/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qfileinfo_wrapper.h"

// inner classes

// Extra includes
#include <QDateTime>
#include <QDir>
#include <qdatetime.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFileInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFileInfo >()))
        return -1;

    ::QFileInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QFileInfo", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QFileInfo::QFileInfo()
    // 1: QFileInfo::QFileInfo(QDir,QString)
    // 2: QFileInfo::QFileInfo(QFile)
    // 3: QFileInfo::QFileInfo(QFileInfo)
    // 4: QFileInfo::QFileInfo(QString)
    if (numArgs == 0) {
        overloadId = 0; // QFileInfo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 4; // QFileInfo(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QFileInfo(QFile)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QFileInfo(QFileInfo)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 1; // QFileInfo(QDir,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QFileInfo()
        {

            if (!PyErr_Occurred()) {
                // QFileInfo()
                cptr = new ::QFileInfo();
            }
            break;
        }
        case 1: // QFileInfo(const QDir & dir, const QString & file)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDir cppArg0_local;
            ::QDir *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QFileInfo(QDir,QString)
                cptr = new ::QFileInfo(*cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QFileInfo(const QFile & file)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFile *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QFileInfo(QFile)
                cptr = new ::QFileInfo(*cppArg0);
            }
            break;
        }
        case 3: // QFileInfo(const QFileInfo & fileinfo)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFileInfo cppArg0_local;
            ::QFileInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QFileInfo(QFileInfo)
                cptr = new ::QFileInfo(*cppArg0);
            }
            break;
        }
        case 4: // QFileInfo(const QString & file)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QFileInfo(QString)
                cptr = new ::QFileInfo(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFileInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QFileInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QFileInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QFileInfoFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(s))", PyObject_Type(self), qPrintable(cppSelf->filePath()));
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_absoluteDir(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.absoluteDir";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // absoluteDir()const
            QDir cppResult = const_cast<const ::QFileInfo *>(cppSelf)->absoluteDir();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_absoluteFilePath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.absoluteFilePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // absoluteFilePath()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->absoluteFilePath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_absolutePath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.absolutePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // absolutePath()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->absolutePath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_baseName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.baseName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // baseName()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->baseName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_birthTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.birthTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // birthTime()const
            QDateTime cppResult = const_cast<const ::QFileInfo *>(cppSelf)->birthTime();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_bundleName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.bundleName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bundleName()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->bundleName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_caching(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.caching";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // caching()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->caching();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_canonicalFilePath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.canonicalFilePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canonicalFilePath()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->canonicalFilePath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_canonicalPath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.canonicalPath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canonicalPath()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->canonicalPath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_completeBaseName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.completeBaseName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // completeBaseName()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->completeBaseName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_completeSuffix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.completeSuffix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // completeSuffix()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->completeSuffix();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_created(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.created";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // created()const
            QDateTime cppResult = const_cast<const ::QFileInfo *>(cppSelf)->created();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_dir(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.dir";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dir()const
            QDir cppResult = const_cast<const ::QFileInfo *>(cppSelf)->dir();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_exists(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QFileInfo *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.exists";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "exists", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QFileInfo::exists()const
    // 1: static QFileInfo::exists(QString)
    if (numArgs == 0) {
        overloadId = 0; // exists()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // exists(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileInfoFunc_exists_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // exists() const
        {

            if (!PyErr_Occurred()) {
                // exists()const
                bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->exists();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // exists(const QString & file)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // exists(QString)
                bool cppResult = ::QFileInfo::exists(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileInfoFunc_exists_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileInfoFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.fileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileName()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->fileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_filePath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.filePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // filePath()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->filePath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_fileTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.fileTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileInfo::fileTime(QFileDevice::FileTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_FILETIME_IDX])->converter, (pyArg)))) {
        overloadId = 0; // fileTime(QFileDevice::FileTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileInfoFunc_fileTime_TypeError;

    // Call function/method
    {
        ::QFileDevice::FileTime cppArg0{QFileDevice::FileAccessTime};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fileTime(QFileDevice::FileTime)const
            QDateTime cppResult = const_cast<const ::QFileInfo *>(cppSelf)->fileTime(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileInfoFunc_fileTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileInfoFunc_group(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.group";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // group()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->group();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_groupId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.groupId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // groupId()const
            uint cppResult = const_cast<const ::QFileInfo *>(cppSelf)->groupId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isAbsolute(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isAbsolute";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAbsolute()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isAbsolute();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isBundle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isBundle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBundle()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isBundle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isDir(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isDir";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDir()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isDir();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isExecutable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isExecutable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isExecutable()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isExecutable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isFile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFile()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isFile();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isHidden(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isHidden";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isHidden()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isHidden();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isJunction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isJunction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isJunction()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isJunction();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isNativePath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isNativePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNativePath()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isNativePath();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isReadable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isReadable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReadable()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isReadable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isRelative(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isRelative";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRelative()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isRelative();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isRoot(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isRoot";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRoot()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isRoot();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isShortcut(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isShortcut";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isShortcut()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isShortcut();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isSymLink(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isSymLink";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSymLink()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isSymLink();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isSymbolicLink(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isSymbolicLink";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSymbolicLink()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isSymbolicLink();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_isWritable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.isWritable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isWritable()const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->isWritable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_lastModified(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.lastModified";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastModified()const
            QDateTime cppResult = const_cast<const ::QFileInfo *>(cppSelf)->lastModified();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_lastRead(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.lastRead";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastRead()const
            QDateTime cppResult = const_cast<const ::QFileInfo *>(cppSelf)->lastRead();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_makeAbsolute(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.makeAbsolute";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // makeAbsolute()
            bool cppResult = cppSelf->makeAbsolute();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_metadataChangeTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.metadataChangeTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // metadataChangeTime()const
            QDateTime cppResult = const_cast<const ::QFileInfo *>(cppSelf)->metadataChangeTime();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_owner(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.owner";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // owner()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->owner();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_ownerId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.ownerId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ownerId()const
            uint cppResult = const_cast<const ::QFileInfo *>(cppSelf)->ownerId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_path(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.path";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // path()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->path();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_permission(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.permission";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileInfo::permission(QFlags<QFileDevice::Permission>)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // permission(QFlags<QFileDevice::Permission>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileInfoFunc_permission_TypeError;

    // Call function/method
    {
        ::QFlags<QFileDevice::Permission> cppArg0 = QFlags<QFileDevice::Permission>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // permission(QFlags<QFileDevice::Permission>)const
            bool cppResult = const_cast<const ::QFileInfo *>(cppSelf)->permission(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileInfoFunc_permission_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileInfoFunc_permissions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.permissions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // permissions()const
            QFlags<QFileDevice::Permission> cppResult = const_cast<const ::QFileInfo *>(cppSelf)->permissions();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_readLink(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.readLink";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readLink()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->readLink();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_refresh(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.refresh";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // refresh()
            cppSelf->refresh();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFileInfoFunc_setCaching(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.setCaching";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileInfo::setCaching(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setCaching(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileInfoFunc_setCaching_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCaching(bool)
            cppSelf->setCaching(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileInfoFunc_setCaching_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileInfoFunc_setFile(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.setFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFile", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFileInfo::setFile(QDir,QString)
    // 1: QFileInfo::setFile(QFile)
    // 2: QFileInfo::setFile(QString)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 2; // setFile(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // setFile(QFile)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // setFile(QDir,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileInfoFunc_setFile_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setFile(const QDir & dir, const QString & file)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QDir cppArg0_local;
            ::QDir *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setFile(QDir,QString)
                cppSelf->setFile(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setFile(const QFile & file)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QFile *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setFile(QFile)
                cppSelf->setFile(*cppArg0);
            }
            break;
        }
        case 2: // setFile(const QString & file)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setFile(QString)
                cppSelf->setFile(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileInfoFunc_setFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileInfoFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            qint64 cppResult = const_cast<const ::QFileInfo *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_suffix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.suffix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // suffix()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->suffix();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfoFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileInfo::swap(QFileInfo&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QFileInfo&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileInfoFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFileInfo cppArg0_local;
        ::QFileInfo *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QFileInfo&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileInfoFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileInfoFunc_symLinkTarget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFileInfo.symLinkTarget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // symLinkTarget()const
            QString cppResult = const_cast<const ::QFileInfo *>(cppSelf)->symLinkTarget();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyMethodDef Sbk_QFileInfoMethod_exists = {
    "exists", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_exists), METH_VARARGS|METH_STATIC
};


static const char *Sbk_QFileInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFileInfo_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc___reduce__), METH_NOARGS},
    {"absoluteDir", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_absoluteDir), METH_NOARGS},
    {"absoluteFilePath", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_absoluteFilePath), METH_NOARGS},
    {"absolutePath", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_absolutePath), METH_NOARGS},
    {"baseName", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_baseName), METH_NOARGS},
    {"birthTime", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_birthTime), METH_NOARGS},
    {"bundleName", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_bundleName), METH_NOARGS},
    {"caching", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_caching), METH_NOARGS},
    {"canonicalFilePath", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_canonicalFilePath), METH_NOARGS},
    {"canonicalPath", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_canonicalPath), METH_NOARGS},
    {"completeBaseName", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_completeBaseName), METH_NOARGS},
    {"completeSuffix", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_completeSuffix), METH_NOARGS},
    {"created", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_created), METH_NOARGS},
    {"dir", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_dir), METH_NOARGS},
    Sbk_QFileInfoMethod_exists,
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_fileName), METH_NOARGS},
    {"filePath", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_filePath), METH_NOARGS},
    {"fileTime", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_fileTime), METH_O},
    {"group", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_group), METH_NOARGS},
    {"groupId", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_groupId), METH_NOARGS},
    {"isAbsolute", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isAbsolute), METH_NOARGS},
    {"isBundle", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isBundle), METH_NOARGS},
    {"isDir", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isDir), METH_NOARGS},
    {"isExecutable", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isExecutable), METH_NOARGS},
    {"isFile", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isFile), METH_NOARGS},
    {"isHidden", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isHidden), METH_NOARGS},
    {"isJunction", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isJunction), METH_NOARGS},
    {"isNativePath", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isNativePath), METH_NOARGS},
    {"isReadable", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isReadable), METH_NOARGS},
    {"isRelative", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isRelative), METH_NOARGS},
    {"isRoot", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isRoot), METH_NOARGS},
    {"isShortcut", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isShortcut), METH_NOARGS},
    {"isSymLink", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isSymLink), METH_NOARGS},
    {"isSymbolicLink", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isSymbolicLink), METH_NOARGS},
    {"isWritable", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_isWritable), METH_NOARGS},
    {"lastModified", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_lastModified), METH_NOARGS},
    {"lastRead", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_lastRead), METH_NOARGS},
    {"makeAbsolute", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_makeAbsolute), METH_NOARGS},
    {"metadataChangeTime", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_metadataChangeTime), METH_NOARGS},
    {"owner", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_owner), METH_NOARGS},
    {"ownerId", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_ownerId), METH_NOARGS},
    {"path", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_path), METH_NOARGS},
    {"permission", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_permission), METH_O},
    {"permissions", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_permissions), METH_NOARGS},
    {"readLink", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_readLink), METH_NOARGS},
    {"refresh", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_refresh), METH_NOARGS},
    {"setCaching", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_setCaching), METH_O},
    {"setFile", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_setFile), METH_VARARGS},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_size), METH_NOARGS},
    {"suffix", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_suffix), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_swap), METH_O},
    {"symLinkTarget", reinterpret_cast<PyCFunction>(Sbk_QFileInfoFunc_symLinkTarget), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QFileInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QFileInfo_getattro(PyObject *self, PyObject *name)
{
    PySide::Feature::Select(self);
    // Search the method in the instance dict
    if (auto ob_dict = reinterpret_cast<SbkObject *>(self)->ob_dict) {
        if (auto meth = PyDict_GetItem(ob_dict, name)) {
            Py_INCREF(meth);
            return meth;
        }
    }
    // Search the method in the type dict
    if (Shiboken::Object::isUserType(self)) {
        Shiboken::AutoDecRef tmp(_Pep_PrivateMangle(self, name));
        if (auto meth = PyDict_GetItem(Py_TYPE(self)->tp_dict, tmp))
            return PyFunction_Check(meth) ? SBK_PyMethod_New(meth, self) : PyObject_GenericGetAttr(self, name);
    }
    static PyMethodDef non_static_Sbk_QFileInfoMethod_exists = {
        Sbk_QFileInfoMethod_exists.ml_name,
        Sbk_QFileInfoMethod_exists.ml_meth,
        Sbk_QFileInfoMethod_exists.ml_flags & (~METH_STATIC),
        Sbk_QFileInfoMethod_exists.ml_doc,
    };
    if (Shiboken::String::compare(name, "exists") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QFileInfoMethod_exists, self, 0);
    return PyObject_GenericGetAttr(self, name);
}

// Rich comparison
static PyObject * Sbk_QFileInfo_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), (pyArg)))) {
                // operator!=(const QFileInfo & fileinfo) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFileInfo cppArg0_local;
                ::QFileInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), (pyArg)))) {
                // operator==(const QFileInfo & fileinfo) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFileInfo cppArg0_local;
                ::QFileInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QFileInfo_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QFileInfo_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QFileInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFileInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QFileInfo__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFileInfo_Type = nullptr;
static SbkObjectType *Sbk_QFileInfo_TypeF(void)
{
    return _Sbk_QFileInfo_Type;
}

static PyType_Slot Sbk_QFileInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QFileInfo__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_QFileInfo_getattro)},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFileInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFileInfo_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QFileInfo_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFileInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFileInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QFileInfo_spec = {
    "2:PySide2.QtCore.QFileInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFileInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFileInfo_PythonToCpp_QFileInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFileInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFileInfo_PythonToCpp_QFileInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFileInfo_TypeF())))
        return QFileInfo_PythonToCpp_QFileInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFileInfo_PTR_CppToPython_QFileInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QFileInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QFileInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QFileInfo_COPY_CppToPython_QFileInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QFileInfo_TypeF(), new ::QFileInfo(*reinterpret_cast<const ::QFileInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QFileInfo_PythonToCpp_QFileInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileInfo *>(cppOut) = *reinterpret_cast< ::QFileInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QFileInfo_PythonToCpp_QFileInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFileInfo_TypeF())))
        return QFileInfo_PythonToCpp_QFileInfo_COPY;
    return {};
}

// Implicit conversions.
static void constQFileREF_PythonToCpp_QFileInfo(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileInfo *>(cppOut) = ::QFileInfo( *reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQFileREF_PythonToCpp_QFileInfo_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], pyIn))
        return constQFileREF_PythonToCpp_QFileInfo;
    return {};
}

static void constQStringREF_PythonToCpp_QFileInfo(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QFileInfo *>(cppOut) = ::QFileInfo(cppIn);
}
static PythonToCppFunc is_constQStringREF_PythonToCpp_QFileInfo_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return constQStringREF_PythonToCpp_QFileInfo;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFileInfo_SignatureStrings[] = {
    "4:PySide2.QtCore.QFileInfo(self)",
    "3:PySide2.QtCore.QFileInfo(self,dir:PySide2.QtCore.QDir,file:QString)",
    "2:PySide2.QtCore.QFileInfo(self,file:PySide2.QtCore.QFile)",
    "1:PySide2.QtCore.QFileInfo(self,fileinfo:PySide2.QtCore.QFileInfo)",
    "0:PySide2.QtCore.QFileInfo(self,file:QString)",
    "PySide2.QtCore.QFileInfo.__reduce__(self)->PyObject",
    "PySide2.QtCore.QFileInfo.absoluteDir(self)->PySide2.QtCore.QDir",
    "PySide2.QtCore.QFileInfo.absoluteFilePath(self)->QString",
    "PySide2.QtCore.QFileInfo.absolutePath(self)->QString",
    "PySide2.QtCore.QFileInfo.baseName(self)->QString",
    "PySide2.QtCore.QFileInfo.birthTime(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QFileInfo.bundleName(self)->QString",
    "PySide2.QtCore.QFileInfo.caching(self)->bool",
    "PySide2.QtCore.QFileInfo.canonicalFilePath(self)->QString",
    "PySide2.QtCore.QFileInfo.canonicalPath(self)->QString",
    "PySide2.QtCore.QFileInfo.completeBaseName(self)->QString",
    "PySide2.QtCore.QFileInfo.completeSuffix(self)->QString",
    "PySide2.QtCore.QFileInfo.created(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QFileInfo.dir(self)->PySide2.QtCore.QDir",
    "1:PySide2.QtCore.QFileInfo.exists(self)->bool",
    "0:PySide2.QtCore.QFileInfo.exists(file:QString)->bool",
    "PySide2.QtCore.QFileInfo.fileName(self)->QString",
    "PySide2.QtCore.QFileInfo.filePath(self)->QString",
    "PySide2.QtCore.QFileInfo.fileTime(self,time:PySide2.QtCore.QFileDevice.FileTime)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QFileInfo.group(self)->QString",
    "PySide2.QtCore.QFileInfo.groupId(self)->uint",
    "PySide2.QtCore.QFileInfo.isAbsolute(self)->bool",
    "PySide2.QtCore.QFileInfo.isBundle(self)->bool",
    "PySide2.QtCore.QFileInfo.isDir(self)->bool",
    "PySide2.QtCore.QFileInfo.isExecutable(self)->bool",
    "PySide2.QtCore.QFileInfo.isFile(self)->bool",
    "PySide2.QtCore.QFileInfo.isHidden(self)->bool",
    "PySide2.QtCore.QFileInfo.isJunction(self)->bool",
    "PySide2.QtCore.QFileInfo.isNativePath(self)->bool",
    "PySide2.QtCore.QFileInfo.isReadable(self)->bool",
    "PySide2.QtCore.QFileInfo.isRelative(self)->bool",
    "PySide2.QtCore.QFileInfo.isRoot(self)->bool",
    "PySide2.QtCore.QFileInfo.isShortcut(self)->bool",
    "PySide2.QtCore.QFileInfo.isSymLink(self)->bool",
    "PySide2.QtCore.QFileInfo.isSymbolicLink(self)->bool",
    "PySide2.QtCore.QFileInfo.isWritable(self)->bool",
    "PySide2.QtCore.QFileInfo.lastModified(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QFileInfo.lastRead(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QFileInfo.makeAbsolute(self)->bool",
    "PySide2.QtCore.QFileInfo.metadataChangeTime(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QFileInfo.owner(self)->QString",
    "PySide2.QtCore.QFileInfo.ownerId(self)->uint",
    "PySide2.QtCore.QFileInfo.path(self)->QString",
    "PySide2.QtCore.QFileInfo.permission(self,permissions:PySide2.QtCore.QFileDevice.Permissions)->bool",
    "PySide2.QtCore.QFileInfo.permissions(self)->PySide2.QtCore.QFileDevice.Permissions",
    "PySide2.QtCore.QFileInfo.readLink(self)->QString",
    "PySide2.QtCore.QFileInfo.refresh(self)",
    "PySide2.QtCore.QFileInfo.setCaching(self,on:bool)",
    "2:PySide2.QtCore.QFileInfo.setFile(self,dir:PySide2.QtCore.QDir,file:QString)",
    "1:PySide2.QtCore.QFileInfo.setFile(self,file:PySide2.QtCore.QFile)",
    "0:PySide2.QtCore.QFileInfo.setFile(self,file:QString)",
    "PySide2.QtCore.QFileInfo.size(self)->qint64",
    "PySide2.QtCore.QFileInfo.suffix(self)->QString",
    "PySide2.QtCore.QFileInfo.swap(self,other:PySide2.QtCore.QFileInfo)",
    "PySide2.QtCore.QFileInfo.symLinkTarget(self)->QString",
    "PySide2.QtCore.QFileInfo.__copy__()",
    nullptr}; // Sentinel

void init_QFileInfo(PyObject *module)
{
    _Sbk_QFileInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFileInfo",
        "QFileInfo",
        &Sbk_QFileInfo_spec,
        &Shiboken::callCppDestructor< ::QFileInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFileInfo_Type);
    InitSignatureStrings(pyType, QFileInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFileInfo_Type), Sbk_QFileInfo_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFileInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFileInfo_TypeF(),
        QFileInfo_PythonToCpp_QFileInfo_PTR,
        is_QFileInfo_PythonToCpp_QFileInfo_PTR_Convertible,
        QFileInfo_PTR_CppToPython_QFileInfo,
        QFileInfo_COPY_CppToPython_QFileInfo);

    Shiboken::Conversions::registerConverterName(converter, "QFileInfo");
    Shiboken::Conversions::registerConverterName(converter, "QFileInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QFileInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFileInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QFileInfo_PythonToCpp_QFileInfo_COPY,
        is_QFileInfo_PythonToCpp_QFileInfo_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQFileREF_PythonToCpp_QFileInfo,
        is_constQFileREF_PythonToCpp_QFileInfo_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQStringREF_PythonToCpp_QFileInfo,
        is_constQStringREF_PythonToCpp_QFileInfo_Convertible);

    qRegisterMetaType< ::QFileInfo >("QFileInfo");
}
