/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qgenericreturnargument_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGenericReturnArgument_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGenericReturnArgument >()))
        return -1;

    ::QGenericReturnArgument *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QGenericReturnArgument.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGenericReturnArgument_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QGenericReturnArgument", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QGenericReturnArgument::QGenericReturnArgument(QGenericReturnArgument)
    // 1: QGenericReturnArgument::QGenericReturnArgument(const char*,void*)
    if (numArgs == 0) {
        overloadId = 1; // QGenericReturnArgument(const char*,void*)
    } else if (numArgs >= 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QGenericReturnArgument(const char*,void*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))) {
            overloadId = 1; // QGenericReturnArgument(const char*,void*)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGenericReturnArgument(QGenericReturnArgument)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGenericReturnArgument_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGenericReturnArgument(const QGenericReturnArgument & QGenericReturnArgument)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGenericReturnArgument_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGenericReturnArgument cppArg0_local;
            ::QGenericReturnArgument *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGenericReturnArgument(QGenericReturnArgument)
                cptr = new ::QGenericReturnArgument(*cppArg0);
            }
            break;
        }
        case 1: // QGenericReturnArgument(const char * aName, void * aData)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_aName = Shiboken::String::createStaticString("aName");
                if (PyDict_Contains(kwds, key_aName)) {
                    value = PyDict_GetItem(kwds, key_aName);
                    if (value && pyArgs[0]) {
                        errInfo = key_aName;
                        Py_INCREF(errInfo);
                        goto Sbk_QGenericReturnArgument_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0]))))
                            goto Sbk_QGenericReturnArgument_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_aName);
                }
                static PyObject *const key_aData = Shiboken::String::createStaticString("aData");
                if (PyDict_Contains(kwds, key_aData)) {
                    value = PyDict_GetItem(kwds, key_aData);
                    if (value && pyArgs[1]) {
                        errInfo = key_aData;
                        Py_INCREF(errInfo);
                        goto Sbk_QGenericReturnArgument_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1]))))
                            goto Sbk_QGenericReturnArgument_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_aData);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGenericReturnArgument_Init_TypeError;
                }
            }
            const char* cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
            void* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QGenericReturnArgument(const char*,void*)
                cptr = new ::QGenericReturnArgument(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGenericReturnArgument >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGenericReturnArgument_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGenericReturnArgument_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGenericReturnArgument___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGenericReturnArgument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGenericReturnArgument_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGenericReturnArgument_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGenericReturnArgument___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QGenericReturnArgument_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGenericReturnArgument_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGenericReturnArgument_Type = nullptr;
static SbkObjectType *Sbk_QGenericReturnArgument_TypeF(void)
{
    return _Sbk_QGenericReturnArgument_Type;
}

static PyType_Slot Sbk_QGenericReturnArgument_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGenericReturnArgument_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGenericReturnArgument_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGenericReturnArgument_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGenericReturnArgument_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGenericReturnArgument_spec = {
    "2:PySide2.QtCore.QGenericReturnArgument",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGenericReturnArgument_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGenericReturnArgument_PythonToCpp_QGenericReturnArgument_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGenericReturnArgument_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGenericReturnArgument_PythonToCpp_QGenericReturnArgument_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGenericReturnArgument_TypeF())))
        return QGenericReturnArgument_PythonToCpp_QGenericReturnArgument_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGenericReturnArgument_PTR_CppToPython_QGenericReturnArgument(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGenericReturnArgument *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGenericReturnArgument_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGenericReturnArgument_COPY_CppToPython_QGenericReturnArgument(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGenericReturnArgument_TypeF(), new ::QGenericReturnArgument(*reinterpret_cast<const ::QGenericReturnArgument *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGenericReturnArgument_PythonToCpp_QGenericReturnArgument_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGenericReturnArgument *>(cppOut) = *reinterpret_cast< ::QGenericReturnArgument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGenericReturnArgument_PythonToCpp_QGenericReturnArgument_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGenericReturnArgument_TypeF())))
        return QGenericReturnArgument_PythonToCpp_QGenericReturnArgument_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGenericReturnArgument_SignatureStrings[] = {
    "1:PySide2.QtCore.QGenericReturnArgument(self,QGenericReturnArgument:PySide2.QtCore.QGenericReturnArgument)",
    "0:PySide2.QtCore.QGenericReturnArgument(self,aName:char*=nullptr,aData:void=nullptr)",
    "PySide2.QtCore.QGenericReturnArgument.__copy__()",
    nullptr}; // Sentinel

void init_QGenericReturnArgument(PyObject *module)
{
    _Sbk_QGenericReturnArgument_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGenericReturnArgument",
        "QGenericReturnArgument",
        &Sbk_QGenericReturnArgument_spec,
        &Shiboken::callCppDestructor< ::QGenericReturnArgument >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGenericReturnArgument_Type);
    InitSignatureStrings(pyType, QGenericReturnArgument_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGenericReturnArgument_Type), Sbk_QGenericReturnArgument_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGenericReturnArgument_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGenericReturnArgument_TypeF(),
        QGenericReturnArgument_PythonToCpp_QGenericReturnArgument_PTR,
        is_QGenericReturnArgument_PythonToCpp_QGenericReturnArgument_PTR_Convertible,
        QGenericReturnArgument_PTR_CppToPython_QGenericReturnArgument,
        QGenericReturnArgument_COPY_CppToPython_QGenericReturnArgument);

    Shiboken::Conversions::registerConverterName(converter, "QGenericReturnArgument");
    Shiboken::Conversions::registerConverterName(converter, "QGenericReturnArgument*");
    Shiboken::Conversions::registerConverterName(converter, "QGenericReturnArgument&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGenericReturnArgument).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGenericReturnArgument_PythonToCpp_QGenericReturnArgument_COPY,
        is_QGenericReturnArgument_PythonToCpp_QGenericReturnArgument_COPY_Convertible);

}
