/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qitemselectionrange_wrapper.h"

// inner classes

// Extra includes
#include <qabstractitemmodel.h>
#include <qitemselectionmodel.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QItemSelectionRange_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QItemSelectionRange >()))
        return -1;

    ::QItemSelectionRange *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QItemSelectionRange", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QItemSelectionRange::QItemSelectionRange()
    // 1: QItemSelectionRange::QItemSelectionRange(QItemSelectionRange)
    // 2: QItemSelectionRange::QItemSelectionRange(QModelIndex)
    // 3: QItemSelectionRange::QItemSelectionRange(QModelIndex,QModelIndex)
    if (numArgs == 0) {
        overloadId = 0; // QItemSelectionRange()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QItemSelectionRange(QModelIndex)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[1])))) {
            overloadId = 3; // QItemSelectionRange(QModelIndex,QModelIndex)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QItemSelectionRange(QItemSelectionRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionRange_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QItemSelectionRange()
        {

            if (!PyErr_Occurred()) {
                // QItemSelectionRange()
                cptr = new ::QItemSelectionRange();
            }
            break;
        }
        case 1: // QItemSelectionRange(const QItemSelectionRange & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QItemSelectionRange cppArg0_local;
            ::QItemSelectionRange *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QItemSelectionRange(QItemSelectionRange)
                cptr = new ::QItemSelectionRange(*cppArg0);
            }
            break;
        }
        case 2: // QItemSelectionRange(const QModelIndex & index)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QModelIndex cppArg0_local;
            ::QModelIndex *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QItemSelectionRange(QModelIndex)
                cptr = new ::QItemSelectionRange(*cppArg0);
            }
            break;
        }
        case 3: // QItemSelectionRange(const QModelIndex & topL, const QModelIndex & bottomR)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QModelIndex cppArg0_local;
            ::QModelIndex *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QModelIndex cppArg1_local;
            ::QModelIndex *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QItemSelectionRange(QModelIndex,QModelIndex)
                cptr = new ::QItemSelectionRange(*cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QItemSelectionRange >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QItemSelectionRange_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QItemSelectionRange_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QItemSelectionRangeFunc_bottom(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.bottom";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bottom()const
            int cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->bottom();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRangeFunc_bottomRight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.bottomRight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bottomRight()const
            const QPersistentModelIndex & cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->bottomRight();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRangeFunc_contains(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.contains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto Sbk_QItemSelectionRangeFunc_contains_TypeError;

    if (!PyArg_UnpackTuple(args, "contains", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QItemSelectionRange::contains(QModelIndex)const
    // 1: QItemSelectionRange::contains(int,int,QModelIndex)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[2])))) {
        overloadId = 1; // contains(int,int,QModelIndex)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))) {
        overloadId = 0; // contains(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionRangeFunc_contains_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // contains(const QModelIndex & index) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QModelIndex cppArg0_local;
            ::QModelIndex *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // contains(QModelIndex)const
                bool cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->contains(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // contains(int row, int column, const QModelIndex & parentIndex) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QModelIndex cppArg2_local;
            ::QModelIndex *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // contains(int,int,QModelIndex)const
                bool cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->contains(cppArg0, cppArg1, *cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionRangeFunc_contains_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionRangeFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            int cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRangeFunc_indexes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.indexes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // indexes()const
            QModelIndexList cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->indexes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QMODELINDEXLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRangeFunc_intersected(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.intersected";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelectionRange::intersected(QItemSelectionRange)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        overloadId = 0; // intersected(QItemSelectionRange)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionRangeFunc_intersected_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // intersected(QItemSelectionRange)const
            QItemSelectionRange cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->intersected(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionRangeFunc_intersected_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionRangeFunc_intersects(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.intersects";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelectionRange::intersects(QItemSelectionRange)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        overloadId = 0; // intersects(QItemSelectionRange)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionRangeFunc_intersects_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // intersects(QItemSelectionRange)const
            bool cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->intersects(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemSelectionRangeFunc_intersects_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionRangeFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRangeFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRangeFunc_left(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.left";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // left()const
            int cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->left();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRangeFunc_model(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.model";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // model()const
            const QAbstractItemModel * cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->model();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRangeFunc_parent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.parent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parent()const
            QModelIndex cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->parent();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRangeFunc_right(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.right";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // right()const
            int cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->right();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRangeFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemSelectionRange::swap(QItemSelectionRange&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QItemSelectionRange&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemSelectionRangeFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelectionRange cppArg0_local;
        ::QItemSelectionRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QItemSelectionRange&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemSelectionRangeFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemSelectionRangeFunc_top(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.top";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // top()const
            int cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->top();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRangeFunc_topLeft(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.topLeft";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // topLeft()const
            const QPersistentModelIndex & cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->topLeft();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRangeFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QItemSelectionRange.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            int cppResult = const_cast<const ::QItemSelectionRange *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemSelectionRange___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QItemSelectionRange_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QItemSelectionRange_methods[] = {
    {"bottom", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_bottom), METH_NOARGS},
    {"bottomRight", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_bottomRight), METH_NOARGS},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_contains), METH_VARARGS},
    {"height", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_height), METH_NOARGS},
    {"indexes", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_indexes), METH_NOARGS},
    {"intersected", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_intersected), METH_O},
    {"intersects", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_intersects), METH_O},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_isEmpty), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_isValid), METH_NOARGS},
    {"left", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_left), METH_NOARGS},
    {"model", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_model), METH_NOARGS},
    {"parent", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_parent), METH_NOARGS},
    {"right", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_right), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_swap), METH_O},
    {"top", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_top), METH_NOARGS},
    {"topLeft", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_topLeft), METH_NOARGS},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRangeFunc_width), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QItemSelectionRange___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QItemSelectionRange_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
                // operator!=(const QItemSelectionRange & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QItemSelectionRange cppArg0_local;
                ::QItemSelectionRange *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
                // operator<(const QItemSelectionRange & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QItemSelectionRange cppArg0_local;
                ::QItemSelectionRange *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QItemSelectionRange_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), (pyArg)))) {
                // operator==(const QItemSelectionRange & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QItemSelectionRange cppArg0_local;
                ::QItemSelectionRange *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QItemSelectionRange_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QItemSelectionRange_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QItemSelectionRange_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QItemSelectionRange_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QItemSelectionRange__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QItemSelectionRange_Type = nullptr;
static SbkObjectType *Sbk_QItemSelectionRange_TypeF(void)
{
    return _Sbk_QItemSelectionRange_Type;
}

static PyType_Slot Sbk_QItemSelectionRange_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QItemSelectionRange__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QItemSelectionRange_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QItemSelectionRange_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QItemSelectionRange_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QItemSelectionRange_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QItemSelectionRange_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QItemSelectionRange_spec = {
    "2:PySide2.QtCore.QItemSelectionRange",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QItemSelectionRange_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QItemSelectionRange_PythonToCpp_QItemSelectionRange_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QItemSelectionRange_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QItemSelectionRange_PythonToCpp_QItemSelectionRange_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QItemSelectionRange_TypeF())))
        return QItemSelectionRange_PythonToCpp_QItemSelectionRange_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QItemSelectionRange_PTR_CppToPython_QItemSelectionRange(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QItemSelectionRange *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QItemSelectionRange_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QItemSelectionRange_COPY_CppToPython_QItemSelectionRange(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QItemSelectionRange_TypeF(), new ::QItemSelectionRange(*reinterpret_cast<const ::QItemSelectionRange *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QItemSelectionRange_PythonToCpp_QItemSelectionRange_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QItemSelectionRange *>(cppOut) = *reinterpret_cast< ::QItemSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QItemSelectionRange_PythonToCpp_QItemSelectionRange_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QItemSelectionRange_TypeF())))
        return QItemSelectionRange_PythonToCpp_QItemSelectionRange_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QItemSelectionRange_SignatureStrings[] = {
    "3:PySide2.QtCore.QItemSelectionRange(self)",
    "2:PySide2.QtCore.QItemSelectionRange(self,other:PySide2.QtCore.QItemSelectionRange)",
    "1:PySide2.QtCore.QItemSelectionRange(self,index:PySide2.QtCore.QModelIndex)",
    "0:PySide2.QtCore.QItemSelectionRange(self,topL:PySide2.QtCore.QModelIndex,bottomR:PySide2.QtCore.QModelIndex)",
    "PySide2.QtCore.QItemSelectionRange.bottom(self)->int",
    "PySide2.QtCore.QItemSelectionRange.bottomRight(self)->PySide2.QtCore.QPersistentModelIndex",
    "1:PySide2.QtCore.QItemSelectionRange.contains(self,index:PySide2.QtCore.QModelIndex)->bool",
    "0:PySide2.QtCore.QItemSelectionRange.contains(self,row:int,column:int,parentIndex:PySide2.QtCore.QModelIndex)->bool",
    "PySide2.QtCore.QItemSelectionRange.height(self)->int",
    "PySide2.QtCore.QItemSelectionRange.indexes(self)->QModelIndexList",
    "PySide2.QtCore.QItemSelectionRange.intersected(self,other:PySide2.QtCore.QItemSelectionRange)->PySide2.QtCore.QItemSelectionRange",
    "PySide2.QtCore.QItemSelectionRange.intersects(self,other:PySide2.QtCore.QItemSelectionRange)->bool",
    "PySide2.QtCore.QItemSelectionRange.isEmpty(self)->bool",
    "PySide2.QtCore.QItemSelectionRange.isValid(self)->bool",
    "PySide2.QtCore.QItemSelectionRange.left(self)->int",
    "PySide2.QtCore.QItemSelectionRange.model(self)->PySide2.QtCore.QAbstractItemModel",
    "PySide2.QtCore.QItemSelectionRange.parent(self)->PySide2.QtCore.QModelIndex",
    "PySide2.QtCore.QItemSelectionRange.right(self)->int",
    "PySide2.QtCore.QItemSelectionRange.swap(self,other:PySide2.QtCore.QItemSelectionRange)",
    "PySide2.QtCore.QItemSelectionRange.top(self)->int",
    "PySide2.QtCore.QItemSelectionRange.topLeft(self)->PySide2.QtCore.QPersistentModelIndex",
    "PySide2.QtCore.QItemSelectionRange.width(self)->int",
    "PySide2.QtCore.QItemSelectionRange.__copy__()",
    nullptr}; // Sentinel

void init_QItemSelectionRange(PyObject *module)
{
    _Sbk_QItemSelectionRange_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QItemSelectionRange",
        "QItemSelectionRange",
        &Sbk_QItemSelectionRange_spec,
        &Shiboken::callCppDestructor< ::QItemSelectionRange >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QItemSelectionRange_Type);
    InitSignatureStrings(pyType, QItemSelectionRange_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QItemSelectionRange_Type), Sbk_QItemSelectionRange_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONRANGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QItemSelectionRange_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QItemSelectionRange_TypeF(),
        QItemSelectionRange_PythonToCpp_QItemSelectionRange_PTR,
        is_QItemSelectionRange_PythonToCpp_QItemSelectionRange_PTR_Convertible,
        QItemSelectionRange_PTR_CppToPython_QItemSelectionRange,
        QItemSelectionRange_COPY_CppToPython_QItemSelectionRange);

    Shiboken::Conversions::registerConverterName(converter, "QItemSelectionRange");
    Shiboken::Conversions::registerConverterName(converter, "QItemSelectionRange*");
    Shiboken::Conversions::registerConverterName(converter, "QItemSelectionRange&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QItemSelectionRange).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QItemSelectionRange_PythonToCpp_QItemSelectionRange_COPY,
        is_QItemSelectionRange_PythonToCpp_QItemSelectionRange_COPY_Convertible);

    qRegisterMetaType< ::QItemSelectionRange >("QItemSelectionRange");
}
