/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qjsonvalue_wrapper.h"

// inner classes

// Extra includes
#include <QJsonArray>
#include <QJsonObject>
#include <QVariant>
#include <qjsonarray.h>
#include <qjsonvalue.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QJsonValue_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QJsonValue >()))
        return -1;

    ::QJsonValue *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJsonValue_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QJsonValue", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QJsonValue::QJsonValue(QJsonValue::Type)
    // 1: QJsonValue::QJsonValue(bool)
    // 2: QJsonValue::QJsonValue(QJsonArray)
    // 3: QJsonValue::QJsonValue(QJsonObject)
    // 4: QJsonValue::QJsonValue(QJsonValue)
    // 5: QJsonValue::QJsonValue(QString)
    // 6: QJsonValue::QJsonValue(const char*)
    // 7: QJsonValue::QJsonValue(double)
    // 8: QJsonValue::QJsonValue(int)
    // 9: QJsonValue::QJsonValue(qint64)
    if (numArgs == 0) {
        overloadId = 0; // QJsonValue(QJsonValue::Type)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QJSONOBJECT_IDX], (pyArgs[0])))) {
        overloadId = 3; // QJsonValue(QJsonObject)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QJsonValue(QJsonArray)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QJsonValue(QJsonValue::Type)
    } else if (numArgs == 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        overloadId = 7; // QJsonValue(double)
    } else if (numArgs == 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        overloadId = 6; // QJsonValue(const char*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 5; // QJsonValue(QString)
    } else if (numArgs == 1
        && PyBool_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 1; // QJsonValue(bool)
    } else if (numArgs == 1
        && PyLong_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        overloadId = 9; // QJsonValue(qint64)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 8; // QJsonValue(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), (pyArgs[0])))) {
        overloadId = 4; // QJsonValue(QJsonValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonValue_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QJsonValue(QJsonValue::Type arg__1)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_arg__1 = Shiboken::String::createStaticString("arg__1");
                if (PyDict_Contains(kwds, key_arg__1)) {
                    value = PyDict_GetItem(kwds, key_arg__1);
                    if (value && pyArgs[0]) {
                        errInfo = key_arg__1;
                        Py_INCREF(errInfo);
                        goto Sbk_QJsonValue_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QJsonValue_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_arg__1);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QJsonValue_Init_TypeError;
                }
            }
            ::QJsonValue::Type cppArg0 = QJsonValue::Type::Null;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJsonValue(QJsonValue::Type)
                cptr = new ::QJsonValue(cppArg0);
            }
            break;
        }
        case 1: // QJsonValue(bool b)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJsonValue_Init_TypeError;
            }
            bool cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJsonValue(bool)
                cptr = new ::QJsonValue(cppArg0);
            }
            break;
        }
        case 2: // QJsonValue(const QJsonArray & a)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJsonValue_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QJsonArray cppArg0_local;
            ::QJsonArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QJsonValue(QJsonArray)
                cptr = new ::QJsonValue(*cppArg0);
            }
            break;
        }
        case 3: // QJsonValue(const QJsonObject & o)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJsonValue_Init_TypeError;
            }
            ::QJsonObject cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJsonValue(QJsonObject)
                cptr = new ::QJsonValue(cppArg0);
            }
            break;
        }
        case 4: // QJsonValue(const QJsonValue & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJsonValue_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QJsonValue cppArg0_local;
            ::QJsonValue *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QJsonValue(QJsonValue)
                cptr = new ::QJsonValue(*cppArg0);
            }
            break;
        }
        case 5: // QJsonValue(const QString & s)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJsonValue_Init_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJsonValue(QString)
                cptr = new ::QJsonValue(cppArg0);
            }
            break;
        }
        case 6: // QJsonValue(const char * s)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJsonValue_Init_TypeError;
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJsonValue(const char*)
                cptr = new ::QJsonValue(cppArg0);
            }
            break;
        }
        case 7: // QJsonValue(double n)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJsonValue_Init_TypeError;
            }
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJsonValue(double)
                cptr = new ::QJsonValue(cppArg0);
            }
            break;
        }
        case 8: // QJsonValue(int n)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJsonValue_Init_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJsonValue(int)
                cptr = new ::QJsonValue(cppArg0);
            }
            break;
        }
        case 9: // QJsonValue(qint64 v)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJsonValue_Init_TypeError;
            }
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJsonValue(qint64)
                cptr = new ::QJsonValue(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QJsonValue >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QJsonValue_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QJsonValue_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QJsonValueFunc_fromVariant(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.fromVariant";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QJsonValue::fromVariant(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // fromVariant(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonValueFunc_fromVariant_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromVariant(QVariant)
            QJsonValue cppResult = ::QJsonValue::fromVariant(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonValueFunc_fromVariant_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonValueFunc_isArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.isArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isArray()const
            bool cppResult = const_cast<const ::QJsonValue *>(cppSelf)->isArray();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonValueFunc_isBool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.isBool";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBool()const
            bool cppResult = const_cast<const ::QJsonValue *>(cppSelf)->isBool();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonValueFunc_isDouble(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.isDouble";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDouble()const
            bool cppResult = const_cast<const ::QJsonValue *>(cppSelf)->isDouble();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonValueFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QJsonValue *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonValueFunc_isObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.isObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isObject()const
            bool cppResult = const_cast<const ::QJsonValue *>(cppSelf)->isObject();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonValueFunc_isString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.isString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isString()const
            bool cppResult = const_cast<const ::QJsonValue *>(cppSelf)->isString();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonValueFunc_isUndefined(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.isUndefined";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUndefined()const
            bool cppResult = const_cast<const ::QJsonValue *>(cppSelf)->isUndefined();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonValueFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJsonValue::swap(QJsonValue&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QJsonValue&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonValueFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QJsonValue cppArg0_local;
        ::QJsonValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QJsonValue&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QJsonValueFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonValueFunc_toArray(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.toArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toArray", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QJsonValue::toArray()const
    // 1: QJsonValue::toArray(QJsonArray)const
    if (numArgs == 0) {
        overloadId = 0; // toArray()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // toArray(QJsonArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonValueFunc_toArray_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toArray() const
        {

            if (!PyErr_Occurred()) {
                // toArray()const
                QJsonArray cppResult = const_cast<const ::QJsonValue *>(cppSelf)->toArray();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // toArray(const QJsonArray & defaultValue) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QJsonArray cppArg0_local;
            ::QJsonArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // toArray(QJsonArray)const
                QJsonArray cppResult = const_cast<const ::QJsonValue *>(cppSelf)->toArray(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonValueFunc_toArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonValueFunc_toBool(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.toBool";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJsonValueFunc_toBool_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toBool", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QJsonValue::toBool(bool)const
    if (numArgs == 0) {
        overloadId = 0; // toBool(bool)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // toBool(bool)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonValueFunc_toBool_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QJsonValueFunc_toBool_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QJsonValueFunc_toBool_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJsonValueFunc_toBool_TypeError;
            }
        }
        bool cppArg0 = false;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toBool(bool)const
            bool cppResult = const_cast<const ::QJsonValue *>(cppSelf)->toBool(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonValueFunc_toBool_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonValueFunc_toDouble(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.toDouble";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJsonValueFunc_toDouble_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toDouble", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QJsonValue::toDouble(double)const
    if (numArgs == 0) {
        overloadId = 0; // toDouble(double)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        overloadId = 0; // toDouble(double)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonValueFunc_toDouble_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QJsonValueFunc_toDouble_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0]))))
                        goto Sbk_QJsonValueFunc_toDouble_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJsonValueFunc_toDouble_TypeError;
            }
        }
        double cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toDouble(double)const
            double cppResult = const_cast<const ::QJsonValue *>(cppSelf)->toDouble(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonValueFunc_toDouble_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonValueFunc_toInt(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.toInt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJsonValueFunc_toInt_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toInt", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QJsonValue::toInt(int)const
    if (numArgs == 0) {
        overloadId = 0; // toInt(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // toInt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonValueFunc_toInt_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QJsonValueFunc_toInt_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QJsonValueFunc_toInt_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJsonValueFunc_toInt_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toInt(int)const
            int cppResult = const_cast<const ::QJsonValue *>(cppSelf)->toInt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonValueFunc_toInt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonValueFunc_toObject(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.toObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toObject", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QJsonValue::toObject()const
    // 1: QJsonValue::toObject(QJsonObject)const
    if (numArgs == 0) {
        overloadId = 0; // toObject()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QJSONOBJECT_IDX], (pyArgs[0])))) {
        overloadId = 1; // toObject(QJsonObject)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonValueFunc_toObject_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toObject() const
        {

            if (!PyErr_Occurred()) {
                // toObject()const
                QJsonObject cppResult = const_cast<const ::QJsonValue *>(cppSelf)->toObject();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QJSONOBJECT_IDX], &cppResult);
            }
            break;
        }
        case 1: // toObject(const QJsonObject & defaultValue) const
        {
            ::QJsonObject cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toObject(QJsonObject)const
                QJsonObject cppResult = const_cast<const ::QJsonValue *>(cppSelf)->toObject(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QJSONOBJECT_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonValueFunc_toObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonValueFunc_toString(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.toString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toString", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QJsonValue::toString()const
    // 1: QJsonValue::toString(QString)const
    if (numArgs == 0) {
        overloadId = 0; // toString()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // toString(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJsonValueFunc_toString_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toString() const
        {

            if (!PyErr_Occurred()) {
                // toString()const
                QString cppResult = const_cast<const ::QJsonValue *>(cppSelf)->toString();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // toString(const QString & defaultValue) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(QString)const
                QString cppResult = const_cast<const ::QJsonValue *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJsonValueFunc_toString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJsonValueFunc_toVariant(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.toVariant";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toVariant()const
            QVariant cppResult = const_cast<const ::QJsonValue *>(cppSelf)->toVariant();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonValueFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QJsonValue.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QJsonValue::Type cppResult = const_cast<const ::QJsonValue *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJsonValue___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QJsonValue_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QJsonValue_methods[] = {
    {"fromVariant", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_fromVariant), METH_O|METH_STATIC},
    {"isArray", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_isArray), METH_NOARGS},
    {"isBool", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_isBool), METH_NOARGS},
    {"isDouble", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_isDouble), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_isNull), METH_NOARGS},
    {"isObject", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_isObject), METH_NOARGS},
    {"isString", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_isString), METH_NOARGS},
    {"isUndefined", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_isUndefined), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_swap), METH_O},
    {"toArray", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_toArray), METH_VARARGS},
    {"toBool", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_toBool), METH_VARARGS|METH_KEYWORDS},
    {"toDouble", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_toDouble), METH_VARARGS|METH_KEYWORDS},
    {"toInt", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_toInt), METH_VARARGS|METH_KEYWORDS},
    {"toObject", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_toObject), METH_VARARGS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_toString), METH_VARARGS},
    {"toVariant", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_toVariant), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QJsonValueFunc_type), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QJsonValue___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QJsonValue___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QJsonValue_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), (pyArg)))) {
                // operator!=(const QJsonValue & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QJsonValue cppArg0_local;
                ::QJsonValue *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), (pyArg)))) {
                // operator==(const QJsonValue & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QJsonValue cppArg0_local;
                ::QJsonValue *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QJsonValue_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QJsonValue_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QJsonValue_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QJsonValue_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QJsonValue__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QJsonValue_Type = nullptr;
static SbkObjectType *Sbk_QJsonValue_TypeF(void)
{
    return _Sbk_QJsonValue_Type;
}

static PyType_Slot Sbk_QJsonValue_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QJsonValue__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QJsonValue_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QJsonValue_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QJsonValue_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QJsonValue_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QJsonValue_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QJsonValue___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QJsonValue___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QJsonValue_spec = {
    "2:PySide2.QtCore.QJsonValue",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QJsonValue_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QJsonValue_Type_PythonToCpp_QJsonValue_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QJsonValue::Type *>(cppOut) =
        static_cast<::QJsonValue::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QJsonValue_Type_PythonToCpp_QJsonValue_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX]))
        return QJsonValue_Type_PythonToCpp_QJsonValue_Type;
    return {};
}
static PyObject *QJsonValue_Type_CppToPython_QJsonValue_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QJsonValue::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QJsonValue_PythonToCpp_QJsonValue_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QJsonValue_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QJsonValue_PythonToCpp_QJsonValue_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QJsonValue_TypeF())))
        return QJsonValue_PythonToCpp_QJsonValue_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QJsonValue_PTR_CppToPython_QJsonValue(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QJsonValue *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QJsonValue_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QJsonValue_COPY_CppToPython_QJsonValue(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QJsonValue_TypeF(), new ::QJsonValue(*reinterpret_cast<const ::QJsonValue *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QJsonValue_PythonToCpp_QJsonValue_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QJsonValue *>(cppOut) = *reinterpret_cast< ::QJsonValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QJsonValue_PythonToCpp_QJsonValue_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QJsonValue_TypeF())))
        return QJsonValue_PythonToCpp_QJsonValue_COPY;
    return {};
}

// Implicit conversions.
static void QJsonValue_Type_PythonToCpp_QJsonValue(PyObject *pyIn, void *cppOut) {
    ::QJsonValue::Type cppIn{QJsonValue::Null};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QJsonValue *>(cppOut) = ::QJsonValue(cppIn);
}
static PythonToCppFunc is_QJsonValue_Type_PythonToCpp_QJsonValue_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX], pyIn))
        return QJsonValue_Type_PythonToCpp_QJsonValue;
    return {};
}

static void bool_PythonToCpp_QJsonValue(PyObject *pyIn, void *cppOut) {
    bool cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyIn, &cppIn);
    *reinterpret_cast<::QJsonValue *>(cppOut) = ::QJsonValue(cppIn);
}
static PythonToCppFunc is_bool_PythonToCpp_QJsonValue_Convertible(PyObject *pyIn) {
    if (PyBool_Check(pyIn))
        return bool_PythonToCpp_QJsonValue;
    return {};
}

static void constQJsonArrayREF_PythonToCpp_QJsonValue(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QJsonValue *>(cppOut) = ::QJsonValue( *reinterpret_cast< ::QJsonArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQJsonArrayREF_PythonToCpp_QJsonValue_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX], pyIn))
        return constQJsonArrayREF_PythonToCpp_QJsonValue;
    return {};
}

static void constQJsonObjectREF_PythonToCpp_QJsonValue(PyObject *pyIn, void *cppOut) {
    ::QJsonObject cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QJSONOBJECT_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QJsonValue *>(cppOut) = ::QJsonValue(cppIn);
}
static PythonToCppFunc is_constQJsonObjectREF_PythonToCpp_QJsonValue_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QJSONOBJECT_IDX], pyIn))
        return constQJsonObjectREF_PythonToCpp_QJsonValue;
    return {};
}

static void constQStringREF_PythonToCpp_QJsonValue(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QJsonValue *>(cppOut) = ::QJsonValue(cppIn);
}
static PythonToCppFunc is_constQStringREF_PythonToCpp_QJsonValue_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return constQStringREF_PythonToCpp_QJsonValue;
    return {};
}

static void constcharPTR_PythonToCpp_QJsonValue(PyObject *pyIn, void *cppOut) {
    const char* cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), pyIn, &cppIn);
    *reinterpret_cast<::QJsonValue *>(cppOut) = ::QJsonValue(cppIn);
}
static PythonToCppFunc is_constcharPTR_PythonToCpp_QJsonValue_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return constcharPTR_PythonToCpp_QJsonValue;
    return {};
}

static void double_PythonToCpp_QJsonValue(PyObject *pyIn, void *cppOut) {
    double cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<double>(), pyIn, &cppIn);
    *reinterpret_cast<::QJsonValue *>(cppOut) = ::QJsonValue(cppIn);
}
static PythonToCppFunc is_double_PythonToCpp_QJsonValue_Convertible(PyObject *pyIn) {
    if (PyFloat_Check(pyIn))
        return double_PythonToCpp_QJsonValue;
    return {};
}

static void int_PythonToCpp_QJsonValue(PyObject *pyIn, void *cppOut) {
    int cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn, &cppIn);
    *reinterpret_cast<::QJsonValue *>(cppOut) = ::QJsonValue(cppIn);
}
static PythonToCppFunc is_int_PythonToCpp_QJsonValue_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return int_PythonToCpp_QJsonValue;
    return {};
}

static void qint64_PythonToCpp_QJsonValue(PyObject *pyIn, void *cppOut) {
    qint64 cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyIn, &cppIn);
    *reinterpret_cast<::QJsonValue *>(cppOut) = ::QJsonValue(cppIn);
}
static PythonToCppFunc is_qint64_PythonToCpp_QJsonValue_Convertible(PyObject *pyIn) {
    if (PyLong_Check(pyIn))
        return qint64_PythonToCpp_QJsonValue;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QJsonValue_SignatureStrings[] = {
    "9:PySide2.QtCore.QJsonValue(self,arg__1:PySide2.QtCore.QJsonValue.Type=Null)",
    "8:PySide2.QtCore.QJsonValue(self,b:bool)",
    "7:PySide2.QtCore.QJsonValue(self,a:PySide2.QtCore.QJsonArray)",
    "6:PySide2.QtCore.QJsonValue(self,o:QJsonObject)",
    "5:PySide2.QtCore.QJsonValue(self,other:PySide2.QtCore.QJsonValue)",
    "4:PySide2.QtCore.QJsonValue(self,s:QString)",
    "3:PySide2.QtCore.QJsonValue(self,s:char*)",
    "2:PySide2.QtCore.QJsonValue(self,n:double)",
    "1:PySide2.QtCore.QJsonValue(self,n:int)",
    "0:PySide2.QtCore.QJsonValue(self,v:qint64)",
    "PySide2.QtCore.QJsonValue.fromVariant(variant:QVariant)->PySide2.QtCore.QJsonValue",
    "PySide2.QtCore.QJsonValue.isArray(self)->bool",
    "PySide2.QtCore.QJsonValue.isBool(self)->bool",
    "PySide2.QtCore.QJsonValue.isDouble(self)->bool",
    "PySide2.QtCore.QJsonValue.isNull(self)->bool",
    "PySide2.QtCore.QJsonValue.isObject(self)->bool",
    "PySide2.QtCore.QJsonValue.isString(self)->bool",
    "PySide2.QtCore.QJsonValue.isUndefined(self)->bool",
    "PySide2.QtCore.QJsonValue.swap(self,other:PySide2.QtCore.QJsonValue)",
    "1:PySide2.QtCore.QJsonValue.toArray(self)->PySide2.QtCore.QJsonArray",
    "0:PySide2.QtCore.QJsonValue.toArray(self,defaultValue:PySide2.QtCore.QJsonArray)->PySide2.QtCore.QJsonArray",
    "PySide2.QtCore.QJsonValue.toBool(self,defaultValue:bool=false)->bool",
    "PySide2.QtCore.QJsonValue.toDouble(self,defaultValue:double=0)->double",
    "PySide2.QtCore.QJsonValue.toInt(self,defaultValue:int=0)->int",
    "1:PySide2.QtCore.QJsonValue.toObject(self)->QJsonObject",
    "0:PySide2.QtCore.QJsonValue.toObject(self,defaultValue:QJsonObject)->QJsonObject",
    "1:PySide2.QtCore.QJsonValue.toString(self)->QString",
    "0:PySide2.QtCore.QJsonValue.toString(self,defaultValue:QString)->QString",
    "PySide2.QtCore.QJsonValue.toVariant(self)->QVariant",
    "PySide2.QtCore.QJsonValue.type(self)->PySide2.QtCore.QJsonValue.Type",
    "PySide2.QtCore.QJsonValue.__copy__()",
    nullptr}; // Sentinel

void init_QJsonValue(PyObject *module)
{
    _Sbk_QJsonValue_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QJsonValue",
        "QJsonValue",
        &Sbk_QJsonValue_spec,
        &Shiboken::callCppDestructor< ::QJsonValue >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QJsonValue_Type);
    InitSignatureStrings(pyType, QJsonValue_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QJsonValue_Type), Sbk_QJsonValue_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QJsonValue_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QJsonValue_TypeF(),
        QJsonValue_PythonToCpp_QJsonValue_PTR,
        is_QJsonValue_PythonToCpp_QJsonValue_PTR_Convertible,
        QJsonValue_PTR_CppToPython_QJsonValue,
        QJsonValue_COPY_CppToPython_QJsonValue);

    Shiboken::Conversions::registerConverterName(converter, "QJsonValue");
    Shiboken::Conversions::registerConverterName(converter, "QJsonValue*");
    Shiboken::Conversions::registerConverterName(converter, "QJsonValue&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QJsonValue).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QJsonValue_PythonToCpp_QJsonValue_COPY,
        is_QJsonValue_PythonToCpp_QJsonValue_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QJsonValue_Type_PythonToCpp_QJsonValue,
        is_QJsonValue_Type_PythonToCpp_QJsonValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        bool_PythonToCpp_QJsonValue,
        is_bool_PythonToCpp_QJsonValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQJsonArrayREF_PythonToCpp_QJsonValue,
        is_constQJsonArrayREF_PythonToCpp_QJsonValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQJsonObjectREF_PythonToCpp_QJsonValue,
        is_constQJsonObjectREF_PythonToCpp_QJsonValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQStringREF_PythonToCpp_QJsonValue,
        is_constQStringREF_PythonToCpp_QJsonValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constcharPTR_PythonToCpp_QJsonValue,
        is_constcharPTR_PythonToCpp_QJsonValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        double_PythonToCpp_QJsonValue,
        is_double_PythonToCpp_QJsonValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        int_PythonToCpp_QJsonValue,
        is_int_PythonToCpp_QJsonValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        qint64_PythonToCpp_QJsonValue,
        is_qint64_PythonToCpp_QJsonValue_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QJsonValue_TypeF(),
        "Type",
        "2:PySide2.QtCore.QJsonValue.Type",
        "QJsonValue::Type");
    if (!SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX],
        Sbk_QJsonValue_TypeF(), "Null", (long) QJsonValue::Type::Null))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX],
        Sbk_QJsonValue_TypeF(), "Bool", (long) QJsonValue::Type::Bool))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX],
        Sbk_QJsonValue_TypeF(), "Double", (long) QJsonValue::Type::Double))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX],
        Sbk_QJsonValue_TypeF(), "String", (long) QJsonValue::Type::String))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX],
        Sbk_QJsonValue_TypeF(), "Array", (long) QJsonValue::Type::Array))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX],
        Sbk_QJsonValue_TypeF(), "Object", (long) QJsonValue::Type::Object))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX],
        Sbk_QJsonValue_TypeF(), "Undefined", (long) QJsonValue::Type::Undefined))
        return;
    // Register converter for enum 'QJsonValue::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX],
            QJsonValue_Type_CppToPython_QJsonValue_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QJsonValue_Type_PythonToCpp_QJsonValue_Type,
            is_QJsonValue_Type_PythonToCpp_QJsonValue_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QJsonValue::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    qRegisterMetaType< ::QJsonValue::Type >("QJsonValue::Type");
}
