/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qlibraryinfo_wrapper.h"

// inner classes

// Extra includes
#include <qdatetime.h>
#include <qversionnumber.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QLibraryInfoFunc_build(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLibraryInfo.build";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // build()
            const char * cppResult = ::QLibraryInfo::build();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qlibraryinfo_build)]
#if defined(IS_PY3K) && defined(Py_LIMITED_API)
            auto suffix = PyUnicode_FromString(" [limited API]");
            auto oldResult = pyResult;
            pyResult = PyUnicode_Concat(pyResult, suffix);
            Py_DECREF(oldResult);
            Py_DECREF(suffix);
#endif
            // END of custom code block [file: ../glue/qtcore.cpp (qlibraryinfo_build)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLibraryInfoFunc_buildDate(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLibraryInfo.buildDate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buildDate()
            QDate cppResult = ::QLibraryInfo::buildDate();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLibraryInfoFunc_isDebugBuild(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLibraryInfo.isDebugBuild";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDebugBuild()
            bool cppResult = ::QLibraryInfo::isDebugBuild();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLibraryInfoFunc_licensedProducts(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLibraryInfo.licensedProducts";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // licensedProducts()
            QString cppResult = ::QLibraryInfo::licensedProducts();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLibraryInfoFunc_licensee(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLibraryInfo.licensee";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // licensee()
            QString cppResult = ::QLibraryInfo::licensee();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLibraryInfoFunc_location(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLibraryInfo.location";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QLibraryInfo::location(QLibraryInfo::LibraryLocation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // location(QLibraryInfo::LibraryLocation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLibraryInfoFunc_location_TypeError;

    // Call function/method
    {
        ::QLibraryInfo::LibraryLocation cppArg0{QLibraryInfo::PrefixPath};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // location(QLibraryInfo::LibraryLocation)
            QString cppResult = ::QLibraryInfo::location(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLibraryInfoFunc_location_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLibraryInfoFunc_platformPluginArguments(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLibraryInfo.platformPluginArguments";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QLibraryInfo::platformPluginArguments(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // platformPluginArguments(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLibraryInfoFunc_platformPluginArguments_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // platformPluginArguments(QString)
            QStringList cppResult = ::QLibraryInfo::platformPluginArguments(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLibraryInfoFunc_platformPluginArguments_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLibraryInfoFunc_version(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLibraryInfo.version";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // version()
            QVersionNumber cppResult = ::QLibraryInfo::version();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QLibraryInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QLibraryInfo_methods[] = {
    {"build", reinterpret_cast<PyCFunction>(Sbk_QLibraryInfoFunc_build), METH_NOARGS|METH_STATIC},
    {"buildDate", reinterpret_cast<PyCFunction>(Sbk_QLibraryInfoFunc_buildDate), METH_NOARGS|METH_STATIC},
    {"isDebugBuild", reinterpret_cast<PyCFunction>(Sbk_QLibraryInfoFunc_isDebugBuild), METH_NOARGS|METH_STATIC},
    {"licensedProducts", reinterpret_cast<PyCFunction>(Sbk_QLibraryInfoFunc_licensedProducts), METH_NOARGS|METH_STATIC},
    {"licensee", reinterpret_cast<PyCFunction>(Sbk_QLibraryInfoFunc_licensee), METH_NOARGS|METH_STATIC},
    {"location", reinterpret_cast<PyCFunction>(Sbk_QLibraryInfoFunc_location), METH_O|METH_STATIC},
    {"platformPluginArguments", reinterpret_cast<PyCFunction>(Sbk_QLibraryInfoFunc_platformPluginArguments), METH_O|METH_STATIC},
    {"version", reinterpret_cast<PyCFunction>(Sbk_QLibraryInfoFunc_version), METH_NOARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QLibraryInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QLibraryInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QLibraryInfo_Type = nullptr;
static SbkObjectType *Sbk_QLibraryInfo_TypeF(void)
{
    return _Sbk_QLibraryInfo_Type;
}

static PyType_Slot Sbk_QLibraryInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QLibraryInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QLibraryInfo_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QLibraryInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QLibraryInfo_spec = {
    "2:PySide2.QtCore.QLibraryInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QLibraryInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QLibraryInfo_LibraryLocation_PythonToCpp_QLibraryInfo_LibraryLocation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLibraryInfo::LibraryLocation *>(cppOut) =
        static_cast<::QLibraryInfo::LibraryLocation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLibraryInfo_LibraryLocation_PythonToCpp_QLibraryInfo_LibraryLocation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX]))
        return QLibraryInfo_LibraryLocation_PythonToCpp_QLibraryInfo_LibraryLocation;
    return {};
}
static PyObject *QLibraryInfo_LibraryLocation_CppToPython_QLibraryInfo_LibraryLocation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLibraryInfo::LibraryLocation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QLibraryInfo_PythonToCpp_QLibraryInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QLibraryInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QLibraryInfo_PythonToCpp_QLibraryInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QLibraryInfo_TypeF())))
        return QLibraryInfo_PythonToCpp_QLibraryInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QLibraryInfo_PTR_CppToPython_QLibraryInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QLibraryInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QLibraryInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QLibraryInfo_SignatureStrings[] = {
    "PySide2.QtCore.QLibraryInfo.build()->char*",
    "PySide2.QtCore.QLibraryInfo.buildDate()->PySide2.QtCore.QDate",
    "PySide2.QtCore.QLibraryInfo.isDebugBuild()->bool",
    "PySide2.QtCore.QLibraryInfo.licensedProducts()->QString",
    "PySide2.QtCore.QLibraryInfo.licensee()->QString",
    "PySide2.QtCore.QLibraryInfo.location(arg__1:PySide2.QtCore.QLibraryInfo.LibraryLocation)->QString",
    "PySide2.QtCore.QLibraryInfo.platformPluginArguments(platformName:QString)->QStringList",
    "PySide2.QtCore.QLibraryInfo.version()->PySide2.QtCore.QVersionNumber",
    nullptr}; // Sentinel

void init_QLibraryInfo(PyObject *module)
{
    _Sbk_QLibraryInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QLibraryInfo",
        "QLibraryInfo*",
        &Sbk_QLibraryInfo_spec,
        &Shiboken::callCppDestructor< ::QLibraryInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QLibraryInfo_Type);
    InitSignatureStrings(pyType, QLibraryInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QLibraryInfo_Type), Sbk_QLibraryInfo_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QLibraryInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QLibraryInfo_TypeF(),
        QLibraryInfo_PythonToCpp_QLibraryInfo_PTR,
        is_QLibraryInfo_PythonToCpp_QLibraryInfo_PTR_Convertible,
        QLibraryInfo_PTR_CppToPython_QLibraryInfo);

    Shiboken::Conversions::registerConverterName(converter, "QLibraryInfo");
    Shiboken::Conversions::registerConverterName(converter, "QLibraryInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QLibraryInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QLibraryInfo).name());


    // Initialization of enums.

    // Initialization of enum 'LibraryLocation'.
    SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLibraryInfo_TypeF(),
        "LibraryLocation",
        "2:PySide2.QtCore.QLibraryInfo.LibraryLocation",
        "QLibraryInfo::LibraryLocation");
    if (!SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "PrefixPath", (long) QLibraryInfo::LibraryLocation::PrefixPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "DocumentationPath", (long) QLibraryInfo::LibraryLocation::DocumentationPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "HeadersPath", (long) QLibraryInfo::LibraryLocation::HeadersPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "LibrariesPath", (long) QLibraryInfo::LibraryLocation::LibrariesPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "LibraryExecutablesPath", (long) QLibraryInfo::LibraryLocation::LibraryExecutablesPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "BinariesPath", (long) QLibraryInfo::LibraryLocation::BinariesPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "PluginsPath", (long) QLibraryInfo::LibraryLocation::PluginsPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "ImportsPath", (long) QLibraryInfo::LibraryLocation::ImportsPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "Qml2ImportsPath", (long) QLibraryInfo::LibraryLocation::Qml2ImportsPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "ArchDataPath", (long) QLibraryInfo::LibraryLocation::ArchDataPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "DataPath", (long) QLibraryInfo::LibraryLocation::DataPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "TranslationsPath", (long) QLibraryInfo::LibraryLocation::TranslationsPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "ExamplesPath", (long) QLibraryInfo::LibraryLocation::ExamplesPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "TestsPath", (long) QLibraryInfo::LibraryLocation::TestsPath))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
        Sbk_QLibraryInfo_TypeF(), "SettingsPath", (long) QLibraryInfo::LibraryLocation::SettingsPath))
        return;
    // Register converter for enum 'QLibraryInfo::LibraryLocation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX],
            QLibraryInfo_LibraryLocation_CppToPython_QLibraryInfo_LibraryLocation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLibraryInfo_LibraryLocation_PythonToCpp_QLibraryInfo_LibraryLocation,
            is_QLibraryInfo_LibraryLocation_PythonToCpp_QLibraryInfo_LibraryLocation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLibraryInfo::LibraryLocation");
        Shiboken::Conversions::registerConverterName(converter, "LibraryLocation");
    }
    // End of 'LibraryLocation' enum.

    qRegisterMetaType< ::QLibraryInfo::LibraryLocation >("QLibraryInfo::LibraryLocation");
}
