/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qlocale_wrapper.h"

// inner classes

// Extra includes
#include <QDate>
#include <QList>
#include <qcalendar.h>
#include <qdatetime.h>
#include <qlocale.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QLocale_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QLocale >()))
        return -1;

    ::QLocale *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocale_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QLocale", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QLocale::QLocale()
    // 1: QLocale::QLocale(QLocale::Language,QLocale::Country)
    // 2: QLocale::QLocale(QLocale::Language,QLocale::Script,QLocale::Country)
    // 3: QLocale::QLocale(QLocale)
    // 4: QLocale::QLocale(QString)
    if (numArgs == 0) {
        overloadId = 0; // QLocale()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 4; // QLocale(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QLocale(QLocale::Language,QLocale::Country)
        } else if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX])->converter, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, (pyArgs[2])))) {
            overloadId = 2; // QLocale(QLocale::Language,QLocale::Script,QLocale::Country)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // QLocale(QLocale::Language,QLocale::Country)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QLocale(QLocale)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocale_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QLocale()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocale_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QLocale()
                cptr = new ::QLocale();
            }
            break;
        }
        case 1: // QLocale(QLocale::Language language, QLocale::Country country)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_country = Shiboken::String::createStaticString("country");
                if (PyDict_Contains(kwds, key_country)) {
                    value = PyDict_GetItem(kwds, key_country);
                    if (value && pyArgs[1]) {
                        errInfo = key_country;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocale_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QLocale_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_country);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocale_Init_TypeError;
                }
            }
            ::QLocale::Language cppArg0{QLocale::AnyLanguage};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QLocale::Country cppArg1 = QLocale::Country::AnyCountry;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QLocale(QLocale::Language,QLocale::Country)
                cptr = new ::QLocale(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QLocale(QLocale::Language language, QLocale::Script script, QLocale::Country country)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocale_Init_TypeError;
            }
            ::QLocale::Language cppArg0{QLocale::AnyLanguage};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QLocale::Script cppArg1{QLocale::AnyScript};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QLocale::Country cppArg2{QLocale::AnyCountry};
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QLocale(QLocale::Language,QLocale::Script,QLocale::Country)
                cptr = new ::QLocale(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 3: // QLocale(const QLocale & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocale_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QLocale cppArg0_local;
            ::QLocale *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QLocale(QLocale)
                cptr = new ::QLocale(*cppArg0);
            }
            break;
        }
        case 4: // QLocale(const QString & name)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocale_Init_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QLocale(QString)
                cptr = new ::QLocale(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QLocale >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QLocale_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QLocale_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QLocaleFunc_amText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.amText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // amText()const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->amText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_bcp47Name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.bcp47Name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bcp47Name()const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->bcp47Name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_c(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.c";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // c()
            QLocale cppResult = ::QLocale::c();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_collation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.collation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // collation()const
            QLocale cppResult = const_cast<const ::QLocale *>(cppSelf)->collation();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_countriesForLanguage(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.countriesForLanguage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QLocale::countriesForLanguage(QLocale::Language)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // countriesForLanguage(QLocale::Language)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_countriesForLanguage_TypeError;

    // Call function/method
    {
        ::QLocale::Language cppArg0{QLocale::AnyLanguage};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // countriesForLanguage(QLocale::Language)
            QList<QLocale::Country > cppResult = ::QLocale::countriesForLanguage(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QLOCALE_COUNTRY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_countriesForLanguage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_country(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.country";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // country()const
            QLocale::Country cppResult = const_cast<const ::QLocale *>(cppSelf)->country();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_countryToString(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.countryToString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QLocale::countryToString(QLocale::Country)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // countryToString(QLocale::Country)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_countryToString_TypeError;

    // Call function/method
    {
        ::QLocale::Country cppArg0{QLocale::AnyCountry};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // countryToString(QLocale::Country)
            QString cppResult = ::QLocale::countryToString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_countryToString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_createSeparatedList(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.createSeparatedList";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::createSeparatedList(QStringList)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // createSeparatedList(QStringList)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_createSeparatedList_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // createSeparatedList(QStringList)const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->createSeparatedList(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_createSeparatedList_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_currencySymbol(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.currencySymbol";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_currencySymbol_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:currencySymbol", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::currencySymbol(QLocale::CurrencySymbolFormat)const
    if (numArgs == 0) {
        overloadId = 0; // currencySymbol(QLocale::CurrencySymbolFormat)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_CURRENCYSYMBOLFORMAT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // currencySymbol(QLocale::CurrencySymbolFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_currencySymbol_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_arg__1 = Shiboken::String::createStaticString("arg__1");
            if (PyDict_Contains(kwds, key_arg__1)) {
                value = PyDict_GetItem(kwds, key_arg__1);
                if (value && pyArgs[0]) {
                    errInfo = key_arg__1;
                    Py_INCREF(errInfo);
                    goto Sbk_QLocaleFunc_currencySymbol_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_CURRENCYSYMBOLFORMAT_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QLocaleFunc_currencySymbol_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_arg__1);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QLocaleFunc_currencySymbol_TypeError;
            }
        }
        ::QLocale::CurrencySymbolFormat cppArg0 = QLocale::CurrencySymbolFormat::CurrencySymbol;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // currencySymbol(QLocale::CurrencySymbolFormat)const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->currencySymbol(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_currencySymbol_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_dateFormat(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.dateFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_dateFormat_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:dateFormat", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::dateFormat(QLocale::FormatType)const
    if (numArgs == 0) {
        overloadId = 0; // dateFormat(QLocale::FormatType)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // dateFormat(QLocale::FormatType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_dateFormat_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[0]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QLocaleFunc_dateFormat_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QLocaleFunc_dateFormat_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QLocaleFunc_dateFormat_TypeError;
            }
        }
        ::QLocale::FormatType cppArg0 = QLocale::FormatType::LongFormat;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // dateFormat(QLocale::FormatType)const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->dateFormat(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_dateFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_dateTimeFormat(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.dateTimeFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_dateTimeFormat_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:dateTimeFormat", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::dateTimeFormat(QLocale::FormatType)const
    if (numArgs == 0) {
        overloadId = 0; // dateTimeFormat(QLocale::FormatType)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // dateTimeFormat(QLocale::FormatType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_dateTimeFormat_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[0]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QLocaleFunc_dateTimeFormat_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QLocaleFunc_dateTimeFormat_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QLocaleFunc_dateTimeFormat_TypeError;
            }
        }
        ::QLocale::FormatType cppArg0 = QLocale::FormatType::LongFormat;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // dateTimeFormat(QLocale::FormatType)const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->dateTimeFormat(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_dateTimeFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_dayName(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.dayName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_dayName_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_dayName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:dayName", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::dayName(int,QLocale::FormatType)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // dayName(int,QLocale::FormatType)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // dayName(int,QLocale::FormatType)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_dayName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[1]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QLocaleFunc_dayName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QLocaleFunc_dayName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QLocaleFunc_dayName_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QLocale::FormatType cppArg1 = QLocale::FormatType::LongFormat;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // dayName(int,QLocale::FormatType)const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->dayName(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_dayName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_decimalPoint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.decimalPoint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // decimalPoint()const
            QChar cppResult = const_cast<const ::QLocale *>(cppSelf)->decimalPoint();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_exponential(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.exponential";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // exponential()const
            QChar cppResult = const_cast<const ::QLocale *>(cppSelf)->exponential();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_firstDayOfWeek(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.firstDayOfWeek";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // firstDayOfWeek()const
            Qt::DayOfWeek cppResult = const_cast<const ::QLocale *>(cppSelf)->firstDayOfWeek();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_formattedDataSize(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.formattedDataSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_formattedDataSize_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_formattedDataSize_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:formattedDataSize", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::formattedDataSize(qint64,int,QFlags<QLocale::DataSizeFormat>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // formattedDataSize(qint64,int,QFlags<QLocale::DataSizeFormat>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // formattedDataSize(qint64,int,QFlags<QLocale::DataSizeFormat>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // formattedDataSize(qint64,int,QFlags<QLocale::DataSizeFormat>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_formattedDataSize_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_precision = Shiboken::String::createStaticString("precision");
            if (PyDict_Contains(kwds, key_precision)) {
                value = PyDict_GetItem(kwds, key_precision);
                if (value && pyArgs[1]) {
                    errInfo = key_precision;
                    Py_INCREF(errInfo);
                    goto Sbk_QLocaleFunc_formattedDataSize_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QLocaleFunc_formattedDataSize_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_precision);
            }
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[2]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QLocaleFunc_formattedDataSize_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QLocaleFunc_formattedDataSize_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QLocaleFunc_formattedDataSize_TypeError;
            }
        }
        qint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 2;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<QLocale::DataSizeFormat> cppArg2 = QLocale::DataSizeIecFormat;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // formattedDataSize(qint64,int,QFlags<QLocale::DataSizeFormat>)
            QString cppResult = cppSelf->formattedDataSize(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_formattedDataSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_groupSeparator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.groupSeparator";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // groupSeparator()const
            QChar cppResult = const_cast<const ::QLocale *>(cppSelf)->groupSeparator();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_language(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.language";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // language()const
            QLocale::Language cppResult = const_cast<const ::QLocale *>(cppSelf)->language();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_languageToString(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.languageToString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QLocale::languageToString(QLocale::Language)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // languageToString(QLocale::Language)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_languageToString_TypeError;

    // Call function/method
    {
        ::QLocale::Language cppArg0{QLocale::AnyLanguage};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // languageToString(QLocale::Language)
            QString cppResult = ::QLocale::languageToString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_languageToString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_matchingLocales(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.matchingLocales";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "matchingLocales", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QLocale::matchingLocales(QLocale::Language,QLocale::Script,QLocale::Country)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, (pyArgs[2])))) {
        overloadId = 0; // matchingLocales(QLocale::Language,QLocale::Script,QLocale::Country)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_matchingLocales_TypeError;

    // Call function/method
    {
        ::QLocale::Language cppArg0{QLocale::AnyLanguage};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QLocale::Script cppArg1{QLocale::AnyScript};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QLocale::Country cppArg2{QLocale::AnyCountry};
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // matchingLocales(QLocale::Language,QLocale::Script,QLocale::Country)
            QList<QLocale > cppResult = ::QLocale::matchingLocales(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QLOCALE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_matchingLocales_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_measurementSystem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.measurementSystem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // measurementSystem()const
            QLocale::MeasurementSystem cppResult = const_cast<const ::QLocale *>(cppSelf)->measurementSystem();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_monthName(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.monthName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_monthName_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_monthName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:monthName", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::monthName(int,QLocale::FormatType)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // monthName(int,QLocale::FormatType)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // monthName(int,QLocale::FormatType)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_monthName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[1]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QLocaleFunc_monthName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QLocaleFunc_monthName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QLocaleFunc_monthName_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QLocale::FormatType cppArg1 = QLocale::FormatType::LongFormat;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // monthName(int,QLocale::FormatType)const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->monthName(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_monthName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_nativeCountryName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.nativeCountryName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeCountryName()const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->nativeCountryName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_nativeLanguageName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.nativeLanguageName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeLanguageName()const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->nativeLanguageName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_negativeSign(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.negativeSign";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // negativeSign()const
            QChar cppResult = const_cast<const ::QLocale *>(cppSelf)->negativeSign();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_numberOptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.numberOptions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // numberOptions()const
            QFlags<QLocale::NumberOption> cppResult = const_cast<const ::QLocale *>(cppSelf)->numberOptions();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_percent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.percent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // percent()const
            QChar cppResult = const_cast<const ::QLocale *>(cppSelf)->percent();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_pmText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.pmText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pmText()const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->pmText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_positiveSign(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.positiveSign";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // positiveSign()const
            QChar cppResult = const_cast<const ::QLocale *>(cppSelf)->positiveSign();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_quoteString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.quoteString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_quoteString_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_quoteString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:quoteString", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::quoteString(QString,QLocale::QuotationStyle)const
    // 1: QLocale::quoteString(QStringRef,QLocale::QuotationStyle)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // quoteString(QStringRef,QLocale::QuotationStyle)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_QUOTATIONSTYLE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // quoteString(QStringRef,QLocale::QuotationStyle)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // quoteString(QString,QLocale::QuotationStyle)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_QUOTATIONSTYLE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // quoteString(QString,QLocale::QuotationStyle)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_quoteString_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // quoteString(const QString & str, QLocale::QuotationStyle style) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_style = Shiboken::String::createStaticString("style");
                if (PyDict_Contains(kwds, key_style)) {
                    value = PyDict_GetItem(kwds, key_style);
                    if (value && pyArgs[1]) {
                        errInfo = key_style;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_quoteString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_QUOTATIONSTYLE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_quoteString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_style);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_quoteString_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QLocale::QuotationStyle cppArg1 = QLocale::QuotationStyle::StandardQuotation;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // quoteString(QString,QLocale::QuotationStyle)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->quoteString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // quoteString(const QStringRef & str, QLocale::QuotationStyle style) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_style = Shiboken::String::createStaticString("style");
                if (PyDict_Contains(kwds, key_style)) {
                    value = PyDict_GetItem(kwds, key_style);
                    if (value && pyArgs[1]) {
                        errInfo = key_style;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_quoteString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_QUOTATIONSTYLE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_quoteString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_style);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_quoteString_TypeError;
                }
            }
            ::QStringRef cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QLocale::QuotationStyle cppArg1 = QLocale::QuotationStyle::StandardQuotation;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // quoteString(QStringRef,QLocale::QuotationStyle)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->quoteString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_quoteString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_script(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.script";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // script()const
            QLocale::Script cppResult = const_cast<const ::QLocale *>(cppSelf)->script();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_scriptToString(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.scriptToString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QLocale::scriptToString(QLocale::Script)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // scriptToString(QLocale::Script)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_scriptToString_TypeError;

    // Call function/method
    {
        ::QLocale::Script cppArg0{QLocale::AnyScript};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // scriptToString(QLocale::Script)
            QString cppResult = ::QLocale::scriptToString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_scriptToString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_setDefault(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.setDefault";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QLocale::setDefault(QLocale)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArg)))) {
        overloadId = 0; // setDefault(QLocale)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_setDefault_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDefault(QLocale)
            ::QLocale::setDefault(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLocaleFunc_setDefault_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_setNumberOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.setNumberOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::setNumberOptions(QFlags<QLocale::NumberOption>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setNumberOptions(QFlags<QLocale::NumberOption>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_setNumberOptions_TypeError;

    // Call function/method
    {
        ::QFlags<QLocale::NumberOption> cppArg0 = QFlags<QLocale::NumberOption>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNumberOptions(QFlags<QLocale::NumberOption>)
            cppSelf->setNumberOptions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLocaleFunc_setNumberOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_standaloneDayName(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.standaloneDayName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_standaloneDayName_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_standaloneDayName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:standaloneDayName", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::standaloneDayName(int,QLocale::FormatType)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // standaloneDayName(int,QLocale::FormatType)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // standaloneDayName(int,QLocale::FormatType)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_standaloneDayName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[1]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QLocaleFunc_standaloneDayName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QLocaleFunc_standaloneDayName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QLocaleFunc_standaloneDayName_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QLocale::FormatType cppArg1 = QLocale::FormatType::LongFormat;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // standaloneDayName(int,QLocale::FormatType)const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->standaloneDayName(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_standaloneDayName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_standaloneMonthName(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.standaloneMonthName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_standaloneMonthName_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_standaloneMonthName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:standaloneMonthName", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::standaloneMonthName(int,QLocale::FormatType)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // standaloneMonthName(int,QLocale::FormatType)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // standaloneMonthName(int,QLocale::FormatType)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_standaloneMonthName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[1]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QLocaleFunc_standaloneMonthName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QLocaleFunc_standaloneMonthName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QLocaleFunc_standaloneMonthName_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QLocale::FormatType cppArg1 = QLocale::FormatType::LongFormat;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // standaloneMonthName(int,QLocale::FormatType)const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->standaloneMonthName(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_standaloneMonthName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::swap(QLocale&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QLocale&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QLocale&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLocaleFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_system(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.system";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // system()
            QLocale cppResult = ::QLocale::system();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_textDirection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.textDirection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textDirection()const
            Qt::LayoutDirection cppResult = const_cast<const ::QLocale *>(cppSelf)->textDirection();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_timeFormat(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.timeFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_timeFormat_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:timeFormat", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::timeFormat(QLocale::FormatType)const
    if (numArgs == 0) {
        overloadId = 0; // timeFormat(QLocale::FormatType)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // timeFormat(QLocale::FormatType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_timeFormat_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[0]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QLocaleFunc_timeFormat_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QLocaleFunc_timeFormat_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QLocaleFunc_timeFormat_TypeError;
            }
        }
        ::QLocale::FormatType cppArg0 = QLocale::FormatType::LongFormat;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // timeFormat(QLocale::FormatType)const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->timeFormat(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_timeFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toCurrencyString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toCurrencyString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:toCurrencyString", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::toCurrencyString(double,QString)const
    // 1: QLocale::toCurrencyString(double,QString,int)const
    // 2: QLocale::toCurrencyString(float,QString)const
    // 3: QLocale::toCurrencyString(float,QString,int)const
    // 4: QLocale::toCurrencyString(int,QString)const
    // 5: QLocale::toCurrencyString(qlonglong,QString)const
    // 6: QLocale::toCurrencyString(qulonglong,QString)const
    // 7: QLocale::toCurrencyString(short,QString)const
    // 8: QLocale::toCurrencyString(uint,QString)const
    // 9: QLocale::toCurrencyString(ushort,QString)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 9; // toCurrencyString(ushort,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 9; // toCurrencyString(ushort,QString)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 8; // toCurrencyString(uint,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 8; // toCurrencyString(uint,QString)const
        }
    } else if (numArgs >= 1
        && PyLong_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 6; // toCurrencyString(qulonglong,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 6; // toCurrencyString(qulonglong,QString)const
        }
    } else if (numArgs >= 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // toCurrencyString(float,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // toCurrencyString(float,QString)const
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 3; // toCurrencyString(float,QString,int)const
            }
        }
    } else if (numArgs >= 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toCurrencyString(double,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // toCurrencyString(double,QString)const
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 1; // toCurrencyString(double,QString,int)const
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 7; // toCurrencyString(short,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 7; // toCurrencyString(short,QString)const
        }
    } else if (numArgs >= 1
        && PyLong_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qlonglong>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 5; // toCurrencyString(qlonglong,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 5; // toCurrencyString(qlonglong,QString)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 4; // toCurrencyString(int,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 4; // toCurrencyString(int,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toCurrencyString_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toCurrencyString(double arg__1, const QString & symbol) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_symbol = Shiboken::String::createStaticString("symbol");
                if (PyDict_Contains(kwds, key_symbol)) {
                    value = PyDict_GetItem(kwds, key_symbol);
                    if (value && pyArgs[1]) {
                        errInfo = key_symbol;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_symbol);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                }
            }
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toCurrencyString(double,QString)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toCurrencyString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // toCurrencyString(double arg__1, const QString & symbol, int precision) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
            }
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toCurrencyString(double,QString,int)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toCurrencyString(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 2: // toCurrencyString(float i, const QString & symbol) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_symbol = Shiboken::String::createStaticString("symbol");
                if (PyDict_Contains(kwds, key_symbol)) {
                    value = PyDict_GetItem(kwds, key_symbol);
                    if (value && pyArgs[1]) {
                        errInfo = key_symbol;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_symbol);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                }
            }
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toCurrencyString(float,QString)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toCurrencyString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 3: // toCurrencyString(float i, const QString & symbol, int precision) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
            }
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toCurrencyString(float,QString,int)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toCurrencyString(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 4: // toCurrencyString(int arg__1, const QString & symbol) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_symbol = Shiboken::String::createStaticString("symbol");
                if (PyDict_Contains(kwds, key_symbol)) {
                    value = PyDict_GetItem(kwds, key_symbol);
                    if (value && pyArgs[1]) {
                        errInfo = key_symbol;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_symbol);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toCurrencyString(int,QString)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toCurrencyString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 5: // toCurrencyString(qlonglong arg__1, const QString & symbol) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_symbol = Shiboken::String::createStaticString("symbol");
                if (PyDict_Contains(kwds, key_symbol)) {
                    value = PyDict_GetItem(kwds, key_symbol);
                    if (value && pyArgs[1]) {
                        errInfo = key_symbol;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_symbol);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                }
            }
            qlonglong cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toCurrencyString(qlonglong,QString)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toCurrencyString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 6: // toCurrencyString(qulonglong arg__1, const QString & symbol) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_symbol = Shiboken::String::createStaticString("symbol");
                if (PyDict_Contains(kwds, key_symbol)) {
                    value = PyDict_GetItem(kwds, key_symbol);
                    if (value && pyArgs[1]) {
                        errInfo = key_symbol;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_symbol);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                }
            }
            qulonglong cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toCurrencyString(qulonglong,QString)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toCurrencyString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 7: // toCurrencyString(short arg__1, const QString & symbol) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_symbol = Shiboken::String::createStaticString("symbol");
                if (PyDict_Contains(kwds, key_symbol)) {
                    value = PyDict_GetItem(kwds, key_symbol);
                    if (value && pyArgs[1]) {
                        errInfo = key_symbol;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_symbol);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                }
            }
            short cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toCurrencyString(short,QString)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toCurrencyString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 8: // toCurrencyString(uint arg__1, const QString & symbol) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_symbol = Shiboken::String::createStaticString("symbol");
                if (PyDict_Contains(kwds, key_symbol)) {
                    value = PyDict_GetItem(kwds, key_symbol);
                    if (value && pyArgs[1]) {
                        errInfo = key_symbol;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_symbol);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                }
            }
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toCurrencyString(uint,QString)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toCurrencyString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 9: // toCurrencyString(ushort arg__1, const QString & symbol) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_symbol = Shiboken::String::createStaticString("symbol");
                if (PyDict_Contains(kwds, key_symbol)) {
                    value = PyDict_GetItem(kwds, key_symbol);
                    if (value && pyArgs[1]) {
                        errInfo = key_symbol;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_symbol);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toCurrencyString_TypeError;
                }
            }
            ushort cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toCurrencyString(ushort,QString)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toCurrencyString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toCurrencyString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toDate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toDate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toDate_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toDate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:toDate", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::toDate(QString,QLocale::FormatType)const
    // 1: QLocale::toDate(QString,QLocale::FormatType,QCalendar)const
    // 2: QLocale::toDate(QString,QString)const
    // 3: QLocale::toDate(QString,QString,QCalendar)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toDate(QString,QLocale::FormatType)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // toDate(QString,QString)const
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[2])))) {
                overloadId = 3; // toDate(QString,QString,QCalendar)const
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // toDate(QString,QLocale::FormatType)const
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[2])))) {
                overloadId = 1; // toDate(QString,QLocale::FormatType,QCalendar)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toDate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toDate(const QString & string, QLocale::FormatType format) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toDate_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toDate_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toDate_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QLocale::FormatType cppArg1 = QLocale::FormatType::LongFormat;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toDate(QString,QLocale::FormatType)const
                QDate cppResult = const_cast<const ::QLocale *>(cppSelf)->toDate(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // toDate(const QString & string, QLocale::FormatType format, QCalendar cal) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toDate_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QLocale::FormatType cppArg1{QLocale::LongFormat};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QCalendar cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toDate(QString,QLocale::FormatType,QCalendar)const
                QDate cppResult = const_cast<const ::QLocale *>(cppSelf)->toDate(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
        case 2: // toDate(const QString & string, const QString & format) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toDate_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toDate(QString,QString)const
                QDate cppResult = const_cast<const ::QLocale *>(cppSelf)->toDate(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
        case 3: // toDate(const QString & string, const QString & format, QCalendar cal) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toDate_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QCalendar cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toDate(QString,QString,QCalendar)const
                QDate cppResult = const_cast<const ::QLocale *>(cppSelf)->toDate(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toDate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toDateTime(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toDateTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toDateTime_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toDateTime_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:toDateTime", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::toDateTime(QString,QLocale::FormatType)const
    // 1: QLocale::toDateTime(QString,QLocale::FormatType,QCalendar)const
    // 2: QLocale::toDateTime(QString,QString)const
    // 3: QLocale::toDateTime(QString,QString,QCalendar)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toDateTime(QString,QLocale::FormatType)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // toDateTime(QString,QString)const
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[2])))) {
                overloadId = 3; // toDateTime(QString,QString,QCalendar)const
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // toDateTime(QString,QLocale::FormatType)const
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[2])))) {
                overloadId = 1; // toDateTime(QString,QLocale::FormatType,QCalendar)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toDateTime_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toDateTime(const QString & string, QLocale::FormatType format) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toDateTime_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toDateTime_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toDateTime_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QLocale::FormatType cppArg1 = QLocale::FormatType::LongFormat;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toDateTime(QString,QLocale::FormatType)const
                QDateTime cppResult = const_cast<const ::QLocale *>(cppSelf)->toDateTime(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
        case 1: // toDateTime(const QString & string, QLocale::FormatType format, QCalendar cal) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toDateTime_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QLocale::FormatType cppArg1{QLocale::LongFormat};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QCalendar cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toDateTime(QString,QLocale::FormatType,QCalendar)const
                QDateTime cppResult = const_cast<const ::QLocale *>(cppSelf)->toDateTime(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
        case 2: // toDateTime(const QString & string, const QString & format) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toDateTime_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toDateTime(QString,QString)const
                QDateTime cppResult = const_cast<const ::QLocale *>(cppSelf)->toDateTime(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
        case 3: // toDateTime(const QString & string, const QString & format, QCalendar cal) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toDateTime_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QCalendar cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toDateTime(QString,QString,QCalendar)const
                QDateTime cppResult = const_cast<const ::QLocale *>(cppSelf)->toDateTime(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toDateTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toDouble(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toDouble";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::toDouble(QString,bool*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toDouble(QString,bool*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toDouble_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toDouble(QString,bool*)const
            // Begin code injection
            // TEMPLATE - fix_args,bool* - START
            bool ok_;
            double retval_ = cppSelf->toDouble(cppArg0, &ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_args,bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toDouble_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toFloat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toFloat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::toFloat(QString,bool*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toFloat(QString,bool*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toFloat_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toFloat(QString,bool*)const
            // Begin code injection
            // TEMPLATE - fix_args,bool* - START
            bool ok_;
            float retval_ = cppSelf->toFloat(cppArg0, &ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_args,bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toFloat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toInt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toInt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::toInt(QString,bool*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toInt(QString,bool*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toInt_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        bool* removed_cppArg1 = nullptr;
        SBK_UNUSED(removed_cppArg1)

        if (!PyErr_Occurred()) {
            // toInt(QString,bool*)const
            // Begin code injection
            // TEMPLATE - fix_args,bool* - START
            bool ok_;
            int retval_ = cppSelf->toInt(cppArg0, &ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_args,bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toInt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toLong(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toLong";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toLong_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toLong_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:toLong", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::toLong(QString,bool*)const
    // 1: QLocale::toLong(QStringRef,bool*)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // toLong(QStringRef,bool*)const
        } else if (numArgs >= 2
            && PyBool_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 1; // toLong(QStringRef,bool*)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toLong(QString,bool*)const
        } else if (numArgs >= 2
            && PyBool_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // toLong(QString,bool*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toLong_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toLong(const QString & s, bool * ok) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_ok = Shiboken::String::createStaticString("ok");
                if (PyDict_Contains(kwds, key_ok)) {
                    value = PyDict_GetItem(kwds, key_ok);
                    if (value && pyArgs[1]) {
                        errInfo = key_ok;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toLong_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toLong_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_ok);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toLong_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toLong(QString,bool*)const
                long cppResult = const_cast<const ::QLocale *>(cppSelf)->toLong(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<long>(), &cppResult);
            }
            break;
        }
        case 1: // toLong(const QStringRef & s, bool * ok) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_ok = Shiboken::String::createStaticString("ok");
                if (PyDict_Contains(kwds, key_ok)) {
                    value = PyDict_GetItem(kwds, key_ok);
                    if (value && pyArgs[1]) {
                        errInfo = key_ok;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toLong_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toLong_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_ok);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toLong_TypeError;
                }
            }
            ::QStringRef cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toLong(QStringRef,bool*)const
                long cppResult = const_cast<const ::QLocale *>(cppSelf)->toLong(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<long>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toLong_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toLongLong(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toLongLong";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::toLongLong(QString,bool*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toLongLong(QString,bool*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toLongLong_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        bool* removed_cppArg1 = nullptr;
        SBK_UNUSED(removed_cppArg1)

        if (!PyErr_Occurred()) {
            // toLongLong(QString,bool*)const
            // Begin code injection
            // TEMPLATE - fix_args,bool* - START
            bool ok_;
            qlonglong retval_ = cppSelf->toLongLong(cppArg0, &ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qlonglong>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_args,bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toLongLong_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toLower(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toLower";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::toLower(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toLower(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toLower_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toLower(QString)const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toLower(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toLower_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toShort(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toShort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::toShort(QString,bool*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toShort(QString,bool*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toShort_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        bool* removed_cppArg1 = nullptr;
        SBK_UNUSED(removed_cppArg1)

        if (!PyErr_Occurred()) {
            // toShort(QString,bool*)const
            // Begin code injection
            // TEMPLATE - fix_args,bool* - START
            bool ok_;
            short retval_ = cppSelf->toShort(cppArg0, &ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<short>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_args,bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toShort_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toString_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:toString", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::toString(QDate,QLocale::FormatType)const
    // 1: QLocale::toString(QDate,QLocale::FormatType,QCalendar)const
    // 2: QLocale::toString(QDate,QString)const
    // 3: QLocale::toString(QDateTime,QLocale::FormatType)const
    // 4: QLocale::toString(QDateTime,QLocale::FormatType,QCalendar)const
    // 5: QLocale::toString(QDateTime,QString)const
    // 6: QLocale::toString(QTime,QLocale::FormatType)const
    // 7: QLocale::toString(QTime,QString)const
    // 8: QLocale::toString(double,char,int)const
    // 9: QLocale::toString(float,char,int)const
    // 10: QLocale::toString(int)const
    // 11: QLocale::toString(long)const
    // 12: QLocale::toString(qlonglong)const
    // 13: QLocale::toString(short)const
    // 14: QLocale::toString(ulong)const
    if (numArgs == 1
        && PyLong_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ulong>(), (pyArgs[0])))) {
        overloadId = 14; // toString(ulong)const
    } else if (numArgs >= 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 9; // toString(float,char,int)const
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 9; // toString(float,char,int)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 9; // toString(float,char,int)const
            }
        }
    } else if (numArgs >= 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 8; // toString(double,char,int)const
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 8; // toString(double,char,int)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 8; // toString(double,char,int)const
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[0])))) {
        overloadId = 13; // toString(short)const
    } else if (numArgs == 1
        && PyLong_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qlonglong>(), (pyArgs[0])))) {
        overloadId = 12; // toString(qlonglong)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long>(), (pyArgs[0])))) {
        overloadId = 11; // toString(long)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 10; // toString(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 6; // toString(QTime,QLocale::FormatType)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 7; // toString(QTime,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 6; // toString(QTime,QLocale::FormatType)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // toString(QDateTime,QLocale::FormatType)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 5; // toString(QDateTime,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // toString(QDateTime,QLocale::FormatType)const
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[2])))) {
                overloadId = 4; // toString(QDateTime,QLocale::FormatType,QCalendar)const
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toString(QDate,QLocale::FormatType)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 2; // toString(QDate,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // toString(QDate,QLocale::FormatType)const
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[2])))) {
                overloadId = 1; // toString(QDate,QLocale::FormatType,QCalendar)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toString_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toString(const QDate & date, QLocale::FormatType format) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toString_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QDate cppArg0_local;
            ::QDate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QLocale::FormatType cppArg1 = QLocale::FormatType::LongFormat;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toString(QDate,QLocale::FormatType)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // toString(const QDate & date, QLocale::FormatType format, QCalendar cal) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toString_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QDate cppArg0_local;
            ::QDate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QLocale::FormatType cppArg1{QLocale::LongFormat};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QCalendar cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toString(QDate,QLocale::FormatType,QCalendar)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 2: // toString(const QDate & date, const QString & formatStr) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toString_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QDate cppArg0_local;
            ::QDate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toString(QDate,QString)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 3: // toString(const QDateTime & dateTime, QLocale::FormatType format) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toString_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QDateTime cppArg0_local;
            ::QDateTime *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QLocale::FormatType cppArg1 = QLocale::FormatType::LongFormat;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toString(QDateTime,QLocale::FormatType)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 4: // toString(const QDateTime & dateTime, QLocale::FormatType format, QCalendar cal) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toString_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QDateTime cppArg0_local;
            ::QDateTime *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QLocale::FormatType cppArg1{QLocale::LongFormat};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QCalendar cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toString(QDateTime,QLocale::FormatType,QCalendar)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 5: // toString(const QDateTime & dateTime, const QString & format) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toString_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QDateTime cppArg0_local;
            ::QDateTime *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toString(QDateTime,QString)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 6: // toString(const QTime & time, QLocale::FormatType format) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toString_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTime cppArg0_local;
            ::QTime *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QLocale::FormatType cppArg1 = QLocale::FormatType::LongFormat;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toString(QTime,QLocale::FormatType)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 7: // toString(const QTime & time, const QString & formatStr) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toString_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTime cppArg0_local;
            ::QTime *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toString(QTime,QString)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 8: // toString(double i, char f, int prec) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_f = Shiboken::String::createStaticString("f");
                if (PyDict_Contains(kwds, key_f)) {
                    value = PyDict_GetItem(kwds, key_f);
                    if (value && pyArgs[1]) {
                        errInfo = key_f;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_f);
                }
                static PyObject *const key_prec = Shiboken::String::createStaticString("prec");
                if (PyDict_Contains(kwds, key_prec)) {
                    value = PyDict_GetItem(kwds, key_prec);
                    if (value && pyArgs[2]) {
                        errInfo = key_prec;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_prec);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toString_TypeError;
                }
            }
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1 = 'g';
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 6;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toString(double,char,int)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 9: // toString(float i, char f, int prec) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_f = Shiboken::String::createStaticString("f");
                if (PyDict_Contains(kwds, key_f)) {
                    value = PyDict_GetItem(kwds, key_f);
                    if (value && pyArgs[1]) {
                        errInfo = key_f;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_f);
                }
                static PyObject *const key_prec = Shiboken::String::createStaticString("prec");
                if (PyDict_Contains(kwds, key_prec)) {
                    value = PyDict_GetItem(kwds, key_prec);
                    if (value && pyArgs[2]) {
                        errInfo = key_prec;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QLocaleFunc_toString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_prec);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toString_TypeError;
                }
            }
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1 = 'g';
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 6;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toString(float,char,int)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 10: // toString(int i) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toString_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(int)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 11: // toString(long i) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toString_TypeError;
            }
            long cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(long)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 12: // toString(qlonglong i) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toString_TypeError;
            }
            qlonglong cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(qlonglong)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 13: // toString(short i) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toString_TypeError;
            }
            short cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(short)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 14: // toString(ulong i) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toString_TypeError;
            }
            ulong cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(ulong)const
                QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toTime(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toTime_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toTime_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:toTime", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::toTime(QString,QLocale::FormatType)const
    // 1: QLocale::toTime(QString,QLocale::FormatType,QCalendar)const
    // 2: QLocale::toTime(QString,QString)const
    // 3: QLocale::toTime(QString,QString,QCalendar)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toTime(QString,QLocale::FormatType)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // toTime(QString,QString)const
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[2])))) {
                overloadId = 3; // toTime(QString,QString,QCalendar)const
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // toTime(QString,QLocale::FormatType)const
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[2])))) {
                overloadId = 1; // toTime(QString,QLocale::FormatType,QCalendar)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toTime_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toTime(const QString & string, QLocale::FormatType format) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toTime_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toTime_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toTime_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QLocale::FormatType cppArg1 = QLocale::FormatType::LongFormat;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toTime(QString,QLocale::FormatType)const
                QTime cppResult = const_cast<const ::QLocale *>(cppSelf)->toTime(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), &cppResult);
            }
            break;
        }
        case 1: // toTime(const QString & string, QLocale::FormatType format, QCalendar cal) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toTime_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QLocale::FormatType cppArg1{QLocale::LongFormat};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QCalendar cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toTime(QString,QLocale::FormatType,QCalendar)const
                QTime cppResult = const_cast<const ::QLocale *>(cppSelf)->toTime(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QLocale.toTime(const QString & string, QLocale::FormatType format, QCalendar cal) const is deprecated", 1);
            break;
        }
        case 2: // toTime(const QString & string, const QString & format) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toTime_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toTime(QString,QString)const
                QTime cppResult = const_cast<const ::QLocale *>(cppSelf)->toTime(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), &cppResult);
            }
            break;
        }
        case 3: // toTime(const QString & string, const QString & format, QCalendar cal) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QLocaleFunc_toTime_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QCalendar cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // toTime(QString,QString,QCalendar)const
                QTime cppResult = const_cast<const ::QLocale *>(cppSelf)->toTime(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QLocale.toTime(const QString & string, const QString & format, QCalendar cal) const is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toUInt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toUInt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::toUInt(QString,bool*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toUInt(QString,bool*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toUInt_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toUInt(QString,bool*)const
            // Begin code injection
            // TEMPLATE - fix_args,bool* - START
            bool ok_;
            uint retval_ = cppSelf->toUInt(cppArg0, &ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_args,bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toUInt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toULong(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toULong";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toULong_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLocaleFunc_toULong_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:toULong", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QLocale::toULong(QString,bool*)const
    // 1: QLocale::toULong(QStringRef,bool*)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // toULong(QStringRef,bool*)const
        } else if (numArgs >= 2
            && PyBool_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 1; // toULong(QStringRef,bool*)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toULong(QString,bool*)const
        } else if (numArgs >= 2
            && PyBool_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // toULong(QString,bool*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toULong_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toULong(const QString & s, bool * ok) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_ok = Shiboken::String::createStaticString("ok");
                if (PyDict_Contains(kwds, key_ok)) {
                    value = PyDict_GetItem(kwds, key_ok);
                    if (value && pyArgs[1]) {
                        errInfo = key_ok;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toULong_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toULong_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_ok);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toULong_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toULong(QString,bool*)const
                ulong cppResult = const_cast<const ::QLocale *>(cppSelf)->toULong(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<ulong>(), &cppResult);
            }
            break;
        }
        case 1: // toULong(const QStringRef & s, bool * ok) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_ok = Shiboken::String::createStaticString("ok");
                if (PyDict_Contains(kwds, key_ok)) {
                    value = PyDict_GetItem(kwds, key_ok);
                    if (value && pyArgs[1]) {
                        errInfo = key_ok;
                        Py_INCREF(errInfo);
                        goto Sbk_QLocaleFunc_toULong_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                            goto Sbk_QLocaleFunc_toULong_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_ok);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QLocaleFunc_toULong_TypeError;
                }
            }
            ::QStringRef cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toULong(QStringRef,bool*)const
                ulong cppResult = const_cast<const ::QLocale *>(cppSelf)->toULong(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<ulong>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toULong_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toULongLong(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toULongLong";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::toULongLong(QString,bool*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toULongLong(QString,bool*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toULongLong_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toULongLong(QString,bool*)const
            // Begin code injection
            // TEMPLATE - fix_args,bool* - START
            bool ok_;
            qulonglong retval_ = cppSelf->toULongLong(cppArg0, &ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_args,bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toULongLong_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toUShort(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toUShort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::toUShort(QString,bool*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toUShort(QString,bool*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toUShort_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        bool* removed_cppArg1 = nullptr;
        SBK_UNUSED(removed_cppArg1)

        if (!PyErr_Occurred()) {
            // toUShort(QString,bool*)const
            // Begin code injection
            // TEMPLATE - fix_args,bool* - START
            bool ok_;
            ushort retval_ = cppSelf->toUShort(cppArg0, &ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_args,bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toUShort_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_toUpper(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.toUpper";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocale::toUpper(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toUpper(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocaleFunc_toUpper_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toUpper(QString)const
            QString cppResult = const_cast<const ::QLocale *>(cppSelf)->toUpper(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocaleFunc_toUpper_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocaleFunc_uiLanguages(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.uiLanguages";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // uiLanguages()const
            QStringList cppResult = const_cast<const ::QLocale *>(cppSelf)->uiLanguages();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_weekdays(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.weekdays";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // weekdays()const
            QList<Qt::DayOfWeek > cppResult = const_cast<const ::QLocale *>(cppSelf)->weekdays();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QT_DAYOFWEEK_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocaleFunc_zeroDigit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLocale.zeroDigit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // zeroDigit()const
            QChar cppResult = const_cast<const ::QLocale *>(cppSelf)->zeroDigit();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocale___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QLocale_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QLocale_methods[] = {
    {"amText", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_amText), METH_NOARGS},
    {"bcp47Name", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_bcp47Name), METH_NOARGS},
    {"c", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_c), METH_NOARGS|METH_STATIC},
    {"collation", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_collation), METH_NOARGS},
    {"countriesForLanguage", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_countriesForLanguage), METH_O|METH_STATIC},
    {"country", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_country), METH_NOARGS},
    {"countryToString", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_countryToString), METH_O|METH_STATIC},
    {"createSeparatedList", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_createSeparatedList), METH_O},
    {"currencySymbol", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_currencySymbol), METH_VARARGS|METH_KEYWORDS},
    {"dateFormat", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_dateFormat), METH_VARARGS|METH_KEYWORDS},
    {"dateTimeFormat", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_dateTimeFormat), METH_VARARGS|METH_KEYWORDS},
    {"dayName", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_dayName), METH_VARARGS|METH_KEYWORDS},
    {"decimalPoint", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_decimalPoint), METH_NOARGS},
    {"exponential", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_exponential), METH_NOARGS},
    {"firstDayOfWeek", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_firstDayOfWeek), METH_NOARGS},
    {"formattedDataSize", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_formattedDataSize), METH_VARARGS|METH_KEYWORDS},
    {"groupSeparator", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_groupSeparator), METH_NOARGS},
    {"language", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_language), METH_NOARGS},
    {"languageToString", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_languageToString), METH_O|METH_STATIC},
    {"matchingLocales", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_matchingLocales), METH_VARARGS|METH_STATIC},
    {"measurementSystem", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_measurementSystem), METH_NOARGS},
    {"monthName", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_monthName), METH_VARARGS|METH_KEYWORDS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_name), METH_NOARGS},
    {"nativeCountryName", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_nativeCountryName), METH_NOARGS},
    {"nativeLanguageName", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_nativeLanguageName), METH_NOARGS},
    {"negativeSign", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_negativeSign), METH_NOARGS},
    {"numberOptions", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_numberOptions), METH_NOARGS},
    {"percent", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_percent), METH_NOARGS},
    {"pmText", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_pmText), METH_NOARGS},
    {"positiveSign", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_positiveSign), METH_NOARGS},
    {"quoteString", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_quoteString), METH_VARARGS|METH_KEYWORDS},
    {"script", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_script), METH_NOARGS},
    {"scriptToString", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_scriptToString), METH_O|METH_STATIC},
    {"setDefault", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_setDefault), METH_O|METH_STATIC},
    {"setNumberOptions", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_setNumberOptions), METH_O},
    {"standaloneDayName", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_standaloneDayName), METH_VARARGS|METH_KEYWORDS},
    {"standaloneMonthName", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_standaloneMonthName), METH_VARARGS|METH_KEYWORDS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_swap), METH_O},
    {"system", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_system), METH_NOARGS|METH_STATIC},
    {"textDirection", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_textDirection), METH_NOARGS},
    {"timeFormat", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_timeFormat), METH_VARARGS|METH_KEYWORDS},
    {"toCurrencyString", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toCurrencyString), METH_VARARGS|METH_KEYWORDS},
    {"toDate", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toDate), METH_VARARGS|METH_KEYWORDS},
    {"toDateTime", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toDateTime), METH_VARARGS|METH_KEYWORDS},
    {"toDouble", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toDouble), METH_O},
    {"toFloat", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toFloat), METH_O},
    {"toInt", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toInt), METH_O},
    {"toLong", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toLong), METH_VARARGS|METH_KEYWORDS},
    {"toLongLong", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toLongLong), METH_O},
    {"toLower", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toLower), METH_O},
    {"toShort", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toShort), METH_O},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toString), METH_VARARGS|METH_KEYWORDS},
    {"toTime", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toTime), METH_VARARGS|METH_KEYWORDS},
    {"toUInt", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toUInt), METH_O},
    {"toULong", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toULong), METH_VARARGS|METH_KEYWORDS},
    {"toULongLong", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toULongLong), METH_O},
    {"toUShort", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toUShort), METH_O},
    {"toUpper", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_toUpper), METH_O},
    {"uiLanguages", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_uiLanguages), METH_NOARGS},
    {"weekdays", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_weekdays), METH_NOARGS},
    {"zeroDigit", reinterpret_cast<PyCFunction>(Sbk_QLocaleFunc_zeroDigit), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QLocale___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QLocale_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArg)))) {
                // operator!=(const QLocale & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QLocale cppArg0_local;
                ::QLocale *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArg)))) {
                // operator==(const QLocale & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QLocale cppArg0_local;
                ::QLocale *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QLocale_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QLocale_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QLocale_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QLocale_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QLocale__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QLocale_Type = nullptr;
static SbkObjectType *Sbk_QLocale_TypeF(void)
{
    return _Sbk_QLocale_Type;
}

static PyType_Slot Sbk_QLocale_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QLocale__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QLocale_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QLocale_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QLocale_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QLocale_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QLocale_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QLocale_spec = {
    "2:PySide2.QtCore.QLocale",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QLocale_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_QLocale_NumberOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QLocale::NumberOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QLocale::NumberOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QLocale::NumberOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QLocale::NumberOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QLocale::NumberOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QLocale_NumberOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QLocale::NumberOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QLocale::NumberOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QLocale::NumberOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QLocale::NumberOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QLocale::NumberOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QLocale_NumberOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QLocale::NumberOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QLocale::NumberOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QLocale::NumberOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QLocale::NumberOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QLocale::NumberOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QLocale_NumberOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QLocale::NumberOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX])->converter, self, &cppSelf);
    ::QLocale::NumberOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QLocale_NumberOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QLocale_NumberOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QLocale_NumberOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_NumberOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_NumberOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_NumberOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_NumberOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_NumberOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_NumberOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_NumberOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_NumberOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_NumberOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_NumberOption_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_QLocale_DataSizeFormat___and__(PyObject *self, PyObject *pyArg)
{
    ::QLocale::DataSizeFormats cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QLocale::DataSizeFormats>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QLocale::DataSizeFormats>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QLocale::DataSizeFormats>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QLocale::DataSizeFormats>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QLocale_DataSizeFormat___or__(PyObject *self, PyObject *pyArg)
{
    ::QLocale::DataSizeFormats cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QLocale::DataSizeFormats>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QLocale::DataSizeFormats>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QLocale::DataSizeFormats>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QLocale::DataSizeFormats>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QLocale_DataSizeFormat___xor__(PyObject *self, PyObject *pyArg)
{
    ::QLocale::DataSizeFormats cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QLocale::DataSizeFormats>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QLocale::DataSizeFormats>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QLocale::DataSizeFormats>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QLocale::DataSizeFormats>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QLocale_DataSizeFormat___invert__(PyObject *self, PyObject *pyArg)
{
    ::QLocale::DataSizeFormats cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX])->converter, self, &cppSelf);
    ::QLocale::DataSizeFormats cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QLocale_DataSizeFormat_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QLocale_DataSizeFormat__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QLocale_DataSizeFormat_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_DataSizeFormat__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_DataSizeFormat__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_DataSizeFormat_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_DataSizeFormat___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_DataSizeFormat___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_DataSizeFormat___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_DataSizeFormat___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_DataSizeFormat_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_DataSizeFormat_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QLocale_DataSizeFormat_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QLocale_Language_PythonToCpp_QLocale_Language(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLocale::Language *>(cppOut) =
        static_cast<::QLocale::Language>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLocale_Language_PythonToCpp_QLocale_Language_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX]))
        return QLocale_Language_PythonToCpp_QLocale_Language;
    return {};
}
static PyObject *QLocale_Language_CppToPython_QLocale_Language(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLocale::Language *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX], castCppIn);

}

static void QLocale_Script_PythonToCpp_QLocale_Script(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLocale::Script *>(cppOut) =
        static_cast<::QLocale::Script>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLocale_Script_PythonToCpp_QLocale_Script_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX]))
        return QLocale_Script_PythonToCpp_QLocale_Script;
    return {};
}
static PyObject *QLocale_Script_CppToPython_QLocale_Script(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLocale::Script *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX], castCppIn);

}

static void QLocale_Country_PythonToCpp_QLocale_Country(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLocale::Country *>(cppOut) =
        static_cast<::QLocale::Country>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLocale_Country_PythonToCpp_QLocale_Country_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX]))
        return QLocale_Country_PythonToCpp_QLocale_Country;
    return {};
}
static PyObject *QLocale_Country_CppToPython_QLocale_Country(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLocale::Country *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX], castCppIn);

}

static void QLocale_MeasurementSystem_PythonToCpp_QLocale_MeasurementSystem(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLocale::MeasurementSystem *>(cppOut) =
        static_cast<::QLocale::MeasurementSystem>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLocale_MeasurementSystem_PythonToCpp_QLocale_MeasurementSystem_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX]))
        return QLocale_MeasurementSystem_PythonToCpp_QLocale_MeasurementSystem;
    return {};
}
static PyObject *QLocale_MeasurementSystem_CppToPython_QLocale_MeasurementSystem(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLocale::MeasurementSystem *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX], castCppIn);

}

static void QLocale_FormatType_PythonToCpp_QLocale_FormatType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLocale::FormatType *>(cppOut) =
        static_cast<::QLocale::FormatType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLocale_FormatType_PythonToCpp_QLocale_FormatType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX]))
        return QLocale_FormatType_PythonToCpp_QLocale_FormatType;
    return {};
}
static PyObject *QLocale_FormatType_CppToPython_QLocale_FormatType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLocale::FormatType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX], castCppIn);

}

static void QLocale_NumberOption_PythonToCpp_QLocale_NumberOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLocale::NumberOption *>(cppOut) =
        static_cast<::QLocale::NumberOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLocale_NumberOption_PythonToCpp_QLocale_NumberOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX]))
        return QLocale_NumberOption_PythonToCpp_QLocale_NumberOption;
    return {};
}
static PyObject *QLocale_NumberOption_CppToPython_QLocale_NumberOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLocale::NumberOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX], castCppIn);

}

static void QFlags_QLocale_NumberOption__PythonToCpp_QFlags_QLocale_NumberOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QLocale::NumberOption> *>(cppOut) =
        ::QFlags<QLocale::NumberOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QLocale_NumberOption__PythonToCpp_QFlags_QLocale_NumberOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX]))
        return QFlags_QLocale_NumberOption__PythonToCpp_QFlags_QLocale_NumberOption_;
    return {};
}
static PyObject *QFlags_QLocale_NumberOption__CppToPython_QFlags_QLocale_NumberOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QLocale::NumberOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX]));

}

static void QLocale_NumberOption_PythonToCpp_QFlags_QLocale_NumberOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QLocale::NumberOption> *>(cppOut) =
        ::QFlags<QLocale::NumberOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QLocale_NumberOption_PythonToCpp_QFlags_QLocale_NumberOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX]))
        return QLocale_NumberOption_PythonToCpp_QFlags_QLocale_NumberOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QLocale_NumberOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QLocale::NumberOption> *>(cppOut) =
        ::QFlags<QLocale::NumberOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QLocale_NumberOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX]))
        return number_PythonToCpp_QFlags_QLocale_NumberOption_;
    return {};
}
static void QLocale_FloatingPointPrecisionOption_PythonToCpp_QLocale_FloatingPointPrecisionOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLocale::FloatingPointPrecisionOption *>(cppOut) =
        static_cast<::QLocale::FloatingPointPrecisionOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLocale_FloatingPointPrecisionOption_PythonToCpp_QLocale_FloatingPointPrecisionOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_FLOATINGPOINTPRECISIONOPTION_IDX]))
        return QLocale_FloatingPointPrecisionOption_PythonToCpp_QLocale_FloatingPointPrecisionOption;
    return {};
}
static PyObject *QLocale_FloatingPointPrecisionOption_CppToPython_QLocale_FloatingPointPrecisionOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLocale::FloatingPointPrecisionOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FLOATINGPOINTPRECISIONOPTION_IDX], castCppIn);

}

static void QLocale_CurrencySymbolFormat_PythonToCpp_QLocale_CurrencySymbolFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLocale::CurrencySymbolFormat *>(cppOut) =
        static_cast<::QLocale::CurrencySymbolFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLocale_CurrencySymbolFormat_PythonToCpp_QLocale_CurrencySymbolFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_CURRENCYSYMBOLFORMAT_IDX]))
        return QLocale_CurrencySymbolFormat_PythonToCpp_QLocale_CurrencySymbolFormat;
    return {};
}
static PyObject *QLocale_CurrencySymbolFormat_CppToPython_QLocale_CurrencySymbolFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLocale::CurrencySymbolFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_CURRENCYSYMBOLFORMAT_IDX], castCppIn);

}

static void QLocale_DataSizeFormat_PythonToCpp_QLocale_DataSizeFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLocale::DataSizeFormat *>(cppOut) =
        static_cast<::QLocale::DataSizeFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLocale_DataSizeFormat_PythonToCpp_QLocale_DataSizeFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX]))
        return QLocale_DataSizeFormat_PythonToCpp_QLocale_DataSizeFormat;
    return {};
}
static PyObject *QLocale_DataSizeFormat_CppToPython_QLocale_DataSizeFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLocale::DataSizeFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX], castCppIn);

}

static void QFlags_QLocale_DataSizeFormat__PythonToCpp_QFlags_QLocale_DataSizeFormat_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QLocale::DataSizeFormat> *>(cppOut) =
        ::QFlags<QLocale::DataSizeFormat>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QLocale_DataSizeFormat__PythonToCpp_QFlags_QLocale_DataSizeFormat__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX]))
        return QFlags_QLocale_DataSizeFormat__PythonToCpp_QFlags_QLocale_DataSizeFormat_;
    return {};
}
static PyObject *QFlags_QLocale_DataSizeFormat__CppToPython_QFlags_QLocale_DataSizeFormat_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QLocale::DataSizeFormat> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX]));

}

static void QLocale_DataSizeFormat_PythonToCpp_QFlags_QLocale_DataSizeFormat_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QLocale::DataSizeFormat> *>(cppOut) =
        ::QFlags<QLocale::DataSizeFormat>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QLocale_DataSizeFormat_PythonToCpp_QFlags_QLocale_DataSizeFormat__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX]))
        return QLocale_DataSizeFormat_PythonToCpp_QFlags_QLocale_DataSizeFormat_;
    return {};
}
static void number_PythonToCpp_QFlags_QLocale_DataSizeFormat_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QLocale::DataSizeFormat> *>(cppOut) =
        ::QFlags<QLocale::DataSizeFormat>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QLocale_DataSizeFormat__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX]))
        return number_PythonToCpp_QFlags_QLocale_DataSizeFormat_;
    return {};
}
static void QLocale_QuotationStyle_PythonToCpp_QLocale_QuotationStyle(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLocale::QuotationStyle *>(cppOut) =
        static_cast<::QLocale::QuotationStyle>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLocale_QuotationStyle_PythonToCpp_QLocale_QuotationStyle_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCALE_QUOTATIONSTYLE_IDX]))
        return QLocale_QuotationStyle_PythonToCpp_QLocale_QuotationStyle;
    return {};
}
static PyObject *QLocale_QuotationStyle_CppToPython_QLocale_QuotationStyle(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLocale::QuotationStyle *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_QUOTATIONSTYLE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QLocale_PythonToCpp_QLocale_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QLocale_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QLocale_PythonToCpp_QLocale_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QLocale_TypeF())))
        return QLocale_PythonToCpp_QLocale_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QLocale_PTR_CppToPython_QLocale(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QLocale *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QLocale_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QLocale_COPY_CppToPython_QLocale(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QLocale_TypeF(), new ::QLocale(*reinterpret_cast<const ::QLocale *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QLocale_PythonToCpp_QLocale_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLocale *>(cppOut) = *reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QLocale_PythonToCpp_QLocale_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QLocale_TypeF())))
        return QLocale_PythonToCpp_QLocale_COPY;
    return {};
}

// Implicit conversions.
static void QLocale_Language_PythonToCpp_QLocale(PyObject *pyIn, void *cppOut) {
    ::QLocale::Language cppIn{QLocale::AnyLanguage};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QLocale *>(cppOut) = ::QLocale(cppIn);
}
static PythonToCppFunc is_QLocale_Language_PythonToCpp_QLocale_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX], pyIn))
        return QLocale_Language_PythonToCpp_QLocale;
    return {};
}

static void constQStringREF_PythonToCpp_QLocale(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QLocale *>(cppOut) = ::QLocale(cppIn);
}
static PythonToCppFunc is_constQStringREF_PythonToCpp_QLocale_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return constQStringREF_PythonToCpp_QLocale;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QLocale_SignatureStrings[] = {
    "4:PySide2.QtCore.QLocale(self)",
    "3:PySide2.QtCore.QLocale(self,language:PySide2.QtCore.QLocale.Language,country:PySide2.QtCore.QLocale.Country=AnyCountry)",
    "2:PySide2.QtCore.QLocale(self,language:PySide2.QtCore.QLocale.Language,script:PySide2.QtCore.QLocale.Script,country:PySide2.QtCore.QLocale.Country)",
    "1:PySide2.QtCore.QLocale(self,other:PySide2.QtCore.QLocale)",
    "0:PySide2.QtCore.QLocale(self,name:QString)",
    "PySide2.QtCore.QLocale.amText(self)->QString",
    "PySide2.QtCore.QLocale.bcp47Name(self)->QString",
    "PySide2.QtCore.QLocale.c()->PySide2.QtCore.QLocale",
    "PySide2.QtCore.QLocale.collation(self)->PySide2.QtCore.QLocale",
    "PySide2.QtCore.QLocale.countriesForLanguage(lang:PySide2.QtCore.QLocale.Language)->QList[PySide2.QtCore.QLocale.Country]",
    "PySide2.QtCore.QLocale.country(self)->PySide2.QtCore.QLocale.Country",
    "PySide2.QtCore.QLocale.countryToString(country:PySide2.QtCore.QLocale.Country)->QString",
    "PySide2.QtCore.QLocale.createSeparatedList(self,strl:QStringList)->QString",
    "PySide2.QtCore.QLocale.currencySymbol(self,arg__1:PySide2.QtCore.QLocale.CurrencySymbolFormat=CurrencySymbol)->QString",
    "PySide2.QtCore.QLocale.dateFormat(self,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->QString",
    "PySide2.QtCore.QLocale.dateTimeFormat(self,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->QString",
    "PySide2.QtCore.QLocale.dayName(self,arg__1:int,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->QString",
    "PySide2.QtCore.QLocale.decimalPoint(self)->QChar",
    "PySide2.QtCore.QLocale.exponential(self)->QChar",
    "PySide2.QtCore.QLocale.firstDayOfWeek(self)->PySide2.QtCore.Qt.DayOfWeek",
    "1:PySide2.QtCore.QLocale.formattedDataSize(self,bytes:qint64,precision:int=2,format:PySide2.QtCore.QLocale.DataSizeFormats=QLocale.DataSizeIecFormat)->QString",
    "0:PySide2.QtCore.QLocale.formattedDataSize(self,bytes:qint64,precision:int=2,format:PySide2.QtCore.QLocale.DataSizeFormats=QLocale.DataSizeIecFormat)->QString",
    "PySide2.QtCore.QLocale.groupSeparator(self)->QChar",
    "PySide2.QtCore.QLocale.language(self)->PySide2.QtCore.QLocale.Language",
    "PySide2.QtCore.QLocale.languageToString(language:PySide2.QtCore.QLocale.Language)->QString",
    "PySide2.QtCore.QLocale.matchingLocales(language:PySide2.QtCore.QLocale.Language,script:PySide2.QtCore.QLocale.Script,country:PySide2.QtCore.QLocale.Country)->QList[PySide2.QtCore.QLocale]",
    "PySide2.QtCore.QLocale.measurementSystem(self)->PySide2.QtCore.QLocale.MeasurementSystem",
    "PySide2.QtCore.QLocale.monthName(self,arg__1:int,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->QString",
    "PySide2.QtCore.QLocale.name(self)->QString",
    "PySide2.QtCore.QLocale.nativeCountryName(self)->QString",
    "PySide2.QtCore.QLocale.nativeLanguageName(self)->QString",
    "PySide2.QtCore.QLocale.negativeSign(self)->QChar",
    "PySide2.QtCore.QLocale.numberOptions(self)->PySide2.QtCore.QLocale.NumberOptions",
    "PySide2.QtCore.QLocale.percent(self)->QChar",
    "PySide2.QtCore.QLocale.pmText(self)->QString",
    "PySide2.QtCore.QLocale.positiveSign(self)->QChar",
    "1:PySide2.QtCore.QLocale.quoteString(self,str:QString,style:PySide2.QtCore.QLocale.QuotationStyle=StandardQuotation)->QString",
    "0:PySide2.QtCore.QLocale.quoteString(self,str:QStringRef,style:PySide2.QtCore.QLocale.QuotationStyle=StandardQuotation)->QString",
    "PySide2.QtCore.QLocale.script(self)->PySide2.QtCore.QLocale.Script",
    "PySide2.QtCore.QLocale.scriptToString(script:PySide2.QtCore.QLocale.Script)->QString",
    "PySide2.QtCore.QLocale.setDefault(locale:PySide2.QtCore.QLocale)",
    "PySide2.QtCore.QLocale.setNumberOptions(self,options:PySide2.QtCore.QLocale.NumberOptions)",
    "PySide2.QtCore.QLocale.standaloneDayName(self,arg__1:int,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->QString",
    "PySide2.QtCore.QLocale.standaloneMonthName(self,arg__1:int,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->QString",
    "PySide2.QtCore.QLocale.swap(self,other:PySide2.QtCore.QLocale)",
    "PySide2.QtCore.QLocale.system()->PySide2.QtCore.QLocale",
    "PySide2.QtCore.QLocale.textDirection(self)->PySide2.QtCore.Qt.LayoutDirection",
    "PySide2.QtCore.QLocale.timeFormat(self,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->QString",
    "9:PySide2.QtCore.QLocale.toCurrencyString(self,arg__1:double,symbol:QString=QString())->QString",
    "8:PySide2.QtCore.QLocale.toCurrencyString(self,arg__1:double,symbol:QString,precision:int)->QString",
    "7:PySide2.QtCore.QLocale.toCurrencyString(self,i:float,symbol:QString=QString())->QString",
    "6:PySide2.QtCore.QLocale.toCurrencyString(self,i:float,symbol:QString,precision:int)->QString",
    "5:PySide2.QtCore.QLocale.toCurrencyString(self,arg__1:int,symbol:QString=QString())->QString",
    "4:PySide2.QtCore.QLocale.toCurrencyString(self,arg__1:qlonglong,symbol:QString=QString())->QString",
    "3:PySide2.QtCore.QLocale.toCurrencyString(self,arg__1:qulonglong,symbol:QString=QString())->QString",
    "2:PySide2.QtCore.QLocale.toCurrencyString(self,arg__1:short,symbol:QString=QString())->QString",
    "1:PySide2.QtCore.QLocale.toCurrencyString(self,arg__1:uint,symbol:QString=QString())->QString",
    "0:PySide2.QtCore.QLocale.toCurrencyString(self,arg__1:ushort,symbol:QString=QString())->QString",
    "3:PySide2.QtCore.QLocale.toDate(self,string:QString,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->PySide2.QtCore.QDate",
    "2:PySide2.QtCore.QLocale.toDate(self,string:QString,format:PySide2.QtCore.QLocale.FormatType,cal:PySide2.QtCore.QCalendar)->PySide2.QtCore.QDate",
    "1:PySide2.QtCore.QLocale.toDate(self,string:QString,format:QString)->PySide2.QtCore.QDate",
    "0:PySide2.QtCore.QLocale.toDate(self,string:QString,format:QString,cal:PySide2.QtCore.QCalendar)->PySide2.QtCore.QDate",
    "3:PySide2.QtCore.QLocale.toDateTime(self,string:QString,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->PySide2.QtCore.QDateTime",
    "2:PySide2.QtCore.QLocale.toDateTime(self,string:QString,format:PySide2.QtCore.QLocale.FormatType,cal:PySide2.QtCore.QCalendar)->PySide2.QtCore.QDateTime",
    "1:PySide2.QtCore.QLocale.toDateTime(self,string:QString,format:QString)->PySide2.QtCore.QDateTime",
    "0:PySide2.QtCore.QLocale.toDateTime(self,string:QString,format:QString,cal:PySide2.QtCore.QCalendar)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QLocale.toDouble(self,s:QString,ok:bool*)->double",
    "PySide2.QtCore.QLocale.toFloat(self,s:QString,ok:bool*)->float",
    "PySide2.QtCore.QLocale.toInt(self,s:QString,ok:bool*=nullptr)->int",
    "1:PySide2.QtCore.QLocale.toLong(self,s:QString,ok:bool*=nullptr)->long",
    "0:PySide2.QtCore.QLocale.toLong(self,s:QStringRef,ok:bool*=nullptr)->long",
    "PySide2.QtCore.QLocale.toLongLong(self,s:QString,ok:bool*=nullptr)->qlonglong",
    "PySide2.QtCore.QLocale.toLower(self,str:QString)->QString",
    "PySide2.QtCore.QLocale.toShort(self,s:QString,ok:bool*=nullptr)->short",
    "14:PySide2.QtCore.QLocale.toString(self,date:PySide2.QtCore.QDate,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->QString",
    "13:PySide2.QtCore.QLocale.toString(self,date:PySide2.QtCore.QDate,format:PySide2.QtCore.QLocale.FormatType,cal:PySide2.QtCore.QCalendar)->QString",
    "12:PySide2.QtCore.QLocale.toString(self,date:PySide2.QtCore.QDate,formatStr:QString)->QString",
    "11:PySide2.QtCore.QLocale.toString(self,dateTime:PySide2.QtCore.QDateTime,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->QString",
    "10:PySide2.QtCore.QLocale.toString(self,dateTime:PySide2.QtCore.QDateTime,format:PySide2.QtCore.QLocale.FormatType,cal:PySide2.QtCore.QCalendar)->QString",
    "9:PySide2.QtCore.QLocale.toString(self,dateTime:PySide2.QtCore.QDateTime,format:QString)->QString",
    "8:PySide2.QtCore.QLocale.toString(self,time:PySide2.QtCore.QTime,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->QString",
    "7:PySide2.QtCore.QLocale.toString(self,time:PySide2.QtCore.QTime,formatStr:QString)->QString",
    "6:PySide2.QtCore.QLocale.toString(self,i:double,f:char='g',prec:int=6)->QString",
    "5:PySide2.QtCore.QLocale.toString(self,i:float,f:char='g',prec:int=6)->QString",
    "4:PySide2.QtCore.QLocale.toString(self,i:int)->QString",
    "3:PySide2.QtCore.QLocale.toString(self,i:long)->QString",
    "2:PySide2.QtCore.QLocale.toString(self,i:qlonglong)->QString",
    "1:PySide2.QtCore.QLocale.toString(self,i:short)->QString",
    "0:PySide2.QtCore.QLocale.toString(self,i:ulong)->QString",
    "3:PySide2.QtCore.QLocale.toTime(self,string:QString,format:PySide2.QtCore.QLocale.FormatType=LongFormat)->PySide2.QtCore.QTime",
    "2:PySide2.QtCore.QLocale.toTime(self,string:QString,format:PySide2.QtCore.QLocale.FormatType,cal:PySide2.QtCore.QCalendar)->PySide2.QtCore.QTime",
    "1:PySide2.QtCore.QLocale.toTime(self,string:QString,format:QString)->PySide2.QtCore.QTime",
    "0:PySide2.QtCore.QLocale.toTime(self,string:QString,format:QString,cal:PySide2.QtCore.QCalendar)->PySide2.QtCore.QTime",
    "PySide2.QtCore.QLocale.toUInt(self,s:QString,ok:bool*)->uint",
    "1:PySide2.QtCore.QLocale.toULong(self,s:QString,ok:bool*=nullptr)->ulong",
    "0:PySide2.QtCore.QLocale.toULong(self,s:QStringRef,ok:bool*=nullptr)->ulong",
    "PySide2.QtCore.QLocale.toULongLong(self,s:QString,ok:bool*)->qulonglong",
    "PySide2.QtCore.QLocale.toUShort(self,s:QString,ok:bool*=nullptr)->ushort",
    "PySide2.QtCore.QLocale.toUpper(self,str:QString)->QString",
    "PySide2.QtCore.QLocale.uiLanguages(self)->QStringList",
    "PySide2.QtCore.QLocale.weekdays(self)->QList[PySide2.QtCore.Qt.DayOfWeek]",
    "PySide2.QtCore.QLocale.zeroDigit(self)->QChar",
    "PySide2.QtCore.QLocale.__copy__()",
    nullptr}; // Sentinel

void init_QLocale(PyObject *module)
{
    _Sbk_QLocale_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QLocale",
        "QLocale",
        &Sbk_QLocale_spec,
        &Shiboken::callCppDestructor< ::QLocale >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QLocale_Type);
    InitSignatureStrings(pyType, QLocale_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QLocale_Type), Sbk_QLocale_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QLocale_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QLocale_TypeF(),
        QLocale_PythonToCpp_QLocale_PTR,
        is_QLocale_PythonToCpp_QLocale_PTR_Convertible,
        QLocale_PTR_CppToPython_QLocale,
        QLocale_COPY_CppToPython_QLocale);

    Shiboken::Conversions::registerConverterName(converter, "QLocale");
    Shiboken::Conversions::registerConverterName(converter, "QLocale*");
    Shiboken::Conversions::registerConverterName(converter, "QLocale&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QLocale).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QLocale_PythonToCpp_QLocale_COPY,
        is_QLocale_PythonToCpp_QLocale_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QLocale_Language_PythonToCpp_QLocale,
        is_QLocale_Language_PythonToCpp_QLocale_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQStringREF_PythonToCpp_QLocale,
        is_constQStringREF_PythonToCpp_QLocale_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Language'.
    SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLocale_TypeF(),
        "Language",
        "2:PySide2.QtCore.QLocale.Language",
        "QLocale::Language");
    if (!SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "AnyLanguage", (long) QLocale::Language::AnyLanguage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "C", (long) QLocale::Language::C))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Abkhazian", (long) QLocale::Language::Abkhazian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Oromo", (long) QLocale::Language::Oromo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Afar", (long) QLocale::Language::Afar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Afrikaans", (long) QLocale::Language::Afrikaans))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Albanian", (long) QLocale::Language::Albanian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Amharic", (long) QLocale::Language::Amharic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Arabic", (long) QLocale::Language::Arabic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Armenian", (long) QLocale::Language::Armenian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Assamese", (long) QLocale::Language::Assamese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Aymara", (long) QLocale::Language::Aymara))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Azerbaijani", (long) QLocale::Language::Azerbaijani))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bashkir", (long) QLocale::Language::Bashkir))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Basque", (long) QLocale::Language::Basque))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bengali", (long) QLocale::Language::Bengali))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Dzongkha", (long) QLocale::Language::Dzongkha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bihari", (long) QLocale::Language::Bihari))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bislama", (long) QLocale::Language::Bislama))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Breton", (long) QLocale::Language::Breton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bulgarian", (long) QLocale::Language::Bulgarian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Burmese", (long) QLocale::Language::Burmese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Belarusian", (long) QLocale::Language::Belarusian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Khmer", (long) QLocale::Language::Khmer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Catalan", (long) QLocale::Language::Catalan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Chinese", (long) QLocale::Language::Chinese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Corsican", (long) QLocale::Language::Corsican))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Croatian", (long) QLocale::Language::Croatian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Czech", (long) QLocale::Language::Czech))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Danish", (long) QLocale::Language::Danish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Dutch", (long) QLocale::Language::Dutch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "English", (long) QLocale::Language::English))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Esperanto", (long) QLocale::Language::Esperanto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Estonian", (long) QLocale::Language::Estonian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Faroese", (long) QLocale::Language::Faroese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Fijian", (long) QLocale::Language::Fijian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Finnish", (long) QLocale::Language::Finnish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "French", (long) QLocale::Language::French))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "WesternFrisian", (long) QLocale::Language::WesternFrisian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Gaelic", (long) QLocale::Language::Gaelic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Galician", (long) QLocale::Language::Galician))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Georgian", (long) QLocale::Language::Georgian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "German", (long) QLocale::Language::German))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Greek", (long) QLocale::Language::Greek))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Greenlandic", (long) QLocale::Language::Greenlandic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Guarani", (long) QLocale::Language::Guarani))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Gujarati", (long) QLocale::Language::Gujarati))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Hausa", (long) QLocale::Language::Hausa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Hebrew", (long) QLocale::Language::Hebrew))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Hindi", (long) QLocale::Language::Hindi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Hungarian", (long) QLocale::Language::Hungarian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Icelandic", (long) QLocale::Language::Icelandic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Indonesian", (long) QLocale::Language::Indonesian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Interlingua", (long) QLocale::Language::Interlingua))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Interlingue", (long) QLocale::Language::Interlingue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Inuktitut", (long) QLocale::Language::Inuktitut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Inupiak", (long) QLocale::Language::Inupiak))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Irish", (long) QLocale::Language::Irish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Italian", (long) QLocale::Language::Italian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Japanese", (long) QLocale::Language::Japanese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Javanese", (long) QLocale::Language::Javanese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kannada", (long) QLocale::Language::Kannada))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kashmiri", (long) QLocale::Language::Kashmiri))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kazakh", (long) QLocale::Language::Kazakh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kinyarwanda", (long) QLocale::Language::Kinyarwanda))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kirghiz", (long) QLocale::Language::Kirghiz))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Korean", (long) QLocale::Language::Korean))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kurdish", (long) QLocale::Language::Kurdish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Rundi", (long) QLocale::Language::Rundi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Lao", (long) QLocale::Language::Lao))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Latin", (long) QLocale::Language::Latin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Latvian", (long) QLocale::Language::Latvian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Lingala", (long) QLocale::Language::Lingala))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Lithuanian", (long) QLocale::Language::Lithuanian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Macedonian", (long) QLocale::Language::Macedonian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Malagasy", (long) QLocale::Language::Malagasy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Malay", (long) QLocale::Language::Malay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Malayalam", (long) QLocale::Language::Malayalam))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Maltese", (long) QLocale::Language::Maltese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Maori", (long) QLocale::Language::Maori))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Marathi", (long) QLocale::Language::Marathi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Marshallese", (long) QLocale::Language::Marshallese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Mongolian", (long) QLocale::Language::Mongolian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "NauruLanguage", (long) QLocale::Language::NauruLanguage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Nepali", (long) QLocale::Language::Nepali))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "NorwegianBokmal", (long) QLocale::Language::NorwegianBokmal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Occitan", (long) QLocale::Language::Occitan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Oriya", (long) QLocale::Language::Oriya))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Pashto", (long) QLocale::Language::Pashto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Persian", (long) QLocale::Language::Persian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Polish", (long) QLocale::Language::Polish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Portuguese", (long) QLocale::Language::Portuguese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Punjabi", (long) QLocale::Language::Punjabi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Quechua", (long) QLocale::Language::Quechua))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Romansh", (long) QLocale::Language::Romansh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Romanian", (long) QLocale::Language::Romanian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Russian", (long) QLocale::Language::Russian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Samoan", (long) QLocale::Language::Samoan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sango", (long) QLocale::Language::Sango))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sanskrit", (long) QLocale::Language::Sanskrit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Serbian", (long) QLocale::Language::Serbian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ossetic", (long) QLocale::Language::Ossetic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "SouthernSotho", (long) QLocale::Language::SouthernSotho))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tswana", (long) QLocale::Language::Tswana))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Shona", (long) QLocale::Language::Shona))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sindhi", (long) QLocale::Language::Sindhi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sinhala", (long) QLocale::Language::Sinhala))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Swati", (long) QLocale::Language::Swati))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Slovak", (long) QLocale::Language::Slovak))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Slovenian", (long) QLocale::Language::Slovenian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Somali", (long) QLocale::Language::Somali))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Spanish", (long) QLocale::Language::Spanish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sundanese", (long) QLocale::Language::Sundanese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Swahili", (long) QLocale::Language::Swahili))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Swedish", (long) QLocale::Language::Swedish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sardinian", (long) QLocale::Language::Sardinian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tajik", (long) QLocale::Language::Tajik))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tamil", (long) QLocale::Language::Tamil))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tatar", (long) QLocale::Language::Tatar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Telugu", (long) QLocale::Language::Telugu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Thai", (long) QLocale::Language::Thai))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tibetan", (long) QLocale::Language::Tibetan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tigrinya", (long) QLocale::Language::Tigrinya))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tongan", (long) QLocale::Language::Tongan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tsonga", (long) QLocale::Language::Tsonga))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Turkish", (long) QLocale::Language::Turkish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Turkmen", (long) QLocale::Language::Turkmen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tahitian", (long) QLocale::Language::Tahitian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Uighur", (long) QLocale::Language::Uighur))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ukrainian", (long) QLocale::Language::Ukrainian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Urdu", (long) QLocale::Language::Urdu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Uzbek", (long) QLocale::Language::Uzbek))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Vietnamese", (long) QLocale::Language::Vietnamese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Volapuk", (long) QLocale::Language::Volapuk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Welsh", (long) QLocale::Language::Welsh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Wolof", (long) QLocale::Language::Wolof))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Xhosa", (long) QLocale::Language::Xhosa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Yiddish", (long) QLocale::Language::Yiddish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Yoruba", (long) QLocale::Language::Yoruba))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Zhuang", (long) QLocale::Language::Zhuang))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Zulu", (long) QLocale::Language::Zulu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "NorwegianNynorsk", (long) QLocale::Language::NorwegianNynorsk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bosnian", (long) QLocale::Language::Bosnian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Divehi", (long) QLocale::Language::Divehi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Manx", (long) QLocale::Language::Manx))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Cornish", (long) QLocale::Language::Cornish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Akan", (long) QLocale::Language::Akan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Konkani", (long) QLocale::Language::Konkani))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ga", (long) QLocale::Language::Ga))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Igbo", (long) QLocale::Language::Igbo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kamba", (long) QLocale::Language::Kamba))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Syriac", (long) QLocale::Language::Syriac))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Blin", (long) QLocale::Language::Blin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Geez", (long) QLocale::Language::Geez))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Koro", (long) QLocale::Language::Koro))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sidamo", (long) QLocale::Language::Sidamo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Atsam", (long) QLocale::Language::Atsam))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tigre", (long) QLocale::Language::Tigre))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Jju", (long) QLocale::Language::Jju))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Friulian", (long) QLocale::Language::Friulian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Venda", (long) QLocale::Language::Venda))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ewe", (long) QLocale::Language::Ewe))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Walamo", (long) QLocale::Language::Walamo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Hawaiian", (long) QLocale::Language::Hawaiian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tyap", (long) QLocale::Language::Tyap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Nyanja", (long) QLocale::Language::Nyanja))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Filipino", (long) QLocale::Language::Filipino))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "SwissGerman", (long) QLocale::Language::SwissGerman))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "SichuanYi", (long) QLocale::Language::SichuanYi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kpelle", (long) QLocale::Language::Kpelle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "LowGerman", (long) QLocale::Language::LowGerman))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "SouthNdebele", (long) QLocale::Language::SouthNdebele))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "NorthernSotho", (long) QLocale::Language::NorthernSotho))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "NorthernSami", (long) QLocale::Language::NorthernSami))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Taroko", (long) QLocale::Language::Taroko))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Gusii", (long) QLocale::Language::Gusii))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Taita", (long) QLocale::Language::Taita))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Fulah", (long) QLocale::Language::Fulah))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kikuyu", (long) QLocale::Language::Kikuyu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Samburu", (long) QLocale::Language::Samburu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sena", (long) QLocale::Language::Sena))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "NorthNdebele", (long) QLocale::Language::NorthNdebele))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Rombo", (long) QLocale::Language::Rombo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tachelhit", (long) QLocale::Language::Tachelhit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kabyle", (long) QLocale::Language::Kabyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Nyankole", (long) QLocale::Language::Nyankole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bena", (long) QLocale::Language::Bena))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Vunjo", (long) QLocale::Language::Vunjo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bambara", (long) QLocale::Language::Bambara))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Embu", (long) QLocale::Language::Embu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Cherokee", (long) QLocale::Language::Cherokee))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Morisyen", (long) QLocale::Language::Morisyen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Makonde", (long) QLocale::Language::Makonde))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Langi", (long) QLocale::Language::Langi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ganda", (long) QLocale::Language::Ganda))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bemba", (long) QLocale::Language::Bemba))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kabuverdianu", (long) QLocale::Language::Kabuverdianu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Meru", (long) QLocale::Language::Meru))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kalenjin", (long) QLocale::Language::Kalenjin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Nama", (long) QLocale::Language::Nama))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Machame", (long) QLocale::Language::Machame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Colognian", (long) QLocale::Language::Colognian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Masai", (long) QLocale::Language::Masai))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Soga", (long) QLocale::Language::Soga))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Luyia", (long) QLocale::Language::Luyia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Asu", (long) QLocale::Language::Asu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Teso", (long) QLocale::Language::Teso))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Saho", (long) QLocale::Language::Saho))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "KoyraChiini", (long) QLocale::Language::KoyraChiini))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Rwa", (long) QLocale::Language::Rwa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Luo", (long) QLocale::Language::Luo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Chiga", (long) QLocale::Language::Chiga))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "CentralMoroccoTamazight", (long) QLocale::Language::CentralMoroccoTamazight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "KoyraboroSenni", (long) QLocale::Language::KoyraboroSenni))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Shambala", (long) QLocale::Language::Shambala))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bodo", (long) QLocale::Language::Bodo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Avaric", (long) QLocale::Language::Avaric))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Chamorro", (long) QLocale::Language::Chamorro))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Chechen", (long) QLocale::Language::Chechen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Church", (long) QLocale::Language::Church))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Chuvash", (long) QLocale::Language::Chuvash))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Cree", (long) QLocale::Language::Cree))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Haitian", (long) QLocale::Language::Haitian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Herero", (long) QLocale::Language::Herero))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "HiriMotu", (long) QLocale::Language::HiriMotu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kanuri", (long) QLocale::Language::Kanuri))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Komi", (long) QLocale::Language::Komi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kongo", (long) QLocale::Language::Kongo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kwanyama", (long) QLocale::Language::Kwanyama))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Limburgish", (long) QLocale::Language::Limburgish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "LubaKatanga", (long) QLocale::Language::LubaKatanga))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Luxembourgish", (long) QLocale::Language::Luxembourgish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Navaho", (long) QLocale::Language::Navaho))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ndonga", (long) QLocale::Language::Ndonga))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ojibwa", (long) QLocale::Language::Ojibwa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Pali", (long) QLocale::Language::Pali))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Walloon", (long) QLocale::Language::Walloon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Aghem", (long) QLocale::Language::Aghem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Basaa", (long) QLocale::Language::Basaa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Zarma", (long) QLocale::Language::Zarma))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Duala", (long) QLocale::Language::Duala))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "JolaFonyi", (long) QLocale::Language::JolaFonyi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ewondo", (long) QLocale::Language::Ewondo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bafia", (long) QLocale::Language::Bafia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "MakhuwaMeetto", (long) QLocale::Language::MakhuwaMeetto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Mundang", (long) QLocale::Language::Mundang))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kwasio", (long) QLocale::Language::Kwasio))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Nuer", (long) QLocale::Language::Nuer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sakha", (long) QLocale::Language::Sakha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sangu", (long) QLocale::Language::Sangu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "CongoSwahili", (long) QLocale::Language::CongoSwahili))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tasawaq", (long) QLocale::Language::Tasawaq))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Vai", (long) QLocale::Language::Vai))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Walser", (long) QLocale::Language::Walser))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Yangben", (long) QLocale::Language::Yangben))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Avestan", (long) QLocale::Language::Avestan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Asturian", (long) QLocale::Language::Asturian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ngomba", (long) QLocale::Language::Ngomba))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kako", (long) QLocale::Language::Kako))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Meta", (long) QLocale::Language::Meta))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ngiemboon", (long) QLocale::Language::Ngiemboon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Aragonese", (long) QLocale::Language::Aragonese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Akkadian", (long) QLocale::Language::Akkadian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "AncientEgyptian", (long) QLocale::Language::AncientEgyptian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "AncientGreek", (long) QLocale::Language::AncientGreek))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Aramaic", (long) QLocale::Language::Aramaic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Balinese", (long) QLocale::Language::Balinese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bamun", (long) QLocale::Language::Bamun))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "BatakToba", (long) QLocale::Language::BatakToba))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Buginese", (long) QLocale::Language::Buginese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Buhid", (long) QLocale::Language::Buhid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Carian", (long) QLocale::Language::Carian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Chakma", (long) QLocale::Language::Chakma))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "ClassicalMandaic", (long) QLocale::Language::ClassicalMandaic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Coptic", (long) QLocale::Language::Coptic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Dogri", (long) QLocale::Language::Dogri))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "EasternCham", (long) QLocale::Language::EasternCham))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "EasternKayah", (long) QLocale::Language::EasternKayah))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Etruscan", (long) QLocale::Language::Etruscan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Gothic", (long) QLocale::Language::Gothic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Hanunoo", (long) QLocale::Language::Hanunoo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ingush", (long) QLocale::Language::Ingush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "LargeFloweryMiao", (long) QLocale::Language::LargeFloweryMiao))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Lepcha", (long) QLocale::Language::Lepcha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Limbu", (long) QLocale::Language::Limbu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Lisu", (long) QLocale::Language::Lisu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Lu", (long) QLocale::Language::Lu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Lycian", (long) QLocale::Language::Lycian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Lydian", (long) QLocale::Language::Lydian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Mandingo", (long) QLocale::Language::Mandingo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Manipuri", (long) QLocale::Language::Manipuri))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Meroitic", (long) QLocale::Language::Meroitic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "NorthernThai", (long) QLocale::Language::NorthernThai))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "OldIrish", (long) QLocale::Language::OldIrish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "OldNorse", (long) QLocale::Language::OldNorse))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "OldPersian", (long) QLocale::Language::OldPersian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "OldTurkish", (long) QLocale::Language::OldTurkish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Pahlavi", (long) QLocale::Language::Pahlavi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Parthian", (long) QLocale::Language::Parthian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Phoenician", (long) QLocale::Language::Phoenician))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "PrakritLanguage", (long) QLocale::Language::PrakritLanguage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Rejang", (long) QLocale::Language::Rejang))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sabaean", (long) QLocale::Language::Sabaean))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Samaritan", (long) QLocale::Language::Samaritan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Santali", (long) QLocale::Language::Santali))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Saurashtra", (long) QLocale::Language::Saurashtra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sora", (long) QLocale::Language::Sora))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sylheti", (long) QLocale::Language::Sylheti))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tagbanwa", (long) QLocale::Language::Tagbanwa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "TaiDam", (long) QLocale::Language::TaiDam))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "TaiNua", (long) QLocale::Language::TaiNua))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ugaritic", (long) QLocale::Language::Ugaritic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Akoose", (long) QLocale::Language::Akoose))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Lakota", (long) QLocale::Language::Lakota))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "StandardMoroccanTamazight", (long) QLocale::Language::StandardMoroccanTamazight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Mapuche", (long) QLocale::Language::Mapuche))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "CentralKurdish", (long) QLocale::Language::CentralKurdish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "LowerSorbian", (long) QLocale::Language::LowerSorbian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "UpperSorbian", (long) QLocale::Language::UpperSorbian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kenyang", (long) QLocale::Language::Kenyang))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Mohawk", (long) QLocale::Language::Mohawk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Nko", (long) QLocale::Language::Nko))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Prussian", (long) QLocale::Language::Prussian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kiche", (long) QLocale::Language::Kiche))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "SouthernSami", (long) QLocale::Language::SouthernSami))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "LuleSami", (long) QLocale::Language::LuleSami))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "InariSami", (long) QLocale::Language::InariSami))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "SkoltSami", (long) QLocale::Language::SkoltSami))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Warlpiri", (long) QLocale::Language::Warlpiri))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "ManichaeanMiddlePersian", (long) QLocale::Language::ManichaeanMiddlePersian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Mende", (long) QLocale::Language::Mende))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "AncientNorthArabian", (long) QLocale::Language::AncientNorthArabian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "LinearA", (long) QLocale::Language::LinearA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "HmongNjua", (long) QLocale::Language::HmongNjua))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ho", (long) QLocale::Language::Ho))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Lezghian", (long) QLocale::Language::Lezghian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bassa", (long) QLocale::Language::Bassa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Mono", (long) QLocale::Language::Mono))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "TedimChin", (long) QLocale::Language::TedimChin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Maithili", (long) QLocale::Language::Maithili))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ahom", (long) QLocale::Language::Ahom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "AmericanSignLanguage", (long) QLocale::Language::AmericanSignLanguage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "ArdhamagadhiPrakrit", (long) QLocale::Language::ArdhamagadhiPrakrit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bhojpuri", (long) QLocale::Language::Bhojpuri))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "HieroglyphicLuwian", (long) QLocale::Language::HieroglyphicLuwian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "LiteraryChinese", (long) QLocale::Language::LiteraryChinese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Mazanderani", (long) QLocale::Language::Mazanderani))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Mru", (long) QLocale::Language::Mru))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Newari", (long) QLocale::Language::Newari))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "NorthernLuri", (long) QLocale::Language::NorthernLuri))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Palauan", (long) QLocale::Language::Palauan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Papiamento", (long) QLocale::Language::Papiamento))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Saraiki", (long) QLocale::Language::Saraiki))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "TokelauLanguage", (long) QLocale::Language::TokelauLanguage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "TokPisin", (long) QLocale::Language::TokPisin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "TuvaluLanguage", (long) QLocale::Language::TuvaluLanguage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "UncodedLanguages", (long) QLocale::Language::UncodedLanguages))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Cantonese", (long) QLocale::Language::Cantonese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Osage", (long) QLocale::Language::Osage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tangut", (long) QLocale::Language::Tangut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Ido", (long) QLocale::Language::Ido))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Lojban", (long) QLocale::Language::Lojban))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Sicilian", (long) QLocale::Language::Sicilian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "SouthernKurdish", (long) QLocale::Language::SouthernKurdish))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "WesternBalochi", (long) QLocale::Language::WesternBalochi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Cebuano", (long) QLocale::Language::Cebuano))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Erzya", (long) QLocale::Language::Erzya))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Chickasaw", (long) QLocale::Language::Chickasaw))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Muscogee", (long) QLocale::Language::Muscogee))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Silesian", (long) QLocale::Language::Silesian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "NigerianPidgin", (long) QLocale::Language::NigerianPidgin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Afan", (long) QLocale::Language::Afan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Bhutani", (long) QLocale::Language::Bhutani))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Byelorussian", (long) QLocale::Language::Byelorussian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Cambodian", (long) QLocale::Language::Cambodian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Chewa", (long) QLocale::Language::Chewa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Frisian", (long) QLocale::Language::Frisian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Kurundi", (long) QLocale::Language::Kurundi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Moldavian", (long) QLocale::Language::Moldavian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Norwegian", (long) QLocale::Language::Norwegian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "RhaetoRomance", (long) QLocale::Language::RhaetoRomance))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "SerboCroatian", (long) QLocale::Language::SerboCroatian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Tagalog", (long) QLocale::Language::Tagalog))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Twi", (long) QLocale::Language::Twi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "Uigur", (long) QLocale::Language::Uigur))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
        Sbk_QLocale_TypeF(), "LastLanguage", (long) QLocale::Language::LastLanguage))
        return;
    // Register converter for enum 'QLocale::Language'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX],
            QLocale_Language_CppToPython_QLocale_Language);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocale_Language_PythonToCpp_QLocale_Language,
            is_QLocale_Language_PythonToCpp_QLocale_Language_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocale::Language");
        Shiboken::Conversions::registerConverterName(converter, "Language");
    }
    // End of 'Language' enum.

    // Initialization of enum 'Script'.
    SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLocale_TypeF(),
        "Script",
        "2:PySide2.QtCore.QLocale.Script",
        "QLocale::Script");
    if (!SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "AnyScript", (long) QLocale::Script::AnyScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "ArabicScript", (long) QLocale::Script::ArabicScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "CyrillicScript", (long) QLocale::Script::CyrillicScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "DeseretScript", (long) QLocale::Script::DeseretScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "GurmukhiScript", (long) QLocale::Script::GurmukhiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "SimplifiedHanScript", (long) QLocale::Script::SimplifiedHanScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TraditionalHanScript", (long) QLocale::Script::TraditionalHanScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "LatinScript", (long) QLocale::Script::LatinScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "MongolianScript", (long) QLocale::Script::MongolianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TifinaghScript", (long) QLocale::Script::TifinaghScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "ArmenianScript", (long) QLocale::Script::ArmenianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "BengaliScript", (long) QLocale::Script::BengaliScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "CherokeeScript", (long) QLocale::Script::CherokeeScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "DevanagariScript", (long) QLocale::Script::DevanagariScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "EthiopicScript", (long) QLocale::Script::EthiopicScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "GeorgianScript", (long) QLocale::Script::GeorgianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "GreekScript", (long) QLocale::Script::GreekScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "GujaratiScript", (long) QLocale::Script::GujaratiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "HebrewScript", (long) QLocale::Script::HebrewScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "JapaneseScript", (long) QLocale::Script::JapaneseScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "KhmerScript", (long) QLocale::Script::KhmerScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "KannadaScript", (long) QLocale::Script::KannadaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "KoreanScript", (long) QLocale::Script::KoreanScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "LaoScript", (long) QLocale::Script::LaoScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "MalayalamScript", (long) QLocale::Script::MalayalamScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "MyanmarScript", (long) QLocale::Script::MyanmarScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "OriyaScript", (long) QLocale::Script::OriyaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TamilScript", (long) QLocale::Script::TamilScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TeluguScript", (long) QLocale::Script::TeluguScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "ThaanaScript", (long) QLocale::Script::ThaanaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "ThaiScript", (long) QLocale::Script::ThaiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TibetanScript", (long) QLocale::Script::TibetanScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "SinhalaScript", (long) QLocale::Script::SinhalaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "SyriacScript", (long) QLocale::Script::SyriacScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "YiScript", (long) QLocale::Script::YiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "VaiScript", (long) QLocale::Script::VaiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "AvestanScript", (long) QLocale::Script::AvestanScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "BalineseScript", (long) QLocale::Script::BalineseScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "BamumScript", (long) QLocale::Script::BamumScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "BatakScript", (long) QLocale::Script::BatakScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "BopomofoScript", (long) QLocale::Script::BopomofoScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "BrahmiScript", (long) QLocale::Script::BrahmiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "BugineseScript", (long) QLocale::Script::BugineseScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "BuhidScript", (long) QLocale::Script::BuhidScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "CanadianAboriginalScript", (long) QLocale::Script::CanadianAboriginalScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "CarianScript", (long) QLocale::Script::CarianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "ChakmaScript", (long) QLocale::Script::ChakmaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "ChamScript", (long) QLocale::Script::ChamScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "CopticScript", (long) QLocale::Script::CopticScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "CypriotScript", (long) QLocale::Script::CypriotScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "EgyptianHieroglyphsScript", (long) QLocale::Script::EgyptianHieroglyphsScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "FraserScript", (long) QLocale::Script::FraserScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "GlagoliticScript", (long) QLocale::Script::GlagoliticScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "GothicScript", (long) QLocale::Script::GothicScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "HanScript", (long) QLocale::Script::HanScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "HangulScript", (long) QLocale::Script::HangulScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "HanunooScript", (long) QLocale::Script::HanunooScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "ImperialAramaicScript", (long) QLocale::Script::ImperialAramaicScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "InscriptionalPahlaviScript", (long) QLocale::Script::InscriptionalPahlaviScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "InscriptionalParthianScript", (long) QLocale::Script::InscriptionalParthianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "JavaneseScript", (long) QLocale::Script::JavaneseScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "KaithiScript", (long) QLocale::Script::KaithiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "KatakanaScript", (long) QLocale::Script::KatakanaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "KayahLiScript", (long) QLocale::Script::KayahLiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "KharoshthiScript", (long) QLocale::Script::KharoshthiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "LannaScript", (long) QLocale::Script::LannaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "LepchaScript", (long) QLocale::Script::LepchaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "LimbuScript", (long) QLocale::Script::LimbuScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "LinearBScript", (long) QLocale::Script::LinearBScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "LycianScript", (long) QLocale::Script::LycianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "LydianScript", (long) QLocale::Script::LydianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "MandaeanScript", (long) QLocale::Script::MandaeanScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "MeiteiMayekScript", (long) QLocale::Script::MeiteiMayekScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "MeroiticScript", (long) QLocale::Script::MeroiticScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "MeroiticCursiveScript", (long) QLocale::Script::MeroiticCursiveScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "NkoScript", (long) QLocale::Script::NkoScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "NewTaiLueScript", (long) QLocale::Script::NewTaiLueScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "OghamScript", (long) QLocale::Script::OghamScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "OlChikiScript", (long) QLocale::Script::OlChikiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "OldItalicScript", (long) QLocale::Script::OldItalicScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "OldPersianScript", (long) QLocale::Script::OldPersianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "OldSouthArabianScript", (long) QLocale::Script::OldSouthArabianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "OrkhonScript", (long) QLocale::Script::OrkhonScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "OsmanyaScript", (long) QLocale::Script::OsmanyaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "PhagsPaScript", (long) QLocale::Script::PhagsPaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "PhoenicianScript", (long) QLocale::Script::PhoenicianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "PollardPhoneticScript", (long) QLocale::Script::PollardPhoneticScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "RejangScript", (long) QLocale::Script::RejangScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "RunicScript", (long) QLocale::Script::RunicScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "SamaritanScript", (long) QLocale::Script::SamaritanScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "SaurashtraScript", (long) QLocale::Script::SaurashtraScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "SharadaScript", (long) QLocale::Script::SharadaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "ShavianScript", (long) QLocale::Script::ShavianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "SoraSompengScript", (long) QLocale::Script::SoraSompengScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "CuneiformScript", (long) QLocale::Script::CuneiformScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "SundaneseScript", (long) QLocale::Script::SundaneseScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "SylotiNagriScript", (long) QLocale::Script::SylotiNagriScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TagalogScript", (long) QLocale::Script::TagalogScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TagbanwaScript", (long) QLocale::Script::TagbanwaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TaiLeScript", (long) QLocale::Script::TaiLeScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TaiVietScript", (long) QLocale::Script::TaiVietScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TakriScript", (long) QLocale::Script::TakriScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "UgariticScript", (long) QLocale::Script::UgariticScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "BrailleScript", (long) QLocale::Script::BrailleScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "HiraganaScript", (long) QLocale::Script::HiraganaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "CaucasianAlbanianScript", (long) QLocale::Script::CaucasianAlbanianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "BassaVahScript", (long) QLocale::Script::BassaVahScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "DuployanScript", (long) QLocale::Script::DuployanScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "ElbasanScript", (long) QLocale::Script::ElbasanScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "GranthaScript", (long) QLocale::Script::GranthaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "PahawhHmongScript", (long) QLocale::Script::PahawhHmongScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "KhojkiScript", (long) QLocale::Script::KhojkiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "LinearAScript", (long) QLocale::Script::LinearAScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "MahajaniScript", (long) QLocale::Script::MahajaniScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "ManichaeanScript", (long) QLocale::Script::ManichaeanScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "MendeKikakuiScript", (long) QLocale::Script::MendeKikakuiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "ModiScript", (long) QLocale::Script::ModiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "MroScript", (long) QLocale::Script::MroScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "OldNorthArabianScript", (long) QLocale::Script::OldNorthArabianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "NabataeanScript", (long) QLocale::Script::NabataeanScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "PalmyreneScript", (long) QLocale::Script::PalmyreneScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "PauCinHauScript", (long) QLocale::Script::PauCinHauScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "OldPermicScript", (long) QLocale::Script::OldPermicScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "PsalterPahlaviScript", (long) QLocale::Script::PsalterPahlaviScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "SiddhamScript", (long) QLocale::Script::SiddhamScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "KhudawadiScript", (long) QLocale::Script::KhudawadiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TirhutaScript", (long) QLocale::Script::TirhutaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "VarangKshitiScript", (long) QLocale::Script::VarangKshitiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "AhomScript", (long) QLocale::Script::AhomScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "AnatolianHieroglyphsScript", (long) QLocale::Script::AnatolianHieroglyphsScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "HatranScript", (long) QLocale::Script::HatranScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "MultaniScript", (long) QLocale::Script::MultaniScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "OldHungarianScript", (long) QLocale::Script::OldHungarianScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "SignWritingScript", (long) QLocale::Script::SignWritingScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "AdlamScript", (long) QLocale::Script::AdlamScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "BhaiksukiScript", (long) QLocale::Script::BhaiksukiScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "MarchenScript", (long) QLocale::Script::MarchenScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "NewaScript", (long) QLocale::Script::NewaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "OsageScript", (long) QLocale::Script::OsageScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TangutScript", (long) QLocale::Script::TangutScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "HanWithBopomofoScript", (long) QLocale::Script::HanWithBopomofoScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "JamoScript", (long) QLocale::Script::JamoScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "SimplifiedChineseScript", (long) QLocale::Script::SimplifiedChineseScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "TraditionalChineseScript", (long) QLocale::Script::TraditionalChineseScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
        Sbk_QLocale_TypeF(), "LastScript", (long) QLocale::Script::LastScript))
        return;
    // Register converter for enum 'QLocale::Script'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX],
            QLocale_Script_CppToPython_QLocale_Script);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocale_Script_PythonToCpp_QLocale_Script,
            is_QLocale_Script_PythonToCpp_QLocale_Script_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_SCRIPT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocale::Script");
        Shiboken::Conversions::registerConverterName(converter, "Script");
    }
    // End of 'Script' enum.

    // Initialization of enum 'Country'.
    SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLocale_TypeF(),
        "Country",
        "2:PySide2.QtCore.QLocale.Country",
        "QLocale::Country");
    if (!SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "AnyCountry", (long) QLocale::Country::AnyCountry))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Afghanistan", (long) QLocale::Country::Afghanistan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Albania", (long) QLocale::Country::Albania))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Algeria", (long) QLocale::Country::Algeria))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "AmericanSamoa", (long) QLocale::Country::AmericanSamoa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Andorra", (long) QLocale::Country::Andorra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Angola", (long) QLocale::Country::Angola))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Anguilla", (long) QLocale::Country::Anguilla))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Antarctica", (long) QLocale::Country::Antarctica))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "AntiguaAndBarbuda", (long) QLocale::Country::AntiguaAndBarbuda))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Argentina", (long) QLocale::Country::Argentina))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Armenia", (long) QLocale::Country::Armenia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Aruba", (long) QLocale::Country::Aruba))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Australia", (long) QLocale::Country::Australia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Austria", (long) QLocale::Country::Austria))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Azerbaijan", (long) QLocale::Country::Azerbaijan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Bahamas", (long) QLocale::Country::Bahamas))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Bahrain", (long) QLocale::Country::Bahrain))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Bangladesh", (long) QLocale::Country::Bangladesh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Barbados", (long) QLocale::Country::Barbados))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Belarus", (long) QLocale::Country::Belarus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Belgium", (long) QLocale::Country::Belgium))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Belize", (long) QLocale::Country::Belize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Benin", (long) QLocale::Country::Benin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Bermuda", (long) QLocale::Country::Bermuda))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Bhutan", (long) QLocale::Country::Bhutan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Bolivia", (long) QLocale::Country::Bolivia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "BosniaAndHerzegowina", (long) QLocale::Country::BosniaAndHerzegowina))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Botswana", (long) QLocale::Country::Botswana))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "BouvetIsland", (long) QLocale::Country::BouvetIsland))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Brazil", (long) QLocale::Country::Brazil))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "BritishIndianOceanTerritory", (long) QLocale::Country::BritishIndianOceanTerritory))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Brunei", (long) QLocale::Country::Brunei))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Bulgaria", (long) QLocale::Country::Bulgaria))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "BurkinaFaso", (long) QLocale::Country::BurkinaFaso))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Burundi", (long) QLocale::Country::Burundi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Cambodia", (long) QLocale::Country::Cambodia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Cameroon", (long) QLocale::Country::Cameroon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Canada", (long) QLocale::Country::Canada))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "CapeVerde", (long) QLocale::Country::CapeVerde))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "CaymanIslands", (long) QLocale::Country::CaymanIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "CentralAfricanRepublic", (long) QLocale::Country::CentralAfricanRepublic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Chad", (long) QLocale::Country::Chad))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Chile", (long) QLocale::Country::Chile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "China", (long) QLocale::Country::China))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "ChristmasIsland", (long) QLocale::Country::ChristmasIsland))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "CocosIslands", (long) QLocale::Country::CocosIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Colombia", (long) QLocale::Country::Colombia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Comoros", (long) QLocale::Country::Comoros))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "CongoKinshasa", (long) QLocale::Country::CongoKinshasa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "CongoBrazzaville", (long) QLocale::Country::CongoBrazzaville))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "CookIslands", (long) QLocale::Country::CookIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "CostaRica", (long) QLocale::Country::CostaRica))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "IvoryCoast", (long) QLocale::Country::IvoryCoast))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Croatia", (long) QLocale::Country::Croatia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Cuba", (long) QLocale::Country::Cuba))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Cyprus", (long) QLocale::Country::Cyprus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "CzechRepublic", (long) QLocale::Country::CzechRepublic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Denmark", (long) QLocale::Country::Denmark))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Djibouti", (long) QLocale::Country::Djibouti))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Dominica", (long) QLocale::Country::Dominica))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "DominicanRepublic", (long) QLocale::Country::DominicanRepublic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "EastTimor", (long) QLocale::Country::EastTimor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Ecuador", (long) QLocale::Country::Ecuador))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Egypt", (long) QLocale::Country::Egypt))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "ElSalvador", (long) QLocale::Country::ElSalvador))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "EquatorialGuinea", (long) QLocale::Country::EquatorialGuinea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Eritrea", (long) QLocale::Country::Eritrea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Estonia", (long) QLocale::Country::Estonia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Ethiopia", (long) QLocale::Country::Ethiopia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "FalklandIslands", (long) QLocale::Country::FalklandIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "FaroeIslands", (long) QLocale::Country::FaroeIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Fiji", (long) QLocale::Country::Fiji))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Finland", (long) QLocale::Country::Finland))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "France", (long) QLocale::Country::France))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Guernsey", (long) QLocale::Country::Guernsey))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "FrenchGuiana", (long) QLocale::Country::FrenchGuiana))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "FrenchPolynesia", (long) QLocale::Country::FrenchPolynesia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "FrenchSouthernTerritories", (long) QLocale::Country::FrenchSouthernTerritories))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Gabon", (long) QLocale::Country::Gabon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Gambia", (long) QLocale::Country::Gambia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Georgia", (long) QLocale::Country::Georgia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Germany", (long) QLocale::Country::Germany))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Ghana", (long) QLocale::Country::Ghana))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Gibraltar", (long) QLocale::Country::Gibraltar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Greece", (long) QLocale::Country::Greece))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Greenland", (long) QLocale::Country::Greenland))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Grenada", (long) QLocale::Country::Grenada))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Guadeloupe", (long) QLocale::Country::Guadeloupe))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Guam", (long) QLocale::Country::Guam))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Guatemala", (long) QLocale::Country::Guatemala))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Guinea", (long) QLocale::Country::Guinea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "GuineaBissau", (long) QLocale::Country::GuineaBissau))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Guyana", (long) QLocale::Country::Guyana))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Haiti", (long) QLocale::Country::Haiti))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "HeardAndMcDonaldIslands", (long) QLocale::Country::HeardAndMcDonaldIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Honduras", (long) QLocale::Country::Honduras))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "HongKong", (long) QLocale::Country::HongKong))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Hungary", (long) QLocale::Country::Hungary))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Iceland", (long) QLocale::Country::Iceland))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "India", (long) QLocale::Country::India))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Indonesia", (long) QLocale::Country::Indonesia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Iran", (long) QLocale::Country::Iran))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Iraq", (long) QLocale::Country::Iraq))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Ireland", (long) QLocale::Country::Ireland))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Israel", (long) QLocale::Country::Israel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Italy", (long) QLocale::Country::Italy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Jamaica", (long) QLocale::Country::Jamaica))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Japan", (long) QLocale::Country::Japan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Jordan", (long) QLocale::Country::Jordan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Kazakhstan", (long) QLocale::Country::Kazakhstan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Kenya", (long) QLocale::Country::Kenya))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Kiribati", (long) QLocale::Country::Kiribati))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "NorthKorea", (long) QLocale::Country::NorthKorea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SouthKorea", (long) QLocale::Country::SouthKorea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Kuwait", (long) QLocale::Country::Kuwait))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Kyrgyzstan", (long) QLocale::Country::Kyrgyzstan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Laos", (long) QLocale::Country::Laos))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Latvia", (long) QLocale::Country::Latvia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Lebanon", (long) QLocale::Country::Lebanon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Lesotho", (long) QLocale::Country::Lesotho))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Liberia", (long) QLocale::Country::Liberia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Libya", (long) QLocale::Country::Libya))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Liechtenstein", (long) QLocale::Country::Liechtenstein))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Lithuania", (long) QLocale::Country::Lithuania))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Luxembourg", (long) QLocale::Country::Luxembourg))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Macau", (long) QLocale::Country::Macau))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Macedonia", (long) QLocale::Country::Macedonia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Madagascar", (long) QLocale::Country::Madagascar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Malawi", (long) QLocale::Country::Malawi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Malaysia", (long) QLocale::Country::Malaysia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Maldives", (long) QLocale::Country::Maldives))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Mali", (long) QLocale::Country::Mali))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Malta", (long) QLocale::Country::Malta))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "MarshallIslands", (long) QLocale::Country::MarshallIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Martinique", (long) QLocale::Country::Martinique))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Mauritania", (long) QLocale::Country::Mauritania))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Mauritius", (long) QLocale::Country::Mauritius))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Mayotte", (long) QLocale::Country::Mayotte))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Mexico", (long) QLocale::Country::Mexico))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Micronesia", (long) QLocale::Country::Micronesia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Moldova", (long) QLocale::Country::Moldova))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Monaco", (long) QLocale::Country::Monaco))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Mongolia", (long) QLocale::Country::Mongolia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Montserrat", (long) QLocale::Country::Montserrat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Morocco", (long) QLocale::Country::Morocco))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Mozambique", (long) QLocale::Country::Mozambique))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Myanmar", (long) QLocale::Country::Myanmar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Namibia", (long) QLocale::Country::Namibia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "NauruCountry", (long) QLocale::Country::NauruCountry))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Nepal", (long) QLocale::Country::Nepal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Netherlands", (long) QLocale::Country::Netherlands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "CuraSao", (long) QLocale::Country::CuraSao))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "NewCaledonia", (long) QLocale::Country::NewCaledonia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "NewZealand", (long) QLocale::Country::NewZealand))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Nicaragua", (long) QLocale::Country::Nicaragua))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Niger", (long) QLocale::Country::Niger))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Nigeria", (long) QLocale::Country::Nigeria))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Niue", (long) QLocale::Country::Niue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "NorfolkIsland", (long) QLocale::Country::NorfolkIsland))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "NorthernMarianaIslands", (long) QLocale::Country::NorthernMarianaIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Norway", (long) QLocale::Country::Norway))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Oman", (long) QLocale::Country::Oman))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Pakistan", (long) QLocale::Country::Pakistan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Palau", (long) QLocale::Country::Palau))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "PalestinianTerritories", (long) QLocale::Country::PalestinianTerritories))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Panama", (long) QLocale::Country::Panama))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "PapuaNewGuinea", (long) QLocale::Country::PapuaNewGuinea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Paraguay", (long) QLocale::Country::Paraguay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Peru", (long) QLocale::Country::Peru))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Philippines", (long) QLocale::Country::Philippines))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Pitcairn", (long) QLocale::Country::Pitcairn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Poland", (long) QLocale::Country::Poland))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Portugal", (long) QLocale::Country::Portugal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "PuertoRico", (long) QLocale::Country::PuertoRico))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Qatar", (long) QLocale::Country::Qatar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Reunion", (long) QLocale::Country::Reunion))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Romania", (long) QLocale::Country::Romania))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Russia", (long) QLocale::Country::Russia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Rwanda", (long) QLocale::Country::Rwanda))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SaintKittsAndNevis", (long) QLocale::Country::SaintKittsAndNevis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SaintLucia", (long) QLocale::Country::SaintLucia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SaintVincentAndTheGrenadines", (long) QLocale::Country::SaintVincentAndTheGrenadines))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Samoa", (long) QLocale::Country::Samoa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SanMarino", (long) QLocale::Country::SanMarino))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SaoTomeAndPrincipe", (long) QLocale::Country::SaoTomeAndPrincipe))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SaudiArabia", (long) QLocale::Country::SaudiArabia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Senegal", (long) QLocale::Country::Senegal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Seychelles", (long) QLocale::Country::Seychelles))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SierraLeone", (long) QLocale::Country::SierraLeone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Singapore", (long) QLocale::Country::Singapore))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Slovakia", (long) QLocale::Country::Slovakia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Slovenia", (long) QLocale::Country::Slovenia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SolomonIslands", (long) QLocale::Country::SolomonIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Somalia", (long) QLocale::Country::Somalia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SouthAfrica", (long) QLocale::Country::SouthAfrica))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SouthGeorgiaAndTheSouthSandwichIslands", (long) QLocale::Country::SouthGeorgiaAndTheSouthSandwichIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Spain", (long) QLocale::Country::Spain))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SriLanka", (long) QLocale::Country::SriLanka))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SaintHelena", (long) QLocale::Country::SaintHelena))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SaintPierreAndMiquelon", (long) QLocale::Country::SaintPierreAndMiquelon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Sudan", (long) QLocale::Country::Sudan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Suriname", (long) QLocale::Country::Suriname))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SvalbardAndJanMayenIslands", (long) QLocale::Country::SvalbardAndJanMayenIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Swaziland", (long) QLocale::Country::Swaziland))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Sweden", (long) QLocale::Country::Sweden))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Switzerland", (long) QLocale::Country::Switzerland))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Syria", (long) QLocale::Country::Syria))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Taiwan", (long) QLocale::Country::Taiwan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Tajikistan", (long) QLocale::Country::Tajikistan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Tanzania", (long) QLocale::Country::Tanzania))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Thailand", (long) QLocale::Country::Thailand))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Togo", (long) QLocale::Country::Togo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "TokelauCountry", (long) QLocale::Country::TokelauCountry))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Tonga", (long) QLocale::Country::Tonga))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "TrinidadAndTobago", (long) QLocale::Country::TrinidadAndTobago))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Tunisia", (long) QLocale::Country::Tunisia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Turkey", (long) QLocale::Country::Turkey))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Turkmenistan", (long) QLocale::Country::Turkmenistan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "TurksAndCaicosIslands", (long) QLocale::Country::TurksAndCaicosIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "TuvaluCountry", (long) QLocale::Country::TuvaluCountry))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Uganda", (long) QLocale::Country::Uganda))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Ukraine", (long) QLocale::Country::Ukraine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "UnitedArabEmirates", (long) QLocale::Country::UnitedArabEmirates))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "UnitedKingdom", (long) QLocale::Country::UnitedKingdom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "UnitedStates", (long) QLocale::Country::UnitedStates))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "UnitedStatesMinorOutlyingIslands", (long) QLocale::Country::UnitedStatesMinorOutlyingIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Uruguay", (long) QLocale::Country::Uruguay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Uzbekistan", (long) QLocale::Country::Uzbekistan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Vanuatu", (long) QLocale::Country::Vanuatu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "VaticanCityState", (long) QLocale::Country::VaticanCityState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Venezuela", (long) QLocale::Country::Venezuela))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Vietnam", (long) QLocale::Country::Vietnam))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "BritishVirginIslands", (long) QLocale::Country::BritishVirginIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "UnitedStatesVirginIslands", (long) QLocale::Country::UnitedStatesVirginIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "WallisAndFutunaIslands", (long) QLocale::Country::WallisAndFutunaIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "WesternSahara", (long) QLocale::Country::WesternSahara))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Yemen", (long) QLocale::Country::Yemen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "CanaryIslands", (long) QLocale::Country::CanaryIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Zambia", (long) QLocale::Country::Zambia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Zimbabwe", (long) QLocale::Country::Zimbabwe))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "ClippertonIsland", (long) QLocale::Country::ClippertonIsland))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Montenegro", (long) QLocale::Country::Montenegro))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Serbia", (long) QLocale::Country::Serbia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SaintBarthelemy", (long) QLocale::Country::SaintBarthelemy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SaintMartin", (long) QLocale::Country::SaintMartin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "LatinAmerica", (long) QLocale::Country::LatinAmerica))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "AscensionIsland", (long) QLocale::Country::AscensionIsland))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "AlandIslands", (long) QLocale::Country::AlandIslands))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "DiegoGarcia", (long) QLocale::Country::DiegoGarcia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "CeutaAndMelilla", (long) QLocale::Country::CeutaAndMelilla))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "IsleOfMan", (long) QLocale::Country::IsleOfMan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Jersey", (long) QLocale::Country::Jersey))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "TristanDaCunha", (long) QLocale::Country::TristanDaCunha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SouthSudan", (long) QLocale::Country::SouthSudan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Bonaire", (long) QLocale::Country::Bonaire))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SintMaarten", (long) QLocale::Country::SintMaarten))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Kosovo", (long) QLocale::Country::Kosovo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "EuropeanUnion", (long) QLocale::Country::EuropeanUnion))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "OutlyingOceania", (long) QLocale::Country::OutlyingOceania))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "World", (long) QLocale::Country::World))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Europe", (long) QLocale::Country::Europe))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "DemocraticRepublicOfCongo", (long) QLocale::Country::DemocraticRepublicOfCongo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "DemocraticRepublicOfKorea", (long) QLocale::Country::DemocraticRepublicOfKorea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "LatinAmericaAndTheCaribbean", (long) QLocale::Country::LatinAmericaAndTheCaribbean))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "PeoplesRepublicOfCongo", (long) QLocale::Country::PeoplesRepublicOfCongo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "RepublicOfKorea", (long) QLocale::Country::RepublicOfKorea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "RussianFederation", (long) QLocale::Country::RussianFederation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "SyrianArabRepublic", (long) QLocale::Country::SyrianArabRepublic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Tokelau", (long) QLocale::Country::Tokelau))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "Tuvalu", (long) QLocale::Country::Tuvalu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
        Sbk_QLocale_TypeF(), "LastCountry", (long) QLocale::Country::LastCountry))
        return;
    // Register converter for enum 'QLocale::Country'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX],
            QLocale_Country_CppToPython_QLocale_Country);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocale_Country_PythonToCpp_QLocale_Country,
            is_QLocale_Country_PythonToCpp_QLocale_Country_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocale::Country");
        Shiboken::Conversions::registerConverterName(converter, "Country");
    }
    // End of 'Country' enum.

    // Initialization of enum 'MeasurementSystem'.
    SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLocale_TypeF(),
        "MeasurementSystem",
        "2:PySide2.QtCore.QLocale.MeasurementSystem",
        "QLocale::MeasurementSystem");
    if (!SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX],
        Sbk_QLocale_TypeF(), "MetricSystem", (long) QLocale::MeasurementSystem::MetricSystem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX],
        Sbk_QLocale_TypeF(), "ImperialUSSystem", (long) QLocale::MeasurementSystem::ImperialUSSystem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX],
        Sbk_QLocale_TypeF(), "ImperialUKSystem", (long) QLocale::MeasurementSystem::ImperialUKSystem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX],
        Sbk_QLocale_TypeF(), "ImperialSystem", (long) QLocale::MeasurementSystem::ImperialSystem))
        return;
    // Register converter for enum 'QLocale::MeasurementSystem'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX],
            QLocale_MeasurementSystem_CppToPython_QLocale_MeasurementSystem);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocale_MeasurementSystem_PythonToCpp_QLocale_MeasurementSystem,
            is_QLocale_MeasurementSystem_PythonToCpp_QLocale_MeasurementSystem_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocale::MeasurementSystem");
        Shiboken::Conversions::registerConverterName(converter, "MeasurementSystem");
    }
    // End of 'MeasurementSystem' enum.

    // Initialization of enum 'FormatType'.
    SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLocale_TypeF(),
        "FormatType",
        "2:PySide2.QtCore.QLocale.FormatType",
        "QLocale::FormatType");
    if (!SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX],
        Sbk_QLocale_TypeF(), "LongFormat", (long) QLocale::FormatType::LongFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX],
        Sbk_QLocale_TypeF(), "ShortFormat", (long) QLocale::FormatType::ShortFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX],
        Sbk_QLocale_TypeF(), "NarrowFormat", (long) QLocale::FormatType::NarrowFormat))
        return;
    // Register converter for enum 'QLocale::FormatType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX],
            QLocale_FormatType_CppToPython_QLocale_FormatType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocale_FormatType_PythonToCpp_QLocale_FormatType,
            is_QLocale_FormatType_PythonToCpp_QLocale_FormatType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocale::FormatType");
        Shiboken::Conversions::registerConverterName(converter, "FormatType");
    }
    // End of 'FormatType' enum.

    // Initialization of enum 'NumberOption'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QLocale.NumberOptions", SbkPySide2_QtCore_QLocale_NumberOption_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLocale_TypeF(),
        "NumberOption",
        "2:PySide2.QtCore.QLocale.NumberOption",
        "QLocale::NumberOption",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX],
        Sbk_QLocale_TypeF(), "DefaultNumberOptions", (long) QLocale::NumberOption::DefaultNumberOptions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX],
        Sbk_QLocale_TypeF(), "OmitGroupSeparator", (long) QLocale::NumberOption::OmitGroupSeparator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX],
        Sbk_QLocale_TypeF(), "RejectGroupSeparator", (long) QLocale::NumberOption::RejectGroupSeparator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX],
        Sbk_QLocale_TypeF(), "OmitLeadingZeroInExponent", (long) QLocale::NumberOption::OmitLeadingZeroInExponent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX],
        Sbk_QLocale_TypeF(), "RejectLeadingZeroInExponent", (long) QLocale::NumberOption::RejectLeadingZeroInExponent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX],
        Sbk_QLocale_TypeF(), "IncludeTrailingZeroesAfterDot", (long) QLocale::NumberOption::IncludeTrailingZeroesAfterDot))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX],
        Sbk_QLocale_TypeF(), "RejectTrailingZeroesAfterDot", (long) QLocale::NumberOption::RejectTrailingZeroesAfterDot))
        return;
    // Register converter for enum 'QLocale::NumberOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX],
            QLocale_NumberOption_CppToPython_QLocale_NumberOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocale_NumberOption_PythonToCpp_QLocale_NumberOption,
            is_QLocale_NumberOption_PythonToCpp_QLocale_NumberOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocale::NumberOption");
        Shiboken::Conversions::registerConverterName(converter, "NumberOption");
    }
    // Register converter for flag 'QFlags<QLocale::NumberOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX],
            QFlags_QLocale_NumberOption__CppToPython_QFlags_QLocale_NumberOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocale_NumberOption_PythonToCpp_QFlags_QLocale_NumberOption_,
            is_QLocale_NumberOption_PythonToCpp_QFlags_QLocale_NumberOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QLocale_NumberOption__PythonToCpp_QFlags_QLocale_NumberOption_,
            is_QFlags_QLocale_NumberOption__PythonToCpp_QFlags_QLocale_NumberOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QLocale_NumberOption_,
            is_number_PythonToCpp_QFlags_QLocale_NumberOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocale::NumberOptions");
        Shiboken::Conversions::registerConverterName(converter, "NumberOptions");
    }
    // End of 'NumberOption' enum/flags.

    // Initialization of enum 'FloatingPointPrecisionOption'.
    SbkPySide2_QtCoreTypes[SBK_QLOCALE_FLOATINGPOINTPRECISIONOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLocale_TypeF(),
        "FloatingPointPrecisionOption",
        "2:PySide2.QtCore.QLocale.FloatingPointPrecisionOption",
        "QLocale::FloatingPointPrecisionOption");
    if (!SbkPySide2_QtCoreTypes[SBK_QLOCALE_FLOATINGPOINTPRECISIONOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FLOATINGPOINTPRECISIONOPTION_IDX],
        Sbk_QLocale_TypeF(), "FloatingPointShortest", (long) QLocale::FloatingPointPrecisionOption::FloatingPointShortest))
        return;
    // Register converter for enum 'QLocale::FloatingPointPrecisionOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FLOATINGPOINTPRECISIONOPTION_IDX],
            QLocale_FloatingPointPrecisionOption_CppToPython_QLocale_FloatingPointPrecisionOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocale_FloatingPointPrecisionOption_PythonToCpp_QLocale_FloatingPointPrecisionOption,
            is_QLocale_FloatingPointPrecisionOption_PythonToCpp_QLocale_FloatingPointPrecisionOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_FLOATINGPOINTPRECISIONOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocale::FloatingPointPrecisionOption");
        Shiboken::Conversions::registerConverterName(converter, "FloatingPointPrecisionOption");
    }
    // End of 'FloatingPointPrecisionOption' enum.

    // Initialization of enum 'CurrencySymbolFormat'.
    SbkPySide2_QtCoreTypes[SBK_QLOCALE_CURRENCYSYMBOLFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLocale_TypeF(),
        "CurrencySymbolFormat",
        "2:PySide2.QtCore.QLocale.CurrencySymbolFormat",
        "QLocale::CurrencySymbolFormat");
    if (!SbkPySide2_QtCoreTypes[SBK_QLOCALE_CURRENCYSYMBOLFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_CURRENCYSYMBOLFORMAT_IDX],
        Sbk_QLocale_TypeF(), "CurrencyIsoCode", (long) QLocale::CurrencySymbolFormat::CurrencyIsoCode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_CURRENCYSYMBOLFORMAT_IDX],
        Sbk_QLocale_TypeF(), "CurrencySymbol", (long) QLocale::CurrencySymbolFormat::CurrencySymbol))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_CURRENCYSYMBOLFORMAT_IDX],
        Sbk_QLocale_TypeF(), "CurrencyDisplayName", (long) QLocale::CurrencySymbolFormat::CurrencyDisplayName))
        return;
    // Register converter for enum 'QLocale::CurrencySymbolFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_CURRENCYSYMBOLFORMAT_IDX],
            QLocale_CurrencySymbolFormat_CppToPython_QLocale_CurrencySymbolFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocale_CurrencySymbolFormat_PythonToCpp_QLocale_CurrencySymbolFormat,
            is_QLocale_CurrencySymbolFormat_PythonToCpp_QLocale_CurrencySymbolFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_CURRENCYSYMBOLFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocale::CurrencySymbolFormat");
        Shiboken::Conversions::registerConverterName(converter, "CurrencySymbolFormat");
    }
    // End of 'CurrencySymbolFormat' enum.

    // Initialization of enum 'DataSizeFormat'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QLocale.DataSizeFormats", SbkPySide2_QtCore_QLocale_DataSizeFormat_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLocale_TypeF(),
        "DataSizeFormat",
        "2:PySide2.QtCore.QLocale.DataSizeFormat",
        "QLocale::DataSizeFormat",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX],
        Sbk_QLocale_TypeF(), "DataSizeBase1000", (long) QLocale::DataSizeFormat::DataSizeBase1000))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX],
        Sbk_QLocale_TypeF(), "DataSizeSIQuantifiers", (long) QLocale::DataSizeFormat::DataSizeSIQuantifiers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX],
        Sbk_QLocale_TypeF(), "DataSizeIecFormat", (long) QLocale::DataSizeFormat::DataSizeIecFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX],
        Sbk_QLocale_TypeF(), "DataSizeTraditionalFormat", (long) QLocale::DataSizeFormat::DataSizeTraditionalFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX],
        Sbk_QLocale_TypeF(), "DataSizeSIFormat", (long) QLocale::DataSizeFormat::DataSizeSIFormat))
        return;
    // Register converter for enum 'QLocale::DataSizeFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX],
            QLocale_DataSizeFormat_CppToPython_QLocale_DataSizeFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocale_DataSizeFormat_PythonToCpp_QLocale_DataSizeFormat,
            is_QLocale_DataSizeFormat_PythonToCpp_QLocale_DataSizeFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_DATASIZEFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocale::DataSizeFormat");
        Shiboken::Conversions::registerConverterName(converter, "DataSizeFormat");
    }
    // Register converter for flag 'QFlags<QLocale::DataSizeFormat>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX],
            QFlags_QLocale_DataSizeFormat__CppToPython_QFlags_QLocale_DataSizeFormat_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocale_DataSizeFormat_PythonToCpp_QFlags_QLocale_DataSizeFormat_,
            is_QLocale_DataSizeFormat_PythonToCpp_QFlags_QLocale_DataSizeFormat__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QLocale_DataSizeFormat__PythonToCpp_QFlags_QLocale_DataSizeFormat_,
            is_QFlags_QLocale_DataSizeFormat__PythonToCpp_QFlags_QLocale_DataSizeFormat__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QLocale_DataSizeFormat_,
            is_number_PythonToCpp_QFlags_QLocale_DataSizeFormat__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QLOCALE_DATASIZEFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocale::DataSizeFormats");
        Shiboken::Conversions::registerConverterName(converter, "DataSizeFormats");
    }
    // End of 'DataSizeFormat' enum/flags.

    // Initialization of enum 'QuotationStyle'.
    SbkPySide2_QtCoreTypes[SBK_QLOCALE_QUOTATIONSTYLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLocale_TypeF(),
        "QuotationStyle",
        "2:PySide2.QtCore.QLocale.QuotationStyle",
        "QLocale::QuotationStyle");
    if (!SbkPySide2_QtCoreTypes[SBK_QLOCALE_QUOTATIONSTYLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_QUOTATIONSTYLE_IDX],
        Sbk_QLocale_TypeF(), "StandardQuotation", (long) QLocale::QuotationStyle::StandardQuotation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCALE_QUOTATIONSTYLE_IDX],
        Sbk_QLocale_TypeF(), "AlternateQuotation", (long) QLocale::QuotationStyle::AlternateQuotation))
        return;
    // Register converter for enum 'QLocale::QuotationStyle'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_QUOTATIONSTYLE_IDX],
            QLocale_QuotationStyle_CppToPython_QLocale_QuotationStyle);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocale_QuotationStyle_PythonToCpp_QLocale_QuotationStyle,
            is_QLocale_QuotationStyle_PythonToCpp_QLocale_QuotationStyle_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLOCALE_QUOTATIONSTYLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocale::QuotationStyle");
        Shiboken::Conversions::registerConverterName(converter, "QuotationStyle");
    }
    // End of 'QuotationStyle' enum.

    qRegisterMetaType< ::QLocale >("QLocale");
    qRegisterMetaType< ::QLocale::Language >("QLocale::Language");
    qRegisterMetaType< ::QLocale::Script >("QLocale::Script");
    qRegisterMetaType< ::QLocale::Country >("QLocale::Country");
    qRegisterMetaType< ::QLocale::MeasurementSystem >("QLocale::MeasurementSystem");
    qRegisterMetaType< ::QLocale::FormatType >("QLocale::FormatType");
    qRegisterMetaType< ::QLocale::NumberOption >("QLocale::NumberOption");
    qRegisterMetaType< ::QLocale::NumberOptions >("QLocale::NumberOptions");
    qRegisterMetaType< ::QLocale::FloatingPointPrecisionOption >("QLocale::FloatingPointPrecisionOption");
    qRegisterMetaType< ::QLocale::CurrencySymbolFormat >("QLocale::CurrencySymbolFormat");
    qRegisterMetaType< ::QLocale::DataSizeFormat >("QLocale::DataSizeFormat");
    qRegisterMetaType< ::QLocale::DataSizeFormats >("QLocale::DataSizeFormats");
    qRegisterMetaType< ::QLocale::QuotationStyle >("QLocale::QuotationStyle");
}
