/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qmimedatabase_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qfileinfo.h>
#include <qiodevice.h>
#include <qmimetype.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMimeDatabase_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMimeDatabase >()))
        return -1;

    ::QMimeDatabase *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeDatabase.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QMimeDatabase()
            cptr = new ::QMimeDatabase();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMimeDatabase >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QMimeDatabaseFunc_allMimeTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeDatabase.allMimeTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allMimeTypes()const
            QList<QMimeType > cppResult = const_cast<const ::QMimeDatabase *>(cppSelf)->allMimeTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QMIMETYPE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMimeDatabaseFunc_mimeTypeForData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeDatabase.mimeTypeForData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMimeDatabase::mimeTypeForData(QIODevice*)const
    // 1: QMimeDatabase::mimeTypeForData(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 1; // mimeTypeForData(QByteArray)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // mimeTypeForData(QIODevice*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMimeDatabaseFunc_mimeTypeForData_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // mimeTypeForData(QIODevice * device) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // mimeTypeForData(QIODevice*)const
                QMimeType cppResult = const_cast<const ::QMimeDatabase *>(cppSelf)->mimeTypeForData(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // mimeTypeForData(const QByteArray & data) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // mimeTypeForData(QByteArray)const
                QMimeType cppResult = const_cast<const ::QMimeDatabase *>(cppSelf)->mimeTypeForData(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMimeDatabaseFunc_mimeTypeForData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMimeDatabaseFunc_mimeTypeForFile(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeDatabase.mimeTypeForFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMimeDatabaseFunc_mimeTypeForFile_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QMimeDatabaseFunc_mimeTypeForFile_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:mimeTypeForFile", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMimeDatabase::mimeTypeForFile(QFileInfo,QMimeDatabase::MatchMode)const
    // 1: QMimeDatabase::mimeTypeForFile(QString,QMimeDatabase::MatchMode)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // mimeTypeForFile(QString,QMimeDatabase::MatchMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // mimeTypeForFile(QString,QMimeDatabase::MatchMode)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // mimeTypeForFile(QFileInfo,QMimeDatabase::MatchMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // mimeTypeForFile(QFileInfo,QMimeDatabase::MatchMode)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMimeDatabaseFunc_mimeTypeForFile_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // mimeTypeForFile(const QFileInfo & fileInfo, QMimeDatabase::MatchMode mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QMimeDatabaseFunc_mimeTypeForFile_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QMimeDatabaseFunc_mimeTypeForFile_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMimeDatabaseFunc_mimeTypeForFile_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QFileInfo cppArg0_local;
            ::QFileInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QMimeDatabase::MatchMode cppArg1 = QMimeDatabase::MatchMode::MatchDefault;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // mimeTypeForFile(QFileInfo,QMimeDatabase::MatchMode)const
                QMimeType cppResult = const_cast<const ::QMimeDatabase *>(cppSelf)->mimeTypeForFile(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // mimeTypeForFile(const QString & fileName, QMimeDatabase::MatchMode mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QMimeDatabaseFunc_mimeTypeForFile_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QMimeDatabaseFunc_mimeTypeForFile_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMimeDatabaseFunc_mimeTypeForFile_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QMimeDatabase::MatchMode cppArg1 = QMimeDatabase::MatchMode::MatchDefault;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // mimeTypeForFile(QString,QMimeDatabase::MatchMode)const
                QMimeType cppResult = const_cast<const ::QMimeDatabase *>(cppSelf)->mimeTypeForFile(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMimeDatabaseFunc_mimeTypeForFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMimeDatabaseFunc_mimeTypeForFileNameAndData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeDatabase.mimeTypeForFileNameAndData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "mimeTypeForFileNameAndData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMimeDatabase::mimeTypeForFileNameAndData(QString,QIODevice*)const
    // 1: QMimeDatabase::mimeTypeForFileNameAndData(QString,QByteArray)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 1; // mimeTypeForFileNameAndData(QString,QByteArray)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[1])))) {
            overloadId = 0; // mimeTypeForFileNameAndData(QString,QIODevice*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMimeDatabaseFunc_mimeTypeForFileNameAndData_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // mimeTypeForFileNameAndData(const QString & fileName, QIODevice * device) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QIODevice *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // mimeTypeForFileNameAndData(QString,QIODevice*)const
                QMimeType cppResult = const_cast<const ::QMimeDatabase *>(cppSelf)->mimeTypeForFileNameAndData(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // mimeTypeForFileNameAndData(const QString & fileName, const QByteArray & data) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // mimeTypeForFileNameAndData(QString,QByteArray)const
                QMimeType cppResult = const_cast<const ::QMimeDatabase *>(cppSelf)->mimeTypeForFileNameAndData(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMimeDatabaseFunc_mimeTypeForFileNameAndData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMimeDatabaseFunc_mimeTypeForName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeDatabase.mimeTypeForName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMimeDatabase::mimeTypeForName(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // mimeTypeForName(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMimeDatabaseFunc_mimeTypeForName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mimeTypeForName(QString)const
            QMimeType cppResult = const_cast<const ::QMimeDatabase *>(cppSelf)->mimeTypeForName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMimeDatabaseFunc_mimeTypeForName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMimeDatabaseFunc_mimeTypeForUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeDatabase.mimeTypeForUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMimeDatabase::mimeTypeForUrl(QUrl)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // mimeTypeForUrl(QUrl)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMimeDatabaseFunc_mimeTypeForUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mimeTypeForUrl(QUrl)const
            QMimeType cppResult = const_cast<const ::QMimeDatabase *>(cppSelf)->mimeTypeForUrl(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMETYPE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMimeDatabaseFunc_mimeTypeForUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMimeDatabaseFunc_mimeTypesForFileName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeDatabase.mimeTypesForFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMimeDatabase::mimeTypesForFileName(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // mimeTypesForFileName(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMimeDatabaseFunc_mimeTypesForFileName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mimeTypesForFileName(QString)const
            QList<QMimeType > cppResult = const_cast<const ::QMimeDatabase *>(cppSelf)->mimeTypesForFileName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QMIMETYPE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMimeDatabaseFunc_mimeTypesForFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMimeDatabaseFunc_suffixForFileName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMimeDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QMimeDatabase.suffixForFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMimeDatabase::suffixForFileName(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // suffixForFileName(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMimeDatabaseFunc_suffixForFileName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // suffixForFileName(QString)const
            QString cppResult = const_cast<const ::QMimeDatabase *>(cppSelf)->suffixForFileName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMimeDatabaseFunc_suffixForFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QMimeDatabase_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMimeDatabase_methods[] = {
    {"allMimeTypes", reinterpret_cast<PyCFunction>(Sbk_QMimeDatabaseFunc_allMimeTypes), METH_NOARGS},
    {"mimeTypeForData", reinterpret_cast<PyCFunction>(Sbk_QMimeDatabaseFunc_mimeTypeForData), METH_O},
    {"mimeTypeForFile", reinterpret_cast<PyCFunction>(Sbk_QMimeDatabaseFunc_mimeTypeForFile), METH_VARARGS|METH_KEYWORDS},
    {"mimeTypeForFileNameAndData", reinterpret_cast<PyCFunction>(Sbk_QMimeDatabaseFunc_mimeTypeForFileNameAndData), METH_VARARGS},
    {"mimeTypeForName", reinterpret_cast<PyCFunction>(Sbk_QMimeDatabaseFunc_mimeTypeForName), METH_O},
    {"mimeTypeForUrl", reinterpret_cast<PyCFunction>(Sbk_QMimeDatabaseFunc_mimeTypeForUrl), METH_O},
    {"mimeTypesForFileName", reinterpret_cast<PyCFunction>(Sbk_QMimeDatabaseFunc_mimeTypesForFileName), METH_O},
    {"suffixForFileName", reinterpret_cast<PyCFunction>(Sbk_QMimeDatabaseFunc_suffixForFileName), METH_O},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QMimeDatabase_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMimeDatabase_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMimeDatabase_Type = nullptr;
static SbkObjectType *Sbk_QMimeDatabase_TypeF(void)
{
    return _Sbk_QMimeDatabase_Type;
}

static PyType_Slot Sbk_QMimeDatabase_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMimeDatabase_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMimeDatabase_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMimeDatabase_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMimeDatabase_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMimeDatabase_spec = {
    "2:PySide2.QtCore.QMimeDatabase",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMimeDatabase_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QMimeDatabase_MatchMode_PythonToCpp_QMimeDatabase_MatchMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMimeDatabase::MatchMode *>(cppOut) =
        static_cast<::QMimeDatabase::MatchMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMimeDatabase_MatchMode_PythonToCpp_QMimeDatabase_MatchMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX]))
        return QMimeDatabase_MatchMode_PythonToCpp_QMimeDatabase_MatchMode;
    return {};
}
static PyObject *QMimeDatabase_MatchMode_CppToPython_QMimeDatabase_MatchMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMimeDatabase::MatchMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMimeDatabase_PythonToCpp_QMimeDatabase_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMimeDatabase_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMimeDatabase_PythonToCpp_QMimeDatabase_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMimeDatabase_TypeF())))
        return QMimeDatabase_PythonToCpp_QMimeDatabase_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMimeDatabase_PTR_CppToPython_QMimeDatabase(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMimeDatabase *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMimeDatabase_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMimeDatabase_SignatureStrings[] = {
    "PySide2.QtCore.QMimeDatabase(self)",
    "PySide2.QtCore.QMimeDatabase.allMimeTypes(self)->QList[PySide2.QtCore.QMimeType]",
    "1:PySide2.QtCore.QMimeDatabase.mimeTypeForData(self,device:PySide2.QtCore.QIODevice)->PySide2.QtCore.QMimeType",
    "0:PySide2.QtCore.QMimeDatabase.mimeTypeForData(self,data:PySide2.QtCore.QByteArray)->PySide2.QtCore.QMimeType",
    "1:PySide2.QtCore.QMimeDatabase.mimeTypeForFile(self,fileInfo:PySide2.QtCore.QFileInfo,mode:PySide2.QtCore.QMimeDatabase.MatchMode=MatchDefault)->PySide2.QtCore.QMimeType",
    "0:PySide2.QtCore.QMimeDatabase.mimeTypeForFile(self,fileName:QString,mode:PySide2.QtCore.QMimeDatabase.MatchMode=MatchDefault)->PySide2.QtCore.QMimeType",
    "1:PySide2.QtCore.QMimeDatabase.mimeTypeForFileNameAndData(self,fileName:QString,device:PySide2.QtCore.QIODevice)->PySide2.QtCore.QMimeType",
    "0:PySide2.QtCore.QMimeDatabase.mimeTypeForFileNameAndData(self,fileName:QString,data:PySide2.QtCore.QByteArray)->PySide2.QtCore.QMimeType",
    "PySide2.QtCore.QMimeDatabase.mimeTypeForName(self,nameOrAlias:QString)->PySide2.QtCore.QMimeType",
    "PySide2.QtCore.QMimeDatabase.mimeTypeForUrl(self,url:PySide2.QtCore.QUrl)->PySide2.QtCore.QMimeType",
    "PySide2.QtCore.QMimeDatabase.mimeTypesForFileName(self,fileName:QString)->QList[PySide2.QtCore.QMimeType]",
    "PySide2.QtCore.QMimeDatabase.suffixForFileName(self,fileName:QString)->QString",
    nullptr}; // Sentinel

void init_QMimeDatabase(PyObject *module)
{
    _Sbk_QMimeDatabase_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMimeDatabase",
        "QMimeDatabase*",
        &Sbk_QMimeDatabase_spec,
        &Shiboken::callCppDestructor< ::QMimeDatabase >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMimeDatabase_Type);
    InitSignatureStrings(pyType, QMimeDatabase_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMimeDatabase_Type), Sbk_QMimeDatabase_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMimeDatabase_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMimeDatabase_TypeF(),
        QMimeDatabase_PythonToCpp_QMimeDatabase_PTR,
        is_QMimeDatabase_PythonToCpp_QMimeDatabase_PTR_Convertible,
        QMimeDatabase_PTR_CppToPython_QMimeDatabase);

    Shiboken::Conversions::registerConverterName(converter, "QMimeDatabase");
    Shiboken::Conversions::registerConverterName(converter, "QMimeDatabase*");
    Shiboken::Conversions::registerConverterName(converter, "QMimeDatabase&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMimeDatabase).name());


    // Initialization of enums.

    // Initialization of enum 'MatchMode'.
    SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMimeDatabase_TypeF(),
        "MatchMode",
        "2:PySide2.QtCore.QMimeDatabase.MatchMode",
        "QMimeDatabase::MatchMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX],
        Sbk_QMimeDatabase_TypeF(), "MatchDefault", (long) QMimeDatabase::MatchMode::MatchDefault))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX],
        Sbk_QMimeDatabase_TypeF(), "MatchExtension", (long) QMimeDatabase::MatchMode::MatchExtension))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX],
        Sbk_QMimeDatabase_TypeF(), "MatchContent", (long) QMimeDatabase::MatchMode::MatchContent))
        return;
    // Register converter for enum 'QMimeDatabase::MatchMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX],
            QMimeDatabase_MatchMode_CppToPython_QMimeDatabase_MatchMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMimeDatabase_MatchMode_PythonToCpp_QMimeDatabase_MatchMode,
            is_QMimeDatabase_MatchMode_PythonToCpp_QMimeDatabase_MatchMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QMIMEDATABASE_MATCHMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMimeDatabase::MatchMode");
        Shiboken::Conversions::registerConverterName(converter, "MatchMode");
    }
    // End of 'MatchMode' enum.

    qRegisterMetaType< ::QMimeDatabase::MatchMode >("QMimeDatabase::MatchMode");
}
