/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qmodelindex_wrapper.h"

// inner classes

// Extra includes
#include <qabstractitemmodel.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QModelIndex_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QModelIndex >()))
        return -1;

    ::QModelIndex *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QModelIndex", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QModelIndex::QModelIndex()
    // 1: QModelIndex::QModelIndex(QModelIndex)
    if (numArgs == 0) {
        overloadId = 0; // QModelIndex()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QModelIndex(QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QModelIndex_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QModelIndex()
        {

            if (!PyErr_Occurred()) {
                // QModelIndex()
                cptr = new ::QModelIndex();
            }
            break;
        }
        case 1: // QModelIndex(const QModelIndex & QModelIndex)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QModelIndex cppArg0_local;
            ::QModelIndex *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QModelIndex(QModelIndex)
                cptr = new ::QModelIndex(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QModelIndex >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QModelIndex_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QModelIndex_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QModelIndexFunc_child(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.child";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "child", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QModelIndex::child(int,int)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // child(int,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QModelIndexFunc_child_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // child(int,int)const
            QModelIndex cppResult = const_cast<const ::QModelIndex *>(cppSelf)->child(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QModelIndexFunc_child_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QModelIndexFunc_column(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.column";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // column()const
            int cppResult = const_cast<const ::QModelIndex *>(cppSelf)->column();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QModelIndexFunc_data(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.data";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QModelIndexFunc_data_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:data", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QModelIndex::data(int)const
    if (numArgs == 0) {
        overloadId = 0; // data(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // data(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QModelIndexFunc_data_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_role = Shiboken::String::createStaticString("role");
            if (PyDict_Contains(kwds, key_role)) {
                value = PyDict_GetItem(kwds, key_role);
                if (value && pyArgs[0]) {
                    errInfo = key_role;
                    Py_INCREF(errInfo);
                    goto Sbk_QModelIndexFunc_data_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QModelIndexFunc_data_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_role);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QModelIndexFunc_data_TypeError;
            }
        }
        int cppArg0 = Qt::DisplayRole;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // data(int)const
            QVariant cppResult = const_cast<const ::QModelIndex *>(cppSelf)->data(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QModelIndexFunc_data_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QModelIndexFunc_flags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.flags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flags()const
            QFlags<Qt::ItemFlag> cppResult = const_cast<const ::QModelIndex *>(cppSelf)->flags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QModelIndexFunc_internalId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.internalId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // internalId()const
            quintptr cppResult = const_cast<const ::QModelIndex *>(cppSelf)->internalId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QUINTPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QModelIndexFunc_internalPointer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.internalPointer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // internalPointer()const
            // Begin code injection
            // TEMPLATE - return_internal_pointer - START
            pyResult = reinterpret_cast<PyObject*>(cppSelf->internalPointer());
            if (!pyResult)
                pyResult = Py_None;
            Py_INCREF(pyResult);
            // TEMPLATE - return_internal_pointer - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QModelIndexFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QModelIndex *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QModelIndexFunc_model(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.model";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // model()const
            const QAbstractItemModel * cppResult = const_cast<const ::QModelIndex *>(cppSelf)->model();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QModelIndexFunc_parent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.parent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parent()const
            QModelIndex cppResult = const_cast<const ::QModelIndex *>(cppSelf)->parent();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QModelIndexFunc_row(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.row";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // row()const
            int cppResult = const_cast<const ::QModelIndex *>(cppSelf)->row();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QModelIndexFunc_sibling(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.sibling";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "sibling", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QModelIndex::sibling(int,int)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // sibling(int,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QModelIndexFunc_sibling_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // sibling(int,int)const
            QModelIndex cppResult = const_cast<const ::QModelIndex *>(cppSelf)->sibling(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QModelIndexFunc_sibling_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QModelIndexFunc_siblingAtColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.siblingAtColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QModelIndex::siblingAtColumn(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // siblingAtColumn(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QModelIndexFunc_siblingAtColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // siblingAtColumn(int)const
            QModelIndex cppResult = const_cast<const ::QModelIndex *>(cppSelf)->siblingAtColumn(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QModelIndexFunc_siblingAtColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QModelIndexFunc_siblingAtRow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QModelIndex.siblingAtRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QModelIndex::siblingAtRow(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // siblingAtRow(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QModelIndexFunc_siblingAtRow_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // siblingAtRow(int)const
            QModelIndex cppResult = const_cast<const ::QModelIndex *>(cppSelf)->siblingAtRow(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QModelIndexFunc_siblingAtRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QModelIndex___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QModelIndex_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QModelIndex_methods[] = {
    {"child", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_child), METH_VARARGS},
    {"column", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_column), METH_NOARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_data), METH_VARARGS|METH_KEYWORDS},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_flags), METH_NOARGS},
    {"internalId", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_internalId), METH_NOARGS},
    {"internalPointer", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_internalPointer), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_isValid), METH_NOARGS},
    {"model", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_model), METH_NOARGS},
    {"parent", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_parent), METH_NOARGS},
    {"row", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_row), METH_NOARGS},
    {"sibling", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_sibling), METH_VARARGS},
    {"siblingAtColumn", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_siblingAtColumn), METH_O},
    {"siblingAtRow", reinterpret_cast<PyCFunction>(Sbk_QModelIndexFunc_siblingAtRow), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QModelIndex___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QModelIndex_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
                // operator!=(const QModelIndex & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QModelIndex cppArg0_local;
                ::QModelIndex *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
                // operator<(const QModelIndex & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QModelIndex cppArg0_local;
                ::QModelIndex *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QModelIndex_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
                // operator==(const QModelIndex & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QModelIndex cppArg0_local;
                ::QModelIndex *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QModelIndex_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QModelIndex_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static Py_hash_t Sbk_QModelIndex_HashFunc(PyObject *self) {
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Py_hash_t(qHash(*cppSelf));
}

static int Sbk_QModelIndex_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QModelIndex_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QModelIndex__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QModelIndex_Type = nullptr;
static SbkObjectType *Sbk_QModelIndex_TypeF(void)
{
    return _Sbk_QModelIndex_Type;
}

static PyType_Slot Sbk_QModelIndex_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QModelIndex__repr__)},
    {Py_tp_hash,        reinterpret_cast<void *>(&Sbk_QModelIndex_HashFunc)},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QModelIndex_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QModelIndex_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QModelIndex_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QModelIndex_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QModelIndex_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QModelIndex_spec = {
    "2:PySide2.QtCore.QModelIndex",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QModelIndex_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QModelIndex_PythonToCpp_QModelIndex_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QModelIndex_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QModelIndex_PythonToCpp_QModelIndex_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QModelIndex_TypeF())))
        return QModelIndex_PythonToCpp_QModelIndex_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QModelIndex_PTR_CppToPython_QModelIndex(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QModelIndex *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QModelIndex_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QModelIndex_COPY_CppToPython_QModelIndex(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QModelIndex_TypeF(), new ::QModelIndex(*reinterpret_cast<const ::QModelIndex *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QModelIndex_PythonToCpp_QModelIndex_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QModelIndex *>(cppOut) = *reinterpret_cast< ::QModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QModelIndex_PythonToCpp_QModelIndex_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QModelIndex_TypeF())))
        return QModelIndex_PythonToCpp_QModelIndex_COPY;
    return {};
}

// Implicit conversions.
static void QPersistentModelIndex_PythonToCpp_QModelIndex(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QModelIndex *>(cppOut) = ::QModelIndex(*reinterpret_cast< ::QPersistentModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_QPersistentModelIndex_PythonToCpp_QModelIndex_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]))
        return QPersistentModelIndex_PythonToCpp_QModelIndex;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QModelIndex_SignatureStrings[] = {
    "1:PySide2.QtCore.QModelIndex(self)",
    "0:PySide2.QtCore.QModelIndex(self,QModelIndex:PySide2.QtCore.QModelIndex)",
    "PySide2.QtCore.QModelIndex.child(self,row:int,column:int)->PySide2.QtCore.QModelIndex",
    "PySide2.QtCore.QModelIndex.column(self)->int",
    "PySide2.QtCore.QModelIndex.data(self,role:int=Qt.DisplayRole)->QVariant",
    "PySide2.QtCore.QModelIndex.flags(self)->PySide2.QtCore.Qt.ItemFlags",
    "PySide2.QtCore.QModelIndex.internalId(self)->quintptr",
    "PySide2.QtCore.QModelIndex.internalPointer(self)->void",
    "PySide2.QtCore.QModelIndex.isValid(self)->bool",
    "PySide2.QtCore.QModelIndex.model(self)->PySide2.QtCore.QAbstractItemModel",
    "PySide2.QtCore.QModelIndex.parent(self)->PySide2.QtCore.QModelIndex",
    "PySide2.QtCore.QModelIndex.row(self)->int",
    "PySide2.QtCore.QModelIndex.sibling(self,row:int,column:int)->PySide2.QtCore.QModelIndex",
    "PySide2.QtCore.QModelIndex.siblingAtColumn(self,column:int)->PySide2.QtCore.QModelIndex",
    "PySide2.QtCore.QModelIndex.siblingAtRow(self,row:int)->PySide2.QtCore.QModelIndex",
    "PySide2.QtCore.QModelIndex.__copy__()",
    nullptr}; // Sentinel

void init_QModelIndex(PyObject *module)
{
    _Sbk_QModelIndex_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QModelIndex",
        "QModelIndex",
        &Sbk_QModelIndex_spec,
        &Shiboken::callCppDestructor< ::QModelIndex >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QModelIndex_Type);
    InitSignatureStrings(pyType, QModelIndex_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QModelIndex_Type), Sbk_QModelIndex_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QModelIndex_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QModelIndex_TypeF(),
        QModelIndex_PythonToCpp_QModelIndex_PTR,
        is_QModelIndex_PythonToCpp_QModelIndex_PTR_Convertible,
        QModelIndex_PTR_CppToPython_QModelIndex,
        QModelIndex_COPY_CppToPython_QModelIndex);

    Shiboken::Conversions::registerConverterName(converter, "QModelIndex");
    Shiboken::Conversions::registerConverterName(converter, "QModelIndex*");
    Shiboken::Conversions::registerConverterName(converter, "QModelIndex&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QModelIndex).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QModelIndex_PythonToCpp_QModelIndex_COPY,
        is_QModelIndex_PythonToCpp_QModelIndex_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPersistentModelIndex_PythonToCpp_QModelIndex,
        is_QPersistentModelIndex_PythonToCpp_QModelIndex_Convertible);

    qRegisterMetaType< ::QModelIndex >("QModelIndex");
}
