/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qregularexpressionmatch_wrapper.h"

// inner classes

// Extra includes
#include <qregularexpression.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRegularExpressionMatch_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRegularExpressionMatch >()))
        return -1;

    ::QRegularExpressionMatch *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QRegularExpressionMatch", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QRegularExpressionMatch::QRegularExpressionMatch()
    // 1: QRegularExpressionMatch::QRegularExpressionMatch(QRegularExpressionMatch)
    if (numArgs == 0) {
        overloadId = 0; // QRegularExpressionMatch()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QRegularExpressionMatch(QRegularExpressionMatch)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionMatch_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QRegularExpressionMatch()
        {

            if (!PyErr_Occurred()) {
                // QRegularExpressionMatch()
                cptr = new ::QRegularExpressionMatch();
            }
            break;
        }
        case 1: // QRegularExpressionMatch(const QRegularExpressionMatch & match)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRegularExpressionMatch cppArg0_local;
            ::QRegularExpressionMatch *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QRegularExpressionMatch(QRegularExpressionMatch)
                cptr = new ::QRegularExpressionMatch(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRegularExpressionMatch >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QRegularExpressionMatch_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QRegularExpressionMatch_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRegularExpressionMatchFunc_captured(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.captured";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegularExpressionMatchFunc_captured_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:captured", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QRegularExpressionMatch::captured(QString)const
    // 1: QRegularExpressionMatch::captured(int)const
    if (numArgs == 0) {
        overloadId = 1; // captured(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // captured(int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // captured(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionMatchFunc_captured_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // captured(const QString & name) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRegularExpressionMatchFunc_captured_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // captured(QString)const
                QString cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->captured(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // captured(int nth) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_nth = Shiboken::String::createStaticString("nth");
                if (PyDict_Contains(kwds, key_nth)) {
                    value = PyDict_GetItem(kwds, key_nth);
                    if (value && pyArgs[0]) {
                        errInfo = key_nth;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionMatchFunc_captured_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                            goto Sbk_QRegularExpressionMatchFunc_captured_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_nth);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRegularExpressionMatchFunc_captured_TypeError;
                }
            }
            int cppArg0 = 0;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // captured(int)const
                QString cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->captured(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegularExpressionMatchFunc_captured_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionMatchFunc_capturedEnd(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.capturedEnd";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegularExpressionMatchFunc_capturedEnd_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:capturedEnd", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QRegularExpressionMatch::capturedEnd(QString)const
    // 1: QRegularExpressionMatch::capturedEnd(int)const
    if (numArgs == 0) {
        overloadId = 1; // capturedEnd(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // capturedEnd(int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // capturedEnd(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionMatchFunc_capturedEnd_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // capturedEnd(const QString & name) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRegularExpressionMatchFunc_capturedEnd_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // capturedEnd(QString)const
                int cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->capturedEnd(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // capturedEnd(int nth) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_nth = Shiboken::String::createStaticString("nth");
                if (PyDict_Contains(kwds, key_nth)) {
                    value = PyDict_GetItem(kwds, key_nth);
                    if (value && pyArgs[0]) {
                        errInfo = key_nth;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionMatchFunc_capturedEnd_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                            goto Sbk_QRegularExpressionMatchFunc_capturedEnd_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_nth);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRegularExpressionMatchFunc_capturedEnd_TypeError;
                }
            }
            int cppArg0 = 0;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // capturedEnd(int)const
                int cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->capturedEnd(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegularExpressionMatchFunc_capturedEnd_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionMatchFunc_capturedLength(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.capturedLength";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegularExpressionMatchFunc_capturedLength_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:capturedLength", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QRegularExpressionMatch::capturedLength(QString)const
    // 1: QRegularExpressionMatch::capturedLength(int)const
    if (numArgs == 0) {
        overloadId = 1; // capturedLength(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // capturedLength(int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // capturedLength(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionMatchFunc_capturedLength_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // capturedLength(const QString & name) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRegularExpressionMatchFunc_capturedLength_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // capturedLength(QString)const
                int cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->capturedLength(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // capturedLength(int nth) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_nth = Shiboken::String::createStaticString("nth");
                if (PyDict_Contains(kwds, key_nth)) {
                    value = PyDict_GetItem(kwds, key_nth);
                    if (value && pyArgs[0]) {
                        errInfo = key_nth;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionMatchFunc_capturedLength_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                            goto Sbk_QRegularExpressionMatchFunc_capturedLength_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_nth);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRegularExpressionMatchFunc_capturedLength_TypeError;
                }
            }
            int cppArg0 = 0;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // capturedLength(int)const
                int cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->capturedLength(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegularExpressionMatchFunc_capturedLength_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionMatchFunc_capturedRef(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.capturedRef";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegularExpressionMatchFunc_capturedRef_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:capturedRef", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QRegularExpressionMatch::capturedRef(QString)const
    // 1: QRegularExpressionMatch::capturedRef(int)const
    if (numArgs == 0) {
        overloadId = 1; // capturedRef(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // capturedRef(int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // capturedRef(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionMatchFunc_capturedRef_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // capturedRef(const QString & name) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRegularExpressionMatchFunc_capturedRef_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // capturedRef(QString)const
                QStringRef cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->capturedRef(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
            }
            break;
        }
        case 1: // capturedRef(int nth) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_nth = Shiboken::String::createStaticString("nth");
                if (PyDict_Contains(kwds, key_nth)) {
                    value = PyDict_GetItem(kwds, key_nth);
                    if (value && pyArgs[0]) {
                        errInfo = key_nth;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionMatchFunc_capturedRef_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                            goto Sbk_QRegularExpressionMatchFunc_capturedRef_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_nth);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRegularExpressionMatchFunc_capturedRef_TypeError;
                }
            }
            int cppArg0 = 0;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // capturedRef(int)const
                QStringRef cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->capturedRef(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegularExpressionMatchFunc_capturedRef_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionMatchFunc_capturedStart(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.capturedStart";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegularExpressionMatchFunc_capturedStart_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:capturedStart", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QRegularExpressionMatch::capturedStart(QString)const
    // 1: QRegularExpressionMatch::capturedStart(int)const
    if (numArgs == 0) {
        overloadId = 1; // capturedStart(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // capturedStart(int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // capturedStart(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionMatchFunc_capturedStart_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // capturedStart(const QString & name) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRegularExpressionMatchFunc_capturedStart_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // capturedStart(QString)const
                int cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->capturedStart(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // capturedStart(int nth) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_nth = Shiboken::String::createStaticString("nth");
                if (PyDict_Contains(kwds, key_nth)) {
                    value = PyDict_GetItem(kwds, key_nth);
                    if (value && pyArgs[0]) {
                        errInfo = key_nth;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionMatchFunc_capturedStart_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                            goto Sbk_QRegularExpressionMatchFunc_capturedStart_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_nth);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRegularExpressionMatchFunc_capturedStart_TypeError;
                }
            }
            int cppArg0 = 0;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // capturedStart(int)const
                int cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->capturedStart(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegularExpressionMatchFunc_capturedStart_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionMatchFunc_capturedTexts(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.capturedTexts";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capturedTexts()const
            QStringList cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->capturedTexts();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchFunc_hasMatch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.hasMatch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasMatch()const
            bool cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->hasMatch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchFunc_hasPartialMatch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.hasPartialMatch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasPartialMatch()const
            bool cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->hasPartialMatch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchFunc_lastCapturedIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.lastCapturedIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastCapturedIndex()const
            int cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->lastCapturedIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchFunc_matchOptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.matchOptions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // matchOptions()const
            QFlags<QRegularExpression::MatchOption> cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->matchOptions();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchFunc_matchType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.matchType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // matchType()const
            QRegularExpression::MatchType cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->matchType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchFunc_regularExpression(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.regularExpression";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // regularExpression()const
            QRegularExpression cppResult = const_cast<const ::QRegularExpressionMatch *>(cppSelf)->regularExpression();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatch.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRegularExpressionMatch::swap(QRegularExpressionMatch&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QRegularExpressionMatch&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionMatchFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegularExpressionMatch cppArg0_local;
        ::QRegularExpressionMatch *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QRegularExpressionMatch&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRegularExpressionMatchFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionMatch___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QRegularExpressionMatch_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRegularExpressionMatch_methods[] = {
    {"captured", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_captured), METH_VARARGS|METH_KEYWORDS},
    {"capturedEnd", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_capturedEnd), METH_VARARGS|METH_KEYWORDS},
    {"capturedLength", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_capturedLength), METH_VARARGS|METH_KEYWORDS},
    {"capturedRef", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_capturedRef), METH_VARARGS|METH_KEYWORDS},
    {"capturedStart", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_capturedStart), METH_VARARGS|METH_KEYWORDS},
    {"capturedTexts", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_capturedTexts), METH_NOARGS},
    {"hasMatch", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_hasMatch), METH_NOARGS},
    {"hasPartialMatch", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_hasPartialMatch), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_isValid), METH_NOARGS},
    {"lastCapturedIndex", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_lastCapturedIndex), METH_NOARGS},
    {"matchOptions", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_matchOptions), METH_NOARGS},
    {"matchType", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_matchType), METH_NOARGS},
    {"regularExpression", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_regularExpression), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatch___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QRegularExpressionMatch_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRegularExpressionMatch_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QRegularExpressionMatch__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRegularExpressionMatch_Type = nullptr;
static SbkObjectType *Sbk_QRegularExpressionMatch_TypeF(void)
{
    return _Sbk_QRegularExpressionMatch_Type;
}

static PyType_Slot Sbk_QRegularExpressionMatch_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QRegularExpressionMatch__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRegularExpressionMatch_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRegularExpressionMatch_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRegularExpressionMatch_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRegularExpressionMatch_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRegularExpressionMatch_spec = {
    "2:PySide2.QtCore.QRegularExpressionMatch",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRegularExpressionMatch_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRegularExpressionMatch_PythonToCpp_QRegularExpressionMatch_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRegularExpressionMatch_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRegularExpressionMatch_PythonToCpp_QRegularExpressionMatch_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRegularExpressionMatch_TypeF())))
        return QRegularExpressionMatch_PythonToCpp_QRegularExpressionMatch_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRegularExpressionMatch_PTR_CppToPython_QRegularExpressionMatch(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QRegularExpressionMatch *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QRegularExpressionMatch_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QRegularExpressionMatch_COPY_CppToPython_QRegularExpressionMatch(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QRegularExpressionMatch_TypeF(), new ::QRegularExpressionMatch(*reinterpret_cast<const ::QRegularExpressionMatch *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QRegularExpressionMatch_PythonToCpp_QRegularExpressionMatch_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRegularExpressionMatch *>(cppOut) = *reinterpret_cast< ::QRegularExpressionMatch *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QRegularExpressionMatch_PythonToCpp_QRegularExpressionMatch_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRegularExpressionMatch_TypeF())))
        return QRegularExpressionMatch_PythonToCpp_QRegularExpressionMatch_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRegularExpressionMatch_SignatureStrings[] = {
    "1:PySide2.QtCore.QRegularExpressionMatch(self)",
    "0:PySide2.QtCore.QRegularExpressionMatch(self,match:PySide2.QtCore.QRegularExpressionMatch)",
    "1:PySide2.QtCore.QRegularExpressionMatch.captured(self,name:QString)->QString",
    "0:PySide2.QtCore.QRegularExpressionMatch.captured(self,nth:int=0)->QString",
    "1:PySide2.QtCore.QRegularExpressionMatch.capturedEnd(self,name:QString)->int",
    "0:PySide2.QtCore.QRegularExpressionMatch.capturedEnd(self,nth:int=0)->int",
    "1:PySide2.QtCore.QRegularExpressionMatch.capturedLength(self,name:QString)->int",
    "0:PySide2.QtCore.QRegularExpressionMatch.capturedLength(self,nth:int=0)->int",
    "1:PySide2.QtCore.QRegularExpressionMatch.capturedRef(self,name:QString)->QStringRef",
    "0:PySide2.QtCore.QRegularExpressionMatch.capturedRef(self,nth:int=0)->QStringRef",
    "1:PySide2.QtCore.QRegularExpressionMatch.capturedStart(self,name:QString)->int",
    "0:PySide2.QtCore.QRegularExpressionMatch.capturedStart(self,nth:int=0)->int",
    "PySide2.QtCore.QRegularExpressionMatch.capturedTexts(self)->QStringList",
    "PySide2.QtCore.QRegularExpressionMatch.hasMatch(self)->bool",
    "PySide2.QtCore.QRegularExpressionMatch.hasPartialMatch(self)->bool",
    "PySide2.QtCore.QRegularExpressionMatch.isValid(self)->bool",
    "PySide2.QtCore.QRegularExpressionMatch.lastCapturedIndex(self)->int",
    "PySide2.QtCore.QRegularExpressionMatch.matchOptions(self)->PySide2.QtCore.QRegularExpression.MatchOptions",
    "PySide2.QtCore.QRegularExpressionMatch.matchType(self)->PySide2.QtCore.QRegularExpression.MatchType",
    "PySide2.QtCore.QRegularExpressionMatch.regularExpression(self)->PySide2.QtCore.QRegularExpression",
    "PySide2.QtCore.QRegularExpressionMatch.swap(self,other:PySide2.QtCore.QRegularExpressionMatch)",
    "PySide2.QtCore.QRegularExpressionMatch.__copy__()",
    nullptr}; // Sentinel

void init_QRegularExpressionMatch(PyObject *module)
{
    _Sbk_QRegularExpressionMatch_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRegularExpressionMatch",
        "QRegularExpressionMatch",
        &Sbk_QRegularExpressionMatch_spec,
        &Shiboken::callCppDestructor< ::QRegularExpressionMatch >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRegularExpressionMatch_Type);
    InitSignatureStrings(pyType, QRegularExpressionMatch_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRegularExpressionMatch_Type), Sbk_QRegularExpressionMatch_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRegularExpressionMatch_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRegularExpressionMatch_TypeF(),
        QRegularExpressionMatch_PythonToCpp_QRegularExpressionMatch_PTR,
        is_QRegularExpressionMatch_PythonToCpp_QRegularExpressionMatch_PTR_Convertible,
        QRegularExpressionMatch_PTR_CppToPython_QRegularExpressionMatch,
        QRegularExpressionMatch_COPY_CppToPython_QRegularExpressionMatch);

    Shiboken::Conversions::registerConverterName(converter, "QRegularExpressionMatch");
    Shiboken::Conversions::registerConverterName(converter, "QRegularExpressionMatch*");
    Shiboken::Conversions::registerConverterName(converter, "QRegularExpressionMatch&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRegularExpressionMatch).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QRegularExpressionMatch_PythonToCpp_QRegularExpressionMatch_COPY,
        is_QRegularExpressionMatch_PythonToCpp_QRegularExpressionMatch_COPY_Convertible);

    qRegisterMetaType< ::QRegularExpressionMatch >("QRegularExpressionMatch");
}
