/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qregularexpressionmatchiterator_wrapper.h"

// inner classes

// Extra includes
#include <qregularexpression.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRegularExpressionMatchIterator_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRegularExpressionMatchIterator >()))
        return -1;

    ::QRegularExpressionMatchIterator *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatchIterator.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QRegularExpressionMatchIterator", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QRegularExpressionMatchIterator::QRegularExpressionMatchIterator()
    // 1: QRegularExpressionMatchIterator::QRegularExpressionMatchIterator(QRegularExpressionMatchIterator)
    if (numArgs == 0) {
        overloadId = 0; // QRegularExpressionMatchIterator()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QRegularExpressionMatchIterator(QRegularExpressionMatchIterator)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionMatchIterator_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QRegularExpressionMatchIterator()
        {

            if (!PyErr_Occurred()) {
                // QRegularExpressionMatchIterator()
                cptr = new ::QRegularExpressionMatchIterator();
            }
            break;
        }
        case 1: // QRegularExpressionMatchIterator(const QRegularExpressionMatchIterator & iterator)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRegularExpressionMatchIterator cppArg0_local;
            ::QRegularExpressionMatchIterator *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QRegularExpressionMatchIterator(QRegularExpressionMatchIterator)
                cptr = new ::QRegularExpressionMatchIterator(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRegularExpressionMatchIterator >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QRegularExpressionMatchIterator_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QRegularExpressionMatchIterator_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRegularExpressionMatchIteratorFunc_hasNext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatchIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatchIterator.hasNext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasNext()const
            bool cppResult = const_cast<const ::QRegularExpressionMatchIterator *>(cppSelf)->hasNext();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchIteratorFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatchIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatchIterator.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QRegularExpressionMatchIterator *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchIteratorFunc_matchOptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatchIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatchIterator.matchOptions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // matchOptions()const
            QFlags<QRegularExpression::MatchOption> cppResult = const_cast<const ::QRegularExpressionMatchIterator *>(cppSelf)->matchOptions();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchIteratorFunc_matchType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatchIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatchIterator.matchType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // matchType()const
            QRegularExpression::MatchType cppResult = const_cast<const ::QRegularExpressionMatchIterator *>(cppSelf)->matchType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchIteratorFunc_next(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatchIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatchIterator.next";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // next()
            QRegularExpressionMatch cppResult = cppSelf->next();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchIteratorFunc_peekNext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatchIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatchIterator.peekNext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peekNext()const
            QRegularExpressionMatch cppResult = const_cast<const ::QRegularExpressionMatchIterator *>(cppSelf)->peekNext();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchIteratorFunc_regularExpression(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatchIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatchIterator.regularExpression";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // regularExpression()const
            QRegularExpression cppResult = const_cast<const ::QRegularExpressionMatchIterator *>(cppSelf)->regularExpression();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionMatchIteratorFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpressionMatchIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpressionMatchIterator.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRegularExpressionMatchIterator::swap(QRegularExpressionMatchIterator&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QRegularExpressionMatchIterator&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionMatchIteratorFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegularExpressionMatchIterator cppArg0_local;
        ::QRegularExpressionMatchIterator *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QRegularExpressionMatchIterator&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRegularExpressionMatchIteratorFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionMatchIterator___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QRegularExpressionMatchIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QRegularExpressionMatchIterator_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRegularExpressionMatchIterator_methods[] = {
    {"hasNext", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchIteratorFunc_hasNext), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchIteratorFunc_isValid), METH_NOARGS},
    {"matchOptions", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchIteratorFunc_matchOptions), METH_NOARGS},
    {"matchType", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchIteratorFunc_matchType), METH_NOARGS},
    {"next", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchIteratorFunc_next), METH_NOARGS},
    {"peekNext", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchIteratorFunc_peekNext), METH_NOARGS},
    {"regularExpression", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchIteratorFunc_regularExpression), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchIteratorFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionMatchIterator___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QRegularExpressionMatchIterator_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRegularExpressionMatchIterator_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRegularExpressionMatchIterator_Type = nullptr;
static SbkObjectType *Sbk_QRegularExpressionMatchIterator_TypeF(void)
{
    return _Sbk_QRegularExpressionMatchIterator_Type;
}

static PyType_Slot Sbk_QRegularExpressionMatchIterator_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRegularExpressionMatchIterator_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRegularExpressionMatchIterator_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRegularExpressionMatchIterator_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRegularExpressionMatchIterator_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRegularExpressionMatchIterator_spec = {
    "2:PySide2.QtCore.QRegularExpressionMatchIterator",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRegularExpressionMatchIterator_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRegularExpressionMatchIterator_PythonToCpp_QRegularExpressionMatchIterator_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRegularExpressionMatchIterator_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRegularExpressionMatchIterator_PythonToCpp_QRegularExpressionMatchIterator_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRegularExpressionMatchIterator_TypeF())))
        return QRegularExpressionMatchIterator_PythonToCpp_QRegularExpressionMatchIterator_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRegularExpressionMatchIterator_PTR_CppToPython_QRegularExpressionMatchIterator(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QRegularExpressionMatchIterator *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QRegularExpressionMatchIterator_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QRegularExpressionMatchIterator_COPY_CppToPython_QRegularExpressionMatchIterator(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QRegularExpressionMatchIterator_TypeF(), new ::QRegularExpressionMatchIterator(*reinterpret_cast<const ::QRegularExpressionMatchIterator *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QRegularExpressionMatchIterator_PythonToCpp_QRegularExpressionMatchIterator_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRegularExpressionMatchIterator *>(cppOut) = *reinterpret_cast< ::QRegularExpressionMatchIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QRegularExpressionMatchIterator_PythonToCpp_QRegularExpressionMatchIterator_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRegularExpressionMatchIterator_TypeF())))
        return QRegularExpressionMatchIterator_PythonToCpp_QRegularExpressionMatchIterator_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRegularExpressionMatchIterator_SignatureStrings[] = {
    "1:PySide2.QtCore.QRegularExpressionMatchIterator(self)",
    "0:PySide2.QtCore.QRegularExpressionMatchIterator(self,iterator:PySide2.QtCore.QRegularExpressionMatchIterator)",
    "PySide2.QtCore.QRegularExpressionMatchIterator.hasNext(self)->bool",
    "PySide2.QtCore.QRegularExpressionMatchIterator.isValid(self)->bool",
    "PySide2.QtCore.QRegularExpressionMatchIterator.matchOptions(self)->PySide2.QtCore.QRegularExpression.MatchOptions",
    "PySide2.QtCore.QRegularExpressionMatchIterator.matchType(self)->PySide2.QtCore.QRegularExpression.MatchType",
    "PySide2.QtCore.QRegularExpressionMatchIterator.next(self)->PySide2.QtCore.QRegularExpressionMatch",
    "PySide2.QtCore.QRegularExpressionMatchIterator.peekNext(self)->PySide2.QtCore.QRegularExpressionMatch",
    "PySide2.QtCore.QRegularExpressionMatchIterator.regularExpression(self)->PySide2.QtCore.QRegularExpression",
    "PySide2.QtCore.QRegularExpressionMatchIterator.swap(self,other:PySide2.QtCore.QRegularExpressionMatchIterator)",
    "PySide2.QtCore.QRegularExpressionMatchIterator.__copy__()",
    nullptr}; // Sentinel

void init_QRegularExpressionMatchIterator(PyObject *module)
{
    _Sbk_QRegularExpressionMatchIterator_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRegularExpressionMatchIterator",
        "QRegularExpressionMatchIterator",
        &Sbk_QRegularExpressionMatchIterator_spec,
        &Shiboken::callCppDestructor< ::QRegularExpressionMatchIterator >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRegularExpressionMatchIterator_Type);
    InitSignatureStrings(pyType, QRegularExpressionMatchIterator_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRegularExpressionMatchIterator_Type), Sbk_QRegularExpressionMatchIterator_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRegularExpressionMatchIterator_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRegularExpressionMatchIterator_TypeF(),
        QRegularExpressionMatchIterator_PythonToCpp_QRegularExpressionMatchIterator_PTR,
        is_QRegularExpressionMatchIterator_PythonToCpp_QRegularExpressionMatchIterator_PTR_Convertible,
        QRegularExpressionMatchIterator_PTR_CppToPython_QRegularExpressionMatchIterator,
        QRegularExpressionMatchIterator_COPY_CppToPython_QRegularExpressionMatchIterator);

    Shiboken::Conversions::registerConverterName(converter, "QRegularExpressionMatchIterator");
    Shiboken::Conversions::registerConverterName(converter, "QRegularExpressionMatchIterator*");
    Shiboken::Conversions::registerConverterName(converter, "QRegularExpressionMatchIterator&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRegularExpressionMatchIterator).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QRegularExpressionMatchIterator_PythonToCpp_QRegularExpressionMatchIterator_COPY,
        is_QRegularExpressionMatchIterator_PythonToCpp_QRegularExpressionMatchIterator_COPY_Convertible);

    qRegisterMetaType< ::QRegularExpressionMatchIterator >("QRegularExpressionMatchIterator");
}
