/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qresource_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>
#include <qdatetime.h>
#include <qlocale.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QResource_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QResource >()))
        return -1;

    ::QResource *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QResource_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QResource", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QResource::QResource(QString,QLocale)
    if (numArgs == 0) {
        overloadId = 0; // QResource(QString,QLocale)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QResource(QString,QLocale)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QResource(QString,QLocale)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QResource_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_file = Shiboken::String::createStaticString("file");
            if (PyDict_Contains(kwds, key_file)) {
                value = PyDict_GetItem(kwds, key_file);
                if (value && pyArgs[0]) {
                    errInfo = key_file;
                    Py_INCREF(errInfo);
                    goto Sbk_QResource_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QResource_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_file);
            }
            static PyObject *const key_locale = Shiboken::String::createStaticString("locale");
            if (PyDict_Contains(kwds, key_locale)) {
                value = PyDict_GetItem(kwds, key_locale);
                if (value && pyArgs[1]) {
                    errInfo = key_locale;
                    Py_INCREF(errInfo);
                    goto Sbk_QResource_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArgs[1]))))
                        goto Sbk_QResource_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_locale);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QResource_Init_TypeError;
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QLocale cppArg1_local = QLocale();
        ::QLocale *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // QResource(QString,QLocale)
            cptr = new ::QResource(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QResource >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QResource_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QResource_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QResourceFunc_absoluteFilePath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.absoluteFilePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // absoluteFilePath()const
            QString cppResult = const_cast<const ::QResource *>(cppSelf)->absoluteFilePath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_addSearchPath(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.addSearchPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QResource::addSearchPath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // addSearchPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QResourceFunc_addSearchPath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addSearchPath(QString)
            ::QResource::addSearchPath(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QResourceFunc_addSearchPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QResourceFunc_children(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.children";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // children()const
            QStringList cppResult = const_cast<const ::QResource *>(cppSelf)->children();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_compressionAlgorithm(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.compressionAlgorithm";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // compressionAlgorithm()const
            QResource::Compression cppResult = const_cast<const ::QResource *>(cppSelf)->compressionAlgorithm();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_COMPRESSION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()const
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qresource-data)]
            const void *d = cppSelf->data();
            if (d) {
                pyResult = Shiboken::Buffer::newObject(d, cppSelf->size());
            } else {
                Py_INCREF(Py_None);
                pyResult = Py_None;
            }
            // END of custom code block [file: ../glue/qtcore.cpp (qresource-data)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.fileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileName()const
            QString cppResult = const_cast<const ::QResource *>(cppSelf)->fileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_isCompressed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.isCompressed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCompressed()const
            bool cppResult = const_cast<const ::QResource *>(cppSelf)->isCompressed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_isDir(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.isDir";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDir()const
            bool cppResult = const_cast<const ::QResource *>(cppSelf)->isDir();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_isFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.isFile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFile()const
            bool cppResult = const_cast<const ::QResource *>(cppSelf)->isFile();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QResource *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_lastModified(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.lastModified";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastModified()const
            QDateTime cppResult = const_cast<const ::QResource *>(cppSelf)->lastModified();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_locale(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.locale";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // locale()const
            QLocale cppResult = const_cast<const ::QResource *>(cppSelf)->locale();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_registerResource(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.registerResource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QResourceFunc_registerResource_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QResourceFunc_registerResource_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:registerResource", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QResource::registerResource(QString,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // registerResource(QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // registerResource(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QResourceFunc_registerResource_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_resourceRoot = Shiboken::String::createStaticString("resourceRoot");
            if (PyDict_Contains(kwds, key_resourceRoot)) {
                value = PyDict_GetItem(kwds, key_resourceRoot);
                if (value && pyArgs[1]) {
                    errInfo = key_resourceRoot;
                    Py_INCREF(errInfo);
                    goto Sbk_QResourceFunc_registerResource_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QResourceFunc_registerResource_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_resourceRoot);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QResourceFunc_registerResource_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // registerResource(QString,QString)
            bool cppResult = ::QResource::registerResource(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QResourceFunc_registerResource_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QResourceFunc_registerResourceData(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.registerResourceData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QResourceFunc_registerResourceData_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QResourceFunc_registerResourceData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:registerResourceData", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QResource::registerResource(const uchar*,QString)
    if (numArgs >= 1
        && Shiboken::Buffer::checkType(pyArgs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // registerResource(const uchar*,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // registerResource(const uchar*,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QResourceFunc_registerResourceData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_resourceRoot = Shiboken::String::createStaticString("resourceRoot");
            if (PyDict_Contains(kwds, key_resourceRoot)) {
                value = PyDict_GetItem(kwds, key_resourceRoot);
                if (value && pyArgs[1]) {
                    errInfo = key_resourceRoot;
                    Py_INCREF(errInfo);
                    goto Sbk_QResourceFunc_registerResourceData_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QResourceFunc_registerResourceData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_resourceRoot);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QResourceFunc_registerResourceData_TypeError;
            }
        }
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // registerResource(const uchar*,QString)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qresource-registerResource)]
            auto ptr = reinterpret_cast<uchar *>(Shiboken::Buffer::getPointer(pyArgs[1-1]));
            bool cppResult = QResource::registerResource(const_cast<const uchar *>(ptr), cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            // END of custom code block [file: ../glue/qtcore.cpp (qresource-registerResource)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QResourceFunc_registerResourceData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QResourceFunc_searchPaths(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.searchPaths";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // searchPaths()
            QStringList cppResult = ::QResource::searchPaths();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_setFileName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.setFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QResource::setFileName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setFileName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QResourceFunc_setFileName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFileName(QString)
            cppSelf->setFileName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QResourceFunc_setFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QResourceFunc_setLocale(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.setLocale";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QResource::setLocale(QLocale)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArg)))) {
        overloadId = 0; // setLocale(QLocale)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QResourceFunc_setLocale_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLocale(QLocale)
            cppSelf->setLocale(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QResourceFunc_setLocale_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QResourceFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            qint64 cppResult = const_cast<const ::QResource *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_uncompressedData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.uncompressedData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // uncompressedData()const
            QByteArray cppResult = const_cast<const ::QResource *>(cppSelf)->uncompressedData();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_uncompressedSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.uncompressedSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // uncompressedSize()const
            qint64 cppResult = const_cast<const ::QResource *>(cppSelf)->uncompressedSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QResourceFunc_unregisterResource(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.unregisterResource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QResourceFunc_unregisterResource_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QResourceFunc_unregisterResource_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:unregisterResource", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QResource::unregisterResource(QString,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // unregisterResource(QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // unregisterResource(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QResourceFunc_unregisterResource_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_resourceRoot = Shiboken::String::createStaticString("resourceRoot");
            if (PyDict_Contains(kwds, key_resourceRoot)) {
                value = PyDict_GetItem(kwds, key_resourceRoot);
                if (value && pyArgs[1]) {
                    errInfo = key_resourceRoot;
                    Py_INCREF(errInfo);
                    goto Sbk_QResourceFunc_unregisterResource_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QResourceFunc_unregisterResource_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_resourceRoot);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QResourceFunc_unregisterResource_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // unregisterResource(QString,QString)
            bool cppResult = ::QResource::unregisterResource(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QResourceFunc_unregisterResource_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QResourceFunc_unregisterResourceData(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QResource.unregisterResourceData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QResourceFunc_unregisterResourceData_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QResourceFunc_unregisterResourceData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:unregisterResourceData", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QResource::unregisterResource(const uchar*,QString)
    if (numArgs >= 1
        && Shiboken::Buffer::checkType(pyArgs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // unregisterResource(const uchar*,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // unregisterResource(const uchar*,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QResourceFunc_unregisterResourceData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_resourceRoot = Shiboken::String::createStaticString("resourceRoot");
            if (PyDict_Contains(kwds, key_resourceRoot)) {
                value = PyDict_GetItem(kwds, key_resourceRoot);
                if (value && pyArgs[1]) {
                    errInfo = key_resourceRoot;
                    Py_INCREF(errInfo);
                    goto Sbk_QResourceFunc_unregisterResourceData_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QResourceFunc_unregisterResourceData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_resourceRoot);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QResourceFunc_unregisterResourceData_TypeError;
            }
        }
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // unregisterResource(const uchar*,QString)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qresource-registerResource)]
            auto ptr = reinterpret_cast<uchar *>(Shiboken::Buffer::getPointer(pyArgs[1-1]));
            bool cppResult = QResource::unregisterResource(const_cast<const uchar *>(ptr), cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            // END of custom code block [file: ../glue/qtcore.cpp (qresource-registerResource)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QResourceFunc_unregisterResourceData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QResource_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QResource_methods[] = {
    {"absoluteFilePath", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_absoluteFilePath), METH_NOARGS},
    {"addSearchPath", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_addSearchPath), METH_O|METH_STATIC},
    {"children", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_children), METH_NOARGS},
    {"compressionAlgorithm", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_compressionAlgorithm), METH_NOARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_data), METH_NOARGS},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_fileName), METH_NOARGS},
    {"isCompressed", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_isCompressed), METH_NOARGS},
    {"isDir", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_isDir), METH_NOARGS},
    {"isFile", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_isFile), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_isValid), METH_NOARGS},
    {"lastModified", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_lastModified), METH_NOARGS},
    {"locale", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_locale), METH_NOARGS},
    {"registerResource", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_registerResource), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"registerResourceData", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_registerResourceData), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"searchPaths", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_searchPaths), METH_NOARGS|METH_STATIC},
    {"setFileName", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_setFileName), METH_O},
    {"setLocale", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_setLocale), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_size), METH_NOARGS},
    {"uncompressedData", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_uncompressedData), METH_NOARGS},
    {"uncompressedSize", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_uncompressedSize), METH_NOARGS},
    {"unregisterResource", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_unregisterResource), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"unregisterResourceData", reinterpret_cast<PyCFunction>(Sbk_QResourceFunc_unregisterResourceData), METH_VARARGS|METH_KEYWORDS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QResource_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QResource_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QResource_Type = nullptr;
static SbkObjectType *Sbk_QResource_TypeF(void)
{
    return _Sbk_QResource_Type;
}

static PyType_Slot Sbk_QResource_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QResource_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QResource_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QResource_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QResource_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QResource_spec = {
    "2:PySide2.QtCore.QResource",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QResource_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QResource_Compression_PythonToCpp_QResource_Compression(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QResource::Compression *>(cppOut) =
        static_cast<::QResource::Compression>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QResource_Compression_PythonToCpp_QResource_Compression_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QRESOURCE_COMPRESSION_IDX]))
        return QResource_Compression_PythonToCpp_QResource_Compression;
    return {};
}
static PyObject *QResource_Compression_CppToPython_QResource_Compression(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QResource::Compression *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_COMPRESSION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QResource_PythonToCpp_QResource_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QResource_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QResource_PythonToCpp_QResource_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QResource_TypeF())))
        return QResource_PythonToCpp_QResource_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QResource_PTR_CppToPython_QResource(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QResource *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QResource_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QResource_SignatureStrings[] = {
    "PySide2.QtCore.QResource(self,file:QString=QString(),locale:PySide2.QtCore.QLocale=QLocale())",
    "PySide2.QtCore.QResource.absoluteFilePath(self)->QString",
    "PySide2.QtCore.QResource.addSearchPath(path:QString)",
    "PySide2.QtCore.QResource.children(self)->QStringList",
    "PySide2.QtCore.QResource.compressionAlgorithm(self)->PySide2.QtCore.QResource.Compression",
    "PySide2.QtCore.QResource.data(self)->uchar*",
    "PySide2.QtCore.QResource.fileName(self)->QString",
    "PySide2.QtCore.QResource.isCompressed(self)->bool",
    "PySide2.QtCore.QResource.isDir(self)->bool",
    "PySide2.QtCore.QResource.isFile(self)->bool",
    "PySide2.QtCore.QResource.isValid(self)->bool",
    "PySide2.QtCore.QResource.lastModified(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QResource.locale(self)->PySide2.QtCore.QLocale",
    "PySide2.QtCore.QResource.registerResource(rccFilename:QString,resourceRoot:QString=QString())->bool",
    "PySide2.QtCore.QResource.registerResourceData(rccData:uchar*,resourceRoot:QString=QString())->bool",
    "PySide2.QtCore.QResource.searchPaths()->QStringList",
    "PySide2.QtCore.QResource.setFileName(self,file:QString)",
    "PySide2.QtCore.QResource.setLocale(self,locale:PySide2.QtCore.QLocale)",
    "PySide2.QtCore.QResource.size(self)->qint64",
    "PySide2.QtCore.QResource.uncompressedData(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QResource.uncompressedSize(self)->qint64",
    "PySide2.QtCore.QResource.unregisterResource(rccFilename:QString,resourceRoot:QString=QString())->bool",
    "PySide2.QtCore.QResource.unregisterResourceData(rccData:uchar*,resourceRoot:QString=QString())->bool",
    nullptr}; // Sentinel

void init_QResource(PyObject *module)
{
    _Sbk_QResource_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QResource",
        "QResource*",
        &Sbk_QResource_spec,
        &Shiboken::callCppDestructor< ::QResource >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QResource_Type);
    InitSignatureStrings(pyType, QResource_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QResource_Type), Sbk_QResource_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QRESOURCE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QResource_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QResource_TypeF(),
        QResource_PythonToCpp_QResource_PTR,
        is_QResource_PythonToCpp_QResource_PTR_Convertible,
        QResource_PTR_CppToPython_QResource);

    Shiboken::Conversions::registerConverterName(converter, "QResource");
    Shiboken::Conversions::registerConverterName(converter, "QResource*");
    Shiboken::Conversions::registerConverterName(converter, "QResource&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QResource).name());


    // Initialization of enums.

    // Initialization of enum 'Compression'.
    SbkPySide2_QtCoreTypes[SBK_QRESOURCE_COMPRESSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QResource_TypeF(),
        "Compression",
        "2:PySide2.QtCore.QResource.Compression",
        "QResource::Compression");
    if (!SbkPySide2_QtCoreTypes[SBK_QRESOURCE_COMPRESSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_COMPRESSION_IDX],
        Sbk_QResource_TypeF(), "NoCompression", (long) QResource::Compression::NoCompression))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_COMPRESSION_IDX],
        Sbk_QResource_TypeF(), "ZlibCompression", (long) QResource::Compression::ZlibCompression))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_COMPRESSION_IDX],
        Sbk_QResource_TypeF(), "ZstdCompression", (long) QResource::Compression::ZstdCompression))
        return;
    // Register converter for enum 'QResource::Compression'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_COMPRESSION_IDX],
            QResource_Compression_CppToPython_QResource_Compression);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QResource_Compression_PythonToCpp_QResource_Compression,
            is_QResource_Compression_PythonToCpp_QResource_Compression_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QRESOURCE_COMPRESSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QResource::Compression");
        Shiboken::Conversions::registerConverterName(converter, "Compression");
    }
    // End of 'Compression' enum.

    qRegisterMetaType< ::QResource::Compression >("QResource::Compression");
}
