/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qtextboundaryfinder_wrapper.h"

// inner classes

// Extra includes
#include <qtextboundaryfinder.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextBoundaryFinder_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextBoundaryFinder >()))
        return -1;

    ::QTextBoundaryFinder *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextBoundaryFinder.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QTextBoundaryFinder", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QTextBoundaryFinder::QTextBoundaryFinder()
    // 1: QTextBoundaryFinder::QTextBoundaryFinder(QTextBoundaryFinder::BoundaryType,QString)
    // 2: QTextBoundaryFinder::QTextBoundaryFinder(QTextBoundaryFinder)
    if (numArgs == 0) {
        overloadId = 0; // QTextBoundaryFinder()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QTextBoundaryFinder(QTextBoundaryFinder)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 1; // QTextBoundaryFinder(QTextBoundaryFinder::BoundaryType,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBoundaryFinder_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextBoundaryFinder()
        {

            if (!PyErr_Occurred()) {
                // QTextBoundaryFinder()
                cptr = new ::QTextBoundaryFinder();
            }
            break;
        }
        case 1: // QTextBoundaryFinder(QTextBoundaryFinder::BoundaryType type, const QString & string)
        {
            ::QTextBoundaryFinder::BoundaryType cppArg0{QTextBoundaryFinder::Grapheme};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QTextBoundaryFinder(QTextBoundaryFinder::BoundaryType,QString)
                cptr = new ::QTextBoundaryFinder(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QTextBoundaryFinder(const QTextBoundaryFinder & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextBoundaryFinder cppArg0_local;
            ::QTextBoundaryFinder *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextBoundaryFinder(QTextBoundaryFinder)
                cptr = new ::QTextBoundaryFinder(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextBoundaryFinder >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextBoundaryFinder_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextBoundaryFinder_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextBoundaryFinderFunc_boundaryReasons(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextBoundaryFinder.boundaryReasons";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // boundaryReasons()const
            QFlags<QTextBoundaryFinder::BoundaryReason> cppResult = const_cast<const ::QTextBoundaryFinder *>(cppSelf)->boundaryReasons();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBoundaryFinderFunc_isAtBoundary(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextBoundaryFinder.isAtBoundary";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAtBoundary()const
            bool cppResult = const_cast<const ::QTextBoundaryFinder *>(cppSelf)->isAtBoundary();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBoundaryFinderFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextBoundaryFinder.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QTextBoundaryFinder *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBoundaryFinderFunc_position(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextBoundaryFinder.position";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // position()const
            int cppResult = const_cast<const ::QTextBoundaryFinder *>(cppSelf)->position();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBoundaryFinderFunc_setPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextBoundaryFinder.setPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBoundaryFinder::setPosition(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setPosition(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBoundaryFinderFunc_setPosition_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPosition(int)
            cppSelf->setPosition(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBoundaryFinderFunc_setPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBoundaryFinderFunc_string(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextBoundaryFinder.string";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // string()const
            QString cppResult = const_cast<const ::QTextBoundaryFinder *>(cppSelf)->string();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBoundaryFinderFunc_toEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextBoundaryFinder.toEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toEnd()
            cppSelf->toEnd();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextBoundaryFinderFunc_toNextBoundary(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextBoundaryFinder.toNextBoundary";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toNextBoundary()
            int cppResult = cppSelf->toNextBoundary();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBoundaryFinderFunc_toPreviousBoundary(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextBoundaryFinder.toPreviousBoundary";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toPreviousBoundary()
            int cppResult = cppSelf->toPreviousBoundary();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBoundaryFinderFunc_toStart(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextBoundaryFinder.toStart";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toStart()
            cppSelf->toStart();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextBoundaryFinderFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextBoundaryFinder.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QTextBoundaryFinder::BoundaryType cppResult = const_cast<const ::QTextBoundaryFinder *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBoundaryFinder___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextBoundaryFinder_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextBoundaryFinder_methods[] = {
    {"boundaryReasons", reinterpret_cast<PyCFunction>(Sbk_QTextBoundaryFinderFunc_boundaryReasons), METH_NOARGS},
    {"isAtBoundary", reinterpret_cast<PyCFunction>(Sbk_QTextBoundaryFinderFunc_isAtBoundary), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QTextBoundaryFinderFunc_isValid), METH_NOARGS},
    {"position", reinterpret_cast<PyCFunction>(Sbk_QTextBoundaryFinderFunc_position), METH_NOARGS},
    {"setPosition", reinterpret_cast<PyCFunction>(Sbk_QTextBoundaryFinderFunc_setPosition), METH_O},
    {"string", reinterpret_cast<PyCFunction>(Sbk_QTextBoundaryFinderFunc_string), METH_NOARGS},
    {"toEnd", reinterpret_cast<PyCFunction>(Sbk_QTextBoundaryFinderFunc_toEnd), METH_NOARGS},
    {"toNextBoundary", reinterpret_cast<PyCFunction>(Sbk_QTextBoundaryFinderFunc_toNextBoundary), METH_NOARGS},
    {"toPreviousBoundary", reinterpret_cast<PyCFunction>(Sbk_QTextBoundaryFinderFunc_toPreviousBoundary), METH_NOARGS},
    {"toStart", reinterpret_cast<PyCFunction>(Sbk_QTextBoundaryFinderFunc_toStart), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QTextBoundaryFinderFunc_type), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextBoundaryFinder___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextBoundaryFinder_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextBoundaryFinder_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextBoundaryFinder_Type = nullptr;
static SbkObjectType *Sbk_QTextBoundaryFinder_TypeF(void)
{
    return _Sbk_QTextBoundaryFinder_Type;
}

static PyType_Slot Sbk_QTextBoundaryFinder_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextBoundaryFinder_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextBoundaryFinder_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextBoundaryFinder_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextBoundaryFinder_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextBoundaryFinder_spec = {
    "2:PySide2.QtCore.QTextBoundaryFinder",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextBoundaryFinder_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason___and__(PyObject *self, PyObject *pyArg)
{
    ::QTextBoundaryFinder::BoundaryReasons cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextBoundaryFinder::BoundaryReasons>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextBoundaryFinder::BoundaryReasons>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextBoundaryFinder::BoundaryReasons>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextBoundaryFinder::BoundaryReasons>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason___or__(PyObject *self, PyObject *pyArg)
{
    ::QTextBoundaryFinder::BoundaryReasons cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextBoundaryFinder::BoundaryReasons>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextBoundaryFinder::BoundaryReasons>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextBoundaryFinder::BoundaryReasons>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextBoundaryFinder::BoundaryReasons>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason___xor__(PyObject *self, PyObject *pyArg)
{
    ::QTextBoundaryFinder::BoundaryReasons cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextBoundaryFinder::BoundaryReasons>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextBoundaryFinder::BoundaryReasons>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextBoundaryFinder::BoundaryReasons>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextBoundaryFinder::BoundaryReasons>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason___invert__(PyObject *self, PyObject *pyArg)
{
    ::QTextBoundaryFinder::BoundaryReasons cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX])->converter, self, &cppSelf);
    ::QTextBoundaryFinder::BoundaryReasons cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QTextBoundaryFinder_BoundaryType_PythonToCpp_QTextBoundaryFinder_BoundaryType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextBoundaryFinder::BoundaryType *>(cppOut) =
        static_cast<::QTextBoundaryFinder::BoundaryType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextBoundaryFinder_BoundaryType_PythonToCpp_QTextBoundaryFinder_BoundaryType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX]))
        return QTextBoundaryFinder_BoundaryType_PythonToCpp_QTextBoundaryFinder_BoundaryType;
    return {};
}
static PyObject *QTextBoundaryFinder_BoundaryType_CppToPython_QTextBoundaryFinder_BoundaryType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextBoundaryFinder::BoundaryType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX], castCppIn);

}

static void QTextBoundaryFinder_BoundaryReason_PythonToCpp_QTextBoundaryFinder_BoundaryReason(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextBoundaryFinder::BoundaryReason *>(cppOut) =
        static_cast<::QTextBoundaryFinder::BoundaryReason>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextBoundaryFinder_BoundaryReason_PythonToCpp_QTextBoundaryFinder_BoundaryReason_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX]))
        return QTextBoundaryFinder_BoundaryReason_PythonToCpp_QTextBoundaryFinder_BoundaryReason;
    return {};
}
static PyObject *QTextBoundaryFinder_BoundaryReason_CppToPython_QTextBoundaryFinder_BoundaryReason(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextBoundaryFinder::BoundaryReason *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX], castCppIn);

}

static void QFlags_QTextBoundaryFinder_BoundaryReason__PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextBoundaryFinder::BoundaryReason> *>(cppOut) =
        ::QFlags<QTextBoundaryFinder::BoundaryReason>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QTextBoundaryFinder_BoundaryReason__PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX]))
        return QFlags_QTextBoundaryFinder_BoundaryReason__PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason_;
    return {};
}
static PyObject *QFlags_QTextBoundaryFinder_BoundaryReason__CppToPython_QFlags_QTextBoundaryFinder_BoundaryReason_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QTextBoundaryFinder::BoundaryReason> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX]));

}

static void QTextBoundaryFinder_BoundaryReason_PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextBoundaryFinder::BoundaryReason> *>(cppOut) =
        ::QFlags<QTextBoundaryFinder::BoundaryReason>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QTextBoundaryFinder_BoundaryReason_PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX]))
        return QTextBoundaryFinder_BoundaryReason_PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason_;
    return {};
}
static void number_PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QTextBoundaryFinder::BoundaryReason> *>(cppOut) =
        ::QFlags<QTextBoundaryFinder::BoundaryReason>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX]))
        return number_PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextBoundaryFinder_PythonToCpp_QTextBoundaryFinder_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextBoundaryFinder_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextBoundaryFinder_PythonToCpp_QTextBoundaryFinder_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextBoundaryFinder_TypeF())))
        return QTextBoundaryFinder_PythonToCpp_QTextBoundaryFinder_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextBoundaryFinder_PTR_CppToPython_QTextBoundaryFinder(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextBoundaryFinder *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextBoundaryFinder_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTextBoundaryFinder_COPY_CppToPython_QTextBoundaryFinder(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextBoundaryFinder_TypeF(), new ::QTextBoundaryFinder(*reinterpret_cast<const ::QTextBoundaryFinder *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTextBoundaryFinder_PythonToCpp_QTextBoundaryFinder_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextBoundaryFinder *>(cppOut) = *reinterpret_cast< ::QTextBoundaryFinder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTextBoundaryFinder_PythonToCpp_QTextBoundaryFinder_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextBoundaryFinder_TypeF())))
        return QTextBoundaryFinder_PythonToCpp_QTextBoundaryFinder_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextBoundaryFinder_SignatureStrings[] = {
    "2:PySide2.QtCore.QTextBoundaryFinder(self)",
    "1:PySide2.QtCore.QTextBoundaryFinder(self,type:PySide2.QtCore.QTextBoundaryFinder.BoundaryType,string:QString)",
    "0:PySide2.QtCore.QTextBoundaryFinder(self,other:PySide2.QtCore.QTextBoundaryFinder)",
    "PySide2.QtCore.QTextBoundaryFinder.boundaryReasons(self)->PySide2.QtCore.QTextBoundaryFinder.BoundaryReasons",
    "PySide2.QtCore.QTextBoundaryFinder.isAtBoundary(self)->bool",
    "PySide2.QtCore.QTextBoundaryFinder.isValid(self)->bool",
    "PySide2.QtCore.QTextBoundaryFinder.position(self)->int",
    "PySide2.QtCore.QTextBoundaryFinder.setPosition(self,position:int)",
    "PySide2.QtCore.QTextBoundaryFinder.string(self)->QString",
    "PySide2.QtCore.QTextBoundaryFinder.toEnd(self)",
    "PySide2.QtCore.QTextBoundaryFinder.toNextBoundary(self)->int",
    "PySide2.QtCore.QTextBoundaryFinder.toPreviousBoundary(self)->int",
    "PySide2.QtCore.QTextBoundaryFinder.toStart(self)",
    "PySide2.QtCore.QTextBoundaryFinder.type(self)->PySide2.QtCore.QTextBoundaryFinder.BoundaryType",
    "PySide2.QtCore.QTextBoundaryFinder.__copy__()",
    nullptr}; // Sentinel

void init_QTextBoundaryFinder(PyObject *module)
{
    _Sbk_QTextBoundaryFinder_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextBoundaryFinder",
        "QTextBoundaryFinder",
        &Sbk_QTextBoundaryFinder_spec,
        &Shiboken::callCppDestructor< ::QTextBoundaryFinder >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextBoundaryFinder_Type);
    InitSignatureStrings(pyType, QTextBoundaryFinder_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextBoundaryFinder_Type), Sbk_QTextBoundaryFinder_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextBoundaryFinder_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextBoundaryFinder_TypeF(),
        QTextBoundaryFinder_PythonToCpp_QTextBoundaryFinder_PTR,
        is_QTextBoundaryFinder_PythonToCpp_QTextBoundaryFinder_PTR_Convertible,
        QTextBoundaryFinder_PTR_CppToPython_QTextBoundaryFinder,
        QTextBoundaryFinder_COPY_CppToPython_QTextBoundaryFinder);

    Shiboken::Conversions::registerConverterName(converter, "QTextBoundaryFinder");
    Shiboken::Conversions::registerConverterName(converter, "QTextBoundaryFinder*");
    Shiboken::Conversions::registerConverterName(converter, "QTextBoundaryFinder&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextBoundaryFinder).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTextBoundaryFinder_PythonToCpp_QTextBoundaryFinder_COPY,
        is_QTextBoundaryFinder_PythonToCpp_QTextBoundaryFinder_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'BoundaryType'.
    SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextBoundaryFinder_TypeF(),
        "BoundaryType",
        "2:PySide2.QtCore.QTextBoundaryFinder.BoundaryType",
        "QTextBoundaryFinder::BoundaryType");
    if (!SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX],
        Sbk_QTextBoundaryFinder_TypeF(), "Grapheme", (long) QTextBoundaryFinder::BoundaryType::Grapheme))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX],
        Sbk_QTextBoundaryFinder_TypeF(), "Word", (long) QTextBoundaryFinder::BoundaryType::Word))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX],
        Sbk_QTextBoundaryFinder_TypeF(), "Sentence", (long) QTextBoundaryFinder::BoundaryType::Sentence))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX],
        Sbk_QTextBoundaryFinder_TypeF(), "Line", (long) QTextBoundaryFinder::BoundaryType::Line))
        return;
    // Register converter for enum 'QTextBoundaryFinder::BoundaryType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX],
            QTextBoundaryFinder_BoundaryType_CppToPython_QTextBoundaryFinder_BoundaryType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextBoundaryFinder_BoundaryType_PythonToCpp_QTextBoundaryFinder_BoundaryType,
            is_QTextBoundaryFinder_BoundaryType_PythonToCpp_QTextBoundaryFinder_BoundaryType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextBoundaryFinder::BoundaryType");
        Shiboken::Conversions::registerConverterName(converter, "BoundaryType");
    }
    // End of 'BoundaryType' enum.

    // Initialization of enum 'BoundaryReason'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QTextBoundaryFinder.BoundaryReasons", SbkPySide2_QtCore_QTextBoundaryFinder_BoundaryReason_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextBoundaryFinder_TypeF(),
        "BoundaryReason",
        "2:PySide2.QtCore.QTextBoundaryFinder.BoundaryReason",
        "QTextBoundaryFinder::BoundaryReason",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX],
        Sbk_QTextBoundaryFinder_TypeF(), "NotAtBoundary", (long) QTextBoundaryFinder::BoundaryReason::NotAtBoundary))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX],
        Sbk_QTextBoundaryFinder_TypeF(), "BreakOpportunity", (long) QTextBoundaryFinder::BoundaryReason::BreakOpportunity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX],
        Sbk_QTextBoundaryFinder_TypeF(), "StartOfItem", (long) QTextBoundaryFinder::BoundaryReason::StartOfItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX],
        Sbk_QTextBoundaryFinder_TypeF(), "EndOfItem", (long) QTextBoundaryFinder::BoundaryReason::EndOfItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX],
        Sbk_QTextBoundaryFinder_TypeF(), "MandatoryBreak", (long) QTextBoundaryFinder::BoundaryReason::MandatoryBreak))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX],
        Sbk_QTextBoundaryFinder_TypeF(), "SoftHyphen", (long) QTextBoundaryFinder::BoundaryReason::SoftHyphen))
        return;
    // Register converter for enum 'QTextBoundaryFinder::BoundaryReason'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX],
            QTextBoundaryFinder_BoundaryReason_CppToPython_QTextBoundaryFinder_BoundaryReason);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextBoundaryFinder_BoundaryReason_PythonToCpp_QTextBoundaryFinder_BoundaryReason,
            is_QTextBoundaryFinder_BoundaryReason_PythonToCpp_QTextBoundaryFinder_BoundaryReason_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextBoundaryFinder::BoundaryReason");
        Shiboken::Conversions::registerConverterName(converter, "BoundaryReason");
    }
    // Register converter for flag 'QFlags<QTextBoundaryFinder::BoundaryReason>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX],
            QFlags_QTextBoundaryFinder_BoundaryReason__CppToPython_QFlags_QTextBoundaryFinder_BoundaryReason_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextBoundaryFinder_BoundaryReason_PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason_,
            is_QTextBoundaryFinder_BoundaryReason_PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QTextBoundaryFinder_BoundaryReason__PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason_,
            is_QFlags_QTextBoundaryFinder_BoundaryReason__PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason_,
            is_number_PythonToCpp_QFlags_QTextBoundaryFinder_BoundaryReason__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextBoundaryFinder::BoundaryReasons");
        Shiboken::Conversions::registerConverterName(converter, "BoundaryReasons");
    }
    // End of 'BoundaryReason' enum/flags.

    qRegisterMetaType< ::QTextBoundaryFinder >("QTextBoundaryFinder");
    qRegisterMetaType< ::QTextBoundaryFinder::BoundaryType >("QTextBoundaryFinder::BoundaryType");
    qRegisterMetaType< ::QTextBoundaryFinder::BoundaryReason >("QTextBoundaryFinder::BoundaryReason");
    qRegisterMetaType< ::QTextBoundaryFinder::BoundaryReasons >("QTextBoundaryFinder::BoundaryReasons");
}
