/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qtextcodec_converterstate_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextCodec_ConverterState_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextCodec::ConverterState >()))
        return -1;

    ::QTextCodec::ConverterState *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextCodec.ConverterState.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextCodec_ConverterState_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:ConverterState", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: ConverterState::ConverterState(QFlags<QTextCodec::ConversionFlag>)
    if (numArgs == 0) {
        overloadId = 0; // ConverterState(QFlags<QTextCodec::ConversionFlag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // ConverterState(QFlags<QTextCodec::ConversionFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCodec_ConverterState_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_f = Shiboken::String::createStaticString("f");
            if (PyDict_Contains(kwds, key_f)) {
                value = PyDict_GetItem(kwds, key_f);
                if (value && pyArgs[0]) {
                    errInfo = key_f;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextCodec_ConverterState_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QTextCodec_ConverterState_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_f);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextCodec_ConverterState_Init_TypeError;
            }
        }
        ::QFlags<QTextCodec::ConversionFlag> cppArg0 = QTextCodec::DefaultConversion;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // ConverterState(QFlags<QTextCodec::ConversionFlag>)
            cptr = new ::QTextCodec::ConverterState(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextCodec::ConverterState >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextCodec_ConverterState_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextCodec_ConverterState_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QTextCodec_ConverterState_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextCodec_ConverterState_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QTextCodec_ConverterState_get_flags(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTextCodec::ConverterState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, &cppSelf->flags);
    return pyOut;
}
static int Sbk_QTextCodec_ConverterState_set_flags(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTextCodec::ConverterState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'flags' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'flags', 'ConversionFlags' or convertible type expected");
        return -1;
    }

    ::QFlags<QTextCodec::ConversionFlag> cppOut_local = cppSelf->flags;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->flags = cppOut_local;

    return 0;
}

static PyObject *Sbk_QTextCodec_ConverterState_get_remainingChars(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTextCodec::ConverterState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->remainingChars;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QTextCodec_ConverterState_set_remainingChars(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTextCodec::ConverterState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'remainingChars' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'remainingChars', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->remainingChars;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->remainingChars = cppOut_local;

    return 0;
}

static PyObject *Sbk_QTextCodec_ConverterState_get_invalidChars(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTextCodec::ConverterState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->invalidChars;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QTextCodec_ConverterState_set_invalidChars(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTextCodec::ConverterState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'invalidChars' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'invalidChars', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->invalidChars;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->invalidChars = cppOut_local;

    return 0;
}

// Getters and Setters for ConverterState
static PyGetSetDef Sbk_QTextCodec_ConverterState_getsetlist[] = {
    {const_cast<char *>("flags"), Sbk_QTextCodec_ConverterState_get_flags, Sbk_QTextCodec_ConverterState_set_flags},
    {const_cast<char *>("remainingChars"), Sbk_QTextCodec_ConverterState_get_remainingChars, Sbk_QTextCodec_ConverterState_set_remainingChars},
    {const_cast<char *>("invalidChars"), Sbk_QTextCodec_ConverterState_get_invalidChars, Sbk_QTextCodec_ConverterState_set_invalidChars},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextCodec_ConverterState_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextCodec_ConverterState_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextCodec_ConverterState_Type = nullptr;
static SbkObjectType *Sbk_QTextCodec_ConverterState_TypeF(void)
{
    return _Sbk_QTextCodec_ConverterState_Type;
}

static PyType_Slot Sbk_QTextCodec_ConverterState_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextCodec_ConverterState_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextCodec_ConverterState_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextCodec_ConverterState_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QTextCodec_ConverterState_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextCodec_ConverterState_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextCodec_ConverterState_spec = {
    "2:PySide2.QtCore.QTextCodec.ConverterState",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextCodec_ConverterState_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void ConverterState_PythonToCpp_ConverterState_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextCodec_ConverterState_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_ConverterState_PythonToCpp_ConverterState_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextCodec_ConverterState_TypeF())))
        return ConverterState_PythonToCpp_ConverterState_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *ConverterState_PTR_CppToPython_ConverterState(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextCodec::ConverterState *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextCodec_ConverterState_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextCodec_ConverterState_SignatureStrings[] = {
    "PySide2.QtCore.QTextCodec.ConverterState(self,f:PySide2.QtCore.QTextCodec.ConversionFlags=QTextCodec.DefaultConversion)",
    nullptr}; // Sentinel

void init_QTextCodec_ConverterState(PyObject *enclosingClass)
{
    _Sbk_QTextCodec_ConverterState_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "ConverterState",
        "QTextCodec::ConverterState*",
        &Sbk_QTextCodec_ConverterState_spec,
        &Shiboken::callCppDestructor< ::QTextCodec::ConverterState >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextCodec_ConverterState_Type);
    InitSignatureStrings(pyType, QTextCodec_ConverterState_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextCodec_ConverterState_Type), Sbk_QTextCodec_ConverterState_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextCodec_ConverterState_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextCodec_ConverterState_TypeF(),
        ConverterState_PythonToCpp_ConverterState_PTR,
        is_ConverterState_PythonToCpp_ConverterState_PTR_Convertible,
        ConverterState_PTR_CppToPython_ConverterState);

    Shiboken::Conversions::registerConverterName(converter, "QTextCodec::ConverterState");
    Shiboken::Conversions::registerConverterName(converter, "QTextCodec::ConverterState*");
    Shiboken::Conversions::registerConverterName(converter, "QTextCodec::ConverterState&");
    Shiboken::Conversions::registerConverterName(converter, "ConverterState");
    Shiboken::Conversions::registerConverterName(converter, "ConverterState*");
    Shiboken::Conversions::registerConverterName(converter, "ConverterState&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextCodec::ConverterState).name());


}
