/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qtextstream_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QTextStreamWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QTextStreamWrapper::QTextStreamWrapper() : QTextStream()
{
    resetPyMethodCache();
    // ... middle
}

QTextStreamWrapper::QTextStreamWrapper(::QByteArray * array, ::QFlags<QIODevice::OpenModeFlag> openMode) : QTextStream(array, openMode)
{
    resetPyMethodCache();
    // ... middle
}

QTextStreamWrapper::QTextStreamWrapper(::QIODevice * device) : QTextStream(device)
{
    resetPyMethodCache();
    // ... middle
}

QTextStreamWrapper::~QTextStreamWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextStream_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextStream >()))
        return -1;

    ::QTextStreamWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextStream_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QTextStream", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QTextStream::QTextStream()
    // 1: QTextStream::QTextStream(QByteArray*,QFlags<QIODevice::OpenModeFlag>)
    // 2: QTextStream::QTextStream(QIODevice*)
    if (numArgs == 0) {
        overloadId = 0; // QTextStream()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QTextStream(QIODevice*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QTextStream(QByteArray*,QFlags<QIODevice::OpenModeFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // QTextStream(QByteArray*,QFlags<QIODevice::OpenModeFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStream_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextStream()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTextStream_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QTextStream()
                cptr = new ::QTextStreamWrapper();
            }
            break;
        }
        case 1: // QTextStream(QByteArray * array, QFlags<QIODevice::OpenModeFlag> openMode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_openMode = Shiboken::String::createStaticString("openMode");
                if (PyDict_Contains(kwds, key_openMode)) {
                    value = PyDict_GetItem(kwds, key_openMode);
                    if (value && pyArgs[1]) {
                        errInfo = key_openMode;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextStream_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QTextStream_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_openMode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTextStream_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QIODevice::OpenModeFlag> cppArg1 = QIODevice::ReadWrite;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QTextStream(QByteArray*,QFlags<QIODevice::OpenModeFlag>)
                cptr = new ::QTextStreamWrapper(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QTextStream(QIODevice * device)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTextStream_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QTextStream(QIODevice*)
                cptr = new ::QTextStreamWrapper(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextStream >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextStream_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextStream_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextStreamFunc_atEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.atEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // atEnd()const
            bool cppResult = const_cast<const ::QTextStream *>(cppSelf)->atEnd();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_autoDetectUnicode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.autoDetectUnicode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoDetectUnicode()const
            bool cppResult = const_cast<const ::QTextStream *>(cppSelf)->autoDetectUnicode();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_codec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.codec";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // codec()const
            QTextCodec * cppResult = const_cast<const ::QTextStream *>(cppSelf)->codec();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QIODevice * cppResult = const_cast<const ::QTextStream *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_fieldAlignment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.fieldAlignment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fieldAlignment()const
            QTextStream::FieldAlignment cppResult = const_cast<const ::QTextStream *>(cppSelf)->fieldAlignment();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_fieldWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.fieldWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fieldWidth()const
            int cppResult = const_cast<const ::QTextStream *>(cppSelf)->fieldWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_flush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.flush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flush()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->flush();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextStreamFunc_generateByteOrderMark(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.generateByteOrderMark";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // generateByteOrderMark()const
            bool cppResult = const_cast<const ::QTextStream *>(cppSelf)->generateByteOrderMark();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_integerBase(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.integerBase";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // integerBase()const
            int cppResult = const_cast<const ::QTextStream *>(cppSelf)->integerBase();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_locale(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.locale";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // locale()const
            QLocale cppResult = const_cast<const ::QTextStream *>(cppSelf)->locale();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_numberFlags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.numberFlags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // numberFlags()const
            QFlags<QTextStream::NumberFlag> cppResult = const_cast<const ::QTextStream *>(cppSelf)->numberFlags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_padChar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.padChar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // padChar()const
            QChar cppResult = const_cast<const ::QTextStream *>(cppSelf)->padChar();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.pos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pos()const
            qint64 cppResult = const_cast<const ::QTextStream *>(cppSelf)->pos();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_read(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.read";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::read(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // read(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_read_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // read(qint64)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            QString cppResult = cppSelf->read(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextStreamFunc_read_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_readAll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.readAll";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readAll()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            QString cppResult = cppSelf->readAll();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_readLine(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.readLine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextStreamFunc_readLine_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:readLine", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTextStream::readLine(qint64)
    if (numArgs == 0) {
        overloadId = 0; // readLine(qint64)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        overloadId = 0; // readLine(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_readLine_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_maxlen = Shiboken::String::createStaticString("maxlen");
            if (PyDict_Contains(kwds, key_maxlen)) {
                value = PyDict_GetItem(kwds, key_maxlen);
                if (value && pyArgs[0]) {
                    errInfo = key_maxlen;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextStreamFunc_readLine_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0]))))
                        goto Sbk_QTextStreamFunc_readLine_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_maxlen);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextStreamFunc_readLine_TypeError;
            }
        }
        qint64 cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // readLine(qint64)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            QString cppResult = cppSelf->readLine(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextStreamFunc_readLine_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_realNumberNotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.realNumberNotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // realNumberNotation()const
            QTextStream::RealNumberNotation cppResult = const_cast<const ::QTextStream *>(cppSelf)->realNumberNotation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_realNumberPrecision(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.realNumberPrecision";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // realNumberPrecision()const
            int cppResult = const_cast<const ::QTextStream *>(cppSelf)->realNumberPrecision();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.reset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reset()
            cppSelf->reset();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextStreamFunc_resetStatus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.resetStatus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetStatus()
            cppSelf->resetStatus();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextStreamFunc_seek(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.seek";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::seek(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // seek(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_seek_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // seek(qint64)
            bool cppResult = cppSelf->seek(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextStreamFunc_seek_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setAutoDetectUnicode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setAutoDetectUnicode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setAutoDetectUnicode(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoDetectUnicode(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setAutoDetectUnicode_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoDetectUnicode(bool)
            cppSelf->setAutoDetectUnicode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setAutoDetectUnicode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setCodec(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setCodec";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setCodec(QTextCodec*)
    // 1: QTextStream::setCodec(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 1; // setCodec(const char*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), (pyArg)))) {
        overloadId = 0; // setCodec(QTextCodec*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setCodec_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setCodec(QTextCodec * codec)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QTextCodec *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setCodec(QTextCodec*)
                cppSelf->setCodec(cppArg0);
            }
            break;
        }
        case 1: // setCodec(const char * codecName)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setCodec(const char*)
                cppSelf->setCodec(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setCodec_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setDevice(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setDevice(QIODevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // setDevice(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setDevice_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIODevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevice(QIODevice*)
            cppSelf->setDevice(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setFieldAlignment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setFieldAlignment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setFieldAlignment(QTextStream::FieldAlignment)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFieldAlignment(QTextStream::FieldAlignment)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setFieldAlignment_TypeError;

    // Call function/method
    {
        ::QTextStream::FieldAlignment cppArg0{QTextStream::AlignLeft};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFieldAlignment(QTextStream::FieldAlignment)
            cppSelf->setFieldAlignment(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setFieldAlignment_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setFieldWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setFieldWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setFieldWidth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setFieldWidth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setFieldWidth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFieldWidth(int)
            cppSelf->setFieldWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setFieldWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setGenerateByteOrderMark(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setGenerateByteOrderMark";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setGenerateByteOrderMark(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setGenerateByteOrderMark(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setGenerateByteOrderMark_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGenerateByteOrderMark(bool)
            cppSelf->setGenerateByteOrderMark(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setGenerateByteOrderMark_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setIntegerBase(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setIntegerBase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setIntegerBase(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setIntegerBase(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setIntegerBase_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setIntegerBase(int)
            cppSelf->setIntegerBase(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setIntegerBase_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setLocale(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setLocale";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setLocale(QLocale)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArg)))) {
        overloadId = 0; // setLocale(QLocale)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setLocale_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLocale(QLocale)
            cppSelf->setLocale(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setLocale_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setNumberFlags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setNumberFlags";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setNumberFlags(QFlags<QTextStream::NumberFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setNumberFlags(QFlags<QTextStream::NumberFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setNumberFlags_TypeError;

    // Call function/method
    {
        ::QFlags<QTextStream::NumberFlag> cppArg0 = QFlags<QTextStream::NumberFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNumberFlags(QFlags<QTextStream::NumberFlag>)
            cppSelf->setNumberFlags(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setNumberFlags_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setPadChar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setPadChar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setPadChar(QChar)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArg)))) {
        overloadId = 0; // setPadChar(QChar)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setPadChar_TypeError;

    // Call function/method
    {
        ::QChar cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPadChar(QChar)
            cppSelf->setPadChar(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setPadChar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setRealNumberNotation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setRealNumberNotation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setRealNumberNotation(QTextStream::RealNumberNotation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setRealNumberNotation(QTextStream::RealNumberNotation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setRealNumberNotation_TypeError;

    // Call function/method
    {
        ::QTextStream::RealNumberNotation cppArg0{QTextStream::SmartNotation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRealNumberNotation(QTextStream::RealNumberNotation)
            cppSelf->setRealNumberNotation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setRealNumberNotation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setRealNumberPrecision(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setRealNumberPrecision";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setRealNumberPrecision(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setRealNumberPrecision(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setRealNumberPrecision_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRealNumberPrecision(int)
            cppSelf->setRealNumberPrecision(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setRealNumberPrecision_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_setStatus(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.setStatus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStream::setStatus(QTextStream::Status)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStatus(QTextStream::Status)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamFunc_setStatus_TypeError;

    // Call function/method
    {
        ::QTextStream::Status cppArg0{QTextStream::Ok};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStatus(QTextStream::Status)
            cppSelf->setStatus(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamFunc_setStatus_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc_skipWhiteSpace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.skipWhiteSpace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // skipWhiteSpace()
            cppSelf->skipWhiteSpace();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextStreamFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.status";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // status()const
            QTextStream::Status cppResult = const_cast<const ::QTextStream *>(cppSelf)->status();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextStreamFunc_string(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.string";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // string()const
            QString * cppResult = const_cast<const ::QTextStream *>(cppSelf)->string();
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (return-qstring-ref)]
            QString &res = *cppResult;
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &res);
            // END of custom code block [file: ../glue/qtcore.cpp (return-qstring-ref)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextStream_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextStream_methods[] = {
    {"atEnd", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_atEnd), METH_NOARGS},
    {"autoDetectUnicode", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_autoDetectUnicode), METH_NOARGS},
    {"codec", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_codec), METH_NOARGS},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_device), METH_NOARGS},
    {"fieldAlignment", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_fieldAlignment), METH_NOARGS},
    {"fieldWidth", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_fieldWidth), METH_NOARGS},
    {"flush", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_flush), METH_NOARGS},
    {"generateByteOrderMark", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_generateByteOrderMark), METH_NOARGS},
    {"integerBase", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_integerBase), METH_NOARGS},
    {"locale", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_locale), METH_NOARGS},
    {"numberFlags", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_numberFlags), METH_NOARGS},
    {"padChar", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_padChar), METH_NOARGS},
    {"pos", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_pos), METH_NOARGS},
    {"read", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_read), METH_O},
    {"readAll", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_readAll), METH_NOARGS},
    {"readLine", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_readLine), METH_VARARGS|METH_KEYWORDS},
    {"realNumberNotation", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_realNumberNotation), METH_NOARGS},
    {"realNumberPrecision", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_realNumberPrecision), METH_NOARGS},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_reset), METH_NOARGS},
    {"resetStatus", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_resetStatus), METH_NOARGS},
    {"seek", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_seek), METH_O},
    {"setAutoDetectUnicode", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setAutoDetectUnicode), METH_O},
    {"setCodec", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setCodec), METH_O},
    {"setDevice", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setDevice), METH_O},
    {"setFieldAlignment", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setFieldAlignment), METH_O},
    {"setFieldWidth", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setFieldWidth), METH_O},
    {"setGenerateByteOrderMark", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setGenerateByteOrderMark), METH_O},
    {"setIntegerBase", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setIntegerBase), METH_O},
    {"setLocale", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setLocale), METH_O},
    {"setNumberFlags", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setNumberFlags), METH_O},
    {"setPadChar", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setPadChar), METH_O},
    {"setRealNumberNotation", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setRealNumberNotation), METH_O},
    {"setRealNumberPrecision", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setRealNumberPrecision), METH_O},
    {"setStatus", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_setStatus), METH_O},
    {"skipWhiteSpace", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_skipWhiteSpace), METH_NOARGS},
    {"status", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_status), METH_NOARGS},
    {"string", reinterpret_cast<PyCFunction>(Sbk_QTextStreamFunc_string), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QTextStream_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QTextStreamWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

static PyObject *Sbk_QTextStreamFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QTextStream::operator<<(QChar)
        // 1: QTextStream::operator<<(QTextStream&,QTextStreamManipulator)
        // 2: QTextStream::operator<<(char)
        // 3: QTextStream::operator<<(QByteArray)
        // 4: QTextStream::operator<<(QString)
        // 5: QTextStream::operator<<(QStringRef)
        // 6: QTextStream::operator<<(double)
        // 7: QTextStream::operator<<(long)
        // 8: QTextStream::operator<<(ulong)
        if (!isReverse
            && PyLong_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArg)))) {
            overloadId = 8; // operator<<(ulong)
        } else if (!isReverse
            && PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
            overloadId = 6; // operator<<(double)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long>(), (pyArg)))) {
            overloadId = 7; // operator<<(long)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
            overloadId = 5; // operator<<(QStringRef)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
            overloadId = 4; // operator<<(QString)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
            overloadId = 3; // operator<<(QByteArray)
        } else if (!isReverse
            && SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
            overloadId = 2; // operator<<(char)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAMMANIPULATOR_IDX]), (pyArg)))) {
            overloadId = 1; // operator<<(QTextStream&,QTextStreamManipulator)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArg)))) {
            overloadId = 0; // operator<<(QChar)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QTextStreamFunc___lshift___TypeError;

        // Call function/method
        switch (overloadId) {
            case 0: // operator<<(QChar ch)
            {
                ::QChar cppArg0;
                pythonToCpp(pyArg, &cppArg0);

                if (!PyErr_Occurred()) {
                    // operator<<(QChar)
                    QTextStream & cppResult = (*cppSelf) << cppArg0;
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 1: // operator<<(QTextStreamManipulator m)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextStreamManipulator cppArg0 = QTextStreamManipulator(0, 0);
                pythonToCpp(pyArg, &cppArg0);

                if (!PyErr_Occurred()) {
                    // operator<<(QTextStream&,QTextStreamManipulator)
                    QTextStream & cppResult = (*cppSelf) << cppArg0;
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 2: // operator<<(char ch)
            {
                char cppArg0;
                pythonToCpp(pyArg, &cppArg0);

                if (!PyErr_Occurred()) {
                    // operator<<(char)
                    QTextStream & cppResult = (*cppSelf) << cppArg0;
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 3: // operator<<(const QByteArray & array)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QByteArray cppArg0_local;
                ::QByteArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QByteArray)
                    QTextStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 4: // operator<<(const QString & s)
            {
                ::QString cppArg0;
                pythonToCpp(pyArg, &cppArg0);

                if (!PyErr_Occurred()) {
                    // operator<<(QString)
                    QTextStream & cppResult = (*cppSelf) << cppArg0;
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 5: // operator<<(const QStringRef & s)
            {
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);

                if (!PyErr_Occurred()) {
                    // operator<<(QStringRef)
                    QTextStream & cppResult = (*cppSelf) << cppArg0;
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 6: // operator<<(double f)
            {
                double cppArg0;
                pythonToCpp(pyArg, &cppArg0);

                if (!PyErr_Occurred()) {
                    // operator<<(double)
                    QTextStream & cppResult = (*cppSelf) << cppArg0;
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 7: // operator<<(long i)
            {
                long cppArg0;
                pythonToCpp(pyArg, &cppArg0);

                if (!PyErr_Occurred()) {
                    // operator<<(long)
                    QTextStream & cppResult = (*cppSelf) << cppArg0;
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 8: // operator<<(unsigned long i)
            {
                unsigned long cppArg0;
                pythonToCpp(pyArg, &cppArg0);

                if (!PyErr_Occurred()) {
                    // operator<<(ulong)
                    QTextStream & cppResult = (*cppSelf) << cppArg0;
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
                }
                break;
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextStreamFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStream.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QTextStream::operator>>(QByteArray&)
        if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QByteArray&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QTextStreamFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator>>(QByteArray&)
                QTextStream & cppResult = (*cppSelf) >> (*cppArg0);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextStreamFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

} // extern "C"

static int Sbk_QTextStream_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextStream_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextStream_Type = nullptr;
static SbkObjectType *Sbk_QTextStream_TypeF(void)
{
    return _Sbk_QTextStream_Type;
}

static PyType_Slot Sbk_QTextStream_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QTextStream_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextStream_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextStream_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextStream_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextStream_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QTextStreamFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QTextStreamFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextStream_spec = {
    "2:PySide2.QtCore.QTextStream",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextStream_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_QTextStream_NumberFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QTextStream::NumberFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextStream::NumberFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextStream::NumberFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextStream::NumberFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextStream::NumberFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QTextStream_NumberFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QTextStream::NumberFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextStream::NumberFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextStream::NumberFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextStream::NumberFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextStream::NumberFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QTextStream_NumberFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QTextStream::NumberFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextStream::NumberFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextStream::NumberFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextStream::NumberFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextStream::NumberFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QTextStream_NumberFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QTextStream::NumberFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX])->converter, self, &cppSelf);
    ::QTextStream::NumberFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QTextStream_NumberFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QTextStream_NumberFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QTextStream_NumberFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QTextStream_NumberFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QTextStream_NumberFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QTextStream_NumberFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QTextStream_NumberFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QTextStream_NumberFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QTextStream_NumberFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QTextStream_NumberFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QTextStream_NumberFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QTextStream_NumberFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QTextStream_NumberFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QTextStream_RealNumberNotation_PythonToCpp_QTextStream_RealNumberNotation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextStream::RealNumberNotation *>(cppOut) =
        static_cast<::QTextStream::RealNumberNotation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextStream_RealNumberNotation_PythonToCpp_QTextStream_RealNumberNotation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX]))
        return QTextStream_RealNumberNotation_PythonToCpp_QTextStream_RealNumberNotation;
    return {};
}
static PyObject *QTextStream_RealNumberNotation_CppToPython_QTextStream_RealNumberNotation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextStream::RealNumberNotation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX], castCppIn);

}

static void QTextStream_FieldAlignment_PythonToCpp_QTextStream_FieldAlignment(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextStream::FieldAlignment *>(cppOut) =
        static_cast<::QTextStream::FieldAlignment>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextStream_FieldAlignment_PythonToCpp_QTextStream_FieldAlignment_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX]))
        return QTextStream_FieldAlignment_PythonToCpp_QTextStream_FieldAlignment;
    return {};
}
static PyObject *QTextStream_FieldAlignment_CppToPython_QTextStream_FieldAlignment(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextStream::FieldAlignment *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX], castCppIn);

}

static void QTextStream_Status_PythonToCpp_QTextStream_Status(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextStream::Status *>(cppOut) =
        static_cast<::QTextStream::Status>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextStream_Status_PythonToCpp_QTextStream_Status_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX]))
        return QTextStream_Status_PythonToCpp_QTextStream_Status;
    return {};
}
static PyObject *QTextStream_Status_CppToPython_QTextStream_Status(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextStream::Status *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX], castCppIn);

}

static void QTextStream_NumberFlag_PythonToCpp_QTextStream_NumberFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextStream::NumberFlag *>(cppOut) =
        static_cast<::QTextStream::NumberFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextStream_NumberFlag_PythonToCpp_QTextStream_NumberFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX]))
        return QTextStream_NumberFlag_PythonToCpp_QTextStream_NumberFlag;
    return {};
}
static PyObject *QTextStream_NumberFlag_CppToPython_QTextStream_NumberFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextStream::NumberFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX], castCppIn);

}

static void QFlags_QTextStream_NumberFlag__PythonToCpp_QFlags_QTextStream_NumberFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextStream::NumberFlag> *>(cppOut) =
        ::QFlags<QTextStream::NumberFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QTextStream_NumberFlag__PythonToCpp_QFlags_QTextStream_NumberFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX]))
        return QFlags_QTextStream_NumberFlag__PythonToCpp_QFlags_QTextStream_NumberFlag_;
    return {};
}
static PyObject *QFlags_QTextStream_NumberFlag__CppToPython_QFlags_QTextStream_NumberFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QTextStream::NumberFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX]));

}

static void QTextStream_NumberFlag_PythonToCpp_QFlags_QTextStream_NumberFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextStream::NumberFlag> *>(cppOut) =
        ::QFlags<QTextStream::NumberFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QTextStream_NumberFlag_PythonToCpp_QFlags_QTextStream_NumberFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX]))
        return QTextStream_NumberFlag_PythonToCpp_QFlags_QTextStream_NumberFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QTextStream_NumberFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QTextStream::NumberFlag> *>(cppOut) =
        ::QFlags<QTextStream::NumberFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QTextStream_NumberFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX]))
        return number_PythonToCpp_QFlags_QTextStream_NumberFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextStream_PythonToCpp_QTextStream_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextStream_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextStream_PythonToCpp_QTextStream_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextStream_TypeF())))
        return QTextStream_PythonToCpp_QTextStream_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextStream_PTR_CppToPython_QTextStream(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextStream *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextStream_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextStream_SignatureStrings[] = {
    "2:PySide2.QtCore.QTextStream(self)",
    "1:PySide2.QtCore.QTextStream(self,array:PySide2.QtCore.QByteArray,openMode:PySide2.QtCore.QIODevice.OpenMode=QIODevice.ReadWrite)",
    "0:PySide2.QtCore.QTextStream(self,device:PySide2.QtCore.QIODevice)",
    "PySide2.QtCore.QTextStream.atEnd(self)->bool",
    "PySide2.QtCore.QTextStream.autoDetectUnicode(self)->bool",
    "PySide2.QtCore.QTextStream.codec(self)->PySide2.QtCore.QTextCodec",
    "PySide2.QtCore.QTextStream.device(self)->PySide2.QtCore.QIODevice",
    "PySide2.QtCore.QTextStream.fieldAlignment(self)->PySide2.QtCore.QTextStream.FieldAlignment",
    "PySide2.QtCore.QTextStream.fieldWidth(self)->int",
    "PySide2.QtCore.QTextStream.flush(self)",
    "PySide2.QtCore.QTextStream.generateByteOrderMark(self)->bool",
    "PySide2.QtCore.QTextStream.integerBase(self)->int",
    "PySide2.QtCore.QTextStream.locale(self)->PySide2.QtCore.QLocale",
    "PySide2.QtCore.QTextStream.numberFlags(self)->PySide2.QtCore.QTextStream.NumberFlags",
    "PySide2.QtCore.QTextStream.padChar(self)->QChar",
    "PySide2.QtCore.QTextStream.pos(self)->qint64",
    "PySide2.QtCore.QTextStream.read(self,maxlen:qint64)->QString",
    "PySide2.QtCore.QTextStream.readAll(self)->QString",
    "PySide2.QtCore.QTextStream.readLine(self,maxlen:qint64=0)->QString",
    "PySide2.QtCore.QTextStream.realNumberNotation(self)->PySide2.QtCore.QTextStream.RealNumberNotation",
    "PySide2.QtCore.QTextStream.realNumberPrecision(self)->int",
    "PySide2.QtCore.QTextStream.reset(self)",
    "PySide2.QtCore.QTextStream.resetStatus(self)",
    "PySide2.QtCore.QTextStream.seek(self,pos:qint64)->bool",
    "PySide2.QtCore.QTextStream.setAutoDetectUnicode(self,enabled:bool)",
    "1:PySide2.QtCore.QTextStream.setCodec(self,codec:PySide2.QtCore.QTextCodec)",
    "0:PySide2.QtCore.QTextStream.setCodec(self,codecName:char*)",
    "PySide2.QtCore.QTextStream.setDevice(self,device:PySide2.QtCore.QIODevice)",
    "PySide2.QtCore.QTextStream.setFieldAlignment(self,alignment:PySide2.QtCore.QTextStream.FieldAlignment)",
    "PySide2.QtCore.QTextStream.setFieldWidth(self,width:int)",
    "PySide2.QtCore.QTextStream.setGenerateByteOrderMark(self,generate:bool)",
    "PySide2.QtCore.QTextStream.setIntegerBase(self,base:int)",
    "PySide2.QtCore.QTextStream.setLocale(self,locale:PySide2.QtCore.QLocale)",
    "PySide2.QtCore.QTextStream.setNumberFlags(self,flags:PySide2.QtCore.QTextStream.NumberFlags)",
    "PySide2.QtCore.QTextStream.setPadChar(self,ch:QChar)",
    "PySide2.QtCore.QTextStream.setRealNumberNotation(self,notation:PySide2.QtCore.QTextStream.RealNumberNotation)",
    "PySide2.QtCore.QTextStream.setRealNumberPrecision(self,precision:int)",
    "PySide2.QtCore.QTextStream.setStatus(self,status:PySide2.QtCore.QTextStream.Status)",
    "PySide2.QtCore.QTextStream.skipWhiteSpace(self)",
    "PySide2.QtCore.QTextStream.status(self)->PySide2.QtCore.QTextStream.Status",
    "PySide2.QtCore.QTextStream.string(self)->QString*",
    "8:PySide2.QtCore.QTextStream.__lshift__(self,ch:QChar)->PySide2.QtCore.QTextStream",
    "7:PySide2.QtCore.QTextStream.__lshift__(self,m:PySide2.QtCore.QTextStreamManipulator)->PySide2.QtCore.QTextStream",
    "6:PySide2.QtCore.QTextStream.__lshift__(self,ch:char)->PySide2.QtCore.QTextStream",
    "5:PySide2.QtCore.QTextStream.__lshift__(self,array:PySide2.QtCore.QByteArray)->PySide2.QtCore.QTextStream",
    "4:PySide2.QtCore.QTextStream.__lshift__(self,s:QString)->PySide2.QtCore.QTextStream",
    "3:PySide2.QtCore.QTextStream.__lshift__(self,s:QStringRef)->PySide2.QtCore.QTextStream",
    "2:PySide2.QtCore.QTextStream.__lshift__(self,f:double)->PySide2.QtCore.QTextStream",
    "1:PySide2.QtCore.QTextStream.__lshift__(self,i:long)->PySide2.QtCore.QTextStream",
    "0:PySide2.QtCore.QTextStream.__lshift__(self,i:unsigned long)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.QTextStream.__rshift__(self,array:PySide2.QtCore.QByteArray)->PySide2.QtCore.QTextStream",
    nullptr}; // Sentinel

void init_QTextStream(PyObject *module)
{
    _Sbk_QTextStream_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextStream",
        "QTextStream*",
        &Sbk_QTextStream_spec,
        &Shiboken::callCppDestructor< ::QTextStream >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextStream_Type);
    InitSignatureStrings(pyType, QTextStream_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextStream_Type), Sbk_QTextStream_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextStream_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextStream_TypeF(),
        QTextStream_PythonToCpp_QTextStream_PTR,
        is_QTextStream_PythonToCpp_QTextStream_PTR_Convertible,
        QTextStream_PTR_CppToPython_QTextStream);

    Shiboken::Conversions::registerConverterName(converter, "QTextStream");
    Shiboken::Conversions::registerConverterName(converter, "QTextStream*");
    Shiboken::Conversions::registerConverterName(converter, "QTextStream&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextStream).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextStreamWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'RealNumberNotation'.
    SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextStream_TypeF(),
        "RealNumberNotation",
        "2:PySide2.QtCore.QTextStream.RealNumberNotation",
        "QTextStream::RealNumberNotation");
    if (!SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX],
        Sbk_QTextStream_TypeF(), "SmartNotation", (long) QTextStream::RealNumberNotation::SmartNotation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX],
        Sbk_QTextStream_TypeF(), "FixedNotation", (long) QTextStream::RealNumberNotation::FixedNotation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX],
        Sbk_QTextStream_TypeF(), "ScientificNotation", (long) QTextStream::RealNumberNotation::ScientificNotation))
        return;
    // Register converter for enum 'QTextStream::RealNumberNotation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX],
            QTextStream_RealNumberNotation_CppToPython_QTextStream_RealNumberNotation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextStream_RealNumberNotation_PythonToCpp_QTextStream_RealNumberNotation,
            is_QTextStream_RealNumberNotation_PythonToCpp_QTextStream_RealNumberNotation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextStream::RealNumberNotation");
        Shiboken::Conversions::registerConverterName(converter, "RealNumberNotation");
    }
    // End of 'RealNumberNotation' enum.

    // Initialization of enum 'FieldAlignment'.
    SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextStream_TypeF(),
        "FieldAlignment",
        "2:PySide2.QtCore.QTextStream.FieldAlignment",
        "QTextStream::FieldAlignment");
    if (!SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX],
        Sbk_QTextStream_TypeF(), "AlignLeft", (long) QTextStream::FieldAlignment::AlignLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX],
        Sbk_QTextStream_TypeF(), "AlignRight", (long) QTextStream::FieldAlignment::AlignRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX],
        Sbk_QTextStream_TypeF(), "AlignCenter", (long) QTextStream::FieldAlignment::AlignCenter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX],
        Sbk_QTextStream_TypeF(), "AlignAccountingStyle", (long) QTextStream::FieldAlignment::AlignAccountingStyle))
        return;
    // Register converter for enum 'QTextStream::FieldAlignment'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX],
            QTextStream_FieldAlignment_CppToPython_QTextStream_FieldAlignment);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextStream_FieldAlignment_PythonToCpp_QTextStream_FieldAlignment,
            is_QTextStream_FieldAlignment_PythonToCpp_QTextStream_FieldAlignment_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextStream::FieldAlignment");
        Shiboken::Conversions::registerConverterName(converter, "FieldAlignment");
    }
    // End of 'FieldAlignment' enum.

    // Initialization of enum 'Status'.
    SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextStream_TypeF(),
        "Status",
        "2:PySide2.QtCore.QTextStream.Status",
        "QTextStream::Status");
    if (!SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX],
        Sbk_QTextStream_TypeF(), "Ok", (long) QTextStream::Status::Ok))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX],
        Sbk_QTextStream_TypeF(), "ReadPastEnd", (long) QTextStream::Status::ReadPastEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX],
        Sbk_QTextStream_TypeF(), "ReadCorruptData", (long) QTextStream::Status::ReadCorruptData))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX],
        Sbk_QTextStream_TypeF(), "WriteFailed", (long) QTextStream::Status::WriteFailed))
        return;
    // Register converter for enum 'QTextStream::Status'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX],
            QTextStream_Status_CppToPython_QTextStream_Status);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextStream_Status_PythonToCpp_QTextStream_Status,
            is_QTextStream_Status_PythonToCpp_QTextStream_Status_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextStream::Status");
        Shiboken::Conversions::registerConverterName(converter, "Status");
    }
    // End of 'Status' enum.

    // Initialization of enum 'NumberFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QTextStream.NumberFlags", SbkPySide2_QtCore_QTextStream_NumberFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextStream_TypeF(),
        "NumberFlag",
        "2:PySide2.QtCore.QTextStream.NumberFlag",
        "QTextStream::NumberFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX],
        Sbk_QTextStream_TypeF(), "ShowBase", (long) QTextStream::NumberFlag::ShowBase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX],
        Sbk_QTextStream_TypeF(), "ForcePoint", (long) QTextStream::NumberFlag::ForcePoint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX],
        Sbk_QTextStream_TypeF(), "ForceSign", (long) QTextStream::NumberFlag::ForceSign))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX],
        Sbk_QTextStream_TypeF(), "UppercaseBase", (long) QTextStream::NumberFlag::UppercaseBase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX],
        Sbk_QTextStream_TypeF(), "UppercaseDigits", (long) QTextStream::NumberFlag::UppercaseDigits))
        return;
    // Register converter for enum 'QTextStream::NumberFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX],
            QTextStream_NumberFlag_CppToPython_QTextStream_NumberFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextStream_NumberFlag_PythonToCpp_QTextStream_NumberFlag,
            is_QTextStream_NumberFlag_PythonToCpp_QTextStream_NumberFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextStream::NumberFlag");
        Shiboken::Conversions::registerConverterName(converter, "NumberFlag");
    }
    // Register converter for flag 'QFlags<QTextStream::NumberFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX],
            QFlags_QTextStream_NumberFlag__CppToPython_QFlags_QTextStream_NumberFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextStream_NumberFlag_PythonToCpp_QFlags_QTextStream_NumberFlag_,
            is_QTextStream_NumberFlag_PythonToCpp_QFlags_QTextStream_NumberFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QTextStream_NumberFlag__PythonToCpp_QFlags_QTextStream_NumberFlag_,
            is_QFlags_QTextStream_NumberFlag__PythonToCpp_QFlags_QTextStream_NumberFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QTextStream_NumberFlag_,
            is_number_PythonToCpp_QFlags_QTextStream_NumberFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextStream::NumberFlags");
        Shiboken::Conversions::registerConverterName(converter, "NumberFlags");
    }
    // End of 'NumberFlag' enum/flags.

    qRegisterMetaType< ::QTextStream::RealNumberNotation >("QTextStream::RealNumberNotation");
    qRegisterMetaType< ::QTextStream::FieldAlignment >("QTextStream::FieldAlignment");
    qRegisterMetaType< ::QTextStream::Status >("QTextStream::Status");
    qRegisterMetaType< ::QTextStream::NumberFlag >("QTextStream::NumberFlag");
    qRegisterMetaType< ::QTextStream::NumberFlags >("QTextStream::NumberFlags");
}
