/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qtimeline_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QTimeLineWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QTimeLineWrapper::QTimeLineWrapper(int duration, ::QObject * parent) : QTimeLine(duration, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QTimeLineWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QTimeLineWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QTimeLineWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QTimeLineWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QTimeLineWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTimeLine.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QTimeLineWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTimeLine.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QTimeLineWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QTimeLine::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QTimeLine::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

qreal QTimeLineWrapper::valueForTime(int msec) const
{
    if (m_PyMethodCache[8])
        return this->::QTimeLine::valueForTime(msec);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "valueForTime";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QTimeLine::valueForTime(msec);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msec
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTimeLine.valueForTime", "qreal", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qreal cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QTimeLineWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QTimeLine::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QTimeLineWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QTimeLine::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QTimeLineWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QTimeLineWrapper *>(this));
        return QTimeLine::qt_metacast(_clname);
}

QTimeLineWrapper::~QTimeLineWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTimeLine_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTimeLine >()))
        return -1;

    ::QTimeLineWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QTimeLine", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QTimeLine::QTimeLine(int,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QTimeLine(int,QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QTimeLine(int,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QTimeLine(int,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLine_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_duration = Shiboken::String::createStaticString("duration");
            if (PyDict_Contains(kwds, key_duration)) {
                value = PyDict_GetItem(kwds, key_duration);
                if (value && pyArgs[0]) {
                    errInfo = key_duration;
                    Py_INCREF(errInfo);
                    goto Sbk_QTimeLine_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QTimeLine_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_duration);
            }
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QTimeLine_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                        goto Sbk_QTimeLine_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        int cppArg0 = 1000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QTimeLine(int,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QTimeLineWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QTimeLineWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTimeLine >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTimeLine_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QTimeLine_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QTimeLine_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTimeLineFunc_currentFrame(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.currentFrame";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentFrame()const
            int cppResult = const_cast<const ::QTimeLine *>(cppSelf)->currentFrame();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeLineFunc_currentTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.currentTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentTime()const
            int cppResult = const_cast<const ::QTimeLine *>(cppSelf)->currentTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeLineFunc_currentValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.currentValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentValue()const
            qreal cppResult = const_cast<const ::QTimeLine *>(cppSelf)->currentValue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeLineFunc_curveShape(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.curveShape";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // curveShape()const
            QTimeLine::CurveShape cppResult = const_cast<const ::QTimeLine *>(cppSelf)->curveShape();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeLineFunc_direction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.direction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // direction()const
            QTimeLine::Direction cppResult = const_cast<const ::QTimeLine *>(cppSelf)->direction();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeLineFunc_duration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.duration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // duration()const
            int cppResult = const_cast<const ::QTimeLine *>(cppSelf)->duration();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeLineFunc_easingCurve(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.easingCurve";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // easingCurve()const
            QEasingCurve cppResult = const_cast<const ::QTimeLine *>(cppSelf)->easingCurve();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeLineFunc_endFrame(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.endFrame";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // endFrame()const
            int cppResult = const_cast<const ::QTimeLine *>(cppSelf)->endFrame();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeLineFunc_frameForTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.frameForTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeLine::frameForTime(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // frameForTime(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_frameForTime_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // frameForTime(int)const
            int cppResult = const_cast<const ::QTimeLine *>(cppSelf)->frameForTime(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeLineFunc_frameForTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_loopCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.loopCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loopCount()const
            int cppResult = const_cast<const ::QTimeLine *>(cppSelf)->loopCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeLineFunc_resume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.resume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resume()
            cppSelf->resume();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTimeLineFunc_setCurrentTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.setCurrentTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeLine::setCurrentTime(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentTime(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_setCurrentTime_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurrentTime(int)
            cppSelf->setCurrentTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeLineFunc_setCurrentTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_setCurveShape(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.setCurveShape";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeLine::setCurveShape(QTimeLine::CurveShape)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCurveShape(QTimeLine::CurveShape)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_setCurveShape_TypeError;

    // Call function/method
    {
        ::QTimeLine::CurveShape cppArg0{QTimeLine::EaseInCurve};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurveShape(QTimeLine::CurveShape)
            cppSelf->setCurveShape(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeLineFunc_setCurveShape_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_setDirection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.setDirection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeLine::setDirection(QTimeLine::Direction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDirection(QTimeLine::Direction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_setDirection_TypeError;

    // Call function/method
    {
        ::QTimeLine::Direction cppArg0{QTimeLine::Forward};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDirection(QTimeLine::Direction)
            cppSelf->setDirection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeLineFunc_setDirection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_setDuration(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.setDuration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeLine::setDuration(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDuration(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_setDuration_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDuration(int)
            cppSelf->setDuration(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeLineFunc_setDuration_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_setEasingCurve(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.setEasingCurve";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeLine::setEasingCurve(QEasingCurve)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), (pyArg)))) {
        overloadId = 0; // setEasingCurve(QEasingCurve)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_setEasingCurve_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEasingCurve cppArg0_local;
        ::QEasingCurve *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setEasingCurve(QEasingCurve)
            cppSelf->setEasingCurve(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeLineFunc_setEasingCurve_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_setEndFrame(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.setEndFrame";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeLine::setEndFrame(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setEndFrame(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_setEndFrame_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEndFrame(int)
            cppSelf->setEndFrame(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeLineFunc_setEndFrame_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_setFrameRange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.setFrameRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFrameRange", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTimeLine::setFrameRange(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setFrameRange(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_setFrameRange_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFrameRange(int,int)
            cppSelf->setFrameRange(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeLineFunc_setFrameRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_setLoopCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.setLoopCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeLine::setLoopCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLoopCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_setLoopCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLoopCount(int)
            cppSelf->setLoopCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeLineFunc_setLoopCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_setPaused(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.setPaused";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeLine::setPaused(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPaused(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_setPaused_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPaused(bool)
            cppSelf->setPaused(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeLineFunc_setPaused_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_setStartFrame(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.setStartFrame";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeLine::setStartFrame(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setStartFrame(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_setStartFrame_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStartFrame(int)
            cppSelf->setStartFrame(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeLineFunc_setStartFrame_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_setUpdateInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.setUpdateInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeLine::setUpdateInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setUpdateInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_setUpdateInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUpdateInterval(int)
            cppSelf->setUpdateInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeLineFunc_setUpdateInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.start";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // start()
            cppSelf->start();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTimeLineFunc_startFrame(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.startFrame";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startFrame()const
            int cppResult = const_cast<const ::QTimeLine *>(cppSelf)->startFrame();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeLineFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QTimeLine::State cppResult = const_cast<const ::QTimeLine *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_STATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeLineFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTimeLineFunc_timerEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.timerEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::timerEvent(QTimerEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), (pyArg)))) {
        overloadId = 0; // timerEvent(QTimerEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_timerEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTimerEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // timerEvent(QTimerEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QTimeLine::timerEvent(cppArg0)
                : cppSelf->timerEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeLineFunc_timerEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeLineFunc_toggleDirection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.toggleDirection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toggleDirection()
            cppSelf->toggleDirection();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTimeLineFunc_updateInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.updateInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // updateInterval()const
            int cppResult = const_cast<const ::QTimeLine *>(cppSelf)->updateInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeLineFunc_valueForTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeLine.valueForTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeLine::valueForTime(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // valueForTime(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeLineFunc_valueForTime_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // valueForTime(int)const
            qreal cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QTimeLine *>(cppSelf)->::QTimeLine::valueForTime(cppArg0)
                : const_cast<const ::QTimeLine *>(cppSelf)->valueForTime(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeLineFunc_valueForTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QTimeLine_PropertyStrings[] = {
    "currentTime::",
    "curveShape::",
    "direction::",
    "duration::",
    "easingCurve::",
    "loopCount::",
    "updateInterval::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTimeLine_methods[] = {
    {"currentFrame", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_currentFrame), METH_NOARGS},
    {"currentTime", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_currentTime), METH_NOARGS},
    {"currentValue", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_currentValue), METH_NOARGS},
    {"curveShape", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_curveShape), METH_NOARGS},
    {"direction", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_direction), METH_NOARGS},
    {"duration", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_duration), METH_NOARGS},
    {"easingCurve", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_easingCurve), METH_NOARGS},
    {"endFrame", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_endFrame), METH_NOARGS},
    {"frameForTime", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_frameForTime), METH_O},
    {"loopCount", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_loopCount), METH_NOARGS},
    {"resume", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_resume), METH_NOARGS},
    {"setCurrentTime", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_setCurrentTime), METH_O},
    {"setCurveShape", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_setCurveShape), METH_O},
    {"setDirection", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_setDirection), METH_O},
    {"setDuration", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_setDuration), METH_O},
    {"setEasingCurve", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_setEasingCurve), METH_O},
    {"setEndFrame", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_setEndFrame), METH_O},
    {"setFrameRange", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_setFrameRange), METH_VARARGS},
    {"setLoopCount", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_setLoopCount), METH_O},
    {"setPaused", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_setPaused), METH_O},
    {"setStartFrame", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_setStartFrame), METH_O},
    {"setUpdateInterval", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_setUpdateInterval), METH_O},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_start), METH_NOARGS},
    {"startFrame", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_startFrame), METH_NOARGS},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_state), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_stop), METH_NOARGS},
    {"timerEvent", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_timerEvent), METH_O},
    {"toggleDirection", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_toggleDirection), METH_NOARGS},
    {"updateInterval", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_updateInterval), METH_NOARGS},
    {"valueForTime", reinterpret_cast<PyCFunction>(Sbk_QTimeLineFunc_valueForTime), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QTimeLine_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QTimeLine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QTimeLineWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QTimeLine_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTimeLine_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTimeLine_Type = nullptr;
static SbkObjectType *Sbk_QTimeLine_TypeF(void)
{
    return _Sbk_QTimeLine_Type;
}

static PyType_Slot Sbk_QTimeLine_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QTimeLine_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTimeLine_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTimeLine_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTimeLine_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTimeLine_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTimeLine_spec = {
    "2:PySide2.QtCore.QTimeLine",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTimeLine_slots
};

} //extern "C"

static void *Sbk_QTimeLine_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QTimeLine *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QTimeLine_State_PythonToCpp_QTimeLine_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTimeLine::State *>(cppOut) =
        static_cast<::QTimeLine::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTimeLine_State_PythonToCpp_QTimeLine_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTIMELINE_STATE_IDX]))
        return QTimeLine_State_PythonToCpp_QTimeLine_State;
    return {};
}
static PyObject *QTimeLine_State_CppToPython_QTimeLine_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTimeLine::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_STATE_IDX], castCppIn);

}

static void QTimeLine_Direction_PythonToCpp_QTimeLine_Direction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTimeLine::Direction *>(cppOut) =
        static_cast<::QTimeLine::Direction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTimeLine_Direction_PythonToCpp_QTimeLine_Direction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX]))
        return QTimeLine_Direction_PythonToCpp_QTimeLine_Direction;
    return {};
}
static PyObject *QTimeLine_Direction_CppToPython_QTimeLine_Direction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTimeLine::Direction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX], castCppIn);

}

static void QTimeLine_CurveShape_PythonToCpp_QTimeLine_CurveShape(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTimeLine::CurveShape *>(cppOut) =
        static_cast<::QTimeLine::CurveShape>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTimeLine_CurveShape_PythonToCpp_QTimeLine_CurveShape_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX]))
        return QTimeLine_CurveShape_PythonToCpp_QTimeLine_CurveShape;
    return {};
}
static PyObject *QTimeLine_CurveShape_CppToPython_QTimeLine_CurveShape(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTimeLine::CurveShape *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTimeLine_PythonToCpp_QTimeLine_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTimeLine_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTimeLine_PythonToCpp_QTimeLine_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTimeLine_TypeF())))
        return QTimeLine_PythonToCpp_QTimeLine_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTimeLine_PTR_CppToPython_QTimeLine(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QTimeLine *>(const_cast<void *>(cppIn)), Sbk_QTimeLine_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTimeLine_SignatureStrings[] = {
    "PySide2.QtCore.QTimeLine(self,duration:int=1000,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtCore.QTimeLine.currentFrame(self)->int",
    "PySide2.QtCore.QTimeLine.currentTime(self)->int",
    "PySide2.QtCore.QTimeLine.currentValue(self)->qreal",
    "PySide2.QtCore.QTimeLine.curveShape(self)->PySide2.QtCore.QTimeLine.CurveShape",
    "PySide2.QtCore.QTimeLine.direction(self)->PySide2.QtCore.QTimeLine.Direction",
    "PySide2.QtCore.QTimeLine.duration(self)->int",
    "PySide2.QtCore.QTimeLine.easingCurve(self)->PySide2.QtCore.QEasingCurve",
    "PySide2.QtCore.QTimeLine.endFrame(self)->int",
    "PySide2.QtCore.QTimeLine.frameForTime(self,msec:int)->int",
    "PySide2.QtCore.QTimeLine.loopCount(self)->int",
    "PySide2.QtCore.QTimeLine.resume(self)",
    "PySide2.QtCore.QTimeLine.setCurrentTime(self,msec:int)",
    "PySide2.QtCore.QTimeLine.setCurveShape(self,shape:PySide2.QtCore.QTimeLine.CurveShape)",
    "PySide2.QtCore.QTimeLine.setDirection(self,direction:PySide2.QtCore.QTimeLine.Direction)",
    "PySide2.QtCore.QTimeLine.setDuration(self,duration:int)",
    "PySide2.QtCore.QTimeLine.setEasingCurve(self,curve:PySide2.QtCore.QEasingCurve)",
    "PySide2.QtCore.QTimeLine.setEndFrame(self,frame:int)",
    "PySide2.QtCore.QTimeLine.setFrameRange(self,startFrame:int,endFrame:int)",
    "PySide2.QtCore.QTimeLine.setLoopCount(self,count:int)",
    "PySide2.QtCore.QTimeLine.setPaused(self,paused:bool)",
    "PySide2.QtCore.QTimeLine.setStartFrame(self,frame:int)",
    "PySide2.QtCore.QTimeLine.setUpdateInterval(self,interval:int)",
    "PySide2.QtCore.QTimeLine.start(self)",
    "PySide2.QtCore.QTimeLine.startFrame(self)->int",
    "PySide2.QtCore.QTimeLine.state(self)->PySide2.QtCore.QTimeLine.State",
    "PySide2.QtCore.QTimeLine.stop(self)",
    "PySide2.QtCore.QTimeLine.timerEvent(self,event:PySide2.QtCore.QTimerEvent)",
    "PySide2.QtCore.QTimeLine.toggleDirection(self)",
    "PySide2.QtCore.QTimeLine.updateInterval(self)->int",
    "PySide2.QtCore.QTimeLine.valueForTime(self,msec:int)->qreal",
    nullptr}; // Sentinel

void init_QTimeLine(PyObject *module)
{
    _Sbk_QTimeLine_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTimeLine",
        "QTimeLine*",
        &Sbk_QTimeLine_spec,
        &Shiboken::callCppDestructor< ::QTimeLine >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTimeLine_Type);
    InitSignatureStrings(pyType, QTimeLine_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTimeLine_Type), Sbk_QTimeLine_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTimeLine_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTimeLine_TypeF(),
        QTimeLine_PythonToCpp_QTimeLine_PTR,
        is_QTimeLine_PythonToCpp_QTimeLine_PTR_Convertible,
        QTimeLine_PTR_CppToPython_QTimeLine);

    Shiboken::Conversions::registerConverterName(converter, "QTimeLine");
    Shiboken::Conversions::registerConverterName(converter, "QTimeLine*");
    Shiboken::Conversions::registerConverterName(converter, "QTimeLine&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTimeLine).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTimeLineWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QTimeLine_TypeF(), &Sbk_QTimeLine_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'State'.
    SbkPySide2_QtCoreTypes[SBK_QTIMELINE_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTimeLine_TypeF(),
        "State",
        "2:PySide2.QtCore.QTimeLine.State",
        "QTimeLine::State");
    if (!SbkPySide2_QtCoreTypes[SBK_QTIMELINE_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_STATE_IDX],
        Sbk_QTimeLine_TypeF(), "NotRunning", (long) QTimeLine::State::NotRunning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_STATE_IDX],
        Sbk_QTimeLine_TypeF(), "Paused", (long) QTimeLine::State::Paused))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_STATE_IDX],
        Sbk_QTimeLine_TypeF(), "Running", (long) QTimeLine::State::Running))
        return;
    // Register converter for enum 'QTimeLine::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_STATE_IDX],
            QTimeLine_State_CppToPython_QTimeLine_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTimeLine_State_PythonToCpp_QTimeLine_State,
            is_QTimeLine_State_PythonToCpp_QTimeLine_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTimeLine::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    // Initialization of enum 'Direction'.
    SbkPySide2_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTimeLine_TypeF(),
        "Direction",
        "2:PySide2.QtCore.QTimeLine.Direction",
        "QTimeLine::Direction");
    if (!SbkPySide2_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX],
        Sbk_QTimeLine_TypeF(), "Forward", (long) QTimeLine::Direction::Forward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX],
        Sbk_QTimeLine_TypeF(), "Backward", (long) QTimeLine::Direction::Backward))
        return;
    // Register converter for enum 'QTimeLine::Direction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX],
            QTimeLine_Direction_CppToPython_QTimeLine_Direction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTimeLine_Direction_PythonToCpp_QTimeLine_Direction,
            is_QTimeLine_Direction_PythonToCpp_QTimeLine_Direction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTimeLine::Direction");
        Shiboken::Conversions::registerConverterName(converter, "Direction");
    }
    // End of 'Direction' enum.

    // Initialization of enum 'CurveShape'.
    SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTimeLine_TypeF(),
        "CurveShape",
        "2:PySide2.QtCore.QTimeLine.CurveShape",
        "QTimeLine::CurveShape");
    if (!SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX],
        Sbk_QTimeLine_TypeF(), "EaseInCurve", (long) QTimeLine::CurveShape::EaseInCurve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX],
        Sbk_QTimeLine_TypeF(), "EaseOutCurve", (long) QTimeLine::CurveShape::EaseOutCurve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX],
        Sbk_QTimeLine_TypeF(), "EaseInOutCurve", (long) QTimeLine::CurveShape::EaseInOutCurve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX],
        Sbk_QTimeLine_TypeF(), "LinearCurve", (long) QTimeLine::CurveShape::LinearCurve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX],
        Sbk_QTimeLine_TypeF(), "SineCurve", (long) QTimeLine::CurveShape::SineCurve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX],
        Sbk_QTimeLine_TypeF(), "CosineCurve", (long) QTimeLine::CurveShape::CosineCurve))
        return;
    // Register converter for enum 'QTimeLine::CurveShape'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX],
            QTimeLine_CurveShape_CppToPython_QTimeLine_CurveShape);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTimeLine_CurveShape_PythonToCpp_QTimeLine_CurveShape,
            is_QTimeLine_CurveShape_PythonToCpp_QTimeLine_CurveShape_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTimeLine::CurveShape");
        Shiboken::Conversions::registerConverterName(converter, "CurveShape");
    }
    // End of 'CurveShape' enum.

    PySide::Signal::registerSignals(Sbk_QTimeLine_TypeF(), &::QTimeLine::staticMetaObject);
    qRegisterMetaType< ::QTimeLine::State >("QTimeLine::State");
    qRegisterMetaType< ::QTimeLine::Direction >("QTimeLine::Direction");
    qRegisterMetaType< ::QTimeLine::CurveShape >("QTimeLine::CurveShape");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QTimeLine_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QTimeLine_TypeF(), &::QTimeLine::staticMetaObject, sizeof(QTimeLineWrapper));
}
