/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qtimer_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QTimerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QTimerWrapper::QTimerWrapper(::QObject * parent) : QTimer(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QTimerWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QTimerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QTimerWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QTimerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QTimerWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTimer.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QTimerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTimer.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QTimerWrapper::timerEvent(::QTimerEvent * arg__1)
{
    if (m_PyMethodCache[7]) {
        return this->::QTimer::timerEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QTimer::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QTimerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QTimer::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QTimerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QTimer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QTimerWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QTimerWrapper *>(this));
        return QTimer::qt_metacast(_clname);
}

QTimerWrapper::~QTimerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTimer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTimer >()))
        return -1;

    ::QTimerWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QTimer", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTimer::QTimer(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QTimer(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QTimer(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimer_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QTimer_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QTimer_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QTimer(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QTimerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QTimerWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTimer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTimer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QTimer_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QTimer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTimerFunc_interval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.interval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // interval()const
            int cppResult = const_cast<const ::QTimer *>(cppSelf)->interval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimerFunc_isActive(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.isActive";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isActive()const
            bool cppResult = const_cast<const ::QTimer *>(cppSelf)->isActive();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimerFunc_isSingleShot(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.isSingleShot";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSingleShot()const
            bool cppResult = const_cast<const ::QTimer *>(cppSelf)->isSingleShot();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimerFunc_killTimer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.killTimer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::killTimer(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // killTimer(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimerFunc_killTimer_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "killTimer(int arg__1)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimerFunc_killTimer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimerFunc_remainingTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.remainingTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // remainingTime()const
            int cppResult = const_cast<const ::QTimer *>(cppSelf)->remainingTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimerFunc_setInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.setInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimer::setInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimerFunc_setInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInterval(int)
            cppSelf->setInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimerFunc_setInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimerFunc_setSingleShot(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.setSingleShot";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimer::setSingleShot(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSingleShot(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimerFunc_setSingleShot_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSingleShot(bool)
            cppSelf->setSingleShot(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimerFunc_setSingleShot_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimerFunc_setTimerType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.setTimerType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimer::setTimerType(Qt::TimerType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTimerType(Qt::TimerType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimerFunc_setTimerType_TypeError;

    // Call function/method
    {
        ::Qt::TimerType cppArg0{Qt::PreciseTimer};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTimerType(Qt::TimerType)
            cppSelf->setTimerType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimerFunc_setTimerType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimerFunc_singleShot(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.singleShot";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "singleShot", 2, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QTimer::singleShot(int,PyCallable*)
    // 1: static QTimer::singleShot(int,Qt::TimerType,const QObject*,const char*)
    // 2: static QTimer::singleShot(int,const QObject*,const char*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))
            && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
            overloadId = 2; // singleShot(int,const QObject*,const char*)
        } else if (numArgs == 4
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))
            && Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3])))) {
            overloadId = 1; // singleShot(int,Qt::TimerType,const QObject*,const char*)
        } else if (numArgs == 2
            && PyCallable_Check(pyArgs[1])) {
            overloadId = 0; // singleShot(int,PyCallable*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimerFunc_singleShot_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // singleShot(int arg__1, PyCallable * arg__2)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // singleShot(int,PyCallable*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qtimer-singleshot-2)]
                // singleShot() - disable generation of c++ function call
                Shiboken::AutoDecRef emptyTuple(PyTuple_New(0));
                PyObject *pyTimer = reinterpret_cast<PyTypeObject *>(Shiboken::SbkType<QTimer>())->tp_new(Shiboken::SbkType<QTimer>(), emptyTuple, 0);
                reinterpret_cast<PyTypeObject *>(Shiboken::SbkType<QTimer>())->tp_init(pyTimer, emptyTuple, 0);
                ::QTimer* timer{nullptr};
                    Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX]), pyTimer, &(timer));
                timer->setSingleShot(true);

                if (PyObject_TypeCheck(pyArgs[1], PySideSignalInstanceTypeF())) {
                    PySideSignalInstance *signalInstance = reinterpret_cast<PySideSignalInstance *>(pyArgs[1]);
                    Shiboken::AutoDecRef signalSignature(Shiboken::String::fromFormat("2%s", PySide::Signal::getSignature(signalInstance)));
                    Shiboken::AutoDecRef result(
                        PyObject_CallMethod(pyTimer,
                                            const_cast<char *>("connect"),
                                            const_cast<char *>("OsOO"),
                                            pyTimer,
                                            SIGNAL(timeout()),
                                            PySide::Signal::getObject(signalInstance),
                                            signalSignature.object())
                    );
                } else {
                    Shiboken::AutoDecRef result(
                        PyObject_CallMethod(pyTimer,
                                            const_cast<char *>("connect"),
                                            const_cast<char *>("OsO"),
                                            pyTimer,
                                            SIGNAL(timeout()),
                                            pyArgs[2-1])
                    );
                }

                timer->connect(timer, SIGNAL(timeout()), timer, SLOT(deleteLater()), Qt::DirectConnection);
                Shiboken::Object::releaseOwnership(reinterpret_cast<SbkObject *>(pyTimer));
                Py_XDECREF(pyTimer);
                timer->start(cppArg0);
                // END of custom code block [file: ../glue/qtcore.cpp (qtimer-singleshot-2)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // singleShot(int msec, Qt::TimerType timerType, const QObject * receiver, const char * member)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::TimerType cppArg1{Qt::PreciseTimer};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            const char* cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // singleShot(int,Qt::TimerType,const QObject*,const char*)
                ::QTimer::singleShot(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 2: // singleShot(int msec, const QObject * receiver, const char * member)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            const char* cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // singleShot(int,const QObject*,const char*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qtimer-singleshot-1)]
                // singleShot() - disable generation of c++ function call
                (void) cppArg1; // remove warning about unused variable
                Shiboken::AutoDecRef emptyTuple(PyTuple_New(0));
                PyObject *pyTimer = reinterpret_cast<PyTypeObject *>(Shiboken::SbkType<QTimer>())->tp_new(Shiboken::SbkType<QTimer>(), emptyTuple, 0);
                reinterpret_cast<PyTypeObject *>(Shiboken::SbkType<QTimer>())->tp_init(pyTimer, emptyTuple, 0);

                ::QTimer* timer{nullptr};
                    Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX]), pyTimer, &(timer));
                //XXX  /|\ omitting this space crashes shiboken!
                Shiboken::AutoDecRef result(
                    PyObject_CallMethod(pyTimer,
                                        const_cast<char *>("connect"),
                                        const_cast<char *>("OsOs"),
                                        pyTimer,
                                        SIGNAL(timeout()),
                                        pyArgs[2-1],
                                        cppArg2)
                );
                Shiboken::Object::releaseOwnership((SbkObject *)pyTimer);
                Py_XDECREF(pyTimer);
                timer->setSingleShot(true);
                timer->connect(timer, SIGNAL(timeout()), timer, SLOT(deleteLater()));
                timer->start(cppArg0);
                // END of custom code block [file: ../glue/qtcore.cpp (qtimer-singleshot-1)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimerFunc_singleShot_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimerFunc_start(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.start";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "start", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTimer::start()
    // 1: QTimer::start(int)
    if (numArgs == 0) {
        overloadId = 0; // start()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // start(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimerFunc_start_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // start()
        {

            if (!PyErr_Occurred()) {
                // start()
                cppSelf->start();
            }
            break;
        }
        case 1: // start(int msec)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // start(int)
                cppSelf->start(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimerFunc_start_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimerFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTimerFunc_timerEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.timerEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::timerEvent(QTimerEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), (pyArg)))) {
        overloadId = 0; // timerEvent(QTimerEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimerFunc_timerEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTimerEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // timerEvent(QTimerEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QTimer::timerEvent(cppArg0)
                : cppSelf->timerEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimerFunc_timerEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimerFunc_timerId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.timerId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // timerId()const
            int cppResult = const_cast<const ::QTimer *>(cppSelf)->timerId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimerFunc_timerType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimer.timerType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // timerType()const
            Qt::TimerType cppResult = const_cast<const ::QTimer *>(cppSelf)->timerType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTimer_PropertyStrings[] = {
    "active:isActive",
    "interval::",
    "remainingTime:",
    "singleShot:isSingleShot:",
    "timerType::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTimer_methods[] = {
    {"interval", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_interval), METH_NOARGS},
    {"isActive", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_isActive), METH_NOARGS},
    {"isSingleShot", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_isSingleShot), METH_NOARGS},
    {"killTimer", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_killTimer), METH_O},
    {"remainingTime", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_remainingTime), METH_NOARGS},
    {"setInterval", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_setInterval), METH_O},
    {"setSingleShot", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_setSingleShot), METH_O},
    {"setTimerType", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_setTimerType), METH_O},
    {"singleShot", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_singleShot), METH_VARARGS|METH_STATIC},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_start), METH_VARARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_stop), METH_NOARGS},
    {"timerEvent", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_timerEvent), METH_O},
    {"timerId", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_timerId), METH_NOARGS},
    {"timerType", reinterpret_cast<PyCFunction>(Sbk_QTimerFunc_timerType), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QTimer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QTimerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QTimer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTimer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTimer_Type = nullptr;
static SbkObjectType *Sbk_QTimer_TypeF(void)
{
    return _Sbk_QTimer_Type;
}

static PyType_Slot Sbk_QTimer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QTimer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTimer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTimer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTimer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTimer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTimer_spec = {
    "2:PySide2.QtCore.QTimer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTimer_slots
};

} //extern "C"

static void *Sbk_QTimer_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QTimer *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTimer_PythonToCpp_QTimer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTimer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTimer_PythonToCpp_QTimer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTimer_TypeF())))
        return QTimer_PythonToCpp_QTimer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTimer_PTR_CppToPython_QTimer(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QTimer *>(const_cast<void *>(cppIn)), Sbk_QTimer_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTimer_SignatureStrings[] = {
    "PySide2.QtCore.QTimer(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtCore.QTimer.interval(self)->int",
    "PySide2.QtCore.QTimer.isActive(self)->bool",
    "PySide2.QtCore.QTimer.isSingleShot(self)->bool",
    "PySide2.QtCore.QTimer.killTimer(self,arg__1:int)",
    "PySide2.QtCore.QTimer.remainingTime(self)->int",
    "PySide2.QtCore.QTimer.setInterval(self,msec:int)",
    "PySide2.QtCore.QTimer.setSingleShot(self,singleShot:bool)",
    "PySide2.QtCore.QTimer.setTimerType(self,atype:PySide2.QtCore.Qt.TimerType)",
    "2:PySide2.QtCore.QTimer.singleShot(arg__1:int,arg__2:PyCallable)",
    "1:PySide2.QtCore.QTimer.singleShot(msec:int,timerType:PySide2.QtCore.Qt.TimerType,receiver:PySide2.QtCore.QObject,member:char*)",
    "0:PySide2.QtCore.QTimer.singleShot(msec:int,receiver:PySide2.QtCore.QObject,member:char*)",
    "1:PySide2.QtCore.QTimer.start(self)",
    "0:PySide2.QtCore.QTimer.start(self,msec:int)",
    "PySide2.QtCore.QTimer.stop(self)",
    "PySide2.QtCore.QTimer.timerEvent(self,arg__1:PySide2.QtCore.QTimerEvent)",
    "PySide2.QtCore.QTimer.timerId(self)->int",
    "PySide2.QtCore.QTimer.timerType(self)->PySide2.QtCore.Qt.TimerType",
    nullptr}; // Sentinel

void init_QTimer(PyObject *module)
{
    _Sbk_QTimer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTimer",
        "QTimer*",
        &Sbk_QTimer_spec,
        &Shiboken::callCppDestructor< ::QTimer >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTimer_Type);
    InitSignatureStrings(pyType, QTimer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTimer_Type), Sbk_QTimer_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QTIMER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTimer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTimer_TypeF(),
        QTimer_PythonToCpp_QTimer_PTR,
        is_QTimer_PythonToCpp_QTimer_PTR_Convertible,
        QTimer_PTR_CppToPython_QTimer);

    Shiboken::Conversions::registerConverterName(converter, "QTimer");
    Shiboken::Conversions::registerConverterName(converter, "QTimer*");
    Shiboken::Conversions::registerConverterName(converter, "QTimer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTimer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTimerWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QTimer_TypeF(), &Sbk_QTimer_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QTimer_TypeF(), &::QTimer::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QTimer_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QTimer_TypeF(), &::QTimer::staticMetaObject, sizeof(QTimerWrapper));
}
