/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qurlquery_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QPair>
#include <qurl.h>
#include <qurlquery.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QUrlQuery_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QUrlQuery >()))
        return -1;

    ::QUrlQuery *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QUrlQuery", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QUrlQuery::QUrlQuery()
    // 1: QUrlQuery::QUrlQuery(QString)
    // 2: QUrlQuery::QUrlQuery(QUrl)
    // 3: QUrlQuery::QUrlQuery(QUrlQuery)
    if (numArgs == 0) {
        overloadId = 0; // QUrlQuery()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QUrlQuery(QUrlQuery)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // QUrlQuery(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QUrlQuery(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQuery_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QUrlQuery()
        {

            if (!PyErr_Occurred()) {
                // QUrlQuery()
                cptr = new ::QUrlQuery();
            }
            break;
        }
        case 1: // QUrlQuery(const QString & queryString)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QUrlQuery(QString)
                cptr = new ::QUrlQuery(cppArg0);
            }
            break;
        }
        case 2: // QUrlQuery(const QUrl & url)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QUrlQuery(QUrl)
                cptr = new ::QUrlQuery(*cppArg0);
            }
            break;
        }
        case 3: // QUrlQuery(const QUrlQuery & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrlQuery cppArg0_local;
            ::QUrlQuery *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QUrlQuery(QUrlQuery)
                cptr = new ::QUrlQuery(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QUrlQuery >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QUrlQuery_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QUrlQuery_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QUrlQueryFunc_addQueryItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.addQueryItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addQueryItem", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrlQuery::addQueryItem(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // addQueryItem(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_addQueryItem_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addQueryItem(QString,QString)
            cppSelf->addQueryItem(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlQueryFunc_addQueryItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQueryFunc_allQueryItemValues(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.allQueryItemValues";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlQueryFunc_allQueryItemValues_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlQueryFunc_allQueryItemValues_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:allQueryItemValues", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrlQuery::allQueryItemValues(QString,QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // allQueryItemValues(QString,QFlags<QUrl::ComponentFormattingOption>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // allQueryItemValues(QString,QFlags<QUrl::ComponentFormattingOption>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_allQueryItemValues_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_encoding = Shiboken::String::createStaticString("encoding");
            if (PyDict_Contains(kwds, key_encoding)) {
                value = PyDict_GetItem(kwds, key_encoding);
                if (value && pyArgs[1]) {
                    errInfo = key_encoding;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlQueryFunc_allQueryItemValues_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlQueryFunc_allQueryItemValues_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_encoding);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlQueryFunc_allQueryItemValues_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<QUrl::ComponentFormattingOption> cppArg1 = QUrl::PrettyDecoded;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // allQueryItemValues(QString,QFlags<QUrl::ComponentFormattingOption>)const
            QStringList cppResult = const_cast<const ::QUrlQuery *>(cppSelf)->allQueryItemValues(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlQueryFunc_allQueryItemValues_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQueryFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QUrlQueryFunc_defaultQueryPairDelimiter(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.defaultQueryPairDelimiter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultQueryPairDelimiter()
            QChar cppResult = ::QUrlQuery::defaultQueryPairDelimiter();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlQueryFunc_defaultQueryValueDelimiter(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.defaultQueryValueDelimiter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultQueryValueDelimiter()
            QChar cppResult = ::QUrlQuery::defaultQueryValueDelimiter();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlQueryFunc_hasQueryItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.hasQueryItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QUrlQuery::hasQueryItem(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // hasQueryItem(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_hasQueryItem_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasQueryItem(QString)const
            bool cppResult = const_cast<const ::QUrlQuery *>(cppSelf)->hasQueryItem(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlQueryFunc_hasQueryItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQueryFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QUrlQuery *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlQueryFunc_query(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.query";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlQueryFunc_query_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:query", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrlQuery::query(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // query(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // query(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_query_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_encoding = Shiboken::String::createStaticString("encoding");
            if (PyDict_Contains(kwds, key_encoding)) {
                value = PyDict_GetItem(kwds, key_encoding);
                if (value && pyArgs[0]) {
                    errInfo = key_encoding;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlQueryFunc_query_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlQueryFunc_query_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_encoding);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlQueryFunc_query_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::PrettyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // query(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrlQuery *>(cppSelf)->query(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlQueryFunc_query_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQueryFunc_queryItemValue(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.queryItemValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlQueryFunc_queryItemValue_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QUrlQueryFunc_queryItemValue_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:queryItemValue", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrlQuery::queryItemValue(QString,QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // queryItemValue(QString,QFlags<QUrl::ComponentFormattingOption>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // queryItemValue(QString,QFlags<QUrl::ComponentFormattingOption>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_queryItemValue_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_encoding = Shiboken::String::createStaticString("encoding");
            if (PyDict_Contains(kwds, key_encoding)) {
                value = PyDict_GetItem(kwds, key_encoding);
                if (value && pyArgs[1]) {
                    errInfo = key_encoding;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlQueryFunc_queryItemValue_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QUrlQueryFunc_queryItemValue_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_encoding);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlQueryFunc_queryItemValue_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<QUrl::ComponentFormattingOption> cppArg1 = QUrl::PrettyDecoded;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // queryItemValue(QString,QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrlQuery *>(cppSelf)->queryItemValue(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlQueryFunc_queryItemValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQueryFunc_queryItems(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.queryItems";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlQueryFunc_queryItems_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:queryItems", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrlQuery::queryItems(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // queryItems(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // queryItems(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_queryItems_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_encoding = Shiboken::String::createStaticString("encoding");
            if (PyDict_Contains(kwds, key_encoding)) {
                value = PyDict_GetItem(kwds, key_encoding);
                if (value && pyArgs[0]) {
                    errInfo = key_encoding;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlQueryFunc_queryItems_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlQueryFunc_queryItems_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_encoding);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlQueryFunc_queryItems_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::PrettyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // queryItems(QFlags<QUrl::ComponentFormattingOption>)const
            QList<QPair< QString,QString > > cppResult = const_cast<const ::QUrlQuery *>(cppSelf)->queryItems(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QPAIR_QSTRING_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlQueryFunc_queryItems_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQueryFunc_queryPairDelimiter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.queryPairDelimiter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // queryPairDelimiter()const
            QChar cppResult = const_cast<const ::QUrlQuery *>(cppSelf)->queryPairDelimiter();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlQueryFunc_queryValueDelimiter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.queryValueDelimiter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // queryValueDelimiter()const
            QChar cppResult = const_cast<const ::QUrlQuery *>(cppSelf)->queryValueDelimiter();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QUrlQueryFunc_removeAllQueryItems(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.removeAllQueryItems";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QUrlQuery::removeAllQueryItems(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // removeAllQueryItems(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_removeAllQueryItems_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeAllQueryItems(QString)
            cppSelf->removeAllQueryItems(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlQueryFunc_removeAllQueryItems_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQueryFunc_removeQueryItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.removeQueryItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QUrlQuery::removeQueryItem(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // removeQueryItem(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_removeQueryItem_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeQueryItem(QString)
            cppSelf->removeQueryItem(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlQueryFunc_removeQueryItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQueryFunc_setQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.setQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QUrlQuery::setQuery(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setQuery(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_setQuery_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setQuery(QString)
            cppSelf->setQuery(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlQueryFunc_setQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQueryFunc_setQueryDelimiters(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.setQueryDelimiters";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setQueryDelimiters", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QUrlQuery::setQueryDelimiters(QChar,QChar)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArgs[1])))) {
        overloadId = 0; // setQueryDelimiters(QChar,QChar)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_setQueryDelimiters_TypeError;

    // Call function/method
    {
        ::QChar cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QChar cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setQueryDelimiters(QChar,QChar)
            cppSelf->setQueryDelimiters(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlQueryFunc_setQueryDelimiters_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQueryFunc_setQueryItems(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.setQueryItems";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QUrlQuery::setQueryItems(QList<QPair<QString,QString> >)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QPAIR_QSTRING_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setQueryItems(QList<QPair<QString,QString> >)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_setQueryItems_TypeError;

    // Call function/method
    {
        ::QList<QPair< QString,QString > > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setQueryItems(QList<QPair<QString,QString> >)
            cppSelf->setQueryItems(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlQueryFunc_setQueryItems_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQueryFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QUrlQuery::swap(QUrlQuery&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QUrlQuery&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrlQuery cppArg0_local;
        ::QUrlQuery *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QUrlQuery&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QUrlQueryFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQueryFunc_toString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QUrlQuery.toString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QUrlQueryFunc_toString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toString", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QUrlQuery::toString(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // toString(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // toString(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QUrlQueryFunc_toString_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_encoding = Shiboken::String::createStaticString("encoding");
            if (PyDict_Contains(kwds, key_encoding)) {
                value = PyDict_GetItem(kwds, key_encoding);
                if (value && pyArgs[0]) {
                    errInfo = key_encoding;
                    Py_INCREF(errInfo);
                    goto Sbk_QUrlQueryFunc_toString_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QUrlQueryFunc_toString_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_encoding);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QUrlQueryFunc_toString_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::PrettyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toString(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QUrlQuery *>(cppSelf)->toString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QUrlQueryFunc_toString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QUrlQuery___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QUrlQuery_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QUrlQuery_methods[] = {
    {"addQueryItem", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_addQueryItem), METH_VARARGS},
    {"allQueryItemValues", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_allQueryItemValues), METH_VARARGS|METH_KEYWORDS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_clear), METH_NOARGS},
    {"defaultQueryPairDelimiter", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_defaultQueryPairDelimiter), METH_NOARGS|METH_STATIC},
    {"defaultQueryValueDelimiter", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_defaultQueryValueDelimiter), METH_NOARGS|METH_STATIC},
    {"hasQueryItem", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_hasQueryItem), METH_O},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_isEmpty), METH_NOARGS},
    {"query", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_query), METH_VARARGS|METH_KEYWORDS},
    {"queryItemValue", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_queryItemValue), METH_VARARGS|METH_KEYWORDS},
    {"queryItems", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_queryItems), METH_VARARGS|METH_KEYWORDS},
    {"queryPairDelimiter", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_queryPairDelimiter), METH_NOARGS},
    {"queryValueDelimiter", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_queryValueDelimiter), METH_NOARGS},
    {"removeAllQueryItems", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_removeAllQueryItems), METH_O},
    {"removeQueryItem", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_removeQueryItem), METH_O},
    {"setQuery", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_setQuery), METH_O},
    {"setQueryDelimiters", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_setQueryDelimiters), METH_VARARGS},
    {"setQueryItems", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_setQueryItems), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_swap), METH_O},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QUrlQueryFunc_toString), METH_VARARGS|METH_KEYWORDS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QUrlQuery___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QUrlQuery_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX]), (pyArg)))) {
                // operator!=(const QUrlQuery & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUrlQuery cppArg0_local;
                ::QUrlQuery *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX]), (pyArg)))) {
                // operator==(const QUrlQuery & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUrlQuery cppArg0_local;
                ::QUrlQuery *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QUrlQuery_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QUrlQuery_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QUrlQuery_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QUrlQuery_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QUrlQuery_Type = nullptr;
static SbkObjectType *Sbk_QUrlQuery_TypeF(void)
{
    return _Sbk_QUrlQuery_Type;
}

static PyType_Slot Sbk_QUrlQuery_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QUrlQuery_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QUrlQuery_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QUrlQuery_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QUrlQuery_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QUrlQuery_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QUrlQuery_spec = {
    "2:PySide2.QtCore.QUrlQuery",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QUrlQuery_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QUrlQuery_PythonToCpp_QUrlQuery_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QUrlQuery_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QUrlQuery_PythonToCpp_QUrlQuery_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QUrlQuery_TypeF())))
        return QUrlQuery_PythonToCpp_QUrlQuery_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QUrlQuery_PTR_CppToPython_QUrlQuery(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QUrlQuery *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QUrlQuery_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QUrlQuery_COPY_CppToPython_QUrlQuery(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QUrlQuery_TypeF(), new ::QUrlQuery(*reinterpret_cast<const ::QUrlQuery *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QUrlQuery_PythonToCpp_QUrlQuery_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QUrlQuery *>(cppOut) = *reinterpret_cast< ::QUrlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QUrlQuery_PythonToCpp_QUrlQuery_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QUrlQuery_TypeF())))
        return QUrlQuery_PythonToCpp_QUrlQuery_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QUrlQuery_SignatureStrings[] = {
    "3:PySide2.QtCore.QUrlQuery(self)",
    "2:PySide2.QtCore.QUrlQuery(self,queryString:QString)",
    "1:PySide2.QtCore.QUrlQuery(self,url:PySide2.QtCore.QUrl)",
    "0:PySide2.QtCore.QUrlQuery(self,other:PySide2.QtCore.QUrlQuery)",
    "PySide2.QtCore.QUrlQuery.addQueryItem(self,key:QString,value:QString)",
    "PySide2.QtCore.QUrlQuery.allQueryItemValues(self,key:QString,encoding:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.PrettyDecoded)->QStringList",
    "PySide2.QtCore.QUrlQuery.clear(self)",
    "PySide2.QtCore.QUrlQuery.defaultQueryPairDelimiter()->QChar",
    "PySide2.QtCore.QUrlQuery.defaultQueryValueDelimiter()->QChar",
    "PySide2.QtCore.QUrlQuery.hasQueryItem(self,key:QString)->bool",
    "PySide2.QtCore.QUrlQuery.isEmpty(self)->bool",
    "PySide2.QtCore.QUrlQuery.query(self,encoding:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.PrettyDecoded)->QString",
    "PySide2.QtCore.QUrlQuery.queryItemValue(self,key:QString,encoding:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.PrettyDecoded)->QString",
    "PySide2.QtCore.QUrlQuery.queryItems(self,encoding:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.PrettyDecoded)->QList[QPair[QString, QString]]",
    "PySide2.QtCore.QUrlQuery.queryPairDelimiter(self)->QChar",
    "PySide2.QtCore.QUrlQuery.queryValueDelimiter(self)->QChar",
    "PySide2.QtCore.QUrlQuery.removeAllQueryItems(self,key:QString)",
    "PySide2.QtCore.QUrlQuery.removeQueryItem(self,key:QString)",
    "PySide2.QtCore.QUrlQuery.setQuery(self,queryString:QString)",
    "PySide2.QtCore.QUrlQuery.setQueryDelimiters(self,valueDelimiter:QChar,pairDelimiter:QChar)",
    "PySide2.QtCore.QUrlQuery.setQueryItems(self,query:QList[QPair[QString, QString]])",
    "PySide2.QtCore.QUrlQuery.swap(self,other:PySide2.QtCore.QUrlQuery)",
    "PySide2.QtCore.QUrlQuery.toString(self,encoding:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.PrettyDecoded)->QString",
    "PySide2.QtCore.QUrlQuery.__copy__()",
    nullptr}; // Sentinel

void init_QUrlQuery(PyObject *module)
{
    _Sbk_QUrlQuery_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QUrlQuery",
        "QUrlQuery",
        &Sbk_QUrlQuery_spec,
        &Shiboken::callCppDestructor< ::QUrlQuery >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QUrlQuery_Type);
    InitSignatureStrings(pyType, QUrlQuery_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QUrlQuery_Type), Sbk_QUrlQuery_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QURLQUERY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QUrlQuery_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QUrlQuery_TypeF(),
        QUrlQuery_PythonToCpp_QUrlQuery_PTR,
        is_QUrlQuery_PythonToCpp_QUrlQuery_PTR_Convertible,
        QUrlQuery_PTR_CppToPython_QUrlQuery,
        QUrlQuery_COPY_CppToPython_QUrlQuery);

    Shiboken::Conversions::registerConverterName(converter, "QUrlQuery");
    Shiboken::Conversions::registerConverterName(converter, "QUrlQuery*");
    Shiboken::Conversions::registerConverterName(converter, "QUrlQuery&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QUrlQuery).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QUrlQuery_PythonToCpp_QUrlQuery_COPY,
        is_QUrlQuery_PythonToCpp_QUrlQuery_COPY_Convertible);

    qRegisterMetaType< ::QUrlQuery >("QUrlQuery");
}
