/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qwaitcondition_wrapper.h"

// inner classes

// Extra includes
#include <qdeadlinetimer.h>
#include <qmutex.h>
#include <qreadwritelock.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QWaitCondition_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QWaitCondition >()))
        return -1;

    ::QWaitCondition *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QWaitCondition.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QWaitCondition()
            cptr = new ::QWaitCondition();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QWaitCondition >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QWaitConditionFunc_notify_all(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWaitCondition *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QWAITCONDITION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QWaitCondition.notify_all";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // notify_all()
            cppSelf->notify_all();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWaitConditionFunc_notify_one(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWaitCondition *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QWAITCONDITION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QWaitCondition.notify_one";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // notify_one()
            cppSelf->notify_one();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWaitConditionFunc_wait(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWaitCondition *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QWAITCONDITION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QWaitCondition.wait";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWaitConditionFunc_wait_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QWaitConditionFunc_wait_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:wait", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWaitCondition::wait(QMutex*,QDeadlineTimer)
    // 1: QWaitCondition::wait(QMutex*,ulong)
    // 2: QWaitCondition::wait(QReadWriteLock*,QDeadlineTimer)
    // 3: QWaitCondition::wait(QReadWriteLock*,ulong)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // wait(QReadWriteLock*,QDeadlineTimer)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
            overloadId = 3; // wait(QReadWriteLock*,ulong)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), (pyArgs[1])))) {
            overloadId = 2; // wait(QReadWriteLock*,QDeadlineTimer)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMUTEX_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // wait(QMutex*,QDeadlineTimer)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
            overloadId = 1; // wait(QMutex*,ulong)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), (pyArgs[1])))) {
            overloadId = 0; // wait(QMutex*,QDeadlineTimer)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWaitConditionFunc_wait_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // wait(QMutex * lockedMutex, QDeadlineTimer deadline)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_deadline = Shiboken::String::createStaticString("deadline");
                if (PyDict_Contains(kwds, key_deadline)) {
                    value = PyDict_GetItem(kwds, key_deadline);
                    if (value && pyArgs[1]) {
                        errInfo = key_deadline;
                        Py_INCREF(errInfo);
                        goto Sbk_QWaitConditionFunc_wait_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), (pyArgs[1]))))
                            goto Sbk_QWaitConditionFunc_wait_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_deadline);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QWaitConditionFunc_wait_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMutex *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QDeadlineTimer cppArg1 = QDeadlineTimer(QDeadlineTimer::Forever);
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // wait(QMutex*,QDeadlineTimer)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->wait(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // wait(QMutex * lockedMutex, unsigned long time)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QWaitConditionFunc_wait_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMutex *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            unsigned long cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // wait(QMutex*,ulong)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->wait(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // wait(QReadWriteLock * lockedReadWriteLock, QDeadlineTimer deadline)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_deadline = Shiboken::String::createStaticString("deadline");
                if (PyDict_Contains(kwds, key_deadline)) {
                    value = PyDict_GetItem(kwds, key_deadline);
                    if (value && pyArgs[1]) {
                        errInfo = key_deadline;
                        Py_INCREF(errInfo);
                        goto Sbk_QWaitConditionFunc_wait_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), (pyArgs[1]))))
                            goto Sbk_QWaitConditionFunc_wait_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_deadline);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QWaitConditionFunc_wait_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QReadWriteLock *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QDeadlineTimer cppArg1 = QDeadlineTimer(QDeadlineTimer::Forever);
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // wait(QReadWriteLock*,QDeadlineTimer)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->wait(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 3: // wait(QReadWriteLock * lockedReadWriteLock, unsigned long time)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QWaitConditionFunc_wait_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QReadWriteLock *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            unsigned long cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // wait(QReadWriteLock*,ulong)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->wait(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWaitConditionFunc_wait_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWaitConditionFunc_wakeAll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWaitCondition *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QWAITCONDITION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QWaitCondition.wakeAll";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wakeAll()
            cppSelf->wakeAll();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWaitConditionFunc_wakeOne(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWaitCondition *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QWAITCONDITION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QWaitCondition.wakeOne";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wakeOne()
            cppSelf->wakeOne();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QWaitCondition_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWaitCondition_methods[] = {
    {"notify_all", reinterpret_cast<PyCFunction>(Sbk_QWaitConditionFunc_notify_all), METH_NOARGS},
    {"notify_one", reinterpret_cast<PyCFunction>(Sbk_QWaitConditionFunc_notify_one), METH_NOARGS},
    {"wait", reinterpret_cast<PyCFunction>(Sbk_QWaitConditionFunc_wait), METH_VARARGS|METH_KEYWORDS},
    {"wakeAll", reinterpret_cast<PyCFunction>(Sbk_QWaitConditionFunc_wakeAll), METH_NOARGS},
    {"wakeOne", reinterpret_cast<PyCFunction>(Sbk_QWaitConditionFunc_wakeOne), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QWaitCondition_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWaitCondition_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWaitCondition_Type = nullptr;
static SbkObjectType *Sbk_QWaitCondition_TypeF(void)
{
    return _Sbk_QWaitCondition_Type;
}

static PyType_Slot Sbk_QWaitCondition_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWaitCondition_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWaitCondition_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWaitCondition_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QWaitCondition_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWaitCondition_spec = {
    "2:PySide2.QtCore.QWaitCondition",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWaitCondition_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWaitCondition_PythonToCpp_QWaitCondition_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWaitCondition_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWaitCondition_PythonToCpp_QWaitCondition_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWaitCondition_TypeF())))
        return QWaitCondition_PythonToCpp_QWaitCondition_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWaitCondition_PTR_CppToPython_QWaitCondition(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QWaitCondition *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QWaitCondition_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWaitCondition_SignatureStrings[] = {
    "PySide2.QtCore.QWaitCondition(self)",
    "PySide2.QtCore.QWaitCondition.notify_all(self)",
    "PySide2.QtCore.QWaitCondition.notify_one(self)",
    "3:PySide2.QtCore.QWaitCondition.wait(self,lockedMutex:PySide2.QtCore.QMutex,deadline:PySide2.QtCore.QDeadlineTimer=QDeadlineTimer(QDeadlineTimer.Forever))->bool",
    "2:PySide2.QtCore.QWaitCondition.wait(self,lockedMutex:PySide2.QtCore.QMutex,time:unsigned long)->bool",
    "1:PySide2.QtCore.QWaitCondition.wait(self,lockedReadWriteLock:PySide2.QtCore.QReadWriteLock,deadline:PySide2.QtCore.QDeadlineTimer=QDeadlineTimer(QDeadlineTimer.Forever))->bool",
    "0:PySide2.QtCore.QWaitCondition.wait(self,lockedReadWriteLock:PySide2.QtCore.QReadWriteLock,time:unsigned long)->bool",
    "PySide2.QtCore.QWaitCondition.wakeAll(self)",
    "PySide2.QtCore.QWaitCondition.wakeOne(self)",
    nullptr}; // Sentinel

void init_QWaitCondition(PyObject *module)
{
    _Sbk_QWaitCondition_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWaitCondition",
        "QWaitCondition*",
        &Sbk_QWaitCondition_spec,
        &Shiboken::callCppDestructor< ::QWaitCondition >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWaitCondition_Type);
    InitSignatureStrings(pyType, QWaitCondition_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWaitCondition_Type), Sbk_QWaitCondition_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QWAITCONDITION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWaitCondition_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWaitCondition_TypeF(),
        QWaitCondition_PythonToCpp_QWaitCondition_PTR,
        is_QWaitCondition_PythonToCpp_QWaitCondition_PTR_Convertible,
        QWaitCondition_PTR_CppToPython_QWaitCondition);

    Shiboken::Conversions::registerConverterName(converter, "QWaitCondition");
    Shiboken::Conversions::registerConverterName(converter, "QWaitCondition*");
    Shiboken::Conversions::registerConverterName(converter, "QWaitCondition&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWaitCondition).name());


}
