/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qxmlstreamreader_wrapper.h"

// inner classes

// Extra includes
#include <QVector>
#include <qbytearray.h>
#include <qiodevice.h>
#include <qxmlstream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QXmlStreamReader_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QXmlStreamReader >()))
        return -1;

    ::QXmlStreamReader *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QXmlStreamReader", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QXmlStreamReader::QXmlStreamReader()
    // 1: QXmlStreamReader::QXmlStreamReader(QIODevice*)
    // 2: QXmlStreamReader::QXmlStreamReader(QByteArray)
    // 3: QXmlStreamReader::QXmlStreamReader(QString)
    // 4: QXmlStreamReader::QXmlStreamReader(const char*)
    if (numArgs == 0) {
        overloadId = 0; // QXmlStreamReader()
    } else if (numArgs == 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        overloadId = 4; // QXmlStreamReader(const char*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QXmlStreamReader(QIODevice*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 3; // QXmlStreamReader(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QXmlStreamReader(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamReader_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QXmlStreamReader()
        {

            if (!PyErr_Occurred()) {
                // QXmlStreamReader()
                cptr = new ::QXmlStreamReader();
            }
            break;
        }
        case 1: // QXmlStreamReader(QIODevice * device)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QXmlStreamReader(QIODevice*)
                cptr = new ::QXmlStreamReader(cppArg0);
            }
            break;
        }
        case 2: // QXmlStreamReader(const QByteArray & data)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QXmlStreamReader(QByteArray)
                cptr = new ::QXmlStreamReader(*cppArg0);
            }
            break;
        }
        case 3: // QXmlStreamReader(const QString & data)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QXmlStreamReader(QString)
                cptr = new ::QXmlStreamReader(cppArg0);
            }
            break;
        }
        case 4: // QXmlStreamReader(const char * data)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QXmlStreamReader(const char*)
                cptr = new ::QXmlStreamReader(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QXmlStreamReader >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QXmlStreamReader_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QXmlStreamReader_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QXmlStreamReaderFunc_addData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.addData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamReader::addData(QByteArray)
    // 1: QXmlStreamReader::addData(QString)
    // 2: QXmlStreamReader::addData(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 2; // addData(const char*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // addData(QString)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // addData(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamReaderFunc_addData_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addData(const QByteArray & data)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // addData(QByteArray)
                cppSelf->addData(*cppArg0);
            }
            break;
        }
        case 1: // addData(const QString & data)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // addData(QString)
                cppSelf->addData(cppArg0);
            }
            break;
        }
        case 2: // addData(const char * data)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // addData(const char*)
                cppSelf->addData(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamReaderFunc_addData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamReaderFunc_addExtraNamespaceDeclaration(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.addExtraNamespaceDeclaration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamReader::addExtraNamespaceDeclaration(QXmlStreamNamespaceDeclaration)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMNAMESPACEDECLARATION_IDX]), (pyArg)))) {
        overloadId = 0; // addExtraNamespaceDeclaration(QXmlStreamNamespaceDeclaration)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamReaderFunc_addExtraNamespaceDeclaration_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlStreamNamespaceDeclaration cppArg0_local;
        ::QXmlStreamNamespaceDeclaration *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMNAMESPACEDECLARATION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // addExtraNamespaceDeclaration(QXmlStreamNamespaceDeclaration)
            cppSelf->addExtraNamespaceDeclaration(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamReaderFunc_addExtraNamespaceDeclaration_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamReaderFunc_addExtraNamespaceDeclarations(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.addExtraNamespaceDeclarations";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamReader::addExtraNamespaceDeclarations(QVector<QXmlStreamNamespaceDeclaration>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMNAMESPACEDECLARATION_IDX], (pyArg)))) {
        overloadId = 0; // addExtraNamespaceDeclarations(QVector<QXmlStreamNamespaceDeclaration>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamReaderFunc_addExtraNamespaceDeclarations_TypeError;

    // Call function/method
    {
        ::QVector<QXmlStreamNamespaceDeclaration > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addExtraNamespaceDeclarations(QVector<QXmlStreamNamespaceDeclaration>)
            cppSelf->addExtraNamespaceDeclarations(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamReaderFunc_addExtraNamespaceDeclarations_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamReaderFunc_atEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.atEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // atEnd()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->atEnd();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_attributes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.attributes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // attributes()const
            QXmlStreamAttributes cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->attributes();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_characterOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.characterOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // characterOffset()const
            qint64 cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->characterOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QXmlStreamReaderFunc_columnNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.columnNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnNumber()const
            qint64 cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->columnNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QIODevice * cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_documentEncoding(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.documentEncoding";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // documentEncoding()const
            QStringRef cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->documentEncoding();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_documentVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.documentVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // documentVersion()const
            QStringRef cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->documentVersion();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_dtdName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.dtdName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dtdName()const
            QStringRef cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->dtdName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_dtdPublicId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.dtdPublicId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dtdPublicId()const
            QStringRef cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->dtdPublicId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_dtdSystemId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.dtdSystemId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dtdSystemId()const
            QStringRef cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->dtdSystemId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_entityDeclarations(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.entityDeclarations";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // entityDeclarations()const
            QVector<QXmlStreamEntityDeclaration > cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->entityDeclarations();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMENTITYDECLARATION_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_entityExpansionLimit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.entityExpansionLimit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // entityExpansionLimit()const
            int cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->entityExpansionLimit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_entityResolver(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.entityResolver";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // entityResolver()const
            QXmlStreamEntityResolver * cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->entityResolver();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYRESOLVER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QXmlStreamReader::Error cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_hasError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.hasError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasError()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->hasError();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_isCDATA(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.isCDATA";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCDATA()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->isCDATA();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_isCharacters(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.isCharacters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCharacters()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->isCharacters();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_isComment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.isComment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isComment()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->isComment();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_isDTD(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.isDTD";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDTD()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->isDTD();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_isEndDocument(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.isEndDocument";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEndDocument()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->isEndDocument();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_isEndElement(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.isEndElement";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEndElement()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->isEndElement();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_isEntityReference(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.isEntityReference";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEntityReference()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->isEntityReference();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_isProcessingInstruction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.isProcessingInstruction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isProcessingInstruction()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->isProcessingInstruction();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_isStandaloneDocument(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.isStandaloneDocument";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isStandaloneDocument()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->isStandaloneDocument();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_isStartDocument(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.isStartDocument";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isStartDocument()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->isStartDocument();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_isStartElement(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.isStartElement";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isStartElement()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->isStartElement();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_isWhitespace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.isWhitespace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isWhitespace()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->isWhitespace();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_lineNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.lineNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineNumber()const
            qint64 cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->lineNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QStringRef cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_namespaceDeclarations(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.namespaceDeclarations";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // namespaceDeclarations()const
            QVector<QXmlStreamNamespaceDeclaration > cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->namespaceDeclarations();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMNAMESPACEDECLARATION_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_namespaceProcessing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.namespaceProcessing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // namespaceProcessing()const
            bool cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->namespaceProcessing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_namespaceUri(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.namespaceUri";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // namespaceUri()const
            QStringRef cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->namespaceUri();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_notationDeclarations(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.notationDeclarations";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // notationDeclarations()const
            QVector<QXmlStreamNotationDeclaration > cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->notationDeclarations();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QXMLSTREAMNOTATIONDECLARATION_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_prefix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.prefix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // prefix()const
            QStringRef cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->prefix();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_processingInstructionData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.processingInstructionData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // processingInstructionData()const
            QStringRef cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->processingInstructionData();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_processingInstructionTarget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.processingInstructionTarget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // processingInstructionTarget()const
            QStringRef cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->processingInstructionTarget();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_qualifiedName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.qualifiedName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // qualifiedName()const
            QStringRef cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->qualifiedName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_raiseError(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.raiseError";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QXmlStreamReaderFunc_raiseError_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:raiseError", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamReader::raiseError(QString)
    if (numArgs == 0) {
        overloadId = 0; // raiseError(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // raiseError(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamReaderFunc_raiseError_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_message = Shiboken::String::createStaticString("message");
            if (PyDict_Contains(kwds, key_message)) {
                value = PyDict_GetItem(kwds, key_message);
                if (value && pyArgs[0]) {
                    errInfo = key_message;
                    Py_INCREF(errInfo);
                    goto Sbk_QXmlStreamReaderFunc_raiseError_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QXmlStreamReaderFunc_raiseError_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_message);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QXmlStreamReaderFunc_raiseError_TypeError;
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // raiseError(QString)
            cppSelf->raiseError(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamReaderFunc_raiseError_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamReaderFunc_readElementText(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.readElementText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QXmlStreamReaderFunc_readElementText_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:readElementText", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QXmlStreamReader::readElementText(QXmlStreamReader::ReadElementTextBehaviour)
    if (numArgs == 0) {
        overloadId = 0; // readElementText(QXmlStreamReader::ReadElementTextBehaviour)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // readElementText(QXmlStreamReader::ReadElementTextBehaviour)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamReaderFunc_readElementText_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_behaviour = Shiboken::String::createStaticString("behaviour");
            if (PyDict_Contains(kwds, key_behaviour)) {
                value = PyDict_GetItem(kwds, key_behaviour);
                if (value && pyArgs[0]) {
                    errInfo = key_behaviour;
                    Py_INCREF(errInfo);
                    goto Sbk_QXmlStreamReaderFunc_readElementText_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QXmlStreamReaderFunc_readElementText_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_behaviour);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QXmlStreamReaderFunc_readElementText_TypeError;
            }
        }
        ::QXmlStreamReader::ReadElementTextBehaviour cppArg0 = QXmlStreamReader::ReadElementTextBehaviour::ErrorOnUnexpectedElement;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // readElementText(QXmlStreamReader::ReadElementTextBehaviour)
            QString cppResult = cppSelf->readElementText(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlStreamReaderFunc_readElementText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamReaderFunc_readNext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.readNext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readNext()
            QXmlStreamReader::TokenType cppResult = cppSelf->readNext();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_readNextStartElement(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.readNextStartElement";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readNextStartElement()
            bool cppResult = cppSelf->readNextStartElement();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_setDevice(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.setDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamReader::setDevice(QIODevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // setDevice(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamReaderFunc_setDevice_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIODevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevice(QIODevice*)
            cppSelf->setDevice(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamReaderFunc_setDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamReaderFunc_setEntityExpansionLimit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.setEntityExpansionLimit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamReader::setEntityExpansionLimit(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setEntityExpansionLimit(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamReaderFunc_setEntityExpansionLimit_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEntityExpansionLimit(int)
            cppSelf->setEntityExpansionLimit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamReaderFunc_setEntityExpansionLimit_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamReaderFunc_setEntityResolver(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.setEntityResolver";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamReader::setEntityResolver(QXmlStreamEntityResolver*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMENTITYRESOLVER_IDX]), (pyArg)))) {
        overloadId = 0; // setEntityResolver(QXmlStreamEntityResolver*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamReaderFunc_setEntityResolver_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlStreamEntityResolver *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEntityResolver(QXmlStreamEntityResolver*)
            cppSelf->setEntityResolver(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamReaderFunc_setEntityResolver_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamReaderFunc_setNamespaceProcessing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.setNamespaceProcessing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlStreamReader::setNamespaceProcessing(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setNamespaceProcessing(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlStreamReaderFunc_setNamespaceProcessing_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNamespaceProcessing(bool)
            cppSelf->setNamespaceProcessing(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlStreamReaderFunc_setNamespaceProcessing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlStreamReaderFunc_skipCurrentElement(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.skipCurrentElement";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // skipCurrentElement()
            cppSelf->skipCurrentElement();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QXmlStreamReaderFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.text";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // text()const
            QStringRef cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->text();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_tokenString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.tokenString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tokenString()const
            QString cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->tokenString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlStreamReaderFunc_tokenType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QXmlStreamReader.tokenType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tokenType()const
            QXmlStreamReader::TokenType cppResult = const_cast<const ::QXmlStreamReader *>(cppSelf)->tokenType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QXmlStreamReader_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QXmlStreamReader_methods[] = {
    {"addData", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_addData), METH_O},
    {"addExtraNamespaceDeclaration", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_addExtraNamespaceDeclaration), METH_O},
    {"addExtraNamespaceDeclarations", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_addExtraNamespaceDeclarations), METH_O},
    {"atEnd", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_atEnd), METH_NOARGS},
    {"attributes", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_attributes), METH_NOARGS},
    {"characterOffset", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_characterOffset), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_clear), METH_NOARGS},
    {"columnNumber", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_columnNumber), METH_NOARGS},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_device), METH_NOARGS},
    {"documentEncoding", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_documentEncoding), METH_NOARGS},
    {"documentVersion", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_documentVersion), METH_NOARGS},
    {"dtdName", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_dtdName), METH_NOARGS},
    {"dtdPublicId", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_dtdPublicId), METH_NOARGS},
    {"dtdSystemId", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_dtdSystemId), METH_NOARGS},
    {"entityDeclarations", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_entityDeclarations), METH_NOARGS},
    {"entityExpansionLimit", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_entityExpansionLimit), METH_NOARGS},
    {"entityResolver", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_entityResolver), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_errorString), METH_NOARGS},
    {"hasError", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_hasError), METH_NOARGS},
    {"isCDATA", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_isCDATA), METH_NOARGS},
    {"isCharacters", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_isCharacters), METH_NOARGS},
    {"isComment", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_isComment), METH_NOARGS},
    {"isDTD", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_isDTD), METH_NOARGS},
    {"isEndDocument", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_isEndDocument), METH_NOARGS},
    {"isEndElement", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_isEndElement), METH_NOARGS},
    {"isEntityReference", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_isEntityReference), METH_NOARGS},
    {"isProcessingInstruction", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_isProcessingInstruction), METH_NOARGS},
    {"isStandaloneDocument", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_isStandaloneDocument), METH_NOARGS},
    {"isStartDocument", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_isStartDocument), METH_NOARGS},
    {"isStartElement", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_isStartElement), METH_NOARGS},
    {"isWhitespace", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_isWhitespace), METH_NOARGS},
    {"lineNumber", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_lineNumber), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_name), METH_NOARGS},
    {"namespaceDeclarations", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_namespaceDeclarations), METH_NOARGS},
    {"namespaceProcessing", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_namespaceProcessing), METH_NOARGS},
    {"namespaceUri", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_namespaceUri), METH_NOARGS},
    {"notationDeclarations", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_notationDeclarations), METH_NOARGS},
    {"prefix", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_prefix), METH_NOARGS},
    {"processingInstructionData", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_processingInstructionData), METH_NOARGS},
    {"processingInstructionTarget", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_processingInstructionTarget), METH_NOARGS},
    {"qualifiedName", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_qualifiedName), METH_NOARGS},
    {"raiseError", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_raiseError), METH_VARARGS|METH_KEYWORDS},
    {"readElementText", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_readElementText), METH_VARARGS|METH_KEYWORDS},
    {"readNext", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_readNext), METH_NOARGS},
    {"readNextStartElement", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_readNextStartElement), METH_NOARGS},
    {"setDevice", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_setDevice), METH_O},
    {"setEntityExpansionLimit", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_setEntityExpansionLimit), METH_O},
    {"setEntityResolver", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_setEntityResolver), METH_O},
    {"setNamespaceProcessing", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_setNamespaceProcessing), METH_O},
    {"skipCurrentElement", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_skipCurrentElement), METH_NOARGS},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_text), METH_NOARGS},
    {"tokenString", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_tokenString), METH_NOARGS},
    {"tokenType", reinterpret_cast<PyCFunction>(Sbk_QXmlStreamReaderFunc_tokenType), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QXmlStreamReader_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QXmlStreamReader_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QXmlStreamReader_Type = nullptr;
static SbkObjectType *Sbk_QXmlStreamReader_TypeF(void)
{
    return _Sbk_QXmlStreamReader_Type;
}

static PyType_Slot Sbk_QXmlStreamReader_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QXmlStreamReader_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QXmlStreamReader_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QXmlStreamReader_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QXmlStreamReader_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QXmlStreamReader_spec = {
    "2:PySide2.QtCore.QXmlStreamReader",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QXmlStreamReader_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QXmlStreamReader_TokenType_PythonToCpp_QXmlStreamReader_TokenType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlStreamReader::TokenType *>(cppOut) =
        static_cast<::QXmlStreamReader::TokenType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QXmlStreamReader_TokenType_PythonToCpp_QXmlStreamReader_TokenType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX]))
        return QXmlStreamReader_TokenType_PythonToCpp_QXmlStreamReader_TokenType;
    return {};
}
static PyObject *QXmlStreamReader_TokenType_CppToPython_QXmlStreamReader_TokenType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QXmlStreamReader::TokenType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX], castCppIn);

}

static void QXmlStreamReader_ReadElementTextBehaviour_PythonToCpp_QXmlStreamReader_ReadElementTextBehaviour(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlStreamReader::ReadElementTextBehaviour *>(cppOut) =
        static_cast<::QXmlStreamReader::ReadElementTextBehaviour>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QXmlStreamReader_ReadElementTextBehaviour_PythonToCpp_QXmlStreamReader_ReadElementTextBehaviour_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX]))
        return QXmlStreamReader_ReadElementTextBehaviour_PythonToCpp_QXmlStreamReader_ReadElementTextBehaviour;
    return {};
}
static PyObject *QXmlStreamReader_ReadElementTextBehaviour_CppToPython_QXmlStreamReader_ReadElementTextBehaviour(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QXmlStreamReader::ReadElementTextBehaviour *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX], castCppIn);

}

static void QXmlStreamReader_Error_PythonToCpp_QXmlStreamReader_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlStreamReader::Error *>(cppOut) =
        static_cast<::QXmlStreamReader::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QXmlStreamReader_Error_PythonToCpp_QXmlStreamReader_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX]))
        return QXmlStreamReader_Error_PythonToCpp_QXmlStreamReader_Error;
    return {};
}
static PyObject *QXmlStreamReader_Error_CppToPython_QXmlStreamReader_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QXmlStreamReader::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QXmlStreamReader_PythonToCpp_QXmlStreamReader_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QXmlStreamReader_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QXmlStreamReader_PythonToCpp_QXmlStreamReader_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlStreamReader_TypeF())))
        return QXmlStreamReader_PythonToCpp_QXmlStreamReader_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QXmlStreamReader_PTR_CppToPython_QXmlStreamReader(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QXmlStreamReader *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QXmlStreamReader_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QXmlStreamReader_SignatureStrings[] = {
    "4:PySide2.QtCore.QXmlStreamReader(self)",
    "3:PySide2.QtCore.QXmlStreamReader(self,device:PySide2.QtCore.QIODevice)",
    "2:PySide2.QtCore.QXmlStreamReader(self,data:PySide2.QtCore.QByteArray)",
    "1:PySide2.QtCore.QXmlStreamReader(self,data:QString)",
    "0:PySide2.QtCore.QXmlStreamReader(self,data:char*)",
    "2:PySide2.QtCore.QXmlStreamReader.addData(self,data:PySide2.QtCore.QByteArray)",
    "1:PySide2.QtCore.QXmlStreamReader.addData(self,data:QString)",
    "0:PySide2.QtCore.QXmlStreamReader.addData(self,data:char*)",
    "PySide2.QtCore.QXmlStreamReader.addExtraNamespaceDeclaration(self,extraNamespaceDeclaraction:PySide2.QtCore.QXmlStreamNamespaceDeclaration)",
    "PySide2.QtCore.QXmlStreamReader.addExtraNamespaceDeclarations(self,extraNamespaceDeclaractions:QVector[PySide2.QtCore.QXmlStreamNamespaceDeclaration])",
    "PySide2.QtCore.QXmlStreamReader.atEnd(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.attributes(self)->PySide2.QtCore.QXmlStreamAttributes",
    "PySide2.QtCore.QXmlStreamReader.characterOffset(self)->qint64",
    "PySide2.QtCore.QXmlStreamReader.clear(self)",
    "PySide2.QtCore.QXmlStreamReader.columnNumber(self)->qint64",
    "PySide2.QtCore.QXmlStreamReader.device(self)->PySide2.QtCore.QIODevice",
    "PySide2.QtCore.QXmlStreamReader.documentEncoding(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamReader.documentVersion(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamReader.dtdName(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamReader.dtdPublicId(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamReader.dtdSystemId(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamReader.entityDeclarations(self)->QVector[PySide2.QtCore.QXmlStreamEntityDeclaration]",
    "PySide2.QtCore.QXmlStreamReader.entityExpansionLimit(self)->int",
    "PySide2.QtCore.QXmlStreamReader.entityResolver(self)->PySide2.QtCore.QXmlStreamEntityResolver",
    "PySide2.QtCore.QXmlStreamReader.error(self)->PySide2.QtCore.QXmlStreamReader.Error",
    "PySide2.QtCore.QXmlStreamReader.errorString(self)->QString",
    "PySide2.QtCore.QXmlStreamReader.hasError(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.isCDATA(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.isCharacters(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.isComment(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.isDTD(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.isEndDocument(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.isEndElement(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.isEntityReference(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.isProcessingInstruction(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.isStandaloneDocument(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.isStartDocument(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.isStartElement(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.isWhitespace(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.lineNumber(self)->qint64",
    "PySide2.QtCore.QXmlStreamReader.name(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamReader.namespaceDeclarations(self)->QVector[PySide2.QtCore.QXmlStreamNamespaceDeclaration]",
    "PySide2.QtCore.QXmlStreamReader.namespaceProcessing(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.namespaceUri(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamReader.notationDeclarations(self)->QVector[PySide2.QtCore.QXmlStreamNotationDeclaration]",
    "PySide2.QtCore.QXmlStreamReader.prefix(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamReader.processingInstructionData(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamReader.processingInstructionTarget(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamReader.qualifiedName(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamReader.raiseError(self,message:QString=QString())",
    "PySide2.QtCore.QXmlStreamReader.readElementText(self,behaviour:PySide2.QtCore.QXmlStreamReader.ReadElementTextBehaviour=ErrorOnUnexpectedElement)->QString",
    "PySide2.QtCore.QXmlStreamReader.readNext(self)->PySide2.QtCore.QXmlStreamReader.TokenType",
    "PySide2.QtCore.QXmlStreamReader.readNextStartElement(self)->bool",
    "PySide2.QtCore.QXmlStreamReader.setDevice(self,device:PySide2.QtCore.QIODevice)",
    "PySide2.QtCore.QXmlStreamReader.setEntityExpansionLimit(self,limit:int)",
    "PySide2.QtCore.QXmlStreamReader.setEntityResolver(self,resolver:PySide2.QtCore.QXmlStreamEntityResolver)",
    "PySide2.QtCore.QXmlStreamReader.setNamespaceProcessing(self,arg__1:bool)",
    "PySide2.QtCore.QXmlStreamReader.skipCurrentElement(self)",
    "PySide2.QtCore.QXmlStreamReader.text(self)->QStringRef",
    "PySide2.QtCore.QXmlStreamReader.tokenString(self)->QString",
    "PySide2.QtCore.QXmlStreamReader.tokenType(self)->PySide2.QtCore.QXmlStreamReader.TokenType",
    nullptr}; // Sentinel

void init_QXmlStreamReader(PyObject *module)
{
    _Sbk_QXmlStreamReader_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QXmlStreamReader",
        "QXmlStreamReader*",
        &Sbk_QXmlStreamReader_spec,
        &Shiboken::callCppDestructor< ::QXmlStreamReader >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QXmlStreamReader_Type);
    InitSignatureStrings(pyType, QXmlStreamReader_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QXmlStreamReader_Type), Sbk_QXmlStreamReader_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QXmlStreamReader_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QXmlStreamReader_TypeF(),
        QXmlStreamReader_PythonToCpp_QXmlStreamReader_PTR,
        is_QXmlStreamReader_PythonToCpp_QXmlStreamReader_PTR_Convertible,
        QXmlStreamReader_PTR_CppToPython_QXmlStreamReader);

    Shiboken::Conversions::registerConverterName(converter, "QXmlStreamReader");
    Shiboken::Conversions::registerConverterName(converter, "QXmlStreamReader*");
    Shiboken::Conversions::registerConverterName(converter, "QXmlStreamReader&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QXmlStreamReader).name());


    // Initialization of enums.

    // Initialization of enum 'TokenType'.
    SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QXmlStreamReader_TypeF(),
        "TokenType",
        "2:PySide2.QtCore.QXmlStreamReader.TokenType",
        "QXmlStreamReader::TokenType");
    if (!SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX],
        Sbk_QXmlStreamReader_TypeF(), "NoToken", (long) QXmlStreamReader::TokenType::NoToken))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX],
        Sbk_QXmlStreamReader_TypeF(), "Invalid", (long) QXmlStreamReader::TokenType::Invalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX],
        Sbk_QXmlStreamReader_TypeF(), "StartDocument", (long) QXmlStreamReader::TokenType::StartDocument))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX],
        Sbk_QXmlStreamReader_TypeF(), "EndDocument", (long) QXmlStreamReader::TokenType::EndDocument))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX],
        Sbk_QXmlStreamReader_TypeF(), "StartElement", (long) QXmlStreamReader::TokenType::StartElement))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX],
        Sbk_QXmlStreamReader_TypeF(), "EndElement", (long) QXmlStreamReader::TokenType::EndElement))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX],
        Sbk_QXmlStreamReader_TypeF(), "Characters", (long) QXmlStreamReader::TokenType::Characters))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX],
        Sbk_QXmlStreamReader_TypeF(), "Comment", (long) QXmlStreamReader::TokenType::Comment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX],
        Sbk_QXmlStreamReader_TypeF(), "DTD", (long) QXmlStreamReader::TokenType::DTD))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX],
        Sbk_QXmlStreamReader_TypeF(), "EntityReference", (long) QXmlStreamReader::TokenType::EntityReference))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX],
        Sbk_QXmlStreamReader_TypeF(), "ProcessingInstruction", (long) QXmlStreamReader::TokenType::ProcessingInstruction))
        return;
    // Register converter for enum 'QXmlStreamReader::TokenType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX],
            QXmlStreamReader_TokenType_CppToPython_QXmlStreamReader_TokenType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QXmlStreamReader_TokenType_PythonToCpp_QXmlStreamReader_TokenType,
            is_QXmlStreamReader_TokenType_PythonToCpp_QXmlStreamReader_TokenType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QXmlStreamReader::TokenType");
        Shiboken::Conversions::registerConverterName(converter, "TokenType");
    }
    // End of 'TokenType' enum.

    // Initialization of enum 'ReadElementTextBehaviour'.
    SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QXmlStreamReader_TypeF(),
        "ReadElementTextBehaviour",
        "2:PySide2.QtCore.QXmlStreamReader.ReadElementTextBehaviour",
        "QXmlStreamReader::ReadElementTextBehaviour");
    if (!SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX],
        Sbk_QXmlStreamReader_TypeF(), "ErrorOnUnexpectedElement", (long) QXmlStreamReader::ReadElementTextBehaviour::ErrorOnUnexpectedElement))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX],
        Sbk_QXmlStreamReader_TypeF(), "IncludeChildElements", (long) QXmlStreamReader::ReadElementTextBehaviour::IncludeChildElements))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX],
        Sbk_QXmlStreamReader_TypeF(), "SkipChildElements", (long) QXmlStreamReader::ReadElementTextBehaviour::SkipChildElements))
        return;
    // Register converter for enum 'QXmlStreamReader::ReadElementTextBehaviour'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX],
            QXmlStreamReader_ReadElementTextBehaviour_CppToPython_QXmlStreamReader_ReadElementTextBehaviour);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QXmlStreamReader_ReadElementTextBehaviour_PythonToCpp_QXmlStreamReader_ReadElementTextBehaviour,
            is_QXmlStreamReader_ReadElementTextBehaviour_PythonToCpp_QXmlStreamReader_ReadElementTextBehaviour_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QXmlStreamReader::ReadElementTextBehaviour");
        Shiboken::Conversions::registerConverterName(converter, "ReadElementTextBehaviour");
    }
    // End of 'ReadElementTextBehaviour' enum.

    // Initialization of enum 'Error'.
    SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QXmlStreamReader_TypeF(),
        "Error",
        "2:PySide2.QtCore.QXmlStreamReader.Error",
        "QXmlStreamReader::Error");
    if (!SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX],
        Sbk_QXmlStreamReader_TypeF(), "NoError", (long) QXmlStreamReader::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX],
        Sbk_QXmlStreamReader_TypeF(), "UnexpectedElementError", (long) QXmlStreamReader::Error::UnexpectedElementError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX],
        Sbk_QXmlStreamReader_TypeF(), "CustomError", (long) QXmlStreamReader::Error::CustomError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX],
        Sbk_QXmlStreamReader_TypeF(), "NotWellFormedError", (long) QXmlStreamReader::Error::NotWellFormedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX],
        Sbk_QXmlStreamReader_TypeF(), "PrematureEndOfDocumentError", (long) QXmlStreamReader::Error::PrematureEndOfDocumentError))
        return;
    // Register converter for enum 'QXmlStreamReader::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX],
            QXmlStreamReader_Error_CppToPython_QXmlStreamReader_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QXmlStreamReader_Error_PythonToCpp_QXmlStreamReader_Error,
            is_QXmlStreamReader_Error_PythonToCpp_QXmlStreamReader_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QXmlStreamReader::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    qRegisterMetaType< ::QXmlStreamReader::TokenType >("QXmlStreamReader::TokenType");
    qRegisterMetaType< ::QXmlStreamReader::ReadElementTextBehaviour >("QXmlStreamReader::ReadElementTextBehaviour");
    qRegisterMetaType< ::QXmlStreamReader::Error >("QXmlStreamReader::Error");
}
