/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_q3dcamera_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtDataVisualization;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void Q3DCameraWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

Q3DCameraWrapper::Q3DCameraWrapper(::QObject * parent) : QtDataVisualization::Q3DCamera(parent)
{
    resetPyMethodCache();
    // ... middle
}

void Q3DCameraWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void Q3DCameraWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void Q3DCameraWrapper::copyValuesFrom(const ::QtDataVisualization::Q3DObject & source)
{
    if (m_PyMethodCache[2]) {
        return this->::QtDataVisualization::Q3DCamera::copyValuesFrom(source);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "copyValuesFrom";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QtDataVisualization::Q3DCamera::copyValuesFrom(source);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DOBJECT_IDX]), &source)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void Q3DCameraWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void Q3DCameraWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool Q3DCameraWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "Q3DCamera.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool Q3DCameraWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "Q3DCamera.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void Q3DCameraWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *Q3DCameraWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtDataVisualization::Q3DCamera::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int Q3DCameraWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtDataVisualization::Q3DCamera::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *Q3DCameraWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< Q3DCameraWrapper *>(this));
        return QtDataVisualization::Q3DCamera::qt_metacast(_clname);
}

Q3DCameraWrapper::~Q3DCameraWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtDataVisualization_Q3DCamera_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtDataVisualization::Q3DCamera >()))
        return -1;

    ::Q3DCameraWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:Q3DCamera", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: Q3DCamera::Q3DCamera(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // Q3DCamera(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // Q3DCamera(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DCamera_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QtDataVisualization_Q3DCamera_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QtDataVisualization_Q3DCamera_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // Q3DCamera(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::Q3DCameraWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::Q3DCameraWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtDataVisualization::Q3DCamera >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtDataVisualization_Q3DCamera_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QtDataVisualization_Q3DCamera_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QtDataVisualization_Q3DCamera_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_cameraPreset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.cameraPreset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cameraPreset()const
            QtDataVisualization::Q3DCamera::CameraPreset cppResult = const_cast<const ::QtDataVisualization::Q3DCamera *>(cppSelf)->cameraPreset();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_copyValuesFrom(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.copyValuesFrom";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DObject::copyValuesFrom(QtDataVisualization::Q3DObject)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // copyValuesFrom(QtDataVisualization::Q3DObject)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DCameraFunc_copyValuesFrom_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtDataVisualization::Q3DObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // copyValuesFrom(QtDataVisualization::Q3DObject)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QtDataVisualization::Q3DCamera::copyValuesFrom(*cppArg0)
                : cppSelf->copyValuesFrom(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DCameraFunc_copyValuesFrom_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_maxZoomLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.maxZoomLevel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxZoomLevel()const
            float cppResult = const_cast<const ::QtDataVisualization::Q3DCamera *>(cppSelf)->maxZoomLevel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_minZoomLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.minZoomLevel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minZoomLevel()const
            float cppResult = const_cast<const ::QtDataVisualization::Q3DCamera *>(cppSelf)->minZoomLevel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPosition(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setCameraPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPosition_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPosition_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setCameraPosition", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: Q3DCamera::setCameraPosition(float,float,float)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setCameraPosition(float,float,float)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
            overloadId = 0; // setCameraPosition(float,float,float)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPosition_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_zoom = Shiboken::String::createStaticString("zoom");
            if (PyDict_Contains(kwds, key_zoom)) {
                value = PyDict_GetItem(kwds, key_zoom);
                if (value && pyArgs[2]) {
                    errInfo = key_zoom;
                    Py_INCREF(errInfo);
                    goto Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPosition_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2]))))
                        goto Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPosition_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_zoom);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPosition_TypeError;
            }
        }
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2 = 100.0f;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setCameraPosition(float,float,float)
            cppSelf->setCameraPosition(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPreset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setCameraPreset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DCamera::setCameraPreset(QtDataVisualization::Q3DCamera::CameraPreset)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCameraPreset(QtDataVisualization::Q3DCamera::CameraPreset)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPreset_TypeError;

    // Call function/method
    {
        ::QtDataVisualization::Q3DCamera::CameraPreset cppArg0{QtDataVisualization::Q3DCamera::CameraPresetFrontLow};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCameraPreset(QtDataVisualization::Q3DCamera::CameraPreset)
            cppSelf->setCameraPreset(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPreset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_setMaxZoomLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setMaxZoomLevel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DCamera::setMaxZoomLevel(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setMaxZoomLevel(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DCameraFunc_setMaxZoomLevel_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaxZoomLevel(float)
            cppSelf->setMaxZoomLevel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DCameraFunc_setMaxZoomLevel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_setMinZoomLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setMinZoomLevel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DCamera::setMinZoomLevel(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setMinZoomLevel(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DCameraFunc_setMinZoomLevel_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinZoomLevel(float)
            cppSelf->setMinZoomLevel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DCameraFunc_setMinZoomLevel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_setTarget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DCamera::setTarget(QVector3D)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArg)))) {
        overloadId = 0; // setTarget(QVector3D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DCameraFunc_setTarget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector3D cppArg0_local;
        ::QVector3D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTarget(QVector3D)
            cppSelf->setTarget(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DCameraFunc_setTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_setWrapXRotation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setWrapXRotation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DCamera::setWrapXRotation(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setWrapXRotation(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DCameraFunc_setWrapXRotation_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWrapXRotation(bool)
            cppSelf->setWrapXRotation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DCameraFunc_setWrapXRotation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_setWrapYRotation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setWrapYRotation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DCamera::setWrapYRotation(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setWrapYRotation(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DCameraFunc_setWrapYRotation_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWrapYRotation(bool)
            cppSelf->setWrapYRotation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DCameraFunc_setWrapYRotation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_setXRotation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setXRotation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DCamera::setXRotation(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setXRotation(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DCameraFunc_setXRotation_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setXRotation(float)
            cppSelf->setXRotation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DCameraFunc_setXRotation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_setYRotation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setYRotation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DCamera::setYRotation(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setYRotation(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DCameraFunc_setYRotation_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setYRotation(float)
            cppSelf->setYRotation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DCameraFunc_setYRotation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_setZoomLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setZoomLevel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DCamera::setZoomLevel(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setZoomLevel(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DCameraFunc_setZoomLevel_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setZoomLevel(float)
            cppSelf->setZoomLevel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DCameraFunc_setZoomLevel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_target(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.target";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // target()const
            QVector3D cppResult = const_cast<const ::QtDataVisualization::Q3DCamera *>(cppSelf)->target();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_wrapXRotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.wrapXRotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wrapXRotation()const
            bool cppResult = const_cast<const ::QtDataVisualization::Q3DCamera *>(cppSelf)->wrapXRotation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_wrapYRotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.wrapYRotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wrapYRotation()const
            bool cppResult = const_cast<const ::QtDataVisualization::Q3DCamera *>(cppSelf)->wrapYRotation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_xRotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.xRotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // xRotation()const
            float cppResult = const_cast<const ::QtDataVisualization::Q3DCamera *>(cppSelf)->xRotation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_yRotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.yRotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // yRotation()const
            float cppResult = const_cast<const ::QtDataVisualization::Q3DCamera *>(cppSelf)->yRotation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DCameraFunc_zoomLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.zoomLevel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // zoomLevel()const
            float cppResult = const_cast<const ::QtDataVisualization::Q3DCamera *>(cppSelf)->zoomLevel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtDataVisualization_Q3DCamera_PropertyStrings[] = {
    "cameraPreset::",
    "maxZoomLevel::",
    "minZoomLevel::",
    "target::",
    "wrapXRotation::",
    "wrapYRotation::",
    "xRotation::",
    "yRotation::",
    "zoomLevel::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_Q3DCamera_methods[] = {
    {"cameraPreset", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_cameraPreset), METH_NOARGS},
    {"copyValuesFrom", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_copyValuesFrom), METH_O},
    {"maxZoomLevel", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_maxZoomLevel), METH_NOARGS},
    {"minZoomLevel", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_minZoomLevel), METH_NOARGS},
    {"setCameraPosition", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPosition), METH_VARARGS|METH_KEYWORDS},
    {"setCameraPreset", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_setCameraPreset), METH_O},
    {"setMaxZoomLevel", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_setMaxZoomLevel), METH_O},
    {"setMinZoomLevel", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_setMinZoomLevel), METH_O},
    {"setTarget", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_setTarget), METH_O},
    {"setWrapXRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_setWrapXRotation), METH_O},
    {"setWrapYRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_setWrapYRotation), METH_O},
    {"setXRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_setXRotation), METH_O},
    {"setYRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_setYRotation), METH_O},
    {"setZoomLevel", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_setZoomLevel), METH_O},
    {"target", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_target), METH_NOARGS},
    {"wrapXRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_wrapXRotation), METH_NOARGS},
    {"wrapYRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_wrapYRotation), METH_NOARGS},
    {"xRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_xRotation), METH_NOARGS},
    {"yRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_yRotation), METH_NOARGS},
    {"zoomLevel", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DCameraFunc_zoomLevel), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtDataVisualization_Q3DCamera_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtDataVisualization::Q3DCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<Q3DCameraWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtDataVisualization_Q3DCamera_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_Q3DCamera_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_Q3DCamera_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_Q3DCamera_TypeF(void)
{
    return _Sbk_QtDataVisualization_Q3DCamera_Type;
}

static PyType_Slot Sbk_QtDataVisualization_Q3DCamera_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtDataVisualization_Q3DCamera_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_Q3DCamera_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_Q3DCamera_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_Q3DCamera_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtDataVisualization_Q3DCamera_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_Q3DCamera_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_Q3DCamera_slots
};

} //extern "C"

static void *Sbk_QtDataVisualization_Q3DCamera_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtDataVisualization::Q3DCamera *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QtDataVisualization_Q3DCamera_CameraPreset_PythonToCpp_QtDataVisualization_Q3DCamera_CameraPreset(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::Q3DCamera::CameraPreset *>(cppOut) =
        static_cast<::QtDataVisualization::Q3DCamera::CameraPreset>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_Q3DCamera_CameraPreset_PythonToCpp_QtDataVisualization_Q3DCamera_CameraPreset_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX]))
        return QtDataVisualization_Q3DCamera_CameraPreset_PythonToCpp_QtDataVisualization_Q3DCamera_CameraPreset;
    return {};
}
static PyObject *QtDataVisualization_Q3DCamera_CameraPreset_CppToPython_QtDataVisualization_Q3DCamera_CameraPreset(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::Q3DCamera::CameraPreset *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Q3DCamera_PythonToCpp_Q3DCamera_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtDataVisualization_Q3DCamera_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Q3DCamera_PythonToCpp_Q3DCamera_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_Q3DCamera_TypeF())))
        return Q3DCamera_PythonToCpp_Q3DCamera_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Q3DCamera_PTR_CppToPython_Q3DCamera(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtDataVisualization::Q3DCamera *>(const_cast<void *>(cppIn)), Sbk_QtDataVisualization_Q3DCamera_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_Q3DCamera_SignatureStrings[] = {
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.cameraPreset(self)->PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.CameraPreset",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.copyValuesFrom(self,source:PySide2.QtDataVisualization.QtDataVisualization.Q3DObject)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.maxZoomLevel(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.minZoomLevel(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setCameraPosition(self,horizontal:float,vertical:float,zoom:float=100.0f)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setCameraPreset(self,preset:PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.CameraPreset)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setMaxZoomLevel(self,zoomLevel:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setMinZoomLevel(self,zoomLevel:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setTarget(self,target:PySide2.QtGui.QVector3D)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setWrapXRotation(self,isEnabled:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setWrapYRotation(self,isEnabled:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setXRotation(self,rotation:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setYRotation(self,rotation:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.setZoomLevel(self,zoomLevel:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.target(self)->PySide2.QtGui.QVector3D",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.wrapXRotation(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.wrapYRotation(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.xRotation(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.yRotation(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.zoomLevel(self)->float",
    nullptr}; // Sentinel

void init_QtDataVisualization_Q3DCamera(PyObject *enclosingClass)
{
    _Sbk_QtDataVisualization_Q3DCamera_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Q3DCamera",
        "QtDataVisualization::Q3DCamera*",
        &Sbk_QtDataVisualization_Q3DCamera_spec,
        &Shiboken::callCppDestructor< ::QtDataVisualization::Q3DCamera >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_Q3DCamera_Type);
    InitSignatureStrings(pyType, QtDataVisualization_Q3DCamera_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_Q3DCamera_Type), Sbk_QtDataVisualization_Q3DCamera_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_Q3DCamera_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtDataVisualization_Q3DCamera_TypeF(),
        Q3DCamera_PythonToCpp_Q3DCamera_PTR,
        is_Q3DCamera_PythonToCpp_Q3DCamera_PTR_Convertible,
        Q3DCamera_PTR_CppToPython_Q3DCamera);

    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::Q3DCamera");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::Q3DCamera*");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::Q3DCamera&");
    Shiboken::Conversions::registerConverterName(converter, "Q3DCamera");
    Shiboken::Conversions::registerConverterName(converter, "Q3DCamera*");
    Shiboken::Conversions::registerConverterName(converter, "Q3DCamera&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtDataVisualization::Q3DCamera).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::Q3DCameraWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtDataVisualization_Q3DCamera_TypeF(), &Sbk_QtDataVisualization_Q3DCamera_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'CameraPreset'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_Q3DCamera_TypeF(),
        "CameraPreset",
        "2:PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.CameraPreset",
        "QtDataVisualization::Q3DCamera::CameraPreset");
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetNone", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetFrontLow", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetFrontLow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetFront", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetFront))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetFrontHigh", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetFrontHigh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetLeftLow", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetLeftLow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetLeft", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetLeftHigh", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetLeftHigh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetRightLow", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetRightLow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetRight", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetRightHigh", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetRightHigh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetBehindLow", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetBehindLow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetBehind", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetBehind))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetBehindHigh", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetBehindHigh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetIsometricLeft", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetIsometricLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetIsometricLeftHigh", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetIsometricLeftHigh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetIsometricRight", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetIsometricRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetIsometricRightHigh", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetIsometricRightHigh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetDirectlyAbove", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetDirectlyAbove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetDirectlyAboveCW45", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetDirectlyAboveCW45))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetDirectlyAboveCCW45", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetDirectlyAboveCCW45))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetFrontBelow", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetFrontBelow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetLeftBelow", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetLeftBelow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetRightBelow", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetRightBelow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetBehindBelow", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetBehindBelow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
        Sbk_QtDataVisualization_Q3DCamera_TypeF(), "CameraPresetDirectlyBelow", (long) QtDataVisualization::Q3DCamera::CameraPreset::CameraPresetDirectlyBelow))
        return;
    // Register converter for enum 'QtDataVisualization::Q3DCamera::CameraPreset'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX],
            QtDataVisualization_Q3DCamera_CameraPreset_CppToPython_QtDataVisualization_Q3DCamera_CameraPreset);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_Q3DCamera_CameraPreset_PythonToCpp_QtDataVisualization_Q3DCamera_CameraPreset,
            is_QtDataVisualization_Q3DCamera_CameraPreset_PythonToCpp_QtDataVisualization_Q3DCamera_CameraPreset_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DCAMERA_CAMERAPRESET_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::Q3DCamera::CameraPreset");
        Shiboken::Conversions::registerConverterName(converter, "Q3DCamera::CameraPreset");
        Shiboken::Conversions::registerConverterName(converter, "CameraPreset");
    }
    // End of 'CameraPreset' enum.

    PySide::Signal::registerSignals(Sbk_QtDataVisualization_Q3DCamera_TypeF(), &::QtDataVisualization::Q3DCamera::staticMetaObject);
    qRegisterMetaType< ::QtDataVisualization::Q3DCamera::CameraPreset >("Q3DCamera::CameraPreset");
    qRegisterMetaType< ::QtDataVisualization::Q3DCamera::CameraPreset >("QtDataVisualization::Q3DCamera::CameraPreset");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtDataVisualization_Q3DCamera_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtDataVisualization_Q3DCamera_TypeF(), &::QtDataVisualization::Q3DCamera::staticMetaObject, sizeof(Q3DCameraWrapper));
}
