/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_q3dtheme_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtDataVisualization;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void Q3DThemeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

Q3DThemeWrapper::Q3DThemeWrapper(::QObject * parent) : QtDataVisualization::Q3DTheme(parent)
{
    resetPyMethodCache();
    // ... middle
}

Q3DThemeWrapper::Q3DThemeWrapper(::QtDataVisualization::Q3DTheme::Theme themeType, ::QObject * parent) : QtDataVisualization::Q3DTheme(themeType, parent)
{
    resetPyMethodCache();
    // ... middle
}

void Q3DThemeWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void Q3DThemeWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void Q3DThemeWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void Q3DThemeWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool Q3DThemeWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "Q3DTheme.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool Q3DThemeWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "Q3DTheme.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void Q3DThemeWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *Q3DThemeWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtDataVisualization::Q3DTheme::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int Q3DThemeWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtDataVisualization::Q3DTheme::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *Q3DThemeWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< Q3DThemeWrapper *>(this));
        return QtDataVisualization::Q3DTheme::qt_metacast(_clname);
}

Q3DThemeWrapper::~Q3DThemeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtDataVisualization_Q3DTheme_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtDataVisualization::Q3DTheme >()))
        return -1;

    ::Q3DThemeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:Q3DTheme", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: Q3DTheme::Q3DTheme(QObject*)
    // 1: Q3DTheme::Q3DTheme(QtDataVisualization::Q3DTheme::Theme,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // Q3DTheme(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // Q3DTheme(QtDataVisualization::Q3DTheme::Theme,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // Q3DTheme(QtDataVisualization::Q3DTheme::Theme,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // Q3DTheme(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DTheme_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // Q3DTheme(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_Q3DTheme_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QtDataVisualization_Q3DTheme_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // Q3DTheme(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::Q3DThemeWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::Q3DThemeWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // Q3DTheme(QtDataVisualization::Q3DTheme::Theme themeType, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_Q3DTheme_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QtDataVisualization_Q3DTheme_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QtDataVisualization::Q3DTheme::Theme cppArg0{QtDataVisualization::Q3DTheme::ThemeQt};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // Q3DTheme(QtDataVisualization::Q3DTheme::Theme,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::Q3DThemeWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::Q3DThemeWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtDataVisualization::Q3DTheme >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtDataVisualization_Q3DTheme_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QtDataVisualization_Q3DTheme_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QtDataVisualization_Q3DTheme_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_ambientLightStrength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ambientLightStrength";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ambientLightStrength()const
            float cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->ambientLightStrength();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_backgroundColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.backgroundColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // backgroundColor()const
            QColor cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->backgroundColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_baseColors(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.baseColors";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // baseColors()const
            QList<QColor > cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->baseColors();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QCOLOR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_baseGradients(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.baseGradients";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // baseGradients()const
            QList<QLinearGradient > cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->baseGradients();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QLINEARGRADIENT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_colorStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.colorStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorStyle()const
            QtDataVisualization::Q3DTheme::ColorStyle cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->colorStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_font(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.font";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // font()const
            QFont cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->font();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_gridLineColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.gridLineColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // gridLineColor()const
            QColor cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->gridLineColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_highlightLightStrength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.highlightLightStrength";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // highlightLightStrength()const
            float cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->highlightLightStrength();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_isBackgroundEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.isBackgroundEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBackgroundEnabled()const
            bool cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->isBackgroundEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_isGridEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.isGridEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isGridEnabled()const
            bool cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->isGridEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_isLabelBackgroundEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.isLabelBackgroundEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLabelBackgroundEnabled()const
            bool cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->isLabelBackgroundEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_isLabelBorderEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.isLabelBorderEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLabelBorderEnabled()const
            bool cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->isLabelBorderEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_labelBackgroundColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.labelBackgroundColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelBackgroundColor()const
            QColor cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->labelBackgroundColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_labelTextColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.labelTextColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelTextColor()const
            QColor cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->labelTextColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_lightColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.lightColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lightColor()const
            QColor cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->lightColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_lightStrength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.lightStrength";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lightStrength()const
            float cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->lightStrength();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_multiHighlightColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.multiHighlightColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // multiHighlightColor()const
            QColor cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->multiHighlightColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_multiHighlightGradient(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.multiHighlightGradient";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // multiHighlightGradient()const
            QLinearGradient cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->multiHighlightGradient();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setAmbientLightStrength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setAmbientLightStrength";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setAmbientLightStrength(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setAmbientLightStrength(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setAmbientLightStrength_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAmbientLightStrength(float)
            cppSelf->setAmbientLightStrength(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setAmbientLightStrength_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setBackgroundColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setBackgroundColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setBackgroundColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setBackgroundColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setBackgroundColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBackgroundColor(QColor)
            cppSelf->setBackgroundColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setBackgroundColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setBackgroundEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setBackgroundEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setBackgroundEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setBackgroundEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setBackgroundEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBackgroundEnabled(bool)
            cppSelf->setBackgroundEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setBackgroundEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setBaseColors(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setBaseColors";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setBaseColors(QList<QColor>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QCOLOR_IDX], (pyArg)))) {
        overloadId = 0; // setBaseColors(QList<QColor>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setBaseColors_TypeError;

    // Call function/method
    {
        ::QList<QColor > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBaseColors(QList<QColor>)
            cppSelf->setBaseColors(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setBaseColors_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setBaseGradients(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setBaseGradients";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setBaseGradients(QList<QLinearGradient>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QLINEARGRADIENT_IDX], (pyArg)))) {
        overloadId = 0; // setBaseGradients(QList<QLinearGradient>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setBaseGradients_TypeError;

    // Call function/method
    {
        ::QList<QLinearGradient > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBaseGradients(QList<QLinearGradient>)
            cppSelf->setBaseGradients(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setBaseGradients_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setColorStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setColorStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setColorStyle(QtDataVisualization::Q3DTheme::ColorStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setColorStyle(QtDataVisualization::Q3DTheme::ColorStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setColorStyle_TypeError;

    // Call function/method
    {
        ::QtDataVisualization::Q3DTheme::ColorStyle cppArg0{QtDataVisualization::Q3DTheme::ColorStyleUniform};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColorStyle(QtDataVisualization::Q3DTheme::ColorStyle)
            cppSelf->setColorStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setColorStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
        overloadId = 0; // setFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setFont_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFont(QFont)
            cppSelf->setFont(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setGridEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setGridEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setGridEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setGridEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setGridEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGridEnabled(bool)
            cppSelf->setGridEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setGridEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setGridLineColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setGridLineColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setGridLineColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setGridLineColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setGridLineColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setGridLineColor(QColor)
            cppSelf->setGridLineColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setGridLineColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setHighlightLightStrength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setHighlightLightStrength";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setHighlightLightStrength(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setHighlightLightStrength(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setHighlightLightStrength_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHighlightLightStrength(float)
            cppSelf->setHighlightLightStrength(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setHighlightLightStrength_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setLabelBackgroundColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setLabelBackgroundColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setLabelBackgroundColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setLabelBackgroundColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setLabelBackgroundColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLabelBackgroundColor(QColor)
            cppSelf->setLabelBackgroundColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setLabelBackgroundColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setLabelBackgroundEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setLabelBackgroundEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setLabelBackgroundEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setLabelBackgroundEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setLabelBackgroundEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelBackgroundEnabled(bool)
            cppSelf->setLabelBackgroundEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setLabelBackgroundEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setLabelBorderEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setLabelBorderEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setLabelBorderEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setLabelBorderEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setLabelBorderEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelBorderEnabled(bool)
            cppSelf->setLabelBorderEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setLabelBorderEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setLabelTextColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setLabelTextColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setLabelTextColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setLabelTextColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setLabelTextColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLabelTextColor(QColor)
            cppSelf->setLabelTextColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setLabelTextColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setLightColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setLightColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setLightColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setLightColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setLightColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLightColor(QColor)
            cppSelf->setLightColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setLightColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setLightStrength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setLightStrength";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setLightStrength(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setLightStrength(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setLightStrength_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLightStrength(float)
            cppSelf->setLightStrength(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setLightStrength_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setMultiHighlightColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setMultiHighlightColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setMultiHighlightColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setMultiHighlightColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setMultiHighlightColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMultiHighlightColor(QColor)
            cppSelf->setMultiHighlightColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setMultiHighlightColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setMultiHighlightGradient(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setMultiHighlightGradient";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setMultiHighlightGradient(QLinearGradient)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), (pyArg)))) {
        overloadId = 0; // setMultiHighlightGradient(QLinearGradient)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setMultiHighlightGradient_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLinearGradient cppArg0_local;
        ::QLinearGradient *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMultiHighlightGradient(QLinearGradient)
            cppSelf->setMultiHighlightGradient(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setMultiHighlightGradient_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setSingleHighlightColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setSingleHighlightColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setSingleHighlightColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setSingleHighlightColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setSingleHighlightColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSingleHighlightColor(QColor)
            cppSelf->setSingleHighlightColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setSingleHighlightColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setSingleHighlightGradient(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setSingleHighlightGradient";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setSingleHighlightGradient(QLinearGradient)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), (pyArg)))) {
        overloadId = 0; // setSingleHighlightGradient(QLinearGradient)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setSingleHighlightGradient_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLinearGradient cppArg0_local;
        ::QLinearGradient *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSingleHighlightGradient(QLinearGradient)
            cppSelf->setSingleHighlightGradient(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setSingleHighlightGradient_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setType(QtDataVisualization::Q3DTheme::Theme)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setType(QtDataVisualization::Q3DTheme::Theme)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setType_TypeError;

    // Call function/method
    {
        ::QtDataVisualization::Q3DTheme::Theme cppArg0{QtDataVisualization::Q3DTheme::ThemeQt};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setType(QtDataVisualization::Q3DTheme::Theme)
            cppSelf->setType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_setWindowColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setWindowColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Q3DTheme::setWindowColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setWindowColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_Q3DThemeFunc_setWindowColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setWindowColor(QColor)
            cppSelf->setWindowColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_Q3DThemeFunc_setWindowColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_singleHighlightColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.singleHighlightColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // singleHighlightColor()const
            QColor cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->singleHighlightColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_singleHighlightGradient(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.singleHighlightGradient";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // singleHighlightGradient()const
            QLinearGradient cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->singleHighlightGradient();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QtDataVisualization::Q3DTheme::Theme cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_Q3DThemeFunc_windowColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.windowColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // windowColor()const
            QColor cppResult = const_cast<const ::QtDataVisualization::Q3DTheme *>(cppSelf)->windowColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtDataVisualization_Q3DTheme_PropertyStrings[] = {
    "ambientLightStrength::",
    "backgroundColor::",
    "backgroundEnabled:isBackgroundEnabled:",
    "baseColors::",
    "baseGradients::",
    "colorStyle::",
    "font::",
    "gridEnabled:isGridEnabled:",
    "gridLineColor::",
    "highlightLightStrength::",
    "labelBackgroundColor::",
    "labelBackgroundEnabled:isLabelBackgroundEnabled:",
    "labelBorderEnabled:isLabelBorderEnabled:",
    "labelTextColor::",
    "lightColor::",
    "lightStrength::",
    "multiHighlightColor::",
    "multiHighlightGradient::",
    "singleHighlightColor::",
    "singleHighlightGradient::",
    "type::",
    "windowColor::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_Q3DTheme_methods[] = {
    {"ambientLightStrength", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_ambientLightStrength), METH_NOARGS},
    {"backgroundColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_backgroundColor), METH_NOARGS},
    {"baseColors", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_baseColors), METH_NOARGS},
    {"baseGradients", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_baseGradients), METH_NOARGS},
    {"colorStyle", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_colorStyle), METH_NOARGS},
    {"font", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_font), METH_NOARGS},
    {"gridLineColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_gridLineColor), METH_NOARGS},
    {"highlightLightStrength", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_highlightLightStrength), METH_NOARGS},
    {"isBackgroundEnabled", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_isBackgroundEnabled), METH_NOARGS},
    {"isGridEnabled", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_isGridEnabled), METH_NOARGS},
    {"isLabelBackgroundEnabled", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_isLabelBackgroundEnabled), METH_NOARGS},
    {"isLabelBorderEnabled", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_isLabelBorderEnabled), METH_NOARGS},
    {"labelBackgroundColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_labelBackgroundColor), METH_NOARGS},
    {"labelTextColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_labelTextColor), METH_NOARGS},
    {"lightColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_lightColor), METH_NOARGS},
    {"lightStrength", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_lightStrength), METH_NOARGS},
    {"multiHighlightColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_multiHighlightColor), METH_NOARGS},
    {"multiHighlightGradient", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_multiHighlightGradient), METH_NOARGS},
    {"setAmbientLightStrength", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setAmbientLightStrength), METH_O},
    {"setBackgroundColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setBackgroundColor), METH_O},
    {"setBackgroundEnabled", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setBackgroundEnabled), METH_O},
    {"setBaseColors", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setBaseColors), METH_O},
    {"setBaseGradients", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setBaseGradients), METH_O},
    {"setColorStyle", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setColorStyle), METH_O},
    {"setFont", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setFont), METH_O},
    {"setGridEnabled", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setGridEnabled), METH_O},
    {"setGridLineColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setGridLineColor), METH_O},
    {"setHighlightLightStrength", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setHighlightLightStrength), METH_O},
    {"setLabelBackgroundColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setLabelBackgroundColor), METH_O},
    {"setLabelBackgroundEnabled", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setLabelBackgroundEnabled), METH_O},
    {"setLabelBorderEnabled", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setLabelBorderEnabled), METH_O},
    {"setLabelTextColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setLabelTextColor), METH_O},
    {"setLightColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setLightColor), METH_O},
    {"setLightStrength", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setLightStrength), METH_O},
    {"setMultiHighlightColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setMultiHighlightColor), METH_O},
    {"setMultiHighlightGradient", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setMultiHighlightGradient), METH_O},
    {"setSingleHighlightColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setSingleHighlightColor), METH_O},
    {"setSingleHighlightGradient", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setSingleHighlightGradient), METH_O},
    {"setType", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setType), METH_O},
    {"setWindowColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_setWindowColor), METH_O},
    {"singleHighlightColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_singleHighlightColor), METH_NOARGS},
    {"singleHighlightGradient", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_singleHighlightGradient), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_type), METH_NOARGS},
    {"windowColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_Q3DThemeFunc_windowColor), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtDataVisualization_Q3DTheme_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtDataVisualization::Q3DTheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<Q3DThemeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtDataVisualization_Q3DTheme_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_Q3DTheme_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_Q3DTheme_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_Q3DTheme_TypeF(void)
{
    return _Sbk_QtDataVisualization_Q3DTheme_Type;
}

static PyType_Slot Sbk_QtDataVisualization_Q3DTheme_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtDataVisualization_Q3DTheme_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_Q3DTheme_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_Q3DTheme_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_Q3DTheme_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtDataVisualization_Q3DTheme_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_Q3DTheme_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_Q3DTheme_slots
};

} //extern "C"

static void *Sbk_QtDataVisualization_Q3DTheme_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtDataVisualization::Q3DTheme *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QtDataVisualization_Q3DTheme_ColorStyle_PythonToCpp_QtDataVisualization_Q3DTheme_ColorStyle(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::Q3DTheme::ColorStyle *>(cppOut) =
        static_cast<::QtDataVisualization::Q3DTheme::ColorStyle>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_Q3DTheme_ColorStyle_PythonToCpp_QtDataVisualization_Q3DTheme_ColorStyle_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX]))
        return QtDataVisualization_Q3DTheme_ColorStyle_PythonToCpp_QtDataVisualization_Q3DTheme_ColorStyle;
    return {};
}
static PyObject *QtDataVisualization_Q3DTheme_ColorStyle_CppToPython_QtDataVisualization_Q3DTheme_ColorStyle(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::Q3DTheme::ColorStyle *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX], castCppIn);

}

static void QtDataVisualization_Q3DTheme_Theme_PythonToCpp_QtDataVisualization_Q3DTheme_Theme(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::Q3DTheme::Theme *>(cppOut) =
        static_cast<::QtDataVisualization::Q3DTheme::Theme>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_Q3DTheme_Theme_PythonToCpp_QtDataVisualization_Q3DTheme_Theme_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX]))
        return QtDataVisualization_Q3DTheme_Theme_PythonToCpp_QtDataVisualization_Q3DTheme_Theme;
    return {};
}
static PyObject *QtDataVisualization_Q3DTheme_Theme_CppToPython_QtDataVisualization_Q3DTheme_Theme(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::Q3DTheme::Theme *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Q3DTheme_PythonToCpp_Q3DTheme_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtDataVisualization_Q3DTheme_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Q3DTheme_PythonToCpp_Q3DTheme_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_Q3DTheme_TypeF())))
        return Q3DTheme_PythonToCpp_Q3DTheme_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Q3DTheme_PTR_CppToPython_Q3DTheme(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtDataVisualization::Q3DTheme *>(const_cast<void *>(cppIn)), Sbk_QtDataVisualization_Q3DTheme_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_Q3DTheme_SignatureStrings[] = {
    "1:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme(self,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme(self,themeType:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.Theme,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ambientLightStrength(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.backgroundColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.baseColors(self)->QList[PySide2.QtGui.QColor]",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.baseGradients(self)->QList[PySide2.QtGui.QLinearGradient]",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.colorStyle(self)->PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.font(self)->PySide2.QtGui.QFont",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.gridLineColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.highlightLightStrength(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.isBackgroundEnabled(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.isGridEnabled(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.isLabelBackgroundEnabled(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.isLabelBorderEnabled(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.labelBackgroundColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.labelTextColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.lightColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.lightStrength(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.multiHighlightColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.multiHighlightGradient(self)->PySide2.QtGui.QLinearGradient",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setAmbientLightStrength(self,strength:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setBackgroundColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setBackgroundEnabled(self,enabled:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setBaseColors(self,colors:QList[PySide2.QtGui.QColor])",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setBaseGradients(self,gradients:QList[PySide2.QtGui.QLinearGradient])",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setColorStyle(self,style:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setFont(self,font:PySide2.QtGui.QFont)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setGridEnabled(self,enabled:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setGridLineColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setHighlightLightStrength(self,strength:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setLabelBackgroundColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setLabelBackgroundEnabled(self,enabled:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setLabelBorderEnabled(self,enabled:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setLabelTextColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setLightColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setLightStrength(self,strength:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setMultiHighlightColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setMultiHighlightGradient(self,gradient:PySide2.QtGui.QLinearGradient)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setSingleHighlightColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setSingleHighlightGradient(self,gradient:PySide2.QtGui.QLinearGradient)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setType(self,themeType:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.Theme)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.setWindowColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.singleHighlightColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.singleHighlightGradient(self)->PySide2.QtGui.QLinearGradient",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.type(self)->PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.Theme",
    "PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.windowColor(self)->PySide2.QtGui.QColor",
    nullptr}; // Sentinel

void init_QtDataVisualization_Q3DTheme(PyObject *enclosingClass)
{
    _Sbk_QtDataVisualization_Q3DTheme_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Q3DTheme",
        "QtDataVisualization::Q3DTheme*",
        &Sbk_QtDataVisualization_Q3DTheme_spec,
        &Shiboken::callCppDestructor< ::QtDataVisualization::Q3DTheme >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_Q3DTheme_Type);
    InitSignatureStrings(pyType, QtDataVisualization_Q3DTheme_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_Q3DTheme_Type), Sbk_QtDataVisualization_Q3DTheme_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_Q3DTheme_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtDataVisualization_Q3DTheme_TypeF(),
        Q3DTheme_PythonToCpp_Q3DTheme_PTR,
        is_Q3DTheme_PythonToCpp_Q3DTheme_PTR_Convertible,
        Q3DTheme_PTR_CppToPython_Q3DTheme);

    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::Q3DTheme");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::Q3DTheme*");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::Q3DTheme&");
    Shiboken::Conversions::registerConverterName(converter, "Q3DTheme");
    Shiboken::Conversions::registerConverterName(converter, "Q3DTheme*");
    Shiboken::Conversions::registerConverterName(converter, "Q3DTheme&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtDataVisualization::Q3DTheme).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::Q3DThemeWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtDataVisualization_Q3DTheme_TypeF(), &Sbk_QtDataVisualization_Q3DTheme_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ColorStyle'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_Q3DTheme_TypeF(),
        "ColorStyle",
        "2:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle",
        "QtDataVisualization::Q3DTheme::ColorStyle");
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX],
        Sbk_QtDataVisualization_Q3DTheme_TypeF(), "ColorStyleUniform", (long) QtDataVisualization::Q3DTheme::ColorStyle::ColorStyleUniform))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX],
        Sbk_QtDataVisualization_Q3DTheme_TypeF(), "ColorStyleObjectGradient", (long) QtDataVisualization::Q3DTheme::ColorStyle::ColorStyleObjectGradient))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX],
        Sbk_QtDataVisualization_Q3DTheme_TypeF(), "ColorStyleRangeGradient", (long) QtDataVisualization::Q3DTheme::ColorStyle::ColorStyleRangeGradient))
        return;
    // Register converter for enum 'QtDataVisualization::Q3DTheme::ColorStyle'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX],
            QtDataVisualization_Q3DTheme_ColorStyle_CppToPython_QtDataVisualization_Q3DTheme_ColorStyle);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_Q3DTheme_ColorStyle_PythonToCpp_QtDataVisualization_Q3DTheme_ColorStyle,
            is_QtDataVisualization_Q3DTheme_ColorStyle_PythonToCpp_QtDataVisualization_Q3DTheme_ColorStyle_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::Q3DTheme::ColorStyle");
        Shiboken::Conversions::registerConverterName(converter, "Q3DTheme::ColorStyle");
        Shiboken::Conversions::registerConverterName(converter, "ColorStyle");
    }
    // End of 'ColorStyle' enum.

    // Initialization of enum 'Theme'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_Q3DTheme_TypeF(),
        "Theme",
        "2:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.Theme",
        "QtDataVisualization::Q3DTheme::Theme");
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX],
        Sbk_QtDataVisualization_Q3DTheme_TypeF(), "ThemeQt", (long) QtDataVisualization::Q3DTheme::Theme::ThemeQt))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX],
        Sbk_QtDataVisualization_Q3DTheme_TypeF(), "ThemePrimaryColors", (long) QtDataVisualization::Q3DTheme::Theme::ThemePrimaryColors))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX],
        Sbk_QtDataVisualization_Q3DTheme_TypeF(), "ThemeDigia", (long) QtDataVisualization::Q3DTheme::Theme::ThemeDigia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX],
        Sbk_QtDataVisualization_Q3DTheme_TypeF(), "ThemeStoneMoss", (long) QtDataVisualization::Q3DTheme::Theme::ThemeStoneMoss))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX],
        Sbk_QtDataVisualization_Q3DTheme_TypeF(), "ThemeArmyBlue", (long) QtDataVisualization::Q3DTheme::Theme::ThemeArmyBlue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX],
        Sbk_QtDataVisualization_Q3DTheme_TypeF(), "ThemeRetro", (long) QtDataVisualization::Q3DTheme::Theme::ThemeRetro))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX],
        Sbk_QtDataVisualization_Q3DTheme_TypeF(), "ThemeEbony", (long) QtDataVisualization::Q3DTheme::Theme::ThemeEbony))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX],
        Sbk_QtDataVisualization_Q3DTheme_TypeF(), "ThemeIsabelle", (long) QtDataVisualization::Q3DTheme::Theme::ThemeIsabelle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX],
        Sbk_QtDataVisualization_Q3DTheme_TypeF(), "ThemeUserDefined", (long) QtDataVisualization::Q3DTheme::Theme::ThemeUserDefined))
        return;
    // Register converter for enum 'QtDataVisualization::Q3DTheme::Theme'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX],
            QtDataVisualization_Q3DTheme_Theme_CppToPython_QtDataVisualization_Q3DTheme_Theme);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_Q3DTheme_Theme_PythonToCpp_QtDataVisualization_Q3DTheme_Theme,
            is_QtDataVisualization_Q3DTheme_Theme_PythonToCpp_QtDataVisualization_Q3DTheme_Theme_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_THEME_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::Q3DTheme::Theme");
        Shiboken::Conversions::registerConverterName(converter, "Q3DTheme::Theme");
        Shiboken::Conversions::registerConverterName(converter, "Theme");
    }
    // End of 'Theme' enum.

    PySide::Signal::registerSignals(Sbk_QtDataVisualization_Q3DTheme_TypeF(), &::QtDataVisualization::Q3DTheme::staticMetaObject);
    qRegisterMetaType< ::QtDataVisualization::Q3DTheme::ColorStyle >("Q3DTheme::ColorStyle");
    qRegisterMetaType< ::QtDataVisualization::Q3DTheme::ColorStyle >("QtDataVisualization::Q3DTheme::ColorStyle");
    qRegisterMetaType< ::QtDataVisualization::Q3DTheme::Theme >("Q3DTheme::Theme");
    qRegisterMetaType< ::QtDataVisualization::Q3DTheme::Theme >("QtDataVisualization::Q3DTheme::Theme");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtDataVisualization_Q3DTheme_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtDataVisualization_Q3DTheme_TypeF(), &::QtDataVisualization::Q3DTheme::staticMetaObject, sizeof(Q3DThemeWrapper));
}
