/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_qabstract3dgraph_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtDataVisualization;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstract3DGraphWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

::QAccessibleInterface * QAbstract3DGraphWrapper::accessibleRoot() const
{
    if (m_PyMethodCache[0])
        return this->::QWindow::accessibleRoot();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "accessibleRoot";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QWindow::accessibleRoot();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstract3DGraph.accessibleRoot", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QAccessibleInterface >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QAccessibleInterface *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstract3DGraphWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstract3DGraphWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DGraphWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstract3DGraphWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstract3DGraphWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QtDataVisualization::QAbstract3DGraph::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QtDataVisualization::QAbstract3DGraph::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstract3DGraph.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstract3DGraphWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstract3DGraph.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstract3DGraphWrapper::exposeEvent(::QExposeEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QtDataVisualization::QAbstract3DGraph::exposeEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "exposeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QtDataVisualization::QAbstract3DGraph::exposeEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QEXPOSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DGraphWrapper::focusInEvent(::QFocusEvent * arg__1)
{
    if (m_PyMethodCache[8]) {
        return this->::QWindow::focusInEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusInEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QWindow::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QObject * QAbstract3DGraphWrapper::focusObject() const
{
    if (m_PyMethodCache[9])
        return this->::QWindow::focusObject();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusObject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QWindow::focusObject();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstract3DGraph.focusObject", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QObject >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QObject *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstract3DGraphWrapper::focusOutEvent(::QFocusEvent * arg__1)
{
    if (m_PyMethodCache[10]) {
        return this->::QWindow::focusOutEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusOutEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QWindow::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSurfaceFormat QAbstract3DGraphWrapper::format() const
{
    if (m_PyMethodCache[11])
        return this->::QWindow::format();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "format";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QWindow::format();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstract3DGraph.format", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSurfaceFormat >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSurfaceFormat cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstract3DGraphWrapper::hideEvent(::QHideEvent * arg__1)
{
    if (m_PyMethodCache[12]) {
        return this->::QWindow::hideEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hideEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QWindow::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHIDEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DGraphWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    if (m_PyMethodCache[13]) {
        return this->::QWindow::keyPressEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyPressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QWindow::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DGraphWrapper::keyReleaseEvent(::QKeyEvent * arg__1)
{
    if (m_PyMethodCache[14]) {
        return this->::QWindow::keyReleaseEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QWindow::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DGraphWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[16]) {
        return this->::QtDataVisualization::QAbstract3DGraph::mouseDoubleClickEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseDoubleClickEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QtDataVisualization::QAbstract3DGraph::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DGraphWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[17]) {
        return this->::QtDataVisualization::QAbstract3DGraph::mouseMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QtDataVisualization::QAbstract3DGraph::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DGraphWrapper::mousePressEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[18]) {
        return this->::QtDataVisualization::QAbstract3DGraph::mousePressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mousePressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QtDataVisualization::QAbstract3DGraph::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DGraphWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[19]) {
        return this->::QtDataVisualization::QAbstract3DGraph::mouseReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QtDataVisualization::QAbstract3DGraph::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DGraphWrapper::moveEvent(::QMoveEvent * arg__1)
{
    if (m_PyMethodCache[20]) {
        return this->::QWindow::moveEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "moveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QWindow::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOVEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstract3DGraphWrapper::nativeEvent(const ::QByteArray & eventType, void * message, long * result)
{
    if (m_PyMethodCache[21]) {
        return this->::QWindow::nativeEvent(eventType, message, result);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nativeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QWindow::nativeEvent(eventType, message, result);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &eventType),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), message)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Begin code injection
    // TEMPLATE - return_native_eventfilter_conversion - START
    bool cppResult = false;
    if (PySequence_Check(pyResult) && (PySequence_Size(pyResult) == 2)) {
        Shiboken::AutoDecRef pyItem(PySequence_GetItem(pyResult, 0));
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyItem, &(cppResult));
        if (result) {
            Shiboken::AutoDecRef pyResultItem(PySequence_GetItem(pyResult, 1));
            Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<long>(), pyResultItem, (result));
        }
    }
    // TEMPLATE - return_native_eventfilter_conversion - END

    // End of code injection


    return cppResult;
}

void QAbstract3DGraphWrapper::resizeEvent(::QResizeEvent * event)
{
    if (m_PyMethodCache[22]) {
        return this->::QtDataVisualization::QAbstract3DGraph::resizeEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "resizeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QtDataVisualization::QAbstract3DGraph::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRESIZEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstract3DGraphWrapper::shadowsSupported() const
{
    if (m_PyMethodCache[23])
        return this->::QtDataVisualization::QAbstract3DGraph::shadowsSupported();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "shadowsSupported";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QtDataVisualization::QAbstract3DGraph::shadowsSupported();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstract3DGraph.shadowsSupported", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstract3DGraphWrapper::showEvent(::QShowEvent * arg__1)
{
    if (m_PyMethodCache[24]) {
        return this->::QWindow::showEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "showEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QWindow::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSHOWEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSize QAbstract3DGraphWrapper::size() const
{
    if (m_PyMethodCache[25])
        return this->::QWindow::size();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "size";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QWindow::size();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstract3DGraph.size", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSurface::SurfaceType QAbstract3DGraphWrapper::surfaceType() const
{
    if (m_PyMethodCache[26])
        return this->::QWindow::surfaceType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QSurface::RasterSurface;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "surfaceType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QWindow::surfaceType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QSurface::RasterSurface;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstract3DGraph.surfaceType", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSurface::SurfaceType >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QSurface::RasterSurface;
    }
    ::QSurface::SurfaceType cppResult{QSurface::RasterSurface};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstract3DGraphWrapper::tabletEvent(::QTabletEvent * arg__1)
{
    if (m_PyMethodCache[27]) {
        return this->::QWindow::tabletEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "tabletEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QWindow::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DGraphWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[28]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstract3DGraphWrapper::touchEvent(::QTouchEvent * event)
{
    if (m_PyMethodCache[29]) {
        return this->::QtDataVisualization::QAbstract3DGraph::touchEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "touchEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QtDataVisualization::QAbstract3DGraph::touchEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DGraphWrapper::wheelEvent(::QWheelEvent * event)
{
    if (m_PyMethodCache[30]) {
        return this->::QtDataVisualization::QAbstract3DGraph::wheelEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "wheelEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[30] = true;
        return this->::QtDataVisualization::QAbstract3DGraph::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

const QMetaObject *QAbstract3DGraphWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtDataVisualization::QAbstract3DGraph::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstract3DGraphWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtDataVisualization::QAbstract3DGraph::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstract3DGraphWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstract3DGraphWrapper *>(this));
        return QtDataVisualization::QAbstract3DGraph::qt_metacast(_clname);
}

QAbstract3DGraphWrapper::~QAbstract3DGraphWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_activeInputHandler(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.activeInputHandler";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeInputHandler()const
            QtDataVisualization::QAbstract3DInputHandler * cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->activeInputHandler();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DINPUTHANDLER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_activeTheme(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.activeTheme";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeTheme()const
            QtDataVisualization::Q3DTheme * cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->activeTheme();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_addCustomItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.addCustomItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::addCustomItem(QtDataVisualization::QCustom3DItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DITEM_IDX]), (pyArg)))) {
        overloadId = 0; // addCustomItem(QtDataVisualization::QCustom3DItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_addCustomItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtDataVisualization::QCustom3DItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addCustomItem(QtDataVisualization::QCustom3DItem*)
            int cppResult = cppSelf->addCustomItem(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_addCustomItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_addInputHandler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.addInputHandler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::addInputHandler(QtDataVisualization::QAbstract3DInputHandler*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DINPUTHANDLER_IDX]), (pyArg)))) {
        overloadId = 0; // addInputHandler(QtDataVisualization::QAbstract3DInputHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_addInputHandler_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtDataVisualization::QAbstract3DInputHandler *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addInputHandler(QtDataVisualization::QAbstract3DInputHandler*)
            cppSelf->addInputHandler(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_addInputHandler_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_addTheme(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.addTheme";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::addTheme(QtDataVisualization::Q3DTheme*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX]), (pyArg)))) {
        overloadId = 0; // addTheme(QtDataVisualization::Q3DTheme*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_addTheme_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtDataVisualization::Q3DTheme *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addTheme(QtDataVisualization::Q3DTheme*)
            cppSelf->addTheme(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_addTheme_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_aspectRatio(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.aspectRatio";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // aspectRatio()const
            qreal cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->aspectRatio();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_clearSelection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.clearSelection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearSelection()
            cppSelf->clearSelection();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_currentFps(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.currentFps";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentFps()const
            qreal cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->currentFps();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_customItems(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.customItems";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // customItems()const
            QList<QtDataVisualization::QCustom3DItem* > cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->customItems();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QCUSTOM3DITEMPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QtDataVisualization::QAbstract3DGraph::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_exposeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.exposeEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::exposeEvent(QExposeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QEXPOSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // exposeEvent(QExposeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_exposeEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QExposeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // exposeEvent(QExposeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QtDataVisualization::QAbstract3DGraph::exposeEvent(cppArg0)
                : cppSelf->exposeEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_exposeEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_hasContext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.hasContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasContext()const
            bool cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->hasContext();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_horizontalAspectRatio(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.horizontalAspectRatio";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // horizontalAspectRatio()const
            qreal cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->horizontalAspectRatio();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_inputHandlers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.inputHandlers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // inputHandlers()const
            QList<QtDataVisualization::QAbstract3DInputHandler* > cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->inputHandlers();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QABSTRACT3DINPUTHANDLERPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_isOrthoProjection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.isOrthoProjection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isOrthoProjection()const
            bool cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->isOrthoProjection();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_isPolar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.isPolar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPolar()const
            bool cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->isPolar();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_isReflection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.isReflection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReflection()const
            bool cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->isReflection();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_locale(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.locale";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // locale()const
            QLocale cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->locale();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_margin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.margin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // margin()const
            qreal cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->margin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_measureFps(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.measureFps";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // measureFps()const
            bool cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->measureFps();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_mouseDoubleClickEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.mouseDoubleClickEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::mouseDoubleClickEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseDoubleClickEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_mouseDoubleClickEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseDoubleClickEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QtDataVisualization::QAbstract3DGraph::mouseDoubleClickEvent(cppArg0)
                : cppSelf->mouseDoubleClickEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_mouseDoubleClickEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_mouseMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.mouseMoveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::mouseMoveEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseMoveEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_mouseMoveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseMoveEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QtDataVisualization::QAbstract3DGraph::mouseMoveEvent(cppArg0)
                : cppSelf->mouseMoveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_mouseMoveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.mousePressEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::mousePressEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_mousePressEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mousePressEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QtDataVisualization::QAbstract3DGraph::mousePressEvent(cppArg0)
                : cppSelf->mousePressEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_mousePressEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_mouseReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.mouseReleaseEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::mouseReleaseEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseReleaseEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_mouseReleaseEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseReleaseEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QtDataVisualization::QAbstract3DGraph::mouseReleaseEvent(cppArg0)
                : cppSelf->mouseReleaseEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_mouseReleaseEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_optimizationHints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.optimizationHints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // optimizationHints()const
            QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint> cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->optimizationHints();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_queriedGraphPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.queriedGraphPosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // queriedGraphPosition()const
            QVector3D cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->queriedGraphPosition();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_radialLabelOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.radialLabelOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // radialLabelOffset()const
            float cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->radialLabelOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_reflectivity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.reflectivity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reflectivity()const
            qreal cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->reflectivity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_releaseCustomItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.releaseCustomItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::releaseCustomItem(QtDataVisualization::QCustom3DItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DITEM_IDX]), (pyArg)))) {
        overloadId = 0; // releaseCustomItem(QtDataVisualization::QCustom3DItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_releaseCustomItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtDataVisualization::QCustom3DItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // releaseCustomItem(QtDataVisualization::QCustom3DItem*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtdatavisualization.cpp (releaseownership)]
            Shiboken::Object::releaseOwnership(pyArg);
            // END of custom code block [file: ../glue/qtdatavisualization.cpp (releaseownership)]
            // ========================================================================

            // End of code injection

            cppSelf->releaseCustomItem(cppArg0);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "releaseCustomItem(QtDataVisualization::QCustom3DItem*)1", pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_releaseCustomItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_releaseInputHandler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.releaseInputHandler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::releaseInputHandler(QtDataVisualization::QAbstract3DInputHandler*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DINPUTHANDLER_IDX]), (pyArg)))) {
        overloadId = 0; // releaseInputHandler(QtDataVisualization::QAbstract3DInputHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_releaseInputHandler_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtDataVisualization::QAbstract3DInputHandler *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // releaseInputHandler(QtDataVisualization::QAbstract3DInputHandler*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtdatavisualization.cpp (releaseownership)]
            Shiboken::Object::releaseOwnership(pyArg);
            // END of custom code block [file: ../glue/qtdatavisualization.cpp (releaseownership)]
            // ========================================================================

            // End of code injection

            cppSelf->releaseInputHandler(cppArg0);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "releaseInputHandler(QtDataVisualization::QAbstract3DInputHandler*)1", pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_releaseInputHandler_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_releaseTheme(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.releaseTheme";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::releaseTheme(QtDataVisualization::Q3DTheme*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX]), (pyArg)))) {
        overloadId = 0; // releaseTheme(QtDataVisualization::Q3DTheme*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_releaseTheme_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtDataVisualization::Q3DTheme *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // releaseTheme(QtDataVisualization::Q3DTheme*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtdatavisualization.cpp (releaseownership)]
            Shiboken::Object::releaseOwnership(pyArg);
            // END of custom code block [file: ../glue/qtdatavisualization.cpp (releaseownership)]
            // ========================================================================

            // End of code injection

            cppSelf->releaseTheme(cppArg0);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "releaseTheme(QtDataVisualization::Q3DTheme*)1", pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_releaseTheme_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_removeCustomItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.removeCustomItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::removeCustomItem(QtDataVisualization::QCustom3DItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DITEM_IDX]), (pyArg)))) {
        overloadId = 0; // removeCustomItem(QtDataVisualization::QCustom3DItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_removeCustomItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtDataVisualization::QCustom3DItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeCustomItem(QtDataVisualization::QCustom3DItem*)
            cppSelf->removeCustomItem(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_removeCustomItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_removeCustomItemAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.removeCustomItemAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::removeCustomItemAt(QVector3D)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArg)))) {
        overloadId = 0; // removeCustomItemAt(QVector3D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_removeCustomItemAt_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector3D cppArg0_local;
        ::QVector3D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // removeCustomItemAt(QVector3D)
            cppSelf->removeCustomItemAt(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_removeCustomItemAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_removeCustomItems(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.removeCustomItems";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeCustomItems()
            cppSelf->removeCustomItems();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_renderToImage(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.renderToImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_renderToImage_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:renderToImage", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstract3DGraph::renderToImage(int,QSize)
    if (numArgs == 0) {
        overloadId = 0; // renderToImage(int,QSize)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // renderToImage(int,QSize)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
            overloadId = 0; // renderToImage(int,QSize)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_renderToImage_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msaaSamples = Shiboken::String::createStaticString("msaaSamples");
            if (PyDict_Contains(kwds, key_msaaSamples)) {
                value = PyDict_GetItem(kwds, key_msaaSamples);
                if (value && pyArgs[0]) {
                    errInfo = key_msaaSamples;
                    Py_INCREF(errInfo);
                    goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_renderToImage_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_renderToImage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msaaSamples);
            }
            static PyObject *const key_imageSize = Shiboken::String::createStaticString("imageSize");
            if (PyDict_Contains(kwds, key_imageSize)) {
                value = PyDict_GetItem(kwds, key_imageSize);
                if (value && pyArgs[1]) {
                    errInfo = key_imageSize;
                    Py_INCREF(errInfo);
                    goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_renderToImage_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1]))))
                        goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_renderToImage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_imageSize);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_renderToImage_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSize cppArg1_local = QSize();
        ::QSize *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // renderToImage(int,QSize)
            QImage cppResult = cppSelf->renderToImage(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_renderToImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.resizeEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRESIZEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_resizeEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QtDataVisualization::QAbstract3DGraph::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_resizeEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_scene(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.scene";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scene()const
            QtDataVisualization::Q3DScene * cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->scene();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DSCENE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_selectedAxis(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.selectedAxis";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedAxis()const
            QtDataVisualization::QAbstract3DAxis * cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->selectedAxis();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_selectedCustomItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.selectedCustomItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedCustomItem()const
            QtDataVisualization::QCustom3DItem * cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->selectedCustomItem();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_selectedCustomItemIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.selectedCustomItemIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedCustomItemIndex()const
            int cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->selectedCustomItemIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_selectedElement(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.selectedElement";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedElement()const
            QtDataVisualization::QAbstract3DGraph::ElementType cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->selectedElement();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_selectedLabelIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.selectedLabelIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedLabelIndex()const
            int cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->selectedLabelIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_selectionMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.selectionMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectionMode()const
            QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag> cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->selectionMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setActiveInputHandler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setActiveInputHandler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setActiveInputHandler(QtDataVisualization::QAbstract3DInputHandler*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DINPUTHANDLER_IDX]), (pyArg)))) {
        overloadId = 0; // setActiveInputHandler(QtDataVisualization::QAbstract3DInputHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setActiveInputHandler_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtDataVisualization::QAbstract3DInputHandler *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setActiveInputHandler(QtDataVisualization::QAbstract3DInputHandler*)
            cppSelf->setActiveInputHandler(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setActiveInputHandler_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setActiveTheme(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setActiveTheme";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setActiveTheme(QtDataVisualization::Q3DTheme*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX]), (pyArg)))) {
        overloadId = 0; // setActiveTheme(QtDataVisualization::Q3DTheme*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setActiveTheme_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtDataVisualization::Q3DTheme *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setActiveTheme(QtDataVisualization::Q3DTheme*)
            cppSelf->setActiveTheme(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setActiveTheme_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setAspectRatio(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setAspectRatio";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setAspectRatio(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setAspectRatio(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setAspectRatio_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAspectRatio(qreal)
            cppSelf->setAspectRatio(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setAspectRatio_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setHorizontalAspectRatio(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setHorizontalAspectRatio";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setHorizontalAspectRatio(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setHorizontalAspectRatio(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setHorizontalAspectRatio_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHorizontalAspectRatio(qreal)
            cppSelf->setHorizontalAspectRatio(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setHorizontalAspectRatio_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setLocale(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setLocale";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setLocale(QLocale)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArg)))) {
        overloadId = 0; // setLocale(QLocale)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setLocale_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLocale(QLocale)
            cppSelf->setLocale(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setLocale_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMargin(qreal)
            cppSelf->setMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setMeasureFps(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setMeasureFps";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setMeasureFps(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMeasureFps(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setMeasureFps_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMeasureFps(bool)
            cppSelf->setMeasureFps(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setMeasureFps_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setOptimizationHints(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setOptimizationHints";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setOptimizationHints(QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setOptimizationHints(QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setOptimizationHints_TypeError;

    // Call function/method
    {
        ::QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint> cppArg0 = QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOptimizationHints(QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint>)
            cppSelf->setOptimizationHints(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setOptimizationHints_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setOrthoProjection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setOrthoProjection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setOrthoProjection(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setOrthoProjection(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setOrthoProjection_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOrthoProjection(bool)
            cppSelf->setOrthoProjection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setOrthoProjection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setPolar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setPolar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setPolar(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPolar(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setPolar_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPolar(bool)
            cppSelf->setPolar(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setPolar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setRadialLabelOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setRadialLabelOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setRadialLabelOffset(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setRadialLabelOffset(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setRadialLabelOffset_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRadialLabelOffset(float)
            cppSelf->setRadialLabelOffset(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setRadialLabelOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setReflection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setReflection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setReflection(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setReflection(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setReflection_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setReflection(bool)
            cppSelf->setReflection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setReflection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setReflectivity(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setReflectivity";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setReflectivity(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setReflectivity(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setReflectivity_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setReflectivity(qreal)
            cppSelf->setReflectivity(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setReflectivity_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setSelectionMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setSelectionMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setSelectionMode(QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSelectionMode(QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setSelectionMode_TypeError;

    // Call function/method
    {
        ::QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag> cppArg0 = QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSelectionMode(QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag>)
            cppSelf->setSelectionMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setSelectionMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_setShadowQuality(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setShadowQuality";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DGraph::setShadowQuality(QtDataVisualization::QAbstract3DGraph::ShadowQuality)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setShadowQuality(QtDataVisualization::QAbstract3DGraph::ShadowQuality)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_setShadowQuality_TypeError;

    // Call function/method
    {
        ::QtDataVisualization::QAbstract3DGraph::ShadowQuality cppArg0{QtDataVisualization::QAbstract3DGraph::ShadowQualityNone};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setShadowQuality(QtDataVisualization::QAbstract3DGraph::ShadowQuality)
            cppSelf->setShadowQuality(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_setShadowQuality_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_shadowQuality(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.shadowQuality";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shadowQuality()const
            QtDataVisualization::QAbstract3DGraph::ShadowQuality cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->shadowQuality();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_shadowsSupported(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.shadowsSupported";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shadowsSupported()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->::QtDataVisualization::QAbstract3DGraph::shadowsSupported()
                : const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->shadowsSupported();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_themes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.themes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // themes()const
            QList<QtDataVisualization::Q3DTheme* > cppResult = const_cast<const ::QtDataVisualization::QAbstract3DGraph *>(cppSelf)->themes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_Q3DTHEMEPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_touchEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.touchEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::touchEvent(QTouchEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // touchEvent(QTouchEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_touchEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTouchEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // touchEvent(QTouchEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QtDataVisualization::QAbstract3DGraph::touchEvent(cppArg0)
                : cppSelf->touchEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_touchEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DGraphFunc_wheelEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.wheelEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::wheelEvent(QWheelEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // wheelEvent(QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DGraphFunc_wheelEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWheelEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // wheelEvent(QWheelEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QtDataVisualization::QAbstract3DGraph::wheelEvent(cppArg0)
                : cppSelf->wheelEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DGraphFunc_wheelEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QtDataVisualization_QAbstract3DGraph_PropertyStrings[] = {
    "activeInputHandler::",
    "activeTheme::",
    "aspectRatio::",
    "currentFps:",
    "horizontalAspectRatio::",
    "locale::",
    "margin::",
    "measureFps::",
    "optimizationHints::",
    "orthoProjection:isOrthoProjection:",
    "polar:isPolar:",
    "queriedGraphPosition:",
    "radialLabelOffset::",
    "reflection:isReflection:",
    "reflectivity::",
    "scene:",
    "selectedElement:",
    "selectionMode::",
    "shadowQuality::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_QAbstract3DGraph_methods[] = {
    {"activeInputHandler", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_activeInputHandler), METH_NOARGS},
    {"activeTheme", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_activeTheme), METH_NOARGS},
    {"addCustomItem", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_addCustomItem), METH_O},
    {"addInputHandler", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_addInputHandler), METH_O},
    {"addTheme", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_addTheme), METH_O},
    {"aspectRatio", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_aspectRatio), METH_NOARGS},
    {"clearSelection", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_clearSelection), METH_NOARGS},
    {"currentFps", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_currentFps), METH_NOARGS},
    {"customItems", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_customItems), METH_NOARGS},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_event), METH_O},
    {"exposeEvent", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_exposeEvent), METH_O},
    {"hasContext", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_hasContext), METH_NOARGS},
    {"horizontalAspectRatio", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_horizontalAspectRatio), METH_NOARGS},
    {"inputHandlers", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_inputHandlers), METH_NOARGS},
    {"isOrthoProjection", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_isOrthoProjection), METH_NOARGS},
    {"isPolar", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_isPolar), METH_NOARGS},
    {"isReflection", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_isReflection), METH_NOARGS},
    {"locale", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_locale), METH_NOARGS},
    {"margin", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_margin), METH_NOARGS},
    {"measureFps", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_measureFps), METH_NOARGS},
    {"mouseDoubleClickEvent", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_mouseDoubleClickEvent), METH_O},
    {"mouseMoveEvent", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_mouseMoveEvent), METH_O},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_mousePressEvent), METH_O},
    {"mouseReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_mouseReleaseEvent), METH_O},
    {"optimizationHints", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_optimizationHints), METH_NOARGS},
    {"queriedGraphPosition", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_queriedGraphPosition), METH_NOARGS},
    {"radialLabelOffset", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_radialLabelOffset), METH_NOARGS},
    {"reflectivity", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_reflectivity), METH_NOARGS},
    {"releaseCustomItem", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_releaseCustomItem), METH_O},
    {"releaseInputHandler", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_releaseInputHandler), METH_O},
    {"releaseTheme", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_releaseTheme), METH_O},
    {"removeCustomItem", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_removeCustomItem), METH_O},
    {"removeCustomItemAt", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_removeCustomItemAt), METH_O},
    {"removeCustomItems", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_removeCustomItems), METH_NOARGS},
    {"renderToImage", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_renderToImage), METH_VARARGS|METH_KEYWORDS},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_resizeEvent), METH_O},
    {"scene", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_scene), METH_NOARGS},
    {"selectedAxis", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_selectedAxis), METH_NOARGS},
    {"selectedCustomItem", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_selectedCustomItem), METH_NOARGS},
    {"selectedCustomItemIndex", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_selectedCustomItemIndex), METH_NOARGS},
    {"selectedElement", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_selectedElement), METH_NOARGS},
    {"selectedLabelIndex", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_selectedLabelIndex), METH_NOARGS},
    {"selectionMode", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_selectionMode), METH_NOARGS},
    {"setActiveInputHandler", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setActiveInputHandler), METH_O},
    {"setActiveTheme", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setActiveTheme), METH_O},
    {"setAspectRatio", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setAspectRatio), METH_O},
    {"setHorizontalAspectRatio", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setHorizontalAspectRatio), METH_O},
    {"setLocale", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setLocale), METH_O},
    {"setMargin", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setMargin), METH_O},
    {"setMeasureFps", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setMeasureFps), METH_O},
    {"setOptimizationHints", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setOptimizationHints), METH_O},
    {"setOrthoProjection", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setOrthoProjection), METH_O},
    {"setPolar", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setPolar), METH_O},
    {"setRadialLabelOffset", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setRadialLabelOffset), METH_O},
    {"setReflection", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setReflection), METH_O},
    {"setReflectivity", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setReflectivity), METH_O},
    {"setSelectionMode", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setSelectionMode), METH_O},
    {"setShadowQuality", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_setShadowQuality), METH_O},
    {"shadowQuality", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_shadowQuality), METH_NOARGS},
    {"shadowsSupported", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_shadowsSupported), METH_NOARGS},
    {"themes", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_themes), METH_NOARGS},
    {"touchEvent", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_touchEvent), METH_O},
    {"wheelEvent", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DGraphFunc_wheelEvent), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtDataVisualization_QAbstract3DGraph_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstract3DGraphWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtDataVisualization_QAbstract3DGraph_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_QAbstract3DGraph_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static void * Sbk_QtDataVisualization_QAbstract3DGraphSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QtDataVisualization::QAbstract3DGraph *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]))
        return static_cast< ::QWindow *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX]))
        return static_cast< ::QSurface *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_QAbstract3DGraph_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(void)
{
    return _Sbk_QtDataVisualization_QAbstract3DGraph_Type;
}

static PyType_Slot Sbk_QtDataVisualization_QAbstract3DGraph_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QAbstract3DGraph_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QAbstract3DGraph_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_QAbstract3DGraph_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_QAbstract3DGraph_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_QAbstract3DGraph_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_QAbstract3DGraph_slots
};

} //extern "C"

static void *Sbk_QtDataVisualization_QAbstract3DGraph_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtDataVisualization::QAbstract3DGraph *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QSurface >()))
        return dynamic_cast< ::QtDataVisualization::QAbstract3DGraph *>(reinterpret_cast< ::QSurface *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QtDataVisualization::QAbstract3DGraph::SelectionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QtDataVisualization::QAbstract3DGraph::SelectionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QtDataVisualization::QAbstract3DGraph::SelectionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QtDataVisualization::QAbstract3DGraph::SelectionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QtDataVisualization::QAbstract3DGraph::SelectionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QtDataVisualization::QAbstract3DGraph::SelectionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QtDataVisualization::QAbstract3DGraph::SelectionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QtDataVisualization::QAbstract3DGraph::SelectionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QtDataVisualization::QAbstract3DGraph::SelectionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QtDataVisualization::QAbstract3DGraph::SelectionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QtDataVisualization::QAbstract3DGraph::SelectionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QtDataVisualization::QAbstract3DGraph::SelectionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QtDataVisualization::QAbstract3DGraph::SelectionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QtDataVisualization::QAbstract3DGraph::SelectionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QtDataVisualization::QAbstract3DGraph::SelectionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QtDataVisualization::QAbstract3DGraph::SelectionFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX])->converter, self, &cppSelf);
    ::QtDataVisualization::QAbstract3DGraph::SelectionFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint___and__(PyObject *self, PyObject *pyArg)
{
    ::QtDataVisualization::QAbstract3DGraph::OptimizationHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QtDataVisualization::QAbstract3DGraph::OptimizationHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QtDataVisualization::QAbstract3DGraph::OptimizationHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QtDataVisualization::QAbstract3DGraph::OptimizationHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QtDataVisualization::QAbstract3DGraph::OptimizationHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint___or__(PyObject *self, PyObject *pyArg)
{
    ::QtDataVisualization::QAbstract3DGraph::OptimizationHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QtDataVisualization::QAbstract3DGraph::OptimizationHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QtDataVisualization::QAbstract3DGraph::OptimizationHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QtDataVisualization::QAbstract3DGraph::OptimizationHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QtDataVisualization::QAbstract3DGraph::OptimizationHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint___xor__(PyObject *self, PyObject *pyArg)
{
    ::QtDataVisualization::QAbstract3DGraph::OptimizationHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QtDataVisualization::QAbstract3DGraph::OptimizationHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QtDataVisualization::QAbstract3DGraph::OptimizationHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QtDataVisualization::QAbstract3DGraph::OptimizationHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QtDataVisualization::QAbstract3DGraph::OptimizationHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint___invert__(PyObject *self, PyObject *pyArg)
{
    ::QtDataVisualization::QAbstract3DGraph::OptimizationHints cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX])->converter, self, &cppSelf);
    ::QtDataVisualization::QAbstract3DGraph::OptimizationHints cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QtDataVisualization_QAbstract3DGraph_SelectionFlag_PythonToCpp_QtDataVisualization_QAbstract3DGraph_SelectionFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QAbstract3DGraph::SelectionFlag *>(cppOut) =
        static_cast<::QtDataVisualization::QAbstract3DGraph::SelectionFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_QAbstract3DGraph_SelectionFlag_PythonToCpp_QtDataVisualization_QAbstract3DGraph_SelectionFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX]))
        return QtDataVisualization_QAbstract3DGraph_SelectionFlag_PythonToCpp_QtDataVisualization_QAbstract3DGraph_SelectionFlag;
    return {};
}
static PyObject *QtDataVisualization_QAbstract3DGraph_SelectionFlag_CppToPython_QtDataVisualization_QAbstract3DGraph_SelectionFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::QAbstract3DGraph::SelectionFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX], castCppIn);

}

static void QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag> *>(cppOut) =
        ::QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX]))
        return QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag_;
    return {};
}
static PyObject *QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__CppToPython_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX]));

}

static void QtDataVisualization_QAbstract3DGraph_SelectionFlag_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag> *>(cppOut) =
        ::QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QtDataVisualization_QAbstract3DGraph_SelectionFlag_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX]))
        return QtDataVisualization_QAbstract3DGraph_SelectionFlag_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag> *>(cppOut) =
        ::QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX]))
        return number_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag_;
    return {};
}
static void QtDataVisualization_QAbstract3DGraph_ShadowQuality_PythonToCpp_QtDataVisualization_QAbstract3DGraph_ShadowQuality(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QAbstract3DGraph::ShadowQuality *>(cppOut) =
        static_cast<::QtDataVisualization::QAbstract3DGraph::ShadowQuality>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_QAbstract3DGraph_ShadowQuality_PythonToCpp_QtDataVisualization_QAbstract3DGraph_ShadowQuality_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX]))
        return QtDataVisualization_QAbstract3DGraph_ShadowQuality_PythonToCpp_QtDataVisualization_QAbstract3DGraph_ShadowQuality;
    return {};
}
static PyObject *QtDataVisualization_QAbstract3DGraph_ShadowQuality_CppToPython_QtDataVisualization_QAbstract3DGraph_ShadowQuality(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::QAbstract3DGraph::ShadowQuality *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX], castCppIn);

}

static void QtDataVisualization_QAbstract3DGraph_ElementType_PythonToCpp_QtDataVisualization_QAbstract3DGraph_ElementType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QAbstract3DGraph::ElementType *>(cppOut) =
        static_cast<::QtDataVisualization::QAbstract3DGraph::ElementType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_QAbstract3DGraph_ElementType_PythonToCpp_QtDataVisualization_QAbstract3DGraph_ElementType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX]))
        return QtDataVisualization_QAbstract3DGraph_ElementType_PythonToCpp_QtDataVisualization_QAbstract3DGraph_ElementType;
    return {};
}
static PyObject *QtDataVisualization_QAbstract3DGraph_ElementType_CppToPython_QtDataVisualization_QAbstract3DGraph_ElementType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::QAbstract3DGraph::ElementType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX], castCppIn);

}

static void QtDataVisualization_QAbstract3DGraph_OptimizationHint_PythonToCpp_QtDataVisualization_QAbstract3DGraph_OptimizationHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QAbstract3DGraph::OptimizationHint *>(cppOut) =
        static_cast<::QtDataVisualization::QAbstract3DGraph::OptimizationHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_QAbstract3DGraph_OptimizationHint_PythonToCpp_QtDataVisualization_QAbstract3DGraph_OptimizationHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX]))
        return QtDataVisualization_QAbstract3DGraph_OptimizationHint_PythonToCpp_QtDataVisualization_QAbstract3DGraph_OptimizationHint;
    return {};
}
static PyObject *QtDataVisualization_QAbstract3DGraph_OptimizationHint_CppToPython_QtDataVisualization_QAbstract3DGraph_OptimizationHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::QAbstract3DGraph::OptimizationHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX], castCppIn);

}

static void QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint> *>(cppOut) =
        ::QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX]))
        return QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint_;
    return {};
}
static PyObject *QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__CppToPython_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX]));

}

static void QtDataVisualization_QAbstract3DGraph_OptimizationHint_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint> *>(cppOut) =
        ::QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QtDataVisualization_QAbstract3DGraph_OptimizationHint_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX]))
        return QtDataVisualization_QAbstract3DGraph_OptimizationHint_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint_;
    return {};
}
static void number_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint> *>(cppOut) =
        ::QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX]))
        return number_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstract3DGraph_PythonToCpp_QAbstract3DGraph_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstract3DGraph_PythonToCpp_QAbstract3DGraph_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF())))
        return QAbstract3DGraph_PythonToCpp_QAbstract3DGraph_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstract3DGraph_PTR_CppToPython_QAbstract3DGraph(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtDataVisualization::QAbstract3DGraph *>(const_cast<void *>(cppIn)), Sbk_QtDataVisualization_QAbstract3DGraph_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_QAbstract3DGraph_SignatureStrings[] = {
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.activeInputHandler(self)->PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.activeTheme(self)->PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.addCustomItem(self,item:PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.addInputHandler(self,inputHandler:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.addTheme(self,theme:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.aspectRatio(self)->qreal",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.clearSelection(self)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.currentFps(self)->qreal",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.customItems(self)->QList[PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem]",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.event(self,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.exposeEvent(self,event:PySide2.QtGui.QExposeEvent)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.hasContext(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.horizontalAspectRatio(self)->qreal",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.inputHandlers(self)->QList[PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler]",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.isOrthoProjection(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.isPolar(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.isReflection(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.locale(self)->PySide2.QtCore.QLocale",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.margin(self)->qreal",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.measureFps(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.mouseDoubleClickEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.mouseMoveEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.mousePressEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.mouseReleaseEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.optimizationHints(self)->PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.OptimizationHints",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.queriedGraphPosition(self)->PySide2.QtGui.QVector3D",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.radialLabelOffset(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.reflectivity(self)->qreal",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.releaseCustomItem(self,item:PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.releaseInputHandler(self,inputHandler:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.releaseTheme(self,theme:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.removeCustomItem(self,item:PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.removeCustomItemAt(self,position:PySide2.QtGui.QVector3D)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.removeCustomItems(self)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.renderToImage(self,msaaSamples:int=0,imageSize:PySide2.QtCore.QSize=QSize())->PySide2.QtGui.QImage",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.resizeEvent(self,event:PySide2.QtGui.QResizeEvent)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.scene(self)->PySide2.QtDataVisualization.QtDataVisualization.Q3DScene",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.selectedAxis(self)->PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.selectedCustomItem(self)->PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.selectedCustomItemIndex(self)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.selectedElement(self)->PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.ElementType",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.selectedLabelIndex(self)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.selectionMode(self)->PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.SelectionFlags",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setActiveInputHandler(self,inputHandler:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setActiveTheme(self,theme:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setAspectRatio(self,ratio:qreal)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setHorizontalAspectRatio(self,ratio:qreal)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setLocale(self,locale:PySide2.QtCore.QLocale)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setMargin(self,margin:qreal)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setMeasureFps(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setOptimizationHints(self,hints:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.OptimizationHints)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setOrthoProjection(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setPolar(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setRadialLabelOffset(self,offset:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setReflection(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setReflectivity(self,reflectivity:qreal)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setSelectionMode(self,mode:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.SelectionFlags)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.setShadowQuality(self,quality:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.ShadowQuality)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.shadowQuality(self)->PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.ShadowQuality",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.shadowsSupported(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.themes(self)->QList[PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme]",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.touchEvent(self,event:PySide2.QtGui.QTouchEvent)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.wheelEvent(self,event:PySide2.QtGui.QWheelEvent)",
    nullptr}; // Sentinel

void init_QtDataVisualization_QAbstract3DGraph(PyObject *enclosingClass)
{
    _Sbk_QtDataVisualization_QAbstract3DGraph_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QAbstract3DGraph",
        "QtDataVisualization::QAbstract3DGraph*",
        &Sbk_QtDataVisualization_QAbstract3DGraph_spec,
        &Shiboken::callCppDestructor< ::QtDataVisualization::QAbstract3DGraph >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass | Shiboken::ObjectType::WrapperFlags::DeleteInMainThread    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QAbstract3DGraph_Type);
    InitSignatureStrings(pyType, QtDataVisualization_QAbstract3DGraph_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QAbstract3DGraph_Type), Sbk_QtDataVisualization_QAbstract3DGraph_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(),
        QAbstract3DGraph_PythonToCpp_QAbstract3DGraph_PTR,
        is_QAbstract3DGraph_PythonToCpp_QAbstract3DGraph_PTR_Convertible,
        QAbstract3DGraph_PTR_CppToPython_QAbstract3DGraph);

    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DGraph");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DGraph*");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DGraph&");
    Shiboken::Conversions::registerConverterName(converter, "QAbstract3DGraph");
    Shiboken::Conversions::registerConverterName(converter, "QAbstract3DGraph*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstract3DGraph&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtDataVisualization::QAbstract3DGraph).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstract3DGraphWrapper).name());


    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), &Sbk_QtDataVisualization_QAbstract3DGraphSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), &Sbk_QtDataVisualization_QAbstract3DGraph_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'SelectionFlag'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.SelectionFlags", SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_SelectionFlag_number_slots);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(),
        "SelectionFlag",
        "2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.SelectionFlag",
        "QtDataVisualization::QAbstract3DGraph::SelectionFlag",
        SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX]);
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "SelectionNone", (long) QtDataVisualization::QAbstract3DGraph::SelectionFlag::SelectionNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "SelectionItem", (long) QtDataVisualization::QAbstract3DGraph::SelectionFlag::SelectionItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "SelectionRow", (long) QtDataVisualization::QAbstract3DGraph::SelectionFlag::SelectionRow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "SelectionItemAndRow", (long) QtDataVisualization::QAbstract3DGraph::SelectionFlag::SelectionItemAndRow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "SelectionColumn", (long) QtDataVisualization::QAbstract3DGraph::SelectionFlag::SelectionColumn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "SelectionItemAndColumn", (long) QtDataVisualization::QAbstract3DGraph::SelectionFlag::SelectionItemAndColumn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "SelectionRowAndColumn", (long) QtDataVisualization::QAbstract3DGraph::SelectionFlag::SelectionRowAndColumn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "SelectionItemRowAndColumn", (long) QtDataVisualization::QAbstract3DGraph::SelectionFlag::SelectionItemRowAndColumn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "SelectionSlice", (long) QtDataVisualization::QAbstract3DGraph::SelectionFlag::SelectionSlice))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "SelectionMultiSeries", (long) QtDataVisualization::QAbstract3DGraph::SelectionFlag::SelectionMultiSeries))
        return;
    // Register converter for enum 'QtDataVisualization::QAbstract3DGraph::SelectionFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX],
            QtDataVisualization_QAbstract3DGraph_SelectionFlag_CppToPython_QtDataVisualization_QAbstract3DGraph_SelectionFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_QAbstract3DGraph_SelectionFlag_PythonToCpp_QtDataVisualization_QAbstract3DGraph_SelectionFlag,
            is_QtDataVisualization_QAbstract3DGraph_SelectionFlag_PythonToCpp_QtDataVisualization_QAbstract3DGraph_SelectionFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DGraph::SelectionFlag");
        Shiboken::Conversions::registerConverterName(converter, "QAbstract3DGraph::SelectionFlag");
        Shiboken::Conversions::registerConverterName(converter, "SelectionFlag");
    }
    // Register converter for flag 'QFlags<QtDataVisualization::QAbstract3DGraph::SelectionFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX],
            QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__CppToPython_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_QAbstract3DGraph_SelectionFlag_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag_,
            is_QtDataVisualization_QAbstract3DGraph_SelectionFlag_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag_,
            is_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag_,
            is_number_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_SelectionFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SELECTIONFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DGraph::SelectionFlags");
        Shiboken::Conversions::registerConverterName(converter, "QAbstract3DGraph::SelectionFlags");
        Shiboken::Conversions::registerConverterName(converter, "SelectionFlags");
    }
    // End of 'SelectionFlag' enum/flags.

    // Initialization of enum 'ShadowQuality'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(),
        "ShadowQuality",
        "2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.ShadowQuality",
        "QtDataVisualization::QAbstract3DGraph::ShadowQuality");
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ShadowQualityNone", (long) QtDataVisualization::QAbstract3DGraph::ShadowQuality::ShadowQualityNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ShadowQualityLow", (long) QtDataVisualization::QAbstract3DGraph::ShadowQuality::ShadowQualityLow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ShadowQualityMedium", (long) QtDataVisualization::QAbstract3DGraph::ShadowQuality::ShadowQualityMedium))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ShadowQualityHigh", (long) QtDataVisualization::QAbstract3DGraph::ShadowQuality::ShadowQualityHigh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ShadowQualitySoftLow", (long) QtDataVisualization::QAbstract3DGraph::ShadowQuality::ShadowQualitySoftLow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ShadowQualitySoftMedium", (long) QtDataVisualization::QAbstract3DGraph::ShadowQuality::ShadowQualitySoftMedium))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ShadowQualitySoftHigh", (long) QtDataVisualization::QAbstract3DGraph::ShadowQuality::ShadowQualitySoftHigh))
        return;
    // Register converter for enum 'QtDataVisualization::QAbstract3DGraph::ShadowQuality'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX],
            QtDataVisualization_QAbstract3DGraph_ShadowQuality_CppToPython_QtDataVisualization_QAbstract3DGraph_ShadowQuality);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_QAbstract3DGraph_ShadowQuality_PythonToCpp_QtDataVisualization_QAbstract3DGraph_ShadowQuality,
            is_QtDataVisualization_QAbstract3DGraph_ShadowQuality_PythonToCpp_QtDataVisualization_QAbstract3DGraph_ShadowQuality_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_SHADOWQUALITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DGraph::ShadowQuality");
        Shiboken::Conversions::registerConverterName(converter, "QAbstract3DGraph::ShadowQuality");
        Shiboken::Conversions::registerConverterName(converter, "ShadowQuality");
    }
    // End of 'ShadowQuality' enum.

    // Initialization of enum 'ElementType'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(),
        "ElementType",
        "2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.ElementType",
        "QtDataVisualization::QAbstract3DGraph::ElementType");
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ElementNone", (long) QtDataVisualization::QAbstract3DGraph::ElementType::ElementNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ElementSeries", (long) QtDataVisualization::QAbstract3DGraph::ElementType::ElementSeries))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ElementAxisXLabel", (long) QtDataVisualization::QAbstract3DGraph::ElementType::ElementAxisXLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ElementAxisYLabel", (long) QtDataVisualization::QAbstract3DGraph::ElementType::ElementAxisYLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ElementAxisZLabel", (long) QtDataVisualization::QAbstract3DGraph::ElementType::ElementAxisZLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "ElementCustomItem", (long) QtDataVisualization::QAbstract3DGraph::ElementType::ElementCustomItem))
        return;
    // Register converter for enum 'QtDataVisualization::QAbstract3DGraph::ElementType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX],
            QtDataVisualization_QAbstract3DGraph_ElementType_CppToPython_QtDataVisualization_QAbstract3DGraph_ElementType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_QAbstract3DGraph_ElementType_PythonToCpp_QtDataVisualization_QAbstract3DGraph_ElementType,
            is_QtDataVisualization_QAbstract3DGraph_ElementType_PythonToCpp_QtDataVisualization_QAbstract3DGraph_ElementType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_ELEMENTTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DGraph::ElementType");
        Shiboken::Conversions::registerConverterName(converter, "QAbstract3DGraph::ElementType");
        Shiboken::Conversions::registerConverterName(converter, "ElementType");
    }
    // End of 'ElementType' enum.

    // Initialization of enum 'OptimizationHint'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX] = PySide::QFlags::create("2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.OptimizationHints", SbkPySide2_QtDataVisualization_QtDataVisualization_QAbstract3DGraph_OptimizationHint_number_slots);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(),
        "OptimizationHint",
        "2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.OptimizationHint",
        "QtDataVisualization::QAbstract3DGraph::OptimizationHint",
        SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX]);
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "OptimizationDefault", (long) QtDataVisualization::QAbstract3DGraph::OptimizationHint::OptimizationDefault))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX],
        Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), "OptimizationStatic", (long) QtDataVisualization::QAbstract3DGraph::OptimizationHint::OptimizationStatic))
        return;
    // Register converter for enum 'QtDataVisualization::QAbstract3DGraph::OptimizationHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX],
            QtDataVisualization_QAbstract3DGraph_OptimizationHint_CppToPython_QtDataVisualization_QAbstract3DGraph_OptimizationHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_QAbstract3DGraph_OptimizationHint_PythonToCpp_QtDataVisualization_QAbstract3DGraph_OptimizationHint,
            is_QtDataVisualization_QAbstract3DGraph_OptimizationHint_PythonToCpp_QtDataVisualization_QAbstract3DGraph_OptimizationHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DGraph::OptimizationHint");
        Shiboken::Conversions::registerConverterName(converter, "QAbstract3DGraph::OptimizationHint");
        Shiboken::Conversions::registerConverterName(converter, "OptimizationHint");
    }
    // Register converter for flag 'QFlags<QtDataVisualization::QAbstract3DGraph::OptimizationHint>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX],
            QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__CppToPython_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_QAbstract3DGraph_OptimizationHint_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint_,
            is_QtDataVisualization_QAbstract3DGraph_OptimizationHint_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint_,
            is_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint_,
            is_number_PythonToCpp_QFlags_QtDataVisualization_QAbstract3DGraph_OptimizationHint__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QFLAGS_QTDATAVISUALIZATION_QABSTRACT3DGRAPH_OPTIMIZATIONHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DGraph::OptimizationHints");
        Shiboken::Conversions::registerConverterName(converter, "QAbstract3DGraph::OptimizationHints");
        Shiboken::Conversions::registerConverterName(converter, "OptimizationHints");
    }
    // End of 'OptimizationHint' enum/flags.

    PySide::Signal::registerSignals(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), &::QtDataVisualization::QAbstract3DGraph::staticMetaObject);
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DGraph::SelectionFlag >("QAbstract3DGraph::SelectionFlag");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DGraph::SelectionFlag >("QtDataVisualization::QAbstract3DGraph::SelectionFlag");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DGraph::SelectionFlags >("QtDataVisualization::QAbstract3DGraph::SelectionFlags");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DGraph::ShadowQuality >("QAbstract3DGraph::ShadowQuality");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DGraph::ShadowQuality >("QtDataVisualization::QAbstract3DGraph::ShadowQuality");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DGraph::ElementType >("QAbstract3DGraph::ElementType");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DGraph::ElementType >("QtDataVisualization::QAbstract3DGraph::ElementType");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DGraph::OptimizationHint >("QAbstract3DGraph::OptimizationHint");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DGraph::OptimizationHint >("QtDataVisualization::QAbstract3DGraph::OptimizationHint");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DGraph::OptimizationHints >("QtDataVisualization::QAbstract3DGraph::OptimizationHints");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtDataVisualization_QAbstract3DGraph_TypeF(), &::QtDataVisualization::QAbstract3DGraph::staticMetaObject, sizeof(QAbstract3DGraphWrapper));
}
