/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_qabstract3dseries_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtDataVisualization;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstract3DSeriesWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QAbstract3DSeriesWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstract3DSeriesWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DSeriesWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstract3DSeriesWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstract3DSeriesWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstract3DSeries.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstract3DSeriesWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstract3DSeries.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstract3DSeriesWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QAbstract3DSeriesWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtDataVisualization::QAbstract3DSeries::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstract3DSeriesWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtDataVisualization::QAbstract3DSeries::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstract3DSeriesWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstract3DSeriesWrapper *>(this));
        return QtDataVisualization::QAbstract3DSeries::qt_metacast(_clname);
}

QAbstract3DSeriesWrapper::~QAbstract3DSeriesWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_baseColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.baseColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // baseColor()const
            QColor cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->baseColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_baseGradient(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.baseGradient";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // baseGradient()const
            QLinearGradient cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->baseGradient();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_colorStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.colorStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorStyle()const
            QtDataVisualization::Q3DTheme::ColorStyle cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->colorStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_isItemLabelVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.isItemLabelVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isItemLabelVisible()const
            bool cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->isItemLabelVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_isMeshSmooth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.isMeshSmooth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMeshSmooth()const
            bool cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->isMeshSmooth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_isVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.isVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isVisible()const
            bool cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->isVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_itemLabel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.itemLabel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // itemLabel()const
            QString cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->itemLabel();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_itemLabelFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.itemLabelFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // itemLabelFormat()const
            QString cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->itemLabelFormat();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_mesh(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.mesh";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mesh()const
            QtDataVisualization::QAbstract3DSeries::Mesh cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->mesh();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_meshRotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.meshRotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // meshRotation()const
            QQuaternion cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->meshRotation();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QQUATERNION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_multiHighlightColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.multiHighlightColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // multiHighlightColor()const
            QColor cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->multiHighlightColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_multiHighlightGradient(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.multiHighlightGradient";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // multiHighlightGradient()const
            QLinearGradient cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->multiHighlightGradient();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setBaseColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setBaseColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setBaseColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setBaseColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setBaseColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBaseColor(QColor)
            cppSelf->setBaseColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setBaseColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setBaseGradient(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setBaseGradient";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setBaseGradient(QLinearGradient)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), (pyArg)))) {
        overloadId = 0; // setBaseGradient(QLinearGradient)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setBaseGradient_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLinearGradient cppArg0_local;
        ::QLinearGradient *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBaseGradient(QLinearGradient)
            cppSelf->setBaseGradient(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setBaseGradient_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setColorStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setColorStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setColorStyle(QtDataVisualization::Q3DTheme::ColorStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_COLORSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setColorStyle(QtDataVisualization::Q3DTheme::ColorStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setColorStyle_TypeError;

    // Call function/method
    {
        ::QtDataVisualization::Q3DTheme::ColorStyle cppArg0{QtDataVisualization::Q3DTheme::ColorStyleUniform};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColorStyle(QtDataVisualization::Q3DTheme::ColorStyle)
            cppSelf->setColorStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setColorStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setItemLabelFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setItemLabelFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setItemLabelFormat(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setItemLabelFormat(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setItemLabelFormat_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setItemLabelFormat(QString)
            cppSelf->setItemLabelFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setItemLabelFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setItemLabelVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setItemLabelVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setItemLabelVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setItemLabelVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setItemLabelVisible_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setItemLabelVisible(bool)
            cppSelf->setItemLabelVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setItemLabelVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMesh(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setMesh";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setMesh(QtDataVisualization::QAbstract3DSeries::Mesh)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMesh(QtDataVisualization::QAbstract3DSeries::Mesh)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMesh_TypeError;

    // Call function/method
    {
        ::QtDataVisualization::QAbstract3DSeries::Mesh cppArg0{QtDataVisualization::QAbstract3DSeries::MeshUserDefined};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMesh(QtDataVisualization::QAbstract3DSeries::Mesh)
            cppSelf->setMesh(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMesh_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMeshAxisAndAngle(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setMeshAxisAndAngle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setMeshAxisAndAngle", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstract3DSeries::setMeshAxisAndAngle(QVector3D,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // setMeshAxisAndAngle(QVector3D,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMeshAxisAndAngle_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QVector3D cppArg0_local;
        ::QVector3D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setMeshAxisAndAngle(QVector3D,float)
            cppSelf->setMeshAxisAndAngle(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMeshAxisAndAngle_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMeshRotation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setMeshRotation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setMeshRotation(QQuaternion)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QQUATERNION_IDX]), (pyArg)))) {
        overloadId = 0; // setMeshRotation(QQuaternion)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMeshRotation_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QQuaternion cppArg0_local;
        ::QQuaternion *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QQUATERNION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMeshRotation(QQuaternion)
            cppSelf->setMeshRotation(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMeshRotation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMeshSmooth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setMeshSmooth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setMeshSmooth(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMeshSmooth(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMeshSmooth_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMeshSmooth(bool)
            cppSelf->setMeshSmooth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMeshSmooth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMultiHighlightColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setMultiHighlightColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setMultiHighlightColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setMultiHighlightColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMultiHighlightColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMultiHighlightColor(QColor)
            cppSelf->setMultiHighlightColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMultiHighlightColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMultiHighlightGradient(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setMultiHighlightGradient";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setMultiHighlightGradient(QLinearGradient)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), (pyArg)))) {
        overloadId = 0; // setMultiHighlightGradient(QLinearGradient)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMultiHighlightGradient_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLinearGradient cppArg0_local;
        ::QLinearGradient *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMultiHighlightGradient(QLinearGradient)
            cppSelf->setMultiHighlightGradient(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMultiHighlightGradient_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setName(QString)
            cppSelf->setName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setSingleHighlightColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setSingleHighlightColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setSingleHighlightColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setSingleHighlightColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setSingleHighlightColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSingleHighlightColor(QColor)
            cppSelf->setSingleHighlightColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setSingleHighlightColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setSingleHighlightGradient(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setSingleHighlightGradient";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setSingleHighlightGradient(QLinearGradient)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), (pyArg)))) {
        overloadId = 0; // setSingleHighlightGradient(QLinearGradient)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setSingleHighlightGradient_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLinearGradient cppArg0_local;
        ::QLinearGradient *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSingleHighlightGradient(QLinearGradient)
            cppSelf->setSingleHighlightGradient(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setSingleHighlightGradient_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setUserDefinedMesh(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setUserDefinedMesh";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setUserDefinedMesh(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setUserDefinedMesh(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setUserDefinedMesh_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUserDefinedMesh(QString)
            cppSelf->setUserDefinedMesh(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setUserDefinedMesh_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DSeries::setVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setVisible_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVisible(bool)
            cppSelf->setVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_singleHighlightColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.singleHighlightColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // singleHighlightColor()const
            QColor cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->singleHighlightColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_singleHighlightGradient(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.singleHighlightGradient";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // singleHighlightGradient()const
            QLinearGradient cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->singleHighlightGradient();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QtDataVisualization::QAbstract3DSeries::SeriesType cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_SERIESTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DSeriesFunc_userDefinedMesh(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.userDefinedMesh";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // userDefinedMesh()const
            QString cppResult = const_cast<const ::QtDataVisualization::QAbstract3DSeries *>(cppSelf)->userDefinedMesh();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtDataVisualization_QAbstract3DSeries_PropertyStrings[] = {
    "baseColor::",
    "baseGradient::",
    "colorStyle::",
    "itemLabel:",
    "itemLabelFormat::",
    "itemLabelVisible:isItemLabelVisible:",
    "mesh::",
    "meshRotation::",
    "meshSmooth:isMeshSmooth:",
    "multiHighlightColor::",
    "multiHighlightGradient::",
    "name::",
    "singleHighlightColor::",
    "singleHighlightGradient::",
    "type:",
    "userDefinedMesh::",
    "visible:isVisible:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_QAbstract3DSeries_methods[] = {
    {"baseColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_baseColor), METH_NOARGS},
    {"baseGradient", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_baseGradient), METH_NOARGS},
    {"colorStyle", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_colorStyle), METH_NOARGS},
    {"isItemLabelVisible", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_isItemLabelVisible), METH_NOARGS},
    {"isMeshSmooth", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_isMeshSmooth), METH_NOARGS},
    {"isVisible", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_isVisible), METH_NOARGS},
    {"itemLabel", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_itemLabel), METH_NOARGS},
    {"itemLabelFormat", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_itemLabelFormat), METH_NOARGS},
    {"mesh", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_mesh), METH_NOARGS},
    {"meshRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_meshRotation), METH_NOARGS},
    {"multiHighlightColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_multiHighlightColor), METH_NOARGS},
    {"multiHighlightGradient", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_multiHighlightGradient), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_name), METH_NOARGS},
    {"setBaseColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setBaseColor), METH_O},
    {"setBaseGradient", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setBaseGradient), METH_O},
    {"setColorStyle", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setColorStyle), METH_O},
    {"setItemLabelFormat", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setItemLabelFormat), METH_O},
    {"setItemLabelVisible", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setItemLabelVisible), METH_O},
    {"setMesh", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMesh), METH_O},
    {"setMeshAxisAndAngle", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMeshAxisAndAngle), METH_VARARGS},
    {"setMeshRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMeshRotation), METH_O},
    {"setMeshSmooth", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMeshSmooth), METH_O},
    {"setMultiHighlightColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMultiHighlightColor), METH_O},
    {"setMultiHighlightGradient", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setMultiHighlightGradient), METH_O},
    {"setName", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setName), METH_O},
    {"setSingleHighlightColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setSingleHighlightColor), METH_O},
    {"setSingleHighlightGradient", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setSingleHighlightGradient), METH_O},
    {"setUserDefinedMesh", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setUserDefinedMesh), METH_O},
    {"setVisible", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_setVisible), METH_O},
    {"singleHighlightColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_singleHighlightColor), METH_NOARGS},
    {"singleHighlightGradient", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_singleHighlightGradient), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_type), METH_NOARGS},
    {"userDefinedMesh", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DSeriesFunc_userDefinedMesh), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtDataVisualization_QAbstract3DSeries_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtDataVisualization::QAbstract3DSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstract3DSeriesWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtDataVisualization_QAbstract3DSeries_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_QAbstract3DSeries_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_QAbstract3DSeries_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(void)
{
    return _Sbk_QtDataVisualization_QAbstract3DSeries_Type;
}

static PyType_Slot Sbk_QtDataVisualization_QAbstract3DSeries_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QAbstract3DSeries_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QAbstract3DSeries_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_QAbstract3DSeries_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_QAbstract3DSeries_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_QAbstract3DSeries_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_QAbstract3DSeries_slots
};

} //extern "C"

static void *Sbk_QtDataVisualization_QAbstract3DSeries_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtDataVisualization::QAbstract3DSeries *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QtDataVisualization_QAbstract3DSeries_SeriesType_PythonToCpp_QtDataVisualization_QAbstract3DSeries_SeriesType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QAbstract3DSeries::SeriesType *>(cppOut) =
        static_cast<::QtDataVisualization::QAbstract3DSeries::SeriesType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_QAbstract3DSeries_SeriesType_PythonToCpp_QtDataVisualization_QAbstract3DSeries_SeriesType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_SERIESTYPE_IDX]))
        return QtDataVisualization_QAbstract3DSeries_SeriesType_PythonToCpp_QtDataVisualization_QAbstract3DSeries_SeriesType;
    return {};
}
static PyObject *QtDataVisualization_QAbstract3DSeries_SeriesType_CppToPython_QtDataVisualization_QAbstract3DSeries_SeriesType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::QAbstract3DSeries::SeriesType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_SERIESTYPE_IDX], castCppIn);

}

static void QtDataVisualization_QAbstract3DSeries_Mesh_PythonToCpp_QtDataVisualization_QAbstract3DSeries_Mesh(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QAbstract3DSeries::Mesh *>(cppOut) =
        static_cast<::QtDataVisualization::QAbstract3DSeries::Mesh>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_QAbstract3DSeries_Mesh_PythonToCpp_QtDataVisualization_QAbstract3DSeries_Mesh_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX]))
        return QtDataVisualization_QAbstract3DSeries_Mesh_PythonToCpp_QtDataVisualization_QAbstract3DSeries_Mesh;
    return {};
}
static PyObject *QtDataVisualization_QAbstract3DSeries_Mesh_CppToPython_QtDataVisualization_QAbstract3DSeries_Mesh(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::QAbstract3DSeries::Mesh *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstract3DSeries_PythonToCpp_QAbstract3DSeries_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstract3DSeries_PythonToCpp_QAbstract3DSeries_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QAbstract3DSeries_TypeF())))
        return QAbstract3DSeries_PythonToCpp_QAbstract3DSeries_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstract3DSeries_PTR_CppToPython_QAbstract3DSeries(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtDataVisualization::QAbstract3DSeries *>(const_cast<void *>(cppIn)), Sbk_QtDataVisualization_QAbstract3DSeries_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_QAbstract3DSeries_SignatureStrings[] = {
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.baseColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.baseGradient(self)->PySide2.QtGui.QLinearGradient",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.colorStyle(self)->PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.isItemLabelVisible(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.isMeshSmooth(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.isVisible(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.itemLabel(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.itemLabelFormat(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.mesh(self)->PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.Mesh",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.meshRotation(self)->PySide2.QtGui.QQuaternion",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.multiHighlightColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.multiHighlightGradient(self)->PySide2.QtGui.QLinearGradient",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.name(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setBaseColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setBaseGradient(self,gradient:PySide2.QtGui.QLinearGradient)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setColorStyle(self,style:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setItemLabelFormat(self,format:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setItemLabelVisible(self,visible:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setMesh(self,mesh:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.Mesh)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setMeshAxisAndAngle(self,axis:PySide2.QtGui.QVector3D,angle:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setMeshRotation(self,rotation:PySide2.QtGui.QQuaternion)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setMeshSmooth(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setMultiHighlightColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setMultiHighlightGradient(self,gradient:PySide2.QtGui.QLinearGradient)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setName(self,name:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setSingleHighlightColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setSingleHighlightGradient(self,gradient:PySide2.QtGui.QLinearGradient)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setUserDefinedMesh(self,fileName:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.setVisible(self,visible:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.singleHighlightColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.singleHighlightGradient(self)->PySide2.QtGui.QLinearGradient",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.type(self)->PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.SeriesType",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.userDefinedMesh(self)->QString",
    nullptr}; // Sentinel

void init_QtDataVisualization_QAbstract3DSeries(PyObject *enclosingClass)
{
    _Sbk_QtDataVisualization_QAbstract3DSeries_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QAbstract3DSeries",
        "QtDataVisualization::QAbstract3DSeries*",
        &Sbk_QtDataVisualization_QAbstract3DSeries_spec,
        &Shiboken::callCppDestructor< ::QtDataVisualization::QAbstract3DSeries >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QAbstract3DSeries_Type);
    InitSignatureStrings(pyType, QtDataVisualization_QAbstract3DSeries_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QAbstract3DSeries_Type), Sbk_QtDataVisualization_QAbstract3DSeries_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QAbstract3DSeries_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(),
        QAbstract3DSeries_PythonToCpp_QAbstract3DSeries_PTR,
        is_QAbstract3DSeries_PythonToCpp_QAbstract3DSeries_PTR_Convertible,
        QAbstract3DSeries_PTR_CppToPython_QAbstract3DSeries);

    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DSeries");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DSeries*");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DSeries&");
    Shiboken::Conversions::registerConverterName(converter, "QAbstract3DSeries");
    Shiboken::Conversions::registerConverterName(converter, "QAbstract3DSeries*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstract3DSeries&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtDataVisualization::QAbstract3DSeries).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstract3DSeriesWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), &Sbk_QtDataVisualization_QAbstract3DSeries_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'SeriesType'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_SERIESTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(),
        "SeriesType",
        "2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.SeriesType",
        "QtDataVisualization::QAbstract3DSeries::SeriesType");
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_SERIESTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_SERIESTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "SeriesTypeNone", (long) QtDataVisualization::QAbstract3DSeries::SeriesType::SeriesTypeNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_SERIESTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "SeriesTypeBar", (long) QtDataVisualization::QAbstract3DSeries::SeriesType::SeriesTypeBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_SERIESTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "SeriesTypeScatter", (long) QtDataVisualization::QAbstract3DSeries::SeriesType::SeriesTypeScatter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_SERIESTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "SeriesTypeSurface", (long) QtDataVisualization::QAbstract3DSeries::SeriesType::SeriesTypeSurface))
        return;
    // Register converter for enum 'QtDataVisualization::QAbstract3DSeries::SeriesType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_SERIESTYPE_IDX],
            QtDataVisualization_QAbstract3DSeries_SeriesType_CppToPython_QtDataVisualization_QAbstract3DSeries_SeriesType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_QAbstract3DSeries_SeriesType_PythonToCpp_QtDataVisualization_QAbstract3DSeries_SeriesType,
            is_QtDataVisualization_QAbstract3DSeries_SeriesType_PythonToCpp_QtDataVisualization_QAbstract3DSeries_SeriesType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_SERIESTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DSeries::SeriesType");
        Shiboken::Conversions::registerConverterName(converter, "QAbstract3DSeries::SeriesType");
        Shiboken::Conversions::registerConverterName(converter, "SeriesType");
    }
    // End of 'SeriesType' enum.

    // Initialization of enum 'Mesh'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(),
        "Mesh",
        "2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.Mesh",
        "QtDataVisualization::QAbstract3DSeries::Mesh");
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "MeshUserDefined", (long) QtDataVisualization::QAbstract3DSeries::Mesh::MeshUserDefined))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "MeshBar", (long) QtDataVisualization::QAbstract3DSeries::Mesh::MeshBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "MeshCube", (long) QtDataVisualization::QAbstract3DSeries::Mesh::MeshCube))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "MeshPyramid", (long) QtDataVisualization::QAbstract3DSeries::Mesh::MeshPyramid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "MeshCone", (long) QtDataVisualization::QAbstract3DSeries::Mesh::MeshCone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "MeshCylinder", (long) QtDataVisualization::QAbstract3DSeries::Mesh::MeshCylinder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "MeshBevelBar", (long) QtDataVisualization::QAbstract3DSeries::Mesh::MeshBevelBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "MeshBevelCube", (long) QtDataVisualization::QAbstract3DSeries::Mesh::MeshBevelCube))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "MeshSphere", (long) QtDataVisualization::QAbstract3DSeries::Mesh::MeshSphere))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "MeshMinimal", (long) QtDataVisualization::QAbstract3DSeries::Mesh::MeshMinimal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "MeshArrow", (long) QtDataVisualization::QAbstract3DSeries::Mesh::MeshArrow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
        Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), "MeshPoint", (long) QtDataVisualization::QAbstract3DSeries::Mesh::MeshPoint))
        return;
    // Register converter for enum 'QtDataVisualization::QAbstract3DSeries::Mesh'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX],
            QtDataVisualization_QAbstract3DSeries_Mesh_CppToPython_QtDataVisualization_QAbstract3DSeries_Mesh);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_QAbstract3DSeries_Mesh_PythonToCpp_QtDataVisualization_QAbstract3DSeries_Mesh,
            is_QtDataVisualization_QAbstract3DSeries_Mesh_PythonToCpp_QtDataVisualization_QAbstract3DSeries_Mesh_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DSERIES_MESH_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DSeries::Mesh");
        Shiboken::Conversions::registerConverterName(converter, "QAbstract3DSeries::Mesh");
        Shiboken::Conversions::registerConverterName(converter, "Mesh");
    }
    // End of 'Mesh' enum.

    PySide::Signal::registerSignals(Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), &::QtDataVisualization::QAbstract3DSeries::staticMetaObject);
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DSeries::SeriesType >("QAbstract3DSeries::SeriesType");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DSeries::SeriesType >("QtDataVisualization::QAbstract3DSeries::SeriesType");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DSeries::Mesh >("QAbstract3DSeries::Mesh");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DSeries::Mesh >("QtDataVisualization::QAbstract3DSeries::Mesh");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtDataVisualization_QAbstract3DSeries_TypeF(), &::QtDataVisualization::QAbstract3DSeries::staticMetaObject, sizeof(QAbstract3DSeriesWrapper));
}
