/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_qitemmodelbardataproxy_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtDataVisualization;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QItemModelBarDataProxyWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QItemModelBarDataProxyWrapper::QItemModelBarDataProxyWrapper(::QAbstractItemModel * itemModel, ::QObject * parent) : QtDataVisualization::QItemModelBarDataProxy(itemModel, parent)
{
    resetPyMethodCache();
    // ... middle
}

QItemModelBarDataProxyWrapper::QItemModelBarDataProxyWrapper(::QAbstractItemModel * itemModel, const ::QString & rowRole, const ::QString & columnRole, const ::QString & valueRole, ::QObject * parent) : QtDataVisualization::QItemModelBarDataProxy(itemModel, rowRole, columnRole, valueRole, parent)
{
    resetPyMethodCache();
    // ... middle
}

QItemModelBarDataProxyWrapper::QItemModelBarDataProxyWrapper(::QAbstractItemModel * itemModel, const ::QString & rowRole, const ::QString & columnRole, const ::QString & valueRole, const ::QString & rotationRole, ::QObject * parent) : QtDataVisualization::QItemModelBarDataProxy(itemModel, rowRole, columnRole, valueRole, rotationRole, parent)
{
    resetPyMethodCache();
    // ... middle
}

QItemModelBarDataProxyWrapper::QItemModelBarDataProxyWrapper(::QAbstractItemModel * itemModel, const ::QString & rowRole, const ::QString & columnRole, const ::QString & valueRole, const ::QString & rotationRole, const ::QStringList & rowCategories, const ::QStringList & columnCategories, ::QObject * parent) : QtDataVisualization::QItemModelBarDataProxy(itemModel, rowRole, columnRole, valueRole, rotationRole, rowCategories, columnCategories, parent)
{
    resetPyMethodCache();
    // ... middle
}

QItemModelBarDataProxyWrapper::QItemModelBarDataProxyWrapper(::QAbstractItemModel * itemModel, const ::QString & rowRole, const ::QString & columnRole, const ::QString & valueRole, const ::QStringList & rowCategories, const ::QStringList & columnCategories, ::QObject * parent) : QtDataVisualization::QItemModelBarDataProxy(itemModel, rowRole, columnRole, valueRole, rowCategories, columnCategories, parent)
{
    resetPyMethodCache();
    // ... middle
}

QItemModelBarDataProxyWrapper::QItemModelBarDataProxyWrapper(::QAbstractItemModel * itemModel, const ::QString & valueRole, ::QObject * parent) : QtDataVisualization::QItemModelBarDataProxy(itemModel, valueRole, parent)
{
    resetPyMethodCache();
    // ... middle
}

QItemModelBarDataProxyWrapper::QItemModelBarDataProxyWrapper(::QObject * parent) : QtDataVisualization::QItemModelBarDataProxy(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QItemModelBarDataProxyWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QItemModelBarDataProxyWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QItemModelBarDataProxyWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QItemModelBarDataProxyWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QItemModelBarDataProxyWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QItemModelBarDataProxy.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QItemModelBarDataProxyWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QItemModelBarDataProxy.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QItemModelBarDataProxyWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QItemModelBarDataProxyWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtDataVisualization::QItemModelBarDataProxy::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QItemModelBarDataProxyWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtDataVisualization::QItemModelBarDataProxy::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QItemModelBarDataProxyWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QItemModelBarDataProxyWrapper *>(this));
        return QtDataVisualization::QItemModelBarDataProxy::qt_metacast(_clname);
}

QItemModelBarDataProxyWrapper::~QItemModelBarDataProxyWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtDataVisualization_QItemModelBarDataProxy_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtDataVisualization::QItemModelBarDataProxy >()))
        return -1;

    ::QItemModelBarDataProxyWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OOOOOOOO:QItemModelBarDataProxy", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return -1;


    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QObject*)
    // 1: QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QObject*)
    // 2: QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QObject*)
    // 3: QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QStringList,QStringList,QObject*)
    // 4: QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QStringList,QStringList,QObject*)
    // 5: QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QObject*)
    // 6: QItemModelBarDataProxy::QItemModelBarDataProxy(QObject*)
    if (numArgs == 0) {
        overloadId = 6; // QItemModelBarDataProxy(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QItemModelBarDataProxy(QAbstractItemModel*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QItemModelBarDataProxy(QAbstractItemModel*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 5; // QItemModelBarDataProxy(QAbstractItemModel*,QString,QObject*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
                overloadId = 5; // QItemModelBarDataProxy(QAbstractItemModel*,QString,QObject*)
            } else if (numArgs >= 4
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 1; // QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QObject*)
                } else if (numArgs >= 6
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[4])))
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[5])))) {
                    if (numArgs == 6) {
                        overloadId = 4; // QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QStringList,QStringList,QObject*)
                    } else if (numArgs >= 7
                        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[6])))) {
                        overloadId = 4; // QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QStringList,QStringList,QObject*)
                    }
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[4])))) {
                    overloadId = 1; // QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QObject*)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))) {
                    if (numArgs == 5) {
                        overloadId = 2; // QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QObject*)
                    } else if (numArgs >= 7
                        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[5])))
                        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[6])))) {
                        if (numArgs == 7) {
                            overloadId = 3; // QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QStringList,QStringList,QObject*)
                        } else if (numArgs >= 8
                            && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[7])))) {
                            overloadId = 3; // QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QStringList,QStringList,QObject*)
                        }
                    } else if (numArgs >= 6
                        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[5])))) {
                        overloadId = 2; // QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QObject*)
                    }
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 6; // QItemModelBarDataProxy(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QItemModelBarDataProxy(QAbstractItemModel * itemModel, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QItemModelBarDataProxy(QAbstractItemModel*,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelBarDataProxyWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelBarDataProxyWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
        case 1: // QItemModelBarDataProxy(QAbstractItemModel * itemModel, const QString & rowRole, const QString & columnRole, const QString & valueRole, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[4]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[4]))))
                            goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return -1;
            ::QObject *cppArg4 = nullptr;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelBarDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelBarDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                }

                Shiboken::Object::setParent(pyArgs[4], self);
            }
            break;
        }
        case 2: // QItemModelBarDataProxy(QAbstractItemModel * itemModel, const QString & rowRole, const QString & columnRole, const QString & valueRole, const QString & rotationRole, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[5]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[5]))))
                            goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QString cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return -1;
            ::QObject *cppArg5 = nullptr;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelBarDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelBarDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
                }

                Shiboken::Object::setParent(pyArgs[5], self);
            }
            break;
        }
        case 3: // QItemModelBarDataProxy(QAbstractItemModel * itemModel, const QString & rowRole, const QString & columnRole, const QString & valueRole, const QString & rotationRole, const QStringList & rowCategories, const QStringList & columnCategories, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[7]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[7]))))
                            goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QString cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QStringList cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            ::QStringList cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return -1;
            ::QObject *cppArg7 = nullptr;
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);

            if (!PyErr_Occurred()) {
                // QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QStringList,QStringList,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelBarDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelBarDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
                }

                Shiboken::Object::setParent(pyArgs[7], self);
            }
            break;
        }
        case 4: // QItemModelBarDataProxy(QAbstractItemModel * itemModel, const QString & rowRole, const QString & columnRole, const QString & valueRole, const QStringList & rowCategories, const QStringList & columnCategories, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[6]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[6]))))
                            goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QStringList cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QStringList cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return -1;
            ::QObject *cppArg6 = nullptr;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QStringList,QStringList,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelBarDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelBarDataProxyWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
                }

                Shiboken::Object::setParent(pyArgs[6], self);
            }
            break;
        }
        case 5: // QItemModelBarDataProxy(QAbstractItemModel * itemModel, const QString & valueRole, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[2]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2]))))
                            goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QItemModelBarDataProxy(QAbstractItemModel*,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelBarDataProxyWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelBarDataProxyWrapper(cppArg0, cppArg1, cppArg2);
                }

                Shiboken::Object::setParent(pyArgs[2], self);
            }
            break;
        }
        case 6: // QItemModelBarDataProxy(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QItemModelBarDataProxy(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QItemModelBarDataProxyWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QItemModelBarDataProxyWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtDataVisualization::QItemModelBarDataProxy >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QtDataVisualization_QItemModelBarDataProxy_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_autoColumnCategories(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.autoColumnCategories";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoColumnCategories()const
            bool cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->autoColumnCategories();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_autoRowCategories(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.autoRowCategories";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoRowCategories()const
            bool cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->autoRowCategories();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_columnCategories(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.columnCategories";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnCategories()const
            QStringList cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->columnCategories();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_columnCategoryIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.columnCategoryIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::columnCategoryIndex(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // columnCategoryIndex(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_columnCategoryIndex_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // columnCategoryIndex(QString)
            int cppResult = cppSelf->columnCategoryIndex(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_columnCategoryIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_columnRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.columnRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnRole()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->columnRole();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_columnRolePattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.columnRolePattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnRolePattern()const
            QRegExp cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->columnRolePattern();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_columnRoleReplace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.columnRoleReplace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnRoleReplace()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->columnRoleReplace();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_itemModel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.itemModel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // itemModel()const
            QAbstractItemModel * cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->itemModel();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_multiMatchBehavior(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.multiMatchBehavior";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // multiMatchBehavior()const
            QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->multiMatchBehavior();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_MULTIMATCHBEHAVIOR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_remap(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.remap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "remap", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::remap(QString,QString,QString,QString,QStringList,QStringList)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[5])))) {
        overloadId = 0; // remap(QString,QString,QString,QString,QStringList,QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_remap_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QStringList cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QStringList cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // remap(QString,QString,QString,QString,QStringList,QStringList)
            cppSelf->remap(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_remap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rotationRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rotationRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rotationRole()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->rotationRole();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rotationRolePattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rotationRolePattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rotationRolePattern()const
            QRegExp cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->rotationRolePattern();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rotationRoleReplace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rotationRoleReplace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rotationRoleReplace()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->rotationRoleReplace();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rowCategories(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rowCategories";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rowCategories()const
            QStringList cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->rowCategories();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rowCategoryIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rowCategoryIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::rowCategoryIndex(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // rowCategoryIndex(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rowCategoryIndex_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // rowCategoryIndex(QString)
            int cppResult = cppSelf->rowCategoryIndex(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rowCategoryIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rowRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rowRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rowRole()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->rowRole();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rowRolePattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rowRolePattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rowRolePattern()const
            QRegExp cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->rowRolePattern();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rowRoleReplace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rowRoleReplace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rowRoleReplace()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->rowRoleReplace();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setAutoColumnCategories(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setAutoColumnCategories";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setAutoColumnCategories(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoColumnCategories(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setAutoColumnCategories_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoColumnCategories(bool)
            cppSelf->setAutoColumnCategories(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setAutoColumnCategories_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setAutoRowCategories(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setAutoRowCategories";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setAutoRowCategories(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoRowCategories(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setAutoRowCategories_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoRowCategories(bool)
            cppSelf->setAutoRowCategories(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setAutoRowCategories_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnCategories(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setColumnCategories";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setColumnCategories(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setColumnCategories(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnCategories_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColumnCategories(QStringList)
            cppSelf->setColumnCategories(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnCategories_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setColumnRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setColumnRole(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setColumnRole(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnRole_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColumnRole(QString)
            cppSelf->setColumnRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnRolePattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setColumnRolePattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setColumnRolePattern(QRegExp)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
        overloadId = 0; // setColumnRolePattern(QRegExp)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnRolePattern_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegExp cppArg0_local;
        ::QRegExp *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setColumnRolePattern(QRegExp)
            cppSelf->setColumnRolePattern(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnRolePattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnRoleReplace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setColumnRoleReplace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setColumnRoleReplace(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setColumnRoleReplace(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnRoleReplace_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColumnRoleReplace(QString)
            cppSelf->setColumnRoleReplace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnRoleReplace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setItemModel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setItemModel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setItemModel(QAbstractItemModel*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), (pyArg)))) {
        overloadId = 0; // setItemModel(QAbstractItemModel*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setItemModel_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractItemModel *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setItemModel(QAbstractItemModel*)
            cppSelf->setItemModel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setItemModel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setMultiMatchBehavior(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setMultiMatchBehavior";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setMultiMatchBehavior(QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_MULTIMATCHBEHAVIOR_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMultiMatchBehavior(QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setMultiMatchBehavior_TypeError;

    // Call function/method
    {
        ::QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior cppArg0{QtDataVisualization::QItemModelBarDataProxy::MMBFirst};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMultiMatchBehavior(QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior)
            cppSelf->setMultiMatchBehavior(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setMultiMatchBehavior_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRotationRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRotationRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setRotationRole(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setRotationRole(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRotationRole_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRotationRole(QString)
            cppSelf->setRotationRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRotationRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRotationRolePattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRotationRolePattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setRotationRolePattern(QRegExp)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
        overloadId = 0; // setRotationRolePattern(QRegExp)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRotationRolePattern_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegExp cppArg0_local;
        ::QRegExp *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setRotationRolePattern(QRegExp)
            cppSelf->setRotationRolePattern(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRotationRolePattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRotationRoleReplace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRotationRoleReplace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setRotationRoleReplace(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setRotationRoleReplace(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRotationRoleReplace_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRotationRoleReplace(QString)
            cppSelf->setRotationRoleReplace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRotationRoleReplace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowCategories(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRowCategories";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setRowCategories(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setRowCategories(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowCategories_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRowCategories(QStringList)
            cppSelf->setRowCategories(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowCategories_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRowRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setRowRole(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setRowRole(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowRole_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRowRole(QString)
            cppSelf->setRowRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowRolePattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRowRolePattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setRowRolePattern(QRegExp)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
        overloadId = 0; // setRowRolePattern(QRegExp)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowRolePattern_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegExp cppArg0_local;
        ::QRegExp *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setRowRolePattern(QRegExp)
            cppSelf->setRowRolePattern(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowRolePattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowRoleReplace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRowRoleReplace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setRowRoleReplace(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setRowRoleReplace(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowRoleReplace_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRowRoleReplace(QString)
            cppSelf->setRowRoleReplace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowRoleReplace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setUseModelCategories(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setUseModelCategories";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setUseModelCategories(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setUseModelCategories(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setUseModelCategories_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUseModelCategories(bool)
            cppSelf->setUseModelCategories(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setUseModelCategories_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setValueRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setValueRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setValueRole(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setValueRole(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setValueRole_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setValueRole(QString)
            cppSelf->setValueRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setValueRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setValueRolePattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setValueRolePattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setValueRolePattern(QRegExp)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
        overloadId = 0; // setValueRolePattern(QRegExp)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setValueRolePattern_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegExp cppArg0_local;
        ::QRegExp *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setValueRolePattern(QRegExp)
            cppSelf->setValueRolePattern(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setValueRolePattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setValueRoleReplace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setValueRoleReplace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemModelBarDataProxy::setValueRoleReplace(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setValueRoleReplace(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setValueRoleReplace_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setValueRoleReplace(QString)
            cppSelf->setValueRoleReplace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setValueRoleReplace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_useModelCategories(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.useModelCategories";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // useModelCategories()const
            bool cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->useModelCategories();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_valueRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.valueRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // valueRole()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->valueRole();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_valueRolePattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.valueRolePattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // valueRolePattern()const
            QRegExp cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->valueRolePattern();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_valueRoleReplace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.valueRoleReplace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // valueRoleReplace()const
            QString cppResult = const_cast<const ::QtDataVisualization::QItemModelBarDataProxy *>(cppSelf)->valueRoleReplace();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtDataVisualization_QItemModelBarDataProxy_PropertyStrings[] = {
    "autoColumnCategories::",
    "autoRowCategories::",
    "columnCategories::",
    "columnRole::",
    "columnRolePattern::",
    "columnRoleReplace::",
    "itemModel::",
    "multiMatchBehavior::",
    "rotationRole::",
    "rotationRolePattern::",
    "rotationRoleReplace::",
    "rowCategories::",
    "rowRole::",
    "rowRolePattern::",
    "rowRoleReplace::",
    "useModelCategories::",
    "valueRole::",
    "valueRolePattern::",
    "valueRoleReplace::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_QItemModelBarDataProxy_methods[] = {
    {"autoColumnCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_autoColumnCategories), METH_NOARGS},
    {"autoRowCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_autoRowCategories), METH_NOARGS},
    {"columnCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_columnCategories), METH_NOARGS},
    {"columnCategoryIndex", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_columnCategoryIndex), METH_O},
    {"columnRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_columnRole), METH_NOARGS},
    {"columnRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_columnRolePattern), METH_NOARGS},
    {"columnRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_columnRoleReplace), METH_NOARGS},
    {"itemModel", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_itemModel), METH_NOARGS},
    {"multiMatchBehavior", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_multiMatchBehavior), METH_NOARGS},
    {"remap", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_remap), METH_VARARGS},
    {"rotationRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rotationRole), METH_NOARGS},
    {"rotationRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rotationRolePattern), METH_NOARGS},
    {"rotationRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rotationRoleReplace), METH_NOARGS},
    {"rowCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rowCategories), METH_NOARGS},
    {"rowCategoryIndex", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rowCategoryIndex), METH_O},
    {"rowRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rowRole), METH_NOARGS},
    {"rowRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rowRolePattern), METH_NOARGS},
    {"rowRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_rowRoleReplace), METH_NOARGS},
    {"setAutoColumnCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setAutoColumnCategories), METH_O},
    {"setAutoRowCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setAutoRowCategories), METH_O},
    {"setColumnCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnCategories), METH_O},
    {"setColumnRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnRole), METH_O},
    {"setColumnRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnRolePattern), METH_O},
    {"setColumnRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setColumnRoleReplace), METH_O},
    {"setItemModel", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setItemModel), METH_O},
    {"setMultiMatchBehavior", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setMultiMatchBehavior), METH_O},
    {"setRotationRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRotationRole), METH_O},
    {"setRotationRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRotationRolePattern), METH_O},
    {"setRotationRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRotationRoleReplace), METH_O},
    {"setRowCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowCategories), METH_O},
    {"setRowRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowRole), METH_O},
    {"setRowRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowRolePattern), METH_O},
    {"setRowRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setRowRoleReplace), METH_O},
    {"setUseModelCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setUseModelCategories), METH_O},
    {"setValueRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setValueRole), METH_O},
    {"setValueRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setValueRolePattern), METH_O},
    {"setValueRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_setValueRoleReplace), METH_O},
    {"useModelCategories", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_useModelCategories), METH_NOARGS},
    {"valueRole", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_valueRole), METH_NOARGS},
    {"valueRolePattern", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_valueRolePattern), METH_NOARGS},
    {"valueRoleReplace", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QItemModelBarDataProxyFunc_valueRoleReplace), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtDataVisualization_QItemModelBarDataProxy_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QItemModelBarDataProxyWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtDataVisualization_QItemModelBarDataProxy_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_QItemModelBarDataProxy_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_QItemModelBarDataProxy_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF(void)
{
    return _Sbk_QtDataVisualization_QItemModelBarDataProxy_Type;
}

static PyType_Slot Sbk_QtDataVisualization_QItemModelBarDataProxy_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QItemModelBarDataProxy_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QItemModelBarDataProxy_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_QItemModelBarDataProxy_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_QItemModelBarDataProxy_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtDataVisualization_QItemModelBarDataProxy_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_QItemModelBarDataProxy_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_QItemModelBarDataProxy_slots
};

} //extern "C"

static void *Sbk_QtDataVisualization_QItemModelBarDataProxy_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtDataVisualization::QItemModelBarDataProxy *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior_PythonToCpp_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior *>(cppOut) =
        static_cast<::QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior_PythonToCpp_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_MULTIMATCHBEHAVIOR_IDX]))
        return QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior_PythonToCpp_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior;
    return {};
}
static PyObject *QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior_CppToPython_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_MULTIMATCHBEHAVIOR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QItemModelBarDataProxy_PythonToCpp_QItemModelBarDataProxy_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QItemModelBarDataProxy_PythonToCpp_QItemModelBarDataProxy_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF())))
        return QItemModelBarDataProxy_PythonToCpp_QItemModelBarDataProxy_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QItemModelBarDataProxy_PTR_CppToPython_QItemModelBarDataProxy(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtDataVisualization::QItemModelBarDataProxy *>(const_cast<void *>(cppIn)), Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_QItemModelBarDataProxy_SignatureStrings[] = {
    "6:PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy(self,itemModel:PySide2.QtCore.QAbstractItemModel,parent:PySide2.QtCore.QObject=nullptr)",
    "5:PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy(self,itemModel:PySide2.QtCore.QAbstractItemModel,rowRole:QString,columnRole:QString,valueRole:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "4:PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy(self,itemModel:PySide2.QtCore.QAbstractItemModel,rowRole:QString,columnRole:QString,valueRole:QString,rotationRole:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "3:PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy(self,itemModel:PySide2.QtCore.QAbstractItemModel,rowRole:QString,columnRole:QString,valueRole:QString,rotationRole:QString,rowCategories:QStringList,columnCategories:QStringList,parent:PySide2.QtCore.QObject=nullptr)",
    "2:PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy(self,itemModel:PySide2.QtCore.QAbstractItemModel,rowRole:QString,columnRole:QString,valueRole:QString,rowCategories:QStringList,columnCategories:QStringList,parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy(self,itemModel:PySide2.QtCore.QAbstractItemModel,valueRole:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.autoColumnCategories(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.autoRowCategories(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.columnCategories(self)->QStringList",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.columnCategoryIndex(self,category:QString)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.columnRole(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.columnRolePattern(self)->PySide2.QtCore.QRegExp",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.columnRoleReplace(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.itemModel(self)->PySide2.QtCore.QAbstractItemModel",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.multiMatchBehavior(self)->PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.remap(self,rowRole:QString,columnRole:QString,valueRole:QString,rotationRole:QString,rowCategories:QStringList,columnCategories:QStringList)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rotationRole(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rotationRolePattern(self)->PySide2.QtCore.QRegExp",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rotationRoleReplace(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rowCategories(self)->QStringList",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rowCategoryIndex(self,category:QString)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rowRole(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rowRolePattern(self)->PySide2.QtCore.QRegExp",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.rowRoleReplace(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setAutoColumnCategories(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setAutoRowCategories(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setColumnCategories(self,categories:QStringList)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setColumnRole(self,role:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setColumnRolePattern(self,pattern:PySide2.QtCore.QRegExp)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setColumnRoleReplace(self,replace:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setItemModel(self,itemModel:PySide2.QtCore.QAbstractItemModel)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setMultiMatchBehavior(self,behavior:PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRotationRole(self,role:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRotationRolePattern(self,pattern:PySide2.QtCore.QRegExp)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRotationRoleReplace(self,replace:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRowCategories(self,categories:QStringList)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRowRole(self,role:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRowRolePattern(self,pattern:PySide2.QtCore.QRegExp)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setRowRoleReplace(self,replace:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setUseModelCategories(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setValueRole(self,role:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setValueRolePattern(self,pattern:PySide2.QtCore.QRegExp)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.setValueRoleReplace(self,replace:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.useModelCategories(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.valueRole(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.valueRolePattern(self)->PySide2.QtCore.QRegExp",
    "PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.valueRoleReplace(self)->QString",
    nullptr}; // Sentinel

void init_QtDataVisualization_QItemModelBarDataProxy(PyObject *enclosingClass)
{
    _Sbk_QtDataVisualization_QItemModelBarDataProxy_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QItemModelBarDataProxy",
        "QtDataVisualization::QItemModelBarDataProxy*",
        &Sbk_QtDataVisualization_QItemModelBarDataProxy_spec,
        &Shiboken::callCppDestructor< ::QtDataVisualization::QItemModelBarDataProxy >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QItemModelBarDataProxy_Type);
    InitSignatureStrings(pyType, QtDataVisualization_QItemModelBarDataProxy_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QItemModelBarDataProxy_Type), Sbk_QtDataVisualization_QItemModelBarDataProxy_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF(),
        QItemModelBarDataProxy_PythonToCpp_QItemModelBarDataProxy_PTR,
        is_QItemModelBarDataProxy_PythonToCpp_QItemModelBarDataProxy_PTR_Convertible,
        QItemModelBarDataProxy_PTR_CppToPython_QItemModelBarDataProxy);

    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QItemModelBarDataProxy");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QItemModelBarDataProxy*");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QItemModelBarDataProxy&");
    Shiboken::Conversions::registerConverterName(converter, "QItemModelBarDataProxy");
    Shiboken::Conversions::registerConverterName(converter, "QItemModelBarDataProxy*");
    Shiboken::Conversions::registerConverterName(converter, "QItemModelBarDataProxy&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtDataVisualization::QItemModelBarDataProxy).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QItemModelBarDataProxyWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF(), &Sbk_QtDataVisualization_QItemModelBarDataProxy_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'MultiMatchBehavior'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_MULTIMATCHBEHAVIOR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF(),
        "MultiMatchBehavior",
        "2:PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior",
        "QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior");
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_MULTIMATCHBEHAVIOR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_MULTIMATCHBEHAVIOR_IDX],
        Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF(), "MMBFirst", (long) QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior::MMBFirst))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_MULTIMATCHBEHAVIOR_IDX],
        Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF(), "MMBLast", (long) QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior::MMBLast))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_MULTIMATCHBEHAVIOR_IDX],
        Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF(), "MMBAverage", (long) QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior::MMBAverage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_MULTIMATCHBEHAVIOR_IDX],
        Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF(), "MMBCumulative", (long) QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior::MMBCumulative))
        return;
    // Register converter for enum 'QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_MULTIMATCHBEHAVIOR_IDX],
            QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior_CppToPython_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior_PythonToCpp_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior,
            is_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior_PythonToCpp_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QITEMMODELBARDATAPROXY_MULTIMATCHBEHAVIOR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior");
        Shiboken::Conversions::registerConverterName(converter, "QItemModelBarDataProxy::MultiMatchBehavior");
        Shiboken::Conversions::registerConverterName(converter, "MultiMatchBehavior");
    }
    // End of 'MultiMatchBehavior' enum.

    PySide::Signal::registerSignals(Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF(), &::QtDataVisualization::QItemModelBarDataProxy::staticMetaObject);
    qRegisterMetaType< ::QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior >("QItemModelBarDataProxy::MultiMatchBehavior");
    qRegisterMetaType< ::QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior >("QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtDataVisualization_QItemModelBarDataProxy_TypeF(), &::QtDataVisualization::QItemModelBarDataProxy::staticMetaObject, sizeof(QItemModelBarDataProxyWrapper));
}
