/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_qscatterdataitem_wrapper.h"

// inner classes

// Extra includes
#include <QtDataVisualization/qscatterdataitem.h>
#include <QtGui/qquaternion.h>
#include <QtGui/qvector3d.h>


#include <cctype>
#include <cstring>

using namespace QtDataVisualization;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtDataVisualization_QScatterDataItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtDataVisualization::QScatterDataItem >()))
        return -1;

    ::QtDataVisualization::QScatterDataItem *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QScatterDataItem", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QScatterDataItem::QScatterDataItem()
    // 1: QScatterDataItem::QScatterDataItem(QVector3D)
    // 2: QScatterDataItem::QScatterDataItem(QVector3D,QQuaternion)
    // 3: QScatterDataItem::QScatterDataItem(QtDataVisualization::QScatterDataItem)
    if (numArgs == 0) {
        overloadId = 0; // QScatterDataItem()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QScatterDataItem(QVector3D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QQUATERNION_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QScatterDataItem(QVector3D,QQuaternion)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QScatterDataItem(QtDataVisualization::QScatterDataItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataItem_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QScatterDataItem()
        {

            if (!PyErr_Occurred()) {
                // QScatterDataItem()
                cptr = new ::QtDataVisualization::QScatterDataItem();
            }
            break;
        }
        case 1: // QScatterDataItem(const QVector3D & position)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QVector3D cppArg0_local;
            ::QVector3D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QScatterDataItem(QVector3D)
                cptr = new ::QtDataVisualization::QScatterDataItem(*cppArg0);
            }
            break;
        }
        case 2: // QScatterDataItem(const QVector3D & position, const QQuaternion & rotation)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QVector3D cppArg0_local;
            ::QVector3D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QQuaternion cppArg1_local;
            ::QQuaternion *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QQUATERNION_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QScatterDataItem(QVector3D,QQuaternion)
                cptr = new ::QtDataVisualization::QScatterDataItem(*cppArg0, *cppArg1);
            }
            break;
        }
        case 3: // QScatterDataItem(const QtDataVisualization::QScatterDataItem & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QtDataVisualization::QScatterDataItem cppArg0_local;
            ::QtDataVisualization::QScatterDataItem *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QScatterDataItem(QtDataVisualization::QScatterDataItem)
                cptr = new ::QtDataVisualization::QScatterDataItem(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtDataVisualization::QScatterDataItem >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtDataVisualization_QScatterDataItem_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QtDataVisualization_QScatterDataItem_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtDataVisualization_QScatterDataItemFunc_createExtraData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.createExtraData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // createExtraData()
            cppSelf->createExtraData();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QtDataVisualization_QScatterDataItemFunc_position(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.position";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // position()const
            QVector3D cppResult = const_cast<const ::QtDataVisualization::QScatterDataItem *>(cppSelf)->position();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QScatterDataItemFunc_rotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.rotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rotation()const
            QQuaternion cppResult = const_cast<const ::QtDataVisualization::QScatterDataItem *>(cppSelf)->rotation();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QQUATERNION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QScatterDataItemFunc_setPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.setPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScatterDataItem::setPosition(QVector3D)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArg)))) {
        overloadId = 0; // setPosition(QVector3D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataItemFunc_setPosition_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector3D cppArg0_local;
        ::QVector3D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPosition(QVector3D)
            cppSelf->setPosition(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QScatterDataItemFunc_setPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataItemFunc_setRotation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.setRotation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScatterDataItem::setRotation(QQuaternion)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QQUATERNION_IDX]), (pyArg)))) {
        overloadId = 0; // setRotation(QQuaternion)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataItemFunc_setRotation_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QQuaternion cppArg0_local;
        ::QQuaternion *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QQUATERNION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setRotation(QQuaternion)
            cppSelf->setRotation(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QScatterDataItemFunc_setRotation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataItemFunc_setX(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.setX";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScatterDataItem::setX(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setX(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataItemFunc_setX_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setX(float)
            cppSelf->setX(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QScatterDataItemFunc_setX_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataItemFunc_setY(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.setY";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScatterDataItem::setY(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setY(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataItemFunc_setY_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setY(float)
            cppSelf->setY(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QScatterDataItemFunc_setY_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataItemFunc_setZ(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.setZ";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScatterDataItem::setZ(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setZ(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataItemFunc_setZ_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setZ(float)
            cppSelf->setZ(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QScatterDataItemFunc_setZ_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataItemFunc_x(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.x";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // x()const
            float cppResult = const_cast<const ::QtDataVisualization::QScatterDataItem *>(cppSelf)->x();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QScatterDataItemFunc_y(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.y";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // y()const
            float cppResult = const_cast<const ::QtDataVisualization::QScatterDataItem *>(cppSelf)->y();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QScatterDataItemFunc_z(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.z";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // z()const
            float cppResult = const_cast<const ::QtDataVisualization::QScatterDataItem *>(cppSelf)->z();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QScatterDataItem___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtDataVisualization_QScatterDataItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_QScatterDataItem_methods[] = {
    {"createExtraData", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataItemFunc_createExtraData), METH_NOARGS},
    {"position", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataItemFunc_position), METH_NOARGS},
    {"rotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataItemFunc_rotation), METH_NOARGS},
    {"setPosition", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataItemFunc_setPosition), METH_O},
    {"setRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataItemFunc_setRotation), METH_O},
    {"setX", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataItemFunc_setX), METH_O},
    {"setY", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataItemFunc_setY), METH_O},
    {"setZ", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataItemFunc_setZ), METH_O},
    {"x", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataItemFunc_x), METH_NOARGS},
    {"y", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataItemFunc_y), METH_NOARGS},
    {"z", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataItemFunc_z), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataItem___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QtDataVisualization_QScatterDataItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_QScatterDataItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_QScatterDataItem_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_QScatterDataItem_TypeF(void)
{
    return _Sbk_QtDataVisualization_QScatterDataItem_Type;
}

static PyType_Slot Sbk_QtDataVisualization_QScatterDataItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QScatterDataItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_QScatterDataItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_QScatterDataItem_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtDataVisualization_QScatterDataItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_QScatterDataItem_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_QScatterDataItem_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScatterDataItem_PythonToCpp_QScatterDataItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtDataVisualization_QScatterDataItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScatterDataItem_PythonToCpp_QScatterDataItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QScatterDataItem_TypeF())))
        return QScatterDataItem_PythonToCpp_QScatterDataItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScatterDataItem_PTR_CppToPython_QScatterDataItem(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QtDataVisualization::QScatterDataItem *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QtDataVisualization_QScatterDataItem_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QScatterDataItem_COPY_CppToPython_QScatterDataItem(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QtDataVisualization_QScatterDataItem_TypeF(), new ::QtDataVisualization::QScatterDataItem(*reinterpret_cast<const ::QtDataVisualization::QScatterDataItem *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QScatterDataItem_PythonToCpp_QScatterDataItem_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QScatterDataItem *>(cppOut) = *reinterpret_cast< ::QtDataVisualization::QScatterDataItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QScatterDataItem_PythonToCpp_QScatterDataItem_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QScatterDataItem_TypeF())))
        return QScatterDataItem_PythonToCpp_QScatterDataItem_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtGui_constQVector3DREF_PythonToCpp_QtDataVisualization_QScatterDataItem(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QScatterDataItem *>(cppOut) = ::QtDataVisualization::QScatterDataItem( *reinterpret_cast< ::QVector3D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide2_QtGui_constQVector3DREF_PythonToCpp_QtDataVisualization_QScatterDataItem_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX], pyIn))
        return PySide2_QtGui_constQVector3DREF_PythonToCpp_QtDataVisualization_QScatterDataItem;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_QScatterDataItem_SignatureStrings[] = {
    "3:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem(self)",
    "2:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem(self,position:PySide2.QtGui.QVector3D)",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem(self,position:PySide2.QtGui.QVector3D,rotation:PySide2.QtGui.QQuaternion)",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem(self,other:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem)",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.createExtraData(self)",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.position(self)->PySide2.QtGui.QVector3D",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.rotation(self)->PySide2.QtGui.QQuaternion",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.setPosition(self,pos:PySide2.QtGui.QVector3D)",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.setRotation(self,rot:PySide2.QtGui.QQuaternion)",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.setX(self,value:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.setY(self,value:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.setZ(self,value:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.x(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.y(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.z(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem.__copy__()",
    nullptr}; // Sentinel

void init_QtDataVisualization_QScatterDataItem(PyObject *enclosingClass)
{
    _Sbk_QtDataVisualization_QScatterDataItem_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QScatterDataItem",
        "QtDataVisualization::QScatterDataItem",
        &Sbk_QtDataVisualization_QScatterDataItem_spec,
        &Shiboken::callCppDestructor< ::QtDataVisualization::QScatterDataItem >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QScatterDataItem_Type);
    InitSignatureStrings(pyType, QtDataVisualization_QScatterDataItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QScatterDataItem_Type), Sbk_QtDataVisualization_QScatterDataItem_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QScatterDataItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtDataVisualization_QScatterDataItem_TypeF(),
        QScatterDataItem_PythonToCpp_QScatterDataItem_PTR,
        is_QScatterDataItem_PythonToCpp_QScatterDataItem_PTR_Convertible,
        QScatterDataItem_PTR_CppToPython_QScatterDataItem,
        QScatterDataItem_COPY_CppToPython_QScatterDataItem);

    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QScatterDataItem");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QScatterDataItem*");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QScatterDataItem&");
    Shiboken::Conversions::registerConverterName(converter, "QScatterDataItem");
    Shiboken::Conversions::registerConverterName(converter, "QScatterDataItem*");
    Shiboken::Conversions::registerConverterName(converter, "QScatterDataItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtDataVisualization::QScatterDataItem).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QScatterDataItem_PythonToCpp_QScatterDataItem_COPY,
        is_QScatterDataItem_PythonToCpp_QScatterDataItem_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtGui_constQVector3DREF_PythonToCpp_QtDataVisualization_QScatterDataItem,
        is_PySide2_QtGui_constQVector3DREF_PythonToCpp_QtDataVisualization_QScatterDataItem_Convertible);

    qRegisterMetaType< ::QtDataVisualization::QScatterDataItem >("QScatterDataItem");
    qRegisterMetaType< ::QtDataVisualization::QScatterDataItem >("QtDataVisualization::QScatterDataItem");
}
