/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_qscatterdataproxy_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtDataVisualization;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QScatterDataProxyWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QScatterDataProxyWrapper::QScatterDataProxyWrapper(::QObject * parent) : QtDataVisualization::QScatterDataProxy(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QScatterDataProxyWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QScatterDataProxyWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QScatterDataProxyWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QScatterDataProxyWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QScatterDataProxyWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScatterDataProxy.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QScatterDataProxyWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScatterDataProxy.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QScatterDataProxyWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QScatterDataProxyWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtDataVisualization::QScatterDataProxy::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QScatterDataProxyWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtDataVisualization::QScatterDataProxy::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QScatterDataProxyWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QScatterDataProxyWrapper *>(this));
        return QtDataVisualization::QScatterDataProxy::qt_metacast(_clname);
}

QScatterDataProxyWrapper::~QScatterDataProxyWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtDataVisualization_QScatterDataProxy_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtDataVisualization::QScatterDataProxy >()))
        return -1;

    ::QScatterDataProxyWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QScatterDataProxy", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QScatterDataProxy::QScatterDataProxy(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QScatterDataProxy(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QScatterDataProxy(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataProxy_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QtDataVisualization_QScatterDataProxy_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QtDataVisualization_QScatterDataProxy_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QScatterDataProxy(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QScatterDataProxyWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QScatterDataProxyWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtDataVisualization::QScatterDataProxy >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtDataVisualization_QScatterDataProxy_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QtDataVisualization_QScatterDataProxy_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QtDataVisualization_QScatterDataProxy_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtDataVisualization_QScatterDataProxyFunc_addItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.addItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScatterDataProxy::addItem(QtDataVisualization::QScatterDataItem)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), (pyArg)))) {
        overloadId = 0; // addItem(QtDataVisualization::QScatterDataItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataProxyFunc_addItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtDataVisualization::QScatterDataItem cppArg0_local;
        ::QtDataVisualization::QScatterDataItem *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // addItem(QtDataVisualization::QScatterDataItem)
            int cppResult = cppSelf->addItem(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QScatterDataProxyFunc_addItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataProxyFunc_addItems(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.addItems";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScatterDataProxy::addItems(QVector<QtDataVisualization::QScatterDataItem>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], (pyArg)))) {
        overloadId = 0; // addItems(QVector<QtDataVisualization::QScatterDataItem>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataProxyFunc_addItems_TypeError;

    // Call function/method
    {
        ::QVector<QtDataVisualization::QScatterDataItem > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addItems(QVector<QtDataVisualization::QScatterDataItem>)
            int cppResult = cppSelf->addItems(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QScatterDataProxyFunc_addItems_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataProxyFunc_array(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.array";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // array()const
            const QVector<QtDataVisualization::QScatterDataItem > * cppResult = const_cast<const ::QtDataVisualization::QScatterDataProxy *>(cppSelf)->array();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QScatterDataProxyFunc_insertItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.insertItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertItem", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScatterDataProxy::insertItem(int,QtDataVisualization::QScatterDataItem)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insertItem(int,QtDataVisualization::QScatterDataItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataProxyFunc_insertItem_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QtDataVisualization::QScatterDataItem cppArg1_local;
        ::QtDataVisualization::QScatterDataItem *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // insertItem(int,QtDataVisualization::QScatterDataItem)
            cppSelf->insertItem(cppArg0, *cppArg1);
            Shiboken::Object::setParent(self, pyArgs[1]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QScatterDataProxyFunc_insertItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataProxyFunc_insertItems(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.insertItems";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertItems", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScatterDataProxy::insertItems(int,QVector<QtDataVisualization::QScatterDataItem>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], (pyArgs[1])))) {
        overloadId = 0; // insertItems(int,QVector<QtDataVisualization::QScatterDataItem>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataProxyFunc_insertItems_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVector<QtDataVisualization::QScatterDataItem > cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // insertItems(int,QVector<QtDataVisualization::QScatterDataItem>)
            cppSelf->insertItems(cppArg0, cppArg1);
            Shiboken::Object::setParent(self, pyArgs[1]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QScatterDataProxyFunc_insertItems_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataProxyFunc_itemAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.itemAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScatterDataProxy::itemAt(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // itemAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataProxyFunc_itemAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // itemAt(int)const
            const QtDataVisualization::QScatterDataItem * cppResult = const_cast<const ::QtDataVisualization::QScatterDataProxy *>(cppSelf)->itemAt(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QScatterDataProxyFunc_itemAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataProxyFunc_itemCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.itemCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // itemCount()const
            int cppResult = const_cast<const ::QtDataVisualization::QScatterDataProxy *>(cppSelf)->itemCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QScatterDataProxyFunc_removeItems(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.removeItems";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "removeItems", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScatterDataProxy::removeItems(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // removeItems(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataProxyFunc_removeItems_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // removeItems(int,int)
            cppSelf->removeItems(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QScatterDataProxyFunc_removeItems_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataProxyFunc_resetArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.resetArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScatterDataProxy::resetArray(QVector<QtDataVisualization::QScatterDataItem>*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], (pyArg)))) {
        overloadId = 0; // resetArray(QVector<QtDataVisualization::QScatterDataItem>*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataProxyFunc_resetArray_TypeError;

    // Call function/method
    {
        ::QVector<QtDataVisualization::QScatterDataItem > *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resetArray(QVector<QtDataVisualization::QScatterDataItem>*)
            cppSelf->resetArray(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QScatterDataProxyFunc_resetArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataProxyFunc_series(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.series";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // series()const
            QtDataVisualization::QScatter3DSeries * cppResult = const_cast<const ::QtDataVisualization::QScatterDataProxy *>(cppSelf)->series();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTER3DSERIES_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QScatterDataProxyFunc_setItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.setItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setItem", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScatterDataProxy::setItem(int,QtDataVisualization::QScatterDataItem)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setItem(int,QtDataVisualization::QScatterDataItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataProxyFunc_setItem_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QtDataVisualization::QScatterDataItem cppArg1_local;
        ::QtDataVisualization::QScatterDataItem *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setItem(int,QtDataVisualization::QScatterDataItem)
            cppSelf->setItem(cppArg0, *cppArg1);
            Shiboken::Object::setParent(self, pyArgs[1]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QScatterDataProxyFunc_setItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QScatterDataProxyFunc_setItems(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.setItems";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setItems", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScatterDataProxy::setItems(int,QVector<QtDataVisualization::QScatterDataItem>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], (pyArgs[1])))) {
        overloadId = 0; // setItems(int,QVector<QtDataVisualization::QScatterDataItem>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QScatterDataProxyFunc_setItems_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVector<QtDataVisualization::QScatterDataItem > cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setItems(int,QVector<QtDataVisualization::QScatterDataItem>)
            cppSelf->setItems(cppArg0, cppArg1);
            Shiboken::Object::setParent(self, pyArgs[1]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QScatterDataProxyFunc_setItems_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QtDataVisualization_QScatterDataProxy_PropertyStrings[] = {
    "itemCount:",
    "series:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_QScatterDataProxy_methods[] = {
    {"addItem", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataProxyFunc_addItem), METH_O},
    {"addItems", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataProxyFunc_addItems), METH_O},
    {"array", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataProxyFunc_array), METH_NOARGS},
    {"insertItem", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataProxyFunc_insertItem), METH_VARARGS},
    {"insertItems", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataProxyFunc_insertItems), METH_VARARGS},
    {"itemAt", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataProxyFunc_itemAt), METH_O},
    {"itemCount", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataProxyFunc_itemCount), METH_NOARGS},
    {"removeItems", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataProxyFunc_removeItems), METH_VARARGS},
    {"resetArray", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataProxyFunc_resetArray), METH_O},
    {"series", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataProxyFunc_series), METH_NOARGS},
    {"setItem", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataProxyFunc_setItem), METH_VARARGS},
    {"setItems", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QScatterDataProxyFunc_setItems), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtDataVisualization_QScatterDataProxy_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtDataVisualization::QScatterDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QScatterDataProxyWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtDataVisualization_QScatterDataProxy_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_QScatterDataProxy_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_QScatterDataProxy_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_QScatterDataProxy_TypeF(void)
{
    return _Sbk_QtDataVisualization_QScatterDataProxy_Type;
}

static PyType_Slot Sbk_QtDataVisualization_QScatterDataProxy_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QScatterDataProxy_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QScatterDataProxy_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_QScatterDataProxy_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_QScatterDataProxy_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtDataVisualization_QScatterDataProxy_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_QScatterDataProxy_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_QScatterDataProxy_slots
};

} //extern "C"

static void *Sbk_QtDataVisualization_QScatterDataProxy_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtDataVisualization::QScatterDataProxy *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScatterDataProxy_PythonToCpp_QScatterDataProxy_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtDataVisualization_QScatterDataProxy_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScatterDataProxy_PythonToCpp_QScatterDataProxy_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QScatterDataProxy_TypeF())))
        return QScatterDataProxy_PythonToCpp_QScatterDataProxy_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScatterDataProxy_PTR_CppToPython_QScatterDataProxy(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtDataVisualization::QScatterDataProxy *>(const_cast<void *>(cppIn)), Sbk_QtDataVisualization_QScatterDataProxy_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_QScatterDataProxy_SignatureStrings[] = {
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.addItem(self,item:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.addItems(self,items:QVector[PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem])->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.array(self)->QVector[PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem]",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.insertItem(self,index:int,item:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem)",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.insertItems(self,index:int,items:QVector[PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem])",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.itemAt(self,index:int)->PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.itemCount(self)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.removeItems(self,index:int,removeCount:int)",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.resetArray(self,newArray:QVector[PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem])",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.series(self)->PySide2.QtDataVisualization.QtDataVisualization.QScatter3DSeries",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.setItem(self,index:int,item:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem)",
    "PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy.setItems(self,index:int,items:QVector[PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem])",
    nullptr}; // Sentinel

void init_QtDataVisualization_QScatterDataProxy(PyObject *enclosingClass)
{
    _Sbk_QtDataVisualization_QScatterDataProxy_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QScatterDataProxy",
        "QtDataVisualization::QScatterDataProxy*",
        &Sbk_QtDataVisualization_QScatterDataProxy_spec,
        &Shiboken::callCppDestructor< ::QtDataVisualization::QScatterDataProxy >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACTDATAPROXY_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QScatterDataProxy_Type);
    InitSignatureStrings(pyType, QtDataVisualization_QScatterDataProxy_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QScatterDataProxy_Type), Sbk_QtDataVisualization_QScatterDataProxy_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAPROXY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QScatterDataProxy_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtDataVisualization_QScatterDataProxy_TypeF(),
        QScatterDataProxy_PythonToCpp_QScatterDataProxy_PTR,
        is_QScatterDataProxy_PythonToCpp_QScatterDataProxy_PTR_Convertible,
        QScatterDataProxy_PTR_CppToPython_QScatterDataProxy);

    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QScatterDataProxy");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QScatterDataProxy*");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QScatterDataProxy&");
    Shiboken::Conversions::registerConverterName(converter, "QScatterDataProxy");
    Shiboken::Conversions::registerConverterName(converter, "QScatterDataProxy*");
    Shiboken::Conversions::registerConverterName(converter, "QScatterDataProxy&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtDataVisualization::QScatterDataProxy).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScatterDataProxyWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtDataVisualization_QScatterDataProxy_TypeF(), &Sbk_QtDataVisualization_QScatterDataProxy_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QtDataVisualization_QScatterDataProxy_TypeF(), &::QtDataVisualization::QScatterDataProxy::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtDataVisualization_QScatterDataProxy_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtDataVisualization_QScatterDataProxy_TypeF(), &::QtDataVisualization::QScatterDataProxy::staticMetaObject, sizeof(QScatterDataProxyWrapper));
}
