/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_wrapper.h"

// inner classes
#include "qtdatavisualization_qcustom3ditem_wrapper.h"
#include "qtdatavisualization_qcustom3dvolume_wrapper.h"
#include "qtdatavisualization_qcustom3dlabel_wrapper.h"
#include "qtdatavisualization_qsurfacedataitem_wrapper.h"
#include "qtdatavisualization_qscatterdataitem_wrapper.h"
#include "qtdatavisualization_qbardataitem_wrapper.h"
#include "qtdatavisualization_qabstractdataproxy_wrapper.h"
#include "qtdatavisualization_qbardataproxy_wrapper.h"
#include "qtdatavisualization_qitemmodelbardataproxy_wrapper.h"
#include "qtdatavisualization_qsurfacedataproxy_wrapper.h"
#include "qtdatavisualization_qitemmodelsurfacedataproxy_wrapper.h"
#include "qtdatavisualization_qheightmapsurfacedataproxy_wrapper.h"
#include "qtdatavisualization_qscatterdataproxy_wrapper.h"
#include "qtdatavisualization_qitemmodelscatterdataproxy_wrapper.h"
#include "qtdatavisualization_qabstract3dseries_wrapper.h"
#include "qtdatavisualization_qbar3dseries_wrapper.h"
#include "qtdatavisualization_qsurface3dseries_wrapper.h"
#include "qtdatavisualization_qscatter3dseries_wrapper.h"
#include "qtdatavisualization_qvalue3daxisformatter_wrapper.h"
#include "qtdatavisualization_qlogvalue3daxisformatter_wrapper.h"
#include "qtdatavisualization_qabstract3daxis_wrapper.h"
#include "qtdatavisualization_qcategory3daxis_wrapper.h"
#include "qtdatavisualization_qvalue3daxis_wrapper.h"
#include "qtdatavisualization_qabstract3dgraph_wrapper.h"
#include "qtdatavisualization_q3dbars_wrapper.h"
#include "qtdatavisualization_q3dsurface_wrapper.h"
#include "qtdatavisualization_q3dscatter_wrapper.h"
#include "qtdatavisualization_qabstract3dinputhandler_wrapper.h"
#include "qtdatavisualization_q3dinputhandler_wrapper.h"
#include "qtdatavisualization_qtouch3dinputhandler_wrapper.h"
#include "qtdatavisualization_q3dscene_wrapper.h"
#include "qtdatavisualization_q3dobject_wrapper.h"
#include "qtdatavisualization_q3dlight_wrapper.h"
#include "qtdatavisualization_q3dcamera_wrapper.h"
#include "qtdatavisualization_q3dtheme_wrapper.h"

// Extra includes
#include <QtGui/qsurfaceformat.h>
#include <qutils.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QtDataVisualizationFunc_qDefaultSurfaceFormat(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.qDefaultSurfaceFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtDataVisualizationFunc_qDefaultSurfaceFormat_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:qDefaultSurfaceFormat", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QtDataVisualization::qDefaultSurfaceFormat(bool)
    // 1: static QtDataVisualization::qDefaultSurfaceFormat(bool)
    if (numArgs == 0) {
        overloadId = 0; // qDefaultSurfaceFormat(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // qDefaultSurfaceFormat(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualizationFunc_qDefaultSurfaceFormat_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // qDefaultSurfaceFormat(bool antialias)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_antialias = Shiboken::String::createStaticString("antialias");
                if (PyDict_Contains(kwds, key_antialias)) {
                    value = PyDict_GetItem(kwds, key_antialias);
                    if (value && pyArgs[0]) {
                        errInfo = key_antialias;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualizationFunc_qDefaultSurfaceFormat_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                            goto Sbk_QtDataVisualizationFunc_qDefaultSurfaceFormat_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_antialias);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QtDataVisualizationFunc_qDefaultSurfaceFormat_TypeError;
                }
            }
            bool cppArg0 = true;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // qDefaultSurfaceFormat(bool)
                QSurfaceFormat cppResult = ::QtDataVisualization::qDefaultSurfaceFormat(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), &cppResult);
            }
            break;
        }
        case 1: // qDefaultSurfaceFormat(bool antialias)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QtDataVisualizationFunc_qDefaultSurfaceFormat_TypeError;
            }
            bool cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // qDefaultSurfaceFormat(bool)
                QSurfaceFormat cppResult = ::QtDataVisualization::qDefaultSurfaceFormat(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualizationFunc_qDefaultSurfaceFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QtDataVisualization_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_methods[] = {
    {"qDefaultSurfaceFormat", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualizationFunc_qDefaultSurfaceFormat), METH_VARARGS|METH_KEYWORDS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QtDataVisualization_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_TypeF(void)
{
    return _Sbk_QtDataVisualization_Type;
}

static PyType_Slot Sbk_QtDataVisualization_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_slots
};

} //extern "C"


// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualizationQtDataVisualization_SignatureStrings[] = {
    "1:PySide2.QtDataVisualization.QtDataVisualization.qDefaultSurfaceFormat(antialias:bool=true)->PySide2.QtGui.QSurfaceFormat",
    "0:PySide2.QtDataVisualization.QtDataVisualization.qDefaultSurfaceFormat(antialias:bool)->PySide2.QtGui.QSurfaceFormat",
    nullptr}; // Sentinel

void init_QtDataVisualizationQtDataVisualization(PyObject *module)
{
    _Sbk_QtDataVisualization_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QtDataVisualization",
        "QtDataVisualization",
        &Sbk_QtDataVisualization_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_Type);
    InitSignatureStrings(pyType, QtDataVisualizationQtDataVisualization_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_Type), Sbk_QtDataVisualization_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_TypeF());


}
