/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qaccessiblevalueinterface_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAccessibleValueInterfaceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAccessibleValueInterfaceWrapper::QAccessibleValueInterfaceWrapper() : QAccessibleValueInterface()
{
    resetPyMethodCache();
    // ... middle
}

::QVariant QAccessibleValueInterfaceWrapper::currentValue() const
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.currentValue()' not implemented.");
        return ::QVariant();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "currentValue";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.currentValue()' not implemented.");
        return ::QVariant();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAccessibleValueInterface.currentValue", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QVariant QAccessibleValueInterfaceWrapper::maximumValue() const
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.maximumValue()' not implemented.");
        return ::QVariant();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "maximumValue";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.maximumValue()' not implemented.");
        return ::QVariant();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAccessibleValueInterface.maximumValue", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QVariant QAccessibleValueInterfaceWrapper::minimumStepSize() const
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.minimumStepSize()' not implemented.");
        return ::QVariant();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumStepSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.minimumStepSize()' not implemented.");
        return ::QVariant();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAccessibleValueInterface.minimumStepSize", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QVariant QAccessibleValueInterfaceWrapper::minimumValue() const
{
    if (m_PyMethodCache[3]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.minimumValue()' not implemented.");
        return ::QVariant();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumValue";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.minimumValue()' not implemented.");
        return ::QVariant();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAccessibleValueInterface.minimumValue", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAccessibleValueInterfaceWrapper::setCurrentValue(const ::QVariant & value)
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.setCurrentValue()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setCurrentValue";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.setCurrentValue()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QAccessibleValueInterfaceWrapper::~QAccessibleValueInterfaceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAccessibleValueInterface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEVALUEINTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAccessibleValueInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAccessibleValueInterface >()))
        return -1;

    ::QAccessibleValueInterfaceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleValueInterface.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QAccessibleValueInterface()
            cptr = new ::QAccessibleValueInterfaceWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAccessibleValueInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QAccessibleValueInterfaceFunc_currentValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleValueInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEVALUEINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleValueInterface.currentValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentValue()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.currentValue()' not implemented.");
                return {};
            }
            QVariant cppResult = const_cast<const ::QAccessibleValueInterface *>(cppSelf)->currentValue();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleValueInterfaceFunc_maximumValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleValueInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEVALUEINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleValueInterface.maximumValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumValue()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.maximumValue()' not implemented.");
                return {};
            }
            QVariant cppResult = const_cast<const ::QAccessibleValueInterface *>(cppSelf)->maximumValue();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleValueInterfaceFunc_minimumStepSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleValueInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEVALUEINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleValueInterface.minimumStepSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumStepSize()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.minimumStepSize()' not implemented.");
                return {};
            }
            QVariant cppResult = const_cast<const ::QAccessibleValueInterface *>(cppSelf)->minimumStepSize();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleValueInterfaceFunc_minimumValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleValueInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEVALUEINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleValueInterface.minimumValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumValue()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.minimumValue()' not implemented.");
                return {};
            }
            QVariant cppResult = const_cast<const ::QAccessibleValueInterface *>(cppSelf)->minimumValue();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleValueInterfaceFunc_setCurrentValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleValueInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEVALUEINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleValueInterface.setCurrentValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAccessibleValueInterface::setCurrentValue(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setCurrentValue(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleValueInterfaceFunc_setCurrentValue_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurrentValue(QVariant)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAccessibleValueInterface.setCurrentValue()' not implemented.");
                return {};
            }
            cppSelf->setCurrentValue(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAccessibleValueInterfaceFunc_setCurrentValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QAccessibleValueInterface_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAccessibleValueInterface_methods[] = {
    {"currentValue", reinterpret_cast<PyCFunction>(Sbk_QAccessibleValueInterfaceFunc_currentValue), METH_NOARGS},
    {"maximumValue", reinterpret_cast<PyCFunction>(Sbk_QAccessibleValueInterfaceFunc_maximumValue), METH_NOARGS},
    {"minimumStepSize", reinterpret_cast<PyCFunction>(Sbk_QAccessibleValueInterfaceFunc_minimumStepSize), METH_NOARGS},
    {"minimumValue", reinterpret_cast<PyCFunction>(Sbk_QAccessibleValueInterfaceFunc_minimumValue), METH_NOARGS},
    {"setCurrentValue", reinterpret_cast<PyCFunction>(Sbk_QAccessibleValueInterfaceFunc_setCurrentValue), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAccessibleValueInterface_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAccessibleValueInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEVALUEINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAccessibleValueInterfaceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAccessibleValueInterface_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAccessibleValueInterface_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAccessibleValueInterface_Type = nullptr;
static SbkObjectType *Sbk_QAccessibleValueInterface_TypeF(void)
{
    return _Sbk_QAccessibleValueInterface_Type;
}

static PyType_Slot Sbk_QAccessibleValueInterface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAccessibleValueInterface_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAccessibleValueInterface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAccessibleValueInterface_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAccessibleValueInterface_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAccessibleValueInterface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAccessibleValueInterface_spec = {
    "2:PySide2.QtGui.QAccessibleValueInterface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAccessibleValueInterface_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAccessibleValueInterface_PythonToCpp_QAccessibleValueInterface_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAccessibleValueInterface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAccessibleValueInterface_PythonToCpp_QAccessibleValueInterface_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAccessibleValueInterface_TypeF())))
        return QAccessibleValueInterface_PythonToCpp_QAccessibleValueInterface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAccessibleValueInterface_PTR_CppToPython_QAccessibleValueInterface(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAccessibleValueInterface *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAccessibleValueInterface_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAccessibleValueInterface_SignatureStrings[] = {
    "PySide2.QtGui.QAccessibleValueInterface(self)",
    "PySide2.QtGui.QAccessibleValueInterface.currentValue(self)->QVariant",
    "PySide2.QtGui.QAccessibleValueInterface.maximumValue(self)->QVariant",
    "PySide2.QtGui.QAccessibleValueInterface.minimumStepSize(self)->QVariant",
    "PySide2.QtGui.QAccessibleValueInterface.minimumValue(self)->QVariant",
    "PySide2.QtGui.QAccessibleValueInterface.setCurrentValue(self,value:QVariant)",
    nullptr}; // Sentinel

void init_QAccessibleValueInterface(PyObject *module)
{
    _Sbk_QAccessibleValueInterface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAccessibleValueInterface",
        "QAccessibleValueInterface*",
        &Sbk_QAccessibleValueInterface_spec,
        &Shiboken::callCppDestructor< ::QAccessibleValueInterface >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAccessibleValueInterface_Type);
    InitSignatureStrings(pyType, QAccessibleValueInterface_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAccessibleValueInterface_Type), Sbk_QAccessibleValueInterface_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEVALUEINTERFACE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAccessibleValueInterface_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAccessibleValueInterface_TypeF(),
        QAccessibleValueInterface_PythonToCpp_QAccessibleValueInterface_PTR,
        is_QAccessibleValueInterface_PythonToCpp_QAccessibleValueInterface_PTR_Convertible,
        QAccessibleValueInterface_PTR_CppToPython_QAccessibleValueInterface);

    Shiboken::Conversions::registerConverterName(converter, "QAccessibleValueInterface");
    Shiboken::Conversions::registerConverterName(converter, "QAccessibleValueInterface*");
    Shiboken::Conversions::registerConverterName(converter, "QAccessibleValueInterface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAccessibleValueInterface).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAccessibleValueInterfaceWrapper).name());


}
