/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qclipboard_wrapper.h"

// inner classes

// Extra includes
#include <QImage>
#include <QList>
#include <QPixmap>
#include <QtGui/qimage.h>
#include <QtGui/qpixmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QClipboardFunc_clear(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.clear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_clear_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:clear", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QClipboard::clear(QClipboard::Mode)
    if (numArgs == 0) {
        overloadId = 0; // clear(QClipboard::Mode)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // clear(QClipboard::Mode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QClipboardFunc_clear_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[0]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QClipboardFunc_clear_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QClipboardFunc_clear_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QClipboardFunc_clear_TypeError;
            }
        }
        ::QClipboard::Mode cppArg0 = QClipboard::Mode::Clipboard;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // clear(QClipboard::Mode)
            cppSelf->clear(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QClipboardFunc_clear_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QClipboardFunc_image(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.image";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_image_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:image", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QClipboard::image(QClipboard::Mode)const
    if (numArgs == 0) {
        overloadId = 0; // image(QClipboard::Mode)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // image(QClipboard::Mode)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QClipboardFunc_image_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[0]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QClipboardFunc_image_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QClipboardFunc_image_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QClipboardFunc_image_TypeError;
            }
        }
        ::QClipboard::Mode cppArg0 = QClipboard::Mode::Clipboard;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // image(QClipboard::Mode)const
            QImage cppResult = const_cast<const ::QClipboard *>(cppSelf)->image(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QClipboardFunc_image_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QClipboardFunc_mimeData(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.mimeData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_mimeData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:mimeData", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QClipboard::mimeData(QClipboard::Mode)const
    if (numArgs == 0) {
        overloadId = 0; // mimeData(QClipboard::Mode)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // mimeData(QClipboard::Mode)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QClipboardFunc_mimeData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[0]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QClipboardFunc_mimeData_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QClipboardFunc_mimeData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QClipboardFunc_mimeData_TypeError;
            }
        }
        ::QClipboard::Mode cppArg0 = QClipboard::Mode::Clipboard;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // mimeData(QClipboard::Mode)const
            const QMimeData * cppResult = const_cast<const ::QClipboard *>(cppSelf)->mimeData(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMEDATA_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QClipboardFunc_mimeData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QClipboardFunc_ownsClipboard(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.ownsClipboard";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ownsClipboard()const
            bool cppResult = const_cast<const ::QClipboard *>(cppSelf)->ownsClipboard();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QClipboardFunc_ownsFindBuffer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.ownsFindBuffer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ownsFindBuffer()const
            bool cppResult = const_cast<const ::QClipboard *>(cppSelf)->ownsFindBuffer();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QClipboardFunc_ownsSelection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.ownsSelection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ownsSelection()const
            bool cppResult = const_cast<const ::QClipboard *>(cppSelf)->ownsSelection();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QClipboardFunc_pixmap(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.pixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_pixmap_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:pixmap", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QClipboard::pixmap(QClipboard::Mode)const
    if (numArgs == 0) {
        overloadId = 0; // pixmap(QClipboard::Mode)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // pixmap(QClipboard::Mode)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QClipboardFunc_pixmap_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[0]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QClipboardFunc_pixmap_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QClipboardFunc_pixmap_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QClipboardFunc_pixmap_TypeError;
            }
        }
        ::QClipboard::Mode cppArg0 = QClipboard::Mode::Clipboard;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // pixmap(QClipboard::Mode)const
            QPixmap cppResult = const_cast<const ::QClipboard *>(cppSelf)->pixmap(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QClipboardFunc_pixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QClipboardFunc_setImage(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.setImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_setImage_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_setImage_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setImage", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QClipboard::setImage(QImage,QClipboard::Mode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setImage(QImage,QClipboard::Mode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setImage(QImage,QClipboard::Mode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QClipboardFunc_setImage_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QClipboardFunc_setImage_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QClipboardFunc_setImage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QClipboardFunc_setImage_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QImage cppArg0_local;
        ::QImage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QClipboard::Mode cppArg1 = QClipboard::Mode::Clipboard;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setImage(QImage,QClipboard::Mode)
            cppSelf->setImage(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QClipboardFunc_setImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QClipboardFunc_setMimeData(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.setMimeData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_setMimeData_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_setMimeData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setMimeData", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QClipboard::setMimeData(QMimeData*,QClipboard::Mode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMEDATA_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setMimeData(QMimeData*,QClipboard::Mode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setMimeData(QMimeData*,QClipboard::Mode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QClipboardFunc_setMimeData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QClipboardFunc_setMimeData_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QClipboardFunc_setMimeData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QClipboardFunc_setMimeData_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMimeData *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QClipboard::Mode cppArg1 = QClipboard::Mode::Clipboard;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setMimeData(QMimeData*,QClipboard::Mode)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->setMimeData(cppArg0, cppArg1);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            Shiboken::Object::setParent(self, pyArgs[0]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QClipboardFunc_setMimeData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QClipboardFunc_setPixmap(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.setPixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_setPixmap_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_setPixmap_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setPixmap", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QClipboard::setPixmap(QPixmap,QClipboard::Mode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setPixmap(QPixmap,QClipboard::Mode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setPixmap(QPixmap,QClipboard::Mode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QClipboardFunc_setPixmap_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QClipboardFunc_setPixmap_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QClipboardFunc_setPixmap_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QClipboardFunc_setPixmap_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QClipboard::Mode cppArg1 = QClipboard::Mode::Clipboard;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setPixmap(QPixmap,QClipboard::Mode)
            cppSelf->setPixmap(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QClipboardFunc_setPixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QClipboardFunc_setText(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.setText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_setText_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_setText_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setText", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QClipboard::setText(QString,QClipboard::Mode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setText(QString,QClipboard::Mode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setText(QString,QClipboard::Mode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QClipboardFunc_setText_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QClipboardFunc_setText_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QClipboardFunc_setText_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QClipboardFunc_setText_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QClipboard::Mode cppArg1 = QClipboard::Mode::Clipboard;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setText(QString,QClipboard::Mode)
            cppSelf->setText(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QClipboardFunc_setText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QClipboardFunc_supportsFindBuffer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.supportsFindBuffer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsFindBuffer()const
            bool cppResult = const_cast<const ::QClipboard *>(cppSelf)->supportsFindBuffer();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QClipboardFunc_supportsSelection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.supportsSelection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsSelection()const
            bool cppResult = const_cast<const ::QClipboard *>(cppSelf)->supportsSelection();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QClipboardFunc_text(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QClipboard *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QClipboard.text";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QClipboardFunc_text_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:text", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QClipboard::text(QClipboard::Mode)const
    // 1: QClipboard::text(QString&,QClipboard::Mode)const
    if (numArgs == 0) {
        overloadId = 0; // text(QClipboard::Mode)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // text(QString&,QClipboard::Mode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // text(QString&,QClipboard::Mode)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // text(QClipboard::Mode)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QClipboardFunc_text_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // text(QClipboard::Mode mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[0]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QClipboardFunc_text_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QClipboardFunc_text_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QClipboardFunc_text_TypeError;
                }
            }
            ::QClipboard::Mode cppArg0 = QClipboard::Mode::Clipboard;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // text(QClipboard::Mode)const
                QString cppResult = const_cast<const ::QClipboard *>(cppSelf)->text(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // text(QString & subtype, QClipboard::Mode mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QClipboardFunc_text_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QClipboardFunc_text_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QClipboardFunc_text_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QClipboard::Mode cppArg1 = QClipboard::Clipboard;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // text(QString&,QClipboard::Mode)const
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qclipboard-text)]
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                ::QString retval_ = cppSelf->text(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = PyTuple_New(2);
                PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &retval_));
                PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg0));
                // END of custom code block [file: ../glue/qtgui.cpp (qclipboard-text)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QClipboardFunc_text_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QClipboard_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QClipboard_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_clear), METH_VARARGS|METH_KEYWORDS},
    {"image", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_image), METH_VARARGS|METH_KEYWORDS},
    {"mimeData", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_mimeData), METH_VARARGS|METH_KEYWORDS},
    {"ownsClipboard", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_ownsClipboard), METH_NOARGS},
    {"ownsFindBuffer", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_ownsFindBuffer), METH_NOARGS},
    {"ownsSelection", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_ownsSelection), METH_NOARGS},
    {"pixmap", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_pixmap), METH_VARARGS|METH_KEYWORDS},
    {"setImage", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_setImage), METH_VARARGS|METH_KEYWORDS},
    {"setMimeData", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_setMimeData), METH_VARARGS|METH_KEYWORDS},
    {"setPixmap", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_setPixmap), METH_VARARGS|METH_KEYWORDS},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_setText), METH_VARARGS|METH_KEYWORDS},
    {"supportsFindBuffer", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_supportsFindBuffer), METH_NOARGS},
    {"supportsSelection", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_supportsSelection), METH_NOARGS},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QClipboardFunc_text), METH_VARARGS|METH_KEYWORDS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QClipboard_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QClipboard_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QClipboard_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QClipboard_Type = nullptr;
static SbkObjectType *Sbk_QClipboard_TypeF(void)
{
    return _Sbk_QClipboard_Type;
}

static PyType_Slot Sbk_QClipboard_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(SbkDeallocWrapperWithPrivateDtor)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QClipboard_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QClipboard_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QClipboard_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QClipboard_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QClipboard_spec = {
    "2:PySide2.QtGui.QClipboard",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QClipboard_slots
};

} //extern "C"

static void *Sbk_QClipboard_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QClipboard *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QClipboard_Mode_PythonToCpp_QClipboard_Mode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QClipboard::Mode *>(cppOut) =
        static_cast<::QClipboard::Mode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QClipboard_Mode_PythonToCpp_QClipboard_Mode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX]))
        return QClipboard_Mode_PythonToCpp_QClipboard_Mode;
    return {};
}
static PyObject *QClipboard_Mode_CppToPython_QClipboard_Mode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QClipboard::Mode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QClipboard_PythonToCpp_QClipboard_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QClipboard_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QClipboard_PythonToCpp_QClipboard_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QClipboard_TypeF())))
        return QClipboard_PythonToCpp_QClipboard_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QClipboard_PTR_CppToPython_QClipboard(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QClipboard *>(const_cast<void *>(cppIn)), Sbk_QClipboard_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QClipboard_SignatureStrings[] = {
    "PySide2.QtGui.QClipboard.clear(self,mode:PySide2.QtGui.QClipboard.Mode=Clipboard)",
    "PySide2.QtGui.QClipboard.image(self,mode:PySide2.QtGui.QClipboard.Mode=Clipboard)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QClipboard.mimeData(self,mode:PySide2.QtGui.QClipboard.Mode=Clipboard)->PySide2.QtCore.QMimeData",
    "PySide2.QtGui.QClipboard.ownsClipboard(self)->bool",
    "PySide2.QtGui.QClipboard.ownsFindBuffer(self)->bool",
    "PySide2.QtGui.QClipboard.ownsSelection(self)->bool",
    "PySide2.QtGui.QClipboard.pixmap(self,mode:PySide2.QtGui.QClipboard.Mode=Clipboard)->PySide2.QtGui.QPixmap",
    "PySide2.QtGui.QClipboard.setImage(self,arg__1:PySide2.QtGui.QImage,mode:PySide2.QtGui.QClipboard.Mode=Clipboard)",
    "PySide2.QtGui.QClipboard.setMimeData(self,data:PySide2.QtCore.QMimeData,mode:PySide2.QtGui.QClipboard.Mode=Clipboard)",
    "PySide2.QtGui.QClipboard.setPixmap(self,arg__1:PySide2.QtGui.QPixmap,mode:PySide2.QtGui.QClipboard.Mode=Clipboard)",
    "PySide2.QtGui.QClipboard.setText(self,arg__1:QString,mode:PySide2.QtGui.QClipboard.Mode=Clipboard)",
    "PySide2.QtGui.QClipboard.supportsFindBuffer(self)->bool",
    "PySide2.QtGui.QClipboard.supportsSelection(self)->bool",
    "1:PySide2.QtGui.QClipboard.text(self,mode:PySide2.QtGui.QClipboard.Mode=Clipboard)->QString",
    "0:PySide2.QtGui.QClipboard.text(self,subtype:QString,mode:PySide2.QtGui.QClipboard.Mode=QClipboard.Clipboard)->QString",
    nullptr}; // Sentinel

void init_QClipboard(PyObject *module)
{
    _Sbk_QClipboard_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QClipboard",
        "QClipboard*",
        &Sbk_QClipboard_spec,
        0,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QClipboard_Type);
    InitSignatureStrings(pyType, QClipboard_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QClipboard_Type), Sbk_QClipboard_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QClipboard_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QClipboard_TypeF(),
        QClipboard_PythonToCpp_QClipboard_PTR,
        is_QClipboard_PythonToCpp_QClipboard_PTR_Convertible,
        QClipboard_PTR_CppToPython_QClipboard);

    Shiboken::Conversions::registerConverterName(converter, "QClipboard");
    Shiboken::Conversions::registerConverterName(converter, "QClipboard*");
    Shiboken::Conversions::registerConverterName(converter, "QClipboard&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QClipboard).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QClipboard_TypeF(), &Sbk_QClipboard_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Mode'.
    SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QClipboard_TypeF(),
        "Mode",
        "2:PySide2.QtGui.QClipboard.Mode",
        "QClipboard::Mode");
    if (!SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX],
        Sbk_QClipboard_TypeF(), "Clipboard", (long) QClipboard::Mode::Clipboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX],
        Sbk_QClipboard_TypeF(), "Selection", (long) QClipboard::Mode::Selection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX],
        Sbk_QClipboard_TypeF(), "FindBuffer", (long) QClipboard::Mode::FindBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX],
        Sbk_QClipboard_TypeF(), "LastMode", (long) QClipboard::Mode::LastMode))
        return;
    // Register converter for enum 'QClipboard::Mode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX],
            QClipboard_Mode_CppToPython_QClipboard_Mode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QClipboard_Mode_PythonToCpp_QClipboard_Mode,
            is_QClipboard_Mode_PythonToCpp_QClipboard_Mode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QCLIPBOARD_MODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QClipboard::Mode");
        Shiboken::Conversions::registerConverterName(converter, "Mode");
    }
    // End of 'Mode' enum.

    PySide::Signal::registerSignals(Sbk_QClipboard_TypeF(), &::QClipboard::staticMetaObject);
    qRegisterMetaType< ::QClipboard::Mode >("QClipboard::Mode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QClipboard_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QClipboard_TypeF(), &::QClipboard::staticMetaObject, sizeof(::QClipboard));
}
