/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qcolorconstants_svg_wrapper.h"

// inner classes

// Extra includes
#include <QColor>


#include <cctype>
#include <cstring>

using namespace QColorConstants;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {

static const char *Sbk_QColorConstants_Svg_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QColorConstants_Svg_methods[] = {

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QColorConstants_Svg_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QColorConstants_Svg_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QColorConstants_Svg_Type = nullptr;
static SbkObjectType *Sbk_QColorConstants_Svg_TypeF(void)
{
    return _Sbk_QColorConstants_Svg_Type;
}

static PyType_Slot Sbk_QColorConstants_Svg_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QColorConstants_Svg_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QColorConstants_Svg_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QColorConstants_Svg_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QColorConstants_Svg_spec = {
    "2:PySide2.QtGui.QColorConstants.Svg",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QColorConstants_Svg_slots
};

} //extern "C"


// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtGuiQColorConstants_Svg_SignatureStrings[] = {
    nullptr}; // Sentinel

void init_QtGuiQColorConstants_Svg(PyObject *enclosingClass)
{
    _Sbk_QColorConstants_Svg_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Svg",
        "QColorConstants::Svg",
        &Sbk_QColorConstants_Svg_spec,
        0,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QColorConstants_Svg_Type);
    InitSignatureStrings(pyType, QtGuiQColorConstants_Svg_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QColorConstants_Svg_Type), Sbk_QColorConstants_Svg_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QtGuiQCOLORCONSTANTS_SVG_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QColorConstants_Svg_TypeF());


}

void init_QtGuiQColorConstants_SvgStaticFields()
{
    auto dict = reinterpret_cast<PyTypeObject *>(Sbk_QColorConstants_Svg_TypeF())->tp_dict;
    PyDict_SetItemString(dict, "aliceblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::aliceblue));
    PyDict_SetItemString(dict, "antiquewhite",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::antiquewhite));
    PyDict_SetItemString(dict, "aqua",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::aqua));
    PyDict_SetItemString(dict, "aquamarine",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::aquamarine));
    PyDict_SetItemString(dict, "azure",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::azure));
    PyDict_SetItemString(dict, "beige",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::beige));
    PyDict_SetItemString(dict, "bisque",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::bisque));
    PyDict_SetItemString(dict, "black",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::black));
    PyDict_SetItemString(dict, "blanchedalmond",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::blanchedalmond));
    PyDict_SetItemString(dict, "blue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::blue));
    PyDict_SetItemString(dict, "blueviolet",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::blueviolet));
    PyDict_SetItemString(dict, "brown",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::brown));
    PyDict_SetItemString(dict, "burlywood",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::burlywood));
    PyDict_SetItemString(dict, "cadetblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::cadetblue));
    PyDict_SetItemString(dict, "chartreuse",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::chartreuse));
    PyDict_SetItemString(dict, "chocolate",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::chocolate));
    PyDict_SetItemString(dict, "coral",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::coral));
    PyDict_SetItemString(dict, "cornflowerblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::cornflowerblue));
    PyDict_SetItemString(dict, "cornsilk",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::cornsilk));
    PyDict_SetItemString(dict, "crimson",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::crimson));
    PyDict_SetItemString(dict, "cyan",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::cyan));
    PyDict_SetItemString(dict, "darkblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkblue));
    PyDict_SetItemString(dict, "darkcyan",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkcyan));
    PyDict_SetItemString(dict, "darkgoldenrod",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkgoldenrod));
    PyDict_SetItemString(dict, "darkgray",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkgray));
    PyDict_SetItemString(dict, "darkgreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkgreen));
    PyDict_SetItemString(dict, "darkgrey",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkgrey));
    PyDict_SetItemString(dict, "darkkhaki",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkkhaki));
    PyDict_SetItemString(dict, "darkmagenta",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkmagenta));
    PyDict_SetItemString(dict, "darkolivegreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkolivegreen));
    PyDict_SetItemString(dict, "darkorange",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkorange));
    PyDict_SetItemString(dict, "darkorchid",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkorchid));
    PyDict_SetItemString(dict, "darkred",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkred));
    PyDict_SetItemString(dict, "darksalmon",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darksalmon));
    PyDict_SetItemString(dict, "darkseagreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkseagreen));
    PyDict_SetItemString(dict, "darkslateblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkslateblue));
    PyDict_SetItemString(dict, "darkslategray",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkslategray));
    PyDict_SetItemString(dict, "darkslategrey",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkslategrey));
    PyDict_SetItemString(dict, "darkturquoise",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkturquoise));
    PyDict_SetItemString(dict, "darkviolet",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::darkviolet));
    PyDict_SetItemString(dict, "deeppink",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::deeppink));
    PyDict_SetItemString(dict, "deepskyblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::deepskyblue));
    PyDict_SetItemString(dict, "dimgray",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::dimgray));
    PyDict_SetItemString(dict, "dimgrey",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::dimgrey));
    PyDict_SetItemString(dict, "dodgerblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::dodgerblue));
    PyDict_SetItemString(dict, "firebrick",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::firebrick));
    PyDict_SetItemString(dict, "floralwhite",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::floralwhite));
    PyDict_SetItemString(dict, "forestgreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::forestgreen));
    PyDict_SetItemString(dict, "fuchsia",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::fuchsia));
    PyDict_SetItemString(dict, "gainsboro",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::gainsboro));
    PyDict_SetItemString(dict, "ghostwhite",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::ghostwhite));
    PyDict_SetItemString(dict, "gold",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::gold));
    PyDict_SetItemString(dict, "goldenrod",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::goldenrod));
    PyDict_SetItemString(dict, "gray",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::gray));
    PyDict_SetItemString(dict, "green",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::green));
    PyDict_SetItemString(dict, "greenyellow",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::greenyellow));
    PyDict_SetItemString(dict, "grey",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::grey));
    PyDict_SetItemString(dict, "honeydew",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::honeydew));
    PyDict_SetItemString(dict, "hotpink",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::hotpink));
    PyDict_SetItemString(dict, "indianred",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::indianred));
    PyDict_SetItemString(dict, "indigo",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::indigo));
    PyDict_SetItemString(dict, "ivory",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::ivory));
    PyDict_SetItemString(dict, "khaki",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::khaki));
    PyDict_SetItemString(dict, "lavender",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lavender));
    PyDict_SetItemString(dict, "lavenderblush",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lavenderblush));
    PyDict_SetItemString(dict, "lawngreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lawngreen));
    PyDict_SetItemString(dict, "lemonchiffon",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lemonchiffon));
    PyDict_SetItemString(dict, "lightblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightblue));
    PyDict_SetItemString(dict, "lightcoral",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightcoral));
    PyDict_SetItemString(dict, "lightcyan",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightcyan));
    PyDict_SetItemString(dict, "lightgoldenrodyellow",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightgoldenrodyellow));
    PyDict_SetItemString(dict, "lightgray",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightgray));
    PyDict_SetItemString(dict, "lightgreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightgreen));
    PyDict_SetItemString(dict, "lightgrey",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightgrey));
    PyDict_SetItemString(dict, "lightpink",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightpink));
    PyDict_SetItemString(dict, "lightsalmon",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightsalmon));
    PyDict_SetItemString(dict, "lightseagreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightseagreen));
    PyDict_SetItemString(dict, "lightskyblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightskyblue));
    PyDict_SetItemString(dict, "lightslategray",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightslategray));
    PyDict_SetItemString(dict, "lightslategrey",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightslategrey));
    PyDict_SetItemString(dict, "lightsteelblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightsteelblue));
    PyDict_SetItemString(dict, "lightyellow",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lightyellow));
    PyDict_SetItemString(dict, "lime",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::lime));
    PyDict_SetItemString(dict, "limegreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::limegreen));
    PyDict_SetItemString(dict, "linen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::linen));
    PyDict_SetItemString(dict, "magenta",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::magenta));
    PyDict_SetItemString(dict, "maroon",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::maroon));
    PyDict_SetItemString(dict, "mediumaquamarine",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::mediumaquamarine));
    PyDict_SetItemString(dict, "mediumblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::mediumblue));
    PyDict_SetItemString(dict, "mediumorchid",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::mediumorchid));
    PyDict_SetItemString(dict, "mediumpurple",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::mediumpurple));
    PyDict_SetItemString(dict, "mediumseagreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::mediumseagreen));
    PyDict_SetItemString(dict, "mediumslateblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::mediumslateblue));
    PyDict_SetItemString(dict, "mediumspringgreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::mediumspringgreen));
    PyDict_SetItemString(dict, "mediumturquoise",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::mediumturquoise));
    PyDict_SetItemString(dict, "mediumvioletred",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::mediumvioletred));
    PyDict_SetItemString(dict, "midnightblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::midnightblue));
    PyDict_SetItemString(dict, "mintcream",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::mintcream));
    PyDict_SetItemString(dict, "mistyrose",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::mistyrose));
    PyDict_SetItemString(dict, "moccasin",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::moccasin));
    PyDict_SetItemString(dict, "navajowhite",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::navajowhite));
    PyDict_SetItemString(dict, "navy",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::navy));
    PyDict_SetItemString(dict, "oldlace",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::oldlace));
    PyDict_SetItemString(dict, "olive",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::olive));
    PyDict_SetItemString(dict, "olivedrab",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::olivedrab));
    PyDict_SetItemString(dict, "orange",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::orange));
    PyDict_SetItemString(dict, "orangered",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::orangered));
    PyDict_SetItemString(dict, "orchid",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::orchid));
    PyDict_SetItemString(dict, "palegoldenrod",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::palegoldenrod));
    PyDict_SetItemString(dict, "palegreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::palegreen));
    PyDict_SetItemString(dict, "paleturquoise",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::paleturquoise));
    PyDict_SetItemString(dict, "palevioletred",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::palevioletred));
    PyDict_SetItemString(dict, "papayawhip",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::papayawhip));
    PyDict_SetItemString(dict, "peachpuff",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::peachpuff));
    PyDict_SetItemString(dict, "peru",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::peru));
    PyDict_SetItemString(dict, "pink",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::pink));
    PyDict_SetItemString(dict, "plum",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::plum));
    PyDict_SetItemString(dict, "powderblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::powderblue));
    PyDict_SetItemString(dict, "purple",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::purple));
    PyDict_SetItemString(dict, "red",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::red));
    PyDict_SetItemString(dict, "rosybrown",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::rosybrown));
    PyDict_SetItemString(dict, "royalblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::royalblue));
    PyDict_SetItemString(dict, "saddlebrown",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::saddlebrown));
    PyDict_SetItemString(dict, "salmon",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::salmon));
    PyDict_SetItemString(dict, "sandybrown",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::sandybrown));
    PyDict_SetItemString(dict, "seagreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::seagreen));
    PyDict_SetItemString(dict, "seashell",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::seashell));
    PyDict_SetItemString(dict, "sienna",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::sienna));
    PyDict_SetItemString(dict, "silver",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::silver));
    PyDict_SetItemString(dict, "skyblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::skyblue));
    PyDict_SetItemString(dict, "slateblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::slateblue));
    PyDict_SetItemString(dict, "slategray",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::slategray));
    PyDict_SetItemString(dict, "slategrey",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::slategrey));
    PyDict_SetItemString(dict, "snow",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::snow));
    PyDict_SetItemString(dict, "springgreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::springgreen));
    PyDict_SetItemString(dict, "steelblue",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::steelblue));
    PyDict_SetItemString(dict, "tan",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::tan));
    PyDict_SetItemString(dict, "teal",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::teal));
    PyDict_SetItemString(dict, "thistle",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::thistle));
    PyDict_SetItemString(dict, "tomato",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::tomato));
    PyDict_SetItemString(dict, "turquoise",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::turquoise));
    PyDict_SetItemString(dict, "violet",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::violet));
    PyDict_SetItemString(dict, "wheat",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::wheat));
    PyDict_SetItemString(dict, "white",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::white));
    PyDict_SetItemString(dict, "whitesmoke",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::whitesmoke));
    PyDict_SetItemString(dict, "yellow",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::yellow));
    PyDict_SetItemString(dict, "yellowgreen",
                         Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &QColorConstants::Svg::yellowgreen));

}
