/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qfontdatabase_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QStringList>
#include <QtGui/qfont.h>
#include <QtGui/qfontinfo.h>
#include <qbytearray.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFontDatabase_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFontDatabase >()))
        return -1;

    ::QFontDatabase *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QFontDatabase", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QFontDatabase::QFontDatabase()
    // 1: QFontDatabase::QFontDatabase(QFontDatabase)
    if (numArgs == 0) {
        overloadId = 0; // QFontDatabase()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QFontDatabase(QFontDatabase)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabase_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QFontDatabase()
        {

            if (!PyErr_Occurred()) {
                // QFontDatabase()
                cptr = new ::QFontDatabase();
            }
            break;
        }
        case 1: // QFontDatabase(const QFontDatabase & QFontDatabase)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFontDatabase cppArg0_local;
            ::QFontDatabase *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QFontDatabase(QFontDatabase)
                cptr = new ::QFontDatabase(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFontDatabase >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QFontDatabase_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QFontDatabase_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QFontDatabaseFunc_addApplicationFont(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.addApplicationFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QFontDatabase::addApplicationFont(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // addApplicationFont(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_addApplicationFont_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addApplicationFont(QString)
            int cppResult = ::QFontDatabase::addApplicationFont(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_addApplicationFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_addApplicationFontFromData(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.addApplicationFontFromData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QFontDatabase::addApplicationFontFromData(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // addApplicationFontFromData(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_addApplicationFontFromData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // addApplicationFontFromData(QByteArray)
            int cppResult = ::QFontDatabase::addApplicationFontFromData(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_addApplicationFontFromData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_applicationFontFamilies(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.applicationFontFamilies";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QFontDatabase::applicationFontFamilies(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // applicationFontFamilies(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_applicationFontFamilies_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // applicationFontFamilies(int)
            QStringList cppResult = ::QFontDatabase::applicationFontFamilies(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_applicationFontFamilies_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_bold(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.bold";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "bold", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFontDatabase::bold(QString,QString)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // bold(QString,QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_bold_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // bold(QString,QString)const
            bool cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->bold(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_bold_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_families(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.families";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontDatabaseFunc_families_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:families", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QFontDatabase::families(QFontDatabase::WritingSystem)const
    if (numArgs == 0) {
        overloadId = 0; // families(QFontDatabase::WritingSystem)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // families(QFontDatabase::WritingSystem)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_families_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_writingSystem = Shiboken::String::createStaticString("writingSystem");
            if (PyDict_Contains(kwds, key_writingSystem)) {
                value = PyDict_GetItem(kwds, key_writingSystem);
                if (value && pyArgs[0]) {
                    errInfo = key_writingSystem;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontDatabaseFunc_families_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QFontDatabaseFunc_families_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_writingSystem);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFontDatabaseFunc_families_TypeError;
            }
        }
        ::QFontDatabase::WritingSystem cppArg0 = QFontDatabase::WritingSystem::Any;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // families(QFontDatabase::WritingSystem)const
            QStringList cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->families(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_families_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_font(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.font";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "font", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QFontDatabase::font(QString,QString,int)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // font(QString,QString,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_font_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // font(QString,QString,int)const
            QFont cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->font(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_font_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_hasFamily(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.hasFamily";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontDatabase::hasFamily(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // hasFamily(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_hasFamily_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasFamily(QString)const
            bool cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->hasFamily(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_hasFamily_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_isBitmapScalable(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.isBitmapScalable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontDatabaseFunc_isBitmapScalable_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontDatabaseFunc_isBitmapScalable_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:isBitmapScalable", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFontDatabase::isBitmapScalable(QString,QString)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // isBitmapScalable(QString,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // isBitmapScalable(QString,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_isBitmapScalable_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_style = Shiboken::String::createStaticString("style");
            if (PyDict_Contains(kwds, key_style)) {
                value = PyDict_GetItem(kwds, key_style);
                if (value && pyArgs[1]) {
                    errInfo = key_style;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontDatabaseFunc_isBitmapScalable_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFontDatabaseFunc_isBitmapScalable_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_style);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFontDatabaseFunc_isBitmapScalable_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // isBitmapScalable(QString,QString)const
            bool cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->isBitmapScalable(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_isBitmapScalable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_isFixedPitch(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.isFixedPitch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontDatabaseFunc_isFixedPitch_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontDatabaseFunc_isFixedPitch_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:isFixedPitch", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFontDatabase::isFixedPitch(QString,QString)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // isFixedPitch(QString,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // isFixedPitch(QString,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_isFixedPitch_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_style = Shiboken::String::createStaticString("style");
            if (PyDict_Contains(kwds, key_style)) {
                value = PyDict_GetItem(kwds, key_style);
                if (value && pyArgs[1]) {
                    errInfo = key_style;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontDatabaseFunc_isFixedPitch_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFontDatabaseFunc_isFixedPitch_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_style);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFontDatabaseFunc_isFixedPitch_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // isFixedPitch(QString,QString)const
            bool cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->isFixedPitch(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_isFixedPitch_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_isPrivateFamily(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.isPrivateFamily";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontDatabase::isPrivateFamily(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // isPrivateFamily(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_isPrivateFamily_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isPrivateFamily(QString)const
            bool cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->isPrivateFamily(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_isPrivateFamily_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_isScalable(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.isScalable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontDatabaseFunc_isScalable_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontDatabaseFunc_isScalable_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:isScalable", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFontDatabase::isScalable(QString,QString)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // isScalable(QString,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // isScalable(QString,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_isScalable_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_style = Shiboken::String::createStaticString("style");
            if (PyDict_Contains(kwds, key_style)) {
                value = PyDict_GetItem(kwds, key_style);
                if (value && pyArgs[1]) {
                    errInfo = key_style;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontDatabaseFunc_isScalable_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFontDatabaseFunc_isScalable_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_style);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFontDatabaseFunc_isScalable_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // isScalable(QString,QString)const
            bool cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->isScalable(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_isScalable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_isSmoothlyScalable(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.isSmoothlyScalable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontDatabaseFunc_isSmoothlyScalable_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontDatabaseFunc_isSmoothlyScalable_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:isSmoothlyScalable", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFontDatabase::isSmoothlyScalable(QString,QString)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // isSmoothlyScalable(QString,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // isSmoothlyScalable(QString,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_isSmoothlyScalable_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_style = Shiboken::String::createStaticString("style");
            if (PyDict_Contains(kwds, key_style)) {
                value = PyDict_GetItem(kwds, key_style);
                if (value && pyArgs[1]) {
                    errInfo = key_style;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontDatabaseFunc_isSmoothlyScalable_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFontDatabaseFunc_isSmoothlyScalable_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_style);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFontDatabaseFunc_isSmoothlyScalable_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // isSmoothlyScalable(QString,QString)const
            bool cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->isSmoothlyScalable(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_isSmoothlyScalable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_italic(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.italic";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "italic", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFontDatabase::italic(QString,QString)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // italic(QString,QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_italic_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // italic(QString,QString)const
            bool cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->italic(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_italic_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_pointSizes(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.pointSizes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFontDatabaseFunc_pointSizes_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFontDatabaseFunc_pointSizes_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:pointSizes", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFontDatabase::pointSizes(QString,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // pointSizes(QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // pointSizes(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_pointSizes_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_style = Shiboken::String::createStaticString("style");
            if (PyDict_Contains(kwds, key_style)) {
                value = PyDict_GetItem(kwds, key_style);
                if (value && pyArgs[1]) {
                    errInfo = key_style;
                    Py_INCREF(errInfo);
                    goto Sbk_QFontDatabaseFunc_pointSizes_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFontDatabaseFunc_pointSizes_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_style);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFontDatabaseFunc_pointSizes_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // pointSizes(QString,QString)
            QList<int > cppResult = cppSelf->pointSizes(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_pointSizes_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_removeAllApplicationFonts(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.removeAllApplicationFonts";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeAllApplicationFonts()
            bool cppResult = ::QFontDatabase::removeAllApplicationFonts();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontDatabaseFunc_removeApplicationFont(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.removeApplicationFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QFontDatabase::removeApplicationFont(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // removeApplicationFont(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_removeApplicationFont_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeApplicationFont(int)
            bool cppResult = ::QFontDatabase::removeApplicationFont(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_removeApplicationFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_smoothSizes(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.smoothSizes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "smoothSizes", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFontDatabase::smoothSizes(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // smoothSizes(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_smoothSizes_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // smoothSizes(QString,QString)
            QList<int > cppResult = cppSelf->smoothSizes(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_smoothSizes_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_standardSizes(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.standardSizes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // standardSizes()
            QList<int > cppResult = ::QFontDatabase::standardSizes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontDatabaseFunc_styleString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.styleString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontDatabase::styleString(QFont)
    // 1: QFontDatabase::styleString(QFontInfo)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
        overloadId = 0; // styleString(QFont)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX]), (pyArg)))) {
        overloadId = 1; // styleString(QFontInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_styleString_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // styleString(const QFont & font)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // styleString(QFont)
                QString cppResult = cppSelf->styleString(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // styleString(const QFontInfo & fontInfo)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QFontInfo cppArg0_local = ::QFontInfo(::QFont());
            ::QFontInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // styleString(QFontInfo)
                QString cppResult = cppSelf->styleString(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_styleString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_styles(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.styles";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontDatabase::styles(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // styles(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_styles_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // styles(QString)const
            QStringList cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->styles(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_styles_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_supportsThreadedFontRendering(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.supportsThreadedFontRendering";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsThreadedFontRendering()
            bool cppResult = ::QFontDatabase::supportsThreadedFontRendering();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontDatabaseFunc_systemFont(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.systemFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QFontDatabase::systemFont(QFontDatabase::SystemFont)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_SYSTEMFONT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // systemFont(QFontDatabase::SystemFont)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_systemFont_TypeError;

    // Call function/method
    {
        ::QFontDatabase::SystemFont cppArg0{QFontDatabase::GeneralFont};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // systemFont(QFontDatabase::SystemFont)
            QFont cppResult = ::QFontDatabase::systemFont(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_systemFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_weight(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.weight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "weight", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFontDatabase::weight(QString,QString)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // weight(QString,QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_weight_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // weight(QString,QString)const
            int cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->weight(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_weight_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_writingSystemName(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.writingSystemName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QFontDatabase::writingSystemName(QFontDatabase::WritingSystem)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX])->converter, (pyArg)))) {
        overloadId = 0; // writingSystemName(QFontDatabase::WritingSystem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_writingSystemName_TypeError;

    // Call function/method
    {
        ::QFontDatabase::WritingSystem cppArg0{QFontDatabase::Any};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // writingSystemName(QFontDatabase::WritingSystem)
            QString cppResult = ::QFontDatabase::writingSystemName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_writingSystemName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_writingSystemSample(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.writingSystemSample";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QFontDatabase::writingSystemSample(QFontDatabase::WritingSystem)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX])->converter, (pyArg)))) {
        overloadId = 0; // writingSystemSample(QFontDatabase::WritingSystem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_writingSystemSample_TypeError;

    // Call function/method
    {
        ::QFontDatabase::WritingSystem cppArg0{QFontDatabase::Any};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // writingSystemSample(QFontDatabase::WritingSystem)
            QString cppResult = ::QFontDatabase::writingSystemSample(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_writingSystemSample_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabaseFunc_writingSystems(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontDatabase.writingSystems";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "writingSystems", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QFontDatabase::writingSystems()const
    // 1: QFontDatabase::writingSystems(QString)const
    if (numArgs == 0) {
        overloadId = 0; // writingSystems()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // writingSystems(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontDatabaseFunc_writingSystems_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // writingSystems() const
        {

            if (!PyErr_Occurred()) {
                // writingSystems()const
                QList<QFontDatabase::WritingSystem > cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->writingSystems();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QFONTDATABASE_WRITINGSYSTEM_IDX], &cppResult);
            }
            break;
        }
        case 1: // writingSystems(const QString & family) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // writingSystems(QString)const
                QList<QFontDatabase::WritingSystem > cppResult = const_cast<const ::QFontDatabase *>(cppSelf)->writingSystems(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QFONTDATABASE_WRITINGSYSTEM_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFontDatabaseFunc_writingSystems_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontDatabase___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QFontDatabase_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFontDatabase_methods[] = {
    {"addApplicationFont", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_addApplicationFont), METH_O|METH_STATIC},
    {"addApplicationFontFromData", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_addApplicationFontFromData), METH_O|METH_STATIC},
    {"applicationFontFamilies", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_applicationFontFamilies), METH_O|METH_STATIC},
    {"bold", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_bold), METH_VARARGS},
    {"families", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_families), METH_VARARGS|METH_KEYWORDS},
    {"font", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_font), METH_VARARGS},
    {"hasFamily", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_hasFamily), METH_O},
    {"isBitmapScalable", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_isBitmapScalable), METH_VARARGS|METH_KEYWORDS},
    {"isFixedPitch", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_isFixedPitch), METH_VARARGS|METH_KEYWORDS},
    {"isPrivateFamily", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_isPrivateFamily), METH_O},
    {"isScalable", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_isScalable), METH_VARARGS|METH_KEYWORDS},
    {"isSmoothlyScalable", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_isSmoothlyScalable), METH_VARARGS|METH_KEYWORDS},
    {"italic", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_italic), METH_VARARGS},
    {"pointSizes", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_pointSizes), METH_VARARGS|METH_KEYWORDS},
    {"removeAllApplicationFonts", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_removeAllApplicationFonts), METH_NOARGS|METH_STATIC},
    {"removeApplicationFont", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_removeApplicationFont), METH_O|METH_STATIC},
    {"smoothSizes", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_smoothSizes), METH_VARARGS},
    {"standardSizes", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_standardSizes), METH_NOARGS|METH_STATIC},
    {"styleString", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_styleString), METH_O},
    {"styles", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_styles), METH_O},
    {"supportsThreadedFontRendering", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_supportsThreadedFontRendering), METH_NOARGS|METH_STATIC},
    {"systemFont", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_systemFont), METH_O|METH_STATIC},
    {"weight", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_weight), METH_VARARGS},
    {"writingSystemName", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_writingSystemName), METH_O|METH_STATIC},
    {"writingSystemSample", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_writingSystemSample), METH_O|METH_STATIC},
    {"writingSystems", reinterpret_cast<PyCFunction>(Sbk_QFontDatabaseFunc_writingSystems), METH_VARARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QFontDatabase___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QFontDatabase_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFontDatabase_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFontDatabase_Type = nullptr;
static SbkObjectType *Sbk_QFontDatabase_TypeF(void)
{
    return _Sbk_QFontDatabase_Type;
}

static PyType_Slot Sbk_QFontDatabase_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFontDatabase_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFontDatabase_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFontDatabase_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFontDatabase_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QFontDatabase_spec = {
    "2:PySide2.QtGui.QFontDatabase",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFontDatabase_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QFontDatabase_WritingSystem_PythonToCpp_QFontDatabase_WritingSystem(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFontDatabase::WritingSystem *>(cppOut) =
        static_cast<::QFontDatabase::WritingSystem>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFontDatabase_WritingSystem_PythonToCpp_QFontDatabase_WritingSystem_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX]))
        return QFontDatabase_WritingSystem_PythonToCpp_QFontDatabase_WritingSystem;
    return {};
}
static PyObject *QFontDatabase_WritingSystem_CppToPython_QFontDatabase_WritingSystem(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFontDatabase::WritingSystem *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX], castCppIn);

}

static void QFontDatabase_SystemFont_PythonToCpp_QFontDatabase_SystemFont(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFontDatabase::SystemFont *>(cppOut) =
        static_cast<::QFontDatabase::SystemFont>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFontDatabase_SystemFont_PythonToCpp_QFontDatabase_SystemFont_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_SYSTEMFONT_IDX]))
        return QFontDatabase_SystemFont_PythonToCpp_QFontDatabase_SystemFont;
    return {};
}
static PyObject *QFontDatabase_SystemFont_CppToPython_QFontDatabase_SystemFont(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFontDatabase::SystemFont *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_SYSTEMFONT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFontDatabase_PythonToCpp_QFontDatabase_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFontDatabase_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFontDatabase_PythonToCpp_QFontDatabase_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFontDatabase_TypeF())))
        return QFontDatabase_PythonToCpp_QFontDatabase_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFontDatabase_PTR_CppToPython_QFontDatabase(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QFontDatabase *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QFontDatabase_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QFontDatabase_COPY_CppToPython_QFontDatabase(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QFontDatabase_TypeF(), new ::QFontDatabase(*reinterpret_cast<const ::QFontDatabase *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QFontDatabase_PythonToCpp_QFontDatabase_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFontDatabase *>(cppOut) = *reinterpret_cast< ::QFontDatabase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QFontDatabase_PythonToCpp_QFontDatabase_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFontDatabase_TypeF())))
        return QFontDatabase_PythonToCpp_QFontDatabase_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFontDatabase_SignatureStrings[] = {
    "1:PySide2.QtGui.QFontDatabase(self)",
    "0:PySide2.QtGui.QFontDatabase(self,QFontDatabase:PySide2.QtGui.QFontDatabase)",
    "PySide2.QtGui.QFontDatabase.addApplicationFont(fileName:QString)->int",
    "PySide2.QtGui.QFontDatabase.addApplicationFontFromData(fontData:PySide2.QtCore.QByteArray)->int",
    "PySide2.QtGui.QFontDatabase.applicationFontFamilies(id:int)->QStringList",
    "PySide2.QtGui.QFontDatabase.bold(self,family:QString,style:QString)->bool",
    "PySide2.QtGui.QFontDatabase.families(self,writingSystem:PySide2.QtGui.QFontDatabase.WritingSystem=Any)->QStringList",
    "PySide2.QtGui.QFontDatabase.font(self,family:QString,style:QString,pointSize:int)->PySide2.QtGui.QFont",
    "PySide2.QtGui.QFontDatabase.hasFamily(self,family:QString)->bool",
    "PySide2.QtGui.QFontDatabase.isBitmapScalable(self,family:QString,style:QString=QString())->bool",
    "PySide2.QtGui.QFontDatabase.isFixedPitch(self,family:QString,style:QString=QString())->bool",
    "PySide2.QtGui.QFontDatabase.isPrivateFamily(self,family:QString)->bool",
    "PySide2.QtGui.QFontDatabase.isScalable(self,family:QString,style:QString=QString())->bool",
    "PySide2.QtGui.QFontDatabase.isSmoothlyScalable(self,family:QString,style:QString=QString())->bool",
    "PySide2.QtGui.QFontDatabase.italic(self,family:QString,style:QString)->bool",
    "PySide2.QtGui.QFontDatabase.pointSizes(self,family:QString,style:QString=QString())->QList[int]",
    "PySide2.QtGui.QFontDatabase.removeAllApplicationFonts()->bool",
    "PySide2.QtGui.QFontDatabase.removeApplicationFont(id:int)->bool",
    "PySide2.QtGui.QFontDatabase.smoothSizes(self,family:QString,style:QString)->QList[int]",
    "PySide2.QtGui.QFontDatabase.standardSizes()->QList[int]",
    "1:PySide2.QtGui.QFontDatabase.styleString(self,font:PySide2.QtGui.QFont)->QString",
    "0:PySide2.QtGui.QFontDatabase.styleString(self,fontInfo:PySide2.QtGui.QFontInfo)->QString",
    "PySide2.QtGui.QFontDatabase.styles(self,family:QString)->QStringList",
    "PySide2.QtGui.QFontDatabase.supportsThreadedFontRendering()->bool",
    "PySide2.QtGui.QFontDatabase.systemFont(type:PySide2.QtGui.QFontDatabase.SystemFont)->PySide2.QtGui.QFont",
    "PySide2.QtGui.QFontDatabase.weight(self,family:QString,style:QString)->int",
    "PySide2.QtGui.QFontDatabase.writingSystemName(writingSystem:PySide2.QtGui.QFontDatabase.WritingSystem)->QString",
    "PySide2.QtGui.QFontDatabase.writingSystemSample(writingSystem:PySide2.QtGui.QFontDatabase.WritingSystem)->QString",
    "1:PySide2.QtGui.QFontDatabase.writingSystems(self)->QList[PySide2.QtGui.QFontDatabase.WritingSystem]",
    "0:PySide2.QtGui.QFontDatabase.writingSystems(self,family:QString)->QList[PySide2.QtGui.QFontDatabase.WritingSystem]",
    "PySide2.QtGui.QFontDatabase.__copy__()",
    nullptr}; // Sentinel

void init_QFontDatabase(PyObject *module)
{
    _Sbk_QFontDatabase_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFontDatabase",
        "QFontDatabase",
        &Sbk_QFontDatabase_spec,
        &Shiboken::callCppDestructor< ::QFontDatabase >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFontDatabase_Type);
    InitSignatureStrings(pyType, QFontDatabase_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFontDatabase_Type), Sbk_QFontDatabase_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFontDatabase_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFontDatabase_TypeF(),
        QFontDatabase_PythonToCpp_QFontDatabase_PTR,
        is_QFontDatabase_PythonToCpp_QFontDatabase_PTR_Convertible,
        QFontDatabase_PTR_CppToPython_QFontDatabase,
        QFontDatabase_COPY_CppToPython_QFontDatabase);

    Shiboken::Conversions::registerConverterName(converter, "QFontDatabase");
    Shiboken::Conversions::registerConverterName(converter, "QFontDatabase*");
    Shiboken::Conversions::registerConverterName(converter, "QFontDatabase&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFontDatabase).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QFontDatabase_PythonToCpp_QFontDatabase_COPY,
        is_QFontDatabase_PythonToCpp_QFontDatabase_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'WritingSystem'.
    SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFontDatabase_TypeF(),
        "WritingSystem",
        "2:PySide2.QtGui.QFontDatabase.WritingSystem",
        "QFontDatabase::WritingSystem");
    if (!SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Any", (long) QFontDatabase::WritingSystem::Any))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Latin", (long) QFontDatabase::WritingSystem::Latin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Greek", (long) QFontDatabase::WritingSystem::Greek))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Cyrillic", (long) QFontDatabase::WritingSystem::Cyrillic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Armenian", (long) QFontDatabase::WritingSystem::Armenian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Hebrew", (long) QFontDatabase::WritingSystem::Hebrew))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Arabic", (long) QFontDatabase::WritingSystem::Arabic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Syriac", (long) QFontDatabase::WritingSystem::Syriac))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Thaana", (long) QFontDatabase::WritingSystem::Thaana))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Devanagari", (long) QFontDatabase::WritingSystem::Devanagari))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Bengali", (long) QFontDatabase::WritingSystem::Bengali))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Gurmukhi", (long) QFontDatabase::WritingSystem::Gurmukhi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Gujarati", (long) QFontDatabase::WritingSystem::Gujarati))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Oriya", (long) QFontDatabase::WritingSystem::Oriya))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Tamil", (long) QFontDatabase::WritingSystem::Tamil))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Telugu", (long) QFontDatabase::WritingSystem::Telugu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Kannada", (long) QFontDatabase::WritingSystem::Kannada))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Malayalam", (long) QFontDatabase::WritingSystem::Malayalam))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Sinhala", (long) QFontDatabase::WritingSystem::Sinhala))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Thai", (long) QFontDatabase::WritingSystem::Thai))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Lao", (long) QFontDatabase::WritingSystem::Lao))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Tibetan", (long) QFontDatabase::WritingSystem::Tibetan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Myanmar", (long) QFontDatabase::WritingSystem::Myanmar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Georgian", (long) QFontDatabase::WritingSystem::Georgian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Khmer", (long) QFontDatabase::WritingSystem::Khmer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "SimplifiedChinese", (long) QFontDatabase::WritingSystem::SimplifiedChinese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "TraditionalChinese", (long) QFontDatabase::WritingSystem::TraditionalChinese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Japanese", (long) QFontDatabase::WritingSystem::Japanese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Korean", (long) QFontDatabase::WritingSystem::Korean))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Vietnamese", (long) QFontDatabase::WritingSystem::Vietnamese))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Symbol", (long) QFontDatabase::WritingSystem::Symbol))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Other", (long) QFontDatabase::WritingSystem::Other))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Ogham", (long) QFontDatabase::WritingSystem::Ogham))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Runic", (long) QFontDatabase::WritingSystem::Runic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "Nko", (long) QFontDatabase::WritingSystem::Nko))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
        Sbk_QFontDatabase_TypeF(), "WritingSystemsCount", (long) QFontDatabase::WritingSystem::WritingSystemsCount))
        return;
    // Register converter for enum 'QFontDatabase::WritingSystem'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX],
            QFontDatabase_WritingSystem_CppToPython_QFontDatabase_WritingSystem);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFontDatabase_WritingSystem_PythonToCpp_QFontDatabase_WritingSystem,
            is_QFontDatabase_WritingSystem_PythonToCpp_QFontDatabase_WritingSystem_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFontDatabase::WritingSystem");
        Shiboken::Conversions::registerConverterName(converter, "WritingSystem");
    }
    // End of 'WritingSystem' enum.

    // Initialization of enum 'SystemFont'.
    SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_SYSTEMFONT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFontDatabase_TypeF(),
        "SystemFont",
        "2:PySide2.QtGui.QFontDatabase.SystemFont",
        "QFontDatabase::SystemFont");
    if (!SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_SYSTEMFONT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_SYSTEMFONT_IDX],
        Sbk_QFontDatabase_TypeF(), "GeneralFont", (long) QFontDatabase::SystemFont::GeneralFont))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_SYSTEMFONT_IDX],
        Sbk_QFontDatabase_TypeF(), "FixedFont", (long) QFontDatabase::SystemFont::FixedFont))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_SYSTEMFONT_IDX],
        Sbk_QFontDatabase_TypeF(), "TitleFont", (long) QFontDatabase::SystemFont::TitleFont))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_SYSTEMFONT_IDX],
        Sbk_QFontDatabase_TypeF(), "SmallestReadableFont", (long) QFontDatabase::SystemFont::SmallestReadableFont))
        return;
    // Register converter for enum 'QFontDatabase::SystemFont'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_SYSTEMFONT_IDX],
            QFontDatabase_SystemFont_CppToPython_QFontDatabase_SystemFont);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFontDatabase_SystemFont_PythonToCpp_QFontDatabase_SystemFont,
            is_QFontDatabase_SystemFont_PythonToCpp_QFontDatabase_SystemFont_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_SYSTEMFONT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFontDatabase::SystemFont");
        Shiboken::Conversions::registerConverterName(converter, "SystemFont");
    }
    // End of 'SystemFont' enum.

    qRegisterMetaType< ::QFontDatabase >("QFontDatabase");
    qRegisterMetaType< ::QFontDatabase::WritingSystem >("QFontDatabase::WritingSystem");
    qRegisterMetaType< ::QFontDatabase::SystemFont >("QFontDatabase::SystemFont");
}
