/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qicon_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtGui/qicon.h>
#include <QtGui/qiconengine.h>
#include <QtGui/qpainter.h>
#include <QtGui/qpixmap.h>
#include <QtGui/qwindow.h>
#include <qdatastream.h>
#include <qrect.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QIcon_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QIcon >()))
        return -1;

    ::QIcon *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QIcon", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QIcon::QIcon()
    // 1: QIcon::QIcon(QIconEngine*)
    // 2: QIcon::QIcon(QIcon)
    // 3: QIcon::QIcon(QPixmap)
    // 4: QIcon::QIcon(QString)
    if (numArgs == 0) {
        overloadId = 0; // QIcon()
    } else if (numArgs == 1
        && (pyArgs[0] != Py_None && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICONENGINE_IDX]), (pyArgs[0]))))) {
        overloadId = 1; // QIcon(QIconEngine*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 4; // QIcon(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QIcon(QPixmap)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIcon_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QIcon()
        {

            if (!PyErr_Occurred()) {
                // QIcon()
                cptr = new ::QIcon();
            }
            break;
        }
        case 1: // QIcon(QIconEngine * engine)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIconEngine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QIcon(QIconEngine*)
                cptr = new ::QIcon(cppArg0);
                Shiboken::Object::setParent(self, pyArgs[0]);
            }
            break;
        }
        case 2: // QIcon(const QIcon & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIcon cppArg0_local;
            ::QIcon *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QIcon(QIcon)
                cptr = new ::QIcon(*cppArg0);
            }
            break;
        }
        case 3: // QIcon(const QPixmap & pixmap)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QIcon(QPixmap)
                cptr = new ::QIcon(*cppArg0);
            }
            break;
        }
        case 4: // QIcon(const QString & fileName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QIcon(QString)
                cptr = new ::QIcon(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QIcon >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QIcon_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QIcon_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QIconFunc_actualSize(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.actualSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QIconFunc_actualSize_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QIconFunc_actualSize_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:actualSize", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QIcon::actualSize(QWindow*,QSize,QIcon::Mode,QIcon::State)const
    // 1: QIcon::actualSize(QSize,QIcon::Mode,QIcon::State)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // actualSize(QSize,QIcon::Mode,QIcon::State)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // actualSize(QSize,QIcon::Mode,QIcon::State)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 1; // actualSize(QSize,QIcon::Mode,QIcon::State)const
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // actualSize(QWindow*,QSize,QIcon::Mode,QIcon::State)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // actualSize(QWindow*,QSize,QIcon::Mode,QIcon::State)const
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[3])))) {
                overloadId = 0; // actualSize(QWindow*,QSize,QIcon::Mode,QIcon::State)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_actualSize_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // actualSize(QWindow * window, const QSize & size, QIcon::Mode mode, QIcon::State state) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[2]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_actualSize_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QIconFunc_actualSize_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_state = Shiboken::String::createStaticString("state");
                if (PyDict_Contains(kwds, key_state)) {
                    value = PyDict_GetItem(kwds, key_state);
                    if (value && pyArgs[3]) {
                        errInfo = key_state;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_actualSize_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QIconFunc_actualSize_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_state);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QIconFunc_actualSize_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QSize cppArg1_local;
            ::QSize *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QIcon::Mode cppArg2 = QIcon::Mode::Normal;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QIcon::State cppArg3 = QIcon::State::Off;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // actualSize(QWindow*,QSize,QIcon::Mode,QIcon::State)const
                QSize cppResult = const_cast<const ::QIcon *>(cppSelf)->actualSize(cppArg0, *cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // actualSize(const QSize & size, QIcon::Mode mode, QIcon::State state) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_actualSize_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QIconFunc_actualSize_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_state = Shiboken::String::createStaticString("state");
                if (PyDict_Contains(kwds, key_state)) {
                    value = PyDict_GetItem(kwds, key_state);
                    if (value && pyArgs[2]) {
                        errInfo = key_state;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_actualSize_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QIconFunc_actualSize_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_state);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QIconFunc_actualSize_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QIcon::Mode cppArg1 = QIcon::Mode::Normal;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QIcon::State cppArg2 = QIcon::State::Off;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // actualSize(QSize,QIcon::Mode,QIcon::State)const
                QSize cppResult = const_cast<const ::QIcon *>(cppSelf)->actualSize(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIconFunc_actualSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_addFile(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.addFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QIconFunc_addFile_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QIconFunc_addFile_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:addFile", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QIcon::addFile(QString,QSize,QIcon::Mode,QIcon::State)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addFile(QString,QSize,QIcon::Mode,QIcon::State)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // addFile(QString,QSize,QIcon::Mode,QIcon::State)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // addFile(QString,QSize,QIcon::Mode,QIcon::State)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 0; // addFile(QString,QSize,QIcon::Mode,QIcon::State)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_addFile_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_size = Shiboken::String::createStaticString("size");
            if (PyDict_Contains(kwds, key_size)) {
                value = PyDict_GetItem(kwds, key_size);
                if (value && pyArgs[1]) {
                    errInfo = key_size;
                    Py_INCREF(errInfo);
                    goto Sbk_QIconFunc_addFile_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1]))))
                        goto Sbk_QIconFunc_addFile_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_size);
            }
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[2]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QIconFunc_addFile_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QIconFunc_addFile_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            static PyObject *const key_state = Shiboken::String::createStaticString("state");
            if (PyDict_Contains(kwds, key_state)) {
                value = PyDict_GetItem(kwds, key_state);
                if (value && pyArgs[3]) {
                    errInfo = key_state;
                    Py_INCREF(errInfo);
                    goto Sbk_QIconFunc_addFile_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QIconFunc_addFile_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_state);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QIconFunc_addFile_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSize cppArg1_local = QSize();
        ::QSize *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }
        ::QIcon::Mode cppArg2 = QIcon::Mode::Normal;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QIcon::State cppArg3 = QIcon::State::Off;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // addFile(QString,QSize,QIcon::Mode,QIcon::State)
            cppSelf->addFile(cppArg0, *cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIconFunc_addFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_addPixmap(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.addPixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QIconFunc_addPixmap_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QIconFunc_addPixmap_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:addPixmap", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QIcon::addPixmap(QPixmap,QIcon::Mode,QIcon::State)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addPixmap(QPixmap,QIcon::Mode,QIcon::State)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // addPixmap(QPixmap,QIcon::Mode,QIcon::State)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // addPixmap(QPixmap,QIcon::Mode,QIcon::State)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_addPixmap_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QIconFunc_addPixmap_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QIconFunc_addPixmap_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            static PyObject *const key_state = Shiboken::String::createStaticString("state");
            if (PyDict_Contains(kwds, key_state)) {
                value = PyDict_GetItem(kwds, key_state);
                if (value && pyArgs[2]) {
                    errInfo = key_state;
                    Py_INCREF(errInfo);
                    goto Sbk_QIconFunc_addPixmap_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QIconFunc_addPixmap_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_state);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QIconFunc_addPixmap_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QIcon::Mode cppArg1 = QIcon::Mode::Normal;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QIcon::State cppArg2 = QIcon::State::Off;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // addPixmap(QPixmap,QIcon::Mode,QIcon::State)
            cppSelf->addPixmap(*cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIconFunc_addPixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_availableSizes(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.availableSizes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QIconFunc_availableSizes_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:availableSizes", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QIcon::availableSizes(QIcon::Mode,QIcon::State)const
    if (numArgs == 0) {
        overloadId = 0; // availableSizes(QIcon::Mode,QIcon::State)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // availableSizes(QIcon::Mode,QIcon::State)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // availableSizes(QIcon::Mode,QIcon::State)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_availableSizes_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[0]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QIconFunc_availableSizes_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QIconFunc_availableSizes_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            static PyObject *const key_state = Shiboken::String::createStaticString("state");
            if (PyDict_Contains(kwds, key_state)) {
                value = PyDict_GetItem(kwds, key_state);
                if (value && pyArgs[1]) {
                    errInfo = key_state;
                    Py_INCREF(errInfo);
                    goto Sbk_QIconFunc_availableSizes_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QIconFunc_availableSizes_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_state);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QIconFunc_availableSizes_TypeError;
            }
        }
        ::QIcon::Mode cppArg0 = QIcon::Mode::Normal;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QIcon::State cppArg1 = QIcon::State::Off;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // availableSizes(QIcon::Mode,QIcon::State)const
            QList<QSize > cppResult = const_cast<const ::QIcon *>(cppSelf)->availableSizes(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSIZE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIconFunc_availableSizes_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_cacheKey(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.cacheKey";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cacheKey()const
            qint64 cppResult = const_cast<const ::QIcon *>(cppSelf)->cacheKey();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIconFunc_fallbackSearchPaths(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.fallbackSearchPaths";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fallbackSearchPaths()
            QStringList cppResult = ::QIcon::fallbackSearchPaths();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIconFunc_fallbackThemeName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.fallbackThemeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fallbackThemeName()
            QString cppResult = ::QIcon::fallbackThemeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIconFunc_fromTheme(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.fromTheme";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "fromTheme", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QIcon::fromTheme(QString)
    // 1: static QIcon::fromTheme(QString,QIcon)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromTheme(QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyArgs[1])))) {
            overloadId = 1; // fromTheme(QString,QIcon)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_fromTheme_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromTheme(const QString & name)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // fromTheme(QString)
                QIcon cppResult = ::QIcon::fromTheme(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromTheme(const QString & name, const QIcon & fallback)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QIcon cppArg1_local;
            ::QIcon *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // fromTheme(QString,QIcon)
                QIcon cppResult = ::QIcon::fromTheme(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIconFunc_fromTheme_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_hasThemeIcon(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.hasThemeIcon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QIcon::hasThemeIcon(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // hasThemeIcon(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_hasThemeIcon_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasThemeIcon(QString)
            bool cppResult = ::QIcon::hasThemeIcon(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIconFunc_hasThemeIcon_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_isMask(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.isMask";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMask()const
            bool cppResult = const_cast<const ::QIcon *>(cppSelf)->isMask();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIconFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QIcon *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIconFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QIcon *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIconFunc_paint(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.paint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 8) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QIconFunc_paint_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QIconFunc_paint_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOOO:paint", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QIcon::paint(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
    // 1: QIcon::paint(QPainter*,int,int,int,int,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArgs[0])))) {
        if (numArgs >= 5
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 1; // paint(QPainter*,int,int,int,int,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[5])))) {
                if (numArgs == 6) {
                    overloadId = 1; // paint(QPainter*,int,int,int,int,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                } else if (numArgs >= 7
                    && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[6])))) {
                    if (numArgs == 7) {
                        overloadId = 1; // paint(QPainter*,int,int,int,int,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                    } else if (numArgs >= 8
                        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[7])))) {
                        overloadId = 1; // paint(QPainter*,int,int,int,int,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                    }
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // paint(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // paint(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // paint(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[4])))) {
                        overloadId = 0; // paint(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_paint_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // paint(QPainter * painter, const QRect & rect, QFlags<Qt::AlignmentFlag> alignment, QIcon::Mode mode, QIcon::State state) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_alignment = Shiboken::String::createStaticString("alignment");
                if (PyDict_Contains(kwds, key_alignment)) {
                    value = PyDict_GetItem(kwds, key_alignment);
                    if (value && pyArgs[2]) {
                        errInfo = key_alignment;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_paint_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QIconFunc_paint_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_alignment);
                }
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[3]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_paint_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QIconFunc_paint_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_state = Shiboken::String::createStaticString("state");
                if (PyDict_Contains(kwds, key_state)) {
                    value = PyDict_GetItem(kwds, key_state);
                    if (value && pyArgs[4]) {
                        errInfo = key_state;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_paint_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[4]))))
                            goto Sbk_QIconFunc_paint_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_state);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QIconFunc_paint_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPainter *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QRect cppArg1_local;
            ::QRect *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QFlags<Qt::AlignmentFlag> cppArg2 = Qt::AlignCenter;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QIcon::Mode cppArg3 = QIcon::Mode::Normal;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QIcon::State cppArg4 = QIcon::State::Off;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // paint(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                const_cast<const ::QIcon *>(cppSelf)->paint(cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 1: // paint(QPainter * painter, int x, int y, int w, int h, QFlags<Qt::AlignmentFlag> alignment, QIcon::Mode mode, QIcon::State state) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_alignment = Shiboken::String::createStaticString("alignment");
                if (PyDict_Contains(kwds, key_alignment)) {
                    value = PyDict_GetItem(kwds, key_alignment);
                    if (value && pyArgs[5]) {
                        errInfo = key_alignment;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_paint_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[5]))))
                            goto Sbk_QIconFunc_paint_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_alignment);
                }
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[6]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_paint_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[6]))))
                            goto Sbk_QIconFunc_paint_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_state = Shiboken::String::createStaticString("state");
                if (PyDict_Contains(kwds, key_state)) {
                    value = PyDict_GetItem(kwds, key_state);
                    if (value && pyArgs[7]) {
                        errInfo = key_state;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_paint_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[7]))))
                            goto Sbk_QIconFunc_paint_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_state);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QIconFunc_paint_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPainter *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QFlags<Qt::AlignmentFlag> cppArg5 = Qt::AlignCenter;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            ::QIcon::Mode cppArg6 = QIcon::Mode::Normal;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QIcon::State cppArg7 = QIcon::State::Off;
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);

            if (!PyErr_Occurred()) {
                // paint(QPainter*,int,int,int,int,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                const_cast<const ::QIcon *>(cppSelf)->paint(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIconFunc_paint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_pixmap(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.pixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QIconFunc_pixmap_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QIconFunc_pixmap_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:pixmap", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QIcon::pixmap(QWindow*,QSize,QIcon::Mode,QIcon::State)const
    // 1: QIcon::pixmap(QSize,QIcon::Mode,QIcon::State)const
    // 2: QIcon::pixmap(int,QIcon::Mode,QIcon::State)const
    // 3: QIcon::pixmap(int,int,QIcon::Mode,QIcon::State)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // pixmap(int,QIcon::Mode,QIcon::State)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // pixmap(int,QIcon::Mode,QIcon::State)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 2; // pixmap(int,QIcon::Mode,QIcon::State)const
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // pixmap(int,int,QIcon::Mode,QIcon::State)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 3; // pixmap(int,int,QIcon::Mode,QIcon::State)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 3; // pixmap(int,int,QIcon::Mode,QIcon::State)const
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // pixmap(QSize,QIcon::Mode,QIcon::State)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // pixmap(QSize,QIcon::Mode,QIcon::State)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 1; // pixmap(QSize,QIcon::Mode,QIcon::State)const
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // pixmap(QWindow*,QSize,QIcon::Mode,QIcon::State)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // pixmap(QWindow*,QSize,QIcon::Mode,QIcon::State)const
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[3])))) {
                overloadId = 0; // pixmap(QWindow*,QSize,QIcon::Mode,QIcon::State)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_pixmap_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // pixmap(QWindow * window, const QSize & size, QIcon::Mode mode, QIcon::State state) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[2]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_state = Shiboken::String::createStaticString("state");
                if (PyDict_Contains(kwds, key_state)) {
                    value = PyDict_GetItem(kwds, key_state);
                    if (value && pyArgs[3]) {
                        errInfo = key_state;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_state);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QIconFunc_pixmap_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QSize cppArg1_local;
            ::QSize *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QIcon::Mode cppArg2 = QIcon::Mode::Normal;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QIcon::State cppArg3 = QIcon::State::Off;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // pixmap(QWindow*,QSize,QIcon::Mode,QIcon::State)const
                QPixmap cppResult = const_cast<const ::QIcon *>(cppSelf)->pixmap(cppArg0, *cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
            }
            break;
        }
        case 1: // pixmap(const QSize & size, QIcon::Mode mode, QIcon::State state) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_state = Shiboken::String::createStaticString("state");
                if (PyDict_Contains(kwds, key_state)) {
                    value = PyDict_GetItem(kwds, key_state);
                    if (value && pyArgs[2]) {
                        errInfo = key_state;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_state);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QIconFunc_pixmap_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QIcon::Mode cppArg1 = QIcon::Mode::Normal;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QIcon::State cppArg2 = QIcon::State::Off;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // pixmap(QSize,QIcon::Mode,QIcon::State)const
                QPixmap cppResult = const_cast<const ::QIcon *>(cppSelf)->pixmap(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
            }
            break;
        }
        case 2: // pixmap(int extent, QIcon::Mode mode, QIcon::State state) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_state = Shiboken::String::createStaticString("state");
                if (PyDict_Contains(kwds, key_state)) {
                    value = PyDict_GetItem(kwds, key_state);
                    if (value && pyArgs[2]) {
                        errInfo = key_state;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_state);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QIconFunc_pixmap_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QIcon::Mode cppArg1 = QIcon::Mode::Normal;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QIcon::State cppArg2 = QIcon::State::Off;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // pixmap(int,QIcon::Mode,QIcon::State)const
                QPixmap cppResult = const_cast<const ::QIcon *>(cppSelf)->pixmap(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
            }
            break;
        }
        case 3: // pixmap(int w, int h, QIcon::Mode mode, QIcon::State state) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[2]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_state = Shiboken::String::createStaticString("state");
                if (PyDict_Contains(kwds, key_state)) {
                    value = PyDict_GetItem(kwds, key_state);
                    if (value && pyArgs[3]) {
                        errInfo = key_state;
                        Py_INCREF(errInfo);
                        goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QIconFunc_pixmap_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_state);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QIconFunc_pixmap_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QIcon::Mode cppArg2 = QIcon::Mode::Normal;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QIcon::State cppArg3 = QIcon::State::Off;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // pixmap(int,int,QIcon::Mode,QIcon::State)const
                QPixmap cppResult = const_cast<const ::QIcon *>(cppSelf)->pixmap(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIconFunc_pixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_setFallbackSearchPaths(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.setFallbackSearchPaths";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QIcon::setFallbackSearchPaths(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setFallbackSearchPaths(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_setFallbackSearchPaths_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFallbackSearchPaths(QStringList)
            ::QIcon::setFallbackSearchPaths(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIconFunc_setFallbackSearchPaths_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_setFallbackThemeName(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.setFallbackThemeName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QIcon::setFallbackThemeName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setFallbackThemeName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_setFallbackThemeName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFallbackThemeName(QString)
            ::QIcon::setFallbackThemeName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIconFunc_setFallbackThemeName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_setIsMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.setIsMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIcon::setIsMask(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setIsMask(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_setIsMask_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setIsMask(bool)
            cppSelf->setIsMask(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIconFunc_setIsMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_setThemeName(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.setThemeName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QIcon::setThemeName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setThemeName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_setThemeName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setThemeName(QString)
            ::QIcon::setThemeName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIconFunc_setThemeName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_setThemeSearchPaths(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.setThemeSearchPaths";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QIcon::setThemeSearchPaths(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setThemeSearchPaths(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_setThemeSearchPaths_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setThemeSearchPaths(QStringList)
            ::QIcon::setThemeSearchPaths(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIconFunc_setThemeSearchPaths_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIcon::swap(QIcon&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QIcon&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIconFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QIcon&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QIconFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc_themeName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.themeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // themeName()
            QString cppResult = ::QIcon::themeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIconFunc_themeSearchPaths(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.themeSearchPaths";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // themeSearchPaths()
            QStringList cppResult = ::QIcon::themeSearchPaths();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QIcon___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QIcon_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QIcon_methods[] = {
    {"actualSize", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_actualSize), METH_VARARGS|METH_KEYWORDS},
    {"addFile", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_addFile), METH_VARARGS|METH_KEYWORDS},
    {"addPixmap", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_addPixmap), METH_VARARGS|METH_KEYWORDS},
    {"availableSizes", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_availableSizes), METH_VARARGS|METH_KEYWORDS},
    {"cacheKey", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_cacheKey), METH_NOARGS},
    {"fallbackSearchPaths", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_fallbackSearchPaths), METH_NOARGS|METH_STATIC},
    {"fallbackThemeName", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_fallbackThemeName), METH_NOARGS|METH_STATIC},
    {"fromTheme", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_fromTheme), METH_VARARGS|METH_STATIC},
    {"hasThemeIcon", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_hasThemeIcon), METH_O|METH_STATIC},
    {"isMask", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_isMask), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_isNull), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_name), METH_NOARGS},
    {"paint", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_paint), METH_VARARGS|METH_KEYWORDS},
    {"pixmap", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_pixmap), METH_VARARGS|METH_KEYWORDS},
    {"setFallbackSearchPaths", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_setFallbackSearchPaths), METH_O|METH_STATIC},
    {"setFallbackThemeName", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_setFallbackThemeName), METH_O|METH_STATIC},
    {"setIsMask", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_setIsMask), METH_O},
    {"setThemeName", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_setThemeName), METH_O|METH_STATIC},
    {"setThemeSearchPaths", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_setThemeSearchPaths), METH_O|METH_STATIC},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_swap), METH_O},
    {"themeName", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_themeName), METH_NOARGS|METH_STATIC},
    {"themeSearchPaths", reinterpret_cast<PyCFunction>(Sbk_QIconFunc_themeSearchPaths), METH_NOARGS|METH_STATIC},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QIcon___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QIcon___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

static PyObject *Sbk_QIconFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QIcon::operator<<(QDataStream&,QIcon)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QIcon)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QIconFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QIcon) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIconFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QIconFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIcon.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QIcon::operator>>(QDataStream&,QIcon&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QIcon&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QIconFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QIcon&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QIconFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

} // extern "C"

static int Sbk_QIcon_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QIcon_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QIcon__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QIcon_Type = nullptr;
static SbkObjectType *Sbk_QIcon_TypeF(void)
{
    return _Sbk_QIcon_Type;
}

static PyType_Slot Sbk_QIcon_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QIcon__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QIcon_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QIcon_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QIcon_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QIcon_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QIconFunc___rshift__},
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QIcon___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QIcon___nb_bool},
#endif
    {Py_nb_lshift, (void *)Sbk_QIconFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QIcon_spec = {
    "2:PySide2.QtGui.QIcon",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QIcon_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QIcon_Mode_PythonToCpp_QIcon_Mode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QIcon::Mode *>(cppOut) =
        static_cast<::QIcon::Mode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QIcon_Mode_PythonToCpp_QIcon_Mode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX]))
        return QIcon_Mode_PythonToCpp_QIcon_Mode;
    return {};
}
static PyObject *QIcon_Mode_CppToPython_QIcon_Mode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QIcon::Mode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX], castCppIn);

}

static void QIcon_State_PythonToCpp_QIcon_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QIcon::State *>(cppOut) =
        static_cast<::QIcon::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QIcon_State_PythonToCpp_QIcon_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX]))
        return QIcon_State_PythonToCpp_QIcon_State;
    return {};
}
static PyObject *QIcon_State_CppToPython_QIcon_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QIcon::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QIcon_PythonToCpp_QIcon_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QIcon_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QIcon_PythonToCpp_QIcon_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QIcon_TypeF())))
        return QIcon_PythonToCpp_QIcon_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QIcon_PTR_CppToPython_QIcon(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QIcon *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QIcon_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QIcon_COPY_CppToPython_QIcon(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QIcon_TypeF(), new ::QIcon(*reinterpret_cast<const ::QIcon *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QIcon_PythonToCpp_QIcon_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QIcon *>(cppOut) = *reinterpret_cast< ::QIcon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICON_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QIcon_PythonToCpp_QIcon_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QIcon_TypeF())))
        return QIcon_PythonToCpp_QIcon_COPY;
    return {};
}

// Implicit conversions.
static void constQPixmapREF_PythonToCpp_QIcon(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QIcon *>(cppOut) = ::QIcon( *reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQPixmapREF_PythonToCpp_QIcon_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], pyIn))
        return constQPixmapREF_PythonToCpp_QIcon;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QIcon_SignatureStrings[] = {
    "4:PySide2.QtGui.QIcon(self)",
    "3:PySide2.QtGui.QIcon(self,engine:PySide2.QtGui.QIconEngine)",
    "2:PySide2.QtGui.QIcon(self,other:PySide2.QtGui.QIcon)",
    "1:PySide2.QtGui.QIcon(self,pixmap:PySide2.QtGui.QPixmap)",
    "0:PySide2.QtGui.QIcon(self,fileName:QString)",
    "1:PySide2.QtGui.QIcon.actualSize(self,window:PySide2.QtGui.QWindow,size:PySide2.QtCore.QSize,mode:PySide2.QtGui.QIcon.Mode=Normal,state:PySide2.QtGui.QIcon.State=Off)->PySide2.QtCore.QSize",
    "0:PySide2.QtGui.QIcon.actualSize(self,size:PySide2.QtCore.QSize,mode:PySide2.QtGui.QIcon.Mode=Normal,state:PySide2.QtGui.QIcon.State=Off)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QIcon.addFile(self,fileName:QString,size:PySide2.QtCore.QSize=QSize(),mode:PySide2.QtGui.QIcon.Mode=Normal,state:PySide2.QtGui.QIcon.State=Off)",
    "PySide2.QtGui.QIcon.addPixmap(self,pixmap:PySide2.QtGui.QPixmap,mode:PySide2.QtGui.QIcon.Mode=Normal,state:PySide2.QtGui.QIcon.State=Off)",
    "PySide2.QtGui.QIcon.availableSizes(self,mode:PySide2.QtGui.QIcon.Mode=Normal,state:PySide2.QtGui.QIcon.State=Off)->QList[PySide2.QtCore.QSize]",
    "PySide2.QtGui.QIcon.cacheKey(self)->qint64",
    "PySide2.QtGui.QIcon.fallbackSearchPaths()->QStringList",
    "PySide2.QtGui.QIcon.fallbackThemeName()->QString",
    "1:PySide2.QtGui.QIcon.fromTheme(name:QString)->PySide2.QtGui.QIcon",
    "0:PySide2.QtGui.QIcon.fromTheme(name:QString,fallback:PySide2.QtGui.QIcon)->PySide2.QtGui.QIcon",
    "PySide2.QtGui.QIcon.hasThemeIcon(name:QString)->bool",
    "PySide2.QtGui.QIcon.isMask(self)->bool",
    "PySide2.QtGui.QIcon.isNull(self)->bool",
    "PySide2.QtGui.QIcon.name(self)->QString",
    "1:PySide2.QtGui.QIcon.paint(self,painter:PySide2.QtGui.QPainter,rect:PySide2.QtCore.QRect,alignment:PySide2.QtCore.Qt.Alignment=Qt.AlignCenter,mode:PySide2.QtGui.QIcon.Mode=Normal,state:PySide2.QtGui.QIcon.State=Off)",
    "0:PySide2.QtGui.QIcon.paint(self,painter:PySide2.QtGui.QPainter,x:int,y:int,w:int,h:int,alignment:PySide2.QtCore.Qt.Alignment=Qt.AlignCenter,mode:PySide2.QtGui.QIcon.Mode=Normal,state:PySide2.QtGui.QIcon.State=Off)",
    "3:PySide2.QtGui.QIcon.pixmap(self,window:PySide2.QtGui.QWindow,size:PySide2.QtCore.QSize,mode:PySide2.QtGui.QIcon.Mode=Normal,state:PySide2.QtGui.QIcon.State=Off)->PySide2.QtGui.QPixmap",
    "2:PySide2.QtGui.QIcon.pixmap(self,size:PySide2.QtCore.QSize,mode:PySide2.QtGui.QIcon.Mode=Normal,state:PySide2.QtGui.QIcon.State=Off)->PySide2.QtGui.QPixmap",
    "1:PySide2.QtGui.QIcon.pixmap(self,extent:int,mode:PySide2.QtGui.QIcon.Mode=Normal,state:PySide2.QtGui.QIcon.State=Off)->PySide2.QtGui.QPixmap",
    "0:PySide2.QtGui.QIcon.pixmap(self,w:int,h:int,mode:PySide2.QtGui.QIcon.Mode=Normal,state:PySide2.QtGui.QIcon.State=Off)->PySide2.QtGui.QPixmap",
    "PySide2.QtGui.QIcon.setFallbackSearchPaths(paths:QStringList)",
    "PySide2.QtGui.QIcon.setFallbackThemeName(name:QString)",
    "PySide2.QtGui.QIcon.setIsMask(self,isMask:bool)",
    "PySide2.QtGui.QIcon.setThemeName(path:QString)",
    "PySide2.QtGui.QIcon.setThemeSearchPaths(searchpath:QStringList)",
    "PySide2.QtGui.QIcon.swap(self,other:PySide2.QtGui.QIcon)",
    "PySide2.QtGui.QIcon.themeName()->QString",
    "PySide2.QtGui.QIcon.themeSearchPaths()->QStringList",
    "PySide2.QtGui.QIcon.__copy__()",
    "PySide2.QtGui.QIcon.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QIcon.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QIcon(PyObject *module)
{
    _Sbk_QIcon_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QIcon",
        "QIcon",
        &Sbk_QIcon_spec,
        &Shiboken::callCppDestructor< ::QIcon >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QIcon_Type);
    InitSignatureStrings(pyType, QIcon_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QIcon_Type), Sbk_QIcon_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QICON_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QIcon_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QIcon_TypeF(),
        QIcon_PythonToCpp_QIcon_PTR,
        is_QIcon_PythonToCpp_QIcon_PTR_Convertible,
        QIcon_PTR_CppToPython_QIcon,
        QIcon_COPY_CppToPython_QIcon);

    Shiboken::Conversions::registerConverterName(converter, "QIcon");
    Shiboken::Conversions::registerConverterName(converter, "QIcon*");
    Shiboken::Conversions::registerConverterName(converter, "QIcon&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QIcon).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QIcon_PythonToCpp_QIcon_COPY,
        is_QIcon_PythonToCpp_QIcon_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQPixmapREF_PythonToCpp_QIcon,
        is_constQPixmapREF_PythonToCpp_QIcon_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Mode'.
    SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QIcon_TypeF(),
        "Mode",
        "2:PySide2.QtGui.QIcon.Mode",
        "QIcon::Mode");
    if (!SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX],
        Sbk_QIcon_TypeF(), "Normal", (long) QIcon::Mode::Normal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX],
        Sbk_QIcon_TypeF(), "Disabled", (long) QIcon::Mode::Disabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX],
        Sbk_QIcon_TypeF(), "Active", (long) QIcon::Mode::Active))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX],
        Sbk_QIcon_TypeF(), "Selected", (long) QIcon::Mode::Selected))
        return;
    // Register converter for enum 'QIcon::Mode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX],
            QIcon_Mode_CppToPython_QIcon_Mode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QIcon_Mode_PythonToCpp_QIcon_Mode,
            is_QIcon_Mode_PythonToCpp_QIcon_Mode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QIcon::Mode");
        Shiboken::Conversions::registerConverterName(converter, "Mode");
    }
    // End of 'Mode' enum.

    // Initialization of enum 'State'.
    SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QIcon_TypeF(),
        "State",
        "2:PySide2.QtGui.QIcon.State",
        "QIcon::State");
    if (!SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX],
        Sbk_QIcon_TypeF(), "On", (long) QIcon::State::On))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX],
        Sbk_QIcon_TypeF(), "Off", (long) QIcon::State::Off))
        return;
    // Register converter for enum 'QIcon::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX],
            QIcon_State_CppToPython_QIcon_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QIcon_State_PythonToCpp_QIcon_State,
            is_QIcon_State_PythonToCpp_QIcon_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QIcon::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    qRegisterMetaType< ::QIcon >("QIcon");
    qRegisterMetaType< ::QIcon::Mode >("QIcon::Mode");
    qRegisterMetaType< ::QIcon::State >("QIcon::State");
}
