/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qimage_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// ========================================================================
// START of custom code block [file: ../glue/qtgui.cpp (qimage-decref-image-data)]
static void imageDecrefDataHandler(void *data)
{
    // Avoid "Python memory allocator called without holding the GIL"
    auto state = PyGILState_Ensure();
    Py_DECREF(reinterpret_cast<PyObject *>(data));
    PyGILState_Release(state);
}
// END of custom code block [file: ../glue/qtgui.cpp (qimage-decref-image-data)]
// ========================================================================

// End of code injection


// Native ---------------------------------------------------------

void QImageWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QImageWrapper::QImageWrapper() noexcept : QImage()
{
    resetPyMethodCache();
    // ... middle
}

QImageWrapper::QImageWrapper(const ::QSize & size, ::QImage::Format format) : QImage(size, format)
{
    resetPyMethodCache();
    // ... middle
}

QImageWrapper::QImageWrapper(const ::QString & fileName, const char * format) : QImage(fileName, format)
{
    resetPyMethodCache();
    // ... middle
}

QImageWrapper::QImageWrapper(const char *const xpm[]) : QImage(xpm)
{
    resetPyMethodCache();
    // ... middle
}

QImageWrapper::QImageWrapper(int width, int height, ::QImage::Format format) : QImage(width, height, format)
{
    resetPyMethodCache();
    // ... middle
}

QImageWrapper::QImageWrapper(uchar * data, int width, int height, ::QImage::Format format, ::QImageCleanupFunction cleanupFunction, void * cleanupInfo) : QImage(data, width, height, format, cleanupFunction, cleanupInfo)
{
    resetPyMethodCache();
    // ... middle
}

QImageWrapper::QImageWrapper(uchar * data, int width, int height, int bytesPerLine, ::QImage::Format format, ::QImageCleanupFunction cleanupFunction, void * cleanupInfo) : QImage(data, width, height, bytesPerLine, format, cleanupFunction, cleanupInfo)
{
    resetPyMethodCache();
    // ... middle
}

int QImageWrapper::devType() const
{
    if (m_PyMethodCache[0])
        return this->::QImage::devType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "devType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QImage::devType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImage.devType", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QImageWrapper::initPainter(::QPainter * painter) const
{
    if (m_PyMethodCache[1]) {
        return this->::QPaintDevice::initPainter(painter);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QPaintDevice::initPainter(painter);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

int QImageWrapper::metric(::QPaintDevice::PaintDeviceMetric metric) const
{
    if (m_PyMethodCache[2])
        return this->::QImage::metric(metric);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "metric";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QImage::metric(metric);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, &metric)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImage.metric", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintEngine * QImageWrapper::paintEngine() const
{
    if (m_PyMethodCache[3])
        return this->::QImage::paintEngine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QImage::paintEngine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImage.paintEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintDevice * QImageWrapper::redirected(::QPoint * offset) const
{
    if (m_PyMethodCache[4])
        return this->::QPaintDevice::redirected(offset);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "redirected";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QPaintDevice::redirected(offset);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), offset)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImage.redirected", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintDevice >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintDevice *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPainter * QImageWrapper::sharedPainter() const
{
    if (m_PyMethodCache[5])
        return this->::QPaintDevice::sharedPainter();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sharedPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QPaintDevice::sharedPainter();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImage.sharedPainter", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPainter >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPainter *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QImageWrapper::~QImageWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QImage_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QImage >()))
        return -1;

    ::QImageWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImage_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOO:QImage", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return -1;


    // Overloaded function decisor
    // 0: QImage::QImage()
    // 1: QImage::QImage(QString&,int,int,QImage::Format)
    // 2: QImage::QImage(QString&,int,int,int,QImage::Format)
    // 3: QImage::QImage(QImage)
    // 4: QImage::QImage(QSize,QImage::Format)
    // 5: QImage::QImage(QString,const char*)
    // 6: QImage::QImage(const char*const[])
    // 7: QImage::QImage(int,int,QImage::Format)
    // 8: QImage::QImage(uchar*,int,int,QImage::Format,QImageCleanupFunction,void*)
    // 9: QImage::QImage(uchar*,int,int,int,QImage::Format,QImageCleanupFunction,void*)
    if (numArgs == 0) {
        overloadId = 0; // QImage()
    } else if (numArgs >= 3
        && Shiboken::Buffer::checkType(pyArgs[0])
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 8; // QImage(uchar*,int,int,QImage::Format,QImageCleanupFunction,void*)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<QImageCleanupFunction>(), (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 8; // QImage(uchar*,int,int,QImage::Format,QImageCleanupFunction,void*)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))) {
                    overloadId = 8; // QImage(uchar*,int,int,QImage::Format,QImageCleanupFunction,void*)
                }
            }
        } else if (numArgs >= 5
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 9; // QImage(uchar*,int,int,int,QImage::Format,QImageCleanupFunction,void*)
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<QImageCleanupFunction>(), (pyArgs[5])))) {
                if (numArgs == 6) {
                    overloadId = 9; // QImage(uchar*,int,int,int,QImage::Format,QImageCleanupFunction,void*)
                } else if (numArgs >= 7
                    && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6])))) {
                    overloadId = 9; // QImage(uchar*,int,int,int,QImage::Format,QImageCleanupFunction,void*)
                }
            }
        }
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArgs[2])))) {
        overloadId = 7; // QImage(int,int,QImage::Format)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArgs[1])))) {
        overloadId = 4; // QImage(QSize,QImage::Format)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 5; // QImage(QString,const char*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 5; // QImage(QString,const char*)
        } else if (numArgs >= 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArgs[3])))) {
                overloadId = 1; // QImage(QString&,int,int,QImage::Format)
            } else if (numArgs == 5
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArgs[4])))) {
                overloadId = 2; // QImage(QString&,int,int,int,QImage::Format)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QImage(QImage)
    } else if (numArgs == 1
        && Shiboken::String::checkIterable(pyArgs[0])) {
        overloadId = 6; // QImage(const char*const[])
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImage_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QImage()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QImage_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QImage()
                cptr = new ::QImageWrapper();
            }
            break;
        }
        case 1: // QImage(QString & arg__1, int arg__2, int arg__3, QImage::Format arg__4)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QImage_Init_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            SBK_UNUSED(cppArg2)
            ::QImage::Format cppArg3{QImage::Format_Invalid};
            pythonToCpp[3](pyArgs[3], &cppArg3);
            SBK_UNUSED(cppArg3)

            if (!PyErr_Occurred()) {
                // QImage(QString&,int,int,QImage::Format)
                // Begin code injection
                // TEMPLATE - qimage_buffer_constructor - START
                Py_INCREF(pyArgs[1-1]);
                auto ptr = reinterpret_cast<uchar*>(Shiboken::Buffer::getPointer(pyArgs[1-1]));
                cptr = new QImageWrapper(ptr, cppArg1, cppArg2, cppArg3, imageDecrefDataHandler, pyArgs[1-1]);
                // TEMPLATE - qimage_buffer_constructor - END

                // End of code injection

            }
            break;
        }
        case 2: // QImage(QString & arg__1, int arg__2, int arg__3, int arg__4, QImage::Format arg__5)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QImage_Init_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            SBK_UNUSED(cppArg2)
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            SBK_UNUSED(cppArg3)
            ::QImage::Format cppArg4{QImage::Format_Invalid};
            pythonToCpp[4](pyArgs[4], &cppArg4);
            SBK_UNUSED(cppArg4)

            if (!PyErr_Occurred()) {
                // QImage(QString&,int,int,int,QImage::Format)
                // Begin code injection
                // TEMPLATE - qimage_buffer_constructor - START
                Py_INCREF(pyArgs[1-1]);
                auto ptr = reinterpret_cast<uchar*>(Shiboken::Buffer::getPointer(pyArgs[1-1]));
                cptr = new QImageWrapper(ptr, cppArg1, cppArg2, cppArg3, cppArg4, imageDecrefDataHandler, pyArgs[1-1]);
                // TEMPLATE - qimage_buffer_constructor - END

                // End of code injection

            }
            break;
        }
        case 3: // QImage(const QImage & arg__1)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QImage_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QImage cppArg0_local;
            ::QImage *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QImage(QImage)
                cptr = new ::QImageWrapper(*cppArg0);
            }
            break;
        }
        case 4: // QImage(const QSize & size, QImage::Format format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QImage_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QImage::Format cppArg1{QImage::Format_Invalid};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QImage(QSize,QImage::Format)
                cptr = new ::QImageWrapper(*cppArg0, cppArg1);
            }
            break;
        }
        case 5: // QImage(const QString & fileName, const char * format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QImage_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QImage_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImage_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QImage(QString,const char*)
                cptr = new ::QImageWrapper(cppArg0, cppArg1);
            }
            break;
        }
        case 6: // QImage(const char*const[] xpm)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QImage_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QImage(const char*const[])
                // Begin code injection
                // TEMPLATE - load_xpm - START
                Shiboken::AutoDecRef strList(PySequence_Fast(pyArgs[1-1], "Invalid sequence."));
                int lineCount = PySequence_Fast_GET_SIZE(strList.object());
                for (int line = 0; line < lineCount; ++line) {
                    if (!Shiboken::String::check(PySequence_Fast_GET_ITEM(strList.object(), line))) {
                        PyErr_SetString(PyExc_TypeError, "The argument must be a sequence of strings.");
                        break;
                    }
                }

                const char **xpm = reinterpret_cast<const char**>(malloc(lineCount * sizeof(const char**)));
                for (int line = 0; line < lineCount; ++line)
                    xpm[line] = Shiboken::String::toCString(PySequence_Fast_GET_ITEM(strList.object(), line));

                cptr = new QImageWrapper(xpm);

                free(xpm);
                // TEMPLATE - load_xpm - END

                // End of code injection

            }
            break;
        }
        case 7: // QImage(int width, int height, QImage::Format format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QImage_Init_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QImage::Format cppArg2{QImage::Format_Invalid};
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QImage(int,int,QImage::Format)
                cptr = new ::QImageWrapper(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 8: // QImage(uchar * data, int width, int height, QImage::Format format, QImageCleanupFunction cleanupFunction, void * cleanupInfo)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_cleanupFunction = Shiboken::String::createStaticString("cleanupFunction");
                if (PyDict_Contains(kwds, key_cleanupFunction)) {
                    value = PyDict_GetItem(kwds, key_cleanupFunction);
                    if (value && pyArgs[4]) {
                        errInfo = key_cleanupFunction;
                        Py_INCREF(errInfo);
                        goto Sbk_QImage_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<QImageCleanupFunction>(), (pyArgs[4]))))
                            goto Sbk_QImage_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_cleanupFunction);
                }
                static PyObject *const key_cleanupInfo = Shiboken::String::createStaticString("cleanupInfo");
                if (PyDict_Contains(kwds, key_cleanupInfo)) {
                    value = PyDict_GetItem(kwds, key_cleanupInfo);
                    if (value && pyArgs[5]) {
                        errInfo = key_cleanupInfo;
                        Py_INCREF(errInfo);
                        goto Sbk_QImage_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5]))))
                            goto Sbk_QImage_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_cleanupInfo);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImage_Init_TypeError;
                }
            }
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QImage::Format cppArg3{QImage::Format_Invalid};
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QImage(uchar*,int,int,QImage::Format,QImageCleanupFunction,void*)
                // Begin code injection
                // TEMPLATE - qimage_buffer_constructor - START
                Py_INCREF(pyArgs[1-1]);
                auto ptr = reinterpret_cast<uchar*>(Shiboken::Buffer::getPointer(pyArgs[1-1]));
                cptr = new QImageWrapper(ptr, cppArg1, cppArg2, cppArg3, imageDecrefDataHandler, pyArgs[1-1]);
                // TEMPLATE - qimage_buffer_constructor - END

                // End of code injection

            }
            break;
        }
        case 9: // QImage(uchar * data, int width, int height, int bytesPerLine, QImage::Format format, QImageCleanupFunction cleanupFunction, void * cleanupInfo)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_cleanupFunction = Shiboken::String::createStaticString("cleanupFunction");
                if (PyDict_Contains(kwds, key_cleanupFunction)) {
                    value = PyDict_GetItem(kwds, key_cleanupFunction);
                    if (value && pyArgs[5]) {
                        errInfo = key_cleanupFunction;
                        Py_INCREF(errInfo);
                        goto Sbk_QImage_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<QImageCleanupFunction>(), (pyArgs[5]))))
                            goto Sbk_QImage_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_cleanupFunction);
                }
                static PyObject *const key_cleanupInfo = Shiboken::String::createStaticString("cleanupInfo");
                if (PyDict_Contains(kwds, key_cleanupInfo)) {
                    value = PyDict_GetItem(kwds, key_cleanupInfo);
                    if (value && pyArgs[6]) {
                        errInfo = key_cleanupInfo;
                        Py_INCREF(errInfo);
                        goto Sbk_QImage_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6]))))
                            goto Sbk_QImage_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_cleanupInfo);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImage_Init_TypeError;
                }
            }
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QImage::Format cppArg4{QImage::Format_Invalid};
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QImage(uchar*,int,int,int,QImage::Format,QImageCleanupFunction,void*)
                // Begin code injection
                // TEMPLATE - qimage_buffer_constructor - START
                Py_INCREF(pyArgs[1-1]);
                auto ptr = reinterpret_cast<uchar*>(Shiboken::Buffer::getPointer(pyArgs[1-1]));
                cptr = new QImageWrapper(ptr, cppArg1, cppArg2, cppArg3, cppArg4, imageDecrefDataHandler, pyArgs[1-1]);
                // TEMPLATE - qimage_buffer_constructor - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QImage >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QImage_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QImage_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QImageFunc_allGray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.allGray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allGray()const
            bool cppResult = const_cast<const ::QImage *>(cppSelf)->allGray();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_alphaChannel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.alphaChannel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alphaChannel()const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->alphaChannel();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_bitPlaneCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.bitPlaneCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bitPlaneCount()const
            int cppResult = const_cast<const ::QImage *>(cppSelf)->bitPlaneCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_bits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.bits";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bits()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qimage-bits)]
            // byteCount() is only available on Qt4.7, so we use bytesPerLine * height
            pyResult = Shiboken::Buffer::newObject(cppSelf->bits(), cppSelf->bytesPerLine() * cppSelf->height(), Shiboken::Buffer::ReadWrite);
            // END of custom code block [file: ../glue/qtgui.cpp (qimage-bits)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_byteCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.byteCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // byteCount()const
            int cppResult = const_cast<const ::QImage *>(cppSelf)->byteCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_bytesPerLine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.bytesPerLine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesPerLine()const
            int cppResult = const_cast<const ::QImage *>(cppSelf)->bytesPerLine();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_cacheKey(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.cacheKey";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cacheKey()const
            qint64 cppResult = const_cast<const ::QImage *>(cppSelf)->cacheKey();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_color(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.color";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::color(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // color(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_color_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // color(int)const
            unsigned int cppResult = const_cast<const ::QImage *>(cppSelf)->color(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_color_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_colorCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.colorCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorCount()const
            int cppResult = const_cast<const ::QImage *>(cppSelf)->colorCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_colorSpace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.colorSpace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorSpace()const
            QColorSpace cppResult = const_cast<const ::QImage *>(cppSelf)->colorSpace();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_colorTable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.colorTable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorTable()const
            QVector<unsigned int > cppResult = const_cast<const ::QImage *>(cppSelf)->colorTable();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_UNSIGNEDINT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_constBits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.constBits";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // constBits()const
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qimage-constbits)]
            pyResult = Shiboken::Buffer::newObject(cppSelf->constBits(), cppSelf->byteCount());
            // END of custom code block [file: ../glue/qtgui.cpp (qimage-constbits)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_constScanLine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.constScanLine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::constScanLine(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // constScanLine(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_constScanLine_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // constScanLine(int)const
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qimage-constscanline)]
            pyResult = Shiboken::Buffer::newObject(cppSelf->constScanLine(cppArg0), cppSelf->bytesPerLine());
            // END of custom code block [file: ../glue/qtgui.cpp (qimage-constscanline)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_constScanLine_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_convertTo(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.convertTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_convertTo_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_convertTo_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:convertTo", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::convertTo(QImage::Format,QFlags<Qt::ImageConversionFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // convertTo(QImage::Format,QFlags<Qt::ImageConversionFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // convertTo(QImage::Format,QFlags<Qt::ImageConversionFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_convertTo_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[1]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QImageFunc_convertTo_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QImageFunc_convertTo_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QImageFunc_convertTo_TypeError;
            }
        }
        ::QImage::Format cppArg0{QImage::Format_Invalid};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<Qt::ImageConversionFlag> cppArg1 = Qt::AutoColor;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // convertTo(QImage::Format,QFlags<Qt::ImageConversionFlag>)
            cppSelf->convertTo(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_convertTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_convertToColorSpace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.convertToColorSpace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::convertToColorSpace(QColorSpace)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), (pyArg)))) {
        overloadId = 0; // convertToColorSpace(QColorSpace)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_convertToColorSpace_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColorSpace cppArg0_local;
        ::QColorSpace *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // convertToColorSpace(QColorSpace)
            cppSelf->convertToColorSpace(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_convertToColorSpace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_convertToFormat(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.convertToFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_convertToFormat_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_convertToFormat_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:convertToFormat", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QImage::convertToFormat(QImage::Format,QFlags<Qt::ImageConversionFlag>)
    // 1: QImage::convertToFormat(QImage::Format,QVector<uint>,QFlags<Qt::ImageConversionFlag>)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // convertToFormat(QImage::Format,QFlags<Qt::ImageConversionFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_UNSIGNEDINT_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // convertToFormat(QImage::Format,QVector<uint>,QFlags<Qt::ImageConversionFlag>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 2; // convertToFormat(QImage::Format,QVector<uint>,QFlags<Qt::ImageConversionFlag>)const
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // convertToFormat(QImage::Format,QFlags<Qt::ImageConversionFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_convertToFormat_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // convertToFormat(QImage::Format f, QFlags<Qt::ImageConversionFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[1]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_convertToFormat_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QImageFunc_convertToFormat_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageFunc_convertToFormat_TypeError;
                }
            }
            ::QImage::Format cppArg0{QImage::Format_Invalid};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<Qt::ImageConversionFlag> cppArg1 = Qt::AutoColor;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // convertToFormat(QImage::Format,QFlags<Qt::ImageConversionFlag>)
                QImage cppResult = cppSelf->convertToFormat(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // convertToFormat(QImage::Format f, const QVector<unsigned int > & colorTable, QFlags<Qt::ImageConversionFlag> flags) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[2]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_convertToFormat_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QImageFunc_convertToFormat_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageFunc_convertToFormat_TypeError;
                }
            }
            ::QImage::Format cppArg0{QImage::Format_Invalid};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QVector<unsigned int > cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::ImageConversionFlag> cppArg2 = Qt::AutoColor;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // convertToFormat(QImage::Format,QVector<uint>,QFlags<Qt::ImageConversionFlag>)const
                QImage cppResult = const_cast<const ::QImage *>(cppSelf)->convertToFormat(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_convertToFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_convertToFormat_helper(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.convertToFormat_helper";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "convertToFormat_helper", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::convertToFormat_helper(QImage::Format,QFlags<Qt::ImageConversionFlag>)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // convertToFormat_helper(QImage::Format,QFlags<Qt::ImageConversionFlag>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_convertToFormat_helper_TypeError;

    // Call function/method
    {
        ::QImage::Format cppArg0{QImage::Format_Invalid};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<Qt::ImageConversionFlag> cppArg1 = QFlags<Qt::ImageConversionFlag>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // convertToFormat_helper(QImage::Format,QFlags<Qt::ImageConversionFlag>)const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->convertToFormat_helper(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_convertToFormat_helper_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_convertToFormat_inplace(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.convertToFormat_inplace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "convertToFormat_inplace", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::convertToFormat_inplace(QImage::Format,QFlags<Qt::ImageConversionFlag>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // convertToFormat_inplace(QImage::Format,QFlags<Qt::ImageConversionFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_convertToFormat_inplace_TypeError;

    // Call function/method
    {
        ::QImage::Format cppArg0{QImage::Format_Invalid};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<Qt::ImageConversionFlag> cppArg1 = QFlags<Qt::ImageConversionFlag>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // convertToFormat_inplace(QImage::Format,QFlags<Qt::ImageConversionFlag>)
            bool cppResult = cppSelf->convertToFormat_inplace(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_convertToFormat_inplace_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_convertedToColorSpace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.convertedToColorSpace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::convertedToColorSpace(QColorSpace)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), (pyArg)))) {
        overloadId = 0; // convertedToColorSpace(QColorSpace)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_convertedToColorSpace_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColorSpace cppArg0_local;
        ::QColorSpace *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // convertedToColorSpace(QColorSpace)const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->convertedToColorSpace(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_convertedToColorSpace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_copy(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.copy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_copy_TypeError;
    } else if (numArgs == 2 || numArgs == 3)
        goto Sbk_QImageFunc_copy_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOO:copy", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QImage::copy(QRect)const
    // 1: QImage::copy(int,int,int,int)const
    if (numArgs == 0) {
        overloadId = 0; // copy(QRect)const
    } else if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 1; // copy(int,int,int,int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // copy(QRect)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_copy_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // copy(const QRect & rect) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_rect = Shiboken::String::createStaticString("rect");
                if (PyDict_Contains(kwds, key_rect)) {
                    value = PyDict_GetItem(kwds, key_rect);
                    if (value && pyArgs[0]) {
                        errInfo = key_rect;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_copy_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QImageFunc_copy_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_rect);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageFunc_copy_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local = QRect();
            ::QRect *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

            if (!PyErr_Occurred()) {
                // copy(QRect)const
                QImage cppResult = const_cast<const ::QImage *>(cppSelf)->copy(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // copy(int x, int y, int w, int h) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QImageFunc_copy_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // copy(int,int,int,int)const
                QImage cppResult = const_cast<const ::QImage *>(cppSelf)->copy(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_copy_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_createAlphaMask(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.createAlphaMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_createAlphaMask_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:createAlphaMask", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QImage::createAlphaMask(QFlags<Qt::ImageConversionFlag>)const
    if (numArgs == 0) {
        overloadId = 0; // createAlphaMask(QFlags<Qt::ImageConversionFlag>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // createAlphaMask(QFlags<Qt::ImageConversionFlag>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_createAlphaMask_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[0]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QImageFunc_createAlphaMask_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QImageFunc_createAlphaMask_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QImageFunc_createAlphaMask_TypeError;
            }
        }
        ::QFlags<Qt::ImageConversionFlag> cppArg0 = Qt::AutoColor;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // createAlphaMask(QFlags<Qt::ImageConversionFlag>)const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->createAlphaMask(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_createAlphaMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_createHeuristicMask(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.createHeuristicMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_createHeuristicMask_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:createHeuristicMask", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QImage::createHeuristicMask(bool)const
    if (numArgs == 0) {
        overloadId = 0; // createHeuristicMask(bool)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // createHeuristicMask(bool)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_createHeuristicMask_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_clipTight = Shiboken::String::createStaticString("clipTight");
            if (PyDict_Contains(kwds, key_clipTight)) {
                value = PyDict_GetItem(kwds, key_clipTight);
                if (value && pyArgs[0]) {
                    errInfo = key_clipTight;
                    Py_INCREF(errInfo);
                    goto Sbk_QImageFunc_createHeuristicMask_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QImageFunc_createHeuristicMask_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_clipTight);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QImageFunc_createHeuristicMask_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // createHeuristicMask(bool)const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->createHeuristicMask(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_createHeuristicMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_createMaskFromColor(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.createMaskFromColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_createMaskFromColor_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_createMaskFromColor_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:createMaskFromColor", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::createMaskFromColor(uint,Qt::MaskMode)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // createMaskFromColor(uint,Qt::MaskMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MASKMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // createMaskFromColor(uint,Qt::MaskMode)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_createMaskFromColor_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QImageFunc_createMaskFromColor_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MASKMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QImageFunc_createMaskFromColor_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QImageFunc_createMaskFromColor_TypeError;
            }
        }
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::MaskMode cppArg1 = Qt::MaskInColor;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // createMaskFromColor(uint,Qt::MaskMode)const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->createMaskFromColor(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_createMaskFromColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_depth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.depth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depth()const
            int cppResult = const_cast<const ::QImage *>(cppSelf)->depth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_devType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.devType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // devType()const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QImage *>(cppSelf)->::QImage::devType()
                : const_cast<const ::QImage *>(cppSelf)->devType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_devicePixelRatio(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.devicePixelRatio";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // devicePixelRatio()const
            qreal cppResult = const_cast<const ::QImage *>(cppSelf)->devicePixelRatio();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_dotsPerMeterX(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.dotsPerMeterX";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dotsPerMeterX()const
            int cppResult = const_cast<const ::QImage *>(cppSelf)->dotsPerMeterX();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_dotsPerMeterY(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.dotsPerMeterY";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dotsPerMeterY()const
            int cppResult = const_cast<const ::QImage *>(cppSelf)->dotsPerMeterY();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_fill(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.fill";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::fill(Qt::GlobalColor)
    // 1: QImage::fill(QColor)
    // 2: QImage::fill(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])->converter, (pyArg)))) {
        overloadId = 0; // fill(Qt::GlobalColor)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 2; // fill(uint)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 1; // fill(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_fill_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fill(Qt::GlobalColor color)
        {
            ::Qt::GlobalColor cppArg0{Qt::color0};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // fill(Qt::GlobalColor)
                cppSelf->fill(cppArg0);
            }
            break;
        }
        case 1: // fill(const QColor & color)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // fill(QColor)
                cppSelf->fill(*cppArg0);
            }
            break;
        }
        case 2: // fill(uint pixel)
        {
            uint cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // fill(uint)
                cppSelf->fill(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_fill_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QImage::Format cppResult = const_cast<const ::QImage *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_fromData(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.fromData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_fromData_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_fromData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromData", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QImage::fromData(QByteArray,const char*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromData(QByteArray,const char*)
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 0; // fromData(QByteArray,const char*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_fromData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[1]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QImageFunc_fromData_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                        goto Sbk_QImageFunc_fromData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QImageFunc_fromData_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        const char* cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromData(QByteArray,const char*)
            QImage cppResult = ::QImage::fromData(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_fromData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_hasAlphaChannel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.hasAlphaChannel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasAlphaChannel()const
            bool cppResult = const_cast<const ::QImage *>(cppSelf)->hasAlphaChannel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            int cppResult = const_cast<const ::QImage *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_invertPixels(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.invertPixels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_invertPixels_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:invertPixels", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QImage::invertPixels(QImage::InvertMode)
    if (numArgs == 0) {
        overloadId = 0; // invertPixels(QImage::InvertMode)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_INVERTMODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // invertPixels(QImage::InvertMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_invertPixels_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[0]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QImageFunc_invertPixels_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_INVERTMODE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QImageFunc_invertPixels_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QImageFunc_invertPixels_TypeError;
            }
        }
        ::QImage::InvertMode cppArg0 = QImage::InvertMode::InvertRgb;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // invertPixels(QImage::InvertMode)
            cppSelf->invertPixels(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_invertPixels_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_isGrayscale(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.isGrayscale";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isGrayscale()const
            bool cppResult = const_cast<const ::QImage *>(cppSelf)->isGrayscale();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QImage *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_load(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.load";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_load_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_load_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:load", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::load(QIODevice*,const char*)
    // 1: QImage::load(QString,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // load(QIODevice*,const char*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // load(QString,const char*)
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 1; // load(QString,const char*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_load_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // load(QIODevice * device, const char * format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QImageFunc_load_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // load(QIODevice*,const char*)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->load(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // load(const QString & fileName, const char * format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_load_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QImageFunc_load_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageFunc_load_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // load(QString,const char*)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->load(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_load_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_loadFromData(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.loadFromData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_loadFromData_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_loadFromData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:loadFromData", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::loadFromData(QByteArray,const char*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // loadFromData(QByteArray,const char*)
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 0; // loadFromData(QByteArray,const char*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_loadFromData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_aformat = Shiboken::String::createStaticString("aformat");
            if (PyDict_Contains(kwds, key_aformat)) {
                value = PyDict_GetItem(kwds, key_aformat);
                if (value && pyArgs[1]) {
                    errInfo = key_aformat;
                    Py_INCREF(errInfo);
                    goto Sbk_QImageFunc_loadFromData_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                        goto Sbk_QImageFunc_loadFromData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_aformat);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QImageFunc_loadFromData_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        const char* cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // loadFromData(QByteArray,const char*)
            bool cppResult = cppSelf->loadFromData(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_loadFromData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_metric(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.metric";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, (pyArg)))) {
        overloadId = 0; // metric(QPaintDevice::PaintDeviceMetric)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_metric_TypeError;

    // Call function/method
    {
        ::QPaintDevice::PaintDeviceMetric cppArg0 = static_cast< ::QPaintDevice::PaintDeviceMetric>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // metric(QPaintDevice::PaintDeviceMetric)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QImage *>(cppSelf)->::QImage::metric(cppArg0)
                : const_cast<const ::QImage *>(cppSelf)->metric(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_metric_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_mirrored(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.mirrored";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_mirrored_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:mirrored", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::mirrored(bool,bool)const
    if (numArgs == 0) {
        overloadId = 0; // mirrored(bool,bool)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // mirrored(bool,bool)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // mirrored(bool,bool)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_mirrored_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_horizontally = Shiboken::String::createStaticString("horizontally");
            if (PyDict_Contains(kwds, key_horizontally)) {
                value = PyDict_GetItem(kwds, key_horizontally);
                if (value && pyArgs[0]) {
                    errInfo = key_horizontally;
                    Py_INCREF(errInfo);
                    goto Sbk_QImageFunc_mirrored_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QImageFunc_mirrored_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_horizontally);
            }
            static PyObject *const key_vertically = Shiboken::String::createStaticString("vertically");
            if (PyDict_Contains(kwds, key_vertically)) {
                value = PyDict_GetItem(kwds, key_vertically);
                if (value && pyArgs[1]) {
                    errInfo = key_vertically;
                    Py_INCREF(errInfo);
                    goto Sbk_QImageFunc_mirrored_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QImageFunc_mirrored_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_vertically);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QImageFunc_mirrored_TypeError;
            }
        }
        bool cppArg0 = false;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // mirrored(bool,bool)const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->mirrored(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_mirrored_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_mirrored_helper(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.mirrored_helper";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "mirrored_helper", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::mirrored_helper(bool,bool)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // mirrored_helper(bool,bool)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_mirrored_helper_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // mirrored_helper(bool,bool)const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->mirrored_helper(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_mirrored_helper_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_mirrored_inplace(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.mirrored_inplace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "mirrored_inplace", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::mirrored_inplace(bool,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // mirrored_inplace(bool,bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_mirrored_inplace_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // mirrored_inplace(bool,bool)
            cppSelf->mirrored_inplace(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_mirrored_inplace_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_offset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.offset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // offset()const
            QPoint cppResult = const_cast<const ::QImage *>(cppSelf)->offset();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_paintEngine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.paintEngine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // paintEngine()const
            QPaintEngine * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QImage *>(cppSelf)->::QImage::paintEngine()
                : const_cast<const ::QImage *>(cppSelf)->paintEngine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_pixel(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.pixel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "pixel", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::pixel(QPoint)const
    // 1: QImage::pixel(int,int)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // pixel(int,int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // pixel(QPoint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_pixel_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // pixel(const QPoint & pt) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // pixel(QPoint)const
                unsigned int cppResult = const_cast<const ::QImage *>(cppSelf)->pixel(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
            }
            break;
        }
        case 1: // pixel(int x, int y) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // pixel(int,int)const
                unsigned int cppResult = const_cast<const ::QImage *>(cppSelf)->pixel(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_pixel_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_pixelColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.pixelColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "pixelColor", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::pixelColor(QPoint)const
    // 1: QImage::pixelColor(int,int)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // pixelColor(int,int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // pixelColor(QPoint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_pixelColor_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // pixelColor(const QPoint & pt) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // pixelColor(QPoint)const
                QColor cppResult = const_cast<const ::QImage *>(cppSelf)->pixelColor(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
            }
            break;
        }
        case 1: // pixelColor(int x, int y) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // pixelColor(int,int)const
                QColor cppResult = const_cast<const ::QImage *>(cppSelf)->pixelColor(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_pixelColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_pixelFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.pixelFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelFormat()const
            QPixelFormat cppResult = const_cast<const ::QImage *>(cppSelf)->pixelFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_pixelIndex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.pixelIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "pixelIndex", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::pixelIndex(QPoint)const
    // 1: QImage::pixelIndex(int,int)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // pixelIndex(int,int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // pixelIndex(QPoint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_pixelIndex_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // pixelIndex(const QPoint & pt) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // pixelIndex(QPoint)const
                int cppResult = const_cast<const ::QImage *>(cppSelf)->pixelIndex(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // pixelIndex(int x, int y) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // pixelIndex(int,int)const
                int cppResult = const_cast<const ::QImage *>(cppSelf)->pixelIndex(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_pixelIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_rect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.rect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rect()const
            QRect cppResult = const_cast<const ::QImage *>(cppSelf)->rect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_reinterpretAsFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.reinterpretAsFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::reinterpretAsFormat(QImage::Format)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // reinterpretAsFormat(QImage::Format)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_reinterpretAsFormat_TypeError;

    // Call function/method
    {
        ::QImage::Format cppArg0{QImage::Format_Invalid};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // reinterpretAsFormat(QImage::Format)
            bool cppResult = cppSelf->reinterpretAsFormat(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_reinterpretAsFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_rgbSwapped(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.rgbSwapped";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rgbSwapped()const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->rgbSwapped();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_rgbSwapped_helper(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.rgbSwapped_helper";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rgbSwapped_helper()const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->rgbSwapped_helper();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_rgbSwapped_inplace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.rgbSwapped_inplace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rgbSwapped_inplace()
            cppSelf->rgbSwapped_inplace();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QImageFunc_save(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.save";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_save_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_save_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:save", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QImage::save(QIODevice*,const char*,int)const
    // 1: QImage::save(QString,const char*,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // save(QIODevice*,const char*,int)const
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // save(QIODevice*,const char*,int)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // save(QIODevice*,const char*,int)const
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // save(QString,const char*,int)const
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // save(QString,const char*,int)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 1; // save(QString,const char*,int)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_save_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // save(QIODevice * device, const char * format, int quality) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_save_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QImageFunc_save_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                static PyObject *const key_quality = Shiboken::String::createStaticString("quality");
                if (PyDict_Contains(kwds, key_quality)) {
                    value = PyDict_GetItem(kwds, key_quality);
                    if (value && pyArgs[2]) {
                        errInfo = key_quality;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_save_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QImageFunc_save_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_quality);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageFunc_save_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = -1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // save(QIODevice*,const char*,int)const
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = const_cast<const ::QImage *>(cppSelf)->save(cppArg0, cppArg1, cppArg2);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // save(const QString & fileName, const char * format, int quality) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_save_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QImageFunc_save_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                static PyObject *const key_quality = Shiboken::String::createStaticString("quality");
                if (PyDict_Contains(kwds, key_quality)) {
                    value = PyDict_GetItem(kwds, key_quality);
                    if (value && pyArgs[2]) {
                        errInfo = key_quality;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_save_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QImageFunc_save_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_quality);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageFunc_save_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = -1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // save(QString,const char*,int)const
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = const_cast<const ::QImage *>(cppSelf)->save(cppArg0, cppArg1, cppArg2);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_save_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_scaled(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.scaled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_scaled_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_scaled_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:scaled", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QImage::scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
    // 1: QImage::scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[3])))) {
                overloadId = 1; // scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_scaled_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // scaled(const QSize & s, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_aspectMode = Shiboken::String::createStaticString("aspectMode");
                if (PyDict_Contains(kwds, key_aspectMode)) {
                    value = PyDict_GetItem(kwds, key_aspectMode);
                    if (value && pyArgs[1]) {
                        errInfo = key_aspectMode;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_scaled_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QImageFunc_scaled_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_aspectMode);
                }
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[2]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_scaled_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QImageFunc_scaled_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageFunc_scaled_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::AspectRatioMode cppArg1 = Qt::IgnoreAspectRatio;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::TransformationMode cppArg2 = Qt::FastTransformation;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
                QImage cppResult = const_cast<const ::QImage *>(cppSelf)->scaled(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // scaled(int w, int h, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_aspectMode = Shiboken::String::createStaticString("aspectMode");
                if (PyDict_Contains(kwds, key_aspectMode)) {
                    value = PyDict_GetItem(kwds, key_aspectMode);
                    if (value && pyArgs[2]) {
                        errInfo = key_aspectMode;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_scaled_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QImageFunc_scaled_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_aspectMode);
                }
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[3]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_scaled_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QImageFunc_scaled_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageFunc_scaled_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::AspectRatioMode cppArg2 = Qt::IgnoreAspectRatio;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::Qt::TransformationMode cppArg3 = Qt::FastTransformation;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
                QImage cppResult = const_cast<const ::QImage *>(cppSelf)->scaled(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_scaled_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_scaledToHeight(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.scaledToHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_scaledToHeight_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_scaledToHeight_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:scaledToHeight", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::scaledToHeight(int,Qt::TransformationMode)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // scaledToHeight(int,Qt::TransformationMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // scaledToHeight(int,Qt::TransformationMode)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_scaledToHeight_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QImageFunc_scaledToHeight_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QImageFunc_scaledToHeight_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QImageFunc_scaledToHeight_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::TransformationMode cppArg1 = Qt::FastTransformation;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // scaledToHeight(int,Qt::TransformationMode)const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->scaledToHeight(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_scaledToHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_scaledToWidth(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.scaledToWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_scaledToWidth_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_scaledToWidth_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:scaledToWidth", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::scaledToWidth(int,Qt::TransformationMode)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // scaledToWidth(int,Qt::TransformationMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // scaledToWidth(int,Qt::TransformationMode)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_scaledToWidth_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QImageFunc_scaledToWidth_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QImageFunc_scaledToWidth_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QImageFunc_scaledToWidth_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::TransformationMode cppArg1 = Qt::FastTransformation;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // scaledToWidth(int,Qt::TransformationMode)const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->scaledToWidth(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_scaledToWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_scanLine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.scanLine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::scanLine(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // scanLine(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_scanLine_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // scanLine(int)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qimage-scanline)]
            pyResult = Shiboken::Buffer::newObject(cppSelf->scanLine(cppArg0), cppSelf->bytesPerLine(), Shiboken::Buffer::ReadWrite);
            // END of custom code block [file: ../glue/qtgui.cpp (qimage-scanline)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_scanLine_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_setAlphaChannel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.setAlphaChannel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::setAlphaChannel(QImage)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArg)))) {
        overloadId = 0; // setAlphaChannel(QImage)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_setAlphaChannel_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QImage cppArg0_local;
        ::QImage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setAlphaChannel(QImage)
            cppSelf->setAlphaChannel(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_setAlphaChannel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_setColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.setColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setColor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::setColor(int,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // setColor(int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_setColor_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setColor(int,uint)
            cppSelf->setColor(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_setColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_setColorCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.setColorCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::setColorCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setColorCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_setColorCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColorCount(int)
            cppSelf->setColorCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_setColorCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_setColorSpace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.setColorSpace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::setColorSpace(QColorSpace)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), (pyArg)))) {
        overloadId = 0; // setColorSpace(QColorSpace)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_setColorSpace_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColorSpace cppArg0_local;
        ::QColorSpace *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLORSPACE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setColorSpace(QColorSpace)
            cppSelf->setColorSpace(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_setColorSpace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_setColorTable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.setColorTable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::setColorTable(QVector<uint>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_UNSIGNEDINT_IDX], (pyArg)))) {
        overloadId = 0; // setColorTable(QVector<uint>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_setColorTable_TypeError;

    // Call function/method
    {
        ::QVector<unsigned int > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColorTable(QVector<uint>)
            cppSelf->setColorTable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_setColorTable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_setDevicePixelRatio(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.setDevicePixelRatio";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::setDevicePixelRatio(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setDevicePixelRatio(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_setDevicePixelRatio_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevicePixelRatio(qreal)
            cppSelf->setDevicePixelRatio(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_setDevicePixelRatio_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_setDotsPerMeterX(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.setDotsPerMeterX";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::setDotsPerMeterX(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDotsPerMeterX(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_setDotsPerMeterX_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDotsPerMeterX(int)
            cppSelf->setDotsPerMeterX(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_setDotsPerMeterX_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_setDotsPerMeterY(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.setDotsPerMeterY";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::setDotsPerMeterY(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDotsPerMeterY(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_setDotsPerMeterY_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDotsPerMeterY(int)
            cppSelf->setDotsPerMeterY(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_setDotsPerMeterY_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_setOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.setOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::setOffset(QPoint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // setOffset(QPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_setOffset_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setOffset(QPoint)
            cppSelf->setOffset(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_setOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_setPixel(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.setPixel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setPixel", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QImage::setPixel(QPoint,uint)
    // 1: QImage::setPixel(int,int,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[2])))) {
        overloadId = 1; // setPixel(int,int,uint)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[1])))) {
        overloadId = 0; // setPixel(QPoint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_setPixel_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPixel(const QPoint & pt, uint index_or_rgb)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            uint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setPixel(QPoint,uint)
                cppSelf->setPixel(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setPixel(int x, int y, uint index_or_rgb)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            uint cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setPixel(int,int,uint)
                cppSelf->setPixel(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_setPixel_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_setPixelColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.setPixelColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setPixelColor", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QImage::setPixelColor(QPoint,QColor)
    // 1: QImage::setPixelColor(int,int,QColor)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[2])))) {
        overloadId = 1; // setPixelColor(int,int,QColor)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setPixelColor(QPoint,QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_setPixelColor_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPixelColor(const QPoint & pt, const QColor & c)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setPixelColor(QPoint,QColor)
                cppSelf->setPixelColor(*cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // setPixelColor(int x, int y, const QColor & c)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QColor cppArg2_local;
            ::QColor *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // setPixelColor(int,int,QColor)
                cppSelf->setPixelColor(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_setPixelColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_setText(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.setText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setText", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::setText(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // setText(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_setText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setText(QString,QString)
            cppSelf->setText(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_setText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            QSize cppResult = const_cast<const ::QImage *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_sizeInBytes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.sizeInBytes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sizeInBytes()const
            long long cppResult = const_cast<const ::QImage *>(cppSelf)->sizeInBytes();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_smoothScaled(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.smoothScaled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "smoothScaled", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::smoothScaled(int,int)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // smoothScaled(int,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_smoothScaled_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // smoothScaled(int,int)const
            QImage cppResult = const_cast<const ::QImage *>(cppSelf)->smoothScaled(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_smoothScaled_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImage::swap(QImage&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QImage&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QImage cppArg0_local;
        ::QImage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QImage&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_text(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.text";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_text_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:text", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QImage::text(QString)const
    if (numArgs == 0) {
        overloadId = 0; // text(QString)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // text(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_text_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_key = Shiboken::String::createStaticString("key");
            if (PyDict_Contains(kwds, key_key)) {
                value = PyDict_GetItem(kwds, key_key);
                if (value && pyArgs[0]) {
                    errInfo = key_key;
                    Py_INCREF(errInfo);
                    goto Sbk_QImageFunc_text_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QImageFunc_text_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_key);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QImageFunc_text_TypeError;
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // text(QString)const
            QString cppResult = const_cast<const ::QImage *>(cppSelf)->text(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_text_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_textKeys(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.textKeys";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textKeys()const
            QStringList cppResult = const_cast<const ::QImage *>(cppSelf)->textKeys();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageFunc_toImageFormat(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.toImageFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QImage::toImageFormat(QPixelFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // toImageFormat(QPixelFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_toImageFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPixelFormat cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toImageFormat(QPixelFormat)
            QImage::Format cppResult = ::QImage::toImageFormat(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_toImageFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_toPixelFormat(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.toPixelFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QImage::toPixelFormat(QImage::Format)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // toPixelFormat(QImage::Format)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_toPixelFormat_TypeError;

    // Call function/method
    {
        ::QImage::Format cppArg0{QImage::Format_Invalid};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toPixelFormat(QImage::Format)
            QPixelFormat cppResult = ::QImage::toPixelFormat(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_toPixelFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_transformed(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.transformed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_transformed_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QImageFunc_transformed_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:transformed", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::transformed(QMatrix,Qt::TransformationMode)const
    // 1: QImage::transformed(QTransform,Qt::TransformationMode)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // transformed(QTransform,Qt::TransformationMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // transformed(QTransform,Qt::TransformationMode)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // transformed(QMatrix,Qt::TransformationMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // transformed(QMatrix,Qt::TransformationMode)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_transformed_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // transformed(const QMatrix & matrix, Qt::TransformationMode mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_transformed_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QImageFunc_transformed_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageFunc_transformed_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMatrix cppArg0_local;
            ::QMatrix *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::TransformationMode cppArg1 = Qt::FastTransformation;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // transformed(QMatrix,Qt::TransformationMode)const
                QImage cppResult = const_cast<const ::QImage *>(cppSelf)->transformed(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QImage.transformed(const QMatrix & matrix, Qt::TransformationMode mode) const is deprecated", 1);
            break;
        }
        case 1: // transformed(const QTransform & matrix, Qt::TransformationMode mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageFunc_transformed_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QImageFunc_transformed_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageFunc_transformed_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTransform cppArg0_local;
            ::QTransform *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::TransformationMode cppArg1 = Qt::FastTransformation;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // transformed(QTransform,Qt::TransformationMode)const
                QImage cppResult = const_cast<const ::QImage *>(cppSelf)->transformed(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_transformed_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_trueMatrix(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.trueMatrix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "trueMatrix", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QImage::trueMatrix(QMatrix,int,int)
    // 1: static QImage::trueMatrix(QTransform,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 1; // trueMatrix(QTransform,int,int)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // trueMatrix(QMatrix,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_trueMatrix_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // trueMatrix(const QMatrix & arg__1, int w, int h)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMatrix cppArg0_local;
            ::QMatrix *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // trueMatrix(QMatrix,int,int)
                QMatrix cppResult = ::QImage::trueMatrix(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QImage.trueMatrix(const QMatrix & arg__1, int w, int h) is deprecated", 1);
            break;
        }
        case 1: // trueMatrix(const QTransform & arg__1, int w, int h)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTransform cppArg0_local;
            ::QTransform *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // trueMatrix(QTransform,int,int)
                QTransform cppResult = ::QImage::trueMatrix(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_trueMatrix_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_valid(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.valid";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "valid", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImage::valid(QPoint)const
    // 1: QImage::valid(int,int)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // valid(int,int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // valid(QPoint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageFunc_valid_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // valid(const QPoint & pt) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // valid(QPoint)const
                bool cppResult = const_cast<const ::QImage *>(cppSelf)->valid(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // valid(int x, int y) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // valid(int,int)const
                bool cppResult = const_cast<const ::QImage *>(cppSelf)->valid(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc_valid_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            int cppResult = const_cast<const ::QImage *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImage___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QImage_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QImage_methods[] = {
    {"allGray", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_allGray), METH_NOARGS},
    {"alphaChannel", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_alphaChannel), METH_NOARGS},
    {"bitPlaneCount", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_bitPlaneCount), METH_NOARGS},
    {"bits", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_bits), METH_NOARGS},
    {"byteCount", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_byteCount), METH_NOARGS},
    {"bytesPerLine", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_bytesPerLine), METH_NOARGS},
    {"cacheKey", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_cacheKey), METH_NOARGS},
    {"color", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_color), METH_O},
    {"colorCount", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_colorCount), METH_NOARGS},
    {"colorSpace", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_colorSpace), METH_NOARGS},
    {"colorTable", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_colorTable), METH_NOARGS},
    {"constBits", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_constBits), METH_NOARGS},
    {"constScanLine", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_constScanLine), METH_O},
    {"convertTo", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_convertTo), METH_VARARGS|METH_KEYWORDS},
    {"convertToColorSpace", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_convertToColorSpace), METH_O},
    {"convertToFormat", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_convertToFormat), METH_VARARGS|METH_KEYWORDS},
    {"convertToFormat_helper", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_convertToFormat_helper), METH_VARARGS},
    {"convertToFormat_inplace", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_convertToFormat_inplace), METH_VARARGS},
    {"convertedToColorSpace", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_convertedToColorSpace), METH_O},
    {"copy", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_copy), METH_VARARGS|METH_KEYWORDS},
    {"createAlphaMask", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_createAlphaMask), METH_VARARGS|METH_KEYWORDS},
    {"createHeuristicMask", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_createHeuristicMask), METH_VARARGS|METH_KEYWORDS},
    {"createMaskFromColor", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_createMaskFromColor), METH_VARARGS|METH_KEYWORDS},
    {"depth", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_depth), METH_NOARGS},
    {"devType", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_devType), METH_NOARGS},
    {"devicePixelRatio", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_devicePixelRatio), METH_NOARGS},
    {"dotsPerMeterX", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_dotsPerMeterX), METH_NOARGS},
    {"dotsPerMeterY", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_dotsPerMeterY), METH_NOARGS},
    {"fill", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_fill), METH_O},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_format), METH_NOARGS},
    {"fromData", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_fromData), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"hasAlphaChannel", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_hasAlphaChannel), METH_NOARGS},
    {"height", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_height), METH_NOARGS},
    {"invertPixels", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_invertPixels), METH_VARARGS|METH_KEYWORDS},
    {"isGrayscale", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_isGrayscale), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_isNull), METH_NOARGS},
    {"load", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_load), METH_VARARGS|METH_KEYWORDS},
    {"loadFromData", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_loadFromData), METH_VARARGS|METH_KEYWORDS},
    {"metric", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_metric), METH_O},
    {"mirrored", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_mirrored), METH_VARARGS|METH_KEYWORDS},
    {"mirrored_helper", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_mirrored_helper), METH_VARARGS},
    {"mirrored_inplace", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_mirrored_inplace), METH_VARARGS},
    {"offset", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_offset), METH_NOARGS},
    {"paintEngine", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_paintEngine), METH_NOARGS},
    {"pixel", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_pixel), METH_VARARGS},
    {"pixelColor", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_pixelColor), METH_VARARGS},
    {"pixelFormat", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_pixelFormat), METH_NOARGS},
    {"pixelIndex", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_pixelIndex), METH_VARARGS},
    {"rect", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_rect), METH_NOARGS},
    {"reinterpretAsFormat", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_reinterpretAsFormat), METH_O},
    {"rgbSwapped", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_rgbSwapped), METH_NOARGS},
    {"rgbSwapped_helper", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_rgbSwapped_helper), METH_NOARGS},
    {"rgbSwapped_inplace", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_rgbSwapped_inplace), METH_NOARGS},
    {"save", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_save), METH_VARARGS|METH_KEYWORDS},
    {"scaled", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_scaled), METH_VARARGS|METH_KEYWORDS},
    {"scaledToHeight", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_scaledToHeight), METH_VARARGS|METH_KEYWORDS},
    {"scaledToWidth", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_scaledToWidth), METH_VARARGS|METH_KEYWORDS},
    {"scanLine", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_scanLine), METH_O},
    {"setAlphaChannel", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_setAlphaChannel), METH_O},
    {"setColor", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_setColor), METH_VARARGS},
    {"setColorCount", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_setColorCount), METH_O},
    {"setColorSpace", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_setColorSpace), METH_O},
    {"setColorTable", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_setColorTable), METH_O},
    {"setDevicePixelRatio", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_setDevicePixelRatio), METH_O},
    {"setDotsPerMeterX", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_setDotsPerMeterX), METH_O},
    {"setDotsPerMeterY", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_setDotsPerMeterY), METH_O},
    {"setOffset", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_setOffset), METH_O},
    {"setPixel", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_setPixel), METH_VARARGS},
    {"setPixelColor", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_setPixelColor), METH_VARARGS},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_setText), METH_VARARGS},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_size), METH_NOARGS},
    {"sizeInBytes", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_sizeInBytes), METH_NOARGS},
    {"smoothScaled", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_smoothScaled), METH_VARARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_swap), METH_O},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_text), METH_VARARGS|METH_KEYWORDS},
    {"textKeys", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_textKeys), METH_NOARGS},
    {"toImageFormat", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_toImageFormat), METH_O|METH_STATIC},
    {"toPixelFormat", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_toPixelFormat), METH_O|METH_STATIC},
    {"transformed", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_transformed), METH_VARARGS|METH_KEYWORDS},
    {"trueMatrix", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_trueMatrix), METH_VARARGS|METH_STATIC},
    {"valid", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_valid), METH_VARARGS},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QImageFunc_width), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QImage___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QImage_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QImageWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

static int Sbk_QImage___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

static PyObject *Sbk_QImageFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QImage::operator<<(QDataStream&,QImage)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QImage)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QImageFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QImage) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImage.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QImage::operator>>(QDataStream&,QImage&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QImage&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QImageFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QImage&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QImage_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArg)))) {
                // operator!=(const QImage & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QImage cppArg0_local;
                ::QImage *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArg)))) {
                // operator==(const QImage & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QImage cppArg0_local;
                ::QImage *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QImage_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QImage_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QImage_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QImage_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QImage__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QImage_Type = nullptr;
static SbkObjectType *Sbk_QImage_TypeF(void)
{
    return _Sbk_QImage_Type;
}

static PyType_Slot Sbk_QImage_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QImage__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QImage_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QImage_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QImage_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QImage_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QImage_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QImage_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QImageFunc___rshift__},
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QImage___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QImage___nb_bool},
#endif
    {Py_nb_lshift, (void *)Sbk_QImageFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QImage_spec = {
    "2:PySide2.QtGui.QImage",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QImage_slots
};

} //extern "C"

static void *Sbk_QImage_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QPaintDevice >()))
        return dynamic_cast< ::QImage *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QImage_InvertMode_PythonToCpp_QImage_InvertMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QImage::InvertMode *>(cppOut) =
        static_cast<::QImage::InvertMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QImage_InvertMode_PythonToCpp_QImage_InvertMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QIMAGE_INVERTMODE_IDX]))
        return QImage_InvertMode_PythonToCpp_QImage_InvertMode;
    return {};
}
static PyObject *QImage_InvertMode_CppToPython_QImage_InvertMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QImage::InvertMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_INVERTMODE_IDX], castCppIn);

}

static void QImage_Format_PythonToCpp_QImage_Format(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QImage::Format *>(cppOut) =
        static_cast<::QImage::Format>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QImage_Format_PythonToCpp_QImage_Format_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX]))
        return QImage_Format_PythonToCpp_QImage_Format;
    return {};
}
static PyObject *QImage_Format_CppToPython_QImage_Format(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QImage::Format *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QImage_PythonToCpp_QImage_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QImage_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QImage_PythonToCpp_QImage_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QImage_TypeF())))
        return QImage_PythonToCpp_QImage_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QImage_PTR_CppToPython_QImage(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QImage *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QImage_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QImage_COPY_CppToPython_QImage(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QImage_TypeF(), new ::QImageWrapper(*reinterpret_cast<const ::QImage *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QImage_PythonToCpp_QImage_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QImage *>(cppOut) = *reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QImage_PythonToCpp_QImage_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QImage_TypeF())))
        return QImage_PythonToCpp_QImage_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_constQStringREF_PythonToCpp_QImage(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QImage *>(cppOut) = ::QImage(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_constQStringREF_PythonToCpp_QImage_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return PySide2_QtCore_constQStringREF_PythonToCpp_QImage;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QImage_SignatureStrings[] = {
    "9:PySide2.QtGui.QImage(self)",
    "8:PySide2.QtGui.QImage(self,arg__1:QString,arg__2:int,arg__3:int,arg__4:PySide2.QtGui.QImage.Format)",
    "7:PySide2.QtGui.QImage(self,arg__1:QString,arg__2:int,arg__3:int,arg__4:int,arg__5:PySide2.QtGui.QImage.Format)",
    "6:PySide2.QtGui.QImage(self,arg__1:PySide2.QtGui.QImage)",
    "5:PySide2.QtGui.QImage(self,size:PySide2.QtCore.QSize,format:PySide2.QtGui.QImage.Format)",
    "4:PySide2.QtGui.QImage(self,fileName:QString,format:char*=nullptr)",
    "3:PySide2.QtGui.QImage(self,xpm:char*const[])",
    "2:PySide2.QtGui.QImage(self,width:int,height:int,format:PySide2.QtGui.QImage.Format)",
    "1:PySide2.QtGui.QImage(self,data:uchar*,width:int,height:int,format:PySide2.QtGui.QImage.Format,cleanupFunction:QImageCleanupFunction=nullptr,cleanupInfo:void=nullptr)",
    "0:PySide2.QtGui.QImage(self,data:uchar*,width:int,height:int,bytesPerLine:int,format:PySide2.QtGui.QImage.Format,cleanupFunction:QImageCleanupFunction=nullptr,cleanupInfo:void=nullptr)",
    "PySide2.QtGui.QImage.allGray(self)->bool",
    "PySide2.QtGui.QImage.alphaChannel(self)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.bitPlaneCount(self)->int",
    "PySide2.QtGui.QImage.bits(self)->uchar*",
    "PySide2.QtGui.QImage.byteCount(self)->int",
    "PySide2.QtGui.QImage.bytesPerLine(self)->int",
    "PySide2.QtGui.QImage.cacheKey(self)->qint64",
    "PySide2.QtGui.QImage.color(self,i:int)->unsigned int",
    "PySide2.QtGui.QImage.colorCount(self)->int",
    "PySide2.QtGui.QImage.colorSpace(self)->PySide2.QtGui.QColorSpace",
    "PySide2.QtGui.QImage.colorTable(self)->QVector[unsigned int]",
    "PySide2.QtGui.QImage.constBits(self)->uchar*",
    "PySide2.QtGui.QImage.constScanLine(self,arg__1:int)->uchar*",
    "PySide2.QtGui.QImage.convertTo(self,f:PySide2.QtGui.QImage.Format,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)",
    "PySide2.QtGui.QImage.convertToColorSpace(self,arg__1:PySide2.QtGui.QColorSpace)",
    "2:PySide2.QtGui.QImage.convertToFormat(self,f:PySide2.QtGui.QImage.Format,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)->PySide2.QtGui.QImage",
    "1:PySide2.QtGui.QImage.convertToFormat(self,f:PySide2.QtGui.QImage.Format,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)->PySide2.QtGui.QImage",
    "0:PySide2.QtGui.QImage.convertToFormat(self,f:PySide2.QtGui.QImage.Format,colorTable:QVector[unsigned int],flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.convertToFormat_helper(self,format:PySide2.QtGui.QImage.Format,flags:PySide2.QtCore.Qt.ImageConversionFlags)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.convertToFormat_inplace(self,format:PySide2.QtGui.QImage.Format,flags:PySide2.QtCore.Qt.ImageConversionFlags)->bool",
    "PySide2.QtGui.QImage.convertedToColorSpace(self,arg__1:PySide2.QtGui.QColorSpace)->PySide2.QtGui.QImage",
    "1:PySide2.QtGui.QImage.copy(self,rect:PySide2.QtCore.QRect=QRect())->PySide2.QtGui.QImage",
    "0:PySide2.QtGui.QImage.copy(self,x:int,y:int,w:int,h:int)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.createAlphaMask(self,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.createHeuristicMask(self,clipTight:bool=true)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.createMaskFromColor(self,color:unsigned int,mode:PySide2.QtCore.Qt.MaskMode=Qt.MaskInColor)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.depth(self)->int",
    "PySide2.QtGui.QImage.devType(self)->int",
    "PySide2.QtGui.QImage.devicePixelRatio(self)->qreal",
    "PySide2.QtGui.QImage.dotsPerMeterX(self)->int",
    "PySide2.QtGui.QImage.dotsPerMeterY(self)->int",
    "2:PySide2.QtGui.QImage.fill(self,color:PySide2.QtCore.Qt.GlobalColor)",
    "1:PySide2.QtGui.QImage.fill(self,color:PySide2.QtGui.QColor)",
    "0:PySide2.QtGui.QImage.fill(self,pixel:uint)",
    "PySide2.QtGui.QImage.format(self)->PySide2.QtGui.QImage.Format",
    "PySide2.QtGui.QImage.fromData(data:PySide2.QtCore.QByteArray,format:char*=nullptr)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.hasAlphaChannel(self)->bool",
    "PySide2.QtGui.QImage.height(self)->int",
    "PySide2.QtGui.QImage.invertPixels(self,mode:PySide2.QtGui.QImage.InvertMode=InvertRgb)",
    "PySide2.QtGui.QImage.isGrayscale(self)->bool",
    "PySide2.QtGui.QImage.isNull(self)->bool",
    "1:PySide2.QtGui.QImage.load(self,device:PySide2.QtCore.QIODevice,format:char*)->bool",
    "0:PySide2.QtGui.QImage.load(self,fileName:QString,format:char*=nullptr)->bool",
    "PySide2.QtGui.QImage.loadFromData(self,data:PySide2.QtCore.QByteArray,aformat:char*=nullptr)->bool",
    "PySide2.QtGui.QImage.metric(self,metric:PySide2.QtGui.QPaintDevice.PaintDeviceMetric)->int",
    "PySide2.QtGui.QImage.mirrored(self,horizontally:bool=false,vertically:bool=true)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.mirrored_helper(self,horizontal:bool,vertical:bool)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.mirrored_inplace(self,horizontal:bool,vertical:bool)",
    "PySide2.QtGui.QImage.offset(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QImage.paintEngine(self)->PySide2.QtGui.QPaintEngine",
    "1:PySide2.QtGui.QImage.pixel(self,pt:PySide2.QtCore.QPoint)->unsigned int",
    "0:PySide2.QtGui.QImage.pixel(self,x:int,y:int)->unsigned int",
    "1:PySide2.QtGui.QImage.pixelColor(self,pt:PySide2.QtCore.QPoint)->PySide2.QtGui.QColor",
    "0:PySide2.QtGui.QImage.pixelColor(self,x:int,y:int)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QImage.pixelFormat(self)->PySide2.QtGui.QPixelFormat",
    "1:PySide2.QtGui.QImage.pixelIndex(self,pt:PySide2.QtCore.QPoint)->int",
    "0:PySide2.QtGui.QImage.pixelIndex(self,x:int,y:int)->int",
    "PySide2.QtGui.QImage.rect(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QImage.reinterpretAsFormat(self,f:PySide2.QtGui.QImage.Format)->bool",
    "PySide2.QtGui.QImage.rgbSwapped(self)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.rgbSwapped_helper(self)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.rgbSwapped_inplace(self)",
    "1:PySide2.QtGui.QImage.save(self,device:PySide2.QtCore.QIODevice,format:char*=nullptr,quality:int=-1)->bool",
    "0:PySide2.QtGui.QImage.save(self,fileName:QString,format:char*=nullptr,quality:int=-1)->bool",
    "1:PySide2.QtGui.QImage.scaled(self,s:PySide2.QtCore.QSize,aspectMode:PySide2.QtCore.Qt.AspectRatioMode=Qt.IgnoreAspectRatio,mode:PySide2.QtCore.Qt.TransformationMode=Qt.FastTransformation)->PySide2.QtGui.QImage",
    "0:PySide2.QtGui.QImage.scaled(self,w:int,h:int,aspectMode:PySide2.QtCore.Qt.AspectRatioMode=Qt.IgnoreAspectRatio,mode:PySide2.QtCore.Qt.TransformationMode=Qt.FastTransformation)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.scaledToHeight(self,h:int,mode:PySide2.QtCore.Qt.TransformationMode=Qt.FastTransformation)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.scaledToWidth(self,w:int,mode:PySide2.QtCore.Qt.TransformationMode=Qt.FastTransformation)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.scanLine(self,arg__1:int)->uchar*",
    "PySide2.QtGui.QImage.setAlphaChannel(self,alphaChannel:PySide2.QtGui.QImage)",
    "PySide2.QtGui.QImage.setColor(self,i:int,c:unsigned int)",
    "PySide2.QtGui.QImage.setColorCount(self,arg__1:int)",
    "PySide2.QtGui.QImage.setColorSpace(self,arg__1:PySide2.QtGui.QColorSpace)",
    "PySide2.QtGui.QImage.setColorTable(self,colors:QVector[unsigned int])",
    "PySide2.QtGui.QImage.setDevicePixelRatio(self,scaleFactor:qreal)",
    "PySide2.QtGui.QImage.setDotsPerMeterX(self,arg__1:int)",
    "PySide2.QtGui.QImage.setDotsPerMeterY(self,arg__1:int)",
    "PySide2.QtGui.QImage.setOffset(self,arg__1:PySide2.QtCore.QPoint)",
    "1:PySide2.QtGui.QImage.setPixel(self,pt:PySide2.QtCore.QPoint,index_or_rgb:uint)",
    "0:PySide2.QtGui.QImage.setPixel(self,x:int,y:int,index_or_rgb:uint)",
    "1:PySide2.QtGui.QImage.setPixelColor(self,pt:PySide2.QtCore.QPoint,c:PySide2.QtGui.QColor)",
    "0:PySide2.QtGui.QImage.setPixelColor(self,x:int,y:int,c:PySide2.QtGui.QColor)",
    "PySide2.QtGui.QImage.setText(self,key:QString,value:QString)",
    "PySide2.QtGui.QImage.size(self)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QImage.sizeInBytes(self)->long long",
    "PySide2.QtGui.QImage.smoothScaled(self,w:int,h:int)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImage.swap(self,other:PySide2.QtGui.QImage)",
    "PySide2.QtGui.QImage.text(self,key:QString=QString())->QString",
    "PySide2.QtGui.QImage.textKeys(self)->QStringList",
    "PySide2.QtGui.QImage.toImageFormat(format:PySide2.QtGui.QPixelFormat)->PySide2.QtGui.QImage.Format",
    "PySide2.QtGui.QImage.toPixelFormat(format:PySide2.QtGui.QImage.Format)->PySide2.QtGui.QPixelFormat",
    "1:PySide2.QtGui.QImage.transformed(self,matrix:PySide2.QtGui.QMatrix,mode:PySide2.QtCore.Qt.TransformationMode=Qt.FastTransformation)->PySide2.QtGui.QImage",
    "0:PySide2.QtGui.QImage.transformed(self,matrix:PySide2.QtGui.QTransform,mode:PySide2.QtCore.Qt.TransformationMode=Qt.FastTransformation)->PySide2.QtGui.QImage",
    "1:PySide2.QtGui.QImage.trueMatrix(arg__1:PySide2.QtGui.QMatrix,w:int,h:int)->PySide2.QtGui.QMatrix",
    "0:PySide2.QtGui.QImage.trueMatrix(arg__1:PySide2.QtGui.QTransform,w:int,h:int)->PySide2.QtGui.QTransform",
    "1:PySide2.QtGui.QImage.valid(self,pt:PySide2.QtCore.QPoint)->bool",
    "0:PySide2.QtGui.QImage.valid(self,x:int,y:int)->bool",
    "PySide2.QtGui.QImage.width(self)->int",
    "PySide2.QtGui.QImage.__copy__()",
    "PySide2.QtGui.QImage.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QImage.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QImage(PyObject *module)
{
    _Sbk_QImage_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QImage",
        "QImage",
        &Sbk_QImage_spec,
        &Shiboken::callCppDestructor< ::QImageWrapper >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QImage_Type);
    InitSignatureStrings(pyType, QImage_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QImage_Type), Sbk_QImage_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QImage_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QImage_TypeF(),
        QImage_PythonToCpp_QImage_PTR,
        is_QImage_PythonToCpp_QImage_PTR_Convertible,
        QImage_PTR_CppToPython_QImage,
        QImage_COPY_CppToPython_QImage);

    Shiboken::Conversions::registerConverterName(converter, "QImage");
    Shiboken::Conversions::registerConverterName(converter, "QImage*");
    Shiboken::Conversions::registerConverterName(converter, "QImage&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QImage).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QImageWrapper).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QImage_PythonToCpp_QImage_COPY,
        is_QImage_PythonToCpp_QImage_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQStringREF_PythonToCpp_QImage,
        is_PySide2_QtCore_constQStringREF_PythonToCpp_QImage_Convertible);


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QImage_TypeF(), &Sbk_QImage_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'InvertMode'.
    SbkPySide2_QtGuiTypes[SBK_QIMAGE_INVERTMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QImage_TypeF(),
        "InvertMode",
        "2:PySide2.QtGui.QImage.InvertMode",
        "QImage::InvertMode");
    if (!SbkPySide2_QtGuiTypes[SBK_QIMAGE_INVERTMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_INVERTMODE_IDX],
        Sbk_QImage_TypeF(), "InvertRgb", (long) QImage::InvertMode::InvertRgb))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_INVERTMODE_IDX],
        Sbk_QImage_TypeF(), "InvertRgba", (long) QImage::InvertMode::InvertRgba))
        return;
    // Register converter for enum 'QImage::InvertMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QIMAGE_INVERTMODE_IDX],
            QImage_InvertMode_CppToPython_QImage_InvertMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QImage_InvertMode_PythonToCpp_QImage_InvertMode,
            is_QImage_InvertMode_PythonToCpp_QImage_InvertMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QIMAGE_INVERTMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QImage::InvertMode");
        Shiboken::Conversions::registerConverterName(converter, "InvertMode");
    }
    // End of 'InvertMode' enum.

    // Initialization of enum 'Format'.
    SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QImage_TypeF(),
        "Format",
        "2:PySide2.QtGui.QImage.Format",
        "QImage::Format");
    if (!SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_Invalid", (long) QImage::Format::Format_Invalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_Mono", (long) QImage::Format::Format_Mono))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_MonoLSB", (long) QImage::Format::Format_MonoLSB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_Indexed8", (long) QImage::Format::Format_Indexed8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGB32", (long) QImage::Format::Format_RGB32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_ARGB32", (long) QImage::Format::Format_ARGB32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_ARGB32_Premultiplied", (long) QImage::Format::Format_ARGB32_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGB16", (long) QImage::Format::Format_RGB16))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_ARGB8565_Premultiplied", (long) QImage::Format::Format_ARGB8565_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGB666", (long) QImage::Format::Format_RGB666))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_ARGB6666_Premultiplied", (long) QImage::Format::Format_ARGB6666_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGB555", (long) QImage::Format::Format_RGB555))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_ARGB8555_Premultiplied", (long) QImage::Format::Format_ARGB8555_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGB888", (long) QImage::Format::Format_RGB888))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGB444", (long) QImage::Format::Format_RGB444))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_ARGB4444_Premultiplied", (long) QImage::Format::Format_ARGB4444_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGBX8888", (long) QImage::Format::Format_RGBX8888))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGBA8888", (long) QImage::Format::Format_RGBA8888))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGBA8888_Premultiplied", (long) QImage::Format::Format_RGBA8888_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_BGR30", (long) QImage::Format::Format_BGR30))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_A2BGR30_Premultiplied", (long) QImage::Format::Format_A2BGR30_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGB30", (long) QImage::Format::Format_RGB30))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_A2RGB30_Premultiplied", (long) QImage::Format::Format_A2RGB30_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_Alpha8", (long) QImage::Format::Format_Alpha8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_Grayscale8", (long) QImage::Format::Format_Grayscale8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGBX64", (long) QImage::Format::Format_RGBX64))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGBA64", (long) QImage::Format::Format_RGBA64))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_RGBA64_Premultiplied", (long) QImage::Format::Format_RGBA64_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_Grayscale16", (long) QImage::Format::Format_Grayscale16))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "Format_BGR888", (long) QImage::Format::Format_BGR888))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
        Sbk_QImage_TypeF(), "NImageFormats", (long) QImage::Format::NImageFormats))
        return;
    // Register converter for enum 'QImage::Format'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX],
            QImage_Format_CppToPython_QImage_Format);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QImage_Format_PythonToCpp_QImage_Format,
            is_QImage_Format_PythonToCpp_QImage_Format_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QImage::Format");
        Shiboken::Conversions::registerConverterName(converter, "Format");
    }
    // End of 'Format' enum.


    qRegisterMetaType< ::QImage >("QImage");
    qRegisterMetaType< ::QImage::InvertMode >("QImage::InvertMode");
    qRegisterMetaType< ::QImage::Format >("QImage::Format");
}

