/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QIMAGEIOHANDLERWRAPPER_H
#define SBK_QIMAGEIOHANDLERWRAPPER_H

#define protected public

#include <QtGui/qimageiohandler.h>


// Extra includes
#include <QRect>
#include <qiodevice.h>
#include <qbytearray.h>
#include <QtGui/qimage.h>
#include <qrect.h>
class QImageIOHandlerWrapper : public QImageIOHandler
{
public:
    QImageIOHandlerWrapper();
    bool canRead() const override;
    int currentImageNumber() const override;
    ::QRect currentImageRect() const override;
    int imageCount() const override;
    bool jumpToImage(int imageNumber) override;
    bool jumpToNextImage() override;
    int loopCount() const override;
    ::QByteArray name() const override;
    int nextImageDelay() const override;
    ::QVariant option(::QImageIOHandler::ImageOption option) const override;
    bool read(::QImage * image) override;
    void setOption(::QImageIOHandler::ImageOption option, const ::QVariant & value) override;
    bool supportsOption(::QImageIOHandler::ImageOption option) const override;
    bool write(const ::QImage & image) override;
    ~QImageIOHandlerWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[14];
};

#endif // SBK_QIMAGEIOHANDLERWRAPPER_H

