/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qinputmethodevent_wrapper.h"

// inner classes
#include "qinputmethodevent_attribute_wrapper.h"

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QInputMethodEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QInputMethodEventWrapper::QInputMethodEventWrapper() : QInputMethodEvent()
{
    resetPyMethodCache();
    // ... middle
}

QInputMethodEventWrapper::QInputMethodEventWrapper(const ::QString & preeditText, const ::QList<QInputMethodEvent::Attribute > & attributes) : QInputMethodEvent(preeditText, attributes)
{
    resetPyMethodCache();
    // ... middle
}

QInputMethodEventWrapper::~QInputMethodEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QInputMethodEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QInputMethodEvent >()))
        return -1;

    ::QInputMethodEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethodEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QInputMethodEvent", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QInputMethodEvent::QInputMethodEvent()
    // 1: QInputMethodEvent::QInputMethodEvent(QInputMethodEvent)
    // 2: QInputMethodEvent::QInputMethodEvent(QString,QList<QInputMethodEvent::Attribute>)
    if (numArgs == 0) {
        overloadId = 0; // QInputMethodEvent()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QINPUTMETHODEVENT_ATTRIBUTE_IDX], (pyArgs[1])))) {
        overloadId = 2; // QInputMethodEvent(QString,QList<QInputMethodEvent::Attribute>)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QInputMethodEvent(QInputMethodEvent)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QInputMethodEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QInputMethodEvent()
        {

            if (!PyErr_Occurred()) {
                // QInputMethodEvent()
                cptr = new ::QInputMethodEventWrapper();
            }
            break;
        }
        case 1: // QInputMethodEvent(const QInputMethodEvent & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QInputMethodEvent *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QInputMethodEvent(QInputMethodEvent)
                cptr = new ::QInputMethodEventWrapper(*cppArg0);
            }
            break;
        }
        case 2: // QInputMethodEvent(const QString & preeditText, const QList<QInputMethodEvent::Attribute > & attributes)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QList<QInputMethodEvent::Attribute > cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QInputMethodEvent(QString,QList<QInputMethodEvent::Attribute>)
                cptr = new ::QInputMethodEventWrapper(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QInputMethodEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QInputMethodEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QInputMethodEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QInputMethodEventFunc_attributes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethodEvent.attributes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // attributes()const
            const QList<QInputMethodEvent::Attribute > & cppResult = const_cast<const ::QInputMethodEvent *>(cppSelf)->attributes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QINPUTMETHODEVENT_ATTRIBUTE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodEventFunc_commitString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethodEvent.commitString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // commitString()const
            const QString & cppResult = const_cast<const ::QInputMethodEvent *>(cppSelf)->commitString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodEventFunc_preeditString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethodEvent.preeditString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // preeditString()const
            const QString & cppResult = const_cast<const ::QInputMethodEvent *>(cppSelf)->preeditString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodEventFunc_replacementLength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethodEvent.replacementLength";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // replacementLength()const
            int cppResult = const_cast<const ::QInputMethodEvent *>(cppSelf)->replacementLength();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodEventFunc_replacementStart(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethodEvent.replacementStart";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // replacementStart()const
            int cppResult = const_cast<const ::QInputMethodEvent *>(cppSelf)->replacementStart();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodEventFunc_setCommitString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethodEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethodEvent.setCommitString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QInputMethodEventFunc_setCommitString_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QInputMethodEventFunc_setCommitString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setCommitString", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QInputMethodEvent::setCommitString(QString,int,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setCommitString(QString,int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setCommitString(QString,int,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // setCommitString(QString,int,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QInputMethodEventFunc_setCommitString_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_replaceFrom = Shiboken::String::createStaticString("replaceFrom");
            if (PyDict_Contains(kwds, key_replaceFrom)) {
                value = PyDict_GetItem(kwds, key_replaceFrom);
                if (value && pyArgs[1]) {
                    errInfo = key_replaceFrom;
                    Py_INCREF(errInfo);
                    goto Sbk_QInputMethodEventFunc_setCommitString_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QInputMethodEventFunc_setCommitString_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_replaceFrom);
            }
            static PyObject *const key_replaceLength = Shiboken::String::createStaticString("replaceLength");
            if (PyDict_Contains(kwds, key_replaceLength)) {
                value = PyDict_GetItem(kwds, key_replaceLength);
                if (value && pyArgs[2]) {
                    errInfo = key_replaceLength;
                    Py_INCREF(errInfo);
                    goto Sbk_QInputMethodEventFunc_setCommitString_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QInputMethodEventFunc_setCommitString_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_replaceLength);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QInputMethodEventFunc_setCommitString_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setCommitString(QString,int,int)
            cppSelf->setCommitString(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QInputMethodEventFunc_setCommitString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QInputMethodEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QInputMethodEvent_methods[] = {
    {"attributes", reinterpret_cast<PyCFunction>(Sbk_QInputMethodEventFunc_attributes), METH_NOARGS},
    {"commitString", reinterpret_cast<PyCFunction>(Sbk_QInputMethodEventFunc_commitString), METH_NOARGS},
    {"preeditString", reinterpret_cast<PyCFunction>(Sbk_QInputMethodEventFunc_preeditString), METH_NOARGS},
    {"replacementLength", reinterpret_cast<PyCFunction>(Sbk_QInputMethodEventFunc_replacementLength), METH_NOARGS},
    {"replacementStart", reinterpret_cast<PyCFunction>(Sbk_QInputMethodEventFunc_replacementStart), METH_NOARGS},
    {"setCommitString", reinterpret_cast<PyCFunction>(Sbk_QInputMethodEventFunc_setCommitString), METH_VARARGS|METH_KEYWORDS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QInputMethodEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QInputMethodEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QInputMethodEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QInputMethodEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QInputMethodEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QInputMethodEvent_Type = nullptr;
static SbkObjectType *Sbk_QInputMethodEvent_TypeF(void)
{
    return _Sbk_QInputMethodEvent_Type;
}

static PyType_Slot Sbk_QInputMethodEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QInputMethodEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QInputMethodEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QInputMethodEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QInputMethodEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QInputMethodEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QInputMethodEvent_spec = {
    "2:PySide2.QtGui.QInputMethodEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QInputMethodEvent_slots
};

} //extern "C"

static void *Sbk_QInputMethodEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QInputMethodEvent *>(cptr)->type() == QEvent::InputMethod)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QInputMethodEvent_AttributeType_PythonToCpp_QInputMethodEvent_AttributeType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QInputMethodEvent::AttributeType *>(cppOut) =
        static_cast<::QInputMethodEvent::AttributeType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QInputMethodEvent_AttributeType_PythonToCpp_QInputMethodEvent_AttributeType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX]))
        return QInputMethodEvent_AttributeType_PythonToCpp_QInputMethodEvent_AttributeType;
    return {};
}
static PyObject *QInputMethodEvent_AttributeType_CppToPython_QInputMethodEvent_AttributeType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QInputMethodEvent::AttributeType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QInputMethodEvent_PythonToCpp_QInputMethodEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QInputMethodEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QInputMethodEvent_PythonToCpp_QInputMethodEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QInputMethodEvent_TypeF())))
        return QInputMethodEvent_PythonToCpp_QInputMethodEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QInputMethodEvent_PTR_CppToPython_QInputMethodEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QInputMethodEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QInputMethodEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QInputMethodEvent_SignatureStrings[] = {
    "2:PySide2.QtGui.QInputMethodEvent(self)",
    "1:PySide2.QtGui.QInputMethodEvent(self,other:PySide2.QtGui.QInputMethodEvent)",
    "0:PySide2.QtGui.QInputMethodEvent(self,preeditText:QString,attributes:QList[PySide2.QtGui.QInputMethodEvent.Attribute])",
    "PySide2.QtGui.QInputMethodEvent.attributes(self)->QList[PySide2.QtGui.QInputMethodEvent.Attribute]",
    "PySide2.QtGui.QInputMethodEvent.commitString(self)->QString",
    "PySide2.QtGui.QInputMethodEvent.preeditString(self)->QString",
    "PySide2.QtGui.QInputMethodEvent.replacementLength(self)->int",
    "PySide2.QtGui.QInputMethodEvent.replacementStart(self)->int",
    "PySide2.QtGui.QInputMethodEvent.setCommitString(self,commitString:QString,replaceFrom:int=0,replaceLength:int=0)",
    nullptr}; // Sentinel

void init_QInputMethodEvent(PyObject *module)
{
    _Sbk_QInputMethodEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QInputMethodEvent",
        "QInputMethodEvent*",
        &Sbk_QInputMethodEvent_spec,
        &Shiboken::callCppDestructor< ::QInputMethodEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QInputMethodEvent_Type);
    InitSignatureStrings(pyType, QInputMethodEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QInputMethodEvent_Type), Sbk_QInputMethodEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QInputMethodEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QInputMethodEvent_TypeF(),
        QInputMethodEvent_PythonToCpp_QInputMethodEvent_PTR,
        is_QInputMethodEvent_PythonToCpp_QInputMethodEvent_PTR_Convertible,
        QInputMethodEvent_PTR_CppToPython_QInputMethodEvent);

    Shiboken::Conversions::registerConverterName(converter, "QInputMethodEvent");
    Shiboken::Conversions::registerConverterName(converter, "QInputMethodEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QInputMethodEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QInputMethodEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QInputMethodEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QInputMethodEvent_TypeF(), &Sbk_QInputMethodEvent_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'AttributeType'.
    SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QInputMethodEvent_TypeF(),
        "AttributeType",
        "2:PySide2.QtGui.QInputMethodEvent.AttributeType",
        "QInputMethodEvent::AttributeType");
    if (!SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX],
        Sbk_QInputMethodEvent_TypeF(), "TextFormat", (long) QInputMethodEvent::AttributeType::TextFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX],
        Sbk_QInputMethodEvent_TypeF(), "Cursor", (long) QInputMethodEvent::AttributeType::Cursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX],
        Sbk_QInputMethodEvent_TypeF(), "Language", (long) QInputMethodEvent::AttributeType::Language))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX],
        Sbk_QInputMethodEvent_TypeF(), "Ruby", (long) QInputMethodEvent::AttributeType::Ruby))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX],
        Sbk_QInputMethodEvent_TypeF(), "Selection", (long) QInputMethodEvent::AttributeType::Selection))
        return;
    // Register converter for enum 'QInputMethodEvent::AttributeType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX],
            QInputMethodEvent_AttributeType_CppToPython_QInputMethodEvent_AttributeType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QInputMethodEvent_AttributeType_PythonToCpp_QInputMethodEvent_AttributeType,
            is_QInputMethodEvent_AttributeType_PythonToCpp_QInputMethodEvent_AttributeType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QInputMethodEvent::AttributeType");
        Shiboken::Conversions::registerConverterName(converter, "AttributeType");
    }
    // End of 'AttributeType' enum.

    qRegisterMetaType< ::QInputMethodEvent::AttributeType >("QInputMethodEvent::AttributeType");
}
