/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qkeyevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QKeyEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QKeyEventWrapper::QKeyEventWrapper(::QEvent::Type type, int key, ::QFlags<Qt::KeyboardModifier> modifiers, const ::QString & text, bool autorep, ushort count) : QKeyEvent(type, key, modifiers, text, autorep, count)
{
    resetPyMethodCache();
    // ... middle
}

QKeyEventWrapper::QKeyEventWrapper(::QEvent::Type type, int key, ::QFlags<Qt::KeyboardModifier> modifiers, quint32 nativeScanCode, quint32 nativeVirtualKey, quint32 nativeModifiers, const ::QString & text, bool autorep, ushort count) : QKeyEvent(type, key, modifiers, nativeScanCode, nativeVirtualKey, nativeModifiers, text, autorep, count)
{
    resetPyMethodCache();
    // ... middle
}

QKeyEventWrapper::~QKeyEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QKeyEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QKeyEvent >()))
        return -1;

    ::QKeyEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeyEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 9) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QKeyEvent_Init_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QKeyEvent_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOOOO:QKeyEvent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return -1;


    // Overloaded function decisor
    // 0: QKeyEvent::QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
    // 1: QKeyEvent::QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,quint32,quint32,quint32,QString,bool,ushort)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
        } else if (numArgs >= 6
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[4])))
            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[5])))) {
            if (numArgs == 6) {
                overloadId = 1; // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,quint32,quint32,quint32,QString,bool,ushort)
            } else if (numArgs >= 7
                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[6])))) {
                if (numArgs == 7) {
                    overloadId = 1; // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,quint32,quint32,quint32,QString,bool,ushort)
                } else if (numArgs >= 8
                    && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[7])))) {
                    if (numArgs == 8) {
                        overloadId = 1; // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,quint32,quint32,quint32,QString,bool,ushort)
                    } else if (numArgs >= 9
                        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[8])))) {
                        overloadId = 1; // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,quint32,quint32,quint32,QString,bool,ushort)
                    }
                }
            }
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 0; // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[5])))) {
                    overloadId = 0; // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QKeyEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QKeyEvent(QEvent::Type type, int key, QFlags<Qt::KeyboardModifier> modifiers, const QString & text, bool autorep, ushort count)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_text = Shiboken::String::createStaticString("text");
                if (PyDict_Contains(kwds, key_text)) {
                    value = PyDict_GetItem(kwds, key_text);
                    if (value && pyArgs[3]) {
                        errInfo = key_text;
                        Py_INCREF(errInfo);
                        goto Sbk_QKeyEvent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                            goto Sbk_QKeyEvent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_text);
                }
                static PyObject *const key_autorep = Shiboken::String::createStaticString("autorep");
                if (PyDict_Contains(kwds, key_autorep)) {
                    value = PyDict_GetItem(kwds, key_autorep);
                    if (value && pyArgs[4]) {
                        errInfo = key_autorep;
                        Py_INCREF(errInfo);
                        goto Sbk_QKeyEvent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[4]))))
                            goto Sbk_QKeyEvent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_autorep);
                }
                static PyObject *const key_count = Shiboken::String::createStaticString("count");
                if (PyDict_Contains(kwds, key_count)) {
                    value = PyDict_GetItem(kwds, key_count);
                    if (value && pyArgs[5]) {
                        errInfo = key_count;
                        Py_INCREF(errInfo);
                        goto Sbk_QKeyEvent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[5]))))
                            goto Sbk_QKeyEvent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_count);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QKeyEvent_Init_TypeError;
                }
            }
            ::QEvent::Type cppArg0{QEvent::None};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            bool cppArg4 = false;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            ushort cppArg5 = 1;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
                cptr = new ::QKeyEventWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
        case 1: // QKeyEvent(QEvent::Type type, int key, QFlags<Qt::KeyboardModifier> modifiers, quint32 nativeScanCode, quint32 nativeVirtualKey, quint32 nativeModifiers, const QString & text, bool autorep, ushort count)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_text = Shiboken::String::createStaticString("text");
                if (PyDict_Contains(kwds, key_text)) {
                    value = PyDict_GetItem(kwds, key_text);
                    if (value && pyArgs[6]) {
                        errInfo = key_text;
                        Py_INCREF(errInfo);
                        goto Sbk_QKeyEvent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[6]))))
                            goto Sbk_QKeyEvent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_text);
                }
                static PyObject *const key_autorep = Shiboken::String::createStaticString("autorep");
                if (PyDict_Contains(kwds, key_autorep)) {
                    value = PyDict_GetItem(kwds, key_autorep);
                    if (value && pyArgs[7]) {
                        errInfo = key_autorep;
                        Py_INCREF(errInfo);
                        goto Sbk_QKeyEvent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[7]))))
                            goto Sbk_QKeyEvent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_autorep);
                }
                static PyObject *const key_count = Shiboken::String::createStaticString("count");
                if (PyDict_Contains(kwds, key_count)) {
                    value = PyDict_GetItem(kwds, key_count);
                    if (value && pyArgs[8]) {
                        errInfo = key_count;
                        Py_INCREF(errInfo);
                        goto Sbk_QKeyEvent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[8]))))
                            goto Sbk_QKeyEvent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_count);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QKeyEvent_Init_TypeError;
                }
            }
            ::QEvent::Type cppArg0{QEvent::None};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            quint32 cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            quint32 cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            quint32 cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            ::QString cppArg6 = QString();
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            bool cppArg7 = false;
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
            ushort cppArg8 = 1;
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);

            if (!PyErr_Occurred()) {
                // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,quint32,quint32,quint32,QString,bool,ushort)
                cptr = new ::QKeyEventWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QKeyEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QKeyEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QKeyEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QKeyEventFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeyEvent.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            int cppResult = const_cast<const ::QKeyEvent *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QKeyEventFunc_isAutoRepeat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeyEvent.isAutoRepeat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAutoRepeat()const
            bool cppResult = const_cast<const ::QKeyEvent *>(cppSelf)->isAutoRepeat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QKeyEventFunc_key(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeyEvent.key";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // key()const
            int cppResult = const_cast<const ::QKeyEvent *>(cppSelf)->key();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QKeyEventFunc_matches(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeyEvent.matches";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeyEvent::matches(QKeySequence::StandardKey)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // matches(QKeySequence::StandardKey)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QKeyEventFunc_matches_TypeError;

    // Call function/method
    {
        ::QKeySequence::StandardKey cppArg0{QKeySequence::UnknownKey};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // matches(QKeySequence::StandardKey)const
            bool cppResult = const_cast<const ::QKeyEvent *>(cppSelf)->matches(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QKeyEventFunc_matches_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QKeyEventFunc_modifiers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeyEvent.modifiers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // modifiers()const
            QFlags<Qt::KeyboardModifier> cppResult = const_cast<const ::QKeyEvent *>(cppSelf)->modifiers();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QKeyEventFunc_nativeModifiers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeyEvent.nativeModifiers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeModifiers()const
            quint32 cppResult = const_cast<const ::QKeyEvent *>(cppSelf)->nativeModifiers();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QKeyEventFunc_nativeScanCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeyEvent.nativeScanCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeScanCode()const
            quint32 cppResult = const_cast<const ::QKeyEvent *>(cppSelf)->nativeScanCode();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QKeyEventFunc_nativeVirtualKey(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeyEvent.nativeVirtualKey";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeVirtualKey()const
            quint32 cppResult = const_cast<const ::QKeyEvent *>(cppSelf)->nativeVirtualKey();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QKeyEventFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeyEvent.text";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // text()const
            QString cppResult = const_cast<const ::QKeyEvent *>(cppSelf)->text();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QKeyEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QKeyEvent_methods[] = {
    {"count", reinterpret_cast<PyCFunction>(Sbk_QKeyEventFunc_count), METH_NOARGS},
    {"isAutoRepeat", reinterpret_cast<PyCFunction>(Sbk_QKeyEventFunc_isAutoRepeat), METH_NOARGS},
    {"key", reinterpret_cast<PyCFunction>(Sbk_QKeyEventFunc_key), METH_NOARGS},
    {"matches", reinterpret_cast<PyCFunction>(Sbk_QKeyEventFunc_matches), METH_O},
    {"modifiers", reinterpret_cast<PyCFunction>(Sbk_QKeyEventFunc_modifiers), METH_NOARGS},
    {"nativeModifiers", reinterpret_cast<PyCFunction>(Sbk_QKeyEventFunc_nativeModifiers), METH_NOARGS},
    {"nativeScanCode", reinterpret_cast<PyCFunction>(Sbk_QKeyEventFunc_nativeScanCode), METH_NOARGS},
    {"nativeVirtualKey", reinterpret_cast<PyCFunction>(Sbk_QKeyEventFunc_nativeVirtualKey), METH_NOARGS},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QKeyEventFunc_text), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QKeyEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QKeyEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

// Rich comparison
static PyObject * Sbk_QKeyEvent_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX])->converter, (pyArg)))) {
                // operator!=(QKeySequence::StandardKey arg__1)
                ::QKeySequence::StandardKey cppArg0{QKeySequence::UnknownKey};
                pythonToCpp(pyArg, &cppArg0);
                SBK_UNUSED(cppArg0)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qkeyevent-operatornotequal)]
                bool ret = !(&cppSelf == cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ret);
                // END of custom code block [file: ../glue/qtgui.cpp (qkeyevent-operatornotequal)]
                // ========================================================================

                // End of code injection

            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX])->converter, (pyArg)))) {
                // operator==(QKeySequence::StandardKey key)
                ::QKeySequence::StandardKey cppArg0{QKeySequence::UnknownKey};
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = &cppSelf ==(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX])->converter, (pyArg)))) {
                // operator==(QKeySequence::StandardKey key)
                ::QKeySequence::StandardKey cppArg0{QKeySequence::UnknownKey};
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = &cppSelf ==(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QKeyEvent_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QKeyEvent_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

static PyObject *Sbk_QKeyEvent_get_nScanCode(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint32 cppOut_local = cppSelf->nScanCode;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QKeyEvent_set_nScanCode(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'nScanCode' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'nScanCode', 'quint32' or convertible type expected");
        return -1;
    }

    quint32 cppOut_local = cppSelf->nScanCode;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->nScanCode = cppOut_local;

    return 0;
}

static PyObject *Sbk_QKeyEvent_get_nVirtualKey(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint32 cppOut_local = cppSelf->nVirtualKey;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QKeyEvent_set_nVirtualKey(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'nVirtualKey' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'nVirtualKey', 'quint32' or convertible type expected");
        return -1;
    }

    quint32 cppOut_local = cppSelf->nVirtualKey;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->nVirtualKey = cppOut_local;

    return 0;
}

static PyObject *Sbk_QKeyEvent_get_nModifiers(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint32 cppOut_local = cppSelf->nModifiers;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QKeyEvent_set_nModifiers(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'nModifiers' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'nModifiers', 'quint32' or convertible type expected");
        return -1;
    }

    quint32 cppOut_local = cppSelf->nModifiers;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->nModifiers = cppOut_local;

    return 0;
}

static PyObject *Sbk_QKeyEvent_get_autor(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ushort cppOut_local = cppSelf->autor;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QKeyEvent_set_autor(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'autor' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'autor', 'ushort' or convertible type expected");
        return -1;
    }

    ushort cppOut_local = cppSelf->autor;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->autor = cppOut_local;

    return 0;
}

// Getters and Setters for QKeyEvent
static PyGetSetDef Sbk_QKeyEvent_getsetlist[] = {
    {const_cast<char *>("nScanCode"), Sbk_QKeyEvent_get_nScanCode, Sbk_QKeyEvent_set_nScanCode},
    {const_cast<char *>("nVirtualKey"), Sbk_QKeyEvent_get_nVirtualKey, Sbk_QKeyEvent_set_nVirtualKey},
    {const_cast<char *>("nModifiers"), Sbk_QKeyEvent_get_nModifiers, Sbk_QKeyEvent_set_nModifiers},
    {const_cast<char *>("autor"), Sbk_QKeyEvent_get_autor, Sbk_QKeyEvent_set_autor},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QKeyEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QKeyEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QKeyEvent_Type = nullptr;
static SbkObjectType *Sbk_QKeyEvent_TypeF(void)
{
    return _Sbk_QKeyEvent_Type;
}

static PyType_Slot Sbk_QKeyEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QKeyEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QKeyEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QKeyEvent_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QKeyEvent_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QKeyEvent_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QKeyEvent_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QKeyEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QKeyEvent_spec = {
    "2:PySide2.QtGui.QKeyEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QKeyEvent_slots
};

} //extern "C"

static void *Sbk_QKeyEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QKeyEvent *>(cptr)->type() == QEvent::KeyPress ||  reinterpret_cast< ::QKeyEvent *>(cptr)->type() == QEvent::KeyRelease ||  reinterpret_cast< ::QKeyEvent *>(cptr)->type() == QEvent::ShortcutOverride)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QKeyEvent_PythonToCpp_QKeyEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QKeyEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QKeyEvent_PythonToCpp_QKeyEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QKeyEvent_TypeF())))
        return QKeyEvent_PythonToCpp_QKeyEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QKeyEvent_PTR_CppToPython_QKeyEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QKeyEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QKeyEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QKeyEvent_SignatureStrings[] = {
    "1:PySide2.QtGui.QKeyEvent(self,type:PySide2.QtCore.QEvent.Type,key:int,modifiers:PySide2.QtCore.Qt.KeyboardModifiers,text:QString=QString(),autorep:bool=false,count:ushort=1)",
    "0:PySide2.QtGui.QKeyEvent(self,type:PySide2.QtCore.QEvent.Type,key:int,modifiers:PySide2.QtCore.Qt.KeyboardModifiers,nativeScanCode:quint32,nativeVirtualKey:quint32,nativeModifiers:quint32,text:QString=QString(),autorep:bool=false,count:ushort=1)",
    "PySide2.QtGui.QKeyEvent.count(self)->int",
    "PySide2.QtGui.QKeyEvent.isAutoRepeat(self)->bool",
    "PySide2.QtGui.QKeyEvent.key(self)->int",
    "PySide2.QtGui.QKeyEvent.matches(self,key:PySide2.QtGui.QKeySequence.StandardKey)->bool",
    "PySide2.QtGui.QKeyEvent.modifiers(self)->PySide2.QtCore.Qt.KeyboardModifiers",
    "PySide2.QtGui.QKeyEvent.nativeModifiers(self)->quint32",
    "PySide2.QtGui.QKeyEvent.nativeScanCode(self)->quint32",
    "PySide2.QtGui.QKeyEvent.nativeVirtualKey(self)->quint32",
    "PySide2.QtGui.QKeyEvent.text(self)->QString",
    nullptr}; // Sentinel

void init_QKeyEvent(PyObject *module)
{
    _Sbk_QKeyEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QKeyEvent",
        "QKeyEvent*",
        &Sbk_QKeyEvent_spec,
        &Shiboken::callCppDestructor< ::QKeyEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QKeyEvent_Type);
    InitSignatureStrings(pyType, QKeyEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QKeyEvent_Type), Sbk_QKeyEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QKeyEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QKeyEvent_TypeF(),
        QKeyEvent_PythonToCpp_QKeyEvent_PTR,
        is_QKeyEvent_PythonToCpp_QKeyEvent_PTR_Convertible,
        QKeyEvent_PTR_CppToPython_QKeyEvent);

    Shiboken::Conversions::registerConverterName(converter, "QKeyEvent");
    Shiboken::Conversions::registerConverterName(converter, "QKeyEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QKeyEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QKeyEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QKeyEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QKeyEvent_TypeF(), &Sbk_QKeyEvent_typeDiscovery);

}
