/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qoffscreensurface_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QOffscreenSurfaceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QOffscreenSurfaceWrapper::QOffscreenSurfaceWrapper(::QScreen * screen) : QOffscreenSurface(screen)
{
    resetPyMethodCache();
    // ... middle
}

QOffscreenSurfaceWrapper::QOffscreenSurfaceWrapper(::QScreen * screen, ::QObject * parent) : QOffscreenSurface(screen, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QOffscreenSurfaceWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QOffscreenSurfaceWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QOffscreenSurfaceWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QOffscreenSurfaceWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QOffscreenSurfaceWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOffscreenSurface.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QOffscreenSurfaceWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOffscreenSurface.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QSurfaceFormat QOffscreenSurfaceWrapper::format() const
{
    if (m_PyMethodCache[6])
        return this->::QOffscreenSurface::format();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "format";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QOffscreenSurface::format();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOffscreenSurface.format", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSurfaceFormat >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSurfaceFormat cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QOffscreenSurfaceWrapper::size() const
{
    if (m_PyMethodCache[8])
        return this->::QOffscreenSurface::size();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "size";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QOffscreenSurface::size();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOffscreenSurface.size", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSurface::SurfaceType QOffscreenSurfaceWrapper::surfaceType() const
{
    if (m_PyMethodCache[9])
        return this->::QOffscreenSurface::surfaceType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QSurface::RasterSurface;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "surfaceType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QOffscreenSurface::surfaceType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QSurface::RasterSurface;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOffscreenSurface.surfaceType", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSurface::SurfaceType >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QSurface::RasterSurface;
    }
    ::QSurface::SurfaceType cppResult{QSurface::RasterSurface};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QOffscreenSurfaceWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[10]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QOffscreenSurfaceWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QOffscreenSurface::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QOffscreenSurfaceWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QOffscreenSurface::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QOffscreenSurfaceWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QOffscreenSurfaceWrapper *>(this));
        return QOffscreenSurface::qt_metacast(_clname);
}

QOffscreenSurfaceWrapper::~QOffscreenSurfaceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOffscreenSurface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX]);
    if (type != myType)
        Shiboken::ObjectType::copyMultipleInheritance(type, myType);

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOffscreenSurface >()))
        return -1;

    ::QOffscreenSurfaceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QOffscreenSurface", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QOffscreenSurface::QOffscreenSurface(QScreen*)
    // 1: QOffscreenSurface::QOffscreenSurface(QScreen*,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QOffscreenSurface(QScreen*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QOffscreenSurface(QScreen*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QOffscreenSurface(QScreen*,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOffscreenSurface_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QOffscreenSurface(QScreen * screen)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_screen = Shiboken::String::createStaticString("screen");
                if (PyDict_Contains(kwds, key_screen)) {
                    value = PyDict_GetItem(kwds, key_screen);
                    if (value && pyArgs[0]) {
                        errInfo = key_screen;
                        Py_INCREF(errInfo);
                        goto Sbk_QOffscreenSurface_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), (pyArgs[0]))))
                            goto Sbk_QOffscreenSurface_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_screen);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScreen *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QOffscreenSurface(QScreen*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QOffscreenSurfaceWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QOffscreenSurfaceWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // QOffscreenSurface(QScreen * screen, QObject * parent)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QOffscreenSurface_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScreen *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QOffscreenSurface(QScreen*,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QOffscreenSurfaceWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QOffscreenSurfaceWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOffscreenSurface >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOffscreenSurface_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QOffscreenSurface_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QOffscreenSurface_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOffscreenSurfaceFunc_create(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.create";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // create()
            cppSelf->create();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOffscreenSurfaceFunc_destroy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.destroy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destroy()
            cppSelf->destroy();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOffscreenSurfaceFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QSurfaceFormat cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QOffscreenSurface *>(cppSelf)->::QOffscreenSurface::format()
                : const_cast<const ::QOffscreenSurface *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOffscreenSurfaceFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QOffscreenSurface *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOffscreenSurfaceFunc_nativeHandle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.nativeHandle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeHandle()const
            void * cppResult = const_cast<const ::QOffscreenSurface *>(cppSelf)->nativeHandle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOffscreenSurfaceFunc_requestedFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.requestedFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // requestedFormat()const
            QSurfaceFormat cppResult = const_cast<const ::QOffscreenSurface *>(cppSelf)->requestedFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOffscreenSurfaceFunc_screen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.screen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // screen()const
            QScreen * cppResult = const_cast<const ::QOffscreenSurface *>(cppSelf)->screen();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOffscreenSurfaceFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOffscreenSurface::setFormat(QSurfaceFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // setFormat(QSurfaceFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOffscreenSurfaceFunc_setFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSurfaceFormat cppArg0_local;
        ::QSurfaceFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFormat(QSurfaceFormat)
            cppSelf->setFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOffscreenSurfaceFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOffscreenSurfaceFunc_setNativeHandle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.setNativeHandle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOffscreenSurface::setNativeHandle(void*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArg)))) {
        overloadId = 0; // setNativeHandle(void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOffscreenSurfaceFunc_setNativeHandle_TypeError;

    // Call function/method
    {
        void* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNativeHandle(void*)
            cppSelf->setNativeHandle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOffscreenSurfaceFunc_setNativeHandle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOffscreenSurfaceFunc_setScreen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.setScreen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOffscreenSurface::setScreen(QScreen*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), (pyArg)))) {
        overloadId = 0; // setScreen(QScreen*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOffscreenSurfaceFunc_setScreen_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScreen *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setScreen(QScreen*)
            cppSelf->setScreen(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOffscreenSurfaceFunc_setScreen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOffscreenSurfaceFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QOffscreenSurface *>(cppSelf)->::QOffscreenSurface::size()
                : const_cast<const ::QOffscreenSurface *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOffscreenSurfaceFunc_surfaceHandle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.surfaceHandle";
    SBK_UNUSED(fullName)

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "surfaceHandle() const");
        return {};
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOffscreenSurfaceFunc_surfaceType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOffscreenSurface.surfaceType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // surfaceType()const
            QSurface::SurfaceType cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QOffscreenSurface *>(cppSelf)->::QOffscreenSurface::surfaceType()
                : const_cast<const ::QOffscreenSurface *>(cppSelf)->surfaceType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QOffscreenSurface_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOffscreenSurface_methods[] = {
    {"create", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_create), METH_NOARGS},
    {"destroy", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_destroy), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_format), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_isValid), METH_NOARGS},
    {"nativeHandle", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_nativeHandle), METH_NOARGS},
    {"requestedFormat", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_requestedFormat), METH_NOARGS},
    {"screen", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_screen), METH_NOARGS},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_setFormat), METH_O},
    {"setNativeHandle", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_setNativeHandle), METH_O},
    {"setScreen", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_setScreen), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_size), METH_NOARGS},
    {"surfaceHandle", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_surfaceHandle), METH_NOARGS},
    {"surfaceType", reinterpret_cast<PyCFunction>(Sbk_QOffscreenSurfaceFunc_surfaceType), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QOffscreenSurface_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QOffscreenSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QOffscreenSurfaceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QOffscreenSurface_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOffscreenSurface_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static int mi_offsets[] = { -1, -1, -1, -1, -1 };
int *
Sbk_QOffscreenSurface_mi_init(const void *cptr)
{
    if (mi_offsets[0] == -1) {
        std::set<int> offsets;
        const auto *class_ptr = reinterpret_cast<const QOffscreenSurface *>(cptr);
        const auto base = reinterpret_cast<uintptr_t>(class_ptr);
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(class_ptr)) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(static_cast<const QOffscreenSurface *>(static_cast<const void *>(class_ptr)))) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QSurface *>(class_ptr)) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QSurface *>(static_cast<const QOffscreenSurface *>(static_cast<const void *>(class_ptr)))) - base));

        offsets.erase(0);

        std::copy(offsets.cbegin(), offsets.cend(), mi_offsets);
    }
    return mi_offsets;
}
static void * Sbk_QOffscreenSurfaceSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QOffscreenSurface *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX]))
        return static_cast< ::QSurface *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOffscreenSurface_Type = nullptr;
static SbkObjectType *Sbk_QOffscreenSurface_TypeF(void)
{
    return _Sbk_QOffscreenSurface_Type;
}

static PyType_Slot Sbk_QOffscreenSurface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QOffscreenSurface_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOffscreenSurface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOffscreenSurface_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOffscreenSurface_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOffscreenSurface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOffscreenSurface_spec = {
    "2:PySide2.QtGui.QOffscreenSurface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOffscreenSurface_slots
};

} //extern "C"

static void *Sbk_QOffscreenSurface_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QOffscreenSurface *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QSurface >()))
        return dynamic_cast< ::QOffscreenSurface *>(reinterpret_cast< ::QSurface *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOffscreenSurface_PythonToCpp_QOffscreenSurface_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOffscreenSurface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOffscreenSurface_PythonToCpp_QOffscreenSurface_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOffscreenSurface_TypeF())))
        return QOffscreenSurface_PythonToCpp_QOffscreenSurface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOffscreenSurface_PTR_CppToPython_QOffscreenSurface(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QOffscreenSurface *>(const_cast<void *>(cppIn)), Sbk_QOffscreenSurface_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOffscreenSurface_SignatureStrings[] = {
    "1:PySide2.QtGui.QOffscreenSurface(self,screen:PySide2.QtGui.QScreen=nullptr)",
    "0:PySide2.QtGui.QOffscreenSurface(self,screen:PySide2.QtGui.QScreen,parent:PySide2.QtCore.QObject)",
    "PySide2.QtGui.QOffscreenSurface.create(self)",
    "PySide2.QtGui.QOffscreenSurface.destroy(self)",
    "PySide2.QtGui.QOffscreenSurface.format(self)->PySide2.QtGui.QSurfaceFormat",
    "PySide2.QtGui.QOffscreenSurface.isValid(self)->bool",
    "PySide2.QtGui.QOffscreenSurface.nativeHandle(self)->void",
    "PySide2.QtGui.QOffscreenSurface.requestedFormat(self)->PySide2.QtGui.QSurfaceFormat",
    "PySide2.QtGui.QOffscreenSurface.screen(self)->PySide2.QtGui.QScreen",
    "PySide2.QtGui.QOffscreenSurface.setFormat(self,format:PySide2.QtGui.QSurfaceFormat)",
    "PySide2.QtGui.QOffscreenSurface.setNativeHandle(self,handle:void)",
    "PySide2.QtGui.QOffscreenSurface.setScreen(self,screen:PySide2.QtGui.QScreen)",
    "PySide2.QtGui.QOffscreenSurface.size(self)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QOffscreenSurface.surfaceHandle(self)->QPlatformSurface*",
    "PySide2.QtGui.QOffscreenSurface.surfaceType(self)->PySide2.QtGui.QSurface.SurfaceType",
    nullptr}; // Sentinel

void init_QOffscreenSurface(PyObject *module)
{
    PyObject *Sbk_QOffscreenSurface_Type_bases = PyTuple_Pack(2,
        reinterpret_cast<PyObject *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        reinterpret_cast<PyObject *>(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX]));

    _Sbk_QOffscreenSurface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOffscreenSurface",
        "QOffscreenSurface*",
        &Sbk_QOffscreenSurface_spec,
        &Shiboken::callCppDestructor< ::QOffscreenSurface >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        Sbk_QOffscreenSurface_Type_bases,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOffscreenSurface_Type);
    InitSignatureStrings(pyType, QOffscreenSurface_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOffscreenSurface_Type), Sbk_QOffscreenSurface_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOFFSCREENSURFACE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOffscreenSurface_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOffscreenSurface_TypeF(),
        QOffscreenSurface_PythonToCpp_QOffscreenSurface_PTR,
        is_QOffscreenSurface_PythonToCpp_QOffscreenSurface_PTR_Convertible,
        QOffscreenSurface_PTR_CppToPython_QOffscreenSurface);

    Shiboken::Conversions::registerConverterName(converter, "QOffscreenSurface");
    Shiboken::Conversions::registerConverterName(converter, "QOffscreenSurface*");
    Shiboken::Conversions::registerConverterName(converter, "QOffscreenSurface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOffscreenSurface).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOffscreenSurfaceWrapper).name());


    MultipleInheritanceInitFunction func = Sbk_QOffscreenSurface_mi_init;
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QOffscreenSurface_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QOffscreenSurface_TypeF(), &Sbk_QOffscreenSurfaceSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QOffscreenSurface_TypeF(), &Sbk_QOffscreenSurface_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QOffscreenSurface_TypeF(), &::QOffscreenSurface::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QOffscreenSurface_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QOffscreenSurface_TypeF(), &::QOffscreenSurface::staticMetaObject, sizeof(QOffscreenSurfaceWrapper));
}
