/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qopenglcontext_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QOpenGLContextWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QOpenGLContextWrapper::QOpenGLContextWrapper(::QObject * parent) : QOpenGLContext(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QOpenGLContextWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QOpenGLContextWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QOpenGLContextWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QOpenGLContextWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QOpenGLContextWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOpenGLContext.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QOpenGLContextWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOpenGLContext.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QOpenGLContextWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QOpenGLContextWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QOpenGLContext::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QOpenGLContextWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QOpenGLContext::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QOpenGLContextWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QOpenGLContextWrapper *>(this));
        return QOpenGLContext::qt_metacast(_clname);
}

QOpenGLContextWrapper::~QOpenGLContextWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLContext_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLContext >()))
        return -1;

    ::QOpenGLContextWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QOpenGLContext", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QOpenGLContext::QOpenGLContext(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QOpenGLContext(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QOpenGLContext(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLContext_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLContext_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QOpenGLContext_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QOpenGLContext(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QOpenGLContextWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QOpenGLContextWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLContext >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOpenGLContext_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QOpenGLContext_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QOpenGLContext_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOpenGLContextFunc_areSharing(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.areSharing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "areSharing", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QOpenGLContext::areSharing(QOpenGLContext*,QOpenGLContext*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // areSharing(QOpenGLContext*,QOpenGLContext*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLContextFunc_areSharing_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QOpenGLContext *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QOpenGLContext *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // areSharing(QOpenGLContext*,QOpenGLContext*)
            bool cppResult = ::QOpenGLContext::areSharing(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLContextFunc_areSharing_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLContextFunc_create(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.create";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // create()
            bool cppResult = cppSelf->create();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_currentContext(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.currentContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentContext()
            QOpenGLContext * cppResult = ::QOpenGLContext::currentContext();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_defaultFramebufferObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.defaultFramebufferObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultFramebufferObject()const
            unsigned int cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->defaultFramebufferObject();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_doneCurrent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.doneCurrent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // doneCurrent()
            cppSelf->doneCurrent();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLContextFunc_extensions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.extensions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // extensions()const
            QSet<QByteArray > cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->extensions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QSET_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_extraFunctions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.extraFunctions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // extraFunctions()const
            QOpenGLExtraFunctions * cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->extraFunctions();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLEXTRAFUNCTIONS_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QSurfaceFormat cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_functions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.functions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // functions()const
            QOpenGLFunctions * cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->functions();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLFUNCTIONS_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_globalShareContext(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.globalShareContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalShareContext()
            QOpenGLContext * cppResult = ::QOpenGLContext::globalShareContext();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_hasExtension(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.hasExtension";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLContext::hasExtension(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // hasExtension(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLContextFunc_hasExtension_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // hasExtension(QByteArray)const
            bool cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->hasExtension(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLContextFunc_hasExtension_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLContextFunc_isOpenGLES(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.isOpenGLES";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isOpenGLES()const
            bool cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->isOpenGLES();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_makeCurrent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.makeCurrent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLContext::makeCurrent(QSurface*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX]), (pyArg)))) {
        overloadId = 0; // makeCurrent(QSurface*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLContextFunc_makeCurrent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSurface *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // makeCurrent(QSurface*)
            bool cppResult = cppSelf->makeCurrent(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLContextFunc_makeCurrent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLContextFunc_nativeHandle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.nativeHandle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeHandle()const
            QVariant cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->nativeHandle();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_openGLModuleHandle(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.openGLModuleHandle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // openGLModuleHandle()
            void * cppResult = ::QOpenGLContext::openGLModuleHandle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_openGLModuleType(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.openGLModuleType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // openGLModuleType()
            QOpenGLContext::OpenGLModuleType cppResult = ::QOpenGLContext::openGLModuleType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_OPENGLMODULETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_screen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.screen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // screen()const
            QScreen * cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->screen();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLContext::setFormat(QSurfaceFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // setFormat(QSurfaceFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLContextFunc_setFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSurfaceFormat cppArg0_local;
        ::QSurfaceFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFormat(QSurfaceFormat)
            cppSelf->setFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLContextFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLContextFunc_setNativeHandle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.setNativeHandle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLContext::setNativeHandle(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setNativeHandle(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLContextFunc_setNativeHandle_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNativeHandle(QVariant)
            cppSelf->setNativeHandle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLContextFunc_setNativeHandle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLContextFunc_setScreen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.setScreen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLContext::setScreen(QScreen*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), (pyArg)))) {
        overloadId = 0; // setScreen(QScreen*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLContextFunc_setScreen_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScreen *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setScreen(QScreen*)
            cppSelf->setScreen(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLContextFunc_setScreen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLContextFunc_setShareContext(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.setShareContext";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLContext::setShareContext(QOpenGLContext*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), (pyArg)))) {
        overloadId = 0; // setShareContext(QOpenGLContext*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLContextFunc_setShareContext_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QOpenGLContext *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setShareContext(QOpenGLContext*)
            cppSelf->setShareContext(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLContextFunc_setShareContext_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLContextFunc_shareContext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.shareContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shareContext()const
            QOpenGLContext * cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->shareContext();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_shareGroup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.shareGroup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shareGroup()const
            QOpenGLContextGroup * cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->shareGroup();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXTGROUP_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_supportsThreadedOpenGL(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.supportsThreadedOpenGL";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsThreadedOpenGL()
            bool cppResult = ::QOpenGLContext::supportsThreadedOpenGL();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_surface(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.surface";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // surface()const
            QSurface * cppResult = const_cast<const ::QOpenGLContext *>(cppSelf)->surface();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLContextFunc_swapBuffers(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.swapBuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLContext::swapBuffers(QSurface*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX]), (pyArg)))) {
        overloadId = 0; // swapBuffers(QSurface*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLContextFunc_swapBuffers_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSurface *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // swapBuffers(QSurface*)
            cppSelf->swapBuffers(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLContextFunc_swapBuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLContextFunc_versionFunctions(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLContext.versionFunctions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLContextFunc_versionFunctions_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:versionFunctions", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLContext::versionFunctions(QOpenGLVersionProfile)const
    if (numArgs == 0) {
        overloadId = 0; // versionFunctions(QOpenGLVersionProfile)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // versionFunctions(QOpenGLVersionProfile)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLContextFunc_versionFunctions_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_versionProfile = Shiboken::String::createStaticString("versionProfile");
            if (PyDict_Contains(kwds, key_versionProfile)) {
                value = PyDict_GetItem(kwds, key_versionProfile);
                if (value && pyArgs[0]) {
                    errInfo = key_versionProfile;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLContextFunc_versionFunctions_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]), (pyArgs[0]))))
                        goto Sbk_QOpenGLContextFunc_versionFunctions_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_versionProfile);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QOpenGLContextFunc_versionFunctions_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QOpenGLVersionProfile cppArg0_local = QOpenGLVersionProfile();
        ::QOpenGLVersionProfile *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // versionFunctions(QOpenGLVersionProfile)const
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qopenglcontext-versionfunctions)]

            // cppSelf->versionFunctions(*cppArg0, %2); Pretend to shiboken we call the function

            // Import QtOpenGLFunctions and call the factory function
            // QOpenGLVersionFunctionsFactory.get()
            PyObject *module = PyImport_ImportModule("PySide2.QtOpenGLFunctions");
            if (module == nullptr)
                return nullptr;
            PyObject *loc = PyModule_GetDict(module);
            static PyObject *const factoryName =
                Shiboken::String::createStaticString("QOpenGLVersionFunctionsFactory");
            auto factory = PyDict_GetItem(loc, factoryName);
            if (factory == nullptr)
                return nullptr;

            static PyObject *const getMethod = Shiboken::String::createStaticString("get");
            pyResult = PyObject_CallMethodObjArgs(factory, getMethod, pyArgs[0], self,
                                                   nullptr);
            // END of custom code block [file: ../glue/qtgui.cpp (qopenglcontext-versionfunctions)]
            // ========================================================================

            // End of code injection

            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLContextFunc_versionFunctions_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QOpenGLContext_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLContext_methods[] = {
    {"areSharing", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_areSharing), METH_VARARGS|METH_STATIC},
    {"create", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_create), METH_NOARGS},
    {"currentContext", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_currentContext), METH_NOARGS|METH_STATIC},
    {"defaultFramebufferObject", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_defaultFramebufferObject), METH_NOARGS},
    {"doneCurrent", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_doneCurrent), METH_NOARGS},
    {"extensions", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_extensions), METH_NOARGS},
    {"extraFunctions", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_extraFunctions), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_format), METH_NOARGS},
    {"functions", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_functions), METH_NOARGS},
    {"globalShareContext", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_globalShareContext), METH_NOARGS|METH_STATIC},
    {"hasExtension", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_hasExtension), METH_O},
    {"isOpenGLES", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_isOpenGLES), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_isValid), METH_NOARGS},
    {"makeCurrent", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_makeCurrent), METH_O},
    {"nativeHandle", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_nativeHandle), METH_NOARGS},
    {"openGLModuleHandle", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_openGLModuleHandle), METH_NOARGS|METH_STATIC},
    {"openGLModuleType", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_openGLModuleType), METH_NOARGS|METH_STATIC},
    {"screen", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_screen), METH_NOARGS},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_setFormat), METH_O},
    {"setNativeHandle", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_setNativeHandle), METH_O},
    {"setScreen", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_setScreen), METH_O},
    {"setShareContext", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_setShareContext), METH_O},
    {"shareContext", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_shareContext), METH_NOARGS},
    {"shareGroup", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_shareGroup), METH_NOARGS},
    {"supportsThreadedOpenGL", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_supportsThreadedOpenGL), METH_NOARGS|METH_STATIC},
    {"surface", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_surface), METH_NOARGS},
    {"swapBuffers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_swapBuffers), METH_O},
    {"versionFunctions", reinterpret_cast<PyCFunction>(Sbk_QOpenGLContextFunc_versionFunctions), METH_VARARGS|METH_KEYWORDS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QOpenGLContext_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QOpenGLContextWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QOpenGLContext_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLContext_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QOpenGLContext__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLContext_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLContext_TypeF(void)
{
    return _Sbk_QOpenGLContext_Type;
}

static PyType_Slot Sbk_QOpenGLContext_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QOpenGLContext__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QOpenGLContext_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLContext_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLContext_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLContext_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLContext_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLContext_spec = {
    "2:PySide2.QtGui.QOpenGLContext",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLContext_slots
};

} //extern "C"

static void *Sbk_QOpenGLContext_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QOpenGLContext *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QOpenGLContext_OpenGLModuleType_PythonToCpp_QOpenGLContext_OpenGLModuleType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLContext::OpenGLModuleType *>(cppOut) =
        static_cast<::QOpenGLContext::OpenGLModuleType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLContext_OpenGLModuleType_PythonToCpp_QOpenGLContext_OpenGLModuleType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_OPENGLMODULETYPE_IDX]))
        return QOpenGLContext_OpenGLModuleType_PythonToCpp_QOpenGLContext_OpenGLModuleType;
    return {};
}
static PyObject *QOpenGLContext_OpenGLModuleType_CppToPython_QOpenGLContext_OpenGLModuleType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLContext::OpenGLModuleType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_OPENGLMODULETYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLContext_PythonToCpp_QOpenGLContext_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLContext_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLContext_PythonToCpp_QOpenGLContext_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLContext_TypeF())))
        return QOpenGLContext_PythonToCpp_QOpenGLContext_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLContext_PTR_CppToPython_QOpenGLContext(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QOpenGLContext *>(const_cast<void *>(cppIn)), Sbk_QOpenGLContext_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLContext_SignatureStrings[] = {
    "PySide2.QtGui.QOpenGLContext(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtGui.QOpenGLContext.areSharing(first:PySide2.QtGui.QOpenGLContext,second:PySide2.QtGui.QOpenGLContext)->bool",
    "PySide2.QtGui.QOpenGLContext.create(self)->bool",
    "PySide2.QtGui.QOpenGLContext.currentContext()->PySide2.QtGui.QOpenGLContext",
    "PySide2.QtGui.QOpenGLContext.defaultFramebufferObject(self)->unsigned int",
    "PySide2.QtGui.QOpenGLContext.doneCurrent(self)",
    "PySide2.QtGui.QOpenGLContext.extensions(self)->QSet[PySide2.QtCore.QByteArray]",
    "PySide2.QtGui.QOpenGLContext.extraFunctions(self)->PySide2.QtGui.QOpenGLExtraFunctions",
    "PySide2.QtGui.QOpenGLContext.format(self)->PySide2.QtGui.QSurfaceFormat",
    "PySide2.QtGui.QOpenGLContext.functions(self)->PySide2.QtGui.QOpenGLFunctions",
    "PySide2.QtGui.QOpenGLContext.globalShareContext()->PySide2.QtGui.QOpenGLContext",
    "PySide2.QtGui.QOpenGLContext.hasExtension(self,extension:PySide2.QtCore.QByteArray)->bool",
    "PySide2.QtGui.QOpenGLContext.isOpenGLES(self)->bool",
    "PySide2.QtGui.QOpenGLContext.isValid(self)->bool",
    "PySide2.QtGui.QOpenGLContext.makeCurrent(self,surface:PySide2.QtGui.QSurface)->bool",
    "PySide2.QtGui.QOpenGLContext.nativeHandle(self)->QVariant",
    "PySide2.QtGui.QOpenGLContext.openGLModuleHandle()->void",
    "PySide2.QtGui.QOpenGLContext.openGLModuleType()->PySide2.QtGui.QOpenGLContext.OpenGLModuleType",
    "PySide2.QtGui.QOpenGLContext.screen(self)->PySide2.QtGui.QScreen",
    "PySide2.QtGui.QOpenGLContext.setFormat(self,format:PySide2.QtGui.QSurfaceFormat)",
    "PySide2.QtGui.QOpenGLContext.setNativeHandle(self,handle:QVariant)",
    "PySide2.QtGui.QOpenGLContext.setScreen(self,screen:PySide2.QtGui.QScreen)",
    "PySide2.QtGui.QOpenGLContext.setShareContext(self,shareContext:PySide2.QtGui.QOpenGLContext)",
    "PySide2.QtGui.QOpenGLContext.shareContext(self)->PySide2.QtGui.QOpenGLContext",
    "PySide2.QtGui.QOpenGLContext.shareGroup(self)->PySide2.QtGui.QOpenGLContextGroup",
    "PySide2.QtGui.QOpenGLContext.supportsThreadedOpenGL()->bool",
    "PySide2.QtGui.QOpenGLContext.surface(self)->PySide2.QtGui.QSurface",
    "PySide2.QtGui.QOpenGLContext.swapBuffers(self,surface:PySide2.QtGui.QSurface)",
    "PySide2.QtGui.QOpenGLContext.versionFunctions(self,versionProfile:PySide2.QtGui.QOpenGLVersionProfile=QOpenGLVersionProfile())->PySide2.QtGui.QAbstractOpenGLFunctions",
    nullptr}; // Sentinel

void init_QOpenGLContext(PyObject *module)
{
    _Sbk_QOpenGLContext_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLContext",
        "QOpenGLContext*",
        &Sbk_QOpenGLContext_spec,
        &Shiboken::callCppDestructor< ::QOpenGLContext >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLContext_Type);
    InitSignatureStrings(pyType, QOpenGLContext_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLContext_Type), Sbk_QOpenGLContext_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLContext_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLContext_TypeF(),
        QOpenGLContext_PythonToCpp_QOpenGLContext_PTR,
        is_QOpenGLContext_PythonToCpp_QOpenGLContext_PTR_Convertible,
        QOpenGLContext_PTR_CppToPython_QOpenGLContext);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLContext");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLContext*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLContext&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLContext).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLContextWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QOpenGLContext_TypeF(), &Sbk_QOpenGLContext_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'OpenGLModuleType'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_OPENGLMODULETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLContext_TypeF(),
        "OpenGLModuleType",
        "2:PySide2.QtGui.QOpenGLContext.OpenGLModuleType",
        "QOpenGLContext::OpenGLModuleType");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_OPENGLMODULETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_OPENGLMODULETYPE_IDX],
        Sbk_QOpenGLContext_TypeF(), "LibGL", (long) QOpenGLContext::OpenGLModuleType::LibGL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_OPENGLMODULETYPE_IDX],
        Sbk_QOpenGLContext_TypeF(), "LibGLES", (long) QOpenGLContext::OpenGLModuleType::LibGLES))
        return;
    // Register converter for enum 'QOpenGLContext::OpenGLModuleType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_OPENGLMODULETYPE_IDX],
            QOpenGLContext_OpenGLModuleType_CppToPython_QOpenGLContext_OpenGLModuleType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLContext_OpenGLModuleType_PythonToCpp_QOpenGLContext_OpenGLModuleType,
            is_QOpenGLContext_OpenGLModuleType_PythonToCpp_QOpenGLContext_OpenGLModuleType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_OPENGLMODULETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLContext::OpenGLModuleType");
        Shiboken::Conversions::registerConverterName(converter, "OpenGLModuleType");
    }
    // End of 'OpenGLModuleType' enum.

    PySide::Signal::registerSignals(Sbk_QOpenGLContext_TypeF(), &::QOpenGLContext::staticMetaObject);
    qRegisterMetaType< ::QOpenGLContext::OpenGLModuleType >("QOpenGLContext::OpenGLModuleType");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QOpenGLContext_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QOpenGLContext_TypeF(), &::QOpenGLContext::staticMetaObject, sizeof(QOpenGLContextWrapper));
}
