/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qopengldebuglogger_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QOpenGLDebugLoggerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QOpenGLDebugLoggerWrapper::QOpenGLDebugLoggerWrapper(::QObject * parent) : QOpenGLDebugLogger(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QOpenGLDebugLoggerWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QOpenGLDebugLoggerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QOpenGLDebugLoggerWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QOpenGLDebugLoggerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QOpenGLDebugLoggerWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOpenGLDebugLogger.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QOpenGLDebugLoggerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOpenGLDebugLogger.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QOpenGLDebugLoggerWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QOpenGLDebugLoggerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QOpenGLDebugLogger::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QOpenGLDebugLoggerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QOpenGLDebugLogger::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QOpenGLDebugLoggerWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QOpenGLDebugLoggerWrapper *>(this));
        return QOpenGLDebugLogger::qt_metacast(_clname);
}

QOpenGLDebugLoggerWrapper::~QOpenGLDebugLoggerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLDebugLogger_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLDebugLogger >()))
        return -1;

    ::QOpenGLDebugLoggerWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QOpenGLDebugLogger", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QOpenGLDebugLogger::QOpenGLDebugLogger(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QOpenGLDebugLogger(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QOpenGLDebugLogger(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLDebugLogger_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLDebugLogger_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QOpenGLDebugLogger_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QOpenGLDebugLogger(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QOpenGLDebugLoggerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QOpenGLDebugLoggerWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLDebugLogger >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOpenGLDebugLogger_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QOpenGLDebugLogger_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QOpenGLDebugLogger_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOpenGLDebugLoggerFunc_disableMessages(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.disableMessages";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:disableMessages", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLDebugLogger::disableMessages(QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>,QFlags<QOpenGLDebugMessage::Severity>)
    // 1: QOpenGLDebugLogger::disableMessages(QVector<uint>,QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>)
    if (numArgs == 0) {
        overloadId = 0; // disableMessages(QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>,QFlags<QOpenGLDebugMessage::Severity>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_UNSIGNEDINT_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // disableMessages(QVector<uint>,QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // disableMessages(QVector<uint>,QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 1; // disableMessages(QVector<uint>,QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // disableMessages(QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>,QFlags<QOpenGLDebugMessage::Severity>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // disableMessages(QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>,QFlags<QOpenGLDebugMessage::Severity>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // disableMessages(QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>,QFlags<QOpenGLDebugMessage::Severity>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // disableMessages(QFlags<QOpenGLDebugMessage::Source> sources, QFlags<QOpenGLDebugMessage::Type> types, QFlags<QOpenGLDebugMessage::Severity> severities)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_sources = Shiboken::String::createStaticString("sources");
                if (PyDict_Contains(kwds, key_sources)) {
                    value = PyDict_GetItem(kwds, key_sources);
                    if (value && pyArgs[0]) {
                        errInfo = key_sources;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sources);
                }
                static PyObject *const key_types = Shiboken::String::createStaticString("types");
                if (PyDict_Contains(kwds, key_types)) {
                    value = PyDict_GetItem(kwds, key_types);
                    if (value && pyArgs[1]) {
                        errInfo = key_types;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_types);
                }
                static PyObject *const key_severities = Shiboken::String::createStaticString("severities");
                if (PyDict_Contains(kwds, key_severities)) {
                    value = PyDict_GetItem(kwds, key_severities);
                    if (value && pyArgs[2]) {
                        errInfo = key_severities;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_severities);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
                }
            }
            ::QFlags<QOpenGLDebugMessage::Source> cppArg0 = QOpenGLDebugMessage::AnySource;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QOpenGLDebugMessage::Type> cppArg1 = QOpenGLDebugMessage::AnyType;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QOpenGLDebugMessage::Severity> cppArg2 = QOpenGLDebugMessage::AnySeverity;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // disableMessages(QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>,QFlags<QOpenGLDebugMessage::Severity>)
                cppSelf->disableMessages(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // disableMessages(const QVector<unsigned int > & ids, QFlags<QOpenGLDebugMessage::Source> sources, QFlags<QOpenGLDebugMessage::Type> types)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_sources = Shiboken::String::createStaticString("sources");
                if (PyDict_Contains(kwds, key_sources)) {
                    value = PyDict_GetItem(kwds, key_sources);
                    if (value && pyArgs[1]) {
                        errInfo = key_sources;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sources);
                }
                static PyObject *const key_types = Shiboken::String::createStaticString("types");
                if (PyDict_Contains(kwds, key_types)) {
                    value = PyDict_GetItem(kwds, key_types);
                    if (value && pyArgs[2]) {
                        errInfo = key_types;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_types);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError;
                }
            }
            ::QVector<unsigned int > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QOpenGLDebugMessage::Source> cppArg1 = QOpenGLDebugMessage::AnySource;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QOpenGLDebugMessage::Type> cppArg2 = QOpenGLDebugMessage::AnyType;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // disableMessages(QVector<uint>,QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>)
                cppSelf->disableMessages(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLDebugLoggerFunc_disableMessages_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLDebugLoggerFunc_enableMessages(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.enableMessages";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:enableMessages", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLDebugLogger::enableMessages(QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>,QFlags<QOpenGLDebugMessage::Severity>)
    // 1: QOpenGLDebugLogger::enableMessages(QVector<uint>,QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>)
    if (numArgs == 0) {
        overloadId = 0; // enableMessages(QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>,QFlags<QOpenGLDebugMessage::Severity>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_UNSIGNEDINT_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // enableMessages(QVector<uint>,QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // enableMessages(QVector<uint>,QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 1; // enableMessages(QVector<uint>,QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // enableMessages(QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>,QFlags<QOpenGLDebugMessage::Severity>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // enableMessages(QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>,QFlags<QOpenGLDebugMessage::Severity>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // enableMessages(QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>,QFlags<QOpenGLDebugMessage::Severity>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // enableMessages(QFlags<QOpenGLDebugMessage::Source> sources, QFlags<QOpenGLDebugMessage::Type> types, QFlags<QOpenGLDebugMessage::Severity> severities)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_sources = Shiboken::String::createStaticString("sources");
                if (PyDict_Contains(kwds, key_sources)) {
                    value = PyDict_GetItem(kwds, key_sources);
                    if (value && pyArgs[0]) {
                        errInfo = key_sources;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sources);
                }
                static PyObject *const key_types = Shiboken::String::createStaticString("types");
                if (PyDict_Contains(kwds, key_types)) {
                    value = PyDict_GetItem(kwds, key_types);
                    if (value && pyArgs[1]) {
                        errInfo = key_types;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_types);
                }
                static PyObject *const key_severities = Shiboken::String::createStaticString("severities");
                if (PyDict_Contains(kwds, key_severities)) {
                    value = PyDict_GetItem(kwds, key_severities);
                    if (value && pyArgs[2]) {
                        errInfo = key_severities;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SEVERITY_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_severities);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
                }
            }
            ::QFlags<QOpenGLDebugMessage::Source> cppArg0 = QOpenGLDebugMessage::AnySource;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QOpenGLDebugMessage::Type> cppArg1 = QOpenGLDebugMessage::AnyType;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QOpenGLDebugMessage::Severity> cppArg2 = QOpenGLDebugMessage::AnySeverity;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // enableMessages(QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>,QFlags<QOpenGLDebugMessage::Severity>)
                cppSelf->enableMessages(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // enableMessages(const QVector<unsigned int > & ids, QFlags<QOpenGLDebugMessage::Source> sources, QFlags<QOpenGLDebugMessage::Type> types)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_sources = Shiboken::String::createStaticString("sources");
                if (PyDict_Contains(kwds, key_sources)) {
                    value = PyDict_GetItem(kwds, key_sources);
                    if (value && pyArgs[1]) {
                        errInfo = key_sources;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sources);
                }
                static PyObject *const key_types = Shiboken::String::createStaticString("types");
                if (PyDict_Contains(kwds, key_types)) {
                    value = PyDict_GetItem(kwds, key_types);
                    if (value && pyArgs[2]) {
                        errInfo = key_types;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLDEBUGMESSAGE_TYPE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_types);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError;
                }
            }
            ::QVector<unsigned int > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QOpenGLDebugMessage::Source> cppArg1 = QOpenGLDebugMessage::AnySource;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QOpenGLDebugMessage::Type> cppArg2 = QOpenGLDebugMessage::AnyType;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // enableMessages(QVector<uint>,QFlags<QOpenGLDebugMessage::Source>,QFlags<QOpenGLDebugMessage::Type>)
                cppSelf->enableMessages(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLDebugLoggerFunc_enableMessages_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLDebugLoggerFunc_initialize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.initialize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // initialize()
            bool cppResult = cppSelf->initialize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLDebugLoggerFunc_isLogging(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.isLogging";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLogging()const
            bool cppResult = const_cast<const ::QOpenGLDebugLogger *>(cppSelf)->isLogging();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLDebugLoggerFunc_logMessage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.logMessage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLDebugLogger::logMessage(QOpenGLDebugMessage)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), (pyArg)))) {
        overloadId = 0; // logMessage(QOpenGLDebugMessage)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLDebugLoggerFunc_logMessage_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QOpenGLDebugMessage cppArg0_local;
        ::QOpenGLDebugMessage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // logMessage(QOpenGLDebugMessage)
            cppSelf->logMessage(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLDebugLoggerFunc_logMessage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLDebugLoggerFunc_loggedMessages(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.loggedMessages";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loggedMessages()const
            QList<QOpenGLDebugMessage > cppResult = const_cast<const ::QOpenGLDebugLogger *>(cppSelf)->loggedMessages();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOPENGLDEBUGMESSAGE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLDebugLoggerFunc_loggingMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.loggingMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loggingMode()const
            QOpenGLDebugLogger::LoggingMode cppResult = const_cast<const ::QOpenGLDebugLogger *>(cppSelf)->loggingMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_LOGGINGMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLDebugLoggerFunc_maximumMessageLength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.maximumMessageLength";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumMessageLength()const
            qint64 cppResult = const_cast<const ::QOpenGLDebugLogger *>(cppSelf)->maximumMessageLength();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLDebugLoggerFunc_popGroup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.popGroup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // popGroup()
            cppSelf->popGroup();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLDebugLoggerFunc_pushGroup(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.pushGroup";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLDebugLoggerFunc_pushGroup_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLDebugLoggerFunc_pushGroup_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:pushGroup", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLDebugLogger::pushGroup(QString,uint,QOpenGLDebugMessage::Source)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // pushGroup(QString,uint,QOpenGLDebugMessage::Source)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // pushGroup(QString,uint,QOpenGLDebugMessage::Source)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // pushGroup(QString,uint,QOpenGLDebugMessage::Source)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLDebugLoggerFunc_pushGroup_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_id = Shiboken::String::createStaticString("id");
            if (PyDict_Contains(kwds, key_id)) {
                value = PyDict_GetItem(kwds, key_id);
                if (value && pyArgs[1]) {
                    errInfo = key_id;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLDebugLoggerFunc_pushGroup_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1]))))
                        goto Sbk_QOpenGLDebugLoggerFunc_pushGroup_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_id);
            }
            static PyObject *const key_source = Shiboken::String::createStaticString("source");
            if (PyDict_Contains(kwds, key_source)) {
                value = PyDict_GetItem(kwds, key_source);
                if (value && pyArgs[2]) {
                    errInfo = key_source;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLDebugLoggerFunc_pushGroup_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_SOURCE_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QOpenGLDebugLoggerFunc_pushGroup_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_source);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QOpenGLDebugLoggerFunc_pushGroup_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QOpenGLDebugMessage::Source cppArg2 = QOpenGLDebugMessage::ApplicationSource;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // pushGroup(QString,uint,QOpenGLDebugMessage::Source)
            cppSelf->pushGroup(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLDebugLoggerFunc_pushGroup_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLDebugLoggerFunc_startLogging(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.startLogging";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLDebugLoggerFunc_startLogging_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:startLogging", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLDebugLogger::startLogging(QOpenGLDebugLogger::LoggingMode)
    if (numArgs == 0) {
        overloadId = 0; // startLogging(QOpenGLDebugLogger::LoggingMode)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_LOGGINGMODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // startLogging(QOpenGLDebugLogger::LoggingMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLDebugLoggerFunc_startLogging_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_loggingMode = Shiboken::String::createStaticString("loggingMode");
            if (PyDict_Contains(kwds, key_loggingMode)) {
                value = PyDict_GetItem(kwds, key_loggingMode);
                if (value && pyArgs[0]) {
                    errInfo = key_loggingMode;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLDebugLoggerFunc_startLogging_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_LOGGINGMODE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QOpenGLDebugLoggerFunc_startLogging_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_loggingMode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QOpenGLDebugLoggerFunc_startLogging_TypeError;
            }
        }
        ::QOpenGLDebugLogger::LoggingMode cppArg0 = QOpenGLDebugLogger::LoggingMode::AsynchronousLogging;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // startLogging(QOpenGLDebugLogger::LoggingMode)
            cppSelf->startLogging(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLDebugLoggerFunc_startLogging_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLDebugLoggerFunc_stopLogging(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLDebugLogger.stopLogging";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stopLogging()
            cppSelf->stopLogging();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QOpenGLDebugLogger_PropertyStrings[] = {
    "loggingMode:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLDebugLogger_methods[] = {
    {"disableMessages", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugLoggerFunc_disableMessages), METH_VARARGS|METH_KEYWORDS},
    {"enableMessages", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugLoggerFunc_enableMessages), METH_VARARGS|METH_KEYWORDS},
    {"initialize", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugLoggerFunc_initialize), METH_NOARGS},
    {"isLogging", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugLoggerFunc_isLogging), METH_NOARGS},
    {"logMessage", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugLoggerFunc_logMessage), METH_O},
    {"loggedMessages", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugLoggerFunc_loggedMessages), METH_NOARGS},
    {"loggingMode", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugLoggerFunc_loggingMode), METH_NOARGS},
    {"maximumMessageLength", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugLoggerFunc_maximumMessageLength), METH_NOARGS},
    {"popGroup", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugLoggerFunc_popGroup), METH_NOARGS},
    {"pushGroup", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugLoggerFunc_pushGroup), METH_VARARGS|METH_KEYWORDS},
    {"startLogging", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugLoggerFunc_startLogging), METH_VARARGS|METH_KEYWORDS},
    {"stopLogging", reinterpret_cast<PyCFunction>(Sbk_QOpenGLDebugLoggerFunc_stopLogging), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QOpenGLDebugLogger_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QOpenGLDebugLogger *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QOpenGLDebugLoggerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QOpenGLDebugLogger_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLDebugLogger_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLDebugLogger_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLDebugLogger_TypeF(void)
{
    return _Sbk_QOpenGLDebugLogger_Type;
}

static PyType_Slot Sbk_QOpenGLDebugLogger_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QOpenGLDebugLogger_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLDebugLogger_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLDebugLogger_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLDebugLogger_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLDebugLogger_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLDebugLogger_spec = {
    "2:PySide2.QtGui.QOpenGLDebugLogger",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLDebugLogger_slots
};

} //extern "C"

static void *Sbk_QOpenGLDebugLogger_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QOpenGLDebugLogger *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QOpenGLDebugLogger_LoggingMode_PythonToCpp_QOpenGLDebugLogger_LoggingMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLDebugLogger::LoggingMode *>(cppOut) =
        static_cast<::QOpenGLDebugLogger::LoggingMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLDebugLogger_LoggingMode_PythonToCpp_QOpenGLDebugLogger_LoggingMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_LOGGINGMODE_IDX]))
        return QOpenGLDebugLogger_LoggingMode_PythonToCpp_QOpenGLDebugLogger_LoggingMode;
    return {};
}
static PyObject *QOpenGLDebugLogger_LoggingMode_CppToPython_QOpenGLDebugLogger_LoggingMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLDebugLogger::LoggingMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_LOGGINGMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLDebugLogger_PythonToCpp_QOpenGLDebugLogger_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLDebugLogger_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLDebugLogger_PythonToCpp_QOpenGLDebugLogger_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLDebugLogger_TypeF())))
        return QOpenGLDebugLogger_PythonToCpp_QOpenGLDebugLogger_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLDebugLogger_PTR_CppToPython_QOpenGLDebugLogger(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QOpenGLDebugLogger *>(const_cast<void *>(cppIn)), Sbk_QOpenGLDebugLogger_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLDebugLogger_SignatureStrings[] = {
    "PySide2.QtGui.QOpenGLDebugLogger(self,parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtGui.QOpenGLDebugLogger.disableMessages(self,sources:PySide2.QtGui.QOpenGLDebugMessage.Sources=QOpenGLDebugMessage.AnySource,types:PySide2.QtGui.QOpenGLDebugMessage.Types=QOpenGLDebugMessage.AnyType,severities:PySide2.QtGui.QOpenGLDebugMessage.Severities=QOpenGLDebugMessage.AnySeverity)",
    "0:PySide2.QtGui.QOpenGLDebugLogger.disableMessages(self,ids:QVector[unsigned int],sources:PySide2.QtGui.QOpenGLDebugMessage.Sources=QOpenGLDebugMessage.AnySource,types:PySide2.QtGui.QOpenGLDebugMessage.Types=QOpenGLDebugMessage.AnyType)",
    "1:PySide2.QtGui.QOpenGLDebugLogger.enableMessages(self,sources:PySide2.QtGui.QOpenGLDebugMessage.Sources=QOpenGLDebugMessage.AnySource,types:PySide2.QtGui.QOpenGLDebugMessage.Types=QOpenGLDebugMessage.AnyType,severities:PySide2.QtGui.QOpenGLDebugMessage.Severities=QOpenGLDebugMessage.AnySeverity)",
    "0:PySide2.QtGui.QOpenGLDebugLogger.enableMessages(self,ids:QVector[unsigned int],sources:PySide2.QtGui.QOpenGLDebugMessage.Sources=QOpenGLDebugMessage.AnySource,types:PySide2.QtGui.QOpenGLDebugMessage.Types=QOpenGLDebugMessage.AnyType)",
    "PySide2.QtGui.QOpenGLDebugLogger.initialize(self)->bool",
    "PySide2.QtGui.QOpenGLDebugLogger.isLogging(self)->bool",
    "PySide2.QtGui.QOpenGLDebugLogger.logMessage(self,debugMessage:PySide2.QtGui.QOpenGLDebugMessage)",
    "PySide2.QtGui.QOpenGLDebugLogger.loggedMessages(self)->QList[PySide2.QtGui.QOpenGLDebugMessage]",
    "PySide2.QtGui.QOpenGLDebugLogger.loggingMode(self)->PySide2.QtGui.QOpenGLDebugLogger.LoggingMode",
    "PySide2.QtGui.QOpenGLDebugLogger.maximumMessageLength(self)->qint64",
    "PySide2.QtGui.QOpenGLDebugLogger.popGroup(self)",
    "PySide2.QtGui.QOpenGLDebugLogger.pushGroup(self,name:QString,id:unsigned int=0,source:PySide2.QtGui.QOpenGLDebugMessage.Source=QOpenGLDebugMessage.ApplicationSource)",
    "PySide2.QtGui.QOpenGLDebugLogger.startLogging(self,loggingMode:PySide2.QtGui.QOpenGLDebugLogger.LoggingMode=AsynchronousLogging)",
    "PySide2.QtGui.QOpenGLDebugLogger.stopLogging(self)",
    nullptr}; // Sentinel

void init_QOpenGLDebugLogger(PyObject *module)
{
    _Sbk_QOpenGLDebugLogger_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLDebugLogger",
        "QOpenGLDebugLogger*",
        &Sbk_QOpenGLDebugLogger_spec,
        &Shiboken::callCppDestructor< ::QOpenGLDebugLogger >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLDebugLogger_Type);
    InitSignatureStrings(pyType, QOpenGLDebugLogger_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLDebugLogger_Type), Sbk_QOpenGLDebugLogger_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLDebugLogger_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLDebugLogger_TypeF(),
        QOpenGLDebugLogger_PythonToCpp_QOpenGLDebugLogger_PTR,
        is_QOpenGLDebugLogger_PythonToCpp_QOpenGLDebugLogger_PTR_Convertible,
        QOpenGLDebugLogger_PTR_CppToPython_QOpenGLDebugLogger);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugLogger");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugLogger*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugLogger&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLDebugLogger).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLDebugLoggerWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QOpenGLDebugLogger_TypeF(), &Sbk_QOpenGLDebugLogger_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'LoggingMode'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_LOGGINGMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLDebugLogger_TypeF(),
        "LoggingMode",
        "2:PySide2.QtGui.QOpenGLDebugLogger.LoggingMode",
        "QOpenGLDebugLogger::LoggingMode");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_LOGGINGMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_LOGGINGMODE_IDX],
        Sbk_QOpenGLDebugLogger_TypeF(), "AsynchronousLogging", (long) QOpenGLDebugLogger::LoggingMode::AsynchronousLogging))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_LOGGINGMODE_IDX],
        Sbk_QOpenGLDebugLogger_TypeF(), "SynchronousLogging", (long) QOpenGLDebugLogger::LoggingMode::SynchronousLogging))
        return;
    // Register converter for enum 'QOpenGLDebugLogger::LoggingMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_LOGGINGMODE_IDX],
            QOpenGLDebugLogger_LoggingMode_CppToPython_QOpenGLDebugLogger_LoggingMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLDebugLogger_LoggingMode_PythonToCpp_QOpenGLDebugLogger_LoggingMode,
            is_QOpenGLDebugLogger_LoggingMode_PythonToCpp_QOpenGLDebugLogger_LoggingMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGLOGGER_LOGGINGMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLDebugLogger::LoggingMode");
        Shiboken::Conversions::registerConverterName(converter, "LoggingMode");
    }
    // End of 'LoggingMode' enum.

    PySide::Signal::registerSignals(Sbk_QOpenGLDebugLogger_TypeF(), &::QOpenGLDebugLogger::staticMetaObject);
    qRegisterMetaType< ::QOpenGLDebugLogger::LoggingMode >("QOpenGLDebugLogger::LoggingMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QOpenGLDebugLogger_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QOpenGLDebugLogger_TypeF(), &::QOpenGLDebugLogger::staticMetaObject, sizeof(QOpenGLDebugLoggerWrapper));
}
