/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qopengltexture_wrapper.h"

// inner classes

// Extra includes
#include <QPair>
#include <QtGui/qcolor.h>
#include <QtGui/qimage.h>
#include <QtGui/qopenglpixeltransferoptions.h>
#include <QtGui/qopengltexture.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLTexture_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLTexture >()))
        return -1;

    ::QOpenGLTexture *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLTexture_Init_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLTexture_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QOpenGLTexture", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QOpenGLTexture::QOpenGLTexture(QOpenGLTexture::Target)
    // 1: QOpenGLTexture::QOpenGLTexture(QImage,QOpenGLTexture::MipMapGeneration)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QOpenGLTexture(QImage,QOpenGLTexture::MipMapGeneration)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_MIPMAPGENERATION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // QOpenGLTexture(QImage,QOpenGLTexture::MipMapGeneration)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QOpenGLTexture(QOpenGLTexture::Target)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTexture_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QOpenGLTexture(QOpenGLTexture::Target target)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QOpenGLTexture_Init_TypeError;
            }
            ::QOpenGLTexture::Target cppArg0 = static_cast< ::QOpenGLTexture::Target>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QOpenGLTexture(QOpenGLTexture::Target)
                cptr = new ::QOpenGLTexture(cppArg0);
            }
            break;
        }
        case 1: // QOpenGLTexture(const QImage & image, QOpenGLTexture::MipMapGeneration genMipMaps)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_genMipMaps = Shiboken::String::createStaticString("genMipMaps");
                if (PyDict_Contains(kwds, key_genMipMaps)) {
                    value = PyDict_GetItem(kwds, key_genMipMaps);
                    if (value && pyArgs[1]) {
                        errInfo = key_genMipMaps;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTexture_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_MIPMAPGENERATION_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QOpenGLTexture_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_genMipMaps);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTexture_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QImage cppArg0_local;
            ::QImage *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QOpenGLTexture::MipMapGeneration cppArg1 = QOpenGLTexture::MipMapGeneration::GenerateMipMaps;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QOpenGLTexture(QImage,QOpenGLTexture::MipMapGeneration)
                cptr = new ::QOpenGLTexture(*cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLTexture >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOpenGLTexture_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QOpenGLTexture_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOpenGLTextureFunc_allocateStorage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.allocateStorage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto Sbk_QOpenGLTextureFunc_allocateStorage_TypeError;

    if (!PyArg_UnpackTuple(args, "allocateStorage", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::allocateStorage()
    // 1: QOpenGLTexture::allocateStorage(QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType)
    if (numArgs == 0) {
        overloadId = 0; // allocateStorage()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 1; // allocateStorage(QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_allocateStorage_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // allocateStorage()
        {

            if (!PyErr_Occurred()) {
                // allocateStorage()
                cppSelf->allocateStorage();
            }
            break;
        }
        case 1: // allocateStorage(QOpenGLTexture::PixelFormat pixelFormat, QOpenGLTexture::PixelType pixelType)
        {
            ::QOpenGLTexture::PixelFormat cppArg0{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QOpenGLTexture::PixelType cppArg1{QOpenGLTexture::NoPixelType};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // allocateStorage(QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType)
                cppSelf->allocateStorage(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_allocateStorage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_bind(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.bind";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLTextureFunc_bind_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:bind", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::bind()
    // 1: QOpenGLTexture::bind(uint,QOpenGLTexture::TextureUnitReset)
    if (numArgs == 0) {
        overloadId = 0; // bind()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // bind(uint,QOpenGLTexture::TextureUnitReset)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREUNITRESET_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // bind(uint,QOpenGLTexture::TextureUnitReset)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_bind_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // bind()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QOpenGLTextureFunc_bind_TypeError;
            }

            if (!PyErr_Occurred()) {
                // bind()
                cppSelf->bind();
            }
            break;
        }
        case 1: // bind(uint unit, QOpenGLTexture::TextureUnitReset reset)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_reset = Shiboken::String::createStaticString("reset");
                if (PyDict_Contains(kwds, key_reset)) {
                    value = PyDict_GetItem(kwds, key_reset);
                    if (value && pyArgs[1]) {
                        errInfo = key_reset;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_bind_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREUNITRESET_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QOpenGLTextureFunc_bind_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_reset);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_bind_TypeError;
                }
            }
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QOpenGLTexture::TextureUnitReset cppArg1 = QOpenGLTexture::TextureUnitReset::DontResetTextureUnit;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bind(uint,QOpenGLTexture::TextureUnitReset)
                cppSelf->bind(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_bind_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_borderColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.borderColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // borderColor()const
            QColor cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->borderColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_boundTextureId(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.boundTextureId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "boundTextureId", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QOpenGLTexture::boundTextureId(QOpenGLTexture::BindingTarget)
    // 1: static QOpenGLTexture::boundTextureId(uint,QOpenGLTexture::BindingTarget)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // boundTextureId(QOpenGLTexture::BindingTarget)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX])->converter, (pyArgs[1])))) {
        overloadId = 1; // boundTextureId(uint,QOpenGLTexture::BindingTarget)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_boundTextureId_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // boundTextureId(QOpenGLTexture::BindingTarget target)
        {
            ::QOpenGLTexture::BindingTarget cppArg0 = static_cast< ::QOpenGLTexture::BindingTarget>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // boundTextureId(QOpenGLTexture::BindingTarget)
                unsigned int cppResult = ::QOpenGLTexture::boundTextureId(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
            }
            break;
        }
        case 1: // boundTextureId(uint unit, QOpenGLTexture::BindingTarget target)
        {
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QOpenGLTexture::BindingTarget cppArg1 = static_cast< ::QOpenGLTexture::BindingTarget>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // boundTextureId(uint,QOpenGLTexture::BindingTarget)
                unsigned int cppResult = ::QOpenGLTexture::boundTextureId(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLTextureFunc_boundTextureId_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_comparisonFunction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.comparisonFunction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // comparisonFunction()const
            QOpenGLTexture::ComparisonFunction cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->comparisonFunction();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_comparisonMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.comparisonMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // comparisonMode()const
            QOpenGLTexture::ComparisonMode cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->comparisonMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_create(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.create";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // create()
            bool cppResult = cppSelf->create();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_createTextureView(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.createTextureView";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createTextureView", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::createTextureView(QOpenGLTexture::Target,QOpenGLTexture::TextureFormat,int,int,int,int)const
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // createTextureView(QOpenGLTexture::Target,QOpenGLTexture::TextureFormat,int,int,int,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_createTextureView_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::Target cppArg0 = static_cast< ::QOpenGLTexture::Target>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QOpenGLTexture::TextureFormat cppArg1{QOpenGLTexture::NoFormat};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // createTextureView(QOpenGLTexture::Target,QOpenGLTexture::TextureFormat,int,int,int,int)const
            QOpenGLTexture * cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->createTextureView(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLTextureFunc_createTextureView_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_depth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.depth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depth()const
            int cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->depth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_depthStencilMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.depthStencilMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depthStencilMode()const
            QOpenGLTexture::DepthStencilMode cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->depthStencilMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_DEPTHSTENCILMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_destroy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.destroy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destroy()
            cppSelf->destroy();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLTextureFunc_faces(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.faces";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // faces()const
            int cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->faces();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QOpenGLTexture::TextureFormat cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_generateMipMaps(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.generateMipMaps";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLTextureFunc_generateMipMaps_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:generateMipMaps", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::generateMipMaps()
    // 1: QOpenGLTexture::generateMipMaps(int,bool)
    if (numArgs == 0) {
        overloadId = 0; // generateMipMaps()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // generateMipMaps(int,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 1; // generateMipMaps(int,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_generateMipMaps_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // generateMipMaps()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QOpenGLTextureFunc_generateMipMaps_TypeError;
            }

            if (!PyErr_Occurred()) {
                // generateMipMaps()
                cppSelf->generateMipMaps();
            }
            break;
        }
        case 1: // generateMipMaps(int baseLevel, bool resetBaseLevel)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_resetBaseLevel = Shiboken::String::createStaticString("resetBaseLevel");
                if (PyDict_Contains(kwds, key_resetBaseLevel)) {
                    value = PyDict_GetItem(kwds, key_resetBaseLevel);
                    if (value && pyArgs[1]) {
                        errInfo = key_resetBaseLevel;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_generateMipMaps_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                            goto Sbk_QOpenGLTextureFunc_generateMipMaps_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_resetBaseLevel);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_generateMipMaps_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1 = true;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // generateMipMaps(int,bool)
                cppSelf->generateMipMaps(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_generateMipMaps_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_hasFeature(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.hasFeature";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QOpenGLTexture::hasFeature(QOpenGLTexture::Feature)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // hasFeature(QOpenGLTexture::Feature)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_hasFeature_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::Feature cppArg0 = static_cast< ::QOpenGLTexture::Feature>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasFeature(QOpenGLTexture::Feature)
            bool cppResult = ::QOpenGLTexture::hasFeature(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLTextureFunc_hasFeature_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            int cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_isAutoMipMapGenerationEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.isAutoMipMapGenerationEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAutoMipMapGenerationEnabled()const
            bool cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->isAutoMipMapGenerationEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_isBound(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.isBound";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isBound", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::isBound()const
    // 1: QOpenGLTexture::isBound(uint)
    if (numArgs == 0) {
        overloadId = 0; // isBound()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 1; // isBound(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_isBound_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // isBound() const
        {

            if (!PyErr_Occurred()) {
                // isBound()const
                bool cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->isBound();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // isBound(uint unit)
        {
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // isBound(uint)
                bool cppResult = cppSelf->isBound(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLTextureFunc_isBound_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_isCreated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.isCreated";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCreated()const
            bool cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->isCreated();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_isFixedSamplePositions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.isFixedSamplePositions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFixedSamplePositions()const
            bool cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->isFixedSamplePositions();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_isStorageAllocated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.isStorageAllocated";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isStorageAllocated()const
            bool cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->isStorageAllocated();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_isTextureView(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.isTextureView";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTextureView()const
            bool cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->isTextureView();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_layers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.layers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layers()const
            int cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->layers();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_levelOfDetailRange(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.levelOfDetailRange";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // levelOfDetailRange()const
            QPair<float,float > cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->levelOfDetailRange();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_FLOAT_FLOAT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_levelofDetailBias(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.levelofDetailBias";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // levelofDetailBias()const
            float cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->levelofDetailBias();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_magnificationFilter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.magnificationFilter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // magnificationFilter()const
            QOpenGLTexture::Filter cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->magnificationFilter();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_maximumAnisotropy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.maximumAnisotropy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumAnisotropy()const
            float cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->maximumAnisotropy();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_maximumLevelOfDetail(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.maximumLevelOfDetail";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumLevelOfDetail()const
            float cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->maximumLevelOfDetail();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_maximumMipLevels(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.maximumMipLevels";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumMipLevels()const
            int cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->maximumMipLevels();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_minMagFilters(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.minMagFilters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minMagFilters()const
            QPair<QOpenGLTexture::Filter,QOpenGLTexture::Filter > cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->minMagFilters();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QOPENGLTEXTURE_FILTER_QOPENGLTEXTURE_FILTER_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_minificationFilter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.minificationFilter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minificationFilter()const
            QOpenGLTexture::Filter cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->minificationFilter();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_minimumLevelOfDetail(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.minimumLevelOfDetail";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumLevelOfDetail()const
            float cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->minimumLevelOfDetail();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_mipBaseLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.mipBaseLevel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mipBaseLevel()const
            int cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->mipBaseLevel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_mipLevelRange(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.mipLevelRange";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mipLevelRange()const
            QPair<int,int > cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->mipLevelRange();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_INT_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_mipLevels(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.mipLevels";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mipLevels()const
            int cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->mipLevels();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_mipMaxLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.mipMaxLevel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mipMaxLevel()const
            int cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->mipMaxLevel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_release(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.release";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLTextureFunc_release_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:release", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::release()
    // 1: QOpenGLTexture::release(uint,QOpenGLTexture::TextureUnitReset)
    if (numArgs == 0) {
        overloadId = 0; // release()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // release(uint,QOpenGLTexture::TextureUnitReset)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREUNITRESET_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // release(uint,QOpenGLTexture::TextureUnitReset)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_release_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // release()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QOpenGLTextureFunc_release_TypeError;
            }

            if (!PyErr_Occurred()) {
                // release()
                cppSelf->release();
            }
            break;
        }
        case 1: // release(uint unit, QOpenGLTexture::TextureUnitReset reset)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_reset = Shiboken::String::createStaticString("reset");
                if (PyDict_Contains(kwds, key_reset)) {
                    value = PyDict_GetItem(kwds, key_reset);
                    if (value && pyArgs[1]) {
                        errInfo = key_reset;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_release_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREUNITRESET_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QOpenGLTextureFunc_release_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_reset);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_release_TypeError;
                }
            }
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QOpenGLTexture::TextureUnitReset cppArg1 = QOpenGLTexture::TextureUnitReset::DontResetTextureUnit;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // release(uint,QOpenGLTexture::TextureUnitReset)
                cppSelf->release(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_release_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_samples(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.samples";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // samples()const
            int cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->samples();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_setAutoMipMapGenerationEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setAutoMipMapGenerationEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setAutoMipMapGenerationEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoMipMapGenerationEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setAutoMipMapGenerationEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoMipMapGenerationEnabled(bool)
            cppSelf->setAutoMipMapGenerationEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setAutoMipMapGenerationEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setBorderColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setBorderColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QOpenGLTextureFunc_setBorderColor_TypeError;

    if (!PyArg_UnpackTuple(args, "setBorderColor", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::setBorderColor(QColor)
    // 1: QOpenGLTexture::setBorderColor(float,float,float,float)
    // 2: QOpenGLTexture::setBorderColor(int,int,int,int)
    // 3: QOpenGLTexture::setBorderColor(uint,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[3])))) {
        overloadId = 3; // setBorderColor(uint,uint,uint,uint)
    } else if (numArgs == 4
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 1; // setBorderColor(float,float,float,float)
    } else if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 2; // setBorderColor(int,int,int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setBorderColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setBorderColor_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setBorderColor(QColor color)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QColor cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setBorderColor(QColor)
                cppSelf->setBorderColor(cppArg0);
            }
            break;
        }
        case 1: // setBorderColor(float r, float g, float b, float a)
        {
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setBorderColor(float,float,float,float)
                cppSelf->setBorderColor(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 2: // setBorderColor(int r, int g, int b, int a)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setBorderColor(int,int,int,int)
                cppSelf->setBorderColor(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 3: // setBorderColor(uint r, uint g, uint b, uint a)
        {
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            uint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            uint cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            uint cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setBorderColor(uint,uint,uint,uint)
                cppSelf->setBorderColor(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setBorderColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setComparisonFunction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setComparisonFunction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setComparisonFunction(QOpenGLTexture::ComparisonFunction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setComparisonFunction(QOpenGLTexture::ComparisonFunction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setComparisonFunction_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::ComparisonFunction cppArg0 = static_cast< ::QOpenGLTexture::ComparisonFunction>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setComparisonFunction(QOpenGLTexture::ComparisonFunction)
            cppSelf->setComparisonFunction(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setComparisonFunction_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setComparisonMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setComparisonMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setComparisonMode(QOpenGLTexture::ComparisonMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setComparisonMode(QOpenGLTexture::ComparisonMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setComparisonMode_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::ComparisonMode cppArg0{QOpenGLTexture::CompareNone};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setComparisonMode(QOpenGLTexture::ComparisonMode)
            cppSelf->setComparisonMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setComparisonMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setCompressedData(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setCompressedData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOO:setCompressedData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::setCompressedData(int,const void*,QOpenGLPixelTransferOptions*const)
    // 1: QOpenGLTexture::setCompressedData(int,void*,QOpenGLPixelTransferOptions*const)
    // 2: QOpenGLTexture::setCompressedData(int,int,const void*,QOpenGLPixelTransferOptions*const)
    // 3: QOpenGLTexture::setCompressedData(int,int,void*,QOpenGLPixelTransferOptions*const)
    // 4: QOpenGLTexture::setCompressedData(int,int,QOpenGLTexture::CubeMapFace,int,const void*,QOpenGLPixelTransferOptions*const)
    // 5: QOpenGLTexture::setCompressedData(int,int,QOpenGLTexture::CubeMapFace,int,void*,QOpenGLPixelTransferOptions*const)
    // 6: QOpenGLTexture::setCompressedData(int,int,int,const void*,QOpenGLPixelTransferOptions*const)
    // 7: QOpenGLTexture::setCompressedData(int,int,int,void*,QOpenGLPixelTransferOptions*const)
    // 8: QOpenGLTexture::setCompressedData(int,int,int,QOpenGLTexture::CubeMapFace,int,const void*,QOpenGLPixelTransferOptions*const)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs >= 5
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX])->converter, (pyArgs[2])))
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 4; // setCompressedData(int,int,QOpenGLTexture::CubeMapFace,int,const void*,QOpenGLPixelTransferOptions*const)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[5])))) {
                    overloadId = 4; // setCompressedData(int,int,QOpenGLTexture::CubeMapFace,int,const void*,QOpenGLPixelTransferOptions*const)
                }
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs >= 6
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX])->converter, (pyArgs[3])))
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))) {
                    if (numArgs == 6) {
                        overloadId = 8; // setCompressedData(int,int,int,QOpenGLTexture::CubeMapFace,int,const void*,QOpenGLPixelTransferOptions*const)
                    } else if (numArgs >= 7
                        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[6])))) {
                        overloadId = 8; // setCompressedData(int,int,int,QOpenGLTexture::CubeMapFace,int,const void*,QOpenGLPixelTransferOptions*const)
                    }
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 6; // setCompressedData(int,int,int,const void*,QOpenGLPixelTransferOptions*const)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[4])))) {
                        overloadId = 6; // setCompressedData(int,int,int,const void*,QOpenGLPixelTransferOptions*const)
                    }
                }
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // setCompressedData(int,int,const void*,QOpenGLPixelTransferOptions*const)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[3])))) {
                    overloadId = 2; // setCompressedData(int,int,const void*,QOpenGLPixelTransferOptions*const)
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setCompressedData(int,const void*,QOpenGLPixelTransferOptions*const)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[2])))) {
                overloadId = 0; // setCompressedData(int,const void*,QOpenGLPixelTransferOptions*const)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setCompressedData(int dataSize, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[2]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[2]))))
                            goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            void* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setCompressedData(int,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setCompressedData(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // setCompressedData(int dataSize, void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[2]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[2]))))
                            goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            void* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setCompressedData(int,void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setCompressedData(cppArg0, cppArg1, cppArg2);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QOpenGLTexture.setCompressedData(int dataSize, void * data, const QOpenGLPixelTransferOptions *const options) is deprecated", 1);
            break;
        }
        case 2: // setCompressedData(int mipLevel, int dataSize, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[3]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[3]))))
                            goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            void* cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setCompressedData(int,int,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setCompressedData(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 3: // setCompressedData(int mipLevel, int dataSize, void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[3]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[3]))))
                            goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            void* cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setCompressedData(int,int,void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setCompressedData(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QOpenGLTexture.setCompressedData(int mipLevel, int dataSize, void * data, const QOpenGLPixelTransferOptions *const options) is deprecated", 1);
            break;
        }
        case 4: // setCompressedData(int mipLevel, int layer, QOpenGLTexture::CubeMapFace cubeFace, int dataSize, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[5]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[5]))))
                            goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QOpenGLTexture::CubeMapFace cppArg2 = static_cast< ::QOpenGLTexture::CubeMapFace>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            void* cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg5 = nullptr;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // setCompressedData(int,int,QOpenGLTexture::CubeMapFace,int,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setCompressedData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
        case 5: // setCompressedData(int mipLevel, int layer, QOpenGLTexture::CubeMapFace cubeFace, int dataSize, void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[5]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[5]))))
                            goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QOpenGLTexture::CubeMapFace cppArg2 = static_cast< ::QOpenGLTexture::CubeMapFace>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            void* cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg5 = nullptr;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // setCompressedData(int,int,QOpenGLTexture::CubeMapFace,int,void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setCompressedData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QOpenGLTexture.setCompressedData(int mipLevel, int layer, QOpenGLTexture::CubeMapFace cubeFace, int dataSize, void * data, const QOpenGLPixelTransferOptions *const options) is deprecated", 1);
            break;
        }
        case 6: // setCompressedData(int mipLevel, int layer, int dataSize, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[4]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[4]))))
                            goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            void* cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg4 = nullptr;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setCompressedData(int,int,int,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setCompressedData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 7: // setCompressedData(int mipLevel, int layer, int dataSize, void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[4]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[4]))))
                            goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            void* cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg4 = nullptr;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setCompressedData(int,int,int,void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setCompressedData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QOpenGLTexture.setCompressedData(int mipLevel, int layer, int dataSize, void * data, const QOpenGLPixelTransferOptions *const options) is deprecated", 1);
            break;
        }
        case 8: // setCompressedData(int mipLevel, int layer, int layerCount, QOpenGLTexture::CubeMapFace cubeFace, int dataSize, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[6]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[6]))))
                            goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setCompressedData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QOpenGLTexture::CubeMapFace cppArg3 = static_cast< ::QOpenGLTexture::CubeMapFace>(0);
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            void* cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg6 = nullptr;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // setCompressedData(int,int,int,QOpenGLTexture::CubeMapFace,int,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setCompressedData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setCompressedData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setData(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 14) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOOOOOOOOO:setData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10]), &(pyArgs[11]), &(pyArgs[12]), &(pyArgs[13])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::setData(QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
    // 1: QOpenGLTexture::setData(QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,void*,QOpenGLPixelTransferOptions*const)
    // 2: QOpenGLTexture::setData(QImage,QOpenGLTexture::MipMapGeneration)
    // 3: QOpenGLTexture::setData(int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
    // 4: QOpenGLTexture::setData(int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,void*,QOpenGLPixelTransferOptions*const)
    // 5: QOpenGLTexture::setData(int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
    // 6: QOpenGLTexture::setData(int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,void*,QOpenGLPixelTransferOptions*const)
    // 7: QOpenGLTexture::setData(int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
    // 8: QOpenGLTexture::setData(int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,void*,QOpenGLPixelTransferOptions*const)
    // 9: QOpenGLTexture::setData(int,int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
    // 10: QOpenGLTexture::setData(int,int,int,int,int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
    // 11: QOpenGLTexture::setData(int,int,int,int,int,int,int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
    // 12: QOpenGLTexture::setData(int,int,int,int,int,int,int,int,QOpenGLTexture::CubeMapFace,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
    // 13: QOpenGLTexture::setData(int,int,int,int,int,int,int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // setData(QImage,QOpenGLTexture::MipMapGeneration)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_MIPMAPGENERATION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 2; // setData(QImage,QOpenGLTexture::MipMapGeneration)
        }
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // setData(QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[3])))) {
            overloadId = 0; // setData(QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs >= 4
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])->converter, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])->converter, (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 3; // setData(int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[4])))) {
                overloadId = 3; // setData(int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs >= 5
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])->converter, (pyArgs[2])))
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])->converter, (pyArgs[3])))
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 7; // setData(int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[5])))) {
                    overloadId = 7; // setData(int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                }
            } else if (numArgs >= 6
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX])->converter, (pyArgs[2])))
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])->converter, (pyArgs[3])))
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])->converter, (pyArgs[4])))
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))) {
                if (numArgs == 6) {
                    overloadId = 5; // setData(int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                } else if (numArgs >= 7
                    && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[6])))) {
                    overloadId = 5; // setData(int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                }
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs >= 7
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX])->converter, (pyArgs[3])))
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])->converter, (pyArgs[4])))
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])->converter, (pyArgs[5])))
                    && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6])))) {
                    if (numArgs == 7) {
                        overloadId = 9; // setData(int,int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                    } else if (numArgs >= 8
                        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[7])))) {
                        overloadId = 9; // setData(int,int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                    }
                } else if (numArgs >= 6
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
                    if (numArgs >= 9
                        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])->converter, (pyArgs[6])))
                        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])->converter, (pyArgs[7])))
                        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[8])))) {
                        if (numArgs == 9) {
                            overloadId = 10; // setData(int,int,int,int,int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                        } else if (numArgs >= 10
                            && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[9])))) {
                            overloadId = 10; // setData(int,int,int,int,int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                        }
                    } else if (numArgs >= 8
                        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
                        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))) {
                        if (numArgs >= 11
                            && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])->converter, (pyArgs[8])))
                            && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])->converter, (pyArgs[9])))
                            && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[10])))) {
                            if (numArgs == 11) {
                                overloadId = 13; // setData(int,int,int,int,int,int,int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                            } else if (numArgs >= 12
                                && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[11])))) {
                                overloadId = 13; // setData(int,int,int,int,int,int,int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                            }
                        } else if (numArgs >= 9
                            && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX])->converter, (pyArgs[8])))) {
                            if (numArgs >= 12
                                && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])->converter, (pyArgs[9])))
                                && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])->converter, (pyArgs[10])))
                                && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[11])))) {
                                if (numArgs == 12) {
                                    overloadId = 11; // setData(int,int,int,int,int,int,int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                                } else if (numArgs >= 13
                                    && (pythonToCpp[12] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[12])))) {
                                    overloadId = 11; // setData(int,int,int,int,int,int,int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                                }
                            } else if (numArgs >= 13
                                && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[9])))
                                && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])->converter, (pyArgs[10])))
                                && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])->converter, (pyArgs[11])))
                                && (pythonToCpp[12] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[12])))) {
                                if (numArgs == 13) {
                                    overloadId = 12; // setData(int,int,int,int,int,int,int,int,QOpenGLTexture::CubeMapFace,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                                } else if (numArgs >= 14
                                    && (pythonToCpp[13] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[13])))) {
                                    overloadId = 12; // setData(int,int,int,int,int,int,int,int,QOpenGLTexture::CubeMapFace,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setData_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setData(QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[3]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[3]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            ::QOpenGLTexture::PixelFormat cppArg0{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QOpenGLTexture::PixelType cppArg1{QOpenGLTexture::NoPixelType};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            void* cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setData(QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // setData(QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[3]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[3]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            ::QOpenGLTexture::PixelFormat cppArg0{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QOpenGLTexture::PixelType cppArg1{QOpenGLTexture::NoPixelType};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            void* cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setData(QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QOpenGLTexture.setData(QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, void * data, const QOpenGLPixelTransferOptions *const options) is deprecated", 1);
            break;
        }
        case 2: // setData(const QImage & image, QOpenGLTexture::MipMapGeneration genMipMaps)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_genMipMaps = Shiboken::String::createStaticString("genMipMaps");
                if (PyDict_Contains(kwds, key_genMipMaps)) {
                    value = PyDict_GetItem(kwds, key_genMipMaps);
                    if (value && pyArgs[1]) {
                        errInfo = key_genMipMaps;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_MIPMAPGENERATION_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_genMipMaps);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QImage cppArg0_local;
            ::QImage *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QOpenGLTexture::MipMapGeneration cppArg1 = QOpenGLTexture::MipMapGeneration::GenerateMipMaps;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setData(QImage,QOpenGLTexture::MipMapGeneration)
                cppSelf->setData(*cppArg0, cppArg1);
            }
            break;
        }
        case 3: // setData(int mipLevel, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[4]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[4]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QOpenGLTexture::PixelFormat cppArg1{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QOpenGLTexture::PixelType cppArg2{QOpenGLTexture::NoPixelType};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            void* cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg4 = nullptr;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setData(int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 4: // setData(int mipLevel, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[4]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[4]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QOpenGLTexture::PixelFormat cppArg1{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QOpenGLTexture::PixelType cppArg2{QOpenGLTexture::NoPixelType};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            void* cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg4 = nullptr;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setData(int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QOpenGLTexture.setData(int mipLevel, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, void * data, const QOpenGLPixelTransferOptions *const options) is deprecated", 1);
            break;
        }
        case 5: // setData(int mipLevel, int layer, QOpenGLTexture::CubeMapFace cubeFace, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[6]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[6]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QOpenGLTexture::CubeMapFace cppArg2 = static_cast< ::QOpenGLTexture::CubeMapFace>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QOpenGLTexture::PixelFormat cppArg3{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QOpenGLTexture::PixelType cppArg4{QOpenGLTexture::NoPixelType};
            pythonToCpp[4](pyArgs[4], &cppArg4);
            void* cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg6 = nullptr;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // setData(int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
            }
            break;
        }
        case 6: // setData(int mipLevel, int layer, QOpenGLTexture::CubeMapFace cubeFace, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[6]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[6]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QOpenGLTexture::CubeMapFace cppArg2 = static_cast< ::QOpenGLTexture::CubeMapFace>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QOpenGLTexture::PixelFormat cppArg3{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QOpenGLTexture::PixelType cppArg4{QOpenGLTexture::NoPixelType};
            pythonToCpp[4](pyArgs[4], &cppArg4);
            void* cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg6 = nullptr;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // setData(int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QOpenGLTexture.setData(int mipLevel, int layer, QOpenGLTexture::CubeMapFace cubeFace, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, void * data, const QOpenGLPixelTransferOptions *const options) is deprecated", 1);
            break;
        }
        case 7: // setData(int mipLevel, int layer, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[5]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[5]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QOpenGLTexture::PixelFormat cppArg2{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QOpenGLTexture::PixelType cppArg3{QOpenGLTexture::NoPixelType};
            pythonToCpp[3](pyArgs[3], &cppArg3);
            void* cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg5 = nullptr;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // setData(int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
        case 8: // setData(int mipLevel, int layer, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[5]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[5]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QOpenGLTexture::PixelFormat cppArg2{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QOpenGLTexture::PixelType cppArg3{QOpenGLTexture::NoPixelType};
            pythonToCpp[3](pyArgs[3], &cppArg3);
            void* cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            if (!Shiboken::Object::isValid(pyArgs[5]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg5 = nullptr;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // setData(int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QOpenGLTexture.setData(int mipLevel, int layer, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, void * data, const QOpenGLPixelTransferOptions *const options) is deprecated", 1);
            break;
        }
        case 9: // setData(int mipLevel, int layer, int layerCount, QOpenGLTexture::CubeMapFace cubeFace, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[7]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[7]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QOpenGLTexture::CubeMapFace cppArg3 = static_cast< ::QOpenGLTexture::CubeMapFace>(0);
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QOpenGLTexture::PixelFormat cppArg4{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QOpenGLTexture::PixelType cppArg5{QOpenGLTexture::NoPixelType};
            pythonToCpp[5](pyArgs[5], &cppArg5);
            void* cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg7 = nullptr;
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);

            if (!PyErr_Occurred()) {
                // setData(int,int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
            }
            break;
        }
        case 10: // setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[9]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[9] = value;
                        if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[9]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            ::QOpenGLTexture::PixelFormat cppArg6{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QOpenGLTexture::PixelType cppArg7{QOpenGLTexture::NoPixelType};
            pythonToCpp[7](pyArgs[7], &cppArg7);
            void* cppArg8;
            pythonToCpp[8](pyArgs[8], &cppArg8);
            if (!Shiboken::Object::isValid(pyArgs[9]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg9 = nullptr;
            if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);

            if (!PyErr_Occurred()) {
                // setData(int,int,int,int,int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
            }
            break;
        }
        case 11: // setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int layer, QOpenGLTexture::CubeMapFace cubeFace, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[12]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[12] = value;
                        if (!(pythonToCpp[12] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[12]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            int cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);
            ::QOpenGLTexture::CubeMapFace cppArg8 = static_cast< ::QOpenGLTexture::CubeMapFace>(0);
            pythonToCpp[8](pyArgs[8], &cppArg8);
            ::QOpenGLTexture::PixelFormat cppArg9{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[9](pyArgs[9], &cppArg9);
            ::QOpenGLTexture::PixelType cppArg10{QOpenGLTexture::NoPixelType};
            pythonToCpp[10](pyArgs[10], &cppArg10);
            void* cppArg11;
            pythonToCpp[11](pyArgs[11], &cppArg11);
            if (!Shiboken::Object::isValid(pyArgs[12]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg12 = nullptr;
            if (pythonToCpp[12]) pythonToCpp[12](pyArgs[12], &cppArg12);

            if (!PyErr_Occurred()) {
                // setData(int,int,int,int,int,int,int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11, cppArg12);
            }
            break;
        }
        case 12: // setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int layer, QOpenGLTexture::CubeMapFace cubeFace, int layerCount, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[13]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[13] = value;
                        if (!(pythonToCpp[13] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[13]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            int cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);
            ::QOpenGLTexture::CubeMapFace cppArg8 = static_cast< ::QOpenGLTexture::CubeMapFace>(0);
            pythonToCpp[8](pyArgs[8], &cppArg8);
            int cppArg9;
            pythonToCpp[9](pyArgs[9], &cppArg9);
            ::QOpenGLTexture::PixelFormat cppArg10{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[10](pyArgs[10], &cppArg10);
            ::QOpenGLTexture::PixelType cppArg11{QOpenGLTexture::NoPixelType};
            pythonToCpp[11](pyArgs[11], &cppArg11);
            void* cppArg12;
            pythonToCpp[12](pyArgs[12], &cppArg12);
            if (!Shiboken::Object::isValid(pyArgs[13]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg13 = nullptr;
            if (pythonToCpp[13]) pythonToCpp[13](pyArgs[13], &cppArg13);

            if (!PyErr_Occurred()) {
                // setData(int,int,int,int,int,int,int,int,QOpenGLTexture::CubeMapFace,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11, cppArg12, cppArg13);
            }
            break;
        }
        case 13: // setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int layer, QOpenGLTexture::PixelFormat sourceFormat, QOpenGLTexture::PixelType sourceType, const void * data, const QOpenGLPixelTransferOptions *const options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[11]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    if (value) {
                        pyArgs[11] = value;
                        if (!(pythonToCpp[11] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLPIXELTRANSFEROPTIONS_IDX]), (pyArgs[11]))))
                            goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLTextureFunc_setData_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            int cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);
            ::QOpenGLTexture::PixelFormat cppArg8{QOpenGLTexture::NoSourceFormat};
            pythonToCpp[8](pyArgs[8], &cppArg8);
            ::QOpenGLTexture::PixelType cppArg9{QOpenGLTexture::NoPixelType};
            pythonToCpp[9](pyArgs[9], &cppArg9);
            void* cppArg10;
            pythonToCpp[10](pyArgs[10], &cppArg10);
            if (!Shiboken::Object::isValid(pyArgs[11]))
                return {};
            ::QOpenGLPixelTransferOptions *cppArg11 = nullptr;
            if (pythonToCpp[11]) pythonToCpp[11](pyArgs[11], &cppArg11);

            if (!PyErr_Occurred()) {
                // setData(int,int,int,int,int,int,int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,QOpenGLPixelTransferOptions*const)
                cppSelf->setData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setDepthStencilMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setDepthStencilMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setDepthStencilMode(QOpenGLTexture::DepthStencilMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_DEPTHSTENCILMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDepthStencilMode(QOpenGLTexture::DepthStencilMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setDepthStencilMode_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::DepthStencilMode cppArg0 = static_cast< ::QOpenGLTexture::DepthStencilMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDepthStencilMode(QOpenGLTexture::DepthStencilMode)
            cppSelf->setDepthStencilMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setDepthStencilMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setFixedSamplePositions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setFixedSamplePositions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setFixedSamplePositions(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFixedSamplePositions(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setFixedSamplePositions_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFixedSamplePositions(bool)
            cppSelf->setFixedSamplePositions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setFixedSamplePositions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setFormat(QOpenGLTexture::TextureFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFormat(QOpenGLTexture::TextureFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setFormat_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::TextureFormat cppArg0{QOpenGLTexture::NoFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFormat(QOpenGLTexture::TextureFormat)
            cppSelf->setFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setLayers(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setLayers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setLayers(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLayers(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setLayers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLayers(int)
            cppSelf->setLayers(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setLayers_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setLevelOfDetailRange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setLevelOfDetailRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setLevelOfDetailRange", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::setLevelOfDetailRange(float,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // setLevelOfDetailRange(float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setLevelOfDetailRange_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setLevelOfDetailRange(float,float)
            cppSelf->setLevelOfDetailRange(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setLevelOfDetailRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setLevelofDetailBias(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setLevelofDetailBias";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setLevelofDetailBias(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setLevelofDetailBias(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setLevelofDetailBias_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLevelofDetailBias(float)
            cppSelf->setLevelofDetailBias(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setLevelofDetailBias_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setMagnificationFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setMagnificationFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setMagnificationFilter(QOpenGLTexture::Filter)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMagnificationFilter(QOpenGLTexture::Filter)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setMagnificationFilter_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::Filter cppArg0 = static_cast< ::QOpenGLTexture::Filter>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMagnificationFilter(QOpenGLTexture::Filter)
            cppSelf->setMagnificationFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setMagnificationFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setMaximumAnisotropy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setMaximumAnisotropy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setMaximumAnisotropy(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setMaximumAnisotropy(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setMaximumAnisotropy_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaximumAnisotropy(float)
            cppSelf->setMaximumAnisotropy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setMaximumAnisotropy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setMaximumLevelOfDetail(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setMaximumLevelOfDetail";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setMaximumLevelOfDetail(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setMaximumLevelOfDetail(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setMaximumLevelOfDetail_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaximumLevelOfDetail(float)
            cppSelf->setMaximumLevelOfDetail(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setMaximumLevelOfDetail_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setMinMagFilters(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setMinMagFilters";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setMinMagFilters", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::setMinMagFilters(QOpenGLTexture::Filter,QOpenGLTexture::Filter)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // setMinMagFilters(QOpenGLTexture::Filter,QOpenGLTexture::Filter)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setMinMagFilters_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::Filter cppArg0 = static_cast< ::QOpenGLTexture::Filter>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QOpenGLTexture::Filter cppArg1 = static_cast< ::QOpenGLTexture::Filter>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setMinMagFilters(QOpenGLTexture::Filter,QOpenGLTexture::Filter)
            cppSelf->setMinMagFilters(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setMinMagFilters_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setMinificationFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setMinificationFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setMinificationFilter(QOpenGLTexture::Filter)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMinificationFilter(QOpenGLTexture::Filter)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setMinificationFilter_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::Filter cppArg0 = static_cast< ::QOpenGLTexture::Filter>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinificationFilter(QOpenGLTexture::Filter)
            cppSelf->setMinificationFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setMinificationFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setMinimumLevelOfDetail(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setMinimumLevelOfDetail";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setMinimumLevelOfDetail(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setMinimumLevelOfDetail(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setMinimumLevelOfDetail_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinimumLevelOfDetail(float)
            cppSelf->setMinimumLevelOfDetail(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setMinimumLevelOfDetail_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setMipBaseLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setMipBaseLevel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setMipBaseLevel(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMipBaseLevel(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setMipBaseLevel_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMipBaseLevel(int)
            cppSelf->setMipBaseLevel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setMipBaseLevel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setMipLevelRange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setMipLevelRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setMipLevelRange", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::setMipLevelRange(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setMipLevelRange(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setMipLevelRange_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setMipLevelRange(int,int)
            cppSelf->setMipLevelRange(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setMipLevelRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setMipLevels(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setMipLevels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setMipLevels(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMipLevels(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setMipLevels_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMipLevels(int)
            cppSelf->setMipLevels(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setMipLevels_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setMipMaxLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setMipMaxLevel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setMipMaxLevel(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMipMaxLevel(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setMipMaxLevel_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMipMaxLevel(int)
            cppSelf->setMipMaxLevel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setMipMaxLevel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setSamples(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setSamples";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::setSamples(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSamples(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setSamples_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSamples(int)
            cppSelf->setSamples(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setSamples_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setSize(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLTextureFunc_setSize_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLTextureFunc_setSize_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setSize", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::setSize(int,int,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setSize(int,int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setSize(int,int,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // setSize(int,int,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setSize_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_height = Shiboken::String::createStaticString("height");
            if (PyDict_Contains(kwds, key_height)) {
                value = PyDict_GetItem(kwds, key_height);
                if (value && pyArgs[1]) {
                    errInfo = key_height;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLTextureFunc_setSize_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QOpenGLTextureFunc_setSize_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_height);
            }
            static PyObject *const key_depth = Shiboken::String::createStaticString("depth");
            if (PyDict_Contains(kwds, key_depth)) {
                value = PyDict_GetItem(kwds, key_depth);
                if (value && pyArgs[2]) {
                    errInfo = key_depth;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLTextureFunc_setSize_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QOpenGLTextureFunc_setSize_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_depth);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QOpenGLTextureFunc_setSize_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 1;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setSize(int,int,int)
            cppSelf->setSize(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setSwizzleMask(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setSwizzleMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto Sbk_QOpenGLTextureFunc_setSwizzleMask_TypeError;

    if (!PyArg_UnpackTuple(args, "setSwizzleMask", 2, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::setSwizzleMask(QOpenGLTexture::SwizzleComponent,QOpenGLTexture::SwizzleValue)
    // 1: QOpenGLTexture::setSwizzleMask(QOpenGLTexture::SwizzleValue,QOpenGLTexture::SwizzleValue,QOpenGLTexture::SwizzleValue,QOpenGLTexture::SwizzleValue)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX])->converter, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX])->converter, (pyArgs[3])))) {
        overloadId = 1; // setSwizzleMask(QOpenGLTexture::SwizzleValue,QOpenGLTexture::SwizzleValue,QOpenGLTexture::SwizzleValue,QOpenGLTexture::SwizzleValue)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLECOMPONENT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // setSwizzleMask(QOpenGLTexture::SwizzleComponent,QOpenGLTexture::SwizzleValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setSwizzleMask_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setSwizzleMask(QOpenGLTexture::SwizzleComponent component, QOpenGLTexture::SwizzleValue value)
        {
            ::QOpenGLTexture::SwizzleComponent cppArg0 = static_cast< ::QOpenGLTexture::SwizzleComponent>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QOpenGLTexture::SwizzleValue cppArg1{QOpenGLTexture::ZeroValue};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setSwizzleMask(QOpenGLTexture::SwizzleComponent,QOpenGLTexture::SwizzleValue)
                cppSelf->setSwizzleMask(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setSwizzleMask(QOpenGLTexture::SwizzleValue r, QOpenGLTexture::SwizzleValue g, QOpenGLTexture::SwizzleValue b, QOpenGLTexture::SwizzleValue a)
        {
            ::QOpenGLTexture::SwizzleValue cppArg0{QOpenGLTexture::ZeroValue};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QOpenGLTexture::SwizzleValue cppArg1{QOpenGLTexture::ZeroValue};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QOpenGLTexture::SwizzleValue cppArg2{QOpenGLTexture::ZeroValue};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QOpenGLTexture::SwizzleValue cppArg3{QOpenGLTexture::ZeroValue};
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setSwizzleMask(QOpenGLTexture::SwizzleValue,QOpenGLTexture::SwizzleValue,QOpenGLTexture::SwizzleValue,QOpenGLTexture::SwizzleValue)
                cppSelf->setSwizzleMask(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setSwizzleMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_setWrapMode(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.setWrapMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setWrapMode", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTexture::setWrapMode(QOpenGLTexture::CoordinateDirection,QOpenGLTexture::WrapMode)
    // 1: QOpenGLTexture::setWrapMode(QOpenGLTexture::WrapMode)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // setWrapMode(QOpenGLTexture::WrapMode)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COORDINATEDIRECTION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // setWrapMode(QOpenGLTexture::CoordinateDirection,QOpenGLTexture::WrapMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_setWrapMode_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setWrapMode(QOpenGLTexture::CoordinateDirection direction, QOpenGLTexture::WrapMode mode)
        {
            ::QOpenGLTexture::CoordinateDirection cppArg0 = static_cast< ::QOpenGLTexture::CoordinateDirection>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QOpenGLTexture::WrapMode cppArg1 = static_cast< ::QOpenGLTexture::WrapMode>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setWrapMode(QOpenGLTexture::CoordinateDirection,QOpenGLTexture::WrapMode)
                cppSelf->setWrapMode(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setWrapMode(QOpenGLTexture::WrapMode mode)
        {
            ::QOpenGLTexture::WrapMode cppArg0 = static_cast< ::QOpenGLTexture::WrapMode>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setWrapMode(QOpenGLTexture::WrapMode)
                cppSelf->setWrapMode(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureFunc_setWrapMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_swizzleMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.swizzleMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::swizzleMask(QOpenGLTexture::SwizzleComponent)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLECOMPONENT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // swizzleMask(QOpenGLTexture::SwizzleComponent)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_swizzleMask_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::SwizzleComponent cppArg0 = static_cast< ::QOpenGLTexture::SwizzleComponent>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // swizzleMask(QOpenGLTexture::SwizzleComponent)const
            QOpenGLTexture::SwizzleValue cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->swizzleMask(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLTextureFunc_swizzleMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureFunc_target(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.target";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // target()const
            QOpenGLTexture::Target cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->target();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_textureId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.textureId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureId()const
            unsigned int cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->textureId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            int cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureFunc_wrapMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTexture.wrapMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTexture::wrapMode(QOpenGLTexture::CoordinateDirection)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COORDINATEDIRECTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // wrapMode(QOpenGLTexture::CoordinateDirection)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureFunc_wrapMode_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::CoordinateDirection cppArg0 = static_cast< ::QOpenGLTexture::CoordinateDirection>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // wrapMode(QOpenGLTexture::CoordinateDirection)const
            QOpenGLTexture::WrapMode cppResult = const_cast<const ::QOpenGLTexture *>(cppSelf)->wrapMode(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLTextureFunc_wrapMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QOpenGLTexture_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLTexture_methods[] = {
    {"allocateStorage", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_allocateStorage), METH_VARARGS},
    {"bind", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_bind), METH_VARARGS|METH_KEYWORDS},
    {"borderColor", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_borderColor), METH_NOARGS},
    {"boundTextureId", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_boundTextureId), METH_VARARGS|METH_STATIC},
    {"comparisonFunction", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_comparisonFunction), METH_NOARGS},
    {"comparisonMode", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_comparisonMode), METH_NOARGS},
    {"create", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_create), METH_NOARGS},
    {"createTextureView", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_createTextureView), METH_VARARGS},
    {"depth", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_depth), METH_NOARGS},
    {"depthStencilMode", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_depthStencilMode), METH_NOARGS},
    {"destroy", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_destroy), METH_NOARGS},
    {"faces", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_faces), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_format), METH_NOARGS},
    {"generateMipMaps", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_generateMipMaps), METH_VARARGS|METH_KEYWORDS},
    {"hasFeature", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_hasFeature), METH_O|METH_STATIC},
    {"height", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_height), METH_NOARGS},
    {"isAutoMipMapGenerationEnabled", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_isAutoMipMapGenerationEnabled), METH_NOARGS},
    {"isBound", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_isBound), METH_VARARGS},
    {"isCreated", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_isCreated), METH_NOARGS},
    {"isFixedSamplePositions", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_isFixedSamplePositions), METH_NOARGS},
    {"isStorageAllocated", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_isStorageAllocated), METH_NOARGS},
    {"isTextureView", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_isTextureView), METH_NOARGS},
    {"layers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_layers), METH_NOARGS},
    {"levelOfDetailRange", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_levelOfDetailRange), METH_NOARGS},
    {"levelofDetailBias", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_levelofDetailBias), METH_NOARGS},
    {"magnificationFilter", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_magnificationFilter), METH_NOARGS},
    {"maximumAnisotropy", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_maximumAnisotropy), METH_NOARGS},
    {"maximumLevelOfDetail", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_maximumLevelOfDetail), METH_NOARGS},
    {"maximumMipLevels", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_maximumMipLevels), METH_NOARGS},
    {"minMagFilters", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_minMagFilters), METH_NOARGS},
    {"minificationFilter", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_minificationFilter), METH_NOARGS},
    {"minimumLevelOfDetail", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_minimumLevelOfDetail), METH_NOARGS},
    {"mipBaseLevel", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_mipBaseLevel), METH_NOARGS},
    {"mipLevelRange", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_mipLevelRange), METH_NOARGS},
    {"mipLevels", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_mipLevels), METH_NOARGS},
    {"mipMaxLevel", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_mipMaxLevel), METH_NOARGS},
    {"release", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_release), METH_VARARGS|METH_KEYWORDS},
    {"samples", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_samples), METH_NOARGS},
    {"setAutoMipMapGenerationEnabled", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setAutoMipMapGenerationEnabled), METH_O},
    {"setBorderColor", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setBorderColor), METH_VARARGS},
    {"setComparisonFunction", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setComparisonFunction), METH_O},
    {"setComparisonMode", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setComparisonMode), METH_O},
    {"setCompressedData", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setCompressedData), METH_VARARGS|METH_KEYWORDS},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setData), METH_VARARGS|METH_KEYWORDS},
    {"setDepthStencilMode", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setDepthStencilMode), METH_O},
    {"setFixedSamplePositions", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setFixedSamplePositions), METH_O},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setFormat), METH_O},
    {"setLayers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setLayers), METH_O},
    {"setLevelOfDetailRange", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setLevelOfDetailRange), METH_VARARGS},
    {"setLevelofDetailBias", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setLevelofDetailBias), METH_O},
    {"setMagnificationFilter", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setMagnificationFilter), METH_O},
    {"setMaximumAnisotropy", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setMaximumAnisotropy), METH_O},
    {"setMaximumLevelOfDetail", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setMaximumLevelOfDetail), METH_O},
    {"setMinMagFilters", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setMinMagFilters), METH_VARARGS},
    {"setMinificationFilter", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setMinificationFilter), METH_O},
    {"setMinimumLevelOfDetail", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setMinimumLevelOfDetail), METH_O},
    {"setMipBaseLevel", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setMipBaseLevel), METH_O},
    {"setMipLevelRange", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setMipLevelRange), METH_VARARGS},
    {"setMipLevels", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setMipLevels), METH_O},
    {"setMipMaxLevel", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setMipMaxLevel), METH_O},
    {"setSamples", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setSamples), METH_O},
    {"setSize", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setSize), METH_VARARGS|METH_KEYWORDS},
    {"setSwizzleMask", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setSwizzleMask), METH_VARARGS},
    {"setWrapMode", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_setWrapMode), METH_VARARGS},
    {"swizzleMask", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_swizzleMask), METH_O},
    {"target", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_target), METH_NOARGS},
    {"textureId", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_textureId), METH_NOARGS},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_width), METH_NOARGS},
    {"wrapMode", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureFunc_wrapMode), METH_O},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QOpenGLTexture_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLTexture_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QOpenGLTexture__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLTexture_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLTexture_TypeF(void)
{
    return _Sbk_QOpenGLTexture_Type;
}

static PyType_Slot Sbk_QOpenGLTexture_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QOpenGLTexture__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLTexture_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLTexture_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLTexture_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLTexture_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLTexture_spec = {
    "2:PySide2.QtGui.QOpenGLTexture",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLTexture_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QOpenGLTexture_Feature___and__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLTexture::Features cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLTexture::Features>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLTexture::Features>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLTexture::Features>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLTexture::Features>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLTexture_Feature___or__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLTexture::Features cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLTexture::Features>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLTexture::Features>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLTexture::Features>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLTexture::Features>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLTexture_Feature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLTexture::Features cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QOpenGLTexture::Features>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QOpenGLTexture::Features>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QOpenGLTexture::Features>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QOpenGLTexture::Features>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QOpenGLTexture_Feature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QOpenGLTexture::Features cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX])->converter, self, &cppSelf);
    ::QOpenGLTexture::Features cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QOpenGLTexture_Feature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QOpenGLTexture_Feature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QOpenGLTexture_Feature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLTexture_Feature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLTexture_Feature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLTexture_Feature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLTexture_Feature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLTexture_Feature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLTexture_Feature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLTexture_Feature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLTexture_Feature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLTexture_Feature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QOpenGLTexture_Feature_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QOpenGLTexture_Target_PythonToCpp_QOpenGLTexture_Target(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::Target *>(cppOut) =
        static_cast<::QOpenGLTexture::Target>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_Target_PythonToCpp_QOpenGLTexture_Target_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX]))
        return QOpenGLTexture_Target_PythonToCpp_QOpenGLTexture_Target;
    return {};
}
static PyObject *QOpenGLTexture_Target_CppToPython_QOpenGLTexture_Target(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::Target *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX], castCppIn);

}

static void QOpenGLTexture_BindingTarget_PythonToCpp_QOpenGLTexture_BindingTarget(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::BindingTarget *>(cppOut) =
        static_cast<::QOpenGLTexture::BindingTarget>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_BindingTarget_PythonToCpp_QOpenGLTexture_BindingTarget_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX]))
        return QOpenGLTexture_BindingTarget_PythonToCpp_QOpenGLTexture_BindingTarget;
    return {};
}
static PyObject *QOpenGLTexture_BindingTarget_CppToPython_QOpenGLTexture_BindingTarget(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::BindingTarget *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX], castCppIn);

}

static void QOpenGLTexture_MipMapGeneration_PythonToCpp_QOpenGLTexture_MipMapGeneration(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::MipMapGeneration *>(cppOut) =
        static_cast<::QOpenGLTexture::MipMapGeneration>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_MipMapGeneration_PythonToCpp_QOpenGLTexture_MipMapGeneration_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_MIPMAPGENERATION_IDX]))
        return QOpenGLTexture_MipMapGeneration_PythonToCpp_QOpenGLTexture_MipMapGeneration;
    return {};
}
static PyObject *QOpenGLTexture_MipMapGeneration_CppToPython_QOpenGLTexture_MipMapGeneration(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::MipMapGeneration *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_MIPMAPGENERATION_IDX], castCppIn);

}

static void QOpenGLTexture_TextureUnitReset_PythonToCpp_QOpenGLTexture_TextureUnitReset(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::TextureUnitReset *>(cppOut) =
        static_cast<::QOpenGLTexture::TextureUnitReset>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_TextureUnitReset_PythonToCpp_QOpenGLTexture_TextureUnitReset_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREUNITRESET_IDX]))
        return QOpenGLTexture_TextureUnitReset_PythonToCpp_QOpenGLTexture_TextureUnitReset;
    return {};
}
static PyObject *QOpenGLTexture_TextureUnitReset_CppToPython_QOpenGLTexture_TextureUnitReset(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::TextureUnitReset *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREUNITRESET_IDX], castCppIn);

}

static void QOpenGLTexture_TextureFormat_PythonToCpp_QOpenGLTexture_TextureFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::TextureFormat *>(cppOut) =
        static_cast<::QOpenGLTexture::TextureFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_TextureFormat_PythonToCpp_QOpenGLTexture_TextureFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX]))
        return QOpenGLTexture_TextureFormat_PythonToCpp_QOpenGLTexture_TextureFormat;
    return {};
}
static PyObject *QOpenGLTexture_TextureFormat_CppToPython_QOpenGLTexture_TextureFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::TextureFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX], castCppIn);

}

static void QOpenGLTexture_TextureFormatClass_PythonToCpp_QOpenGLTexture_TextureFormatClass(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::TextureFormatClass *>(cppOut) =
        static_cast<::QOpenGLTexture::TextureFormatClass>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_TextureFormatClass_PythonToCpp_QOpenGLTexture_TextureFormatClass_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX]))
        return QOpenGLTexture_TextureFormatClass_PythonToCpp_QOpenGLTexture_TextureFormatClass;
    return {};
}
static PyObject *QOpenGLTexture_TextureFormatClass_CppToPython_QOpenGLTexture_TextureFormatClass(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::TextureFormatClass *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX], castCppIn);

}

static void QOpenGLTexture_CubeMapFace_PythonToCpp_QOpenGLTexture_CubeMapFace(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::CubeMapFace *>(cppOut) =
        static_cast<::QOpenGLTexture::CubeMapFace>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_CubeMapFace_PythonToCpp_QOpenGLTexture_CubeMapFace_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX]))
        return QOpenGLTexture_CubeMapFace_PythonToCpp_QOpenGLTexture_CubeMapFace;
    return {};
}
static PyObject *QOpenGLTexture_CubeMapFace_CppToPython_QOpenGLTexture_CubeMapFace(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::CubeMapFace *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX], castCppIn);

}

static void QOpenGLTexture_PixelFormat_PythonToCpp_QOpenGLTexture_PixelFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::PixelFormat *>(cppOut) =
        static_cast<::QOpenGLTexture::PixelFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_PixelFormat_PythonToCpp_QOpenGLTexture_PixelFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX]))
        return QOpenGLTexture_PixelFormat_PythonToCpp_QOpenGLTexture_PixelFormat;
    return {};
}
static PyObject *QOpenGLTexture_PixelFormat_CppToPython_QOpenGLTexture_PixelFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::PixelFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX], castCppIn);

}

static void QOpenGLTexture_PixelType_PythonToCpp_QOpenGLTexture_PixelType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::PixelType *>(cppOut) =
        static_cast<::QOpenGLTexture::PixelType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_PixelType_PythonToCpp_QOpenGLTexture_PixelType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX]))
        return QOpenGLTexture_PixelType_PythonToCpp_QOpenGLTexture_PixelType;
    return {};
}
static PyObject *QOpenGLTexture_PixelType_CppToPython_QOpenGLTexture_PixelType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::PixelType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX], castCppIn);

}

static void QOpenGLTexture_SwizzleComponent_PythonToCpp_QOpenGLTexture_SwizzleComponent(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::SwizzleComponent *>(cppOut) =
        static_cast<::QOpenGLTexture::SwizzleComponent>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_SwizzleComponent_PythonToCpp_QOpenGLTexture_SwizzleComponent_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLECOMPONENT_IDX]))
        return QOpenGLTexture_SwizzleComponent_PythonToCpp_QOpenGLTexture_SwizzleComponent;
    return {};
}
static PyObject *QOpenGLTexture_SwizzleComponent_CppToPython_QOpenGLTexture_SwizzleComponent(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::SwizzleComponent *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLECOMPONENT_IDX], castCppIn);

}

static void QOpenGLTexture_SwizzleValue_PythonToCpp_QOpenGLTexture_SwizzleValue(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::SwizzleValue *>(cppOut) =
        static_cast<::QOpenGLTexture::SwizzleValue>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_SwizzleValue_PythonToCpp_QOpenGLTexture_SwizzleValue_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX]))
        return QOpenGLTexture_SwizzleValue_PythonToCpp_QOpenGLTexture_SwizzleValue;
    return {};
}
static PyObject *QOpenGLTexture_SwizzleValue_CppToPython_QOpenGLTexture_SwizzleValue(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::SwizzleValue *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX], castCppIn);

}

static void QOpenGLTexture_WrapMode_PythonToCpp_QOpenGLTexture_WrapMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::WrapMode *>(cppOut) =
        static_cast<::QOpenGLTexture::WrapMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_WrapMode_PythonToCpp_QOpenGLTexture_WrapMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX]))
        return QOpenGLTexture_WrapMode_PythonToCpp_QOpenGLTexture_WrapMode;
    return {};
}
static PyObject *QOpenGLTexture_WrapMode_CppToPython_QOpenGLTexture_WrapMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::WrapMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX], castCppIn);

}

static void QOpenGLTexture_CoordinateDirection_PythonToCpp_QOpenGLTexture_CoordinateDirection(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::CoordinateDirection *>(cppOut) =
        static_cast<::QOpenGLTexture::CoordinateDirection>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_CoordinateDirection_PythonToCpp_QOpenGLTexture_CoordinateDirection_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COORDINATEDIRECTION_IDX]))
        return QOpenGLTexture_CoordinateDirection_PythonToCpp_QOpenGLTexture_CoordinateDirection;
    return {};
}
static PyObject *QOpenGLTexture_CoordinateDirection_CppToPython_QOpenGLTexture_CoordinateDirection(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::CoordinateDirection *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COORDINATEDIRECTION_IDX], castCppIn);

}

static void QOpenGLTexture_Feature_PythonToCpp_QOpenGLTexture_Feature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::Feature *>(cppOut) =
        static_cast<::QOpenGLTexture::Feature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_Feature_PythonToCpp_QOpenGLTexture_Feature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX]))
        return QOpenGLTexture_Feature_PythonToCpp_QOpenGLTexture_Feature;
    return {};
}
static PyObject *QOpenGLTexture_Feature_CppToPython_QOpenGLTexture_Feature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::Feature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX], castCppIn);

}

static void QFlags_QOpenGLTexture_Feature__PythonToCpp_QFlags_QOpenGLTexture_Feature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QOpenGLTexture::Feature> *>(cppOut) =
        ::QFlags<QOpenGLTexture::Feature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QOpenGLTexture_Feature__PythonToCpp_QFlags_QOpenGLTexture_Feature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX]))
        return QFlags_QOpenGLTexture_Feature__PythonToCpp_QFlags_QOpenGLTexture_Feature_;
    return {};
}
static PyObject *QFlags_QOpenGLTexture_Feature__CppToPython_QFlags_QOpenGLTexture_Feature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QOpenGLTexture::Feature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX]));

}

static void QOpenGLTexture_Feature_PythonToCpp_QFlags_QOpenGLTexture_Feature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QOpenGLTexture::Feature> *>(cppOut) =
        ::QFlags<QOpenGLTexture::Feature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QOpenGLTexture_Feature_PythonToCpp_QFlags_QOpenGLTexture_Feature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX]))
        return QOpenGLTexture_Feature_PythonToCpp_QFlags_QOpenGLTexture_Feature_;
    return {};
}
static void number_PythonToCpp_QFlags_QOpenGLTexture_Feature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QOpenGLTexture::Feature> *>(cppOut) =
        ::QFlags<QOpenGLTexture::Feature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QOpenGLTexture_Feature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX]))
        return number_PythonToCpp_QFlags_QOpenGLTexture_Feature_;
    return {};
}
static void QOpenGLTexture_DepthStencilMode_PythonToCpp_QOpenGLTexture_DepthStencilMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::DepthStencilMode *>(cppOut) =
        static_cast<::QOpenGLTexture::DepthStencilMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_DepthStencilMode_PythonToCpp_QOpenGLTexture_DepthStencilMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_DEPTHSTENCILMODE_IDX]))
        return QOpenGLTexture_DepthStencilMode_PythonToCpp_QOpenGLTexture_DepthStencilMode;
    return {};
}
static PyObject *QOpenGLTexture_DepthStencilMode_CppToPython_QOpenGLTexture_DepthStencilMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::DepthStencilMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_DEPTHSTENCILMODE_IDX], castCppIn);

}

static void QOpenGLTexture_ComparisonFunction_PythonToCpp_QOpenGLTexture_ComparisonFunction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::ComparisonFunction *>(cppOut) =
        static_cast<::QOpenGLTexture::ComparisonFunction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_ComparisonFunction_PythonToCpp_QOpenGLTexture_ComparisonFunction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX]))
        return QOpenGLTexture_ComparisonFunction_PythonToCpp_QOpenGLTexture_ComparisonFunction;
    return {};
}
static PyObject *QOpenGLTexture_ComparisonFunction_CppToPython_QOpenGLTexture_ComparisonFunction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::ComparisonFunction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX], castCppIn);

}

static void QOpenGLTexture_ComparisonMode_PythonToCpp_QOpenGLTexture_ComparisonMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::ComparisonMode *>(cppOut) =
        static_cast<::QOpenGLTexture::ComparisonMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_ComparisonMode_PythonToCpp_QOpenGLTexture_ComparisonMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONMODE_IDX]))
        return QOpenGLTexture_ComparisonMode_PythonToCpp_QOpenGLTexture_ComparisonMode;
    return {};
}
static PyObject *QOpenGLTexture_ComparisonMode_CppToPython_QOpenGLTexture_ComparisonMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::ComparisonMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONMODE_IDX], castCppIn);

}

static void QOpenGLTexture_Filter_PythonToCpp_QOpenGLTexture_Filter(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTexture::Filter *>(cppOut) =
        static_cast<::QOpenGLTexture::Filter>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTexture_Filter_PythonToCpp_QOpenGLTexture_Filter_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX]))
        return QOpenGLTexture_Filter_PythonToCpp_QOpenGLTexture_Filter;
    return {};
}
static PyObject *QOpenGLTexture_Filter_CppToPython_QOpenGLTexture_Filter(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTexture::Filter *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLTexture_PythonToCpp_QOpenGLTexture_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLTexture_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLTexture_PythonToCpp_QOpenGLTexture_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLTexture_TypeF())))
        return QOpenGLTexture_PythonToCpp_QOpenGLTexture_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLTexture_PTR_CppToPython_QOpenGLTexture(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QOpenGLTexture *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QOpenGLTexture_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLTexture_SignatureStrings[] = {
    "1:PySide2.QtGui.QOpenGLTexture(self,target:PySide2.QtGui.QOpenGLTexture.Target)",
    "0:PySide2.QtGui.QOpenGLTexture(self,image:PySide2.QtGui.QImage,genMipMaps:PySide2.QtGui.QOpenGLTexture.MipMapGeneration=GenerateMipMaps)",
    "1:PySide2.QtGui.QOpenGLTexture.allocateStorage(self)",
    "0:PySide2.QtGui.QOpenGLTexture.allocateStorage(self,pixelFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,pixelType:PySide2.QtGui.QOpenGLTexture.PixelType)",
    "1:PySide2.QtGui.QOpenGLTexture.bind(self)",
    "0:PySide2.QtGui.QOpenGLTexture.bind(self,unit:uint,reset:PySide2.QtGui.QOpenGLTexture.TextureUnitReset=DontResetTextureUnit)",
    "PySide2.QtGui.QOpenGLTexture.borderColor(self)->PySide2.QtGui.QColor",
    "1:PySide2.QtGui.QOpenGLTexture.boundTextureId(target:PySide2.QtGui.QOpenGLTexture.BindingTarget)->unsigned int",
    "0:PySide2.QtGui.QOpenGLTexture.boundTextureId(unit:uint,target:PySide2.QtGui.QOpenGLTexture.BindingTarget)->unsigned int",
    "PySide2.QtGui.QOpenGLTexture.comparisonFunction(self)->PySide2.QtGui.QOpenGLTexture.ComparisonFunction",
    "PySide2.QtGui.QOpenGLTexture.comparisonMode(self)->PySide2.QtGui.QOpenGLTexture.ComparisonMode",
    "PySide2.QtGui.QOpenGLTexture.create(self)->bool",
    "PySide2.QtGui.QOpenGLTexture.createTextureView(self,target:PySide2.QtGui.QOpenGLTexture.Target,viewFormat:PySide2.QtGui.QOpenGLTexture.TextureFormat,minimumMipmapLevel:int,maximumMipmapLevel:int,minimumLayer:int,maximumLayer:int)->PySide2.QtGui.QOpenGLTexture",
    "PySide2.QtGui.QOpenGLTexture.depth(self)->int",
    "PySide2.QtGui.QOpenGLTexture.depthStencilMode(self)->PySide2.QtGui.QOpenGLTexture.DepthStencilMode",
    "PySide2.QtGui.QOpenGLTexture.destroy(self)",
    "PySide2.QtGui.QOpenGLTexture.faces(self)->int",
    "PySide2.QtGui.QOpenGLTexture.format(self)->PySide2.QtGui.QOpenGLTexture.TextureFormat",
    "1:PySide2.QtGui.QOpenGLTexture.generateMipMaps(self)",
    "0:PySide2.QtGui.QOpenGLTexture.generateMipMaps(self,baseLevel:int,resetBaseLevel:bool=true)",
    "PySide2.QtGui.QOpenGLTexture.hasFeature(feature:PySide2.QtGui.QOpenGLTexture.Feature)->bool",
    "PySide2.QtGui.QOpenGLTexture.height(self)->int",
    "PySide2.QtGui.QOpenGLTexture.isAutoMipMapGenerationEnabled(self)->bool",
    "1:PySide2.QtGui.QOpenGLTexture.isBound(self)->bool",
    "0:PySide2.QtGui.QOpenGLTexture.isBound(self,unit:uint)->bool",
    "PySide2.QtGui.QOpenGLTexture.isCreated(self)->bool",
    "PySide2.QtGui.QOpenGLTexture.isFixedSamplePositions(self)->bool",
    "PySide2.QtGui.QOpenGLTexture.isStorageAllocated(self)->bool",
    "PySide2.QtGui.QOpenGLTexture.isTextureView(self)->bool",
    "PySide2.QtGui.QOpenGLTexture.layers(self)->int",
    "PySide2.QtGui.QOpenGLTexture.levelOfDetailRange(self)->QPair[float, float]",
    "PySide2.QtGui.QOpenGLTexture.levelofDetailBias(self)->float",
    "PySide2.QtGui.QOpenGLTexture.magnificationFilter(self)->PySide2.QtGui.QOpenGLTexture.Filter",
    "PySide2.QtGui.QOpenGLTexture.maximumAnisotropy(self)->float",
    "PySide2.QtGui.QOpenGLTexture.maximumLevelOfDetail(self)->float",
    "PySide2.QtGui.QOpenGLTexture.maximumMipLevels(self)->int",
    "PySide2.QtGui.QOpenGLTexture.minMagFilters(self)->QPair[PySide2.QtGui.QOpenGLTexture.Filter, PySide2.QtGui.QOpenGLTexture.Filter]",
    "PySide2.QtGui.QOpenGLTexture.minificationFilter(self)->PySide2.QtGui.QOpenGLTexture.Filter",
    "PySide2.QtGui.QOpenGLTexture.minimumLevelOfDetail(self)->float",
    "PySide2.QtGui.QOpenGLTexture.mipBaseLevel(self)->int",
    "PySide2.QtGui.QOpenGLTexture.mipLevelRange(self)->QPair[int, int]",
    "PySide2.QtGui.QOpenGLTexture.mipLevels(self)->int",
    "PySide2.QtGui.QOpenGLTexture.mipMaxLevel(self)->int",
    "1:PySide2.QtGui.QOpenGLTexture.release(self)",
    "0:PySide2.QtGui.QOpenGLTexture.release(self,unit:uint,reset:PySide2.QtGui.QOpenGLTexture.TextureUnitReset=DontResetTextureUnit)",
    "PySide2.QtGui.QOpenGLTexture.samples(self)->int",
    "PySide2.QtGui.QOpenGLTexture.setAutoMipMapGenerationEnabled(self,enabled:bool)",
    "3:PySide2.QtGui.QOpenGLTexture.setBorderColor(self,color:PySide2.QtGui.QColor)",
    "2:PySide2.QtGui.QOpenGLTexture.setBorderColor(self,r:float,g:float,b:float,a:float)",
    "1:PySide2.QtGui.QOpenGLTexture.setBorderColor(self,r:int,g:int,b:int,a:int)",
    "0:PySide2.QtGui.QOpenGLTexture.setBorderColor(self,r:uint,g:uint,b:uint,a:uint)",
    "PySide2.QtGui.QOpenGLTexture.setComparisonFunction(self,function:PySide2.QtGui.QOpenGLTexture.ComparisonFunction)",
    "PySide2.QtGui.QOpenGLTexture.setComparisonMode(self,mode:PySide2.QtGui.QOpenGLTexture.ComparisonMode)",
    "8:PySide2.QtGui.QOpenGLTexture.setCompressedData(self,dataSize:int,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "7:PySide2.QtGui.QOpenGLTexture.setCompressedData(self,dataSize:int,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "6:PySide2.QtGui.QOpenGLTexture.setCompressedData(self,mipLevel:int,dataSize:int,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "5:PySide2.QtGui.QOpenGLTexture.setCompressedData(self,mipLevel:int,dataSize:int,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "4:PySide2.QtGui.QOpenGLTexture.setCompressedData(self,mipLevel:int,layer:int,cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace,dataSize:int,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "3:PySide2.QtGui.QOpenGLTexture.setCompressedData(self,mipLevel:int,layer:int,cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace,dataSize:int,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "2:PySide2.QtGui.QOpenGLTexture.setCompressedData(self,mipLevel:int,layer:int,dataSize:int,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "1:PySide2.QtGui.QOpenGLTexture.setCompressedData(self,mipLevel:int,layer:int,dataSize:int,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "0:PySide2.QtGui.QOpenGLTexture.setCompressedData(self,mipLevel:int,layer:int,layerCount:int,cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace,dataSize:int,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "13:PySide2.QtGui.QOpenGLTexture.setData(self,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "12:PySide2.QtGui.QOpenGLTexture.setData(self,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "11:PySide2.QtGui.QOpenGLTexture.setData(self,image:PySide2.QtGui.QImage,genMipMaps:PySide2.QtGui.QOpenGLTexture.MipMapGeneration=GenerateMipMaps)",
    "10:PySide2.QtGui.QOpenGLTexture.setData(self,mipLevel:int,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "9:PySide2.QtGui.QOpenGLTexture.setData(self,mipLevel:int,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "8:PySide2.QtGui.QOpenGLTexture.setData(self,mipLevel:int,layer:int,cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "7:PySide2.QtGui.QOpenGLTexture.setData(self,mipLevel:int,layer:int,cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "6:PySide2.QtGui.QOpenGLTexture.setData(self,mipLevel:int,layer:int,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "5:PySide2.QtGui.QOpenGLTexture.setData(self,mipLevel:int,layer:int,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "4:PySide2.QtGui.QOpenGLTexture.setData(self,mipLevel:int,layer:int,layerCount:int,cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "3:PySide2.QtGui.QOpenGLTexture.setData(self,xOffset:int,yOffset:int,zOffset:int,width:int,height:int,depth:int,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "2:PySide2.QtGui.QOpenGLTexture.setData(self,xOffset:int,yOffset:int,zOffset:int,width:int,height:int,depth:int,mipLevel:int,layer:int,cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "1:PySide2.QtGui.QOpenGLTexture.setData(self,xOffset:int,yOffset:int,zOffset:int,width:int,height:int,depth:int,mipLevel:int,layer:int,cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace,layerCount:int,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "0:PySide2.QtGui.QOpenGLTexture.setData(self,xOffset:int,yOffset:int,zOffset:int,width:int,height:int,depth:int,mipLevel:int,layer:int,sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat,sourceType:PySide2.QtGui.QOpenGLTexture.PixelType,data:void,options:PySide2.QtGui.QOpenGLPixelTransferOptions=nullptr)",
    "PySide2.QtGui.QOpenGLTexture.setDepthStencilMode(self,mode:PySide2.QtGui.QOpenGLTexture.DepthStencilMode)",
    "PySide2.QtGui.QOpenGLTexture.setFixedSamplePositions(self,fixed:bool)",
    "PySide2.QtGui.QOpenGLTexture.setFormat(self,format:PySide2.QtGui.QOpenGLTexture.TextureFormat)",
    "PySide2.QtGui.QOpenGLTexture.setLayers(self,layers:int)",
    "PySide2.QtGui.QOpenGLTexture.setLevelOfDetailRange(self,min:float,max:float)",
    "PySide2.QtGui.QOpenGLTexture.setLevelofDetailBias(self,bias:float)",
    "PySide2.QtGui.QOpenGLTexture.setMagnificationFilter(self,filter:PySide2.QtGui.QOpenGLTexture.Filter)",
    "PySide2.QtGui.QOpenGLTexture.setMaximumAnisotropy(self,anisotropy:float)",
    "PySide2.QtGui.QOpenGLTexture.setMaximumLevelOfDetail(self,value:float)",
    "PySide2.QtGui.QOpenGLTexture.setMinMagFilters(self,minificationFilter:PySide2.QtGui.QOpenGLTexture.Filter,magnificationFilter:PySide2.QtGui.QOpenGLTexture.Filter)",
    "PySide2.QtGui.QOpenGLTexture.setMinificationFilter(self,filter:PySide2.QtGui.QOpenGLTexture.Filter)",
    "PySide2.QtGui.QOpenGLTexture.setMinimumLevelOfDetail(self,value:float)",
    "PySide2.QtGui.QOpenGLTexture.setMipBaseLevel(self,baseLevel:int)",
    "PySide2.QtGui.QOpenGLTexture.setMipLevelRange(self,baseLevel:int,maxLevel:int)",
    "PySide2.QtGui.QOpenGLTexture.setMipLevels(self,levels:int)",
    "PySide2.QtGui.QOpenGLTexture.setMipMaxLevel(self,maxLevel:int)",
    "PySide2.QtGui.QOpenGLTexture.setSamples(self,samples:int)",
    "PySide2.QtGui.QOpenGLTexture.setSize(self,width:int,height:int=1,depth:int=1)",
    "1:PySide2.QtGui.QOpenGLTexture.setSwizzleMask(self,component:PySide2.QtGui.QOpenGLTexture.SwizzleComponent,value:PySide2.QtGui.QOpenGLTexture.SwizzleValue)",
    "0:PySide2.QtGui.QOpenGLTexture.setSwizzleMask(self,r:PySide2.QtGui.QOpenGLTexture.SwizzleValue,g:PySide2.QtGui.QOpenGLTexture.SwizzleValue,b:PySide2.QtGui.QOpenGLTexture.SwizzleValue,a:PySide2.QtGui.QOpenGLTexture.SwizzleValue)",
    "1:PySide2.QtGui.QOpenGLTexture.setWrapMode(self,direction:PySide2.QtGui.QOpenGLTexture.CoordinateDirection,mode:PySide2.QtGui.QOpenGLTexture.WrapMode)",
    "0:PySide2.QtGui.QOpenGLTexture.setWrapMode(self,mode:PySide2.QtGui.QOpenGLTexture.WrapMode)",
    "PySide2.QtGui.QOpenGLTexture.swizzleMask(self,component:PySide2.QtGui.QOpenGLTexture.SwizzleComponent)->PySide2.QtGui.QOpenGLTexture.SwizzleValue",
    "PySide2.QtGui.QOpenGLTexture.target(self)->PySide2.QtGui.QOpenGLTexture.Target",
    "PySide2.QtGui.QOpenGLTexture.textureId(self)->unsigned int",
    "PySide2.QtGui.QOpenGLTexture.width(self)->int",
    "PySide2.QtGui.QOpenGLTexture.wrapMode(self,direction:PySide2.QtGui.QOpenGLTexture.CoordinateDirection)->PySide2.QtGui.QOpenGLTexture.WrapMode",
    nullptr}; // Sentinel

void init_QOpenGLTexture(PyObject *module)
{
    _Sbk_QOpenGLTexture_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLTexture",
        "QOpenGLTexture*",
        &Sbk_QOpenGLTexture_spec,
        &Shiboken::callCppDestructor< ::QOpenGLTexture >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLTexture_Type);
    InitSignatureStrings(pyType, QOpenGLTexture_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLTexture_Type), Sbk_QOpenGLTexture_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLTexture_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLTexture_TypeF(),
        QOpenGLTexture_PythonToCpp_QOpenGLTexture_PTR,
        is_QOpenGLTexture_PythonToCpp_QOpenGLTexture_PTR_Convertible,
        QOpenGLTexture_PTR_CppToPython_QOpenGLTexture);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLTexture).name());


    // Initialization of enums.

    // Initialization of enum 'Target'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "Target",
        "2:PySide2.QtGui.QOpenGLTexture.Target",
        "QOpenGLTexture::Target");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Target1D", (long) QOpenGLTexture::Target::Target1D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Target1DArray", (long) QOpenGLTexture::Target::Target1DArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Target2D", (long) QOpenGLTexture::Target::Target2D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Target2DArray", (long) QOpenGLTexture::Target::Target2DArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Target3D", (long) QOpenGLTexture::Target::Target3D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "TargetCubeMap", (long) QOpenGLTexture::Target::TargetCubeMap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "TargetCubeMapArray", (long) QOpenGLTexture::Target::TargetCubeMapArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Target2DMultisample", (long) QOpenGLTexture::Target::Target2DMultisample))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Target2DMultisampleArray", (long) QOpenGLTexture::Target::Target2DMultisampleArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "TargetRectangle", (long) QOpenGLTexture::Target::TargetRectangle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "TargetBuffer", (long) QOpenGLTexture::Target::TargetBuffer))
        return;
    // Register converter for enum 'QOpenGLTexture::Target'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX],
            QOpenGLTexture_Target_CppToPython_QOpenGLTexture_Target);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_Target_PythonToCpp_QOpenGLTexture_Target,
            is_QOpenGLTexture_Target_PythonToCpp_QOpenGLTexture_Target_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::Target");
        Shiboken::Conversions::registerConverterName(converter, "Target");
    }
    // End of 'Target' enum.

    // Initialization of enum 'BindingTarget'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "BindingTarget",
        "2:PySide2.QtGui.QOpenGLTexture.BindingTarget",
        "QOpenGLTexture::BindingTarget");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BindingTarget1D", (long) QOpenGLTexture::BindingTarget::BindingTarget1D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BindingTarget1DArray", (long) QOpenGLTexture::BindingTarget::BindingTarget1DArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BindingTarget2D", (long) QOpenGLTexture::BindingTarget::BindingTarget2D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BindingTarget2DArray", (long) QOpenGLTexture::BindingTarget::BindingTarget2DArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BindingTarget3D", (long) QOpenGLTexture::BindingTarget::BindingTarget3D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BindingTargetCubeMap", (long) QOpenGLTexture::BindingTarget::BindingTargetCubeMap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BindingTargetCubeMapArray", (long) QOpenGLTexture::BindingTarget::BindingTargetCubeMapArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BindingTarget2DMultisample", (long) QOpenGLTexture::BindingTarget::BindingTarget2DMultisample))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BindingTarget2DMultisampleArray", (long) QOpenGLTexture::BindingTarget::BindingTarget2DMultisampleArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BindingTargetRectangle", (long) QOpenGLTexture::BindingTarget::BindingTargetRectangle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BindingTargetBuffer", (long) QOpenGLTexture::BindingTarget::BindingTargetBuffer))
        return;
    // Register converter for enum 'QOpenGLTexture::BindingTarget'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX],
            QOpenGLTexture_BindingTarget_CppToPython_QOpenGLTexture_BindingTarget);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_BindingTarget_PythonToCpp_QOpenGLTexture_BindingTarget,
            is_QOpenGLTexture_BindingTarget_PythonToCpp_QOpenGLTexture_BindingTarget_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_BINDINGTARGET_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::BindingTarget");
        Shiboken::Conversions::registerConverterName(converter, "BindingTarget");
    }
    // End of 'BindingTarget' enum.

    // Initialization of enum 'MipMapGeneration'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_MIPMAPGENERATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "MipMapGeneration",
        "2:PySide2.QtGui.QOpenGLTexture.MipMapGeneration",
        "QOpenGLTexture::MipMapGeneration");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_MIPMAPGENERATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_MIPMAPGENERATION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "GenerateMipMaps", (long) QOpenGLTexture::MipMapGeneration::GenerateMipMaps))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_MIPMAPGENERATION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "DontGenerateMipMaps", (long) QOpenGLTexture::MipMapGeneration::DontGenerateMipMaps))
        return;
    // Register converter for enum 'QOpenGLTexture::MipMapGeneration'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_MIPMAPGENERATION_IDX],
            QOpenGLTexture_MipMapGeneration_CppToPython_QOpenGLTexture_MipMapGeneration);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_MipMapGeneration_PythonToCpp_QOpenGLTexture_MipMapGeneration,
            is_QOpenGLTexture_MipMapGeneration_PythonToCpp_QOpenGLTexture_MipMapGeneration_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_MIPMAPGENERATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::MipMapGeneration");
        Shiboken::Conversions::registerConverterName(converter, "MipMapGeneration");
    }
    // End of 'MipMapGeneration' enum.

    // Initialization of enum 'TextureUnitReset'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREUNITRESET_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "TextureUnitReset",
        "2:PySide2.QtGui.QOpenGLTexture.TextureUnitReset",
        "QOpenGLTexture::TextureUnitReset");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREUNITRESET_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREUNITRESET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "ResetTextureUnit", (long) QOpenGLTexture::TextureUnitReset::ResetTextureUnit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREUNITRESET_IDX],
        Sbk_QOpenGLTexture_TypeF(), "DontResetTextureUnit", (long) QOpenGLTexture::TextureUnitReset::DontResetTextureUnit))
        return;
    // Register converter for enum 'QOpenGLTexture::TextureUnitReset'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREUNITRESET_IDX],
            QOpenGLTexture_TextureUnitReset_CppToPython_QOpenGLTexture_TextureUnitReset);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_TextureUnitReset_PythonToCpp_QOpenGLTexture_TextureUnitReset,
            is_QOpenGLTexture_TextureUnitReset_PythonToCpp_QOpenGLTexture_TextureUnitReset_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREUNITRESET_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::TextureUnitReset");
        Shiboken::Conversions::registerConverterName(converter, "TextureUnitReset");
    }
    // End of 'TextureUnitReset' enum.

    // Initialization of enum 'TextureFormat'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "TextureFormat",
        "2:PySide2.QtGui.QOpenGLTexture.TextureFormat",
        "QOpenGLTexture::TextureFormat");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "NoFormat", (long) QOpenGLTexture::TextureFormat::NoFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R8_UNorm", (long) QOpenGLTexture::TextureFormat::R8_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG8_UNorm", (long) QOpenGLTexture::TextureFormat::RG8_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB8_UNorm", (long) QOpenGLTexture::TextureFormat::RGB8_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA8_UNorm", (long) QOpenGLTexture::TextureFormat::RGBA8_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R16_UNorm", (long) QOpenGLTexture::TextureFormat::R16_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG16_UNorm", (long) QOpenGLTexture::TextureFormat::RG16_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB16_UNorm", (long) QOpenGLTexture::TextureFormat::RGB16_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA16_UNorm", (long) QOpenGLTexture::TextureFormat::RGBA16_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R8_SNorm", (long) QOpenGLTexture::TextureFormat::R8_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG8_SNorm", (long) QOpenGLTexture::TextureFormat::RG8_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB8_SNorm", (long) QOpenGLTexture::TextureFormat::RGB8_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA8_SNorm", (long) QOpenGLTexture::TextureFormat::RGBA8_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R16_SNorm", (long) QOpenGLTexture::TextureFormat::R16_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG16_SNorm", (long) QOpenGLTexture::TextureFormat::RG16_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB16_SNorm", (long) QOpenGLTexture::TextureFormat::RGB16_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA16_SNorm", (long) QOpenGLTexture::TextureFormat::RGBA16_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R8U", (long) QOpenGLTexture::TextureFormat::R8U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG8U", (long) QOpenGLTexture::TextureFormat::RG8U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB8U", (long) QOpenGLTexture::TextureFormat::RGB8U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA8U", (long) QOpenGLTexture::TextureFormat::RGBA8U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R16U", (long) QOpenGLTexture::TextureFormat::R16U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG16U", (long) QOpenGLTexture::TextureFormat::RG16U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB16U", (long) QOpenGLTexture::TextureFormat::RGB16U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA16U", (long) QOpenGLTexture::TextureFormat::RGBA16U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R32U", (long) QOpenGLTexture::TextureFormat::R32U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG32U", (long) QOpenGLTexture::TextureFormat::RG32U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB32U", (long) QOpenGLTexture::TextureFormat::RGB32U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA32U", (long) QOpenGLTexture::TextureFormat::RGBA32U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R8I", (long) QOpenGLTexture::TextureFormat::R8I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG8I", (long) QOpenGLTexture::TextureFormat::RG8I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB8I", (long) QOpenGLTexture::TextureFormat::RGB8I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA8I", (long) QOpenGLTexture::TextureFormat::RGBA8I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R16I", (long) QOpenGLTexture::TextureFormat::R16I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG16I", (long) QOpenGLTexture::TextureFormat::RG16I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB16I", (long) QOpenGLTexture::TextureFormat::RGB16I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA16I", (long) QOpenGLTexture::TextureFormat::RGBA16I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R32I", (long) QOpenGLTexture::TextureFormat::R32I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG32I", (long) QOpenGLTexture::TextureFormat::RG32I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB32I", (long) QOpenGLTexture::TextureFormat::RGB32I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA32I", (long) QOpenGLTexture::TextureFormat::RGBA32I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R16F", (long) QOpenGLTexture::TextureFormat::R16F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG16F", (long) QOpenGLTexture::TextureFormat::RG16F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB16F", (long) QOpenGLTexture::TextureFormat::RGB16F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA16F", (long) QOpenGLTexture::TextureFormat::RGBA16F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R32F", (long) QOpenGLTexture::TextureFormat::R32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG32F", (long) QOpenGLTexture::TextureFormat::RG32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB32F", (long) QOpenGLTexture::TextureFormat::RGB32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA32F", (long) QOpenGLTexture::TextureFormat::RGBA32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB9E5", (long) QOpenGLTexture::TextureFormat::RGB9E5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG11B10F", (long) QOpenGLTexture::TextureFormat::RG11B10F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG3B2", (long) QOpenGLTexture::TextureFormat::RG3B2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R5G6B5", (long) QOpenGLTexture::TextureFormat::R5G6B5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB5A1", (long) QOpenGLTexture::TextureFormat::RGB5A1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA4", (long) QOpenGLTexture::TextureFormat::RGBA4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB10A2", (long) QOpenGLTexture::TextureFormat::RGB10A2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "D16", (long) QOpenGLTexture::TextureFormat::D16))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "D24", (long) QOpenGLTexture::TextureFormat::D24))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "D24S8", (long) QOpenGLTexture::TextureFormat::D24S8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "D32", (long) QOpenGLTexture::TextureFormat::D32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "D32F", (long) QOpenGLTexture::TextureFormat::D32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "D32FS8X24", (long) QOpenGLTexture::TextureFormat::D32FS8X24))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "S8", (long) QOpenGLTexture::TextureFormat::S8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB_DXT1", (long) QOpenGLTexture::TextureFormat::RGB_DXT1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_DXT1", (long) QOpenGLTexture::TextureFormat::RGBA_DXT1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_DXT3", (long) QOpenGLTexture::TextureFormat::RGBA_DXT3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_DXT5", (long) QOpenGLTexture::TextureFormat::RGBA_DXT5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R_ATI1N_UNorm", (long) QOpenGLTexture::TextureFormat::R_ATI1N_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R_ATI1N_SNorm", (long) QOpenGLTexture::TextureFormat::R_ATI1N_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG_ATI2N_UNorm", (long) QOpenGLTexture::TextureFormat::RG_ATI2N_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG_ATI2N_SNorm", (long) QOpenGLTexture::TextureFormat::RG_ATI2N_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB_BP_UNSIGNED_FLOAT", (long) QOpenGLTexture::TextureFormat::RGB_BP_UNSIGNED_FLOAT))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB_BP_SIGNED_FLOAT", (long) QOpenGLTexture::TextureFormat::RGB_BP_SIGNED_FLOAT))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB_BP_UNorm", (long) QOpenGLTexture::TextureFormat::RGB_BP_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R11_EAC_UNorm", (long) QOpenGLTexture::TextureFormat::R11_EAC_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "R11_EAC_SNorm", (long) QOpenGLTexture::TextureFormat::R11_EAC_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG11_EAC_UNorm", (long) QOpenGLTexture::TextureFormat::RG11_EAC_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG11_EAC_SNorm", (long) QOpenGLTexture::TextureFormat::RG11_EAC_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB8_ETC2", (long) QOpenGLTexture::TextureFormat::RGB8_ETC2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_ETC2", (long) QOpenGLTexture::TextureFormat::SRGB8_ETC2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB8_PunchThrough_Alpha1_ETC2", (long) QOpenGLTexture::TextureFormat::RGB8_PunchThrough_Alpha1_ETC2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_PunchThrough_Alpha1_ETC2", (long) QOpenGLTexture::TextureFormat::SRGB8_PunchThrough_Alpha1_ETC2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA8_ETC2_EAC", (long) QOpenGLTexture::TextureFormat::RGBA8_ETC2_EAC))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ETC2_EAC", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ETC2_EAC))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB8_ETC1", (long) QOpenGLTexture::TextureFormat::RGB8_ETC1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_4x4", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_4x4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_5x4", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_5x4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_5x5", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_5x5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_6x5", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_6x5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_6x6", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_6x6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_8x5", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_8x5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_8x6", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_8x6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_8x8", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_8x8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_10x5", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_10x5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_10x6", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_10x6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_10x8", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_10x8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_10x10", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_10x10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_12x10", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_12x10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_ASTC_12x12", (long) QOpenGLTexture::TextureFormat::RGBA_ASTC_12x12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_4x4", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_4x4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_5x4", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_5x4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_5x5", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_5x5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_6x5", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_6x5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_6x6", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_6x6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_8x5", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_8x5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_8x6", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_8x6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_8x8", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_8x8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_10x5", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_10x5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_10x6", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_10x6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_10x8", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_10x8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_10x10", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_10x10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_12x10", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_12x10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8_ASTC_12x12", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8_ASTC_12x12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8", (long) QOpenGLTexture::TextureFormat::SRGB8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB8_Alpha8", (long) QOpenGLTexture::TextureFormat::SRGB8_Alpha8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB_DXT1", (long) QOpenGLTexture::TextureFormat::SRGB_DXT1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB_Alpha_DXT1", (long) QOpenGLTexture::TextureFormat::SRGB_Alpha_DXT1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB_Alpha_DXT3", (long) QOpenGLTexture::TextureFormat::SRGB_Alpha_DXT3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB_Alpha_DXT5", (long) QOpenGLTexture::TextureFormat::SRGB_Alpha_DXT5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SRGB_BP_UNorm", (long) QOpenGLTexture::TextureFormat::SRGB_BP_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "DepthFormat", (long) QOpenGLTexture::TextureFormat::DepthFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "AlphaFormat", (long) QOpenGLTexture::TextureFormat::AlphaFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBFormat", (long) QOpenGLTexture::TextureFormat::RGBFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBAFormat", (long) QOpenGLTexture::TextureFormat::RGBAFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "LuminanceFormat", (long) QOpenGLTexture::TextureFormat::LuminanceFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "LuminanceAlphaFormat", (long) QOpenGLTexture::TextureFormat::LuminanceAlphaFormat))
        return;
    // Register converter for enum 'QOpenGLTexture::TextureFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX],
            QOpenGLTexture_TextureFormat_CppToPython_QOpenGLTexture_TextureFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_TextureFormat_PythonToCpp_QOpenGLTexture_TextureFormat,
            is_QOpenGLTexture_TextureFormat_PythonToCpp_QOpenGLTexture_TextureFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::TextureFormat");
        Shiboken::Conversions::registerConverterName(converter, "TextureFormat");
    }
    // End of 'TextureFormat' enum.

    // Initialization of enum 'TextureFormatClass'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "TextureFormatClass",
        "2:PySide2.QtGui.QOpenGLTexture.TextureFormatClass",
        "QOpenGLTexture::TextureFormatClass");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "NoFormatClass", (long) QOpenGLTexture::TextureFormatClass::NoFormatClass))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_128Bit", (long) QOpenGLTexture::TextureFormatClass::FormatClass_128Bit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_96Bit", (long) QOpenGLTexture::TextureFormatClass::FormatClass_96Bit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_64Bit", (long) QOpenGLTexture::TextureFormatClass::FormatClass_64Bit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_48Bit", (long) QOpenGLTexture::TextureFormatClass::FormatClass_48Bit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_32Bit", (long) QOpenGLTexture::TextureFormatClass::FormatClass_32Bit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_24Bit", (long) QOpenGLTexture::TextureFormatClass::FormatClass_24Bit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_16Bit", (long) QOpenGLTexture::TextureFormatClass::FormatClass_16Bit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_8Bit", (long) QOpenGLTexture::TextureFormatClass::FormatClass_8Bit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_RGTC1_R", (long) QOpenGLTexture::TextureFormatClass::FormatClass_RGTC1_R))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_RGTC2_RG", (long) QOpenGLTexture::TextureFormatClass::FormatClass_RGTC2_RG))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_BPTC_Unorm", (long) QOpenGLTexture::TextureFormatClass::FormatClass_BPTC_Unorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_BPTC_Float", (long) QOpenGLTexture::TextureFormatClass::FormatClass_BPTC_Float))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_S3TC_DXT1_RGB", (long) QOpenGLTexture::TextureFormatClass::FormatClass_S3TC_DXT1_RGB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_S3TC_DXT1_RGBA", (long) QOpenGLTexture::TextureFormatClass::FormatClass_S3TC_DXT1_RGBA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_S3TC_DXT3_RGBA", (long) QOpenGLTexture::TextureFormatClass::FormatClass_S3TC_DXT3_RGBA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_S3TC_DXT5_RGBA", (long) QOpenGLTexture::TextureFormatClass::FormatClass_S3TC_DXT5_RGBA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
        Sbk_QOpenGLTexture_TypeF(), "FormatClass_Unique", (long) QOpenGLTexture::TextureFormatClass::FormatClass_Unique))
        return;
    // Register converter for enum 'QOpenGLTexture::TextureFormatClass'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX],
            QOpenGLTexture_TextureFormatClass_CppToPython_QOpenGLTexture_TextureFormatClass);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_TextureFormatClass_PythonToCpp_QOpenGLTexture_TextureFormatClass,
            is_QOpenGLTexture_TextureFormatClass_PythonToCpp_QOpenGLTexture_TextureFormatClass_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMATCLASS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::TextureFormatClass");
        Shiboken::Conversions::registerConverterName(converter, "TextureFormatClass");
    }
    // End of 'TextureFormatClass' enum.

    // Initialization of enum 'CubeMapFace'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "CubeMapFace",
        "2:PySide2.QtGui.QOpenGLTexture.CubeMapFace",
        "QOpenGLTexture::CubeMapFace");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CubeMapPositiveX", (long) QOpenGLTexture::CubeMapFace::CubeMapPositiveX))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CubeMapNegativeX", (long) QOpenGLTexture::CubeMapFace::CubeMapNegativeX))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CubeMapPositiveY", (long) QOpenGLTexture::CubeMapFace::CubeMapPositiveY))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CubeMapNegativeY", (long) QOpenGLTexture::CubeMapFace::CubeMapNegativeY))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CubeMapPositiveZ", (long) QOpenGLTexture::CubeMapFace::CubeMapPositiveZ))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CubeMapNegativeZ", (long) QOpenGLTexture::CubeMapFace::CubeMapNegativeZ))
        return;
    // Register converter for enum 'QOpenGLTexture::CubeMapFace'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX],
            QOpenGLTexture_CubeMapFace_CppToPython_QOpenGLTexture_CubeMapFace);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_CubeMapFace_PythonToCpp_QOpenGLTexture_CubeMapFace,
            is_QOpenGLTexture_CubeMapFace_PythonToCpp_QOpenGLTexture_CubeMapFace_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_CUBEMAPFACE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::CubeMapFace");
        Shiboken::Conversions::registerConverterName(converter, "CubeMapFace");
    }
    // End of 'CubeMapFace' enum.

    // Initialization of enum 'PixelFormat'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "PixelFormat",
        "2:PySide2.QtGui.QOpenGLTexture.PixelFormat",
        "QOpenGLTexture::PixelFormat");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "NoSourceFormat", (long) QOpenGLTexture::PixelFormat::NoSourceFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Red", (long) QOpenGLTexture::PixelFormat::Red))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG", (long) QOpenGLTexture::PixelFormat::RG))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB", (long) QOpenGLTexture::PixelFormat::RGB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BGR", (long) QOpenGLTexture::PixelFormat::BGR))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA", (long) QOpenGLTexture::PixelFormat::RGBA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BGRA", (long) QOpenGLTexture::PixelFormat::BGRA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Red_Integer", (long) QOpenGLTexture::PixelFormat::Red_Integer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RG_Integer", (long) QOpenGLTexture::PixelFormat::RG_Integer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGB_Integer", (long) QOpenGLTexture::PixelFormat::RGB_Integer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BGR_Integer", (long) QOpenGLTexture::PixelFormat::BGR_Integer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RGBA_Integer", (long) QOpenGLTexture::PixelFormat::RGBA_Integer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BGRA_Integer", (long) QOpenGLTexture::PixelFormat::BGRA_Integer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Stencil", (long) QOpenGLTexture::PixelFormat::Stencil))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Depth", (long) QOpenGLTexture::PixelFormat::Depth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "DepthStencil", (long) QOpenGLTexture::PixelFormat::DepthStencil))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Alpha", (long) QOpenGLTexture::PixelFormat::Alpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Luminance", (long) QOpenGLTexture::PixelFormat::Luminance))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "LuminanceAlpha", (long) QOpenGLTexture::PixelFormat::LuminanceAlpha))
        return;
    // Register converter for enum 'QOpenGLTexture::PixelFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX],
            QOpenGLTexture_PixelFormat_CppToPython_QOpenGLTexture_PixelFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_PixelFormat_PythonToCpp_QOpenGLTexture_PixelFormat,
            is_QOpenGLTexture_PixelFormat_PythonToCpp_QOpenGLTexture_PixelFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::PixelFormat");
        Shiboken::Conversions::registerConverterName(converter, "PixelFormat");
    }
    // End of 'PixelFormat' enum.

    // Initialization of enum 'PixelType'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "PixelType",
        "2:PySide2.QtGui.QOpenGLTexture.PixelType",
        "QOpenGLTexture::PixelType");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "NoPixelType", (long) QOpenGLTexture::PixelType::NoPixelType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Int8", (long) QOpenGLTexture::PixelType::Int8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt8", (long) QOpenGLTexture::PixelType::UInt8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Int16", (long) QOpenGLTexture::PixelType::Int16))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt16", (long) QOpenGLTexture::PixelType::UInt16))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Int32", (long) QOpenGLTexture::PixelType::Int32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt32", (long) QOpenGLTexture::PixelType::UInt32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Float16", (long) QOpenGLTexture::PixelType::Float16))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Float16OES", (long) QOpenGLTexture::PixelType::Float16OES))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Float32", (long) QOpenGLTexture::PixelType::Float32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt32_RGB9_E5", (long) QOpenGLTexture::PixelType::UInt32_RGB9_E5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt32_RG11B10F", (long) QOpenGLTexture::PixelType::UInt32_RG11B10F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt8_RG3B2", (long) QOpenGLTexture::PixelType::UInt8_RG3B2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt8_RG3B2_Rev", (long) QOpenGLTexture::PixelType::UInt8_RG3B2_Rev))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt16_RGB5A1", (long) QOpenGLTexture::PixelType::UInt16_RGB5A1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt16_RGB5A1_Rev", (long) QOpenGLTexture::PixelType::UInt16_RGB5A1_Rev))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt16_R5G6B5", (long) QOpenGLTexture::PixelType::UInt16_R5G6B5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt16_R5G6B5_Rev", (long) QOpenGLTexture::PixelType::UInt16_R5G6B5_Rev))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt16_RGBA4", (long) QOpenGLTexture::PixelType::UInt16_RGBA4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt16_RGBA4_Rev", (long) QOpenGLTexture::PixelType::UInt16_RGBA4_Rev))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt32_RGBA8", (long) QOpenGLTexture::PixelType::UInt32_RGBA8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt32_RGBA8_Rev", (long) QOpenGLTexture::PixelType::UInt32_RGBA8_Rev))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt32_RGB10A2", (long) QOpenGLTexture::PixelType::UInt32_RGB10A2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt32_RGB10A2_Rev", (long) QOpenGLTexture::PixelType::UInt32_RGB10A2_Rev))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "UInt32_D24S8", (long) QOpenGLTexture::PixelType::UInt32_D24S8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Float32_D32_UInt32_S8_X24", (long) QOpenGLTexture::PixelType::Float32_D32_UInt32_S8_X24))
        return;
    // Register converter for enum 'QOpenGLTexture::PixelType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX],
            QOpenGLTexture_PixelType_CppToPython_QOpenGLTexture_PixelType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_PixelType_PythonToCpp_QOpenGLTexture_PixelType,
            is_QOpenGLTexture_PixelType_PythonToCpp_QOpenGLTexture_PixelType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::PixelType");
        Shiboken::Conversions::registerConverterName(converter, "PixelType");
    }
    // End of 'PixelType' enum.

    // Initialization of enum 'SwizzleComponent'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLECOMPONENT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "SwizzleComponent",
        "2:PySide2.QtGui.QOpenGLTexture.SwizzleComponent",
        "QOpenGLTexture::SwizzleComponent");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLECOMPONENT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLECOMPONENT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SwizzleRed", (long) QOpenGLTexture::SwizzleComponent::SwizzleRed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLECOMPONENT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SwizzleGreen", (long) QOpenGLTexture::SwizzleComponent::SwizzleGreen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLECOMPONENT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SwizzleBlue", (long) QOpenGLTexture::SwizzleComponent::SwizzleBlue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLECOMPONENT_IDX],
        Sbk_QOpenGLTexture_TypeF(), "SwizzleAlpha", (long) QOpenGLTexture::SwizzleComponent::SwizzleAlpha))
        return;
    // Register converter for enum 'QOpenGLTexture::SwizzleComponent'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLECOMPONENT_IDX],
            QOpenGLTexture_SwizzleComponent_CppToPython_QOpenGLTexture_SwizzleComponent);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_SwizzleComponent_PythonToCpp_QOpenGLTexture_SwizzleComponent,
            is_QOpenGLTexture_SwizzleComponent_PythonToCpp_QOpenGLTexture_SwizzleComponent_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLECOMPONENT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::SwizzleComponent");
        Shiboken::Conversions::registerConverterName(converter, "SwizzleComponent");
    }
    // End of 'SwizzleComponent' enum.

    // Initialization of enum 'SwizzleValue'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "SwizzleValue",
        "2:PySide2.QtGui.QOpenGLTexture.SwizzleValue",
        "QOpenGLTexture::SwizzleValue");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "RedValue", (long) QOpenGLTexture::SwizzleValue::RedValue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "GreenValue", (long) QOpenGLTexture::SwizzleValue::GreenValue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "BlueValue", (long) QOpenGLTexture::SwizzleValue::BlueValue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "AlphaValue", (long) QOpenGLTexture::SwizzleValue::AlphaValue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "ZeroValue", (long) QOpenGLTexture::SwizzleValue::ZeroValue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "OneValue", (long) QOpenGLTexture::SwizzleValue::OneValue))
        return;
    // Register converter for enum 'QOpenGLTexture::SwizzleValue'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX],
            QOpenGLTexture_SwizzleValue_CppToPython_QOpenGLTexture_SwizzleValue);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_SwizzleValue_PythonToCpp_QOpenGLTexture_SwizzleValue,
            is_QOpenGLTexture_SwizzleValue_PythonToCpp_QOpenGLTexture_SwizzleValue_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_SWIZZLEVALUE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::SwizzleValue");
        Shiboken::Conversions::registerConverterName(converter, "SwizzleValue");
    }
    // End of 'SwizzleValue' enum.

    // Initialization of enum 'WrapMode'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "WrapMode",
        "2:PySide2.QtGui.QOpenGLTexture.WrapMode",
        "QOpenGLTexture::WrapMode");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Repeat", (long) QOpenGLTexture::WrapMode::Repeat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "MirroredRepeat", (long) QOpenGLTexture::WrapMode::MirroredRepeat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "ClampToEdge", (long) QOpenGLTexture::WrapMode::ClampToEdge))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "ClampToBorder", (long) QOpenGLTexture::WrapMode::ClampToBorder))
        return;
    // Register converter for enum 'QOpenGLTexture::WrapMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX],
            QOpenGLTexture_WrapMode_CppToPython_QOpenGLTexture_WrapMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_WrapMode_PythonToCpp_QOpenGLTexture_WrapMode,
            is_QOpenGLTexture_WrapMode_PythonToCpp_QOpenGLTexture_WrapMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_WRAPMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::WrapMode");
        Shiboken::Conversions::registerConverterName(converter, "WrapMode");
    }
    // End of 'WrapMode' enum.

    // Initialization of enum 'CoordinateDirection'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COORDINATEDIRECTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "CoordinateDirection",
        "2:PySide2.QtGui.QOpenGLTexture.CoordinateDirection",
        "QOpenGLTexture::CoordinateDirection");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COORDINATEDIRECTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COORDINATEDIRECTION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "DirectionS", (long) QOpenGLTexture::CoordinateDirection::DirectionS))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COORDINATEDIRECTION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "DirectionT", (long) QOpenGLTexture::CoordinateDirection::DirectionT))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COORDINATEDIRECTION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "DirectionR", (long) QOpenGLTexture::CoordinateDirection::DirectionR))
        return;
    // Register converter for enum 'QOpenGLTexture::CoordinateDirection'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COORDINATEDIRECTION_IDX],
            QOpenGLTexture_CoordinateDirection_CppToPython_QOpenGLTexture_CoordinateDirection);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_CoordinateDirection_PythonToCpp_QOpenGLTexture_CoordinateDirection,
            is_QOpenGLTexture_CoordinateDirection_PythonToCpp_QOpenGLTexture_CoordinateDirection_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COORDINATEDIRECTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::CoordinateDirection");
        Shiboken::Conversions::registerConverterName(converter, "CoordinateDirection");
    }
    // End of 'CoordinateDirection' enum.

    // Initialization of enum 'Feature'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QOpenGLTexture.Features", SbkPySide2_QtGui_QOpenGLTexture_Feature_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "Feature",
        "2:PySide2.QtGui.QOpenGLTexture.Feature",
        "QOpenGLTexture::Feature",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "ImmutableStorage", (long) QOpenGLTexture::Feature::ImmutableStorage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "ImmutableMultisampleStorage", (long) QOpenGLTexture::Feature::ImmutableMultisampleStorage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "TextureRectangle", (long) QOpenGLTexture::Feature::TextureRectangle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "TextureArrays", (long) QOpenGLTexture::Feature::TextureArrays))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Texture3D", (long) QOpenGLTexture::Feature::Texture3D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "TextureMultisample", (long) QOpenGLTexture::Feature::TextureMultisample))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "TextureBuffer", (long) QOpenGLTexture::Feature::TextureBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "TextureCubeMapArrays", (long) QOpenGLTexture::Feature::TextureCubeMapArrays))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Swizzle", (long) QOpenGLTexture::Feature::Swizzle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "StencilTexturing", (long) QOpenGLTexture::Feature::StencilTexturing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "AnisotropicFiltering", (long) QOpenGLTexture::Feature::AnisotropicFiltering))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "NPOTTextures", (long) QOpenGLTexture::Feature::NPOTTextures))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "NPOTTextureRepeat", (long) QOpenGLTexture::Feature::NPOTTextureRepeat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Texture1D", (long) QOpenGLTexture::Feature::Texture1D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "TextureComparisonOperators", (long) QOpenGLTexture::Feature::TextureComparisonOperators))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "TextureMipMapLevel", (long) QOpenGLTexture::Feature::TextureMipMapLevel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "MaxFeatureFlag", (long) QOpenGLTexture::Feature::MaxFeatureFlag))
        return;
    // Register converter for enum 'QOpenGLTexture::Feature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX],
            QOpenGLTexture_Feature_CppToPython_QOpenGLTexture_Feature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_Feature_PythonToCpp_QOpenGLTexture_Feature,
            is_QOpenGLTexture_Feature_PythonToCpp_QOpenGLTexture_Feature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::Feature");
        Shiboken::Conversions::registerConverterName(converter, "Feature");
    }
    // Register converter for flag 'QFlags<QOpenGLTexture::Feature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX],
            QFlags_QOpenGLTexture_Feature__CppToPython_QFlags_QOpenGLTexture_Feature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_Feature_PythonToCpp_QFlags_QOpenGLTexture_Feature_,
            is_QOpenGLTexture_Feature_PythonToCpp_QFlags_QOpenGLTexture_Feature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QOpenGLTexture_Feature__PythonToCpp_QFlags_QOpenGLTexture_Feature_,
            is_QFlags_QOpenGLTexture_Feature__PythonToCpp_QFlags_QOpenGLTexture_Feature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QOpenGLTexture_Feature_,
            is_number_PythonToCpp_QFlags_QOpenGLTexture_Feature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLTEXTURE_FEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::Features");
        Shiboken::Conversions::registerConverterName(converter, "Features");
    }
    // End of 'Feature' enum/flags.

    // Initialization of enum 'DepthStencilMode'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_DEPTHSTENCILMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "DepthStencilMode",
        "2:PySide2.QtGui.QOpenGLTexture.DepthStencilMode",
        "QOpenGLTexture::DepthStencilMode");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_DEPTHSTENCILMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_DEPTHSTENCILMODE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "DepthMode", (long) QOpenGLTexture::DepthStencilMode::DepthMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_DEPTHSTENCILMODE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "StencilMode", (long) QOpenGLTexture::DepthStencilMode::StencilMode))
        return;
    // Register converter for enum 'QOpenGLTexture::DepthStencilMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_DEPTHSTENCILMODE_IDX],
            QOpenGLTexture_DepthStencilMode_CppToPython_QOpenGLTexture_DepthStencilMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_DepthStencilMode_PythonToCpp_QOpenGLTexture_DepthStencilMode,
            is_QOpenGLTexture_DepthStencilMode_PythonToCpp_QOpenGLTexture_DepthStencilMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_DEPTHSTENCILMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::DepthStencilMode");
        Shiboken::Conversions::registerConverterName(converter, "DepthStencilMode");
    }
    // End of 'DepthStencilMode' enum.

    // Initialization of enum 'ComparisonFunction'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "ComparisonFunction",
        "2:PySide2.QtGui.QOpenGLTexture.ComparisonFunction",
        "QOpenGLTexture::ComparisonFunction");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CompareLessEqual", (long) QOpenGLTexture::ComparisonFunction::CompareLessEqual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CompareGreaterEqual", (long) QOpenGLTexture::ComparisonFunction::CompareGreaterEqual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CompareLess", (long) QOpenGLTexture::ComparisonFunction::CompareLess))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CompareGreater", (long) QOpenGLTexture::ComparisonFunction::CompareGreater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CompareEqual", (long) QOpenGLTexture::ComparisonFunction::CompareEqual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CommpareNotEqual", (long) QOpenGLTexture::ComparisonFunction::CommpareNotEqual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CompareAlways", (long) QOpenGLTexture::ComparisonFunction::CompareAlways))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CompareNever", (long) QOpenGLTexture::ComparisonFunction::CompareNever))
        return;
    // Register converter for enum 'QOpenGLTexture::ComparisonFunction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX],
            QOpenGLTexture_ComparisonFunction_CppToPython_QOpenGLTexture_ComparisonFunction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_ComparisonFunction_PythonToCpp_QOpenGLTexture_ComparisonFunction,
            is_QOpenGLTexture_ComparisonFunction_PythonToCpp_QOpenGLTexture_ComparisonFunction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONFUNCTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::ComparisonFunction");
        Shiboken::Conversions::registerConverterName(converter, "ComparisonFunction");
    }
    // End of 'ComparisonFunction' enum.

    // Initialization of enum 'ComparisonMode'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "ComparisonMode",
        "2:PySide2.QtGui.QOpenGLTexture.ComparisonMode",
        "QOpenGLTexture::ComparisonMode");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONMODE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CompareRefToTexture", (long) QOpenGLTexture::ComparisonMode::CompareRefToTexture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONMODE_IDX],
        Sbk_QOpenGLTexture_TypeF(), "CompareNone", (long) QOpenGLTexture::ComparisonMode::CompareNone))
        return;
    // Register converter for enum 'QOpenGLTexture::ComparisonMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONMODE_IDX],
            QOpenGLTexture_ComparisonMode_CppToPython_QOpenGLTexture_ComparisonMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_ComparisonMode_PythonToCpp_QOpenGLTexture_ComparisonMode,
            is_QOpenGLTexture_ComparisonMode_PythonToCpp_QOpenGLTexture_ComparisonMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_COMPARISONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::ComparisonMode");
        Shiboken::Conversions::registerConverterName(converter, "ComparisonMode");
    }
    // End of 'ComparisonMode' enum.

    // Initialization of enum 'Filter'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTexture_TypeF(),
        "Filter",
        "2:PySide2.QtGui.QOpenGLTexture.Filter",
        "QOpenGLTexture::Filter");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Nearest", (long) QOpenGLTexture::Filter::Nearest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX],
        Sbk_QOpenGLTexture_TypeF(), "Linear", (long) QOpenGLTexture::Filter::Linear))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX],
        Sbk_QOpenGLTexture_TypeF(), "NearestMipMapNearest", (long) QOpenGLTexture::Filter::NearestMipMapNearest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX],
        Sbk_QOpenGLTexture_TypeF(), "NearestMipMapLinear", (long) QOpenGLTexture::Filter::NearestMipMapLinear))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX],
        Sbk_QOpenGLTexture_TypeF(), "LinearMipMapNearest", (long) QOpenGLTexture::Filter::LinearMipMapNearest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX],
        Sbk_QOpenGLTexture_TypeF(), "LinearMipMapLinear", (long) QOpenGLTexture::Filter::LinearMipMapLinear))
        return;
    // Register converter for enum 'QOpenGLTexture::Filter'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX],
            QOpenGLTexture_Filter_CppToPython_QOpenGLTexture_Filter);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTexture_Filter_PythonToCpp_QOpenGLTexture_Filter,
            is_QOpenGLTexture_Filter_PythonToCpp_QOpenGLTexture_Filter_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTexture::Filter");
        Shiboken::Conversions::registerConverterName(converter, "Filter");
    }
    // End of 'Filter' enum.

    qRegisterMetaType< ::QOpenGLTexture::Target >("QOpenGLTexture::Target");
    qRegisterMetaType< ::QOpenGLTexture::BindingTarget >("QOpenGLTexture::BindingTarget");
    qRegisterMetaType< ::QOpenGLTexture::MipMapGeneration >("QOpenGLTexture::MipMapGeneration");
    qRegisterMetaType< ::QOpenGLTexture::TextureUnitReset >("QOpenGLTexture::TextureUnitReset");
    qRegisterMetaType< ::QOpenGLTexture::TextureFormat >("QOpenGLTexture::TextureFormat");
    qRegisterMetaType< ::QOpenGLTexture::TextureFormatClass >("QOpenGLTexture::TextureFormatClass");
    qRegisterMetaType< ::QOpenGLTexture::CubeMapFace >("QOpenGLTexture::CubeMapFace");
    qRegisterMetaType< ::QOpenGLTexture::PixelFormat >("QOpenGLTexture::PixelFormat");
    qRegisterMetaType< ::QOpenGLTexture::PixelType >("QOpenGLTexture::PixelType");
    qRegisterMetaType< ::QOpenGLTexture::SwizzleComponent >("QOpenGLTexture::SwizzleComponent");
    qRegisterMetaType< ::QOpenGLTexture::SwizzleValue >("QOpenGLTexture::SwizzleValue");
    qRegisterMetaType< ::QOpenGLTexture::WrapMode >("QOpenGLTexture::WrapMode");
    qRegisterMetaType< ::QOpenGLTexture::CoordinateDirection >("QOpenGLTexture::CoordinateDirection");
    qRegisterMetaType< ::QOpenGLTexture::Feature >("QOpenGLTexture::Feature");
    qRegisterMetaType< ::QOpenGLTexture::Features >("QOpenGLTexture::Features");
    qRegisterMetaType< ::QOpenGLTexture::DepthStencilMode >("QOpenGLTexture::DepthStencilMode");
    qRegisterMetaType< ::QOpenGLTexture::ComparisonFunction >("QOpenGLTexture::ComparisonFunction");
    qRegisterMetaType< ::QOpenGLTexture::ComparisonMode >("QOpenGLTexture::ComparisonMode");
    qRegisterMetaType< ::QOpenGLTexture::Filter >("QOpenGLTexture::Filter");
}
