/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpagedpaintdevice_margins_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPagedPaintDevice_Margins_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPagedPaintDevice::Margins >()))
        return -1;

    ::QPagedPaintDevice::Margins *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.Margins.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "Margins", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: Margins::Margins()
    // 1: Margins::Margins(QPagedPaintDevice::Margins)
    if (numArgs == 0) {
        overloadId = 0; // Margins()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Margins(QPagedPaintDevice::Margins)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPagedPaintDevice_Margins_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // Margins()
        {

            if (!PyErr_Occurred()) {
                // Margins()
                cptr = new ::QPagedPaintDevice::Margins();
            }
            break;
        }
        case 1: // Margins(const QPagedPaintDevice::Margins & Margins)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPagedPaintDevice::Margins cppArg0_local;
            ::QPagedPaintDevice::Margins *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // Margins(QPagedPaintDevice::Margins)
                cptr = new ::QPagedPaintDevice::Margins(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPagedPaintDevice::Margins >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPagedPaintDevice_Margins_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPagedPaintDevice_Margins_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPagedPaintDevice_Margins___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPagedPaintDevice::Margins *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPagedPaintDevice_Margins_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPagedPaintDevice_Margins_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDevice_Margins___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QPagedPaintDevice_Margins_get_left(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice::Margins *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->left);
    return pyOut;
}
static int Sbk_QPagedPaintDevice_Margins_set_left(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice::Margins *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'left' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'left', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->left;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QPagedPaintDevice_Margins_get_right(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice::Margins *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->right);
    return pyOut;
}
static int Sbk_QPagedPaintDevice_Margins_set_right(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice::Margins *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'right' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'right', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->right;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QPagedPaintDevice_Margins_get_top(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice::Margins *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->top);
    return pyOut;
}
static int Sbk_QPagedPaintDevice_Margins_set_top(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice::Margins *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'top' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'top', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->top;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QPagedPaintDevice_Margins_get_bottom(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice::Margins *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->bottom);
    return pyOut;
}
static int Sbk_QPagedPaintDevice_Margins_set_bottom(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice::Margins *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'bottom' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'bottom', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->bottom;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for Margins
static PyGetSetDef Sbk_QPagedPaintDevice_Margins_getsetlist[] = {
    {const_cast<char *>("left"), Sbk_QPagedPaintDevice_Margins_get_left, Sbk_QPagedPaintDevice_Margins_set_left},
    {const_cast<char *>("right"), Sbk_QPagedPaintDevice_Margins_get_right, Sbk_QPagedPaintDevice_Margins_set_right},
    {const_cast<char *>("top"), Sbk_QPagedPaintDevice_Margins_get_top, Sbk_QPagedPaintDevice_Margins_set_top},
    {const_cast<char *>("bottom"), Sbk_QPagedPaintDevice_Margins_get_bottom, Sbk_QPagedPaintDevice_Margins_set_bottom},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QPagedPaintDevice_Margins_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPagedPaintDevice_Margins_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPagedPaintDevice_Margins_Type = nullptr;
static SbkObjectType *Sbk_QPagedPaintDevice_Margins_TypeF(void)
{
    return _Sbk_QPagedPaintDevice_Margins_Type;
}

static PyType_Slot Sbk_QPagedPaintDevice_Margins_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPagedPaintDevice_Margins_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPagedPaintDevice_Margins_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPagedPaintDevice_Margins_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QPagedPaintDevice_Margins_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPagedPaintDevice_Margins_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPagedPaintDevice_Margins_spec = {
    "2:PySide2.QtGui.QPagedPaintDevice.Margins",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPagedPaintDevice_Margins_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Margins_PythonToCpp_Margins_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPagedPaintDevice_Margins_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Margins_PythonToCpp_Margins_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPagedPaintDevice_Margins_TypeF())))
        return Margins_PythonToCpp_Margins_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Margins_PTR_CppToPython_Margins(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPagedPaintDevice::Margins *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPagedPaintDevice_Margins_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *Margins_COPY_CppToPython_Margins(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPagedPaintDevice_Margins_TypeF(), new ::QPagedPaintDevice::Margins(*reinterpret_cast<const ::QPagedPaintDevice::Margins *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void Margins_PythonToCpp_Margins_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPagedPaintDevice::Margins *>(cppOut) = *reinterpret_cast< ::QPagedPaintDevice::Margins *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_Margins_PythonToCpp_Margins_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPagedPaintDevice_Margins_TypeF())))
        return Margins_PythonToCpp_Margins_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPagedPaintDevice_Margins_SignatureStrings[] = {
    "1:PySide2.QtGui.QPagedPaintDevice.Margins(self)",
    "0:PySide2.QtGui.QPagedPaintDevice.Margins(self,Margins:PySide2.QtGui.QPagedPaintDevice.Margins)",
    "PySide2.QtGui.QPagedPaintDevice.Margins.__copy__()",
    nullptr}; // Sentinel

void init_QPagedPaintDevice_Margins(PyObject *enclosingClass)
{
    _Sbk_QPagedPaintDevice_Margins_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Margins",
        "QPagedPaintDevice::Margins",
        &Sbk_QPagedPaintDevice_Margins_spec,
        &Shiboken::callCppDestructor< ::QPagedPaintDevice::Margins >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPagedPaintDevice_Margins_Type);
    InitSignatureStrings(pyType, QPagedPaintDevice_Margins_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPagedPaintDevice_Margins_Type), Sbk_QPagedPaintDevice_Margins_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPagedPaintDevice_Margins_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPagedPaintDevice_Margins_TypeF(),
        Margins_PythonToCpp_Margins_PTR,
        is_Margins_PythonToCpp_Margins_PTR_Convertible,
        Margins_PTR_CppToPython_Margins,
        Margins_COPY_CppToPython_Margins);

    Shiboken::Conversions::registerConverterName(converter, "QPagedPaintDevice::Margins");
    Shiboken::Conversions::registerConverterName(converter, "QPagedPaintDevice::Margins*");
    Shiboken::Conversions::registerConverterName(converter, "QPagedPaintDevice::Margins&");
    Shiboken::Conversions::registerConverterName(converter, "Margins");
    Shiboken::Conversions::registerConverterName(converter, "Margins*");
    Shiboken::Conversions::registerConverterName(converter, "Margins&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPagedPaintDevice::Margins).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Margins_PythonToCpp_Margins_COPY,
        is_Margins_PythonToCpp_Margins_COPY_Convertible);

    qRegisterMetaType< ::QPagedPaintDevice::Margins >("Margins");
    qRegisterMetaType< ::QPagedPaintDevice::Margins >("QPagedPaintDevice::Margins");
}
