/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QPAGEDPAINTDEVICEWRAPPER_H
#define SBK_QPAGEDPAINTDEVICEWRAPPER_H

#define protected public

#include <QtGui/qpagedpaintdevice.h>


// Extra includes
#include <QtGui/qpagelayout.h>
#include <QtGui/qpagesize.h>
#include <qmargins.h>
#include <qsize.h>
#include <QtGui/qpagedpaintdevice.h>
#include <QtGui/qpaintengine.h>
#include <QtGui/qpaintdevice.h>
#include <qpoint.h>
#include <QtGui/qpainter.h>
class QPagedPaintDeviceWrapper : public QPagedPaintDevice
{
public:
    QPagedPaintDeviceWrapper();
    int devType() const override;
    void initPainter(::QPainter * painter) const override;
    int metric(::QPaintDevice::PaintDeviceMetric metric) const override;
    bool newPage() override;
    ::QPaintEngine * paintEngine() const override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void setMargins(const ::QPagedPaintDevice::Margins & margins) override;
    void setPageSize(::QPagedPaintDevice::PageSize size) override;
    void setPageSizeMM(const ::QSizeF & size) override;
    ::QPainter * sharedPainter() const override;
    ~QPagedPaintDeviceWrapper();
    // Inherited overloads, because the using keyword sux
    inline bool setPageSize(const ::QPageSize & pageSize) { return QPagedPaintDevice::setPageSize(pageSize); }
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[10];
};

#endif // SBK_QPAGEDPAINTDEVICEWRAPPER_H

