/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpixmap_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QPixmapWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QPixmapWrapper::QPixmapWrapper() : QPixmap()
{
    resetPyMethodCache();
    // ... middle
}

QPixmapWrapper::QPixmapWrapper(const ::QSize & arg__1) : QPixmap(arg__1)
{
    resetPyMethodCache();
    // ... middle
}

QPixmapWrapper::QPixmapWrapper(const ::QString & fileName, const char * format, ::QFlags<Qt::ImageConversionFlag> flags) : QPixmap(fileName, format, flags)
{
    resetPyMethodCache();
    // ... middle
}

QPixmapWrapper::QPixmapWrapper(const char *const xpm[]) : QPixmap(xpm)
{
    resetPyMethodCache();
    // ... middle
}

QPixmapWrapper::QPixmapWrapper(int w, int h) : QPixmap(w, h)
{
    resetPyMethodCache();
    // ... middle
}

int QPixmapWrapper::devType() const
{
    if (m_PyMethodCache[0])
        return this->::QPixmap::devType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "devType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QPixmap::devType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPixmap.devType", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPixmapWrapper::initPainter(::QPainter * painter) const
{
    if (m_PyMethodCache[1]) {
        return this->::QPaintDevice::initPainter(painter);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QPaintDevice::initPainter(painter);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

int QPixmapWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    if (m_PyMethodCache[2])
        return this->::QPixmap::metric(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "metric";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QPixmap::metric(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPixmap.metric", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintEngine * QPixmapWrapper::paintEngine() const
{
    if (m_PyMethodCache[3])
        return this->::QPixmap::paintEngine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QPixmap::paintEngine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPixmap.paintEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintDevice * QPixmapWrapper::redirected(::QPoint * offset) const
{
    if (m_PyMethodCache[4])
        return this->::QPaintDevice::redirected(offset);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "redirected";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QPaintDevice::redirected(offset);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), offset)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPixmap.redirected", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintDevice >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintDevice *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPainter * QPixmapWrapper::sharedPainter() const
{
    if (m_PyMethodCache[5])
        return this->::QPaintDevice::sharedPainter();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sharedPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QPaintDevice::sharedPainter();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPixmap.sharedPainter", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPainter >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPainter *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QPixmapWrapper::~QPixmapWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPixmap_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPixmap >()))
        return -1;

    ::QPixmapWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmap_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QPixmap", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QPixmap::QPixmap()
    // 1: QPixmap::QPixmap(QImage)
    // 2: QPixmap::QPixmap(QPixmap)
    // 3: QPixmap::QPixmap(QSize)
    // 4: QPixmap::QPixmap(QString,const char*,QFlags<Qt::ImageConversionFlag>)
    // 5: QPixmap::QPixmap(const char*const[])
    // 6: QPixmap::QPixmap(int,int)
    if (numArgs == 0) {
        overloadId = 0; // QPixmap()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 6; // QPixmap(int,int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 4; // QPixmap(QString,const char*,QFlags<Qt::ImageConversionFlag>)
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 4; // QPixmap(QString,const char*,QFlags<Qt::ImageConversionFlag>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 4; // QPixmap(QString,const char*,QFlags<Qt::ImageConversionFlag>)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QPixmap(QSize)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QPixmap(QImage)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QPixmap(QPixmap)
    } else if (numArgs == 1
        && Shiboken::String::checkIterable(pyArgs[0])) {
        overloadId = 5; // QPixmap(const char*const[])
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmap_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPixmap()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPixmap_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QPixmap()
                cptr = new ::QPixmapWrapper();
            }
            break;
        }
        case 1: // QPixmap(QImage image)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPixmap_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QImage cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // QPixmap(QImage)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qpixmap)]
                cptr = new QPixmapWrapper(QPixmap::fromImage(cppArg0));
                // END of custom code block [file: ../glue/qtgui.cpp (qpixmap)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 2: // QPixmap(const QPixmap & arg__1)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPixmap_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPixmap(QPixmap)
                cptr = new ::QPixmapWrapper(*cppArg0);
            }
            break;
        }
        case 3: // QPixmap(const QSize & arg__1)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPixmap_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPixmap(QSize)
                cptr = new ::QPixmapWrapper(*cppArg0);
            }
            break;
        }
        case 4: // QPixmap(const QString & fileName, const char * format, QFlags<Qt::ImageConversionFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmap_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QPixmap_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[2]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmap_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QPixmap_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmap_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::ImageConversionFlag> cppArg2 = Qt::AutoColor;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QPixmap(QString,const char*,QFlags<Qt::ImageConversionFlag>)
                cptr = new ::QPixmapWrapper(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 5: // QPixmap(const char*const[] xpm)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPixmap_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QPixmap(const char*const[])
                // Begin code injection
                // TEMPLATE - load_xpm - START
                Shiboken::AutoDecRef strList(PySequence_Fast(pyArgs[1-1], "Invalid sequence."));
                int lineCount = PySequence_Fast_GET_SIZE(strList.object());
                for (int line = 0; line < lineCount; ++line) {
                    if (!Shiboken::String::check(PySequence_Fast_GET_ITEM(strList.object(), line))) {
                        PyErr_SetString(PyExc_TypeError, "The argument must be a sequence of strings.");
                        break;
                    }
                }

                const char **xpm = reinterpret_cast<const char**>(malloc(lineCount * sizeof(const char**)));
                for (int line = 0; line < lineCount; ++line)
                    xpm[line] = Shiboken::String::toCString(PySequence_Fast_GET_ITEM(strList.object(), line));

                cptr = new QPixmapWrapper(xpm);

                free(xpm);
                // TEMPLATE - load_xpm - END

                // End of code injection

            }
            break;
        }
        case 6: // QPixmap(int w, int h)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPixmap_Init_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QPixmap(int,int)
                cptr = new ::QPixmapWrapper(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPixmap >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPixmap_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPixmap_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPixmapFunc_cacheKey(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.cacheKey";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cacheKey()const
            qint64 cppResult = const_cast<const ::QPixmap *>(cppSelf)->cacheKey();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_convertFromImage(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.convertFromImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_convertFromImage_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_convertFromImage_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:convertFromImage", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::convertFromImage(QImage,QFlags<Qt::ImageConversionFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // convertFromImage(QImage,QFlags<Qt::ImageConversionFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // convertFromImage(QImage,QFlags<Qt::ImageConversionFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_convertFromImage_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[1]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_convertFromImage_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QPixmapFunc_convertFromImage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPixmapFunc_convertFromImage_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QImage cppArg0_local;
        ::QImage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFlags<Qt::ImageConversionFlag> cppArg1 = Qt::AutoColor;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // convertFromImage(QImage,QFlags<Qt::ImageConversionFlag>)
            bool cppResult = cppSelf->convertFromImage(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_convertFromImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_copy(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.copy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_copy_TypeError;
    } else if (numArgs == 2 || numArgs == 3)
        goto Sbk_QPixmapFunc_copy_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOO:copy", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::copy(QRect)const
    // 1: QPixmap::copy(int,int,int,int)const
    if (numArgs == 0) {
        overloadId = 0; // copy(QRect)const
    } else if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 1; // copy(int,int,int,int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // copy(QRect)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_copy_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // copy(const QRect & rect) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_rect = Shiboken::String::createStaticString("rect");
                if (PyDict_Contains(kwds, key_rect)) {
                    value = PyDict_GetItem(kwds, key_rect);
                    if (value && pyArgs[0]) {
                        errInfo = key_rect;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_copy_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QPixmapFunc_copy_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_rect);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_copy_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local = QRect();
            ::QRect *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

            if (!PyErr_Occurred()) {
                // copy(QRect)const
                QPixmap cppResult = const_cast<const ::QPixmap *>(cppSelf)->copy(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
            }
            break;
        }
        case 1: // copy(int x, int y, int width, int height) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPixmapFunc_copy_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // copy(int,int,int,int)const
                QPixmap cppResult = const_cast<const ::QPixmap *>(cppSelf)->copy(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_copy_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_createHeuristicMask(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.createHeuristicMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_createHeuristicMask_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:createHeuristicMask", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::createHeuristicMask(bool)const
    if (numArgs == 0) {
        overloadId = 0; // createHeuristicMask(bool)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // createHeuristicMask(bool)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_createHeuristicMask_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_clipTight = Shiboken::String::createStaticString("clipTight");
            if (PyDict_Contains(kwds, key_clipTight)) {
                value = PyDict_GetItem(kwds, key_clipTight);
                if (value && pyArgs[0]) {
                    errInfo = key_clipTight;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_createHeuristicMask_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QPixmapFunc_createHeuristicMask_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_clipTight);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPixmapFunc_createHeuristicMask_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // createHeuristicMask(bool)const
            QBitmap cppResult = const_cast<const ::QPixmap *>(cppSelf)->createHeuristicMask(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBITMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_createHeuristicMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_createMaskFromColor(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.createMaskFromColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_createMaskFromColor_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_createMaskFromColor_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:createMaskFromColor", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::createMaskFromColor(QColor,Qt::MaskMode)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // createMaskFromColor(QColor,Qt::MaskMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MASKMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // createMaskFromColor(QColor,Qt::MaskMode)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_createMaskFromColor_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_createMaskFromColor_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MASKMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QPixmapFunc_createMaskFromColor_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPixmapFunc_createMaskFromColor_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::Qt::MaskMode cppArg1 = Qt::MaskInColor;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // createMaskFromColor(QColor,Qt::MaskMode)const
            QBitmap cppResult = const_cast<const ::QPixmap *>(cppSelf)->createMaskFromColor(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBITMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_createMaskFromColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_defaultDepth(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.defaultDepth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultDepth()
            int cppResult = ::QPixmap::defaultDepth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_depth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.depth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depth()const
            int cppResult = const_cast<const ::QPixmap *>(cppSelf)->depth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_devType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.devType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // devType()const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QPixmap *>(cppSelf)->::QPixmap::devType()
                : const_cast<const ::QPixmap *>(cppSelf)->devType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_devicePixelRatio(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.devicePixelRatio";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // devicePixelRatio()const
            qreal cppResult = const_cast<const ::QPixmap *>(cppSelf)->devicePixelRatio();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_fill(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.fill";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_fill_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:fill", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::fill(QColor)
    // 1: QPixmap::fill(const QPaintDevice*,QPoint)
    // 2: QPixmap::fill(const QPaintDevice*,int,int)
    if (numArgs == 0) {
        overloadId = 0; // fill(QColor)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 2; // fill(const QPaintDevice*,int,int)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // fill(const QPaintDevice*,QPoint)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[0])))) {
        overloadId = 0; // fill(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_fill_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fill(const QColor & fillColor)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_fillColor = Shiboken::String::createStaticString("fillColor");
                if (PyDict_Contains(kwds, key_fillColor)) {
                    value = PyDict_GetItem(kwds, key_fillColor);
                    if (value && pyArgs[0]) {
                        errInfo = key_fillColor;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_fill_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[0]))))
                            goto Sbk_QPixmapFunc_fill_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_fillColor);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_fill_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QColor cppArg0_local = Qt::white;
            ::QColor *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

            if (!PyErr_Occurred()) {
                // fill(QColor)
                cppSelf->fill(*cppArg0);
            }
            break;
        }
        case 1: // fill(const QPaintDevice * device, const QPoint & ofs)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPixmapFunc_fill_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPaintDevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPoint cppArg1_local;
            ::QPoint *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // fill(const QPaintDevice*,QPoint)
                cppSelf->fill(cppArg0, *cppArg1);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPixmap.fill(const QPaintDevice * device, const QPoint & ofs) is deprecated", 1);
            break;
        }
        case 2: // fill(const QPaintDevice * device, int xofs, int yofs)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPixmapFunc_fill_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPaintDevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // fill(const QPaintDevice*,int,int)
                cppSelf->fill(cppArg0, cppArg1, cppArg2);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPixmap.fill(const QPaintDevice * device, int xofs, int yofs) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPixmapFunc_fill_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_fromImage(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.fromImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_fromImage_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_fromImage_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromImage", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QPixmap::fromImage(QImage,QFlags<Qt::ImageConversionFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromImage(QImage,QFlags<Qt::ImageConversionFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromImage(QImage,QFlags<Qt::ImageConversionFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_fromImage_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[1]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_fromImage_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QPixmapFunc_fromImage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPixmapFunc_fromImage_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QImage cppArg0_local;
        ::QImage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFlags<Qt::ImageConversionFlag> cppArg1 = Qt::AutoColor;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromImage(QImage,QFlags<Qt::ImageConversionFlag>)
            QPixmap cppResult = ::QPixmap::fromImage(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_fromImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_fromImageInPlace(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.fromImageInPlace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_fromImageInPlace_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_fromImageInPlace_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromImageInPlace", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QPixmap::fromImageInPlace(QImage&,QFlags<Qt::ImageConversionFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromImageInPlace(QImage&,QFlags<Qt::ImageConversionFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromImageInPlace(QImage&,QFlags<Qt::ImageConversionFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_fromImageInPlace_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[1]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_fromImageInPlace_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QPixmapFunc_fromImageInPlace_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPixmapFunc_fromImageInPlace_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QImage cppArg0_local;
        ::QImage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFlags<Qt::ImageConversionFlag> cppArg1 = Qt::AutoColor;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromImageInPlace(QImage&,QFlags<Qt::ImageConversionFlag>)
            QPixmap cppResult = ::QPixmap::fromImageInPlace(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_fromImageInPlace_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_fromImageReader(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.fromImageReader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_fromImageReader_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_fromImageReader_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromImageReader", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QPixmap::fromImageReader(QImageReader*,QFlags<Qt::ImageConversionFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromImageReader(QImageReader*,QFlags<Qt::ImageConversionFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromImageReader(QImageReader*,QFlags<Qt::ImageConversionFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_fromImageReader_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[1]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_fromImageReader_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QPixmapFunc_fromImageReader_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPixmapFunc_fromImageReader_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QImageReader *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<Qt::ImageConversionFlag> cppArg1 = Qt::AutoColor;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromImageReader(QImageReader*,QFlags<Qt::ImageConversionFlag>)
            QPixmap cppResult = ::QPixmap::fromImageReader(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_fromImageReader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_grabWidget(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.grabWidget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_grabWidget_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_grabWidget_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:grabWidget", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QPixmap::grabWidget(QObject*,QRect)
    // 1: static QPixmap::grabWidget(QObject*,int,int,int,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // grabWidget(QObject*,int,int,int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // grabWidget(QObject*,int,int,int,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // grabWidget(QObject*,int,int,int,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 1; // grabWidget(QObject*,int,int,int,int)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                        overloadId = 1; // grabWidget(QObject*,int,int,int,int)
                    }
                }
            }
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // grabWidget(QObject*,QRect)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_grabWidget_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // grabWidget(QObject * widget, const QRect & rect)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPixmapFunc_grabWidget_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QRect cppArg1_local;
            ::QRect *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // grabWidget(QObject*,QRect)
                QPixmap cppResult = ::QPixmap::grabWidget(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPixmap.grabWidget(QObject * widget, const QRect & rect) is deprecated", 1);
            break;
        }
        case 1: // grabWidget(QObject * widget, int x, int y, int w, int h)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_x = Shiboken::String::createStaticString("x");
                if (PyDict_Contains(kwds, key_x)) {
                    value = PyDict_GetItem(kwds, key_x);
                    if (value && pyArgs[1]) {
                        errInfo = key_x;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_grabWidget_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QPixmapFunc_grabWidget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_x);
                }
                static PyObject *const key_y = Shiboken::String::createStaticString("y");
                if (PyDict_Contains(kwds, key_y)) {
                    value = PyDict_GetItem(kwds, key_y);
                    if (value && pyArgs[2]) {
                        errInfo = key_y;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_grabWidget_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QPixmapFunc_grabWidget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_y);
                }
                static PyObject *const key_w = Shiboken::String::createStaticString("w");
                if (PyDict_Contains(kwds, key_w)) {
                    value = PyDict_GetItem(kwds, key_w);
                    if (value && pyArgs[3]) {
                        errInfo = key_w;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_grabWidget_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QPixmapFunc_grabWidget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_w);
                }
                static PyObject *const key_h = Shiboken::String::createStaticString("h");
                if (PyDict_Contains(kwds, key_h)) {
                    value = PyDict_GetItem(kwds, key_h);
                    if (value && pyArgs[4]) {
                        errInfo = key_h;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_grabWidget_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QPixmapFunc_grabWidget_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_h);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_grabWidget_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // grabWidget(QObject*,int,int,int,int)
                QPixmap cppResult = ::QPixmap::grabWidget(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPixmap.grabWidget(QObject * widget, int x, int y, int w, int h) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_grabWidget_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_grabWindow(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.grabWindow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_grabWindow_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_grabWindow_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:grabWindow", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QPixmap::grabWindow(WId,int,int,int,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_WID_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // grabWindow(WId,int,int,int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // grabWindow(WId,int,int,int,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // grabWindow(WId,int,int,int,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // grabWindow(WId,int,int,int,int)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                        overloadId = 0; // grabWindow(WId,int,int,int,int)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_grabWindow_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_x = Shiboken::String::createStaticString("x");
            if (PyDict_Contains(kwds, key_x)) {
                value = PyDict_GetItem(kwds, key_x);
                if (value && pyArgs[1]) {
                    errInfo = key_x;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_grabWindow_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QPixmapFunc_grabWindow_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_x);
            }
            static PyObject *const key_y = Shiboken::String::createStaticString("y");
            if (PyDict_Contains(kwds, key_y)) {
                value = PyDict_GetItem(kwds, key_y);
                if (value && pyArgs[2]) {
                    errInfo = key_y;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_grabWindow_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QPixmapFunc_grabWindow_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_y);
            }
            static PyObject *const key_w = Shiboken::String::createStaticString("w");
            if (PyDict_Contains(kwds, key_w)) {
                value = PyDict_GetItem(kwds, key_w);
                if (value && pyArgs[3]) {
                    errInfo = key_w;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_grabWindow_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QPixmapFunc_grabWindow_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_w);
            }
            static PyObject *const key_h = Shiboken::String::createStaticString("h");
            if (PyDict_Contains(kwds, key_h)) {
                value = PyDict_GetItem(kwds, key_h);
                if (value && pyArgs[4]) {
                    errInfo = key_h;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_grabWindow_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                        goto Sbk_QPixmapFunc_grabWindow_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_h);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPixmapFunc_grabWindow_TypeError;
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = -1;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4 = -1;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // grabWindow(WId,int,int,int,int)
            QPixmap cppResult = ::QPixmap::grabWindow(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_grabWindow_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_hasAlpha(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.hasAlpha";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasAlpha()const
            bool cppResult = const_cast<const ::QPixmap *>(cppSelf)->hasAlpha();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_hasAlphaChannel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.hasAlphaChannel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasAlphaChannel()const
            bool cppResult = const_cast<const ::QPixmap *>(cppSelf)->hasAlphaChannel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            int cppResult = const_cast<const ::QPixmap *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QPixmap *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_isQBitmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.isQBitmap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isQBitmap()const
            bool cppResult = const_cast<const ::QPixmap *>(cppSelf)->isQBitmap();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_load(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.load";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_load_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_load_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:load", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::load(QString,const char*,QFlags<Qt::ImageConversionFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // load(QString,const char*,QFlags<Qt::ImageConversionFlag>)
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // load(QString,const char*,QFlags<Qt::ImageConversionFlag>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // load(QString,const char*,QFlags<Qt::ImageConversionFlag>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_load_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[1]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_load_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                        goto Sbk_QPixmapFunc_load_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[2]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_load_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QPixmapFunc_load_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPixmapFunc_load_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<Qt::ImageConversionFlag> cppArg2 = Qt::AutoColor;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // load(QString,const char*,QFlags<Qt::ImageConversionFlag>)
            bool cppResult = cppSelf->load(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_load_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_loadFromData(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.loadFromData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_loadFromData_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_loadFromData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:loadFromData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::loadFromData(QByteArray,const char*,QFlags<Qt::ImageConversionFlag>)
    // 1: QPixmap::loadFromData(const uchar*,uint,const char*,QFlags<Qt::ImageConversionFlag>)
    if (numArgs >= 1
        && PyBytes_Check(pyArgs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // loadFromData(const uchar*,uint,const char*,QFlags<Qt::ImageConversionFlag>)
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // loadFromData(const uchar*,uint,const char*,QFlags<Qt::ImageConversionFlag>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 1; // loadFromData(const uchar*,uint,const char*,QFlags<Qt::ImageConversionFlag>)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // loadFromData(QByteArray,const char*,QFlags<Qt::ImageConversionFlag>)
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // loadFromData(QByteArray,const char*,QFlags<Qt::ImageConversionFlag>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // loadFromData(QByteArray,const char*,QFlags<Qt::ImageConversionFlag>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_loadFromData_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // loadFromData(const QByteArray & data, const char * format, QFlags<Qt::ImageConversionFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_loadFromData_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QPixmapFunc_loadFromData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[2]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_loadFromData_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QPixmapFunc_loadFromData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_loadFromData_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::ImageConversionFlag> cppArg2 = Qt::AutoColor;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // loadFromData(QByteArray,const char*,QFlags<Qt::ImageConversionFlag>)
                bool cppResult = cppSelf->loadFromData(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // loadFromData(const uchar * buf, uint len, const char * format, QFlags<Qt::ImageConversionFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_loadFromData_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QPixmapFunc_loadFromData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[2]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_loadFromData_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QPixmapFunc_loadFromData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_loadFromData_TypeError;
                }
            }
            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::ImageConversionFlag> cppArg2 = Qt::AutoColor;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // loadFromData(const uchar*,uint,const char*,QFlags<Qt::ImageConversionFlag>)
                // Begin code injection
                // TEMPLATE - pybytes_const_uchar - START
                const uchar *buf_out = reinterpret_cast<const uchar*>(PyBytes_AS_STRING(pyArgs[1-1]));
                // TEMPLATE - pybytes_const_uchar - END

                // TEMPLATE - pybytes_uint - START
                uint len_out = static_cast<uint>(PyBytes_Size(pyArgs[1-1]));
                // TEMPLATE - pybytes_uint - END

                // End of code injection

                bool cppResult = cppSelf->loadFromData(buf_out, len_out, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_loadFromData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_mask(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.mask";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mask()const
            QBitmap cppResult = const_cast<const ::QPixmap *>(cppSelf)->mask();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBITMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_metric(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.metric";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, (pyArg)))) {
        overloadId = 0; // metric(QPaintDevice::PaintDeviceMetric)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_metric_TypeError;

    // Call function/method
    {
        ::QPaintDevice::PaintDeviceMetric cppArg0 = static_cast< ::QPaintDevice::PaintDeviceMetric>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // metric(QPaintDevice::PaintDeviceMetric)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QPixmap *>(cppSelf)->::QPixmap::metric(cppArg0)
                : const_cast<const ::QPixmap *>(cppSelf)->metric(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_metric_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_paintEngine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.paintEngine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // paintEngine()const
            QPaintEngine * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QPixmap *>(cppSelf)->::QPixmap::paintEngine()
                : const_cast<const ::QPixmap *>(cppSelf)->paintEngine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_rect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.rect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rect()const
            QRect cppResult = const_cast<const ::QPixmap *>(cppSelf)->rect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_save(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.save";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_save_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_save_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:save", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::save(QIODevice*,const char*,int)const
    // 1: QPixmap::save(QString,const char*,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // save(QIODevice*,const char*,int)const
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // save(QIODevice*,const char*,int)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // save(QIODevice*,const char*,int)const
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // save(QString,const char*,int)const
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // save(QString,const char*,int)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 1; // save(QString,const char*,int)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_save_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // save(QIODevice * device, const char * format, int quality) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_save_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QPixmapFunc_save_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                static PyObject *const key_quality = Shiboken::String::createStaticString("quality");
                if (PyDict_Contains(kwds, key_quality)) {
                    value = PyDict_GetItem(kwds, key_quality);
                    if (value && pyArgs[2]) {
                        errInfo = key_quality;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_save_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QPixmapFunc_save_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_quality);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_save_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = -1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // save(QIODevice*,const char*,int)const
                bool cppResult = const_cast<const ::QPixmap *>(cppSelf)->save(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // save(const QString & fileName, const char * format, int quality) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_save_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QPixmapFunc_save_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                static PyObject *const key_quality = Shiboken::String::createStaticString("quality");
                if (PyDict_Contains(kwds, key_quality)) {
                    value = PyDict_GetItem(kwds, key_quality);
                    if (value && pyArgs[2]) {
                        errInfo = key_quality;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_save_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QPixmapFunc_save_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_quality);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_save_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = -1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // save(QString,const char*,int)const
                bool cppResult = const_cast<const ::QPixmap *>(cppSelf)->save(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_save_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_scaled(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.scaled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_scaled_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_scaled_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:scaled", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
    // 1: QPixmap::scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[3])))) {
                overloadId = 1; // scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_scaled_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // scaled(const QSize & s, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_aspectMode = Shiboken::String::createStaticString("aspectMode");
                if (PyDict_Contains(kwds, key_aspectMode)) {
                    value = PyDict_GetItem(kwds, key_aspectMode);
                    if (value && pyArgs[1]) {
                        errInfo = key_aspectMode;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_scaled_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QPixmapFunc_scaled_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_aspectMode);
                }
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[2]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_scaled_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QPixmapFunc_scaled_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_scaled_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::AspectRatioMode cppArg1 = Qt::IgnoreAspectRatio;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::TransformationMode cppArg2 = Qt::FastTransformation;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // scaled(QSize,Qt::AspectRatioMode,Qt::TransformationMode)const
                QPixmap cppResult = const_cast<const ::QPixmap *>(cppSelf)->scaled(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
            }
            break;
        }
        case 1: // scaled(int w, int h, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_aspectMode = Shiboken::String::createStaticString("aspectMode");
                if (PyDict_Contains(kwds, key_aspectMode)) {
                    value = PyDict_GetItem(kwds, key_aspectMode);
                    if (value && pyArgs[2]) {
                        errInfo = key_aspectMode;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_scaled_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QPixmapFunc_scaled_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_aspectMode);
                }
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[3]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_scaled_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QPixmapFunc_scaled_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_scaled_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::AspectRatioMode cppArg2 = Qt::IgnoreAspectRatio;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::Qt::TransformationMode cppArg3 = Qt::FastTransformation;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // scaled(int,int,Qt::AspectRatioMode,Qt::TransformationMode)const
                QPixmap cppResult = const_cast<const ::QPixmap *>(cppSelf)->scaled(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_scaled_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_scaledToHeight(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.scaledToHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_scaledToHeight_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_scaledToHeight_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:scaledToHeight", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::scaledToHeight(int,Qt::TransformationMode)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // scaledToHeight(int,Qt::TransformationMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // scaledToHeight(int,Qt::TransformationMode)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_scaledToHeight_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_scaledToHeight_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QPixmapFunc_scaledToHeight_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPixmapFunc_scaledToHeight_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::TransformationMode cppArg1 = Qt::FastTransformation;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // scaledToHeight(int,Qt::TransformationMode)const
            QPixmap cppResult = const_cast<const ::QPixmap *>(cppSelf)->scaledToHeight(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_scaledToHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_scaledToWidth(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.scaledToWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_scaledToWidth_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_scaledToWidth_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:scaledToWidth", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::scaledToWidth(int,Qt::TransformationMode)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // scaledToWidth(int,Qt::TransformationMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // scaledToWidth(int,Qt::TransformationMode)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_scaledToWidth_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QPixmapFunc_scaledToWidth_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QPixmapFunc_scaledToWidth_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPixmapFunc_scaledToWidth_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::TransformationMode cppArg1 = Qt::FastTransformation;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // scaledToWidth(int,Qt::TransformationMode)const
            QPixmap cppResult = const_cast<const ::QPixmap *>(cppSelf)->scaledToWidth(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_scaledToWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_scroll(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.scroll";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_scroll_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_scroll_TypeError;
    } else if (numArgs == 5)
        goto Sbk_QPixmapFunc_scroll_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOOO:scroll", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::scroll(int,int,QRect,QRegion*)
    // 1: QPixmap::scroll(int,int,int,int,int,int,QRegion*)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs >= 6
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
            if (numArgs == 6) {
                overloadId = 1; // scroll(int,int,int,int,int,int,QRegion*)
            } else if (numArgs >= 7
                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), (pyArgs[6])))) {
                overloadId = 1; // scroll(int,int,int,int,int,int,QRegion*)
            }
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // scroll(int,int,QRect,QRegion*)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), (pyArgs[3])))) {
                overloadId = 0; // scroll(int,int,QRect,QRegion*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_scroll_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // scroll(int dx, int dy, const QRect & rect, QRegion * exposed)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_exposed = Shiboken::String::createStaticString("exposed");
                if (PyDict_Contains(kwds, key_exposed)) {
                    value = PyDict_GetItem(kwds, key_exposed);
                    if (value && pyArgs[3]) {
                        errInfo = key_exposed;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_scroll_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), (pyArgs[3]))))
                            goto Sbk_QPixmapFunc_scroll_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_exposed);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_scroll_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QRect cppArg2_local;
            ::QRect *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QRegion *cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // scroll(int,int,QRect,QRegion*)
                cppSelf->scroll(cppArg0, cppArg1, *cppArg2, cppArg3);
            }
            break;
        }
        case 1: // scroll(int dx, int dy, int x, int y, int width, int height, QRegion * exposed)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_exposed = Shiboken::String::createStaticString("exposed");
                if (PyDict_Contains(kwds, key_exposed)) {
                    value = PyDict_GetItem(kwds, key_exposed);
                    if (value && pyArgs[6]) {
                        errInfo = key_exposed;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_scroll_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), (pyArgs[6]))))
                            goto Sbk_QPixmapFunc_scroll_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_exposed);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_scroll_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return {};
            ::QRegion *cppArg6 = nullptr;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // scroll(int,int,int,int,int,int,QRegion*)
                cppSelf->scroll(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPixmapFunc_scroll_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_setDevicePixelRatio(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.setDevicePixelRatio";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPixmap::setDevicePixelRatio(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setDevicePixelRatio(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_setDevicePixelRatio_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevicePixelRatio(qreal)
            cppSelf->setDevicePixelRatio(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPixmapFunc_setDevicePixelRatio_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_setMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.setMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPixmap::setMask(QBitmap)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBITMAP_IDX]), (pyArg)))) {
        overloadId = 0; // setMask(QBitmap)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_setMask_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBitmap cppArg0_local;
        ::QBitmap *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBITMAP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMask(QBitmap)
            cppSelf->setMask(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPixmapFunc_setMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            QSize cppResult = const_cast<const ::QPixmap *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPixmap::swap(QPixmap&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QPixmap&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QPixmap&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPixmapFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_toImage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.toImage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toImage()const
            QImage cppResult = const_cast<const ::QPixmap *>(cppSelf)->toImage();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmapFunc_transformed(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.transformed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_transformed_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPixmapFunc_transformed_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:transformed", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPixmap::transformed(QMatrix,Qt::TransformationMode)const
    // 1: QPixmap::transformed(QTransform,Qt::TransformationMode)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // transformed(QTransform,Qt::TransformationMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // transformed(QTransform,Qt::TransformationMode)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // transformed(QMatrix,Qt::TransformationMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // transformed(QMatrix,Qt::TransformationMode)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_transformed_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // transformed(const QMatrix & arg__1, Qt::TransformationMode mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_transformed_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QPixmapFunc_transformed_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_transformed_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMatrix cppArg0_local;
            ::QMatrix *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::TransformationMode cppArg1 = Qt::FastTransformation;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // transformed(QMatrix,Qt::TransformationMode)const
                QPixmap cppResult = const_cast<const ::QPixmap *>(cppSelf)->transformed(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPixmap.transformed(const QMatrix & arg__1, Qt::TransformationMode mode) const is deprecated", 1);
            break;
        }
        case 1: // transformed(const QTransform & arg__1, Qt::TransformationMode mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixmapFunc_transformed_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QPixmapFunc_transformed_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixmapFunc_transformed_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTransform cppArg0_local;
            ::QTransform *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::TransformationMode cppArg1 = Qt::FastTransformation;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // transformed(QTransform,Qt::TransformationMode)const
                QPixmap cppResult = const_cast<const ::QPixmap *>(cppSelf)->transformed(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_transformed_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_trueMatrix(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.trueMatrix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "trueMatrix", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QPixmap::trueMatrix(QMatrix,int,int)
    // 1: static QPixmap::trueMatrix(QTransform,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 1; // trueMatrix(QTransform,int,int)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // trueMatrix(QMatrix,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixmapFunc_trueMatrix_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // trueMatrix(const QMatrix & m, int w, int h)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMatrix cppArg0_local;
            ::QMatrix *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // trueMatrix(QMatrix,int,int)
                QMatrix cppResult = ::QPixmap::trueMatrix(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPixmap.trueMatrix(const QMatrix & m, int w, int h) is deprecated", 1);
            break;
        }
        case 1: // trueMatrix(const QTransform & m, int w, int h)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTransform cppArg0_local;
            ::QTransform *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // trueMatrix(QTransform,int,int)
                QTransform cppResult = ::QPixmap::trueMatrix(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc_trueMatrix_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            int cppResult = const_cast<const ::QPixmap *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixmap___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPixmap_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPixmap_methods[] = {
    {"cacheKey", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_cacheKey), METH_NOARGS},
    {"convertFromImage", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_convertFromImage), METH_VARARGS|METH_KEYWORDS},
    {"copy", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_copy), METH_VARARGS|METH_KEYWORDS},
    {"createHeuristicMask", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_createHeuristicMask), METH_VARARGS|METH_KEYWORDS},
    {"createMaskFromColor", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_createMaskFromColor), METH_VARARGS|METH_KEYWORDS},
    {"defaultDepth", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_defaultDepth), METH_NOARGS|METH_STATIC},
    {"depth", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_depth), METH_NOARGS},
    {"devType", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_devType), METH_NOARGS},
    {"devicePixelRatio", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_devicePixelRatio), METH_NOARGS},
    {"fill", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_fill), METH_VARARGS|METH_KEYWORDS},
    {"fromImage", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_fromImage), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromImageInPlace", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_fromImageInPlace), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromImageReader", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_fromImageReader), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"grabWidget", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_grabWidget), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"grabWindow", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_grabWindow), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"hasAlpha", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_hasAlpha), METH_NOARGS},
    {"hasAlphaChannel", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_hasAlphaChannel), METH_NOARGS},
    {"height", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_height), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_isNull), METH_NOARGS},
    {"isQBitmap", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_isQBitmap), METH_NOARGS},
    {"load", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_load), METH_VARARGS|METH_KEYWORDS},
    {"loadFromData", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_loadFromData), METH_VARARGS|METH_KEYWORDS},
    {"mask", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_mask), METH_NOARGS},
    {"metric", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_metric), METH_O},
    {"paintEngine", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_paintEngine), METH_NOARGS},
    {"rect", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_rect), METH_NOARGS},
    {"save", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_save), METH_VARARGS|METH_KEYWORDS},
    {"scaled", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_scaled), METH_VARARGS|METH_KEYWORDS},
    {"scaledToHeight", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_scaledToHeight), METH_VARARGS|METH_KEYWORDS},
    {"scaledToWidth", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_scaledToWidth), METH_VARARGS|METH_KEYWORDS},
    {"scroll", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_scroll), METH_VARARGS|METH_KEYWORDS},
    {"setDevicePixelRatio", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_setDevicePixelRatio), METH_O},
    {"setMask", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_setMask), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_size), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_swap), METH_O},
    {"toImage", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_toImage), METH_NOARGS},
    {"transformed", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_transformed), METH_VARARGS|METH_KEYWORDS},
    {"trueMatrix", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_trueMatrix), METH_VARARGS|METH_STATIC},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QPixmapFunc_width), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPixmap___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QPixmap_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QPixmapWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

static int Sbk_QPixmap___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

static PyObject *Sbk_QPixmapFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QPixmap::operator<<(QDataStream&,QPixmap)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QPixmap)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QPixmapFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QPixmap) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPixmapFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixmap.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QPixmap::operator>>(QDataStream&,QPixmap&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QPixmap&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QPixmapFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QPixmap&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPixmapFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

} // extern "C"

static int Sbk_QPixmap_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPixmap_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QPixmap__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPixmap_Type = nullptr;
static SbkObjectType *Sbk_QPixmap_TypeF(void)
{
    return _Sbk_QPixmap_Type;
}

static PyType_Slot Sbk_QPixmap_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QPixmap__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QPixmap_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPixmap_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPixmap_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPixmap_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPixmap_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QPixmapFunc___rshift__},
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QPixmap___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QPixmap___nb_bool},
#endif
    {Py_nb_lshift, (void *)Sbk_QPixmapFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QPixmap_spec = {
    "2:PySide2.QtGui.QPixmap",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPixmap_slots
};

} //extern "C"

static void *Sbk_QPixmap_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QPaintDevice >()))
        return dynamic_cast< ::QPixmap *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPixmap_PythonToCpp_QPixmap_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPixmap_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPixmap_PythonToCpp_QPixmap_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPixmap_TypeF())))
        return QPixmap_PythonToCpp_QPixmap_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPixmap_PTR_CppToPython_QPixmap(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPixmap *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPixmap_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QPixmap_COPY_CppToPython_QPixmap(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPixmap_TypeF(), new ::QPixmapWrapper(*reinterpret_cast<const ::QPixmap *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QPixmap_PythonToCpp_QPixmap_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPixmap *>(cppOut) = *reinterpret_cast< ::QPixmap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QPixmap_PythonToCpp_QPixmap_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPixmap_TypeF())))
        return QPixmap_PythonToCpp_QPixmap_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_constQStringREF_PythonToCpp_QPixmap(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QPixmap *>(cppOut) = ::QPixmap(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_constQStringREF_PythonToCpp_QPixmap_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return PySide2_QtCore_constQStringREF_PythonToCpp_QPixmap;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPixmap_SignatureStrings[] = {
    "6:PySide2.QtGui.QPixmap(self)",
    "5:PySide2.QtGui.QPixmap(self,image:PySide2.QtGui.QImage)",
    "4:PySide2.QtGui.QPixmap(self,arg__1:PySide2.QtGui.QPixmap)",
    "3:PySide2.QtGui.QPixmap(self,arg__1:PySide2.QtCore.QSize)",
    "2:PySide2.QtGui.QPixmap(self,fileName:QString,format:char*=nullptr,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)",
    "1:PySide2.QtGui.QPixmap(self,xpm:char*const[])",
    "0:PySide2.QtGui.QPixmap(self,w:int,h:int)",
    "PySide2.QtGui.QPixmap.cacheKey(self)->qint64",
    "PySide2.QtGui.QPixmap.convertFromImage(self,img:PySide2.QtGui.QImage,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)->bool",
    "1:PySide2.QtGui.QPixmap.copy(self,rect:PySide2.QtCore.QRect=QRect())->PySide2.QtGui.QPixmap",
    "0:PySide2.QtGui.QPixmap.copy(self,x:int,y:int,width:int,height:int)->PySide2.QtGui.QPixmap",
    "PySide2.QtGui.QPixmap.createHeuristicMask(self,clipTight:bool=true)->PySide2.QtGui.QBitmap",
    "PySide2.QtGui.QPixmap.createMaskFromColor(self,maskColor:PySide2.QtGui.QColor,mode:PySide2.QtCore.Qt.MaskMode=Qt.MaskInColor)->PySide2.QtGui.QBitmap",
    "PySide2.QtGui.QPixmap.defaultDepth()->int",
    "PySide2.QtGui.QPixmap.depth(self)->int",
    "PySide2.QtGui.QPixmap.devType(self)->int",
    "PySide2.QtGui.QPixmap.devicePixelRatio(self)->qreal",
    "2:PySide2.QtGui.QPixmap.fill(self,fillColor:PySide2.QtGui.QColor=Qt.white)",
    "1:PySide2.QtGui.QPixmap.fill(self,device:PySide2.QtGui.QPaintDevice,ofs:PySide2.QtCore.QPoint)",
    "0:PySide2.QtGui.QPixmap.fill(self,device:PySide2.QtGui.QPaintDevice,xofs:int,yofs:int)",
    "PySide2.QtGui.QPixmap.fromImage(image:PySide2.QtGui.QImage,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)->PySide2.QtGui.QPixmap",
    "PySide2.QtGui.QPixmap.fromImageInPlace(image:PySide2.QtGui.QImage,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)->PySide2.QtGui.QPixmap",
    "PySide2.QtGui.QPixmap.fromImageReader(imageReader:PySide2.QtGui.QImageReader,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)->PySide2.QtGui.QPixmap",
    "1:PySide2.QtGui.QPixmap.grabWidget(widget:PySide2.QtCore.QObject,rect:PySide2.QtCore.QRect)->PySide2.QtGui.QPixmap",
    "0:PySide2.QtGui.QPixmap.grabWidget(widget:PySide2.QtCore.QObject,x:int=0,y:int=0,w:int=-1,h:int=-1)->PySide2.QtGui.QPixmap",
    "PySide2.QtGui.QPixmap.grabWindow(arg__1:WId,x:int=0,y:int=0,w:int=-1,h:int=-1)->PySide2.QtGui.QPixmap",
    "PySide2.QtGui.QPixmap.hasAlpha(self)->bool",
    "PySide2.QtGui.QPixmap.hasAlphaChannel(self)->bool",
    "PySide2.QtGui.QPixmap.height(self)->int",
    "PySide2.QtGui.QPixmap.isNull(self)->bool",
    "PySide2.QtGui.QPixmap.isQBitmap(self)->bool",
    "PySide2.QtGui.QPixmap.load(self,fileName:QString,format:char*=nullptr,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)->bool",
    "1:PySide2.QtGui.QPixmap.loadFromData(self,data:PySide2.QtCore.QByteArray,format:char*=nullptr,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)->bool",
    "0:PySide2.QtGui.QPixmap.loadFromData(self,buf:uchar*,len:uint,format:char*=nullptr,flags:PySide2.QtCore.Qt.ImageConversionFlags=Qt.AutoColor)->bool",
    "PySide2.QtGui.QPixmap.mask(self)->PySide2.QtGui.QBitmap",
    "PySide2.QtGui.QPixmap.metric(self,arg__1:PySide2.QtGui.QPaintDevice.PaintDeviceMetric)->int",
    "PySide2.QtGui.QPixmap.paintEngine(self)->PySide2.QtGui.QPaintEngine",
    "PySide2.QtGui.QPixmap.rect(self)->PySide2.QtCore.QRect",
    "1:PySide2.QtGui.QPixmap.save(self,device:PySide2.QtCore.QIODevice,format:char*=nullptr,quality:int=-1)->bool",
    "0:PySide2.QtGui.QPixmap.save(self,fileName:QString,format:char*=nullptr,quality:int=-1)->bool",
    "1:PySide2.QtGui.QPixmap.scaled(self,s:PySide2.QtCore.QSize,aspectMode:PySide2.QtCore.Qt.AspectRatioMode=Qt.IgnoreAspectRatio,mode:PySide2.QtCore.Qt.TransformationMode=Qt.FastTransformation)->PySide2.QtGui.QPixmap",
    "0:PySide2.QtGui.QPixmap.scaled(self,w:int,h:int,aspectMode:PySide2.QtCore.Qt.AspectRatioMode=Qt.IgnoreAspectRatio,mode:PySide2.QtCore.Qt.TransformationMode=Qt.FastTransformation)->PySide2.QtGui.QPixmap",
    "PySide2.QtGui.QPixmap.scaledToHeight(self,h:int,mode:PySide2.QtCore.Qt.TransformationMode=Qt.FastTransformation)->PySide2.QtGui.QPixmap",
    "PySide2.QtGui.QPixmap.scaledToWidth(self,w:int,mode:PySide2.QtCore.Qt.TransformationMode=Qt.FastTransformation)->PySide2.QtGui.QPixmap",
    "1:PySide2.QtGui.QPixmap.scroll(self,dx:int,dy:int,rect:PySide2.QtCore.QRect,exposed:PySide2.QtGui.QRegion=nullptr)",
    "0:PySide2.QtGui.QPixmap.scroll(self,dx:int,dy:int,x:int,y:int,width:int,height:int,exposed:PySide2.QtGui.QRegion=nullptr)",
    "PySide2.QtGui.QPixmap.setDevicePixelRatio(self,scaleFactor:qreal)",
    "PySide2.QtGui.QPixmap.setMask(self,arg__1:PySide2.QtGui.QBitmap)",
    "PySide2.QtGui.QPixmap.size(self)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QPixmap.swap(self,other:PySide2.QtGui.QPixmap)",
    "PySide2.QtGui.QPixmap.toImage(self)->PySide2.QtGui.QImage",
    "1:PySide2.QtGui.QPixmap.transformed(self,arg__1:PySide2.QtGui.QMatrix,mode:PySide2.QtCore.Qt.TransformationMode=Qt.FastTransformation)->PySide2.QtGui.QPixmap",
    "0:PySide2.QtGui.QPixmap.transformed(self,arg__1:PySide2.QtGui.QTransform,mode:PySide2.QtCore.Qt.TransformationMode=Qt.FastTransformation)->PySide2.QtGui.QPixmap",
    "1:PySide2.QtGui.QPixmap.trueMatrix(m:PySide2.QtGui.QMatrix,w:int,h:int)->PySide2.QtGui.QMatrix",
    "0:PySide2.QtGui.QPixmap.trueMatrix(m:PySide2.QtGui.QTransform,w:int,h:int)->PySide2.QtGui.QTransform",
    "PySide2.QtGui.QPixmap.width(self)->int",
    "PySide2.QtGui.QPixmap.__copy__()",
    "PySide2.QtGui.QPixmap.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QPixmap.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QPixmap(PyObject *module)
{
    _Sbk_QPixmap_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPixmap",
        "QPixmap",
        &Sbk_QPixmap_spec,
        &Shiboken::callCppDestructor< ::QPixmapWrapper >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPixmap_Type);
    InitSignatureStrings(pyType, QPixmap_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPixmap_Type), Sbk_QPixmap_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPixmap_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPixmap_TypeF(),
        QPixmap_PythonToCpp_QPixmap_PTR,
        is_QPixmap_PythonToCpp_QPixmap_PTR_Convertible,
        QPixmap_PTR_CppToPython_QPixmap,
        QPixmap_COPY_CppToPython_QPixmap);

    Shiboken::Conversions::registerConverterName(converter, "QPixmap");
    Shiboken::Conversions::registerConverterName(converter, "QPixmap*");
    Shiboken::Conversions::registerConverterName(converter, "QPixmap&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPixmap).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPixmapWrapper).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPixmap_PythonToCpp_QPixmap_COPY,
        is_QPixmap_PythonToCpp_QPixmap_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQStringREF_PythonToCpp_QPixmap,
        is_PySide2_QtCore_constQStringREF_PythonToCpp_QPixmap_Convertible);

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QPixmap_TypeF(), &Sbk_QPixmap_typeDiscovery);

    qRegisterMetaType< ::QPixmap >("QPixmap");
}
