/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qscreen_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QScreenWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QScreenWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QScreenWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QScreenWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QScreenWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QScreenWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScreen.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QScreenWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScreen.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QScreenWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QScreenWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QScreen::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QScreenWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QScreen::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QScreenWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QScreenWrapper *>(this));
        return QScreen::qt_metacast(_clname);
}

QScreenWrapper::~QScreenWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QScreenFunc_angleBetween(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.angleBetween";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "angleBetween", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScreen::angleBetween(Qt::ScreenOrientation,Qt::ScreenOrientation)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // angleBetween(Qt::ScreenOrientation,Qt::ScreenOrientation)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScreenFunc_angleBetween_TypeError;

    // Call function/method
    {
        ::Qt::ScreenOrientation cppArg0{Qt::PrimaryOrientation};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::ScreenOrientation cppArg1{Qt::PrimaryOrientation};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // angleBetween(Qt::ScreenOrientation,Qt::ScreenOrientation)const
            int cppResult = const_cast<const ::QScreen *>(cppSelf)->angleBetween(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScreenFunc_angleBetween_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScreenFunc_availableGeometry(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.availableGeometry";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableGeometry()const
            QRect cppResult = const_cast<const ::QScreen *>(cppSelf)->availableGeometry();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_availableSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.availableSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableSize()const
            QSize cppResult = const_cast<const ::QScreen *>(cppSelf)->availableSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_availableVirtualGeometry(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.availableVirtualGeometry";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableVirtualGeometry()const
            QRect cppResult = const_cast<const ::QScreen *>(cppSelf)->availableVirtualGeometry();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_availableVirtualSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.availableVirtualSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableVirtualSize()const
            QSize cppResult = const_cast<const ::QScreen *>(cppSelf)->availableVirtualSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_depth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.depth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depth()const
            int cppResult = const_cast<const ::QScreen *>(cppSelf)->depth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_devicePixelRatio(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.devicePixelRatio";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // devicePixelRatio()const
            qreal cppResult = const_cast<const ::QScreen *>(cppSelf)->devicePixelRatio();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_geometry(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.geometry";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geometry()const
            QRect cppResult = const_cast<const ::QScreen *>(cppSelf)->geometry();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_grabWindow(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.grabWindow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScreenFunc_grabWindow_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QScreenFunc_grabWindow_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:grabWindow", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QScreen::grabWindow(WId,int,int,int,int)
    if (numArgs >= 1
        && PyInt_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // grabWindow(WId,int,int,int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // grabWindow(WId,int,int,int,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // grabWindow(WId,int,int,int,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // grabWindow(WId,int,int,int,int)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                        overloadId = 0; // grabWindow(WId,int,int,int,int)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScreenFunc_grabWindow_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_x = Shiboken::String::createStaticString("x");
            if (PyDict_Contains(kwds, key_x)) {
                value = PyDict_GetItem(kwds, key_x);
                if (value && pyArgs[1]) {
                    errInfo = key_x;
                    Py_INCREF(errInfo);
                    goto Sbk_QScreenFunc_grabWindow_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QScreenFunc_grabWindow_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_x);
            }
            static PyObject *const key_y = Shiboken::String::createStaticString("y");
            if (PyDict_Contains(kwds, key_y)) {
                value = PyDict_GetItem(kwds, key_y);
                if (value && pyArgs[2]) {
                    errInfo = key_y;
                    Py_INCREF(errInfo);
                    goto Sbk_QScreenFunc_grabWindow_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QScreenFunc_grabWindow_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_y);
            }
            static PyObject *const key_w = Shiboken::String::createStaticString("w");
            if (PyDict_Contains(kwds, key_w)) {
                value = PyDict_GetItem(kwds, key_w);
                if (value && pyArgs[3]) {
                    errInfo = key_w;
                    Py_INCREF(errInfo);
                    goto Sbk_QScreenFunc_grabWindow_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QScreenFunc_grabWindow_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_w);
            }
            static PyObject *const key_h = Shiboken::String::createStaticString("h");
            if (PyDict_Contains(kwds, key_h)) {
                value = PyDict_GetItem(kwds, key_h);
                if (value && pyArgs[4]) {
                    errInfo = key_h;
                    Py_INCREF(errInfo);
                    goto Sbk_QScreenFunc_grabWindow_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                        goto Sbk_QScreenFunc_grabWindow_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_h);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QScreenFunc_grabWindow_TypeError;
            }
        }
        long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = -1;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4 = -1;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // grabWindow(WId,int,int,int,int)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qscreen-grabWindow)]
            WId id = cppArg0;
            ::QPixmap retval = cppSelf->grabWindow(id, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &retval);
            // END of custom code block [file: ../glue/qtgui.cpp (qscreen-grabWindow)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScreenFunc_grabWindow_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScreenFunc_isLandscape(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.isLandscape";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScreen::isLandscape(Qt::ScreenOrientation)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isLandscape(Qt::ScreenOrientation)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScreenFunc_isLandscape_TypeError;

    // Call function/method
    {
        ::Qt::ScreenOrientation cppArg0{Qt::PrimaryOrientation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isLandscape(Qt::ScreenOrientation)const
            bool cppResult = const_cast<const ::QScreen *>(cppSelf)->isLandscape(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScreenFunc_isLandscape_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScreenFunc_isPortrait(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.isPortrait";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScreen::isPortrait(Qt::ScreenOrientation)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isPortrait(Qt::ScreenOrientation)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScreenFunc_isPortrait_TypeError;

    // Call function/method
    {
        ::Qt::ScreenOrientation cppArg0{Qt::PrimaryOrientation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isPortrait(Qt::ScreenOrientation)const
            bool cppResult = const_cast<const ::QScreen *>(cppSelf)->isPortrait(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScreenFunc_isPortrait_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScreenFunc_logicalDotsPerInch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.logicalDotsPerInch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // logicalDotsPerInch()const
            qreal cppResult = const_cast<const ::QScreen *>(cppSelf)->logicalDotsPerInch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_logicalDotsPerInchX(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.logicalDotsPerInchX";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // logicalDotsPerInchX()const
            qreal cppResult = const_cast<const ::QScreen *>(cppSelf)->logicalDotsPerInchX();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_logicalDotsPerInchY(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.logicalDotsPerInchY";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // logicalDotsPerInchY()const
            qreal cppResult = const_cast<const ::QScreen *>(cppSelf)->logicalDotsPerInchY();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_manufacturer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.manufacturer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // manufacturer()const
            QString cppResult = const_cast<const ::QScreen *>(cppSelf)->manufacturer();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_mapBetween(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.mapBetween";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "mapBetween", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QScreen::mapBetween(Qt::ScreenOrientation,Qt::ScreenOrientation,QRect)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // mapBetween(Qt::ScreenOrientation,Qt::ScreenOrientation,QRect)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScreenFunc_mapBetween_TypeError;

    // Call function/method
    {
        ::Qt::ScreenOrientation cppArg0{Qt::PrimaryOrientation};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::ScreenOrientation cppArg1{Qt::PrimaryOrientation};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QRect cppArg2_local;
        ::QRect *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // mapBetween(Qt::ScreenOrientation,Qt::ScreenOrientation,QRect)const
            QRect cppResult = const_cast<const ::QScreen *>(cppSelf)->mapBetween(cppArg0, cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScreenFunc_mapBetween_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScreenFunc_model(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.model";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // model()const
            QString cppResult = const_cast<const ::QScreen *>(cppSelf)->model();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QScreen *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_nativeOrientation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.nativeOrientation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeOrientation()const
            Qt::ScreenOrientation cppResult = const_cast<const ::QScreen *>(cppSelf)->nativeOrientation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_orientation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.orientation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // orientation()const
            Qt::ScreenOrientation cppResult = const_cast<const ::QScreen *>(cppSelf)->orientation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_orientationUpdateMask(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.orientationUpdateMask";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // orientationUpdateMask()const
            QFlags<Qt::ScreenOrientation> cppResult = const_cast<const ::QScreen *>(cppSelf)->orientationUpdateMask();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_physicalDotsPerInch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.physicalDotsPerInch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // physicalDotsPerInch()const
            qreal cppResult = const_cast<const ::QScreen *>(cppSelf)->physicalDotsPerInch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_physicalDotsPerInchX(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.physicalDotsPerInchX";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // physicalDotsPerInchX()const
            qreal cppResult = const_cast<const ::QScreen *>(cppSelf)->physicalDotsPerInchX();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_physicalDotsPerInchY(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.physicalDotsPerInchY";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // physicalDotsPerInchY()const
            qreal cppResult = const_cast<const ::QScreen *>(cppSelf)->physicalDotsPerInchY();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_physicalSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.physicalSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // physicalSize()const
            QSizeF cppResult = const_cast<const ::QScreen *>(cppSelf)->physicalSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_primaryOrientation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.primaryOrientation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // primaryOrientation()const
            Qt::ScreenOrientation cppResult = const_cast<const ::QScreen *>(cppSelf)->primaryOrientation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_refreshRate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.refreshRate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // refreshRate()const
            qreal cppResult = const_cast<const ::QScreen *>(cppSelf)->refreshRate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_serialNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.serialNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // serialNumber()const
            QString cppResult = const_cast<const ::QScreen *>(cppSelf)->serialNumber();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_setOrientationUpdateMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.setOrientationUpdateMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScreen::setOrientationUpdateMask(QFlags<Qt::ScreenOrientation>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setOrientationUpdateMask(QFlags<Qt::ScreenOrientation>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScreenFunc_setOrientationUpdateMask_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::ScreenOrientation> cppArg0 = QFlags<Qt::ScreenOrientation>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOrientationUpdateMask(QFlags<Qt::ScreenOrientation>)
            cppSelf->setOrientationUpdateMask(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScreenFunc_setOrientationUpdateMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScreenFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            QSize cppResult = const_cast<const ::QScreen *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_transformBetween(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.transformBetween";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "transformBetween", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QScreen::transformBetween(Qt::ScreenOrientation,Qt::ScreenOrientation,QRect)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // transformBetween(Qt::ScreenOrientation,Qt::ScreenOrientation,QRect)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScreenFunc_transformBetween_TypeError;

    // Call function/method
    {
        ::Qt::ScreenOrientation cppArg0{Qt::PrimaryOrientation};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::ScreenOrientation cppArg1{Qt::PrimaryOrientation};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QRect cppArg2_local;
        ::QRect *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // transformBetween(Qt::ScreenOrientation,Qt::ScreenOrientation,QRect)const
            QTransform cppResult = const_cast<const ::QScreen *>(cppSelf)->transformBetween(cppArg0, cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScreenFunc_transformBetween_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScreenFunc_virtualGeometry(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.virtualGeometry";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // virtualGeometry()const
            QRect cppResult = const_cast<const ::QScreen *>(cppSelf)->virtualGeometry();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_virtualSiblingAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.virtualSiblingAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScreen::virtualSiblingAt(QPoint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // virtualSiblingAt(QPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScreenFunc_virtualSiblingAt_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // virtualSiblingAt(QPoint)
            QScreen * cppResult = cppSelf->virtualSiblingAt(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScreenFunc_virtualSiblingAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScreenFunc_virtualSiblings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.virtualSiblings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // virtualSiblings()const
            QList<QScreen* > cppResult = const_cast<const ::QScreen *>(cppSelf)->virtualSiblings();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSCREENPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScreenFunc_virtualSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScreen.virtualSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // virtualSize()const
            QSize cppResult = const_cast<const ::QScreen *>(cppSelf)->virtualSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QScreen_PropertyStrings[] = {
    "availableGeometry:",
    "availableSize:",
    "availableVirtualGeometry:",
    "availableVirtualSize:",
    "depth:",
    "devicePixelRatio:",
    "geometry:",
    "logicalDotsPerInch:",
    "logicalDotsPerInchX:",
    "logicalDotsPerInchY:",
    "manufacturer:",
    "model:",
    "name:",
    "nativeOrientation:",
    "orientation:",
    "physicalDotsPerInch:",
    "physicalDotsPerInchX:",
    "physicalDotsPerInchY:",
    "physicalSize:",
    "primaryOrientation:",
    "refreshRate:",
    "serialNumber:",
    "size:",
    "virtualGeometry:",
    "virtualSize:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScreen_methods[] = {
    {"angleBetween", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_angleBetween), METH_VARARGS},
    {"availableGeometry", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_availableGeometry), METH_NOARGS},
    {"availableSize", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_availableSize), METH_NOARGS},
    {"availableVirtualGeometry", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_availableVirtualGeometry), METH_NOARGS},
    {"availableVirtualSize", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_availableVirtualSize), METH_NOARGS},
    {"depth", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_depth), METH_NOARGS},
    {"devicePixelRatio", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_devicePixelRatio), METH_NOARGS},
    {"geometry", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_geometry), METH_NOARGS},
    {"grabWindow", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_grabWindow), METH_VARARGS|METH_KEYWORDS},
    {"isLandscape", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_isLandscape), METH_O},
    {"isPortrait", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_isPortrait), METH_O},
    {"logicalDotsPerInch", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_logicalDotsPerInch), METH_NOARGS},
    {"logicalDotsPerInchX", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_logicalDotsPerInchX), METH_NOARGS},
    {"logicalDotsPerInchY", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_logicalDotsPerInchY), METH_NOARGS},
    {"manufacturer", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_manufacturer), METH_NOARGS},
    {"mapBetween", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_mapBetween), METH_VARARGS},
    {"model", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_model), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_name), METH_NOARGS},
    {"nativeOrientation", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_nativeOrientation), METH_NOARGS},
    {"orientation", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_orientation), METH_NOARGS},
    {"orientationUpdateMask", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_orientationUpdateMask), METH_NOARGS},
    {"physicalDotsPerInch", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_physicalDotsPerInch), METH_NOARGS},
    {"physicalDotsPerInchX", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_physicalDotsPerInchX), METH_NOARGS},
    {"physicalDotsPerInchY", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_physicalDotsPerInchY), METH_NOARGS},
    {"physicalSize", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_physicalSize), METH_NOARGS},
    {"primaryOrientation", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_primaryOrientation), METH_NOARGS},
    {"refreshRate", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_refreshRate), METH_NOARGS},
    {"serialNumber", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_serialNumber), METH_NOARGS},
    {"setOrientationUpdateMask", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_setOrientationUpdateMask), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_size), METH_NOARGS},
    {"transformBetween", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_transformBetween), METH_VARARGS},
    {"virtualGeometry", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_virtualGeometry), METH_NOARGS},
    {"virtualSiblingAt", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_virtualSiblingAt), METH_O},
    {"virtualSiblings", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_virtualSiblings), METH_NOARGS},
    {"virtualSize", reinterpret_cast<PyCFunction>(Sbk_QScreenFunc_virtualSize), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QScreen_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QScreenWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QScreen_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScreen_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QScreen__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScreen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScreen_Type = nullptr;
static SbkObjectType *Sbk_QScreen_TypeF(void)
{
    return _Sbk_QScreen_Type;
}

static PyType_Slot Sbk_QScreen_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QScreen__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QScreen_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScreen_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScreen_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScreen_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScreen_spec = {
    "2:PySide2.QtGui.QScreen",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScreen_slots
};

} //extern "C"

static void *Sbk_QScreen_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QScreen *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScreen_PythonToCpp_QScreen_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScreen_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScreen_PythonToCpp_QScreen_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScreen_TypeF())))
        return QScreen_PythonToCpp_QScreen_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScreen_PTR_CppToPython_QScreen(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QScreen *>(const_cast<void *>(cppIn)), Sbk_QScreen_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScreen_SignatureStrings[] = {
    "PySide2.QtGui.QScreen.angleBetween(self,a:PySide2.QtCore.Qt.ScreenOrientation,b:PySide2.QtCore.Qt.ScreenOrientation)->int",
    "PySide2.QtGui.QScreen.availableGeometry(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QScreen.availableSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QScreen.availableVirtualGeometry(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QScreen.availableVirtualSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QScreen.depth(self)->int",
    "PySide2.QtGui.QScreen.devicePixelRatio(self)->qreal",
    "PySide2.QtGui.QScreen.geometry(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QScreen.grabWindow(self,window:WId,x:int=0,y:int=0,w:int=-1,h:int=-1)->PySide2.QtGui.QPixmap",
    "PySide2.QtGui.QScreen.isLandscape(self,orientation:PySide2.QtCore.Qt.ScreenOrientation)->bool",
    "PySide2.QtGui.QScreen.isPortrait(self,orientation:PySide2.QtCore.Qt.ScreenOrientation)->bool",
    "PySide2.QtGui.QScreen.logicalDotsPerInch(self)->qreal",
    "PySide2.QtGui.QScreen.logicalDotsPerInchX(self)->qreal",
    "PySide2.QtGui.QScreen.logicalDotsPerInchY(self)->qreal",
    "PySide2.QtGui.QScreen.manufacturer(self)->QString",
    "PySide2.QtGui.QScreen.mapBetween(self,a:PySide2.QtCore.Qt.ScreenOrientation,b:PySide2.QtCore.Qt.ScreenOrientation,rect:PySide2.QtCore.QRect)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QScreen.model(self)->QString",
    "PySide2.QtGui.QScreen.name(self)->QString",
    "PySide2.QtGui.QScreen.nativeOrientation(self)->PySide2.QtCore.Qt.ScreenOrientation",
    "PySide2.QtGui.QScreen.orientation(self)->PySide2.QtCore.Qt.ScreenOrientation",
    "PySide2.QtGui.QScreen.orientationUpdateMask(self)->PySide2.QtCore.Qt.ScreenOrientations",
    "PySide2.QtGui.QScreen.physicalDotsPerInch(self)->qreal",
    "PySide2.QtGui.QScreen.physicalDotsPerInchX(self)->qreal",
    "PySide2.QtGui.QScreen.physicalDotsPerInchY(self)->qreal",
    "PySide2.QtGui.QScreen.physicalSize(self)->PySide2.QtCore.QSizeF",
    "PySide2.QtGui.QScreen.primaryOrientation(self)->PySide2.QtCore.Qt.ScreenOrientation",
    "PySide2.QtGui.QScreen.refreshRate(self)->qreal",
    "PySide2.QtGui.QScreen.serialNumber(self)->QString",
    "PySide2.QtGui.QScreen.setOrientationUpdateMask(self,mask:PySide2.QtCore.Qt.ScreenOrientations)",
    "PySide2.QtGui.QScreen.size(self)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QScreen.transformBetween(self,a:PySide2.QtCore.Qt.ScreenOrientation,b:PySide2.QtCore.Qt.ScreenOrientation,target:PySide2.QtCore.QRect)->PySide2.QtGui.QTransform",
    "PySide2.QtGui.QScreen.virtualGeometry(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QScreen.virtualSiblingAt(self,point:PySide2.QtCore.QPoint)->PySide2.QtGui.QScreen",
    "PySide2.QtGui.QScreen.virtualSiblings(self)->QList[PySide2.QtGui.QScreen]",
    "PySide2.QtGui.QScreen.virtualSize(self)->PySide2.QtCore.QSize",
    nullptr}; // Sentinel

void init_QScreen(PyObject *module)
{
    _Sbk_QScreen_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScreen",
        "QScreen*",
        &Sbk_QScreen_spec,
        &Shiboken::callCppDestructor< ::QScreen >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScreen_Type);
    InitSignatureStrings(pyType, QScreen_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScreen_Type), Sbk_QScreen_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScreen_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScreen_TypeF(),
        QScreen_PythonToCpp_QScreen_PTR,
        is_QScreen_PythonToCpp_QScreen_PTR_Convertible,
        QScreen_PTR_CppToPython_QScreen);

    Shiboken::Conversions::registerConverterName(converter, "QScreen");
    Shiboken::Conversions::registerConverterName(converter, "QScreen*");
    Shiboken::Conversions::registerConverterName(converter, "QScreen&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScreen).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScreenWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QScreen_TypeF(), &Sbk_QScreen_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QScreen_TypeF(), &::QScreen::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QScreen_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QScreen_TypeF(), &::QScreen::staticMetaObject, sizeof(QScreenWrapper));
}
