/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qscrollevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QScrollEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QScrollEventWrapper::QScrollEventWrapper(const ::QPointF & contentPos, const ::QPointF & overshoot, ::QScrollEvent::ScrollState scrollState) : QScrollEvent(contentPos, overshoot, scrollState)
{
    resetPyMethodCache();
    // ... middle
}

QScrollEventWrapper::~QScrollEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScrollEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScrollEvent >()))
        return -1;

    ::QScrollEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScrollEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QScrollEvent", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QScrollEvent::QScrollEvent(QPointF,QPointF,QScrollEvent::ScrollState)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_SCROLLSTATE_IDX])->converter, (pyArgs[2])))) {
        overloadId = 0; // QScrollEvent(QPointF,QPointF,QScrollEvent::ScrollState)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollEvent_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QPointF cppArg1_local;
        ::QPointF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QScrollEvent::ScrollState cppArg2{QScrollEvent::ScrollStarted};
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // QScrollEvent(QPointF,QPointF,QScrollEvent::ScrollState)
            cptr = new ::QScrollEventWrapper(*cppArg0, *cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScrollEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QScrollEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QScrollEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QScrollEventFunc_contentPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScrollEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScrollEvent.contentPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contentPos()const
            QPointF cppResult = const_cast<const ::QScrollEvent *>(cppSelf)->contentPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScrollEventFunc_overshootDistance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScrollEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScrollEvent.overshootDistance";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // overshootDistance()const
            QPointF cppResult = const_cast<const ::QScrollEvent *>(cppSelf)->overshootDistance();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScrollEventFunc_scrollState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScrollEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QScrollEvent.scrollState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scrollState()const
            QScrollEvent::ScrollState cppResult = const_cast<const ::QScrollEvent *>(cppSelf)->scrollState();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_SCROLLSTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QScrollEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScrollEvent_methods[] = {
    {"contentPos", reinterpret_cast<PyCFunction>(Sbk_QScrollEventFunc_contentPos), METH_NOARGS},
    {"overshootDistance", reinterpret_cast<PyCFunction>(Sbk_QScrollEventFunc_overshootDistance), METH_NOARGS},
    {"scrollState", reinterpret_cast<PyCFunction>(Sbk_QScrollEventFunc_scrollState), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QScrollEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QScrollEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QScrollEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QScrollEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScrollEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScrollEvent_Type = nullptr;
static SbkObjectType *Sbk_QScrollEvent_TypeF(void)
{
    return _Sbk_QScrollEvent_Type;
}

static PyType_Slot Sbk_QScrollEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QScrollEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScrollEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScrollEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScrollEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScrollEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScrollEvent_spec = {
    "2:PySide2.QtGui.QScrollEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScrollEvent_slots
};

} //extern "C"

static void *Sbk_QScrollEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QScrollEvent *>(cptr)->type() == QEvent::Scroll)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QScrollEvent_ScrollState_PythonToCpp_QScrollEvent_ScrollState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScrollEvent::ScrollState *>(cppOut) =
        static_cast<::QScrollEvent::ScrollState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScrollEvent_ScrollState_PythonToCpp_QScrollEvent_ScrollState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_SCROLLSTATE_IDX]))
        return QScrollEvent_ScrollState_PythonToCpp_QScrollEvent_ScrollState;
    return {};
}
static PyObject *QScrollEvent_ScrollState_CppToPython_QScrollEvent_ScrollState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScrollEvent::ScrollState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_SCROLLSTATE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScrollEvent_PythonToCpp_QScrollEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScrollEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScrollEvent_PythonToCpp_QScrollEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScrollEvent_TypeF())))
        return QScrollEvent_PythonToCpp_QScrollEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScrollEvent_PTR_CppToPython_QScrollEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScrollEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScrollEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScrollEvent_SignatureStrings[] = {
    "PySide2.QtGui.QScrollEvent(self,contentPos:PySide2.QtCore.QPointF,overshoot:PySide2.QtCore.QPointF,scrollState:PySide2.QtGui.QScrollEvent.ScrollState)",
    "PySide2.QtGui.QScrollEvent.contentPos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QScrollEvent.overshootDistance(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QScrollEvent.scrollState(self)->PySide2.QtGui.QScrollEvent.ScrollState",
    nullptr}; // Sentinel

void init_QScrollEvent(PyObject *module)
{
    _Sbk_QScrollEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScrollEvent",
        "QScrollEvent*",
        &Sbk_QScrollEvent_spec,
        &Shiboken::callCppDestructor< ::QScrollEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScrollEvent_Type);
    InitSignatureStrings(pyType, QScrollEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScrollEvent_Type), Sbk_QScrollEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScrollEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScrollEvent_TypeF(),
        QScrollEvent_PythonToCpp_QScrollEvent_PTR,
        is_QScrollEvent_PythonToCpp_QScrollEvent_PTR_Convertible,
        QScrollEvent_PTR_CppToPython_QScrollEvent);

    Shiboken::Conversions::registerConverterName(converter, "QScrollEvent");
    Shiboken::Conversions::registerConverterName(converter, "QScrollEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QScrollEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScrollEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScrollEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QScrollEvent_TypeF(), &Sbk_QScrollEvent_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ScrollState'.
    SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_SCROLLSTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScrollEvent_TypeF(),
        "ScrollState",
        "2:PySide2.QtGui.QScrollEvent.ScrollState",
        "QScrollEvent::ScrollState");
    if (!SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_SCROLLSTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_SCROLLSTATE_IDX],
        Sbk_QScrollEvent_TypeF(), "ScrollStarted", (long) QScrollEvent::ScrollState::ScrollStarted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_SCROLLSTATE_IDX],
        Sbk_QScrollEvent_TypeF(), "ScrollUpdated", (long) QScrollEvent::ScrollState::ScrollUpdated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_SCROLLSTATE_IDX],
        Sbk_QScrollEvent_TypeF(), "ScrollFinished", (long) QScrollEvent::ScrollState::ScrollFinished))
        return;
    // Register converter for enum 'QScrollEvent::ScrollState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_SCROLLSTATE_IDX],
            QScrollEvent_ScrollState_CppToPython_QScrollEvent_ScrollState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScrollEvent_ScrollState_PythonToCpp_QScrollEvent_ScrollState,
            is_QScrollEvent_ScrollState_PythonToCpp_QScrollEvent_ScrollState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QSCROLLEVENT_SCROLLSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScrollEvent::ScrollState");
        Shiboken::Conversions::registerConverterName(converter, "ScrollState");
    }
    // End of 'ScrollState' enum.

    qRegisterMetaType< ::QScrollEvent::ScrollState >("QScrollEvent::ScrollState");
}
