/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qsessionmanager_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QSessionManagerFunc_allowsErrorInteraction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.allowsErrorInteraction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allowsErrorInteraction()
            bool cppResult = cppSelf->allowsErrorInteraction();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSessionManagerFunc_allowsInteraction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.allowsInteraction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allowsInteraction()
            bool cppResult = cppSelf->allowsInteraction();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSessionManagerFunc_cancel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.cancel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cancel()
            cppSelf->cancel();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSessionManagerFunc_discardCommand(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.discardCommand";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // discardCommand()const
            QStringList cppResult = const_cast<const ::QSessionManager *>(cppSelf)->discardCommand();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSessionManagerFunc_isPhase2(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.isPhase2";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPhase2()const
            bool cppResult = const_cast<const ::QSessionManager *>(cppSelf)->isPhase2();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSessionManagerFunc_release(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.release";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // release()
            cppSelf->release();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSessionManagerFunc_requestPhase2(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.requestPhase2";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // requestPhase2()
            cppSelf->requestPhase2();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSessionManagerFunc_restartCommand(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.restartCommand";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // restartCommand()const
            QStringList cppResult = const_cast<const ::QSessionManager *>(cppSelf)->restartCommand();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSessionManagerFunc_restartHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.restartHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // restartHint()const
            QSessionManager::RestartHint cppResult = const_cast<const ::QSessionManager *>(cppSelf)->restartHint();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSessionManagerFunc_sessionId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.sessionId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sessionId()const
            QString cppResult = const_cast<const ::QSessionManager *>(cppSelf)->sessionId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSessionManagerFunc_sessionKey(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.sessionKey";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sessionKey()const
            QString cppResult = const_cast<const ::QSessionManager *>(cppSelf)->sessionKey();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSessionManagerFunc_setDiscardCommand(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.setDiscardCommand";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSessionManager::setDiscardCommand(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setDiscardCommand(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSessionManagerFunc_setDiscardCommand_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDiscardCommand(QStringList)
            cppSelf->setDiscardCommand(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSessionManagerFunc_setDiscardCommand_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSessionManagerFunc_setManagerProperty(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.setManagerProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setManagerProperty", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSessionManager::setManagerProperty(QString,QString)
    // 1: QSessionManager::setManagerProperty(QString,QStringList)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
            overloadId = 1; // setManagerProperty(QString,QStringList)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // setManagerProperty(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSessionManagerFunc_setManagerProperty_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setManagerProperty(const QString & name, const QString & value)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setManagerProperty(QString,QString)
                cppSelf->setManagerProperty(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setManagerProperty(const QString & name, const QStringList & value)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setManagerProperty(QString,QStringList)
                cppSelf->setManagerProperty(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSessionManagerFunc_setManagerProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSessionManagerFunc_setRestartCommand(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.setRestartCommand";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSessionManager::setRestartCommand(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setRestartCommand(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSessionManagerFunc_setRestartCommand_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRestartCommand(QStringList)
            cppSelf->setRestartCommand(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSessionManagerFunc_setRestartCommand_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSessionManagerFunc_setRestartHint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSessionManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSessionManager.setRestartHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSessionManager::setRestartHint(QSessionManager::RestartHint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setRestartHint(QSessionManager::RestartHint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSessionManagerFunc_setRestartHint_TypeError;

    // Call function/method
    {
        ::QSessionManager::RestartHint cppArg0{QSessionManager::RestartIfRunning};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRestartHint(QSessionManager::RestartHint)
            cppSelf->setRestartHint(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSessionManagerFunc_setRestartHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QSessionManager_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSessionManager_methods[] = {
    {"allowsErrorInteraction", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_allowsErrorInteraction), METH_NOARGS},
    {"allowsInteraction", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_allowsInteraction), METH_NOARGS},
    {"cancel", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_cancel), METH_NOARGS},
    {"discardCommand", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_discardCommand), METH_NOARGS},
    {"isPhase2", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_isPhase2), METH_NOARGS},
    {"release", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_release), METH_NOARGS},
    {"requestPhase2", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_requestPhase2), METH_NOARGS},
    {"restartCommand", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_restartCommand), METH_NOARGS},
    {"restartHint", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_restartHint), METH_NOARGS},
    {"sessionId", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_sessionId), METH_NOARGS},
    {"sessionKey", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_sessionKey), METH_NOARGS},
    {"setDiscardCommand", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_setDiscardCommand), METH_O},
    {"setManagerProperty", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_setManagerProperty), METH_VARARGS},
    {"setRestartCommand", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_setRestartCommand), METH_O},
    {"setRestartHint", reinterpret_cast<PyCFunction>(Sbk_QSessionManagerFunc_setRestartHint), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSessionManager_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSessionManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSessionManager_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSessionManager_Type = nullptr;
static SbkObjectType *Sbk_QSessionManager_TypeF(void)
{
    return _Sbk_QSessionManager_Type;
}

static PyType_Slot Sbk_QSessionManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(SbkDeallocWrapperWithPrivateDtor)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSessionManager_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSessionManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSessionManager_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSessionManager_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSessionManager_spec = {
    "2:PySide2.QtGui.QSessionManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSessionManager_slots
};

} //extern "C"

static void *Sbk_QSessionManager_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QSessionManager *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QSessionManager_RestartHint_PythonToCpp_QSessionManager_RestartHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSessionManager::RestartHint *>(cppOut) =
        static_cast<::QSessionManager::RestartHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSessionManager_RestartHint_PythonToCpp_QSessionManager_RestartHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX]))
        return QSessionManager_RestartHint_PythonToCpp_QSessionManager_RestartHint;
    return {};
}
static PyObject *QSessionManager_RestartHint_CppToPython_QSessionManager_RestartHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSessionManager::RestartHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSessionManager_PythonToCpp_QSessionManager_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSessionManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSessionManager_PythonToCpp_QSessionManager_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSessionManager_TypeF())))
        return QSessionManager_PythonToCpp_QSessionManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSessionManager_PTR_CppToPython_QSessionManager(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QSessionManager *>(const_cast<void *>(cppIn)), Sbk_QSessionManager_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSessionManager_SignatureStrings[] = {
    "PySide2.QtGui.QSessionManager.allowsErrorInteraction(self)->bool",
    "PySide2.QtGui.QSessionManager.allowsInteraction(self)->bool",
    "PySide2.QtGui.QSessionManager.cancel(self)",
    "PySide2.QtGui.QSessionManager.discardCommand(self)->QStringList",
    "PySide2.QtGui.QSessionManager.isPhase2(self)->bool",
    "PySide2.QtGui.QSessionManager.release(self)",
    "PySide2.QtGui.QSessionManager.requestPhase2(self)",
    "PySide2.QtGui.QSessionManager.restartCommand(self)->QStringList",
    "PySide2.QtGui.QSessionManager.restartHint(self)->PySide2.QtGui.QSessionManager.RestartHint",
    "PySide2.QtGui.QSessionManager.sessionId(self)->QString",
    "PySide2.QtGui.QSessionManager.sessionKey(self)->QString",
    "PySide2.QtGui.QSessionManager.setDiscardCommand(self,arg__1:QStringList)",
    "1:PySide2.QtGui.QSessionManager.setManagerProperty(self,name:QString,value:QString)",
    "0:PySide2.QtGui.QSessionManager.setManagerProperty(self,name:QString,value:QStringList)",
    "PySide2.QtGui.QSessionManager.setRestartCommand(self,arg__1:QStringList)",
    "PySide2.QtGui.QSessionManager.setRestartHint(self,arg__1:PySide2.QtGui.QSessionManager.RestartHint)",
    nullptr}; // Sentinel

void init_QSessionManager(PyObject *module)
{
    _Sbk_QSessionManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSessionManager",
        "QSessionManager*",
        &Sbk_QSessionManager_spec,
        0,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSessionManager_Type);
    InitSignatureStrings(pyType, QSessionManager_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSessionManager_Type), Sbk_QSessionManager_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSessionManager_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSessionManager_TypeF(),
        QSessionManager_PythonToCpp_QSessionManager_PTR,
        is_QSessionManager_PythonToCpp_QSessionManager_PTR_Convertible,
        QSessionManager_PTR_CppToPython_QSessionManager);

    Shiboken::Conversions::registerConverterName(converter, "QSessionManager");
    Shiboken::Conversions::registerConverterName(converter, "QSessionManager*");
    Shiboken::Conversions::registerConverterName(converter, "QSessionManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSessionManager).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSessionManager_TypeF(), &Sbk_QSessionManager_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'RestartHint'.
    SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSessionManager_TypeF(),
        "RestartHint",
        "2:PySide2.QtGui.QSessionManager.RestartHint",
        "QSessionManager::RestartHint");
    if (!SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX],
        Sbk_QSessionManager_TypeF(), "RestartIfRunning", (long) QSessionManager::RestartHint::RestartIfRunning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX],
        Sbk_QSessionManager_TypeF(), "RestartAnyway", (long) QSessionManager::RestartHint::RestartAnyway))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX],
        Sbk_QSessionManager_TypeF(), "RestartImmediately", (long) QSessionManager::RestartHint::RestartImmediately))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX],
        Sbk_QSessionManager_TypeF(), "RestartNever", (long) QSessionManager::RestartHint::RestartNever))
        return;
    // Register converter for enum 'QSessionManager::RestartHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX],
            QSessionManager_RestartHint_CppToPython_QSessionManager_RestartHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSessionManager_RestartHint_PythonToCpp_QSessionManager_RestartHint,
            is_QSessionManager_RestartHint_PythonToCpp_QSessionManager_RestartHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSessionManager::RestartHint");
        Shiboken::Conversions::registerConverterName(converter, "RestartHint");
    }
    // End of 'RestartHint' enum.

    PySide::Signal::registerSignals(Sbk_QSessionManager_TypeF(), &::QSessionManager::staticMetaObject);
    qRegisterMetaType< ::QSessionManager::RestartHint >("QSessionManager::RestartHint");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QSessionManager_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QSessionManager_TypeF(), &::QSessionManager::staticMetaObject, sizeof(::QSessionManager));
}
