/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qsurface_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSurfaceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSurfaceWrapper::QSurfaceWrapper(::QSurface::SurfaceClass type) : QSurface(type)
{
    resetPyMethodCache();
    // ... middle
}

::QSurfaceFormat QSurfaceWrapper::format() const
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSurface.format()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "format";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSurface.format()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSurface.format", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSurfaceFormat >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSurfaceFormat cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QSurfaceWrapper::size() const
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSurface.size()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "size";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSurface.size()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSurface.size", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPlatformSurface * QSurfaceWrapper::surfaceHandle() const
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSurface.surfaceHandle()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "surfaceHandle";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSurface.surfaceHandle()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<QPlatformSurface>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSurface.surfaceHandle", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPlatformSurface >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPlatformSurface *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSurface::SurfaceType QSurfaceWrapper::surfaceType() const
{
    if (m_PyMethodCache[3]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSurface.surfaceType()' not implemented.");
        return QSurface::RasterSurface;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QSurface::RasterSurface;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "surfaceType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSurface.surfaceType()' not implemented.");
        return QSurface::RasterSurface;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QSurface::RasterSurface;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSurface.surfaceType", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSurface::SurfaceType >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QSurface::RasterSurface;
    }
    ::QSurface::SurfaceType cppResult{QSurface::RasterSurface};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QSurfaceWrapper::~QSurfaceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSurface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QSurface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSurface >()))
        return -1;

    ::QSurfaceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurface.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSurface", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSurface::QSurface(QSurface::SurfaceClass)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACECLASS_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QSurface(QSurface::SurfaceClass)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurface_Init_TypeError;

    // Call function/method
    {
        ::QSurface::SurfaceClass cppArg0{QSurface::Window};
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QSurface(QSurface::SurfaceClass)
            cptr = new ::QSurfaceWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSurface >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSurface_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSurface_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSurfaceFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurface.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSurface.format()' not implemented.");
                return {};
            }
            QSurfaceFormat cppResult = const_cast<const ::QSurface *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurface.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSurface.size()' not implemented.");
                return {};
            }
            QSize cppResult = const_cast<const ::QSurface *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFunc_supportsOpenGL(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurface.supportsOpenGL";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsOpenGL()const
            bool cppResult = const_cast<const ::QSurface *>(cppSelf)->supportsOpenGL();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFunc_surfaceClass(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurface.surfaceClass";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // surfaceClass()const
            QSurface::SurfaceClass cppResult = const_cast<const ::QSurface *>(cppSelf)->surfaceClass();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACECLASS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFunc_surfaceHandle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurface.surfaceHandle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // surfaceHandle()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSurface.surfaceHandle()' not implemented.");
                return {};
            }
            QPlatformSurface * cppResult = const_cast<const ::QSurface *>(cppSelf)->surfaceHandle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<QPlatformSurface>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFunc_surfaceType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurface.surfaceType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // surfaceType()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSurface.surfaceType()' not implemented.");
                return {};
            }
            QSurface::SurfaceType cppResult = const_cast<const ::QSurface *>(cppSelf)->surfaceType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSurface_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSurface_methods[] = {
    {"format", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFunc_format), METH_NOARGS},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFunc_size), METH_NOARGS},
    {"supportsOpenGL", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFunc_supportsOpenGL), METH_NOARGS},
    {"surfaceClass", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFunc_surfaceClass), METH_NOARGS},
    {"surfaceHandle", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFunc_surfaceHandle), METH_NOARGS},
    {"surfaceType", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFunc_surfaceType), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSurface_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSurfaceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

static PyObject *Sbk_QSurface_get_m_type(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QSurface::SurfaceClass cppOut_local = cppSelf->m_type;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACECLASS_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QSurface_set_m_type(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSurface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'m_type' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACECLASS_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'm_type', 'SurfaceClass' or convertible type expected");
        return -1;
    }

    ::QSurface::SurfaceClass cppOut_local = cppSelf->m_type;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->m_type = cppOut_local;

    return 0;
}

// Getters and Setters for QSurface
static PyGetSetDef Sbk_QSurface_getsetlist[] = {
    {const_cast<char *>("m_type"), Sbk_QSurface_get_m_type, Sbk_QSurface_set_m_type},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QSurface_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSurface_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSurface_Type = nullptr;
static SbkObjectType *Sbk_QSurface_TypeF(void)
{
    return _Sbk_QSurface_Type;
}

static PyType_Slot Sbk_QSurface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSurface_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSurface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSurface_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSurface_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QSurface_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSurface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSurface_spec = {
    "2:PySide2.QtGui.QSurface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSurface_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QSurface_SurfaceClass_PythonToCpp_QSurface_SurfaceClass(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSurface::SurfaceClass *>(cppOut) =
        static_cast<::QSurface::SurfaceClass>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSurface_SurfaceClass_PythonToCpp_QSurface_SurfaceClass_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACECLASS_IDX]))
        return QSurface_SurfaceClass_PythonToCpp_QSurface_SurfaceClass;
    return {};
}
static PyObject *QSurface_SurfaceClass_CppToPython_QSurface_SurfaceClass(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSurface::SurfaceClass *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACECLASS_IDX], castCppIn);

}

static void QSurface_SurfaceType_PythonToCpp_QSurface_SurfaceType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSurface::SurfaceType *>(cppOut) =
        static_cast<::QSurface::SurfaceType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSurface_SurfaceType_PythonToCpp_QSurface_SurfaceType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX]))
        return QSurface_SurfaceType_PythonToCpp_QSurface_SurfaceType;
    return {};
}
static PyObject *QSurface_SurfaceType_CppToPython_QSurface_SurfaceType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSurface::SurfaceType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSurface_PythonToCpp_QSurface_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSurface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSurface_PythonToCpp_QSurface_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSurface_TypeF())))
        return QSurface_PythonToCpp_QSurface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSurface_PTR_CppToPython_QSurface(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSurface *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSurface_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSurface_SignatureStrings[] = {
    "PySide2.QtGui.QSurface(self,type:PySide2.QtGui.QSurface.SurfaceClass)",
    "PySide2.QtGui.QSurface.format(self)->PySide2.QtGui.QSurfaceFormat",
    "PySide2.QtGui.QSurface.size(self)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QSurface.supportsOpenGL(self)->bool",
    "PySide2.QtGui.QSurface.surfaceClass(self)->PySide2.QtGui.QSurface.SurfaceClass",
    "PySide2.QtGui.QSurface.surfaceHandle(self)->QPlatformSurface*",
    "PySide2.QtGui.QSurface.surfaceType(self)->PySide2.QtGui.QSurface.SurfaceType",
    nullptr}; // Sentinel

void init_QSurface(PyObject *module)
{
    _Sbk_QSurface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSurface",
        "QSurface*",
        &Sbk_QSurface_spec,
        &Shiboken::callCppDestructor< ::QSurface >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSurface_Type);
    InitSignatureStrings(pyType, QSurface_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSurface_Type), Sbk_QSurface_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSurface_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSurface_TypeF(),
        QSurface_PythonToCpp_QSurface_PTR,
        is_QSurface_PythonToCpp_QSurface_PTR_Convertible,
        QSurface_PTR_CppToPython_QSurface);

    Shiboken::Conversions::registerConverterName(converter, "QSurface");
    Shiboken::Conversions::registerConverterName(converter, "QSurface*");
    Shiboken::Conversions::registerConverterName(converter, "QSurface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSurface).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSurfaceWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'SurfaceClass'.
    SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACECLASS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSurface_TypeF(),
        "SurfaceClass",
        "2:PySide2.QtGui.QSurface.SurfaceClass",
        "QSurface::SurfaceClass");
    if (!SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACECLASS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACECLASS_IDX],
        Sbk_QSurface_TypeF(), "Window", (long) QSurface::SurfaceClass::Window))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACECLASS_IDX],
        Sbk_QSurface_TypeF(), "Offscreen", (long) QSurface::SurfaceClass::Offscreen))
        return;
    // Register converter for enum 'QSurface::SurfaceClass'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACECLASS_IDX],
            QSurface_SurfaceClass_CppToPython_QSurface_SurfaceClass);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSurface_SurfaceClass_PythonToCpp_QSurface_SurfaceClass,
            is_QSurface_SurfaceClass_PythonToCpp_QSurface_SurfaceClass_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACECLASS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSurface::SurfaceClass");
        Shiboken::Conversions::registerConverterName(converter, "SurfaceClass");
    }
    // End of 'SurfaceClass' enum.

    // Initialization of enum 'SurfaceType'.
    SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSurface_TypeF(),
        "SurfaceType",
        "2:PySide2.QtGui.QSurface.SurfaceType",
        "QSurface::SurfaceType");
    if (!SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX],
        Sbk_QSurface_TypeF(), "RasterSurface", (long) QSurface::SurfaceType::RasterSurface))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX],
        Sbk_QSurface_TypeF(), "OpenGLSurface", (long) QSurface::SurfaceType::OpenGLSurface))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX],
        Sbk_QSurface_TypeF(), "RasterGLSurface", (long) QSurface::SurfaceType::RasterGLSurface))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX],
        Sbk_QSurface_TypeF(), "OpenVGSurface", (long) QSurface::SurfaceType::OpenVGSurface))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX],
        Sbk_QSurface_TypeF(), "VulkanSurface", (long) QSurface::SurfaceType::VulkanSurface))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX],
        Sbk_QSurface_TypeF(), "MetalSurface", (long) QSurface::SurfaceType::MetalSurface))
        return;
    // Register converter for enum 'QSurface::SurfaceType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX],
            QSurface_SurfaceType_CppToPython_QSurface_SurfaceType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSurface_SurfaceType_PythonToCpp_QSurface_SurfaceType,
            is_QSurface_SurfaceType_PythonToCpp_QSurface_SurfaceType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSurface::SurfaceType");
        Shiboken::Conversions::registerConverterName(converter, "SurfaceType");
    }
    // End of 'SurfaceType' enum.

    qRegisterMetaType< ::QSurface::SurfaceClass >("QSurface::SurfaceClass");
    qRegisterMetaType< ::QSurface::SurfaceType >("QSurface::SurfaceType");
}
