/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextframeformat_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QVector>
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <QtGui/qpen.h>
#include <QtGui/qtextformat.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextFrameFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextFrameFormat >()))
        return -1;

    ::QTextFrameFormat *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QTextFrameFormat", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTextFrameFormat::QTextFrameFormat()
    // 1: QTextFrameFormat::QTextFrameFormat(QTextFormat)
    // 2: QTextFrameFormat::QTextFrameFormat(QTextFrameFormat)
    if (numArgs == 0) {
        overloadId = 0; // QTextFrameFormat()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QTextFrameFormat(QTextFrameFormat)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QTextFrameFormat(QTextFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormat_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextFrameFormat()
        {

            if (!PyErr_Occurred()) {
                // QTextFrameFormat()
                cptr = new ::QTextFrameFormat();
            }
            break;
        }
        case 1: // QTextFrameFormat(const QTextFormat & fmt)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextFormat cppArg0_local;
            ::QTextFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextFrameFormat(QTextFormat)
                cptr = new ::QTextFrameFormat(*cppArg0);
            }
            break;
        }
        case 2: // QTextFrameFormat(const QTextFrameFormat & QTextFrameFormat)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextFrameFormat cppArg0_local;
            ::QTextFrameFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextFrameFormat(QTextFrameFormat)
                cptr = new ::QTextFrameFormat(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextFrameFormat >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextFrameFormat_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextFrameFormat_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextFrameFormatFunc_border(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.border";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // border()const
            qreal cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->border();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_borderBrush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.borderBrush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // borderBrush()const
            QBrush cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->borderBrush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_borderStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.borderStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // borderStyle()const
            QTextFrameFormat::BorderStyle cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->borderStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_bottomMargin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.bottomMargin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bottomMargin()const
            qreal cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->bottomMargin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            QTextLength cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLENGTH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_leftMargin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.leftMargin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // leftMargin()const
            qreal cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->leftMargin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_margin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.margin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // margin()const
            qreal cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->margin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_padding(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.padding";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // padding()const
            qreal cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->padding();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_pageBreakPolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.pageBreakPolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pageBreakPolicy()const
            QFlags<QTextFormat::PageBreakFlag> cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->pageBreakPolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_position(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.position";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // position()const
            QTextFrameFormat::Position cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->position();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_rightMargin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.rightMargin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rightMargin()const
            qreal cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->rightMargin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_setBorder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setBorder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setBorder(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBorder(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setBorder_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBorder(qreal)
            cppSelf->setBorder(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setBorder_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_setBorderBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setBorderBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setBorderBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setBorderBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setBorderBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBorderBrush(QBrush)
            cppSelf->setBorderBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setBorderBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_setBorderStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setBorderStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setBorderStyle(QTextFrameFormat::BorderStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setBorderStyle(QTextFrameFormat::BorderStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setBorderStyle_TypeError;

    // Call function/method
    {
        ::QTextFrameFormat::BorderStyle cppArg0{QTextFrameFormat::BorderStyle_None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBorderStyle(QTextFrameFormat::BorderStyle)
            cppSelf->setBorderStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setBorderStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_setBottomMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setBottomMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setBottomMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBottomMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setBottomMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBottomMargin(qreal)
            cppSelf->setBottomMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setBottomMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_setHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setHeight(QTextLength)
    // 1: QTextFrameFormat::setHeight(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 1; // setHeight(qreal)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLENGTH_IDX]), (pyArg)))) {
        overloadId = 0; // setHeight(QTextLength)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setHeight_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setHeight(const QTextLength & height)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QTextLength cppArg0_local;
            ::QTextLength *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLENGTH_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setHeight(QTextLength)
                cppSelf->setHeight(*cppArg0);
            }
            break;
        }
        case 1: // setHeight(qreal height)
        {
            qreal cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setHeight(qreal)
                cppSelf->setHeight(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_setLeftMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setLeftMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setLeftMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setLeftMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setLeftMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLeftMargin(qreal)
            cppSelf->setLeftMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setLeftMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_setMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMargin(qreal)
            cppSelf->setMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_setPadding(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setPadding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setPadding(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setPadding(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setPadding_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPadding(qreal)
            cppSelf->setPadding(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setPadding_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_setPageBreakPolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setPageBreakPolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setPageBreakPolicy(QFlags<QTextFormat::PageBreakFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPageBreakPolicy(QFlags<QTextFormat::PageBreakFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setPageBreakPolicy_TypeError;

    // Call function/method
    {
        ::QFlags<QTextFormat::PageBreakFlag> cppArg0 = QFlags<QTextFormat::PageBreakFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPageBreakPolicy(QFlags<QTextFormat::PageBreakFlag>)
            cppSelf->setPageBreakPolicy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setPageBreakPolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_setPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setPosition(QTextFrameFormat::Position)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPosition(QTextFrameFormat::Position)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setPosition_TypeError;

    // Call function/method
    {
        ::QTextFrameFormat::Position cppArg0{QTextFrameFormat::InFlow};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPosition(QTextFrameFormat::Position)
            cppSelf->setPosition(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_setRightMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setRightMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setRightMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setRightMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setRightMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRightMargin(qreal)
            cppSelf->setRightMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setRightMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_setTopMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setTopMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setTopMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setTopMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setTopMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTopMargin(qreal)
            cppSelf->setTopMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setTopMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_setWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.setWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFrameFormat::setWidth(QTextLength)
    // 1: QTextFrameFormat::setWidth(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 1; // setWidth(qreal)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLENGTH_IDX]), (pyArg)))) {
        overloadId = 0; // setWidth(QTextLength)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFrameFormatFunc_setWidth_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setWidth(const QTextLength & length)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QTextLength cppArg0_local;
            ::QTextLength *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLENGTH_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setWidth(QTextLength)
                cppSelf->setWidth(*cppArg0);
            }
            break;
        }
        case 1: // setWidth(qreal width)
        {
            qreal cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setWidth(qreal)
                cppSelf->setWidth(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFrameFormatFunc_setWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFrameFormatFunc_topMargin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.topMargin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // topMargin()const
            qreal cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->topMargin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormatFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFrameFormat.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            QTextLength cppResult = const_cast<const ::QTextFrameFormat *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLENGTH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFrameFormat___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextFrameFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextFrameFormat_methods[] = {
    {"border", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_border), METH_NOARGS},
    {"borderBrush", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_borderBrush), METH_NOARGS},
    {"borderStyle", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_borderStyle), METH_NOARGS},
    {"bottomMargin", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_bottomMargin), METH_NOARGS},
    {"height", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_height), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_isValid), METH_NOARGS},
    {"leftMargin", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_leftMargin), METH_NOARGS},
    {"margin", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_margin), METH_NOARGS},
    {"padding", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_padding), METH_NOARGS},
    {"pageBreakPolicy", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_pageBreakPolicy), METH_NOARGS},
    {"position", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_position), METH_NOARGS},
    {"rightMargin", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_rightMargin), METH_NOARGS},
    {"setBorder", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setBorder), METH_O},
    {"setBorderBrush", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setBorderBrush), METH_O},
    {"setBorderStyle", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setBorderStyle), METH_O},
    {"setBottomMargin", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setBottomMargin), METH_O},
    {"setHeight", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setHeight), METH_O},
    {"setLeftMargin", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setLeftMargin), METH_O},
    {"setMargin", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setMargin), METH_O},
    {"setPadding", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setPadding), METH_O},
    {"setPageBreakPolicy", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setPageBreakPolicy), METH_O},
    {"setPosition", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setPosition), METH_O},
    {"setRightMargin", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setRightMargin), METH_O},
    {"setTopMargin", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setTopMargin), METH_O},
    {"setWidth", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_setWidth), METH_O},
    {"topMargin", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_topMargin), METH_NOARGS},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormatFunc_width), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextFrameFormat___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextFrameFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextFrameFormat_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextFrameFormat_Type = nullptr;
static SbkObjectType *Sbk_QTextFrameFormat_TypeF(void)
{
    return _Sbk_QTextFrameFormat_Type;
}

static PyType_Slot Sbk_QTextFrameFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextFrameFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextFrameFormat_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextFrameFormat_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextFrameFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextFrameFormat_spec = {
    "2:PySide2.QtGui.QTextFrameFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextFrameFormat_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QTextFrameFormat_Position_PythonToCpp_QTextFrameFormat_Position(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextFrameFormat::Position *>(cppOut) =
        static_cast<::QTextFrameFormat::Position>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextFrameFormat_Position_PythonToCpp_QTextFrameFormat_Position_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX]))
        return QTextFrameFormat_Position_PythonToCpp_QTextFrameFormat_Position;
    return {};
}
static PyObject *QTextFrameFormat_Position_CppToPython_QTextFrameFormat_Position(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextFrameFormat::Position *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX], castCppIn);

}

static void QTextFrameFormat_BorderStyle_PythonToCpp_QTextFrameFormat_BorderStyle(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextFrameFormat::BorderStyle *>(cppOut) =
        static_cast<::QTextFrameFormat::BorderStyle>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextFrameFormat_BorderStyle_PythonToCpp_QTextFrameFormat_BorderStyle_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX]))
        return QTextFrameFormat_BorderStyle_PythonToCpp_QTextFrameFormat_BorderStyle;
    return {};
}
static PyObject *QTextFrameFormat_BorderStyle_CppToPython_QTextFrameFormat_BorderStyle(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextFrameFormat::BorderStyle *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextFrameFormat_PythonToCpp_QTextFrameFormat_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextFrameFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextFrameFormat_PythonToCpp_QTextFrameFormat_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextFrameFormat_TypeF())))
        return QTextFrameFormat_PythonToCpp_QTextFrameFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextFrameFormat_PTR_CppToPython_QTextFrameFormat(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextFrameFormat *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextFrameFormat_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTextFrameFormat_COPY_CppToPython_QTextFrameFormat(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextFrameFormat_TypeF(), new ::QTextFrameFormat(*reinterpret_cast<const ::QTextFrameFormat *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTextFrameFormat_PythonToCpp_QTextFrameFormat_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextFrameFormat *>(cppOut) = *reinterpret_cast< ::QTextFrameFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTextFrameFormat_PythonToCpp_QTextFrameFormat_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextFrameFormat_TypeF())))
        return QTextFrameFormat_PythonToCpp_QTextFrameFormat_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextFrameFormat_SignatureStrings[] = {
    "2:PySide2.QtGui.QTextFrameFormat(self)",
    "1:PySide2.QtGui.QTextFrameFormat(self,fmt:PySide2.QtGui.QTextFormat)",
    "0:PySide2.QtGui.QTextFrameFormat(self,QTextFrameFormat:PySide2.QtGui.QTextFrameFormat)",
    "PySide2.QtGui.QTextFrameFormat.border(self)->qreal",
    "PySide2.QtGui.QTextFrameFormat.borderBrush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QTextFrameFormat.borderStyle(self)->PySide2.QtGui.QTextFrameFormat.BorderStyle",
    "PySide2.QtGui.QTextFrameFormat.bottomMargin(self)->qreal",
    "PySide2.QtGui.QTextFrameFormat.height(self)->PySide2.QtGui.QTextLength",
    "PySide2.QtGui.QTextFrameFormat.isValid(self)->bool",
    "PySide2.QtGui.QTextFrameFormat.leftMargin(self)->qreal",
    "PySide2.QtGui.QTextFrameFormat.margin(self)->qreal",
    "PySide2.QtGui.QTextFrameFormat.padding(self)->qreal",
    "PySide2.QtGui.QTextFrameFormat.pageBreakPolicy(self)->PySide2.QtGui.QTextFormat.PageBreakFlags",
    "PySide2.QtGui.QTextFrameFormat.position(self)->PySide2.QtGui.QTextFrameFormat.Position",
    "PySide2.QtGui.QTextFrameFormat.rightMargin(self)->qreal",
    "PySide2.QtGui.QTextFrameFormat.setBorder(self,border:qreal)",
    "PySide2.QtGui.QTextFrameFormat.setBorderBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtGui.QTextFrameFormat.setBorderStyle(self,style:PySide2.QtGui.QTextFrameFormat.BorderStyle)",
    "PySide2.QtGui.QTextFrameFormat.setBottomMargin(self,margin:qreal)",
    "1:PySide2.QtGui.QTextFrameFormat.setHeight(self,height:PySide2.QtGui.QTextLength)",
    "0:PySide2.QtGui.QTextFrameFormat.setHeight(self,height:qreal)",
    "PySide2.QtGui.QTextFrameFormat.setLeftMargin(self,margin:qreal)",
    "PySide2.QtGui.QTextFrameFormat.setMargin(self,margin:qreal)",
    "PySide2.QtGui.QTextFrameFormat.setPadding(self,padding:qreal)",
    "PySide2.QtGui.QTextFrameFormat.setPageBreakPolicy(self,flags:PySide2.QtGui.QTextFormat.PageBreakFlags)",
    "PySide2.QtGui.QTextFrameFormat.setPosition(self,f:PySide2.QtGui.QTextFrameFormat.Position)",
    "PySide2.QtGui.QTextFrameFormat.setRightMargin(self,margin:qreal)",
    "PySide2.QtGui.QTextFrameFormat.setTopMargin(self,margin:qreal)",
    "1:PySide2.QtGui.QTextFrameFormat.setWidth(self,length:PySide2.QtGui.QTextLength)",
    "0:PySide2.QtGui.QTextFrameFormat.setWidth(self,width:qreal)",
    "PySide2.QtGui.QTextFrameFormat.topMargin(self)->qreal",
    "PySide2.QtGui.QTextFrameFormat.width(self)->PySide2.QtGui.QTextLength",
    "PySide2.QtGui.QTextFrameFormat.__copy__()",
    nullptr}; // Sentinel

void init_QTextFrameFormat(PyObject *module)
{
    _Sbk_QTextFrameFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextFrameFormat",
        "QTextFrameFormat",
        &Sbk_QTextFrameFormat_spec,
        &Shiboken::callCppDestructor< ::QTextFrameFormat >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextFrameFormat_Type);
    InitSignatureStrings(pyType, QTextFrameFormat_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextFrameFormat_Type), Sbk_QTextFrameFormat_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextFrameFormat_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextFrameFormat_TypeF(),
        QTextFrameFormat_PythonToCpp_QTextFrameFormat_PTR,
        is_QTextFrameFormat_PythonToCpp_QTextFrameFormat_PTR_Convertible,
        QTextFrameFormat_PTR_CppToPython_QTextFrameFormat,
        QTextFrameFormat_COPY_CppToPython_QTextFrameFormat);

    Shiboken::Conversions::registerConverterName(converter, "QTextFrameFormat");
    Shiboken::Conversions::registerConverterName(converter, "QTextFrameFormat*");
    Shiboken::Conversions::registerConverterName(converter, "QTextFrameFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextFrameFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTextFrameFormat_PythonToCpp_QTextFrameFormat_COPY,
        is_QTextFrameFormat_PythonToCpp_QTextFrameFormat_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Position'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextFrameFormat_TypeF(),
        "Position",
        "2:PySide2.QtGui.QTextFrameFormat.Position",
        "QTextFrameFormat::Position");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX],
        Sbk_QTextFrameFormat_TypeF(), "InFlow", (long) QTextFrameFormat::Position::InFlow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX],
        Sbk_QTextFrameFormat_TypeF(), "FloatLeft", (long) QTextFrameFormat::Position::FloatLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX],
        Sbk_QTextFrameFormat_TypeF(), "FloatRight", (long) QTextFrameFormat::Position::FloatRight))
        return;
    // Register converter for enum 'QTextFrameFormat::Position'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX],
            QTextFrameFormat_Position_CppToPython_QTextFrameFormat_Position);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextFrameFormat_Position_PythonToCpp_QTextFrameFormat_Position,
            is_QTextFrameFormat_Position_PythonToCpp_QTextFrameFormat_Position_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextFrameFormat::Position");
        Shiboken::Conversions::registerConverterName(converter, "Position");
    }
    // End of 'Position' enum.

    // Initialization of enum 'BorderStyle'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextFrameFormat_TypeF(),
        "BorderStyle",
        "2:PySide2.QtGui.QTextFrameFormat.BorderStyle",
        "QTextFrameFormat::BorderStyle");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX],
        Sbk_QTextFrameFormat_TypeF(), "BorderStyle_None", (long) QTextFrameFormat::BorderStyle::BorderStyle_None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX],
        Sbk_QTextFrameFormat_TypeF(), "BorderStyle_Dotted", (long) QTextFrameFormat::BorderStyle::BorderStyle_Dotted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX],
        Sbk_QTextFrameFormat_TypeF(), "BorderStyle_Dashed", (long) QTextFrameFormat::BorderStyle::BorderStyle_Dashed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX],
        Sbk_QTextFrameFormat_TypeF(), "BorderStyle_Solid", (long) QTextFrameFormat::BorderStyle::BorderStyle_Solid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX],
        Sbk_QTextFrameFormat_TypeF(), "BorderStyle_Double", (long) QTextFrameFormat::BorderStyle::BorderStyle_Double))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX],
        Sbk_QTextFrameFormat_TypeF(), "BorderStyle_DotDash", (long) QTextFrameFormat::BorderStyle::BorderStyle_DotDash))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX],
        Sbk_QTextFrameFormat_TypeF(), "BorderStyle_DotDotDash", (long) QTextFrameFormat::BorderStyle::BorderStyle_DotDotDash))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX],
        Sbk_QTextFrameFormat_TypeF(), "BorderStyle_Groove", (long) QTextFrameFormat::BorderStyle::BorderStyle_Groove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX],
        Sbk_QTextFrameFormat_TypeF(), "BorderStyle_Ridge", (long) QTextFrameFormat::BorderStyle::BorderStyle_Ridge))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX],
        Sbk_QTextFrameFormat_TypeF(), "BorderStyle_Inset", (long) QTextFrameFormat::BorderStyle::BorderStyle_Inset))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX],
        Sbk_QTextFrameFormat_TypeF(), "BorderStyle_Outset", (long) QTextFrameFormat::BorderStyle::BorderStyle_Outset))
        return;
    // Register converter for enum 'QTextFrameFormat::BorderStyle'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX],
            QTextFrameFormat_BorderStyle_CppToPython_QTextFrameFormat_BorderStyle);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextFrameFormat_BorderStyle_PythonToCpp_QTextFrameFormat_BorderStyle,
            is_QTextFrameFormat_BorderStyle_PythonToCpp_QTextFrameFormat_BorderStyle_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextFrameFormat::BorderStyle");
        Shiboken::Conversions::registerConverterName(converter, "BorderStyle");
    }
    // End of 'BorderStyle' enum.

    qRegisterMetaType< ::QTextFrameFormat >("QTextFrameFormat");
    qRegisterMetaType< ::QTextFrameFormat::Position >("QTextFrameFormat::Position");
    qRegisterMetaType< ::QTextFrameFormat::BorderStyle >("QTextFrameFormat::BorderStyle");
}
