/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextlistformat_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QVector>
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <QtGui/qpen.h>
#include <QtGui/qtextformat.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextListFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextListFormat >()))
        return -1;

    ::QTextListFormat *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextListFormat.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QTextListFormat", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTextListFormat::QTextListFormat()
    // 1: QTextListFormat::QTextListFormat(QTextFormat)
    // 2: QTextListFormat::QTextListFormat(QTextListFormat)
    if (numArgs == 0) {
        overloadId = 0; // QTextListFormat()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QTextListFormat(QTextListFormat)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QTextListFormat(QTextFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextListFormat_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextListFormat()
        {

            if (!PyErr_Occurred()) {
                // QTextListFormat()
                cptr = new ::QTextListFormat();
            }
            break;
        }
        case 1: // QTextListFormat(const QTextFormat & fmt)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextFormat cppArg0_local;
            ::QTextFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextListFormat(QTextFormat)
                cptr = new ::QTextListFormat(*cppArg0);
            }
            break;
        }
        case 2: // QTextListFormat(const QTextListFormat & QTextListFormat)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextListFormat cppArg0_local;
            ::QTextListFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextListFormat(QTextListFormat)
                cptr = new ::QTextListFormat(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextListFormat >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextListFormat_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextListFormat_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextListFormatFunc_indent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextListFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextListFormat.indent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // indent()const
            int cppResult = const_cast<const ::QTextListFormat *>(cppSelf)->indent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextListFormatFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextListFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextListFormat.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QTextListFormat *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextListFormatFunc_numberPrefix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextListFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextListFormat.numberPrefix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // numberPrefix()const
            QString cppResult = const_cast<const ::QTextListFormat *>(cppSelf)->numberPrefix();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextListFormatFunc_numberSuffix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextListFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextListFormat.numberSuffix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // numberSuffix()const
            QString cppResult = const_cast<const ::QTextListFormat *>(cppSelf)->numberSuffix();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextListFormatFunc_setIndent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextListFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextListFormat.setIndent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextListFormat::setIndent(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setIndent(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextListFormatFunc_setIndent_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setIndent(int)
            cppSelf->setIndent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextListFormatFunc_setIndent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextListFormatFunc_setNumberPrefix(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextListFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextListFormat.setNumberPrefix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextListFormat::setNumberPrefix(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setNumberPrefix(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextListFormatFunc_setNumberPrefix_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNumberPrefix(QString)
            cppSelf->setNumberPrefix(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextListFormatFunc_setNumberPrefix_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextListFormatFunc_setNumberSuffix(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextListFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextListFormat.setNumberSuffix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextListFormat::setNumberSuffix(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setNumberSuffix(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextListFormatFunc_setNumberSuffix_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNumberSuffix(QString)
            cppSelf->setNumberSuffix(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextListFormatFunc_setNumberSuffix_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextListFormatFunc_setStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextListFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextListFormat.setStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextListFormat::setStyle(QTextListFormat::Style)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStyle(QTextListFormat::Style)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextListFormatFunc_setStyle_TypeError;

    // Call function/method
    {
        ::QTextListFormat::Style cppArg0{QTextListFormat::ListStyleUndefined};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStyle(QTextListFormat::Style)
            cppSelf->setStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextListFormatFunc_setStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextListFormatFunc_style(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextListFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextListFormat.style";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // style()const
            QTextListFormat::Style cppResult = const_cast<const ::QTextListFormat *>(cppSelf)->style();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextListFormat___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextListFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextListFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextListFormat_methods[] = {
    {"indent", reinterpret_cast<PyCFunction>(Sbk_QTextListFormatFunc_indent), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QTextListFormatFunc_isValid), METH_NOARGS},
    {"numberPrefix", reinterpret_cast<PyCFunction>(Sbk_QTextListFormatFunc_numberPrefix), METH_NOARGS},
    {"numberSuffix", reinterpret_cast<PyCFunction>(Sbk_QTextListFormatFunc_numberSuffix), METH_NOARGS},
    {"setIndent", reinterpret_cast<PyCFunction>(Sbk_QTextListFormatFunc_setIndent), METH_O},
    {"setNumberPrefix", reinterpret_cast<PyCFunction>(Sbk_QTextListFormatFunc_setNumberPrefix), METH_O},
    {"setNumberSuffix", reinterpret_cast<PyCFunction>(Sbk_QTextListFormatFunc_setNumberSuffix), METH_O},
    {"setStyle", reinterpret_cast<PyCFunction>(Sbk_QTextListFormatFunc_setStyle), METH_O},
    {"style", reinterpret_cast<PyCFunction>(Sbk_QTextListFormatFunc_style), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextListFormat___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextListFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextListFormat_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextListFormat_Type = nullptr;
static SbkObjectType *Sbk_QTextListFormat_TypeF(void)
{
    return _Sbk_QTextListFormat_Type;
}

static PyType_Slot Sbk_QTextListFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextListFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextListFormat_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextListFormat_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextListFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextListFormat_spec = {
    "2:PySide2.QtGui.QTextListFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextListFormat_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QTextListFormat_Style_PythonToCpp_QTextListFormat_Style(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextListFormat::Style *>(cppOut) =
        static_cast<::QTextListFormat::Style>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextListFormat_Style_PythonToCpp_QTextListFormat_Style_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX]))
        return QTextListFormat_Style_PythonToCpp_QTextListFormat_Style;
    return {};
}
static PyObject *QTextListFormat_Style_CppToPython_QTextListFormat_Style(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextListFormat::Style *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextListFormat_PythonToCpp_QTextListFormat_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextListFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextListFormat_PythonToCpp_QTextListFormat_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextListFormat_TypeF())))
        return QTextListFormat_PythonToCpp_QTextListFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextListFormat_PTR_CppToPython_QTextListFormat(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextListFormat *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextListFormat_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTextListFormat_COPY_CppToPython_QTextListFormat(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextListFormat_TypeF(), new ::QTextListFormat(*reinterpret_cast<const ::QTextListFormat *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTextListFormat_PythonToCpp_QTextListFormat_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextListFormat *>(cppOut) = *reinterpret_cast< ::QTextListFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTextListFormat_PythonToCpp_QTextListFormat_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextListFormat_TypeF())))
        return QTextListFormat_PythonToCpp_QTextListFormat_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextListFormat_SignatureStrings[] = {
    "2:PySide2.QtGui.QTextListFormat(self)",
    "1:PySide2.QtGui.QTextListFormat(self,fmt:PySide2.QtGui.QTextFormat)",
    "0:PySide2.QtGui.QTextListFormat(self,QTextListFormat:PySide2.QtGui.QTextListFormat)",
    "PySide2.QtGui.QTextListFormat.indent(self)->int",
    "PySide2.QtGui.QTextListFormat.isValid(self)->bool",
    "PySide2.QtGui.QTextListFormat.numberPrefix(self)->QString",
    "PySide2.QtGui.QTextListFormat.numberSuffix(self)->QString",
    "PySide2.QtGui.QTextListFormat.setIndent(self,indent:int)",
    "PySide2.QtGui.QTextListFormat.setNumberPrefix(self,numberPrefix:QString)",
    "PySide2.QtGui.QTextListFormat.setNumberSuffix(self,numberSuffix:QString)",
    "PySide2.QtGui.QTextListFormat.setStyle(self,style:PySide2.QtGui.QTextListFormat.Style)",
    "PySide2.QtGui.QTextListFormat.style(self)->PySide2.QtGui.QTextListFormat.Style",
    "PySide2.QtGui.QTextListFormat.__copy__()",
    nullptr}; // Sentinel

void init_QTextListFormat(PyObject *module)
{
    _Sbk_QTextListFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextListFormat",
        "QTextListFormat",
        &Sbk_QTextListFormat_spec,
        &Shiboken::callCppDestructor< ::QTextListFormat >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextListFormat_Type);
    InitSignatureStrings(pyType, QTextListFormat_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextListFormat_Type), Sbk_QTextListFormat_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextListFormat_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextListFormat_TypeF(),
        QTextListFormat_PythonToCpp_QTextListFormat_PTR,
        is_QTextListFormat_PythonToCpp_QTextListFormat_PTR_Convertible,
        QTextListFormat_PTR_CppToPython_QTextListFormat,
        QTextListFormat_COPY_CppToPython_QTextListFormat);

    Shiboken::Conversions::registerConverterName(converter, "QTextListFormat");
    Shiboken::Conversions::registerConverterName(converter, "QTextListFormat*");
    Shiboken::Conversions::registerConverterName(converter, "QTextListFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextListFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTextListFormat_PythonToCpp_QTextListFormat_COPY,
        is_QTextListFormat_PythonToCpp_QTextListFormat_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Style'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextListFormat_TypeF(),
        "Style",
        "2:PySide2.QtGui.QTextListFormat.Style",
        "QTextListFormat::Style");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX],
        Sbk_QTextListFormat_TypeF(), "ListDisc", (long) QTextListFormat::Style::ListDisc))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX],
        Sbk_QTextListFormat_TypeF(), "ListCircle", (long) QTextListFormat::Style::ListCircle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX],
        Sbk_QTextListFormat_TypeF(), "ListSquare", (long) QTextListFormat::Style::ListSquare))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX],
        Sbk_QTextListFormat_TypeF(), "ListDecimal", (long) QTextListFormat::Style::ListDecimal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX],
        Sbk_QTextListFormat_TypeF(), "ListLowerAlpha", (long) QTextListFormat::Style::ListLowerAlpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX],
        Sbk_QTextListFormat_TypeF(), "ListUpperAlpha", (long) QTextListFormat::Style::ListUpperAlpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX],
        Sbk_QTextListFormat_TypeF(), "ListLowerRoman", (long) QTextListFormat::Style::ListLowerRoman))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX],
        Sbk_QTextListFormat_TypeF(), "ListUpperRoman", (long) QTextListFormat::Style::ListUpperRoman))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX],
        Sbk_QTextListFormat_TypeF(), "ListStyleUndefined", (long) QTextListFormat::Style::ListStyleUndefined))
        return;
    // Register converter for enum 'QTextListFormat::Style'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX],
            QTextListFormat_Style_CppToPython_QTextListFormat_Style);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextListFormat_Style_PythonToCpp_QTextListFormat_Style,
            is_QTextListFormat_Style_PythonToCpp_QTextListFormat_Style_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextListFormat::Style");
        Shiboken::Conversions::registerConverterName(converter, "Style");
    }
    // End of 'Style' enum.

    qRegisterMetaType< ::QTextListFormat >("QTextListFormat");
    qRegisterMetaType< ::QTextListFormat::Style >("QTextListFormat::Style");
}
