/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextoption_wrapper.h"

// inner classes
#include "qtextoption_tab_wrapper.h"

// Extra includes
#include <QList>
#include <QtGui/qtextoption.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextOption_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextOption >()))
        return -1;

    ::QTextOption *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QTextOption", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTextOption::QTextOption()
    // 1: QTextOption::QTextOption(QFlags<Qt::AlignmentFlag>)
    // 2: QTextOption::QTextOption(QTextOption)
    if (numArgs == 0) {
        overloadId = 0; // QTextOption()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QTextOption(QFlags<Qt::AlignmentFlag>)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QTextOption(QTextOption)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextOption_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextOption()
        {

            if (!PyErr_Occurred()) {
                // QTextOption()
                cptr = new ::QTextOption();
            }
            break;
        }
        case 1: // QTextOption(QFlags<Qt::AlignmentFlag> alignment)
        {
            ::QFlags<Qt::AlignmentFlag> cppArg0 = QFlags<Qt::AlignmentFlag>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QTextOption(QFlags<Qt::AlignmentFlag>)
                cptr = new ::QTextOption(cppArg0);
            }
            break;
        }
        case 2: // QTextOption(const QTextOption & o)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextOption cppArg0_local;
            ::QTextOption *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextOption(QTextOption)
                cptr = new ::QTextOption(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextOption >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextOption_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextOption_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextOptionFunc_alignment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.alignment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alignment()const
            QFlags<Qt::AlignmentFlag> cppResult = const_cast<const ::QTextOption *>(cppSelf)->alignment();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextOptionFunc_flags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.flags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flags()const
            QFlags<QTextOption::Flag> cppResult = const_cast<const ::QTextOption *>(cppSelf)->flags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextOptionFunc_setAlignment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.setAlignment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextOption::setAlignment(QFlags<Qt::AlignmentFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAlignment(QFlags<Qt::AlignmentFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextOptionFunc_setAlignment_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::AlignmentFlag> cppArg0 = QFlags<Qt::AlignmentFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlignment(QFlags<Qt::AlignmentFlag>)
            cppSelf->setAlignment(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextOptionFunc_setAlignment_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextOptionFunc_setFlags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.setFlags";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextOption::setFlags(QFlags<QTextOption::Flag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFlags(QFlags<QTextOption::Flag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextOptionFunc_setFlags_TypeError;

    // Call function/method
    {
        ::QFlags<QTextOption::Flag> cppArg0 = QFlags<QTextOption::Flag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFlags(QFlags<QTextOption::Flag>)
            cppSelf->setFlags(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextOptionFunc_setFlags_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextOptionFunc_setTabArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.setTabArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextOption::setTabArray(QList<qreal>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QREAL_IDX], (pyArg)))) {
        overloadId = 0; // setTabArray(QList<qreal>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextOptionFunc_setTabArray_TypeError;

    // Call function/method
    {
        ::QList<qreal > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTabArray(QList<qreal>)
            cppSelf->setTabArray(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextOptionFunc_setTabArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextOptionFunc_setTabStop(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.setTabStop";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextOption::setTabStop(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setTabStop(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextOptionFunc_setTabStop_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTabStop(qreal)
            cppSelf->setTabStop(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextOptionFunc_setTabStop_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextOptionFunc_setTabStopDistance(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.setTabStopDistance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextOption::setTabStopDistance(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setTabStopDistance(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextOptionFunc_setTabStopDistance_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTabStopDistance(qreal)
            cppSelf->setTabStopDistance(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextOptionFunc_setTabStopDistance_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextOptionFunc_setTabs(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.setTabs";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextOption::setTabs(QList<QTextOption::Tab>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTOPTION_TAB_IDX], (pyArg)))) {
        overloadId = 0; // setTabs(QList<QTextOption::Tab>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextOptionFunc_setTabs_TypeError;

    // Call function/method
    {
        ::QList<QTextOption::Tab > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTabs(QList<QTextOption::Tab>)
            cppSelf->setTabs(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextOptionFunc_setTabs_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextOptionFunc_setTextDirection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.setTextDirection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextOption::setTextDirection(Qt::LayoutDirection)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTextDirection(Qt::LayoutDirection)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextOptionFunc_setTextDirection_TypeError;

    // Call function/method
    {
        ::Qt::LayoutDirection cppArg0{Qt::LeftToRight};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextDirection(Qt::LayoutDirection)
            cppSelf->setTextDirection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextOptionFunc_setTextDirection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextOptionFunc_setUseDesignMetrics(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.setUseDesignMetrics";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextOption::setUseDesignMetrics(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setUseDesignMetrics(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextOptionFunc_setUseDesignMetrics_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUseDesignMetrics(bool)
            cppSelf->setUseDesignMetrics(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextOptionFunc_setUseDesignMetrics_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextOptionFunc_setWrapMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.setWrapMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextOption::setWrapMode(QTextOption::WrapMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setWrapMode(QTextOption::WrapMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextOptionFunc_setWrapMode_TypeError;

    // Call function/method
    {
        ::QTextOption::WrapMode cppArg0{QTextOption::NoWrap};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWrapMode(QTextOption::WrapMode)
            cppSelf->setWrapMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextOptionFunc_setWrapMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextOptionFunc_tabArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.tabArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tabArray()const
            QList<qreal > cppResult = const_cast<const ::QTextOption *>(cppSelf)->tabArray();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QREAL_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextOptionFunc_tabStop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.tabStop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tabStop()const
            qreal cppResult = const_cast<const ::QTextOption *>(cppSelf)->tabStop();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextOptionFunc_tabStopDistance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.tabStopDistance";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tabStopDistance()const
            qreal cppResult = const_cast<const ::QTextOption *>(cppSelf)->tabStopDistance();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextOptionFunc_tabs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.tabs";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tabs()const
            QList<QTextOption::Tab > cppResult = const_cast<const ::QTextOption *>(cppSelf)->tabs();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTOPTION_TAB_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextOptionFunc_textDirection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.textDirection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textDirection()const
            Qt::LayoutDirection cppResult = const_cast<const ::QTextOption *>(cppSelf)->textDirection();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextOptionFunc_useDesignMetrics(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.useDesignMetrics";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // useDesignMetrics()const
            bool cppResult = const_cast<const ::QTextOption *>(cppSelf)->useDesignMetrics();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextOptionFunc_wrapMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.wrapMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wrapMode()const
            QTextOption::WrapMode cppResult = const_cast<const ::QTextOption *>(cppSelf)->wrapMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextOption___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextOption_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextOption_methods[] = {
    {"alignment", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_alignment), METH_NOARGS},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_flags), METH_NOARGS},
    {"setAlignment", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_setAlignment), METH_O},
    {"setFlags", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_setFlags), METH_O},
    {"setTabArray", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_setTabArray), METH_O},
    {"setTabStop", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_setTabStop), METH_O},
    {"setTabStopDistance", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_setTabStopDistance), METH_O},
    {"setTabs", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_setTabs), METH_O},
    {"setTextDirection", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_setTextDirection), METH_O},
    {"setUseDesignMetrics", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_setUseDesignMetrics), METH_O},
    {"setWrapMode", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_setWrapMode), METH_O},
    {"tabArray", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_tabArray), METH_NOARGS},
    {"tabStop", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_tabStop), METH_NOARGS},
    {"tabStopDistance", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_tabStopDistance), METH_NOARGS},
    {"tabs", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_tabs), METH_NOARGS},
    {"textDirection", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_textDirection), METH_NOARGS},
    {"useDesignMetrics", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_useDesignMetrics), METH_NOARGS},
    {"wrapMode", reinterpret_cast<PyCFunction>(Sbk_QTextOptionFunc_wrapMode), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextOption___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextOption_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextOption_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextOption_Type = nullptr;
static SbkObjectType *Sbk_QTextOption_TypeF(void)
{
    return _Sbk_QTextOption_Type;
}

static PyType_Slot Sbk_QTextOption_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextOption_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextOption_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextOption_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextOption_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextOption_spec = {
    "2:PySide2.QtGui.QTextOption",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextOption_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QTextOption_Flag___and__(PyObject *self, PyObject *pyArg)
{
    ::QTextOption::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextOption::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextOption::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextOption::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextOption::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextOption_Flag___or__(PyObject *self, PyObject *pyArg)
{
    ::QTextOption::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextOption::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextOption::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextOption::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextOption::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextOption_Flag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QTextOption::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextOption::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextOption::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextOption::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextOption::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextOption_Flag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QTextOption::Flags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX])->converter, self, &cppSelf);
    ::QTextOption::Flags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QTextOption_Flag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QTextOption_Flag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QTextOption_Flag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextOption_Flag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QTextOption_Flag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextOption_Flag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QTextOption_Flag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextOption_Flag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextOption_Flag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QTextOption_Flag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextOption_Flag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QTextOption_Flag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextOption_Flag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QTextOption_TabType_PythonToCpp_QTextOption_TabType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextOption::TabType *>(cppOut) =
        static_cast<::QTextOption::TabType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextOption_TabType_PythonToCpp_QTextOption_TabType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX]))
        return QTextOption_TabType_PythonToCpp_QTextOption_TabType;
    return {};
}
static PyObject *QTextOption_TabType_CppToPython_QTextOption_TabType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextOption::TabType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX], castCppIn);

}

static void QTextOption_WrapMode_PythonToCpp_QTextOption_WrapMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextOption::WrapMode *>(cppOut) =
        static_cast<::QTextOption::WrapMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextOption_WrapMode_PythonToCpp_QTextOption_WrapMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX]))
        return QTextOption_WrapMode_PythonToCpp_QTextOption_WrapMode;
    return {};
}
static PyObject *QTextOption_WrapMode_CppToPython_QTextOption_WrapMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextOption::WrapMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX], castCppIn);

}

static void QTextOption_Flag_PythonToCpp_QTextOption_Flag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextOption::Flag *>(cppOut) =
        static_cast<::QTextOption::Flag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextOption_Flag_PythonToCpp_QTextOption_Flag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX]))
        return QTextOption_Flag_PythonToCpp_QTextOption_Flag;
    return {};
}
static PyObject *QTextOption_Flag_CppToPython_QTextOption_Flag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextOption::Flag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX], castCppIn);

}

static void QFlags_QTextOption_Flag__PythonToCpp_QFlags_QTextOption_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextOption::Flag> *>(cppOut) =
        ::QFlags<QTextOption::Flag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QTextOption_Flag__PythonToCpp_QFlags_QTextOption_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX]))
        return QFlags_QTextOption_Flag__PythonToCpp_QFlags_QTextOption_Flag_;
    return {};
}
static PyObject *QFlags_QTextOption_Flag__CppToPython_QFlags_QTextOption_Flag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QTextOption::Flag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX]));

}

static void QTextOption_Flag_PythonToCpp_QFlags_QTextOption_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextOption::Flag> *>(cppOut) =
        ::QFlags<QTextOption::Flag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QTextOption_Flag_PythonToCpp_QFlags_QTextOption_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX]))
        return QTextOption_Flag_PythonToCpp_QFlags_QTextOption_Flag_;
    return {};
}
static void number_PythonToCpp_QFlags_QTextOption_Flag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QTextOption::Flag> *>(cppOut) =
        ::QFlags<QTextOption::Flag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QTextOption_Flag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX]))
        return number_PythonToCpp_QFlags_QTextOption_Flag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextOption_PythonToCpp_QTextOption_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextOption_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextOption_PythonToCpp_QTextOption_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextOption_TypeF())))
        return QTextOption_PythonToCpp_QTextOption_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextOption_PTR_CppToPython_QTextOption(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextOption *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextOption_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTextOption_COPY_CppToPython_QTextOption(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextOption_TypeF(), new ::QTextOption(*reinterpret_cast<const ::QTextOption *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTextOption_PythonToCpp_QTextOption_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextOption *>(cppOut) = *reinterpret_cast< ::QTextOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTextOption_PythonToCpp_QTextOption_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextOption_TypeF())))
        return QTextOption_PythonToCpp_QTextOption_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_QFlags_Qt_AlignmentFlag__PythonToCpp_QTextOption(PyObject *pyIn, void *cppOut) {
    ::QFlags<Qt::AlignmentFlag> cppIn = QFlags<Qt::AlignmentFlag>(0);
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QTextOption *>(cppOut) = ::QTextOption(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_QFlags_Qt_AlignmentFlag__PythonToCpp_QTextOption_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX], pyIn))
        return PySide2_QtCore_QFlags_Qt_AlignmentFlag__PythonToCpp_QTextOption;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextOption_SignatureStrings[] = {
    "2:PySide2.QtGui.QTextOption(self)",
    "1:PySide2.QtGui.QTextOption(self,alignment:PySide2.QtCore.Qt.Alignment)",
    "0:PySide2.QtGui.QTextOption(self,o:PySide2.QtGui.QTextOption)",
    "PySide2.QtGui.QTextOption.alignment(self)->PySide2.QtCore.Qt.Alignment",
    "PySide2.QtGui.QTextOption.flags(self)->PySide2.QtGui.QTextOption.Flags",
    "PySide2.QtGui.QTextOption.setAlignment(self,alignment:PySide2.QtCore.Qt.Alignment)",
    "PySide2.QtGui.QTextOption.setFlags(self,flags:PySide2.QtGui.QTextOption.Flags)",
    "PySide2.QtGui.QTextOption.setTabArray(self,tabStops:QList[qreal])",
    "PySide2.QtGui.QTextOption.setTabStop(self,tabStop:qreal)",
    "PySide2.QtGui.QTextOption.setTabStopDistance(self,tabStopDistance:qreal)",
    "PySide2.QtGui.QTextOption.setTabs(self,tabStops:QList[PySide2.QtGui.QTextOption.Tab])",
    "PySide2.QtGui.QTextOption.setTextDirection(self,aDirection:PySide2.QtCore.Qt.LayoutDirection)",
    "PySide2.QtGui.QTextOption.setUseDesignMetrics(self,b:bool)",
    "PySide2.QtGui.QTextOption.setWrapMode(self,wrap:PySide2.QtGui.QTextOption.WrapMode)",
    "PySide2.QtGui.QTextOption.tabArray(self)->QList[qreal]",
    "PySide2.QtGui.QTextOption.tabStop(self)->qreal",
    "PySide2.QtGui.QTextOption.tabStopDistance(self)->qreal",
    "PySide2.QtGui.QTextOption.tabs(self)->QList[PySide2.QtGui.QTextOption.Tab]",
    "PySide2.QtGui.QTextOption.textDirection(self)->PySide2.QtCore.Qt.LayoutDirection",
    "PySide2.QtGui.QTextOption.useDesignMetrics(self)->bool",
    "PySide2.QtGui.QTextOption.wrapMode(self)->PySide2.QtGui.QTextOption.WrapMode",
    "PySide2.QtGui.QTextOption.__copy__()",
    nullptr}; // Sentinel

void init_QTextOption(PyObject *module)
{
    _Sbk_QTextOption_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextOption",
        "QTextOption",
        &Sbk_QTextOption_spec,
        &Shiboken::callCppDestructor< ::QTextOption >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextOption_Type);
    InitSignatureStrings(pyType, QTextOption_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextOption_Type), Sbk_QTextOption_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextOption_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextOption_TypeF(),
        QTextOption_PythonToCpp_QTextOption_PTR,
        is_QTextOption_PythonToCpp_QTextOption_PTR_Convertible,
        QTextOption_PTR_CppToPython_QTextOption,
        QTextOption_COPY_CppToPython_QTextOption);

    Shiboken::Conversions::registerConverterName(converter, "QTextOption");
    Shiboken::Conversions::registerConverterName(converter, "QTextOption*");
    Shiboken::Conversions::registerConverterName(converter, "QTextOption&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextOption).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTextOption_PythonToCpp_QTextOption_COPY,
        is_QTextOption_PythonToCpp_QTextOption_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_QFlags_Qt_AlignmentFlag__PythonToCpp_QTextOption,
        is_PySide2_QtCore_QFlags_Qt_AlignmentFlag__PythonToCpp_QTextOption_Convertible);

    // Initialization of enums.

    // Initialization of enum 'TabType'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextOption_TypeF(),
        "TabType",
        "2:PySide2.QtGui.QTextOption.TabType",
        "QTextOption::TabType");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX],
        Sbk_QTextOption_TypeF(), "LeftTab", (long) QTextOption::TabType::LeftTab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX],
        Sbk_QTextOption_TypeF(), "RightTab", (long) QTextOption::TabType::RightTab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX],
        Sbk_QTextOption_TypeF(), "CenterTab", (long) QTextOption::TabType::CenterTab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX],
        Sbk_QTextOption_TypeF(), "DelimiterTab", (long) QTextOption::TabType::DelimiterTab))
        return;
    // Register converter for enum 'QTextOption::TabType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX],
            QTextOption_TabType_CppToPython_QTextOption_TabType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextOption_TabType_PythonToCpp_QTextOption_TabType,
            is_QTextOption_TabType_PythonToCpp_QTextOption_TabType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextOption::TabType");
        Shiboken::Conversions::registerConverterName(converter, "TabType");
    }
    // End of 'TabType' enum.

    // Initialization of enum 'WrapMode'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextOption_TypeF(),
        "WrapMode",
        "2:PySide2.QtGui.QTextOption.WrapMode",
        "QTextOption::WrapMode");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX],
        Sbk_QTextOption_TypeF(), "NoWrap", (long) QTextOption::WrapMode::NoWrap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX],
        Sbk_QTextOption_TypeF(), "WordWrap", (long) QTextOption::WrapMode::WordWrap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX],
        Sbk_QTextOption_TypeF(), "ManualWrap", (long) QTextOption::WrapMode::ManualWrap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX],
        Sbk_QTextOption_TypeF(), "WrapAnywhere", (long) QTextOption::WrapMode::WrapAnywhere))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX],
        Sbk_QTextOption_TypeF(), "WrapAtWordBoundaryOrAnywhere", (long) QTextOption::WrapMode::WrapAtWordBoundaryOrAnywhere))
        return;
    // Register converter for enum 'QTextOption::WrapMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX],
            QTextOption_WrapMode_CppToPython_QTextOption_WrapMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextOption_WrapMode_PythonToCpp_QTextOption_WrapMode,
            is_QTextOption_WrapMode_PythonToCpp_QTextOption_WrapMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_WRAPMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextOption::WrapMode");
        Shiboken::Conversions::registerConverterName(converter, "WrapMode");
    }
    // End of 'WrapMode' enum.

    // Initialization of enum 'Flag'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QTextOption.Flags", SbkPySide2_QtGui_QTextOption_Flag_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextOption_TypeF(),
        "Flag",
        "2:PySide2.QtGui.QTextOption.Flag",
        "QTextOption::Flag",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX],
        Sbk_QTextOption_TypeF(), "ShowTabsAndSpaces", (long) QTextOption::Flag::ShowTabsAndSpaces))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX],
        Sbk_QTextOption_TypeF(), "ShowLineAndParagraphSeparators", (long) QTextOption::Flag::ShowLineAndParagraphSeparators))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX],
        Sbk_QTextOption_TypeF(), "AddSpaceForLineAndParagraphSeparators", (long) QTextOption::Flag::AddSpaceForLineAndParagraphSeparators))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX],
        Sbk_QTextOption_TypeF(), "SuppressColors", (long) QTextOption::Flag::SuppressColors))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX],
        Sbk_QTextOption_TypeF(), "ShowDocumentTerminator", (long) QTextOption::Flag::ShowDocumentTerminator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX],
        Sbk_QTextOption_TypeF(), "IncludeTrailingSpaces", (long) QTextOption::Flag::IncludeTrailingSpaces))
        return;
    // Register converter for enum 'QTextOption::Flag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX],
            QTextOption_Flag_CppToPython_QTextOption_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextOption_Flag_PythonToCpp_QTextOption_Flag,
            is_QTextOption_Flag_PythonToCpp_QTextOption_Flag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextOption::Flag");
        Shiboken::Conversions::registerConverterName(converter, "Flag");
    }
    // Register converter for flag 'QFlags<QTextOption::Flag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX],
            QFlags_QTextOption_Flag__CppToPython_QFlags_QTextOption_Flag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextOption_Flag_PythonToCpp_QFlags_QTextOption_Flag_,
            is_QTextOption_Flag_PythonToCpp_QFlags_QTextOption_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QTextOption_Flag__PythonToCpp_QFlags_QTextOption_Flag_,
            is_QFlags_QTextOption_Flag__PythonToCpp_QFlags_QTextOption_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QTextOption_Flag_,
            is_number_PythonToCpp_QFlags_QTextOption_Flag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTOPTION_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextOption::Flags");
        Shiboken::Conversions::registerConverterName(converter, "Flags");
    }
    // End of 'Flag' enum/flags.

    qRegisterMetaType< ::QTextOption >("QTextOption");
    qRegisterMetaType< ::QTextOption::TabType >("QTextOption::TabType");
    qRegisterMetaType< ::QTextOption::WrapMode >("QTextOption::WrapMode");
    qRegisterMetaType< ::QTextOption::Flag >("QTextOption::Flag");
    qRegisterMetaType< ::QTextOption::Flags >("QTextOption::Flags");
}
